/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.bramp.ffmpeg.FFcommon;
import net.bramp.ffmpeg.ProcessFunction;
import net.bramp.ffmpeg.RunProcessFunction;
import net.bramp.ffmpeg.builder.FFmpegBuilder;
import net.bramp.ffmpeg.info.ChannelLayout;
import net.bramp.ffmpeg.info.Codec;
import net.bramp.ffmpeg.info.Filter;
import net.bramp.ffmpeg.info.FilterPattern;
import net.bramp.ffmpeg.info.Format;
import net.bramp.ffmpeg.info.InfoParser;
import net.bramp.ffmpeg.info.PixelFormat;
import net.bramp.ffmpeg.progress.ProgressListener;
import net.bramp.ffmpeg.progress.ProgressParser;
import net.bramp.ffmpeg.progress.TcpProgressParser;
import org.apache.commons.lang3.math.Fraction;

public class FFmpeg
extends FFcommon {
    public static final String FFMPEG = "ffmpeg";
    public static final String DEFAULT_PATH = (String)MoreObjects.firstNonNull((Object)System.getenv("FFMPEG"), (Object)"ffmpeg");
    public static final Fraction FPS_30 = Fraction.getFraction((int)30, (int)1);
    public static final Fraction FPS_29_97 = Fraction.getFraction((int)30000, (int)1001);
    public static final Fraction FPS_24 = Fraction.getFraction((int)24, (int)1);
    public static final Fraction FPS_23_976 = Fraction.getFraction((int)24000, (int)1001);
    public static final int AUDIO_MONO = 1;
    public static final int AUDIO_STEREO = 2;
    public static final String AUDIO_FORMAT_U8 = "u8";
    public static final String AUDIO_FORMAT_S16 = "s16";
    public static final String AUDIO_FORMAT_S32 = "s32";
    public static final String AUDIO_FORMAT_FLT = "flt";
    public static final String AUDIO_FORMAT_DBL = "dbl";
    @Deprecated
    public static final String AUDIO_DEPTH_U8 = "u8";
    @Deprecated
    public static final String AUDIO_DEPTH_S16 = "s16";
    @Deprecated
    public static final String AUDIO_DEPTH_S32 = "s32";
    @Deprecated
    public static final String AUDIO_DEPTH_FLT = "flt";
    @Deprecated
    public static final String AUDIO_DEPTH_DBL = "dbl";
    public static final int AUDIO_SAMPLE_8000 = 8000;
    public static final int AUDIO_SAMPLE_11025 = 11025;
    public static final int AUDIO_SAMPLE_12000 = 12000;
    public static final int AUDIO_SAMPLE_16000 = 16000;
    public static final int AUDIO_SAMPLE_22050 = 22050;
    public static final int AUDIO_SAMPLE_32000 = 32000;
    public static final int AUDIO_SAMPLE_44100 = 44100;
    public static final int AUDIO_SAMPLE_48000 = 48000;
    public static final int AUDIO_SAMPLE_96000 = 96000;
    static final Pattern CODECS_REGEX = Pattern.compile("^ ([.D][.E][VASD][.I][.L][.S]) (\\S{2,})\\s+(.*)$");
    static final Pattern FORMATS_REGEX = Pattern.compile("^ ([ D][ E]) (\\S+)\\s+(.*)$");
    static final Pattern PIXEL_FORMATS_REGEX = Pattern.compile("^([.I][.O][.H][.P][.B]) (\\S{2,})\\s+(\\d+)\\s+(\\d+)$");
    static final Pattern FILTERS_REGEX = Pattern.compile("^\\s*(?<timelinesupport>[T.])(?<slicethreading>[S.])(?<commandsupport>[C.])\\s(?<name>[A-Za-z0-9_]+)\\s+(?<inputpattern>[AVN|]+)->(?<outputpattern>[AVN|]+)\\s+(?<description>.*)$");
    List<Codec> codecs = null;
    List<Format> formats = null;
    private List<PixelFormat> pixelFormats = null;
    private List<Filter> filters = null;
    private List<ChannelLayout> channelLayouts = null;

    public FFmpeg() throws IOException {
        this(DEFAULT_PATH, new RunProcessFunction());
    }

    public FFmpeg(@Nonnull ProcessFunction runFunction) throws IOException {
        this(DEFAULT_PATH, runFunction);
    }

    public FFmpeg(@Nonnull String path) throws IOException {
        this(path, new RunProcessFunction());
    }

    public FFmpeg(@Nonnull String path, @Nonnull ProcessFunction runFunction) throws IOException {
        super(path, runFunction);
        this.version();
    }

    public boolean isFFmpeg() throws IOException {
        return this.version().startsWith(FFMPEG);
    }

    private void checkIfFFmpeg() throws IllegalArgumentException, IOException {
        if (!this.isFFmpeg()) {
            throw new IllegalArgumentException("This binary '" + this.path + "' is not a supported version of ffmpeg");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public synchronized List<Codec> codecs() throws IOException {
        this.checkIfFFmpeg();
        if (this.codecs == null) {
            this.codecs = new ArrayList<Codec>();
            Process p = this.runFunc.run((List<String>)ImmutableList.of((Object)this.path, (Object)"-codecs"));
            try {
                String line;
                BufferedReader r = this.wrapInReader(p);
                while ((line = r.readLine()) != null) {
                    Matcher m = CODECS_REGEX.matcher(line);
                    if (!m.matches()) continue;
                    this.codecs.add(new Codec(m.group(2), m.group(3), m.group(1)));
                }
                this.throwOnError(p);
                this.codecs = ImmutableList.copyOf(this.codecs);
            }
            finally {
                p.destroy();
            }
        }
        return this.codecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public synchronized List<Filter> filters() throws IOException {
        this.checkIfFFmpeg();
        if (this.filters == null) {
            this.filters = new ArrayList<Filter>();
            Process p = this.runFunc.run((List<String>)ImmutableList.of((Object)this.path, (Object)"-filters"));
            try {
                String line;
                BufferedReader r = this.wrapInReader(p);
                while ((line = r.readLine()) != null) {
                    Matcher m = FILTERS_REGEX.matcher(line);
                    if (!m.matches()) continue;
                    this.filters.add(new Filter(m.group("timelinesupport").equals("T"), m.group("slicethreading").equals("S"), m.group("commandsupport").equals("C"), m.group("name"), new FilterPattern(m.group("inputpattern")), new FilterPattern(m.group("outputpattern")), m.group("description")));
                }
                this.throwOnError(p);
                this.filters = ImmutableList.copyOf(this.filters);
            }
            finally {
                p.destroy();
            }
        }
        return this.filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public synchronized List<Format> formats() throws IOException {
        this.checkIfFFmpeg();
        if (this.formats == null) {
            this.formats = new ArrayList<Format>();
            Process p = this.runFunc.run((List<String>)ImmutableList.of((Object)this.path, (Object)"-formats"));
            try {
                String line;
                BufferedReader r = this.wrapInReader(p);
                while ((line = r.readLine()) != null) {
                    Matcher m = FORMATS_REGEX.matcher(line);
                    if (!m.matches()) continue;
                    this.formats.add(new Format(m.group(2), m.group(3), m.group(1)));
                }
                this.throwOnError(p);
                this.formats = ImmutableList.copyOf(this.formats);
            }
            finally {
                p.destroy();
            }
        }
        return this.formats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<PixelFormat> pixelFormats() throws IOException {
        this.checkIfFFmpeg();
        if (this.pixelFormats == null) {
            this.pixelFormats = new ArrayList<PixelFormat>();
            Process p = this.runFunc.run((List<String>)ImmutableList.of((Object)this.path, (Object)"-pix_fmts"));
            try {
                String line;
                BufferedReader r = this.wrapInReader(p);
                while ((line = r.readLine()) != null) {
                    Matcher m = PIXEL_FORMATS_REGEX.matcher(line);
                    if (!m.matches()) continue;
                    String flags = m.group(1);
                    this.pixelFormats.add(new PixelFormat(m.group(2), Integer.parseInt(m.group(3)), Integer.parseInt(m.group(4)), flags));
                }
                this.throwOnError(p);
                this.pixelFormats = ImmutableList.copyOf(this.pixelFormats);
            }
            finally {
                p.destroy();
            }
        }
        return this.pixelFormats;
    }

    public synchronized List<ChannelLayout> channelLayouts() throws IOException {
        this.checkIfFFmpeg();
        if (this.channelLayouts == null) {
            Process p = this.runFunc.run((List<String>)ImmutableList.of((Object)this.path, (Object)"-layouts"));
            try {
                BufferedReader r = this.wrapInReader(p);
                this.channelLayouts = Collections.unmodifiableList(InfoParser.parseLayouts(r));
            }
            finally {
                p.destroy();
            }
        }
        return this.channelLayouts;
    }

    protected ProgressParser createProgressParser(ProgressListener listener) throws IOException {
        try {
            return new TcpProgressParser((ProgressListener)Preconditions.checkNotNull((Object)listener));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void run(List<String> args) throws IOException {
        this.checkIfFFmpeg();
        super.run(args);
    }

    public void run(FFmpegBuilder builder) throws IOException {
        this.run(builder, null);
    }

    public void run(FFmpegBuilder builder, @Nullable ProgressListener listener) throws IOException {
        Preconditions.checkNotNull((Object)builder);
        if (listener != null) {
            try (ProgressParser progressParser = this.createProgressParser(listener);){
                progressParser.start();
                builder = builder.addProgress(progressParser.getUri());
                this.run(builder.build());
            }
        } else {
            this.run(builder.build());
        }
    }

    @CheckReturnValue
    public FFmpegBuilder builder() {
        return new FFmpegBuilder();
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

