/*
 * Decompiled with CFR 0.152.
 */
package net.bramp.ffmpeg;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import net.bramp.ffmpeg.ProcessFunction;
import net.bramp.ffmpeg.RunProcessFunction;
import net.bramp.ffmpeg.io.ProcessUtils;

abstract class FFcommon {
    final String path;
    final ProcessFunction runFunc;
    String version = null;
    Appendable processOutputStream = System.out;
    Appendable processErrorStream = System.err;

    public FFcommon(@Nonnull String path) {
        this(path, new RunProcessFunction());
    }

    protected FFcommon(@Nonnull String path, @Nonnull ProcessFunction runFunction) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0);
        this.runFunc = (ProcessFunction)Preconditions.checkNotNull((Object)runFunction);
        this.path = path;
    }

    public void setProcessOutputStream(@Nonnull Appendable processOutputStream) {
        Preconditions.checkNotNull((Object)processOutputStream);
        this.processOutputStream = processOutputStream;
    }

    public void setProcessErrorStream(@Nonnull Appendable processErrorStream) {
        Preconditions.checkNotNull((Object)processErrorStream);
        this.processErrorStream = processErrorStream;
    }

    private BufferedReader _wrapInReader(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    protected BufferedReader wrapInReader(Process p) {
        return this._wrapInReader(p.getInputStream());
    }

    protected BufferedReader wrapErrorInReader(Process p) {
        return this._wrapInReader(p.getErrorStream());
    }

    protected void throwOnError(Process p) throws IOException {
        try {
            if (ProcessUtils.waitForWithTimeout(p, 1L, TimeUnit.SECONDS) != 0) {
                throw new IOException(this.path + " returned non-zero exit status. Check stdout.");
            }
        }
        catch (TimeoutException e) {
            throw new IOException("Timed out waiting for " + this.path + " to finish.");
        }
    }

    @Nonnull
    public synchronized String version() throws IOException {
        if (this.version == null) {
            Process p = this.runFunc.run((List<String>)ImmutableList.of((Object)this.path, (Object)"-version"));
            try {
                BufferedReader r = this.wrapInReader(p);
                this.version = r.readLine();
                CharStreams.copy((Readable)r, (Appendable)CharStreams.nullWriter());
                this.throwOnError(p);
            }
            finally {
                p.destroy();
            }
        }
        return this.version;
    }

    public String getPath() {
        return this.path;
    }

    public List<String> path(List<String> args) throws IOException {
        return ImmutableList.builder().add((Object)this.path).addAll(args).build();
    }

    public void run(List<String> args) throws IOException {
        Preconditions.checkNotNull(args);
        Process p = this.runFunc.run(this.path(args));
        assert (p != null);
        try {
            CharStreams.copy((Readable)this.wrapInReader(p), (Appendable)this.processOutputStream);
            CharStreams.copy((Readable)this.wrapErrorInReader(p), (Appendable)this.processErrorStream);
            this.throwOnError(p);
        }
        finally {
            p.destroy();
        }
    }
}

