/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.compress.archivers.sevenz;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.sevenz.BindPair;
import org.jetbrains.kotlin.org.apache.commons.compress.archivers.sevenz.Coder;

final class Folder {
    static final Folder[] EMPTY_FOLDER_ARRAY = new Folder[0];
    Coder[] coders;
    long totalInputStreams;
    long totalOutputStreams;
    BindPair[] bindPairs;
    long[] packedStreams;
    long[] unpackSizes;
    boolean hasCrc;
    long crc;
    int numUnpackSubStreams;

    Folder() {
    }

    int findBindPairForInStream(int index) {
        if (this.bindPairs != null) {
            for (int i2 = 0; i2 < this.bindPairs.length; ++i2) {
                if (this.bindPairs[i2].inIndex != (long)index) continue;
                return i2;
            }
        }
        return -1;
    }

    int findBindPairForOutStream(int index) {
        if (this.bindPairs != null) {
            for (int i2 = 0; i2 < this.bindPairs.length; ++i2) {
                if (this.bindPairs[i2].outIndex != (long)index) continue;
                return i2;
            }
        }
        return -1;
    }

    Iterable<Coder> getOrderedCoders() throws IOException {
        if (this.packedStreams == null || this.coders == null || this.packedStreams.length == 0 || this.coders.length == 0) {
            return Collections.emptyList();
        }
        LinkedList<Coder> list = new LinkedList<Coder>();
        int current2 = (int)this.packedStreams[0];
        while (current2 >= 0 && current2 < this.coders.length) {
            if (list.contains(this.coders[current2])) {
                throw new IOException("folder uses the same coder more than once in coder chain");
            }
            list.addLast(this.coders[current2]);
            int pair = this.findBindPairForOutStream(current2);
            current2 = pair != -1 ? (int)this.bindPairs[pair].inIndex : -1;
        }
        return list;
    }

    long getUnpackSize() {
        if (this.totalOutputStreams == 0L) {
            return 0L;
        }
        for (int i2 = (int)this.totalOutputStreams - 1; i2 >= 0; --i2) {
            if (this.findBindPairForOutStream(i2) >= 0) continue;
            return this.unpackSizes[i2];
        }
        return 0L;
    }

    long getUnpackSizeForCoder(Coder coder) {
        if (this.coders != null) {
            for (int i2 = 0; i2 < this.coders.length; ++i2) {
                if (this.coders[i2] != coder) continue;
                return this.unpackSizes[i2];
            }
        }
        return 0L;
    }

    public String toString() {
        return "Folder with " + this.coders.length + " coders, " + this.totalInputStreams + " input streams, " + this.totalOutputStreams + " output streams, " + this.bindPairs.length + " bind pairs, " + this.packedStreams.length + " packed streams, " + this.unpackSizes.length + " unpack sizes, " + (this.hasCrc ? "with CRC " + this.crc : "without CRC") + " and " + this.numUnpackSubStreams + " unpack streams";
    }
}

