/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinGradleBuildServices;
import org.jetbrains.kotlin.gradle.plugin.KotlinGradleFinishBuildHandler;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginInMultipleProjectsHolder;
import org.jetbrains.kotlin.gradle.plugin.PropertiesProvider;
import org.jetbrains.kotlin.gradle.plugin.UsesKotlinGradleBuildServices;
import org.jetbrains.kotlin.gradle.utils.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.utils.PersistentCachesKt;
import org.jetbrains.kotlin.gradle.utils.SingleActionPerProject;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b \u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\u001d\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "Lorg/gradle/api/services/BuildService;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices$Parameters;", "Ljava/lang/AutoCloseable;", "()V", "buildHandler", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleFinishBuildHandler;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "multipleProjectsHolder", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinPluginInMultipleProjectsHolder;", "close", "", "detectKotlinPluginLoadedInMultipleProjects", "project", "Lorg/gradle/api/Project;", "kotlinPluginVersion", "", "detectKotlinPluginLoadedInMultipleProjects$kotlin_gradle_plugin_common", "Companion", "Parameters", "kotlin-gradle-plugin_common"})
public abstract class KotlinGradleBuildServices
implements BuildService<Parameters>,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger log = Logging.getLogger(this.getClass());
    @NotNull
    private final KotlinGradleFinishBuildHandler buildHandler = new KotlinGradleFinishBuildHandler();
    @NotNull
    private final KotlinPluginInMultipleProjectsHolder multipleProjectsHolder = new KotlinPluginInMultipleProjectsHolder(true);
    private static final String CLASS_NAME = KotlinGradleBuildServices.class.getSimpleName();
    @NotNull
    private static final String INIT_MESSAGE = "Initialized " + CLASS_NAME;
    @NotNull
    private static final String DISPOSE_MESSAGE = "Disposed " + CLASS_NAME;

    public KotlinGradleBuildServices() {
        Logger logger2 = this.log;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
        GradleLoggingUtilsKt.kotlinDebug(logger2, INIT_MESSAGE);
        this.buildHandler.buildStart();
    }

    public final synchronized void detectKotlinPluginLoadedInMultipleProjects$kotlin_gradle_plugin_common(@NotNull Project project, @NotNull String kotlinPluginVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
        Function0 onRegister2 = (Function0)new Function0<Unit>(project, this, kotlinPluginVersion){
            final /* synthetic */ Project $project;
            final /* synthetic */ KotlinGradleBuildServices this$0;
            final /* synthetic */ String $kotlinPluginVersion;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$kotlinPluginVersion = $kotlinPluginVersion;
                super(0);
            }

            public final void invoke() {
                this.$project.getGradle().getTaskGraph().whenReady(new Action(this.this$0, this.$project, this.$kotlinPluginVersion){
                    final /* synthetic */ KotlinGradleBuildServices this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ String $kotlinPluginVersion;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        this.$kotlinPluginVersion = $kotlinPluginVersion;
                    }

                    public final void execute(TaskExecutionGraph it) {
                        if (KotlinGradleBuildServices.access$getMultipleProjectsHolder$p(this.this$0).isInMultipleProjects(this.$project, this.$kotlinPluginVersion)) {
                            List<String> list = KotlinGradleBuildServices.access$getMultipleProjectsHolder$p(this.this$0).getAffectedProjects(this.$project, this.$kotlinPluginVersion);
                            Intrinsics.checkNotNull(list);
                            List<String> loadedInProjects = list;
                            if (!Intrinsics.areEqual((Object)PropertiesProvider.Companion.invoke(this.$project).getIgnorePluginLoadedInMultipleProjects(), (Object)true)) {
                                this.$project.getLogger().warn("\nThe Kotlin Gradle plugin was loaded multiple times in different subprojects, which is not supported and may break the build. \nThis might happen in subprojects that apply the Kotlin plugins with the Gradle 'plugins { ... }' DSL if they specify explicit versions, even if the versions are equal.\nPlease add the Kotlin plugin to the common parent project or the root project, then remove the versions in the subprojects.\nIf the parent project does not need the plugin, add 'apply false' to the plugin line.\nSee: https://docs.gradle.org/current/userguide/plugins.html#sec:subprojects_plugins_dsl");
                                this.$project.getLogger().warn("The Kotlin plugin was loaded in the following projects: " + CollectionsKt.joinToString$default((Iterable)loadedInProjects, null, null, null, (int)4, null, (Function1)detectKotlinPluginLoadedInMultipleProjects.onRegister.1.INSTANCE, (int)23, null));
                            }
                            this.$project.getLogger().info("The full list of projects that loaded the Kotlin plugin is: : " + CollectionsKt.joinToString$default((Iterable)loadedInProjects, null, null, null, (int)0, null, (Function1)detectKotlinPluginLoadedInMultipleProjects.onRegister.2.INSTANCE, (int)31, null));
                        }
                    }
                });
            }
        };
        this.multipleProjectsHolder.addProject(project, kotlinPluginVersion, (Function0<Unit>)onRegister2);
    }

    @Override
    public void close() {
        Object object = ((Parameters)this.getParameters()).getSessionsDir().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.sessionsDir.get()");
        this.buildHandler.buildFinished((File)object);
        Logger logger2 = this.log;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
        GradleLoggingUtilsKt.kotlinDebug(logger2, DISPOSE_MESSAGE);
    }

    public static final /* synthetic */ KotlinPluginInMultipleProjectsHolder access$getMultipleProjectsHolder$p(KotlinGradleBuildServices $this) {
        return $this.multipleProjectsHolder;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices$Companion;", "", "()V", "CLASS_NAME", "", "kotlin.jvm.PlatformType", "DISPOSE_MESSAGE", "INIT_MESSAGE", "registerIfAbsent", "Lorg/gradle/api/provider/Provider;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices;", "project", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Provider<KotlinGradleBuildServices> registerIfAbsent(@NotNull Project project) {
            Provider provider;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Gradle gradle = project.getGradle();
            Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
            Provider serviceProvider = provider = GradleUtilsKt.registerClassLoaderScopedBuildService(gradle, Reflection.getOrCreateKotlinClass(KotlinGradleBuildServices.class), (Action)new Action(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                }

                public final void execute(BuildServiceSpec<Parameters> it) {
                    ((Parameters)it.getParameters()).getSessionsDir().set((Object)PersistentCachesKt.getKotlinSessionsDir(this.$project));
                }
            });
            boolean bl = false;
            String string = UsesKotlinGradleBuildServices.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UsesKotlinGradleBuildServices::class.java.name");
            SingleActionPerProject.INSTANCE.run(project, string, (Function0<Unit>)((Function0)new Function0<Unit>(project, serviceProvider){
                final /* synthetic */ Project $project;
                final /* synthetic */ Provider<KotlinGradleBuildServices> $serviceProvider;
                {
                    this.$project = $project;
                    this.$serviceProvider = $serviceProvider;
                    super(0);
                }

                public final void invoke() {
                    TaskContainer taskContainer = this.$project.getTasks();
                    Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                    TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
                    boolean $i$f$withType = false;
                    TaskCollection taskCollection = $this$withType$iv.withType(UsesKotlinGradleBuildServices.class);
                    Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"withType(S::class.java)");
                    taskCollection.configureEach(new Action(this.$serviceProvider){
                        final /* synthetic */ Provider<KotlinGradleBuildServices> $serviceProvider;
                        {
                            this.$serviceProvider = $serviceProvider;
                        }

                        public final void execute(UsesKotlinGradleBuildServices task2) {
                            task2.usesService(this.$serviceProvider);
                            task2.getKotlinGradleBuildServices().set(this.$serviceProvider);
                        }
                    });
                }
            }));
            return provider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinGradleBuildServices$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "sessionsDir", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getSessionsDir", "()Lorg/gradle/api/provider/Property;", "kotlin-gradle-plugin_common"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public Property<File> getSessionsDir();
    }
}

