/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.mangle.KotlinMangleComputer;
import org.jetbrains.kotlin.backend.common.serialization.mangle.MangleConstant;
import org.jetbrains.kotlin.backend.common.serialization.mangle.MangleMode;
import org.jetbrains.kotlin.backend.common.serialization.mangle.MangleUtilsKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirContextReceiver;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticPropertyAccessor;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaField;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.signaturer.FirManglerUtilKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeRawType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\b\u0012\u0004\u0012\u00020\u00050\u0004B\u0019\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0003H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\nH\u0016J$\u0010\u0017\u001a\u00020\u00022\n\u0010\u0018\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J$\u0010\u001d\u001a\u00020\u00022\n\u0010\u001e\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u001c\u0010#\u001a\u00020\u00022\n\u0010$\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u001f\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0003H\u0016J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,2\u0006\u0010)\u001a\u00020\u0003H\u0016J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010)\u001a\u00020\u0003H\u0016J\u0018\u00101\u001a\u00020\u00022\u0006\u00102\u001a\u0002032\u0006\u0010)\u001a\u00020\u0003H\u0016J\u0018\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u0002062\u0006\u0010)\u001a\u00020\u0003H\u0016J\u0018\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u0002092\u0006\u0010)\u001a\u00020\u0003H\u0016J\u0018\u0010:\u001a\u00020\u00022\u0006\u0010;\u001a\u00020<2\u0006\u0010)\u001a\u00020\u0003H\u0016J\u0018\u0010=\u001a\u00020\u00022\u0006\u0010>\u001a\u00020?2\u0006\u0010)\u001a\u00020\u0003H\u0016J\u0018\u0010@\u001a\u00020\u00022\u0006\u0010A\u001a\u00020B2\u0006\u0010)\u001a\u00020\u0003H\u0016J\u0018\u0010C\u001a\u00020\u00022\u0006\u0010D\u001a\u00020E2\u0006\u0010)\u001a\u00020\u0003H\u0016J\u0018\u0010F\u001a\u00020\u00022\u0006\u0010G\u001a\u00020H2\u0006\u0010)\u001a\u00020\u0003H\u0016J\u0018\u0010I\u001a\u00020\u0002*\u00060\u0007j\u0002`\b2\u0006\u0010J\u001a\u00020KH\u0002J\u0018\u0010I\u001a\u00020\u0002*\u00060\u0007j\u0002`\b2\u0006\u0010L\u001a\u00020\u0013H\u0002J\u0018\u0010M\u001a\u00020\u0002*\u00060\u0007j\u0002`\b2\u0006\u0010J\u001a\u00020KH\u0002J\u0018\u0010M\u001a\u00020\u0002*\u00060\u0007j\u0002`\b2\u0006\u0010N\u001a\u00020\"H\u0002J\u0018\u0010M\u001a\u00020\u0002*\u00060\u0007j\u0002`\b2\u0006\u0010L\u001a\u00020\u0013H\u0002J\f\u0010O\u001a\u00020\u000f*\u00020 H\u0002J$\u0010P\u001a\u00020\u0002*\u00020Q2\u0006\u0010R\u001a\u00020\u00032\u0006\u0010S\u001a\u00020\u00032\u0006\u0010T\u001a\u00020\u0005H\u0002J$\u0010U\u001a\u00020\u0002*\u00020Q2\u0006\u0010R\u001a\u00020\u00032\u0006\u0010S\u001a\u00020\u00032\u0006\u0010T\u001a\u00020\u0005H\u0002J\u0014\u0010V\u001a\u00020\u0002*\u00020\u00052\u0006\u0010W\u001a\u00020\u0013H\u0002J\u0018\u0010X\u001a\u00020\u0002*\u00060\u0007j\u0002`\b2\u0006\u0010Y\u001a\u00020 H\u0002J\u000e\u0010Z\u001a\u0004\u0018\u00010\u0013*\u00020QH\u0016J\u000e\u0010[\u001a\u0004\u0018\u00010\u0013*\u00020QH\u0016J\u0014\u0010\\\u001a\u00020\u0013*\u00020Q2\u0006\u0010\u001f\u001a\u00020%H\u0016J\f\u0010]\u001a\u00020\u0002*\u00020\u0005H\u0002R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmMangleComputer;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "", "Lorg/jetbrains/kotlin/backend/common/serialization/mangle/KotlinMangleComputer;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "mode", "Lorg/jetbrains/kotlin/backend/common/serialization/mangle/MangleMode;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/backend/common/serialization/mangle/MangleMode;)V", "isRealExpect", "typeParameterContainer", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lkotlin/collections/ArrayList;", "addReturnType", "computeMangle", "", "declaration", "copy", "newMode", "mangleType", "tBuilder", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "declarationSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "mangleTypeParameter", "tpBuilder", "param", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "index", "", "mangleValueParameter", "vpBuilder", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "visitAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "data", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "visitField", "field", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "visitVariable", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "appendName", "c", "", "s", "appendSignature", "i", "effectiveParent", "mangleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "isCtor", "isStatic", "container", "mangleSignature", "mangleSimpleDeclaration", "name", "mangleTypeParameterReference", "typeParameter", "platformSpecificFunctionName", "platformSpecificSuffix", "specialValueParamPrefix", "visitParent", "jvm-backend"})
@SourceDebugExtension(value={"SMAP\nFirJvmMangleComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmMangleComputer.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmMangleComputer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n+ 6 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,373:1\n1#2:374\n34#3:375\n34#3:384\n34#3:385\n36#3:386\n34#3:387\n36#3:388\n36#3:389\n1855#4,2:376\n1549#4:379\n1620#4,3:380\n60#5:378\n178#6:383\n*S KotlinDebug\n*F\n+ 1 FirJvmMangleComputer.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmMangleComputer\n*L\n117#1:375\n300#1:384\n310#1:385\n314#1:386\n351#1:387\n352#1:388\n364#1:389\n151#1:376,2\n203#1:379\n203#1:380,3\n182#1:378\n234#1:383\n*E\n"})
public class FirJvmMangleComputer
extends FirVisitor<Unit, Boolean>
implements KotlinMangleComputer<FirDeclaration> {
    @NotNull
    private final StringBuilder builder;
    @NotNull
    private final MangleMode mode;
    @NotNull
    private final ArrayList<FirMemberDeclaration> typeParameterContainer;
    private boolean isRealExpect;

    public FirJvmMangleComputer(@NotNull StringBuilder builder2, @NotNull MangleMode mode) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.builder = builder2;
        this.mode = mode;
        this.typeParameterContainer = new ArrayList(4);
    }

    @Nullable
    public String platformSpecificFunctionName(@NotNull FirFunction $this$platformSpecificFunctionName) {
        Intrinsics.checkNotNullParameter((Object)$this$platformSpecificFunctionName, (String)"<this>");
        return null;
    }

    @Nullable
    public String platformSpecificSuffix(@NotNull FirFunction $this$platformSpecificSuffix) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$platformSpecificSuffix, (String)"<this>");
        if ($this$platformSpecificSuffix instanceof FirSimpleFunction && Intrinsics.areEqual((Object)((FirSimpleFunction)$this$platformSpecificSuffix).getName().asString(), (Object)"main")) {
            FirFile firFile = FirProviderKt.getFirProvider($this$platformSpecificSuffix.getModuleData().getSession()).getFirCallableContainerFile(((FirSimpleFunction)$this$platformSpecificSuffix).getSymbol());
            string2 = firFile != null ? firFile.getName() : null;
        } else {
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public String specialValueParamPrefix(@NotNull FirFunction $this$specialValueParamPrefix, @NotNull FirValueParameter param) {
        Intrinsics.checkNotNullParameter((Object)$this$specialValueParamPrefix, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        return "";
    }

    private final boolean addReturnType() {
        return true;
    }

    @NotNull
    public FirJvmMangleComputer copy(@NotNull MangleMode newMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)newMode), (String)"newMode");
        return new FirJvmMangleComputer(this.builder, newMode);
    }

    private final void appendName(StringBuilder $this$appendName, String s) {
        if (this.mode.getFqn()) {
            $this$appendName.append(s);
        }
    }

    private final void appendName(StringBuilder $this$appendName, char c) {
        if (this.mode.getFqn()) {
            $this$appendName.append(c);
        }
    }

    private final void appendSignature(StringBuilder $this$appendSignature, String s) {
        if (this.mode.getSignature()) {
            $this$appendSignature.append(s);
        }
    }

    private final void appendSignature(StringBuilder $this$appendSignature, char c) {
        if (this.mode.getSignature()) {
            $this$appendSignature.append(c);
        }
    }

    private final void appendSignature(StringBuilder $this$appendSignature, int i) {
        if (this.mode.getSignature()) {
            $this$appendSignature.append(i);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void visitParent(FirDeclaration $this$visitParent) {
        Object object;
        FirDeclaration firDeclaration = $this$visitParent;
        if (firDeclaration instanceof FirCallableDeclaration) {
            object = ClassMembersKt.containingClassLookupTag((FirCallableDeclaration)$this$visitParent);
            if (object == null || (object = ((ConeClassLikeLookupTag)object).getClassId()) == null) return;
            Object it = object;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)((ClassId)it).getPackageFqName(), (Object)it);
            object = pair;
            if (pair == null) {
                return;
            }
        } else {
            if (!(firDeclaration instanceof FirClassLikeDeclaration)) return;
            ClassId it = ((FirClassLikeDeclaration)$this$visitParent).getSymbol().getClassId();
            boolean bl = false;
            object = TuplesKt.to((Object)it.getPackageFqName(), (Object)it.getOuterClassId());
        }
        Object object2 = object;
        FqName parentPackageFqName = (FqName)object2.component1();
        ClassId parentClassId = (ClassId)object2.component2();
        if (parentClassId != null && !parentClassId.isLocal()) {
            FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider($this$visitParent.getModuleData().getSession()).getClassLikeSymbolByClassId(parentClassId);
            if (firClassLikeSymbol == null || (firClassLikeSymbol = (FirClassLikeDeclaration)firClassLikeSymbol.getFir()) == null) {
                throw new IllegalStateException(("Attempt to find parent (" + parentClassId + ") for probably-local declaration!").toString());
            }
            FirClassLikeSymbol<?> parentClassLike = firClassLikeSymbol;
            if (!(parentClassLike instanceof FirRegularClass) && !(parentClassLike instanceof FirTypeAlias)) throw new IllegalStateException(("Strange class-like declaration: " + UtilsKt.render((FirElement)((Object)parentClassLike))).toString());
            ((FirClassLikeDeclaration)((Object)parentClassLike)).accept(this, false);
            return;
        } else {
            if (parentClassId != null || parentPackageFqName.isRoot()) return;
            String string2 = parentPackageFqName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parentPackageFqName.asString()");
            this.appendName(this.builder, string2);
        }
    }

    private final void mangleSimpleDeclaration(FirDeclaration $this$mangleSimpleDeclaration, String name) {
        int l = this.builder.length();
        this.visitParent($this$mangleSimpleDeclaration);
        if (this.builder.length() != l) {
            this.appendName(this.builder, '.');
        }
        this.appendName(this.builder, name);
    }

    /*
     * Unable to fully structure code
     */
    private final void mangleFunction(FirFunction $this$mangleFunction, boolean isCtor, boolean isStatic, FirDeclaration container) {
        if (this.isRealExpect) ** GOTO lbl-1000
        v0 = $this$mangleFunction instanceof FirMemberDeclaration != false ? (FirMemberDeclaration)$this$mangleFunction : null;
        if (v0 != null) {
            $this$isExpect$iv = v0;
            $i$f$isExpect = false;
            v1 = $this$isExpect$iv.getStatus().isExpect();
        } else {
            v1 = false;
        }
        if (v1) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = this.isRealExpect = false;
        }
        if (container instanceof FirMemberDeclaration) {
            this.typeParameterContainer.add((FirMemberDeclaration)container);
        }
        this.visitParent($this$mangleFunction);
        this.appendName(this.builder, '#');
        var5_8 = this.platformSpecificFunctionName($this$mangleFunction);
        if (var5_8 != null) {
            it = var5_8;
            $i$a$-let-FirJvmMangleComputer$mangleFunction$1 = false;
            this.builder.append(it);
            return;
        }
        name = FirManglerUtilKt.getIrName($this$mangleFunction);
        this.builder.append(name.asString());
        v3 = this.platformSpecificSuffix($this$mangleFunction);
        if (v3 != null) {
            it = v3;
            $i$a$-let-FirJvmMangleComputer$mangleFunction$2 = false;
            this.builder.append('%');
            this.builder.append(it);
        }
        this.mangleSignature($this$mangleFunction, isCtor, isStatic, container);
    }

    private final void mangleSignature(FirFunction $this$mangleSignature, boolean isCtor, boolean isStatic, FirDeclaration container) {
        List list2;
        FirPureAbstractElement receiverType;
        if (!this.mode.getSignature()) {
            return;
        }
        if (isStatic) {
            this.appendSignature(this.builder, "#static");
        }
        Iterable $this$forEach$iv = $this$mangleSignature.getContextReceivers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirContextReceiver it = (FirContextReceiver)element$iv;
            boolean bl = false;
            this.appendSignature(this.builder, '!');
            this.mangleType(this.builder, FirTypeUtilsKt.getConeType(it.getTypeRef()), $this$mangleSignature.getModuleData().getSession());
        }
        FirPureAbstractElement firPureAbstractElement = $this$mangleSignature.getReceiverParameter();
        if (firPureAbstractElement == null || (firPureAbstractElement = firPureAbstractElement.getTypeRef()) == null) {
            Object object = $this$mangleSignature instanceof FirPropertyAccessor ? (FirPropertyAccessor)$this$mangleSignature : null;
            firPureAbstractElement = object != null && (object = ((FirPropertyAccessor)object).getPropertySymbol()) != null && (object = (FirProperty)((FirBasedSymbol)object).getFir()) != null && (object = ((FirProperty)object).getReceiverParameter()) != null ? ((FirReceiverParameter)object).getTypeRef() : null;
        }
        FirPureAbstractElement firPureAbstractElement2 = receiverType = firPureAbstractElement;
        if (firPureAbstractElement2 != null) {
            FirPureAbstractElement it = firPureAbstractElement2;
            boolean bl = false;
            this.appendSignature(this.builder, '@');
            this.mangleType(this.builder, FirTypeUtilsKt.getConeType((FirTypeRef)it), $this$mangleSignature.getModuleData().getSession());
        }
        MangleUtilsKt.collectForMangler((Collection)$this$mangleSignature.getValueParameters(), this.builder, MangleConstant.VALUE_PARAMETERS, (Function2)new Function2<StringBuilder, FirValueParameter, Unit>(this, $this$mangleSignature){
            final /* synthetic */ FirJvmMangleComputer this$0;
            final /* synthetic */ FirFunction $this_mangleSignature;
            {
                this.this$0 = $receiver;
                this.$this_mangleSignature = $receiver2;
                super(2);
            }

            public final void invoke(@NotNull StringBuilder $this$collectForMangler, @NotNull FirValueParameter it) {
                Intrinsics.checkNotNullParameter((Object)$this$collectForMangler, (String)"$this$collectForMangler");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FirJvmMangleComputer.access$appendSignature(this.this$0, $this$collectForMangler, this.this$0.specialValueParamPrefix(this.$this_mangleSignature, it));
                FirJvmMangleComputer.access$mangleValueParameter(this.this$0, $this$collectForMangler, it);
            }
        });
        Object object = container instanceof FirTypeParametersOwner ? (FirTypeParametersOwner)((Object)container) : null;
        if ((object != null && (object = object.getTypeParameters()) != null && (object = CollectionsKt.withIndex((Iterable)((Iterable)object))) != null ? CollectionsKt.toList((Iterable)object) : (list2 = null)) == null) {
            list2 = CollectionsKt.emptyList();
        }
        MangleUtilsKt.collectForMangler(list2, this.builder, MangleConstant.TYPE_PARAMETERS, (Function2)new Function2<StringBuilder, IndexedValue<? extends FirTypeParameter>, Unit>(this){
            final /* synthetic */ FirJvmMangleComputer this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull StringBuilder $this$collectForMangler, @NotNull IndexedValue<? extends FirTypeParameter> indexedValue) {
                Intrinsics.checkNotNullParameter((Object)$this$collectForMangler, (String)"$this$collectForMangler");
                Intrinsics.checkNotNullParameter(indexedValue, (String)"<name for destructuring parameter 0>");
                int index2 = indexedValue.component1();
                FirTypeParameter typeParameter2 = (FirTypeParameter)indexedValue.component2();
                FirJvmMangleComputer.access$mangleTypeParameter(this.this$0, $this$collectForMangler, typeParameter2, index2);
            }
        });
        if (!isCtor && !FirTypeUtilsKt.isUnit($this$mangleSignature.getReturnTypeRef()) && this.addReturnType()) {
            this.mangleType(this.builder, FirTypeUtilsKt.getConeType($this$mangleSignature.getReturnTypeRef()), $this$mangleSignature.getModuleData().getSession());
        }
    }

    private final FirMemberDeclaration effectiveParent(FirTypeParameter $this$effectiveParent) {
        for (FirMemberDeclaration parent2 : this.typeParameterContainer) {
            if (parent2.getTypeParameters().contains($this$effectiveParent)) {
                Intrinsics.checkNotNullExpressionValue((Object)parent2, (String)"parent");
                return parent2;
            }
            if (!(parent2 instanceof FirCallableDeclaration)) continue;
            FirCallableDeclaration $this$originalForSubstitutionOverride$iv = (FirCallableDeclaration)parent2;
            boolean $i$f$getOriginalForSubstitutionOverride = false;
            FirCallableDeclaration overriddenFir = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv) : null;
            if (!(overriddenFir instanceof FirTypeParametersOwner) || !((FirTypeParametersOwner)((Object)overriddenFir)).getTypeParameters().contains($this$effectiveParent)) continue;
            return parent2;
        }
        throw new IllegalStateException("Should not be here!");
    }

    private final void mangleValueParameter(StringBuilder vpBuilder, FirValueParameter param) {
        this.mangleType(vpBuilder, FirTypeUtilsKt.getConeType(param.getReturnTypeRef()), param.getModuleData().getSession());
        if (param.isVararg()) {
            this.appendSignature(vpBuilder, "...");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void mangleTypeParameter(StringBuilder tpBuilder, FirTypeParameter param, int index2) {
        void $this$mapTo$iv$iv;
        this.appendSignature(tpBuilder, index2);
        this.appendSignature(tpBuilder, '\u00a7');
        Iterable $this$map$iv = param.getBounds();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeRef firTypeRef = (FirTypeRef)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FirTypeUtilsKt.getConeType((FirTypeRef)it));
        }
        MangleUtilsKt.collectForMangler((List)destination$iv$iv, tpBuilder, MangleConstant.UPPER_BOUNDS, (Function2)new Function2<StringBuilder, ConeKotlinType, Unit>(this, param){
            final /* synthetic */ FirJvmMangleComputer this$0;
            final /* synthetic */ FirTypeParameter $param;
            {
                this.this$0 = $receiver;
                this.$param = $param;
                super(2);
            }

            public final void invoke(@NotNull StringBuilder $this$collectForMangler, @NotNull ConeKotlinType it) {
                Intrinsics.checkNotNullParameter((Object)$this$collectForMangler, (String)"$this$collectForMangler");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FirJvmMangleComputer.access$mangleType(this.this$0, $this$collectForMangler, it, this.$param.getModuleData().getSession());
            }
        });
    }

    private final void mangleTypeParameterReference(StringBuilder $this$mangleTypeParameterReference, FirTypeParameter typeParameter2) {
        FirMemberDeclaration parent2 = this.effectiveParent(typeParameter2);
        int ci = this.typeParameterContainer.indexOf(parent2);
        if (!(ci >= 0)) {
            boolean bl = false;
            String string2 = "No type container found for " + UtilsKt.render(typeParameter2);
            throw new IllegalArgumentException(string2.toString());
        }
        this.appendSignature($this$mangleTypeParameterReference, ci);
        this.appendSignature($this$mangleTypeParameterReference, ':');
        this.appendSignature($this$mangleTypeParameterReference, parent2.getTypeParameters().indexOf(typeParameter2));
    }

    private final void mangleType(StringBuilder tBuilder, ConeKotlinType type2, FirSession declarationSiteSession) {
        ConeKotlinType coneKotlinType = type2;
        if (coneKotlinType instanceof ConeLookupTagBasedType) {
            FirClassifierSymbol<?> symbol2 = LookupTagUtilsKt.toSymbol(((ConeLookupTagBasedType)type2).getLookupTag(), declarationSiteSession);
            if (symbol2 instanceof FirTypeAliasSymbol) {
                this.mangleType(tBuilder, TypeExpansionUtilsKt.fullyExpandedType((ConeSimpleKotlinType)type2, declarationSiteSession), declarationSiteSession);
                return;
            }
            if (symbol2 instanceof FirClassSymbol) {
                ((FirDeclaration)symbol2.getFir()).accept(this.copy(MangleMode.FQNAME), false);
            } else if (symbol2 instanceof FirTypeParameterSymbol) {
                this.mangleTypeParameterReference(tBuilder, (FirTypeParameter)((FirTypeParameterSymbol)symbol2).getFir());
            } else if (symbol2 == null) {
                ConeClassifierLookupTag coneClassifierLookupTag = ((ConeLookupTagBasedType)type2).getLookupTag();
                ConeClassLikeLookupTag coneClassLikeLookupTag = coneClassifierLookupTag instanceof ConeClassLikeLookupTag ? (ConeClassLikeLookupTag)coneClassifierLookupTag : null;
                if (coneClassLikeLookupTag != null) {
                    ConeClassLikeLookupTag it = coneClassLikeLookupTag;
                    boolean bl2 = false;
                    tBuilder.append(it.getClassId());
                }
            }
            Collection $this$ifNotEmpty$iv = ArraysKt.asList((Object[])type2.getTypeArguments());
            boolean $i$f$ifNotEmpty = false;
            if (!$this$ifNotEmpty$iv.isEmpty()) {
                List $this$mangleType_u24lambda_u249 = (List)$this$ifNotEmpty$iv;
                boolean bl = false;
                MangleUtilsKt.collectForMangler($this$mangleType_u24lambda_u249, tBuilder, MangleConstant.TYPE_ARGUMENTS, (Function2)new Function2<StringBuilder, ConeTypeProjection, Unit>(this, declarationSiteSession){
                    final /* synthetic */ FirJvmMangleComputer this$0;
                    final /* synthetic */ FirSession $declarationSiteSession;
                    {
                        this.this$0 = $receiver;
                        this.$declarationSiteSession = $declarationSiteSession;
                        super(2);
                    }

                    public final void invoke(@NotNull StringBuilder $this$collectForMangler, @NotNull ConeTypeProjection arg) {
                        Intrinsics.checkNotNullParameter((Object)$this$collectForMangler, (String)"$this$collectForMangler");
                        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                        ConeTypeProjection coneTypeProjection = arg;
                        if (coneTypeProjection instanceof ConeStarProjection) {
                            FirJvmMangleComputer.access$appendSignature(this.this$0, $this$collectForMangler, '*');
                        } else if (coneTypeProjection instanceof ConeKotlinTypeProjection) {
                            if (arg.getKind() != ProjectionKind.INVARIANT) {
                                FirJvmMangleComputer.access$appendSignature(this.this$0, $this$collectForMangler, CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(arg.getKind().name()));
                                FirJvmMangleComputer.access$appendSignature(this.this$0, $this$collectForMangler, '|');
                            }
                            FirJvmMangleComputer.access$mangleType(this.this$0, $this$collectForMangler, ((ConeKotlinTypeProjection)arg).getType(), this.$declarationSiteSession);
                        }
                    }
                });
            }
            if (ConeTypeUtilsKt.isMarkedNullable(type2)) {
                this.appendSignature(tBuilder, '?');
            }
            if (CompilerConeAttributesKt.getHasEnhancedNullability(type2)) {
                this.appendSignature(tBuilder, "{EnhancedNullability}");
            }
        } else if (coneKotlinType instanceof ConeRawType) {
            this.mangleType(tBuilder, ((ConeRawType)type2).getLowerBound(), declarationSiteSession);
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            ConeInferenceContext $this$mangleType_u24lambda_u2410 = TypeComponentsKt.getTypeContext(declarationSiteSession);
            boolean bl = false;
            ConeSimpleKotlinType upper = ((ConeFlexibleType)type2).getUpperBound();
            if (upper instanceof ConeClassLikeType) {
                ConeSimpleKotlinType bl2 = ((ConeFlexibleType)type2).getLowerBound();
                ConeClassLikeType coneClassLikeType = bl2 instanceof ConeClassLikeType ? (ConeClassLikeType)bl2 : null;
                if (coneClassLikeType == null) {
                    throw new IllegalStateException(("Expecting class-like type, got " + ((ConeFlexibleType)type2).getLowerBound()).toString());
                }
                ConeClassLikeType lower2 = coneClassLikeType;
                SimpleTypeMarker intermediate = Intrinsics.areEqual((Object)lower2.getLookupTag(), (Object)((ConeClassLikeType)upper).getLookupTag()) ? $this$mangleType_u24lambda_u2410.replaceArguments((SimpleTypeMarker)lower2, $this$mangleType_u24lambda_u2410.getArguments(upper)) : (SimpleTypeMarker)lower2;
                KotlinTypeMarker mixed = ConeTypeUtilsKt.isNullable(upper) ? $this$mangleType_u24lambda_u2410.makeNullable(intermediate) : $this$mangleType_u24lambda_u2410.makeDefinitelyNotNullOrNotNull(intermediate);
                Intrinsics.checkNotNull((Object)mixed, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                this.mangleType(tBuilder, (ConeKotlinType)mixed, declarationSiteSession);
            } else {
                this.mangleType(tBuilder, upper, declarationSiteSession);
            }
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            this.mangleType(tBuilder, ((ConeDefinitelyNotNullType)type2).getOriginal(), declarationSiteSession);
        } else if (coneKotlinType instanceof ConeCapturedType) {
            ConeKotlinType coneKotlinType2 = ((ConeCapturedType)type2).getLowerType();
            if (coneKotlinType2 == null) {
                List<ConeKotlinType> list2 = ((ConeCapturedType)type2).getConstructor().getSupertypes();
                Intrinsics.checkNotNull(list2);
                coneKotlinType2 = (ConeKotlinType)CollectionsKt.first(list2);
            }
            this.mangleType(tBuilder, coneKotlinType2, declarationSiteSession);
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            this.mangleType(tBuilder, (ConeKotlinType)CollectionsKt.first((Iterable)((ConeIntersectionType)type2).getIntersectedTypes()), declarationSiteSession);
        } else {
            throw new IllegalStateException(("Unexpected type " + type2).toString());
        }
    }

    @Override
    @NotNull
    public Void visitElement(@NotNull FirElement element, boolean data2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        throw new IllegalStateException(("unexpected element " + UtilsKt.render(element)).toString());
    }

    @Override
    public void visitRegularClass(@NotNull FirRegularClass regularClass, boolean data2) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        FirMemberDeclaration $this$isExpect$iv = regularClass;
        boolean $i$f$isExpect = false;
        this.isRealExpect |= $this$isExpect$iv.getStatus().isExpect();
        this.typeParameterContainer.add(regularClass);
        FirDeclaration firDeclaration = regularClass;
        String string2 = regularClass.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"regularClass.name.asString()");
        this.mangleSimpleDeclaration(firDeclaration, string2);
    }

    @Override
    public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject, boolean data2) {
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        this.mangleSimpleDeclaration(anonymousObject, "<anonymous>");
    }

    @Override
    public void visitVariable(@NotNull FirVariable variable2, boolean data2) {
        FirPureAbstractElement firPureAbstractElement;
        Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
        FirMemberDeclaration $this$isExpect$iv = variable2;
        boolean $i$f$isExpect = false;
        this.isRealExpect |= $this$isExpect$iv.getStatus().isExpect();
        this.typeParameterContainer.add(variable2);
        this.visitParent(variable2);
        FirMemberDeclaration $this$isStatic$iv = variable2;
        boolean $i$f$isStatic = false;
        boolean isStaticProperty = $this$isStatic$iv.getStatus().isStatic();
        if (isStaticProperty) {
            this.appendSignature(this.builder, "#static");
        }
        if ((firPureAbstractElement = variable2.getReceiverParameter()) != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null) {
            FirPureAbstractElement it = firPureAbstractElement;
            boolean bl = false;
            this.appendSignature(this.builder, '@');
            this.mangleType(this.builder, FirTypeUtilsKt.getConeType((FirTypeRef)it), variable2.getModuleData().getSession());
        }
        MangleUtilsKt.collectForMangler(CollectionsKt.toList((Iterable)CollectionsKt.withIndex((Iterable)variable2.getTypeParameters())), this.builder, MangleConstant.TYPE_PARAMETERS, (Function2)new Function2<StringBuilder, IndexedValue<? extends FirTypeParameterRef>, Unit>(this){
            final /* synthetic */ FirJvmMangleComputer this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull StringBuilder $this$collectForMangler, @NotNull IndexedValue<? extends FirTypeParameterRef> indexedValue) {
                Intrinsics.checkNotNullParameter((Object)$this$collectForMangler, (String)"$this$collectForMangler");
                Intrinsics.checkNotNullParameter(indexedValue, (String)"<name for destructuring parameter 0>");
                int index2 = indexedValue.component1();
                FirTypeParameterRef typeParameter2 = (FirTypeParameterRef)indexedValue.component2();
                FirJvmMangleComputer.access$mangleTypeParameter(this.this$0, $this$collectForMangler, (FirTypeParameter)typeParameter2.getSymbol().getFir(), index2);
            }
        });
        this.builder.append(variable2.getName().asString());
    }

    @Override
    public void visitProperty(@NotNull FirProperty property2, boolean data2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        this.visitVariable((FirVariable)property2, data2);
    }

    @Override
    public void visitField(@NotNull FirField field2, boolean data2) {
        Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
        if (field2 instanceof FirJavaField) {
            FirDeclaration firDeclaration = field2;
            String string2 = field2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"field.name.asString()");
            this.mangleSimpleDeclaration(firDeclaration, string2);
        } else {
            this.visitVariable((FirVariable)field2, data2);
        }
    }

    @Override
    public void visitEnumEntry(@NotNull FirEnumEntry enumEntry, boolean data2) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        FirDeclaration firDeclaration = enumEntry;
        String string2 = enumEntry.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"enumEntry.name.asString()");
        this.mangleSimpleDeclaration(firDeclaration, string2);
    }

    @Override
    public void visitTypeAlias(@NotNull FirTypeAlias typeAlias, boolean data2) {
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        FirDeclaration firDeclaration = typeAlias;
        String string2 = typeAlias.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"typeAlias.name.asString()");
        this.mangleSimpleDeclaration(firDeclaration, string2);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, boolean data) {
        Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
        if (this.isRealExpect) ** GOTO lbl-1000
        $this$isExpect$iv = simpleFunction;
        $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        this.isRealExpect = v0;
        $this$isStatic$iv = simpleFunction;
        $i$f$isStatic = false;
        isStatic = $this$isStatic$iv.getStatus().isStatic();
        this.mangleFunction(simpleFunction, false, isStatic, simpleFunction);
    }

    @Override
    public void visitConstructor(@NotNull FirConstructor constructor2, boolean data2) {
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        this.mangleFunction(constructor2, true, false, constructor2);
    }

    @Override
    public void visitPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor, boolean data2) {
        Intrinsics.checkNotNullParameter((Object)propertyAccessor, (String)"propertyAccessor");
        if (propertyAccessor instanceof FirSyntheticPropertyAccessor) {
            this.visitSimpleFunction(((FirSyntheticPropertyAccessor)propertyAccessor).getDelegate(), data2);
        } else {
            FirMemberDeclaration $this$isStatic$iv = propertyAccessor;
            boolean $i$f$isStatic = false;
            this.mangleFunction(propertyAccessor, false, $this$isStatic$iv.getStatus().isStatic(), (FirDeclaration)propertyAccessor.getPropertySymbol().getFir());
        }
    }

    @Override
    @NotNull
    public String computeMangle(@NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        declaration.accept(this, true);
        String string2 = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builder.toString()");
        return string2;
    }

    public static final /* synthetic */ void access$appendSignature(FirJvmMangleComputer $this, StringBuilder $receiver, String s) {
        $this.appendSignature($receiver, s);
    }

    public static final /* synthetic */ void access$mangleValueParameter(FirJvmMangleComputer $this, StringBuilder vpBuilder, FirValueParameter param) {
        $this.mangleValueParameter(vpBuilder, param);
    }

    public static final /* synthetic */ void access$mangleTypeParameter(FirJvmMangleComputer $this, StringBuilder tpBuilder, FirTypeParameter param, int index2) {
        $this.mangleTypeParameter(tpBuilder, param, index2);
    }

    public static final /* synthetic */ void access$mangleType(FirJvmMangleComputer $this, StringBuilder tBuilder, ConeKotlinType type2, FirSession declarationSiteSession) {
        $this.mangleType(tBuilder, type2, declarationSiteSession);
    }

    public static final /* synthetic */ void access$appendSignature(FirJvmMangleComputer $this, StringBuilder $receiver, char c) {
        $this.appendSignature($receiver, c);
    }
}

