/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.scope.processor;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStaticStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiConflictResolver;
import org.jetbrains.kotlin.com.intellij.psi.scope.conflictResolvers.DuplicateConflictResolver;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.MethodsProcessor;
import org.jetbrains.kotlin.com.intellij.psi.util.ImportsUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

public class MethodCandidatesProcessor
extends MethodsProcessor {
    boolean myHasAccessibleStaticCorrectCandidate;

    protected MethodCandidatesProcessor(@NotNull PsiElement place, PsiFile placeFile, PsiConflictResolver @NotNull [] resolvers, @NotNull List<CandidateInfo> container) {
        if (place == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(0);
        }
        if (container == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(1);
        }
        if (resolvers == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(2);
        }
        super(resolvers, container, place, placeFile);
    }

    public MethodCandidatesProcessor(@NotNull PsiElement place, PsiFile placeFile) {
        if (place == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(3);
        }
        super(new PsiConflictResolver[]{DuplicateConflictResolver.INSTANCE}, new SmartList<CandidateInfo>(), place, placeFile);
    }

    @Override
    public void add(@NotNull PsiElement element, @NotNull PsiSubstitutor substitutor2) {
        if (element == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(4);
        }
        if (substitutor2 == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(5);
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            this.addMethod(method, substitutor2, this.isInStaticScope() && !method.hasModifierProperty("static"));
        }
    }

    public void addMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, boolean staticProblem) {
        if (method == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(6);
        }
        if (substitutor2 == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(7);
        }
        boolean isAccessible = JavaResolveUtil.isAccessible(method, this.getContainingClass(method), method.getModifierList(), this.myPlace, this.myAccessClass, this.myCurrentFileContext, this.myPlaceFile) && !this.isShadowed(method);
        boolean problematicInterfaceStaticMethod = false;
        if (!(!this.isAccepted(method) || this.isInterfaceStaticMethodAccessibleThroughInheritance(method) && ImportsUtil.hasStaticImportOn(this.myPlace, method, true))) {
            PsiClass containingClass;
            if (!staticProblem && method.hasModifierProperty("static") && (containingClass = method.getContainingClass()) != null && containingClass.isInterface() && !(this.myAccessClass instanceof PsiTypeParameter) && !containingClass.getManager().areElementsEquivalent(this.myAccessClass, containingClass)) {
                if (this.myAccessClass != null) {
                    staticProblem = true;
                } else {
                    problematicInterfaceStaticMethod = true;
                }
            }
            this.add(this.createCandidateInfo(method, substitutor2, staticProblem, isAccessible, false));
            if (this.acceptVarargs() && method.isVarArgs() && PsiUtil.isLanguageLevel8OrHigher(this.myPlace)) {
                this.add(this.createCandidateInfo(method, substitutor2, staticProblem, isAccessible, true));
            }
            this.myHasAccessibleStaticCorrectCandidate |= isAccessible && !problematicInterfaceStaticMethod;
        }
    }

    private boolean isInterfaceStaticMethodAccessibleThroughInheritance(@NotNull PsiMethod method) {
        if (method == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(8);
        }
        if (method.hasModifierProperty("static") && !(this.myCurrentFileContext instanceof PsiImportStaticStatement) && this.myPlace instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)this.myPlace).getMethodExpression().getQualifierExpression() == null) {
            PsiClass containingClass = method.getContainingClass();
            return containingClass != null && containingClass.isInterface();
        }
        return false;
    }

    protected PsiClass getContainingClass(@NotNull PsiMethod method) {
        if (method == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(9);
        }
        return method.getContainingClass();
    }

    protected boolean acceptVarargs() {
        return false;
    }

    @NotNull
    protected MethodCandidateInfo createCandidateInfo(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, boolean staticProblem, boolean accessible, boolean varargs) {
        if (method == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(10);
        }
        if (substitutor2 == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(11);
        }
        return new VarargsAwareMethodCandidateInfo(method, substitutor2, accessible, staticProblem, this.getArgumentList(), this.myCurrentFileContext, this.getTypeArguments(), this.getLanguageLevel(), varargs);
    }

    private static PsiType @NotNull [] getExpressionTypes(@NotNull PsiExpressionList argumentList2) {
        if (argumentList2 == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(12);
        }
        PsiType[] psiTypeArray = argumentList2.getExpressionTypes();
        if (psiTypeArray == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(13);
        }
        return psiTypeArray;
    }

    protected boolean isAccepted(@NotNull PsiMethod candidate2) {
        if (candidate2 == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(14);
        }
        if (!this.isConstructor()) {
            return !candidate2.isConstructor() && candidate2.getName().equals(this.getName(ResolveState.initial()));
        }
        if (!candidate2.isConstructor()) {
            return false;
        }
        if (this.myAccessClass == null) {
            return true;
        }
        if (this.myAccessClass instanceof PsiAnonymousClass) {
            PsiClass containingClass = this.getContainingClass(candidate2);
            return containingClass != null && containingClass.equals(this.myAccessClass.getSuperClass());
        }
        return this.myAccessClass.isEquivalentTo(this.getContainingClass(candidate2));
    }

    private boolean isShadowed(@NotNull PsiMethod candidate2) {
        if (candidate2 == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(15);
        }
        if (this.myCurrentFileContext instanceof PsiImportStaticStatement) {
            for (JavaResolveResult result2 : this.getResults()) {
                if (result2.getElement() == candidate2 || !result2.isAccessible() || result2.getCurrentFileResolveScope() instanceof PsiImportStaticStatement) continue;
                return true;
            }
        }
        return false;
    }

    public CandidateInfo @NotNull [] getCandidates() {
        JavaResolveResult[] resolveResult = this.getResult();
        if (resolveResult.length == 0) {
            if (CandidateInfo.EMPTY_ARRAY == null) {
                MethodCandidatesProcessor.$$$reportNull$$$0(16);
            }
            return CandidateInfo.EMPTY_ARRAY;
        }
        CandidateInfo[] infos = new CandidateInfo[resolveResult.length];
        System.arraycopy(resolveResult, 0, infos, 0, resolveResult.length);
        if (infos == null) {
            MethodCandidatesProcessor.$$$reportNull$$$0(17);
        }
        return infos;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 16: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodCandidatesProcessor";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodCandidatesProcessor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionTypes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addMethod";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInterfaceStaticMethodAccessibleThroughInheritance";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createCandidateInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionTypes";
                break;
            }
            case 13: 
            case 16: 
            case 17: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAccepted";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isShadowed";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 13: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VarargsAwareMethodCandidateInfo
    extends MethodCandidateInfo {
        private final PsiExpressionList myArgumentList;
        private final boolean myVarargs;
        private PsiType[] myExpressionTypes;

        VarargsAwareMethodCandidateInfo(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor2, boolean accessible, boolean staticProblem, PsiExpressionList argumentList2, PsiElement context, PsiType[] arguments2, @NotNull LanguageLevel level, boolean varargs) {
            if (method == null) {
                VarargsAwareMethodCandidateInfo.$$$reportNull$$$0(0);
            }
            if (substitutor2 == null) {
                VarargsAwareMethodCandidateInfo.$$$reportNull$$$0(1);
            }
            if (level == null) {
                VarargsAwareMethodCandidateInfo.$$$reportNull$$$0(2);
            }
            super(method, substitutor2, !accessible, staticProblem, argumentList2, context, null, arguments2, level);
            this.myArgumentList = argumentList2;
            this.myVarargs = varargs;
        }

        @Override
        public PsiType[] getArgumentTypes() {
            if (this.myExpressionTypes == null && this.myArgumentList != null) {
                PsiType[] expressionTypes = MethodCandidatesProcessor.getExpressionTypes(this.myArgumentList);
                if (VarargsAwareMethodCandidateInfo.isOverloadCheck()) {
                    return expressionTypes;
                }
                this.myExpressionTypes = expressionTypes;
            }
            return this.myExpressionTypes;
        }

        @Override
        public boolean isVarargs() {
            return this.myVarargs;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "method";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "substitutor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "level";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodCandidatesProcessor$VarargsAwareMethodCandidateInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

