/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.StubBuildingVisitor;
import org.jetbrains.kotlin.com.intellij.util.Consumer;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Type;

final class AnnotationTextCollector
extends AnnotationVisitor {
    private final StringBuilder myBuilder = new StringBuilder();
    private final Function<@NotNull String, @NotNull String> myMapping;
    private final Consumer<? super String> myCallback;
    private boolean hasPrefix;
    private boolean hasParams;

    AnnotationTextCollector(@Nullable String desc, Function<String, String> mapping2, Consumer<? super String> callback) {
        super(589824);
        this.myMapping = mapping2;
        this.myCallback = callback;
        if (desc != null) {
            this.hasPrefix = true;
            this.myBuilder.append('@').append(StubBuildingVisitor.toJavaType(Type.getType(desc), this.myMapping));
        }
    }

    @Override
    public void visit(String name, Object value2) {
        this.valuePairPrefix(name);
        this.myBuilder.append(StubBuildingVisitor.constToString(value2, null, true, this.myMapping));
    }

    @Override
    public void visitEnum(String name, String desc, String value2) {
        this.valuePairPrefix(name);
        this.myBuilder.append(StubBuildingVisitor.toJavaType(Type.getType(desc), this.myMapping)).append('.').append(value2);
    }

    private void valuePairPrefix(String name) {
        if (!this.hasParams) {
            this.hasParams = true;
            if (this.hasPrefix) {
                this.myBuilder.append('(');
            }
        } else {
            this.myBuilder.append(',');
        }
        if (name != null) {
            this.myBuilder.append(name).append('=');
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        this.valuePairPrefix(name);
        return new AnnotationTextCollector(desc, this.myMapping, text2 -> this.myBuilder.append((String)text2));
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        this.valuePairPrefix(name);
        this.myBuilder.append('{');
        return new AnnotationTextCollector(null, this.myMapping, text2 -> this.myBuilder.append((String)text2).append('}'));
    }

    @Override
    public void visitEnd() {
        if (this.hasPrefix && this.hasParams) {
            this.myBuilder.append(')');
        }
        this.myCallback.consume(this.myBuilder.toString());
    }
}

