/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.util.UniquelyNamedThread;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipClassLoader
extends ClassLoader {
    static final Logger logger = LoggerFactory.getLogger(ZipClassLoader.class);
    private static final int OPEN_TIME = 5000;
    private static final int DEBUG = 0;
    private static final int REQUEST_FIND = 0;
    private static final int REQUEST_LOAD = 1;
    private final File zipPath;
    private final Map<String, Object> classes = new HashMap<String, Object>();
    private final Object bgLock = new Object();
    private WorkThread bgThread = null;

    public ZipClassLoader(File zipFile) {
        this.zipPath = zipFile;
    }

    public ZipClassLoader(String zipFileName) {
        this(new File(zipFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Class<?> findClass(String className) throws ClassNotFoundException {
        boolean found = false;
        Object result = null;
        Map<String, Object> map = this.classes;
        // MONITORENTER : map
        found = this.classes.containsKey(className);
        if (found) {
            result = this.classes.get(className);
        }
        // MONITOREXIT : map
        if (!found) {
            Object data;
            String resourceName = className.replace('.', '/') + ".class";
            result = this.request(1, resourceName);
            if (result instanceof byte[] && (result = this.defineClass(className, (byte[])(data = (byte[])result), 0, ((byte[])data).length)) == null) {
                result = new ClassFormatError(className);
            }
            Map<String, Object> map2 = this.classes;
            data = map2;
            // MONITORENTER : map2
            this.classes.put(className, result);
            // MONITOREXIT : data
        }
        if (result instanceof Class) {
            return (Class)result;
        }
        if (result instanceof ClassNotFoundException) {
            ClassNotFoundException classNotFoundEx = (ClassNotFoundException)result;
            throw classNotFoundEx;
        }
        if (!(result instanceof Error)) return super.findClass(className);
        Error error = (Error)result;
        throw error;
    }

    @Override
    public URL findResource(String resourceName) {
        URL url;
        Object ret = this.request(0, resourceName);
        return ret instanceof URL ? (url = (URL)ret) : super.findResource(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object request(int action, String resourceName) {
        Request request;
        Object object = this.bgLock;
        synchronized (object) {
            if (this.bgThread == null) {
                this.bgThread = new WorkThread();
                this.bgThread.start();
            }
            request = new Request(action, resourceName);
            this.bgThread.requests.addLast(request);
            this.bgLock.notifyAll();
        }
        return request.getResponse();
    }

    private class WorkThread
    extends UniquelyNamedThread {
        private final LinkedList<Request> requests;
        private ZipFile zipFile;

        WorkThread() {
            super("ZipClassLoader-WorkThread");
            this.requests = new LinkedList();
            this.zipFile = null;
        }

        private void ensureZipOpen() {
            if (this.zipFile == null) {
                try {
                    this.zipFile = new ZipFile(ZipClassLoader.this.zipPath);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void performFind(Request req) {
            this.ensureZipOpen();
            URL ret = null;
            try {
                String res;
                ZipEntry zipEntry;
                if (this.zipFile != null && (zipEntry = this.zipFile.getEntry(res = req.resource)) != null) {
                    String url = "jar:" + String.valueOf(ZipClassLoader.this.zipPath.toURI()) + "!/" + res;
                    ret = URI.create(url).toURL();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            req.setResponse(ret);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performLoad(Request req) {
            BufferedInputStream bis = null;
            this.ensureZipOpen();
            byte[] ret = null;
            try {
                ZipEntry zipEntry;
                if (this.zipFile != null && (zipEntry = this.zipFile.getEntry(req.resource)) != null) {
                    byte[] result = new byte[(int)zipEntry.getSize()];
                    bis = new BufferedInputStream(this.zipFile.getInputStream(zipEntry));
                    try {
                        bis.read(result, 0, result.length);
                        ret = result;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            req.setResponse(ret);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                block19: while (true) lbl-1000:
                // 5 sources

                {
                    if ((request = this.waitForNextRequest()) == null) {
                        return;
                    }
                    try {
                        switch (request.action) {
                            case 1: {
                                this.performLoad(request);
                                ** break;
                            }
                            case 0: {
                                this.performFind(request);
                                continue block19;
                            }
                            ** default:
lbl15:
                            // 1 sources

                            continue block19;
                        }
                    }
                    finally {
                        request.ensureDone();
                        continue;
                    }
                    break;
                }
                catch (Exception var1_2) {
                }
            }
            finally {
                if (this.zipFile != null) {
                    try {
                        this.zipFile.close();
                        this.zipFile = null;
                    }
                    catch (IOException var2_4) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Request waitForNextRequest() {
            Object object = ZipClassLoader.this.bgLock;
            synchronized (object) {
                long start = System.currentTimeMillis();
                while (this.requests.isEmpty()) {
                    long elapse = System.currentTimeMillis() - start;
                    if (elapse >= 5000L) {
                        ZipClassLoader.this.bgThread = null;
                        return null;
                    }
                    try {
                        ZipClassLoader.this.bgLock.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.requests.removeFirst();
            }
        }
    }

    private static class Request {
        final int action;
        final String resource;
        boolean responseSent;
        Object response;

        Request(int action, String resource) {
            this.action = action;
            this.resource = resource;
            this.responseSent = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ensureDone() {
            boolean aborted = false;
            Request request = this;
            synchronized (request) {
                if (!this.responseSent) {
                    aborted = true;
                    this.responseSent = true;
                    this.response = null;
                    this.notifyAll();
                }
            }
            if (aborted) {
                // empty if block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getResponse() {
            Request request = this;
            synchronized (request) {
                while (!this.responseSent) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.response;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setResponse(Object value) {
            Request request = this;
            synchronized (request) {
                this.response = value;
                this.responseSent = true;
                this.notifyAll();
            }
        }

        public String toString() {
            String act = this.action == 1 ? "load" : (this.action == 0 ? "find" : "act" + this.action);
            return act + ":" + this.resource;
        }
    }
}

