/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;

public class DisplayDecoder
extends InstanceFactory {
    public static final String _ID = "DisplayDecoder";
    private static final Attribute<Boolean> MULTI_BIT = Attributes.forBoolean("multibit", Strings.S.getter("ioMultiBit"));

    public static void computeDisplayDecoderOutputs(InstanceState state, int inputvalue, int aPortIndex, int bPortIndex, int cPortIndex, int dPortIndex, int ePortIndex, int fPortIndex, int gPortIndex, int LTPortIndex, int BIPortIndex, int RBIPortIndex) {
        if (state.getPortValue(BIPortIndex) == Value.FALSE) {
            inputvalue = 15;
        } else if (state.getPortValue(LTPortIndex) == Value.FALSE) {
            inputvalue = 8;
        } else if (state.getPortValue(RBIPortIndex) == Value.FALSE && inputvalue == 0) {
            inputvalue = 15;
        }
        switch (inputvalue) {
            case 0: {
                state.setPort(aPortIndex, Value.FALSE, 3);
                state.setPort(bPortIndex, Value.FALSE, 3);
                state.setPort(cPortIndex, Value.FALSE, 3);
                state.setPort(dPortIndex, Value.FALSE, 3);
                state.setPort(ePortIndex, Value.FALSE, 3);
                state.setPort(fPortIndex, Value.FALSE, 3);
                state.setPort(gPortIndex, Value.TRUE, 3);
                break;
            }
            case 1: {
                state.setPort(aPortIndex, Value.TRUE, 3);
                state.setPort(bPortIndex, Value.FALSE, 3);
                state.setPort(cPortIndex, Value.FALSE, 3);
                state.setPort(dPortIndex, Value.TRUE, 3);
                state.setPort(ePortIndex, Value.TRUE, 3);
                state.setPort(fPortIndex, Value.TRUE, 3);
                state.setPort(gPortIndex, Value.TRUE, 3);
                break;
            }
            case 2: {
                state.setPort(aPortIndex, Value.FALSE, 3);
                state.setPort(bPortIndex, Value.FALSE, 3);
                state.setPort(cPortIndex, Value.TRUE, 3);
                state.setPort(dPortIndex, Value.FALSE, 3);
                state.setPort(ePortIndex, Value.FALSE, 3);
                state.setPort(fPortIndex, Value.TRUE, 3);
                state.setPort(gPortIndex, Value.FALSE, 3);
                break;
            }
            case 3: {
                state.setPort(aPortIndex, Value.FALSE, 3);
                state.setPort(bPortIndex, Value.FALSE, 3);
                state.setPort(cPortIndex, Value.FALSE, 3);
                state.setPort(dPortIndex, Value.FALSE, 3);
                state.setPort(ePortIndex, Value.TRUE, 3);
                state.setPort(fPortIndex, Value.TRUE, 3);
                state.setPort(gPortIndex, Value.FALSE, 3);
                break;
            }
            case 4: {
                state.setPort(aPortIndex, Value.TRUE, 3);
                state.setPort(bPortIndex, Value.FALSE, 3);
                state.setPort(cPortIndex, Value.FALSE, 3);
                state.setPort(dPortIndex, Value.TRUE, 3);
                state.setPort(ePortIndex, Value.TRUE, 3);
                state.setPort(fPortIndex, Value.FALSE, 3);
                state.setPort(gPortIndex, Value.FALSE, 3);
                break;
            }
            case 5: {
                state.setPort(aPortIndex, Value.FALSE, 3);
                state.setPort(bPortIndex, Value.TRUE, 3);
                state.setPort(cPortIndex, Value.FALSE, 3);
                state.setPort(dPortIndex, Value.FALSE, 3);
                state.setPort(ePortIndex, Value.TRUE, 3);
                state.setPort(fPortIndex, Value.FALSE, 3);
                state.setPort(gPortIndex, Value.FALSE, 3);
                break;
            }
            case 6: {
                state.setPort(aPortIndex, Value.TRUE, 3);
                state.setPort(bPortIndex, Value.TRUE, 3);
                state.setPort(cPortIndex, Value.FALSE, 3);
                state.setPort(dPortIndex, Value.FALSE, 3);
                state.setPort(ePortIndex, Value.FALSE, 3);
                state.setPort(fPortIndex, Value.FALSE, 3);
                state.setPort(gPortIndex, Value.FALSE, 3);
                break;
            }
            case 7: {
                state.setPort(aPortIndex, Value.FALSE, 3);
                state.setPort(bPortIndex, Value.FALSE, 3);
                state.setPort(cPortIndex, Value.FALSE, 3);
                state.setPort(dPortIndex, Value.TRUE, 3);
                state.setPort(ePortIndex, Value.TRUE, 3);
                state.setPort(fPortIndex, Value.TRUE, 3);
                state.setPort(gPortIndex, Value.TRUE, 3);
                break;
            }
            case 8: {
                state.setPort(aPortIndex, Value.FALSE, 3);
                state.setPort(bPortIndex, Value.FALSE, 3);
                state.setPort(cPortIndex, Value.FALSE, 3);
                state.setPort(dPortIndex, Value.FALSE, 3);
                state.setPort(ePortIndex, Value.FALSE, 3);
                state.setPort(fPortIndex, Value.FALSE, 3);
                state.setPort(gPortIndex, Value.FALSE, 3);
                break;
            }
            case 9: {
                state.setPort(aPortIndex, Value.FALSE, 3);
                state.setPort(bPortIndex, Value.FALSE, 3);
                state.setPort(cPortIndex, Value.FALSE, 3);
                state.setPort(dPortIndex, Value.TRUE, 3);
                state.setPort(ePortIndex, Value.TRUE, 3);
                state.setPort(fPortIndex, Value.FALSE, 3);
                state.setPort(gPortIndex, Value.FALSE, 3);
                break;
            }
            case 10: {
                state.setPort(aPortIndex, Value.TRUE, 3);
                state.setPort(bPortIndex, Value.TRUE, 3);
                state.setPort(cPortIndex, Value.TRUE, 3);
                state.setPort(dPortIndex, Value.FALSE, 3);
                state.setPort(ePortIndex, Value.FALSE, 3);
                state.setPort(fPortIndex, Value.TRUE, 3);
                state.setPort(gPortIndex, Value.FALSE, 3);
                break;
            }
            case 11: {
                state.setPort(aPortIndex, Value.TRUE, 3);
                state.setPort(bPortIndex, Value.TRUE, 3);
                state.setPort(cPortIndex, Value.FALSE, 3);
                state.setPort(dPortIndex, Value.FALSE, 3);
                state.setPort(ePortIndex, Value.TRUE, 3);
                state.setPort(fPortIndex, Value.TRUE, 3);
                state.setPort(gPortIndex, Value.FALSE, 3);
                break;
            }
            case 12: {
                state.setPort(aPortIndex, Value.TRUE, 3);
                state.setPort(bPortIndex, Value.FALSE, 3);
                state.setPort(cPortIndex, Value.TRUE, 3);
                state.setPort(dPortIndex, Value.TRUE, 3);
                state.setPort(ePortIndex, Value.TRUE, 3);
                state.setPort(fPortIndex, Value.FALSE, 3);
                state.setPort(gPortIndex, Value.FALSE, 3);
                break;
            }
            case 13: {
                state.setPort(aPortIndex, Value.FALSE, 3);
                state.setPort(bPortIndex, Value.TRUE, 3);
                state.setPort(cPortIndex, Value.TRUE, 3);
                state.setPort(dPortIndex, Value.FALSE, 3);
                state.setPort(ePortIndex, Value.TRUE, 3);
                state.setPort(fPortIndex, Value.FALSE, 3);
                state.setPort(gPortIndex, Value.FALSE, 3);
                break;
            }
            case 14: {
                state.setPort(aPortIndex, Value.TRUE, 3);
                state.setPort(bPortIndex, Value.TRUE, 3);
                state.setPort(cPortIndex, Value.TRUE, 3);
                state.setPort(dPortIndex, Value.FALSE, 3);
                state.setPort(ePortIndex, Value.FALSE, 3);
                state.setPort(fPortIndex, Value.FALSE, 3);
                state.setPort(gPortIndex, Value.FALSE, 3);
                break;
            }
            case 15: {
                state.setPort(aPortIndex, Value.TRUE, 3);
                state.setPort(bPortIndex, Value.TRUE, 3);
                state.setPort(cPortIndex, Value.TRUE, 3);
                state.setPort(dPortIndex, Value.TRUE, 3);
                state.setPort(ePortIndex, Value.TRUE, 3);
                state.setPort(fPortIndex, Value.TRUE, 3);
                state.setPort(gPortIndex, Value.TRUE, 3);
                break;
            }
            default: {
                state.setPort(aPortIndex, Value.UNKNOWN, 3);
                state.setPort(bPortIndex, Value.UNKNOWN, 3);
                state.setPort(cPortIndex, Value.UNKNOWN, 3);
                state.setPort(dPortIndex, Value.UNKNOWN, 3);
                state.setPort(ePortIndex, Value.UNKNOWN, 3);
                state.setPort(fPortIndex, Value.UNKNOWN, 3);
                state.setPort(gPortIndex, Value.UNKNOWN, 3);
            }
        }
    }

    public static byte getdecval(InstanceState state, boolean multibit, int MultibitInputIndex, int Aindex, int Bindex, int Cindex, int Dindex) {
        byte decval = -1;
        int powval = 0;
        int[] inputindex = new int[]{Aindex, Bindex, Cindex, Dindex};
        if (!multibit && state.getPortValue(Aindex) != Value.UNKNOWN && state.getPortValue(Bindex) != Value.UNKNOWN && state.getPortValue(Cindex) != Value.UNKNOWN && state.getPortValue(Dindex) != Value.UNKNOWN) {
            for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
                if (state.getPortValue(inputindex[i]) != Value.TRUE) continue;
                powval = (byte)(powval | 1 << i);
            }
            decval = (byte)(decval + (byte)(powval + 1));
        } else if (multibit && state.getPortValue(MultibitInputIndex) != Value.UNKNOWN) {
            decval = (byte)state.getPortValue(MultibitInputIndex).toLongValue();
        }
        return decval;
    }

    public DisplayDecoder() {
        super(_ID, Strings.S.getter("DisplayDecoderComponent"));
        this.setAttributes(new Attribute[]{StdAttr.FACING, MULTI_BIT}, new Object[]{Direction.EAST, Boolean.TRUE});
        this.setFacingAttribute(StdAttr.FACING);
        this.setIconName("displaydecoder.gif");
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.updatePorts(instance);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Direction dir = attrs.getValue(StdAttr.FACING);
        int len = 80;
        int offs = -40;
        if (dir == Direction.NORTH) {
            return Bounds.create(-40, 0, 80, 40);
        }
        if (dir == Direction.SOUTH) {
            return Bounds.create(-40, -40, 80, 40);
        }
        if (dir == Direction.WEST) {
            return Bounds.create(0, -40, 40, 80);
        }
        return Bounds.create(-40, -40, 40, 80);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        instance.recomputeBounds();
        this.updatePorts(instance);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Direction dir = painter.getAttributeValue(StdAttr.FACING);
        Graphics g = painter.getGraphics();
        painter.drawBounds();
        Bounds bds = painter.getBounds();
        byte nports = (byte)(11 + (painter.getAttributeValue(MULTI_BIT) != false ? 1 : 4));
        Boolean multibit = painter.getAttributeValue(MULTI_BIT);
        String text = painter.getPortValue(7) == Value.FALSE ? "!" + Strings.S.get("memEnableLabel") : (painter.getPortValue(nports - 2) == Value.FALSE ? "BI" : (painter.getPortValue(nports - 3) == Value.FALSE ? "LI" : (painter.getPortValue(nports - 1) == Value.FALSE && DisplayDecoder.getdecval(painter, multibit, 8, 8, 9, 10, 11) == 0 ? "RBI" : (DisplayDecoder.getdecval(painter, multibit, 8, 8, 9, 10, 11) != -1 ? Integer.toString(DisplayDecoder.getdecval(painter, multibit, 8, 8, 9, 10, 11)) : "-"))));
        GraphicsUtil.drawCenteredText(g, text, bds.getX() + bds.getWidth() / 2, bds.getY() + bds.getHeight() / 2);
        for (int i = 0; i < nports - 3; i = (int)((byte)(i + 1))) {
            if (i == 7) continue;
            painter.drawPort(i);
        }
        g.setColor(Color.GRAY);
        painter.drawPort(7, Strings.S.get("memEnableLabel"), dir == Direction.NORTH || dir == Direction.SOUTH ? Direction.EAST : Direction.NORTH);
        if (dir == Direction.NORTH || dir == Direction.SOUTH) {
            painter.drawPort(nports - 3, Strings.S.get("LT"), Direction.WEST);
            painter.drawPort(nports - 2, Strings.S.get("BI"), Direction.WEST);
            painter.drawPort(nports - 1, Strings.S.get("RBI"), Direction.WEST);
        } else {
            painter.drawPort(nports - 3);
            painter.drawPort(nports - 2);
            painter.drawPort(nports - 1);
        }
    }

    @Override
    public void propagate(InstanceState state) {
        Boolean multibit = state.getAttributeValue(MULTI_BIT);
        byte nports = (byte)(11 + (state.getAttributeValue(MULTI_BIT) != false ? 1 : 4));
        if (state.getPortValue(7) != Value.FALSE) {
            DisplayDecoder.computeDisplayDecoderOutputs(state, DisplayDecoder.getdecval(state, multibit, 8, 8, 9, 10, 11), 0, 1, 2, 3, 4, 5, 6, nports - 3, nports - 2, nports - 1);
        }
    }

    private void updatePorts(Instance instance) {
        Direction dir = instance.getAttributeValue(StdAttr.FACING);
        boolean multibit = instance.getAttributeValue(MULTI_BIT) == Boolean.TRUE;
        byte in = (byte)(multibit ? 1 : 4);
        int out = 7;
        char cin = 'A';
        char cout = 'a';
        Port[] ps = new Port[in + out + 4];
        if (dir == Direction.NORTH || dir == Direction.SOUTH) {
            int i;
            byte y = (byte)(dir == Direction.NORTH ? 40 : -40);
            if (!multibit) {
                for (i = 8; i < in + 8; i = (int)((byte)(i + 1))) {
                    ps[i] = new Port(20 * (i - 8) - 30, (int)y, "input", 1);
                    ps[i].setToolTip(Strings.S.getter("DisplayDecoderInTip", "" + cin));
                    cin = (char)(cin + '\u0001');
                }
            } else {
                ps[8] = new Port(0, (int)y, "input", 4);
                ps[8].setToolTip(Strings.S.getter("DisplayDecoderInTip", "" + cin));
            }
            for (i = 0; i < out; i = (int)((byte)(i + 1))) {
                ps[i] = new Port(10 * i - 30, 0, "output", 1);
                ps[i].setToolTip(Strings.S.getter("DisplayDecoderOutTip", "" + cout));
                cout = (char)(cout + '\u0001');
            }
            ps[out] = new Port(-40, y / 2, "input", 1);
            ps[ps.length - 3] = new Port(40, y + (dir == Direction.NORTH ? -10 : 10), "input", 1);
            ps[ps.length - 2] = new Port(40, y + (dir == Direction.NORTH ? -20 : 20), "input", 1);
            ps[ps.length - 1] = new Port(40, y + (dir == Direction.NORTH ? -30 : 30), "input", 1);
        } else {
            int i;
            int x;
            int n = x = dir == Direction.EAST ? -40 : 40;
            if (!multibit) {
                for (i = 8; i < in + 8; i = (int)((byte)(i + 1))) {
                    ps[i] = new Port(x, 20 * (i - 8) - 30, "input", 1);
                    ps[i].setToolTip(Strings.S.getter("DisplayDecoderInTip", "" + cin));
                    cin = (char)(cin + '\u0001');
                }
            } else {
                ps[8] = new Port(x, 0, "input", 4);
                ps[8].setToolTip(Strings.S.getter("DisplayDecoderInTip", "" + cin));
            }
            for (i = 0; i < out; i = (int)((byte)(i + 1))) {
                ps[i] = new Port(0, 10 * i - 30, "output", 1);
                ps[i].setToolTip(Strings.S.getter("DisplayDecoderOutTip", "" + cout));
                cout = (char)(cout + '\u0001');
            }
            ps[out] = new Port(x / 2, -40, "input", 1);
            ps[ps.length - 3] = new Port(x + (dir == Direction.EAST ? 10 : -10), 40, "input", 1);
            ps[ps.length - 2] = new Port(x + (dir == Direction.EAST ? 20 : -20), 40, "input", 1);
            ps[ps.length - 1] = new Port(x + (dir == Direction.EAST ? 30 : -30), 40, "input", 1);
        }
        ps[out].setToolTip(Strings.S.getter("priorityEncoderEnableInTip"));
        ps[ps.length - 3].setToolTip(Strings.S.getter("LampTestInTip"));
        ps[ps.length - 2].setToolTip(Strings.S.getter("BlankingInputInTip"));
        ps[ps.length - 1].setToolTip(Strings.S.getter("RippleBlankingInputInTip"));
        instance.setPorts(ps);
    }
}

