/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io.extra;

import com.cburch.contracts.BaseMouseListenerContract;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.RadixOption;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstanceLogger;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.extra.ProgrammableGeneratorState;
import com.cburch.logisim.std.wiring.Probe;
import com.cburch.logisim.tools.MenuExtender;
import com.cburch.logisim.tools.key.DirectionConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ProgrammableGenerator
extends InstanceFactory {
    public static final String _ID = "ProgrammableGenerator";
    private static final Attribute<Integer> ATTR_NSTATE = Attributes.forIntegerRange("nState", Strings.S.getter("NStateAttr"), 1, 32);
    private static final ContentsAttribute CONTENTS_ATTR = new ContentsAttribute();
    public static final ProgrammableGenerator FACTORY = new ProgrammableGenerator();

    private static ProgrammableGeneratorState getState(com.cburch.logisim.comp.Component comp, CircuitState circ) {
        ProgrammableGeneratorState ret = (ProgrammableGeneratorState)circ.getData(comp);
        int nstate = comp.getAttributeSet().getValue(ATTR_NSTATE);
        if (ret == null) {
            ret = new ProgrammableGeneratorState(nstate);
            ret.decodeSavedData(comp.getAttributeSet().getValue(CONTENTS_ATTR));
            circ.setData(comp, ret);
        } else if (ret.updateSize(nstate)) {
            comp.getAttributeSet().setValue(CONTENTS_ATTR, ret.getSavedData());
        }
        CONTENTS_ATTR.setData(comp, circ);
        return ret;
    }

    private static ProgrammableGeneratorState getState(Instance state, CircuitState circ) {
        ProgrammableGeneratorState ret = (ProgrammableGeneratorState)state.getData(circ);
        int nstate = state.getAttributeValue(ATTR_NSTATE);
        if (ret == null) {
            ret = new ProgrammableGeneratorState(nstate);
            ret.decodeSavedData(state.getAttributeValue(CONTENTS_ATTR));
            state.setData(circ, ret);
        } else if (ret.updateSize(nstate)) {
            state.getAttributeSet().setValue(CONTENTS_ATTR, ret.getSavedData());
        }
        CONTENTS_ATTR.setData(state, circ);
        return ret;
    }

    private static ProgrammableGeneratorState getState(InstanceState state) {
        ProgrammableGeneratorState ret = (ProgrammableGeneratorState)state.getData();
        int nstate = state.getAttributeValue(ATTR_NSTATE);
        if (ret == null) {
            ret = new ProgrammableGeneratorState(nstate);
            ret.decodeSavedData(state.getAttributeValue(CONTENTS_ATTR));
            state.setData(ret);
        } else if (ret.updateSize(nstate)) {
            state.getAttributeSet().setValue(CONTENTS_ATTR, ret.getSavedData());
        }
        CONTENTS_ATTR.setData(state);
        return ret;
    }

    public static boolean tick(CircuitState circState, int ticks, com.cburch.logisim.comp.Component comp) {
        Value desired;
        ProgrammableGeneratorState state = ProgrammableGenerator.getState(comp, circState);
        state.incrementTicks();
        int durationHigh = state.getdurationHighValue();
        int statetick = state.getStateTick();
        Value value = desired = statetick - 1 < durationHigh ? Value.TRUE : Value.FALSE;
        if (!state.sending.equals(desired)) {
            state.sending = desired;
            Instance.getInstanceFor(comp).fireInvalidated();
            return true;
        }
        return false;
    }

    public ProgrammableGenerator() {
        super(_ID, Strings.S.getter("ProgrammableGeneratorComponent"));
        this.setAttributes(new Attribute[]{StdAttr.FACING, ATTR_NSTATE, StdAttr.LABEL, StdAttr.LABEL_LOC, StdAttr.LABEL_FONT, CONTENTS_ATTR}, new Object[]{Direction.EAST, 4, "", Direction.WEST, StdAttr.DEFAULT_LABEL_FONT, ""});
        this.setFacingAttribute(StdAttr.FACING);
        this.setInstanceLogger(ClockLogger.class);
        this.setInstancePoker(Poker.class);
        this.setIconName("programmablegenerator.gif");
        this.setKeyConfigurator(new DirectionConfigurator(StdAttr.LABEL_LOC, 512));
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        instance.setPorts(new Port[]{new Port(0, 0, "output", BitWidth.ONE)});
        instance.computeLabelTextField(8);
    }

    @Override
    protected Object getInstanceFeature(Instance instance, Object key) {
        if (key == MenuExtender.class) {
            return new ProgrammableGeneratorMenu(instance);
        }
        return super.getInstanceFeature(instance, key);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        return Probe.getOffsetBounds(attrs.getValue(StdAttr.FACING), BitWidth.ONE, RadixOption.RADIX_2, false, false);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.LABEL_LOC) {
            instance.computeLabelTextField(8);
        } else if (attr == StdAttr.FACING) {
            instance.recomputeBounds();
            instance.computeLabelTextField(8);
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        boolean drawUp;
        Graphics2D g = (Graphics2D)painter.getGraphics();
        Bounds bds = painter.getInstance().getBounds();
        int x = bds.getX();
        int y = bds.getY();
        painter.drawLabel();
        g.setColor(Color.BLACK);
        if (painter.getShowState()) {
            ProgrammableGeneratorState state = ProgrammableGenerator.getState(painter);
            painter.drawRoundBounds(state.sending.getColor());
            drawUp = state.sending == Value.TRUE;
        } else {
            painter.drawBounds();
            drawUp = true;
        }
        g.setColor(Color.WHITE);
        int[] xs = new int[]{(x += 10) + 1, x + 1, x + 4, x + 4, x + 7, x + 7};
        int[] ys = drawUp ? new int[]{y + 5, y + 3, y + 3, y + 7, y + 7, y + 5} : new int[]{(y += 10) + 5, y + 7, y + 7, y + 3, y + 3, y + 5};
        g.drawPolyline(xs, ys, xs.length);
        GraphicsUtil.switchToWidth(g, 2);
        xs = new int[]{x - 5, x - 5, x + 1, x + 1, x - 4};
        ys = new int[]{y + 5, y - 5, y - 5, y, y};
        g.drawPolyline(xs, ys, xs.length);
        painter.drawPorts();
    }

    @Override
    public void propagate(InstanceState state) {
        Value val = state.getPortValue(0);
        ProgrammableGeneratorState q = ProgrammableGenerator.getState(state);
        if (!val.equals(q.sending)) {
            state.setPort(0, q.sending, 1);
        }
    }

    private static class ContentsAttribute
    extends Attribute<String> {
        private InstanceState state = null;
        private Instance instance = null;
        private CircuitState circ = null;
        private com.cburch.logisim.comp.Component comp = null;

        private ContentsAttribute() {
            super("Contents", Strings.S.getter("romContentsAttr"));
        }

        @Override
        public Component getCellEditor(Window source, String value) {
            Project proj = null;
            if (source instanceof Frame) {
                proj = ((Frame)source).getProject();
            }
            ProgrammableGeneratorState data = null;
            if (this.state != null) {
                data = ProgrammableGenerator.getState(this.state);
            } else if (this.instance != null && this.circ != null) {
                data = ProgrammableGenerator.getState(this.instance, this.circ);
            } else if (this.comp != null && this.circ != null) {
                data = ProgrammableGenerator.getState(this.comp, this.circ);
            }
            ContentsCell ret = new ContentsCell(data);
            ret.mouseClicked(null);
            if (this.state != null && !data.getSavedData().equals(this.state.getAttributeValue(CONTENTS_ATTR))) {
                this.state.fireInvalidated();
                this.state.getAttributeSet().setValue(CONTENTS_ATTR, data.getSavedData());
                if (proj != null) {
                    proj.getLogisimFile().setDirty(true);
                }
            } else if (this.instance != null && !data.getSavedData().equals(this.instance.getAttributeValue(CONTENTS_ATTR))) {
                this.instance.fireInvalidated();
                this.instance.getAttributeSet().setValue(CONTENTS_ATTR, data.getSavedData());
                if (proj != null) {
                    proj.getLogisimFile().setDirty(true);
                }
            } else if (this.comp != null && this.circ != null && !data.getSavedData().equals(this.comp.getAttributeSet().getValue(CONTENTS_ATTR))) {
                this.circ.getInstanceState(this.comp).fireInvalidated();
                this.comp.getAttributeSet().setValue(CONTENTS_ATTR, data.getSavedData());
                if (proj != null) {
                    proj.getLogisimFile().setDirty(true);
                }
            }
            return ret;
        }

        @Override
        public String parse(String value) {
            return value;
        }

        void setData(com.cburch.logisim.comp.Component comp, CircuitState circ) {
            if (!comp.equals(this.comp)) {
                this.comp = comp;
            }
            if (!circ.equals(this.circ)) {
                this.circ = circ;
            }
        }

        void setData(Instance instance, CircuitState circ) {
            if (!instance.equals(this.instance)) {
                this.instance = instance;
            }
            if (!circ.equals(this.circ)) {
                this.circ = circ;
            }
        }

        void setData(InstanceState state) {
            if (!state.equals(this.state)) {
                this.state = state;
            }
        }

        @Override
        public String toDisplayString(String value) {
            return Strings.S.get("romContentsValue");
        }
    }

    public static abstract class ClockLogger
    extends InstanceLogger {
        @Override
        public String getLogName(InstanceState state, Object option) {
            return state.getAttributeValue(StdAttr.LABEL);
        }

        @Override
        public BitWidth getBitWidth(InstanceState state, Object option) {
            return BitWidth.ONE;
        }

        @Override
        public Value getLogValue(InstanceState state, Object option) {
            ProgrammableGeneratorState s = ProgrammableGenerator.getState(state);
            return s.sending;
        }
    }

    public static class Poker
    extends InstancePoker {
        @Override
        public void mouseReleased(InstanceState state, MouseEvent e) {
            Value desired;
            ProgrammableGeneratorState data = ProgrammableGenerator.getState(state);
            data.incrementTicks();
            int durationHigh = data.getdurationHighValue();
            int statetick = data.getStateTick();
            Value value = desired = statetick - 1 < durationHigh ? Value.TRUE : Value.FALSE;
            if (!data.sending.equals(desired)) {
                data.sending = desired;
                state.fireInvalidated();
            }
        }
    }

    private static class ProgrammableGeneratorMenu
    implements ActionListener,
    MenuExtender {
        private JMenuItem edit;
        private JMenuItem reset;
        private final Instance instance;
        private CircuitState circState;

        public ProgrammableGeneratorMenu(Instance instance) {
            this.instance = instance;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ProgrammableGeneratorState data = ProgrammableGenerator.getState(this.instance, this.circState);
            if (evt.getSource() == this.edit) {
                data.editWindow();
            } else if (evt.getSource() == this.reset) {
                data.clearValues();
            }
            if (!data.getSavedData().equals(this.instance.getAttributeValue(CONTENTS_ATTR))) {
                this.instance.fireInvalidated();
                this.instance.getAttributeSet().setValue(CONTENTS_ATTR, data.getSavedData());
                this.circState.getProject().getLogisimFile().setDirty(true);
            }
        }

        @Override
        public void configureMenu(JPopupMenu menu, Project proj) {
            this.circState = proj.getCircuitState();
            boolean enabled = this.circState != null;
            this.edit = this.createItem(enabled, Strings.S.get("ramEditMenuItem"));
            this.reset = this.createItem(enabled, Strings.S.get("ramClearMenuItem"));
            menu.addSeparator();
            menu.add(this.edit);
            menu.add(this.reset);
        }

        private JMenuItem createItem(boolean enabled, String label) {
            JMenuItem ret = new JMenuItem(label);
            ret.setEnabled(enabled);
            ret.addActionListener(this);
            return ret;
        }
    }

    public static class ContentsCell
    extends JLabel
    implements BaseMouseListenerContract {
        private static final long serialVersionUID = -53754819096800664L;
        private final ProgrammableGeneratorState data;

        ContentsCell(ProgrammableGeneratorState data) {
            super(Strings.S.get("romContentsValue"));
            this.data = data;
            this.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.data == null) {
                return;
            }
            this.data.editWindow();
        }
    }
}

