/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.instance.InstanceDataSingleton;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.io.IoLibrary;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SevenSegmentShape
extends DynamicElement {
    static final int[][] SEGMENTS = new int[][]{{3, 1, 6, 2}, {9, 3, 2, 6}, {9, 11, 2, 6}, {3, 17, 6, 2}, {1, 11, 2, 6}, {1, 3, 2, 6}, {3, 9, 6, 2}};

    public SevenSegmentShape(int x, int y, DynamicElement.Path p) {
        super(p, Bounds.create(x, y, 14, 20));
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return UnmodifiableList.create(new Attribute[]{ATTR_LABEL, StdAttr.LABEL_FONT, StdAttr.LABEL_COLOR});
    }

    @Override
    public void paintDynamic(Graphics g, CircuitState state) {
        Color offColor = this.path.leaf().getAttributeSet().getValue(IoLibrary.ATTR_OFF_COLOR);
        Color onColor = this.path.leaf().getAttributeSet().getValue(IoLibrary.ATTR_ON_COLOR);
        Color bgColor = this.path.leaf().getAttributeSet().getValue(IoLibrary.ATTR_BACKGROUND);
        int x = this.bounds.getX();
        int y = this.bounds.getY();
        int w = this.bounds.getWidth();
        int h = this.bounds.getHeight();
        GraphicsUtil.switchToWidth(g, 1);
        if (bgColor.getAlpha() != 0) {
            g.setColor(bgColor);
            g.fillRect(x, y, w, h);
        }
        g.setColor(Color.BLACK);
        g.drawRect(x, y, w, h);
        g.setColor(Color.DARK_GRAY);
        int summ = 0;
        int desired = 1;
        if (state != null) {
            InstanceDataSingleton data = (InstanceDataSingleton)this.getData(state);
            summ = data == null ? 0 : (Integer)data.getValue();
            Boolean activ = this.path.leaf().getAttributeSet().getValue(IoLibrary.ATTR_ACTIVE);
            desired = activ == null || activ != false ? 1 : 0;
        }
        g.setColor(Color.DARK_GRAY);
        for (int i = 0; i <= 7; ++i) {
            if (state != null) {
                g.setColor((summ >> i & 1) == desired ? onColor : offColor);
            }
            if (i < 7) {
                int[] seg = SEGMENTS[i];
                g.fillRect(x + seg[0], y + seg[1], seg[2], seg[3]);
                continue;
            }
            g.fillOval(x + 11, y + 17, 2, 2);
        }
        this.drawLabel(g);
    }

    @Override
    public Element toSvgElement(Document doc) {
        return this.toSvgElement(doc.createElement("visible-sevensegment"));
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("sevenSegmentComponent");
    }

    public String toString() {
        return "Seven Segment:" + String.valueOf(this.getBounds());
    }
}

