/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.tools;

import com.cburch.draw.actions.ModelAddAction;
import com.cburch.draw.canvas.Canvas;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.tools.AbstractTool;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

abstract class RectangularTool
extends AbstractTool {
    private boolean active = false;
    private Location dragStart;
    private int lastMouseX;
    private int lastMouseY;
    private Bounds currentBounds = Bounds.EMPTY_BOUNDS;

    private Bounds computeBounds(Canvas canvas, int mx, int my, int mods) {
        boolean shiftDown;
        boolean ctrlDown;
        this.lastMouseX = mx;
        this.lastMouseY = my;
        if (!this.active) {
            return Bounds.EMPTY_BOUNDS;
        }
        Location start = this.dragStart;
        int x0 = start.getX();
        int y0 = start.getY();
        int x1 = mx;
        int y1 = my;
        if (x0 == x1 && y0 == y1) {
            return Bounds.EMPTY_BOUNDS;
        }
        boolean bl = ctrlDown = (mods & 0x80) != 0;
        if (ctrlDown) {
            x0 = canvas.snapX(x0);
            y0 = canvas.snapY(y0);
            x1 = canvas.snapX(x1);
            y1 = canvas.snapY(y1);
        }
        boolean altDown = (mods & 0x200) != 0;
        boolean bl2 = shiftDown = (mods & 0x40) != 0;
        if (altDown) {
            if (shiftDown) {
                r = Math.min(Math.abs(x0 - x1), Math.abs(y0 - y1));
                x1 = x0 + r;
                y1 = y0 + r;
                x0 -= r;
                y0 -= r;
            } else {
                x0 -= x1 - x0;
                y0 -= y1 - y0;
            }
        } else if (shiftDown) {
            r = Math.min(Math.abs(x0 - x1), Math.abs(y0 - y1));
            y1 = y1 < y0 ? y0 - r : y0 + r;
            x1 = x1 < x0 ? x0 - r : x0 + r;
        }
        int x = x0;
        int y = y0;
        int w = x1 - x0;
        int h = y1 - y0;
        if (w < 0) {
            x = x1;
            w = -w;
        }
        if (h < 0) {
            y = y1;
            h = -h;
        }
        return Bounds.create(x, y, w, h);
    }

    public abstract CanvasObject createShape(int var1, int var2, int var3, int var4);

    @Override
    public void draw(Canvas canvas, Graphics gfx) {
        Bounds bds = this.currentBounds;
        if (this.active && bds != null && bds != Bounds.EMPTY_BOUNDS) {
            gfx.setColor(Color.GRAY);
            this.drawShape(gfx, bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
        }
    }

    public abstract void drawShape(Graphics var1, int var2, int var3, int var4, int var5);

    public abstract void fillShape(Graphics var1, int var2, int var3, int var4, int var5);

    @Override
    public Cursor getCursor(Canvas canvas) {
        return Cursor.getPredefinedCursor(1);
    }

    @Override
    public void keyPressed(Canvas canvas, KeyEvent e) {
        int code = e.getKeyCode();
        if (this.active && (code == 16 || code == 18 || code == 17)) {
            this.updateMouse(canvas, this.lastMouseX, this.lastMouseY, e.getModifiersEx());
        }
    }

    @Override
    public void keyReleased(Canvas canvas, KeyEvent e) {
        this.keyPressed(canvas, e);
    }

    @Override
    public void mouseDragged(Canvas canvas, MouseEvent e) {
        this.updateMouse(canvas, e.getX(), e.getY(), e.getModifiersEx());
    }

    @Override
    public void mousePressed(Canvas canvas, MouseEvent e) {
        Location loc = Location.create(e.getX(), e.getY(), false);
        Bounds bds = Bounds.create(loc);
        this.dragStart = loc;
        this.lastMouseX = loc.getX();
        this.lastMouseY = loc.getY();
        this.active = canvas.getModel() != null;
        this.repaintArea(canvas, bds);
    }

    @Override
    public void mouseReleased(Canvas canvas, MouseEvent e) {
        if (this.active) {
            Bounds oldBounds = this.currentBounds;
            Bounds bds = this.computeBounds(canvas, e.getX(), e.getY(), e.getModifiersEx());
            this.currentBounds = Bounds.EMPTY_BOUNDS;
            this.active = false;
            CanvasObject add = null;
            if (bds.getWidth() != 0 && bds.getHeight() != 0) {
                CanvasModel model = canvas.getModel();
                add = this.createShape(bds.getX(), bds.getY(), bds.getWidth(), bds.getHeight());
                canvas.doAction(new ModelAddAction(model, add));
                this.repaintArea(canvas, oldBounds.add(bds));
            }
            canvas.toolGestureComplete(this, add);
        }
    }

    private void repaintArea(Canvas canvas, Bounds bds) {
        canvas.repaint();
    }

    @Override
    public void toolDeselected(Canvas canvas) {
        Bounds bds = this.currentBounds;
        this.active = false;
        this.repaintArea(canvas, bds);
    }

    private void updateMouse(Canvas canvas, int mx, int my, int mods) {
        Bounds oldBounds = this.currentBounds;
        Bounds bds = this.computeBounds(canvas, mx, my, mods);
        if (!bds.equals(oldBounds)) {
            this.currentBounds = bds;
            this.repaintArea(canvas, oldBounds.add(bds));
        }
    }
}

