/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedSupertypeExtendedByOtherSupertypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirQualifiedSupertypeExtendedByOtherSupertypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirQualifiedSupertypeExtendedByOtherSupertypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedSupertypeExtendedByOtherSupertypeChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class FirQualifiedSupertypeExtendedByOtherSupertypeChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirQualifiedSupertypeExtendedByOtherSupertypeChecker INSTANCE = new FirQualifiedSupertypeExtendedByOtherSupertypeChecker();

    private FirQualifiedSupertypeExtendedByOtherSupertypeChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Object it;
        FirSuperReference firSuperReference;
        FirReference firReference;
        block10: {
            block9: {
                FirSuperReference firSuperReference2;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.QualifiedSupertypeMayBeExtendedByOtherSupertype)) {
                    return;
                }
                firReference = expression2.getCalleeReference();
                FirSuperReference firSuperReference3 = firSuperReference2 = firReference instanceof FirSuperReference ? (FirSuperReference)firReference : null;
                if (firSuperReference2 == null) break block9;
                firSuperReference = firSuperReference2;
                it = firSuperReference;
                boolean bl = false;
                FirReference firReference2 = firReference = ReferenceUtilsKt.hadExplicitTypeInSource((FirSuperReference)it) ? firSuperReference : null;
                if (firReference != null) break block10;
            }
            return;
        }
        FirReference superReference = firReference;
        it = FirHelpersKt.toClassLikeSymbol(((FirSuperReference)superReference).getSuperTypeRef(), context.getSession());
        firSuperReference = it != null ? DeclarationUtilsKt.fullyExpandedClass(it, context.getSession()) : null;
        FirClassSymbol firClassSymbol = firSuperReference instanceof FirClassSymbol ? (FirClassSymbol)((Object)firSuperReference) : null;
        if (firClassSymbol == null) {
            return;
        }
        FirClassSymbol explicitType = firClassSymbol;
        FirClass firClass = FirHelpersKt.findClosestClassOrObject(context);
        if (firClass == null) {
            return;
        }
        FirClass surroundingType = firClass;
        int count = 0;
        FirClassSymbol candidate2 = null;
        for (FirTypeRef it2 : surroundingType.getSuperTypeRefs()) {
            FirClassSymbol that;
            FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.toClassLikeSymbol(it2, context.getSession());
            FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol != null ? DeclarationUtilsKt.fullyExpandedClass(firClassLikeSymbol, context.getSession()) : null;
            if ((firRegularClassSymbol instanceof FirClassSymbol ? (FirClassSymbol)firRegularClassSymbol : null) == null) continue;
            that = that;
            boolean isSupertype = FirHelpersKt.isSupertypeOf(explicitType, that, context.getSession());
            if (!Intrinsics.areEqual((Object)explicitType, (Object)that) && !isSupertype) continue;
            if (isSupertype) {
                candidate2 = that;
            }
            if (++count < 2) continue;
        }
        if (count >= 2 && candidate2 != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirSuperReference)superReference).getSuperTypeRef().getSource(), FirErrors.INSTANCE.getQUALIFIED_SUPERTYPE_EXTENDED_BY_OTHER_SUPERTYPE(), candidate2, (DiagnosticContext)context, null, 16, null);
        }
    }
}

