#include "cameraDrv.h"

camI2cCfg_t gc6133_1sdrRegInfo[] = 
{
	// SYS
	{0xfe, 0xa0},
	{0xfe, 0xa0},
	{0xfe, 0xa0},
	{0xf6, 0x00},
	{0xfa, 0x11},
	{0xfc, 0x12},
	{0xfe, 0x00},
	{0xfe, 0x00},
	{0x49, 0x70},
	{0x4a, 0x40},
	{0x4b, 0x5d},
	
	// ANALOG & CISCTL
	{0x03, 0x00},
	{0x04, 0xfa},
	{0x01, 0x41},
	{0x02, 0x12},
	{0x0f, 0x01},
	{0x0d, 0x30},
	{0x12, 0xc8},
	{0x14, 0x54},
	{0x15, 0x32},
	{0x16, 0x04},
	{0x17, 0x19},
	{0x1d, 0xb9},
	{0x1f, 0x35},
	{0x7a, 0x00},
	{0x7b, 0x14},
	{0x7d, 0x36},
	{0xfe, 0x10},

	/*ISP*/            
	{0x20, 0x7e},
	{0x22, 0xb8},
	{0x24, 0x54},
	{0x26, 0xa7},
	{0x39, 0x00},
	{0x3a, 0x80},
	{0x3b, 0x01},
	{0x3c, 0x40},
	{0x3e, 0xf0},

	/*BLK*/         
	{0x2a, 0x2f},
	{0x37, 0x46},

	/*GAIN*/
	{0x3f, 0x18}, 

	/*DNDD*/    
	{0x50, 0x3c},
	{0x52, 0x4f},
	{0x53, 0x81},
	{0x54, 0x43},
	{0x56, 0x78},
	{0x57, 0xaa},
	{0x58, 0xff},

	/*ASDE*/           
	{0x5b, 0x60},
	{0x5c, 0x80},
	{0xab, 0x28},
	{0xac, 0xb5},
					   
	/*INTPEE*/        
	{0x60, 0x45},
	{0x62, 0x68},
	{0x63, 0x13},
	{0x64, 0x43},

	/*CC*/           
	{0x65, 0x13},
	{0x66, 0x26},
	{0x67, 0x07},
	{0x68, 0xf5},
	{0x69, 0xea},
	{0x6a, 0x21},
	{0x6b, 0x21},
	{0x6c, 0xe4},
	{0x6d, 0xfb},
				
	/*YCP*/          
	{0x81, 0x30},
	{0x82, 0x30},
	{0x83, 0x4a},
	{0x85, 0x06},
	{0x8d, 0x78},
	{0x8e, 0x25},
			 
	/*AEC*/       
	{0x90, 0x38},
	{0x92, 0x36},
	{0x9d, 0x32},
	{0x9e, 0x61},
	{0x9f, 0xf4},
	{0xa3, 0x28},
	{0xa4, 0x01},
					
	/*AWB*/         
	{0xb1, 0x1e},
	{0xb3, 0x20},
	{0xbd, 0x70},
	{0xbe, 0x58},
	{0xbf, 0xa0},
	{0x43, 0xa8},
	{0xb0, 0xf2},
	{0xb5, 0x40},
	{0xb8, 0x05},
	{0xba, 0x60}, 

	/*Banding*/
	{0x01, 0x41},
	{0x02, 0x12},
	{0x0f, 0x01},
	{0x9d, 0x32},
	{0x9e, 0x61},
	{0x9f, 0xf4},

	/*SPI*/          
	{0xfe, 0x02},
	{0x01, 0x01},
	{0x02, 0x02},
	{0x03, 0x20},
	{0x04, 0x20},
	{0x0a, 0x00},
	{0x13, 0x10},
	{0x24, 0x00},
	{0x28, 0x03},
			  
	/*OUTPUT*/        
	{0xfe, 0x00},
	{0x22, 0xf8},
	{0xf1, 0x03},

};

uint16_t gc6133GetRegCnt(char* regName)
{
    if (strcmp(regName, "gc6133_1sdr") == 0)
    {
        return (sizeof(gc6133_1sdrRegInfo) / sizeof(gc6133_1sdrRegInfo[0]));
    }
    
    return 0;
}


