<?php

/*
 * This file is part of Chevere.
 *
 * (c) Rodolfo Berrios <rodolfo@chevere.org>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Chevere\Parameter\Attributes;

use Attribute;
use Chevere\Parameter\Interfaces\IntParameterInterface;
use Chevere\Parameter\Interfaces\ParameterAttributeInterface;
use Chevere\Parameter\Interfaces\ParameterInterface;
use Chevere\Parameter\Traits\AttrTrait;
use function Chevere\Parameter\int;

#[Attribute(Attribute::TARGET_PROPERTY | Attribute::TARGET_PARAMETER | Attribute::TARGET_CLASS_CONSTANT)]
class IntAttr implements ParameterAttributeInterface
{
    use AttrTrait;

    private IntParameterInterface $parameter;

    /**
     * @param int[] $accept
     * @param int[] $reject
     */
    public function __construct(
        string $description = '',
        ?int $default = null,
        ?int $min = null,
        ?int $max = null,
        array $accept = [],
        array $reject = [],
        bool $sensitive = false
    ) {
        $this->parameter = int(
            description: $description,
            default: $default,
            min: $min,
            max: $max,
            accept: $accept,
            reject: $reject,
            sensitive: $sensitive
        );
    }

    public function __invoke(int $int): int
    {
        return $this->parameter->__invoke($int);
    }

    public function parameter(): ParameterInterface
    {
        return $this->parameter;
    }
}
