DROP TABLE IF EXISTS `%table_prefix%users`;
CREATE TABLE `%table_prefix%users` (
  `user_id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_name` VARCHAR(255) DEFAULT NULL,
  `user_username` VARCHAR(255) NOT NULL,
  `user_date` DATETIME NOT NULL,
  `user_date_gmt` DATETIME NOT NULL,
  `user_email` VARCHAR(255) DEFAULT NULL,
  `user_avatar_filename` VARCHAR(255) DEFAULT NULL,
  `user_facebook_username` VARCHAR(255) DEFAULT NULL,
  `user_twitter_username` VARCHAR(255) DEFAULT NULL,
  `user_website` VARCHAR(255) DEFAULT NULL,
  `user_background_filename` VARCHAR(255) DEFAULT NULL,
  `user_bio` VARCHAR(255) DEFAULT NULL,
  `user_timezone` VARCHAR(255) NOT NULL,
  `user_language` VARCHAR(255) DEFAULT NULL,
  `user_status` ENUM('valid','awaiting-confirmation','awaiting-email','banned') NOT NULL,
  `user_is_admin` TINYINT UNSIGNED NOT NULL DEFAULT '0',
  `user_is_manager` TINYINT UNSIGNED NOT NULL DEFAULT '0',
  `user_is_private` TINYINT UNSIGNED NOT NULL DEFAULT '0',
  `user_palette_id` INT UNSIGNED NOT NULL DEFAULT '0',
  `user_newsletter_subscribe` TINYINT UNSIGNED NOT NULL DEFAULT '1',
  `user_show_nsfw_listings` TINYINT UNSIGNED NOT NULL DEFAULT '0',
  `user_image_count` INT UNSIGNED NOT NULL DEFAULT '0',
  `user_album_count` INT UNSIGNED NOT NULL DEFAULT '0',
  `user_image_keep_exif` TINYINT UNSIGNED NOT NULL DEFAULT '1',
  `user_file_meta_tag_camera_model` TINYINT UNSIGNED NOT NULL DEFAULT '1',
  `user_image_expiration` VARCHAR(255) DEFAULT NULL,
  `user_registration_ip` VARCHAR(255) NOT NULL,
  `user_likes` INT UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Likes made to content owned by this user',
  `user_liked` INT UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Likes made by this user',
  `user_following` INT UNSIGNED NOT NULL DEFAULT '0',
  `user_followers` INT UNSIGNED NOT NULL DEFAULT '0',
  `user_content_views` INT UNSIGNED NOT NULL DEFAULT '0',
  `user_notifications_unread` INT UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `username` (`user_username`(191)) USING BTREE,
  UNIQUE KEY `email` (`user_email`(191)) USING BTREE,
  KEY `user_date_gmt` (`user_date_gmt`),
  KEY `user_status` (`user_status`),
  KEY `user_is_admin` (`user_is_admin`),
  KEY `user_is_manager` (`user_is_manager`),
  KEY `user_is_private` (`user_is_private`),
  KEY `user_palette_id` (`user_palette_id`),
  KEY `user_newsletter_subscribe` (`user_newsletter_subscribe`),
  KEY `user_show_nsfw_listings` (`user_show_nsfw_listings`),
  KEY `user_image_count` (`user_image_count`),
  KEY `user_album_count` (`user_album_count`),
  KEY `user_image_keep_exif` (`user_image_keep_exif`),
  KEY `user_file_meta_tag_camera_model` (`user_file_meta_tag_camera_model`),
  KEY `user_image_expiration` (`user_image_expiration`),
  KEY `user_registration_ip` (`user_registration_ip`),
  KEY `user_likes` (`user_likes`),
  KEY `user_following` (`user_following`),
  KEY `user_followers` (`user_followers`),
  KEY `user_liked` (`user_liked`),
  KEY `user_content_views` (`user_content_views`),
  FULLTEXT KEY `searchindex` (`user_name`,`user_username`)
) ENGINE=%table_engine% DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;
