###################################
### GENERIC AND CUSTOM DIALOGUE ###
###################################

## All girl dialogues are stored as Dialogue objects, in the dialogue dictionary. The dictionary is accessed with the 'get_dialogue()' method from the Girl object.
## Special syntax (temp), used only for dialogues: gname, MCname, ...


## Dialogue labels ##

label dialogue(char, topic, key="generic", custom_arg=False, nw=False, narrator_mode=False): # for Girl objects only. custom_arg is broken for now
    # In narrator_mode, dialogue will be said by the narrator instead of the girl char
    if isinstance(char, Girl):
        $ char.job_cn = girl_related_dict[char.job]
        $ char.say(topic, custom_arg=custom_arg, nw=nw, narrator_mode=narrator_mode) # No key is provided for girls, it is instead generated according to personality and other filters
    else:
        $ pick_dialogue(topic, key=key).say(char, nw=nw)
    return


label dialogue_say_multiple(char, lines): # Where char is a renpy Character object (doesn't have to be a Girl)

    $ _lines = list(lines)

    while _lines:
        $ line = _lines.pop(0)

        if line.startswith("g: "):
            $ line = line[3:]
            $ renpy.say(char, __(line))
        elif line.startswith("mc: "):
            $ line = line[4:]
            $ renpy.say(you, __(line))
        elif line.startswith("giz: "):
            $ line = line[4:]
            $ renpy.say(gizel, __(line))
        else:
            $ renpy.say(narrator, __(line))

    return

## Dialogue class ##

init -3 python:

    class Dialogue(object):

        def __init__(self, line, multiple=False, love=0, fear=0, mood=0, min_cap=None, max_cap=None, changes=[], sound=None, unlock=None):

            self.line = line # one line of dialogue, or a list of lines (if set to multiple)
            self.multiple = multiple # advanced dialogue where several lines are prononced.
            # Multiple dialogue only: MC lines must start with 'mc: '. Girl lines must start with 'g: '. Other lines will be pronounced by the narrator.
            self.love = love
            self.fear = fear
            self.min_cap = min_cap # The dialogue cannot change the love/fear cannot lower than this value (if not None)
            self.max_cap = max_cap # The dialogue cannot change the love/fear cannot lower than this value (if not None)
            self.mood = mood
            if changes == None: changes = []
            self.changes = changes # Changes is a list of tuples (stat, value) where stat can be a main or sexual skill name in lower case (like 'beauty'), 'mood', 'love', 'fear', 'energy', 'rep', 'xp', 'jp' (for the current job), 'X jp' where X is a job name, or 'X preference' where X is a trainable sex act
            self.sound = sound
            self.unlock = unlock

        def say(self, char, custom_arg=False, nw=False): # Starts dialogue
            # Sounds are played at the start of dialogue
            if self.sound:
                renpy.play(self.sound, "sound")
            if self.multiple:
                renpy.call("dialogue_say_multiple", char, self.line)
            # elif custom_arg: # Only works with one-liners # Not functional, replaced with variable name between [], which works well enough with Ren'py
            #     renpy.say(char, self.line % custom_arg)
            else:
                # try: # Temporarily disabled, see how it behaves
                if nw:
                    renpy.say(char, __(self.line), interact=False)
                else:
                    renpy.say(char, __(self.line))
                # except:
                #     renpy.say(char, event_color["bad"] % ("Dialogue KO: " + str(self.line)))

        def apply_changes(self, girl):
            if self.love:
                girl.change_love(self.love, min_cap=self.min_cap, max_cap=self.max_cap)
            if self.fear:
                girl.change_fear(self.fear, min_cap=self.min_cap, max_cap=self.max_cap)
            if self.mood:
                girl.change_mood(self.mood)
            if self.unlock:
                girl.personality_unlock[self.unlock] += 15 + MC.get_charisma() + dice(10)
            if self.changes:
                chg_note = ""
                for stat, chg in self.changes:
                    chg = girl.change_stat(stat, chg)
                    if chg > 0:
                       chg_note += "\n" + __(stat.capitalize()) + " increased" # To do: try and find a way to color this string
                    elif chg < 0:
                        chg_note += "\n" + __(stat.capitalize()) + " decreased"

                renpy.notify(chg_note)

## Dialogue functions ##

    def get_dialogue(topic, key="generic"): # Returns a list of dialogue objects for this topic and key
        if dialogue_dict[topic][key]:
            return dialogue_dict[topic][key]
        else:
            return [Dialogue("No dialogue found for " + topic + "/" + key)]

    def pick_dialogue(topic, key="generic"): # Picks a random dialogue object
        return rand_choice(get_dialogue(topic, key))

    # Creates the regular dialogue dictionary. Mods can add to this dictionary using the 'add_dialogue()' function.

    def add_dialogue(topic, keys="generic", lines="", multiple=False, love=0, fear=0, mood=0, min_cap=None, max_cap=None, changes=[], sound=None, unlock=None):
        # topic is a unique id that refers to a specific bit of conversation during a game interaction
        # keys can be a personality, a personality attribute, a list of personalities or attributes, or 'generic'
        # lines is a line or list of lines to be pronounced
        # if multiple is set to False, each line in lines will be added as a separate entry.
        # if multiple is set to True, all lines in lines will be prononced in succession (advanced dialogue)
        # love, fear and mood modifiers will apply when the line of dialogue is called
        # several Dialogue objects can be added for the same topic/key: the game will randomly pick one

        keys = make_list(keys)
        lines = make_list(lines)

        for key in keys:
            if multiple:
#                 try: # if the dictionary entry already exists (several Dialogue objects can co-exist for one topic/key: the game will randomly pick one)
                dialogue_dict[topic][key].append(Dialogue(lines, multiple=True, love=love, fear=fear, mood=mood, min_cap=min_cap, max_cap=max_cap, changes=changes, sound=sound, unlock=unlock))
#                 except: # creates the dictionary entry otherwise
#                     dialogue_dict[topic][key] = [Dialogue(lines, multiple=True)]

            else:
                for line in lines:
#                     try: # if the dictionary entry already exists (several Dialogue objects can co-exist for one topic/key: the game will randomly pick one)
                    dialogue_dict[topic][key].append(Dialogue(line, love=love, fear=fear, mood=mood, min_cap=min_cap, max_cap=max_cap, changes=changes, sound=sound, unlock=unlock))
#                     except: # creates the dictionary entry otherwise
#                         dialogue_dict[topic][key] = [Dialogue(line)]


#### INIT GAME DIALOGUE ####
## Modders can add new dialogue by using the 'add_dialogue' function in an init block
#汉化标签，等待润色校对#
init -1 python:

    ## Dialogue dictionary ##

    dialogue_dict = defaultdict(return_ddict_list) # Nested defaultdicts with lists

    ### FREE GIRL DIALOGUE ###

    add_dialogue("free_greetings_polite", ("superficial", "rebel", "sweet"), "天哪，我没想到会在这里遇到一位真正的绅士!*笑*我叫 [girl.fullname]. 见到你很高兴.", love=2)
    add_dialogue("free_greetings_polite", ("cold", "masochist"), "...{w=1} 我叫 [girl.fullname]. 我不需要帮助.")
    add_dialogue("free_greetings_polite", "generic", "呃?你不必这么正式... 我叫 [girl.fullname].", love=1)

    add_dialogue("free_greetings_casual", ("meek", "nerd", "cold"), "噢,嗨。我是 [girl.fullname]. 很高兴见到你.", love=2)
    add_dialogue("free_greetings_casual", ("superficial", "pervert"), ("g: 天呐，你也太下头了?你就不能换一个更有创意的借口吗?", "g: 我的名字是 [girl.fullname]. 现在, 给我滚开."), multiple=True)
    add_dialogue("free_greetings_casual", "generic", "看来你很直白，不是吗?嗨,我是 [girl.fullname].", love=1)

    add_dialogue("free_greetings_rude", ("lewd"), "啊哈, 一个忠于欲望的男人... *微笑* 我的名字是 [girl.fullname]. 见到你很高兴.", love=2)
    add_dialogue("free_greetings_rude", ("superficial", "cold"), "噢,嗨。我 [girl.fullname].", love=1)
    add_dialogue("free_greetings_rude", "generic", "你在说什么! *怒吼*. 我的名字是 [girl.fullname], 我不喜欢你的举止!")

    add_dialogue("free_small_talk", ("pervert", "rebel"), "*哈欠* 说完了？这太无聊了.")
    add_dialogue("free_small_talk", ("meek", "masochist"), "哦，你说得对, 哈哈...", love=2, max_cap=25)
    add_dialogue("free_small_talk", ("generic"), "嗯，是的，当然...", love=1, max_cap=25)

    add_dialogue("free_gossip", ("nerd", "sweet"), "是么，不过我不太在乎流言蜚语.")
    add_dialogue("free_gossip", ("superficial", "rebel"), "听说了吗?我有大把有趣的八卦要告诉你!", love=2, max_cap=25)
    add_dialogue("free_gossip", ("generic"), "我听到了一些有趣的消息...", love=1, max_cap=25)

    add_dialogue("free_chat_life", ("superficial", "meek"), "哦，我不知道。这算哪门子问题啊?")
    add_dialogue("free_chat_life", ("cold", "nerd"), "有趣的问题!这是我想到的一个理论...", love=2, max_cap=25)
    add_dialogue("free_chat_life", ("generic"), "这是个很难回答的问题。我想我应该思考一下...", love=1, max_cap=25)

    add_dialogue("free_chat_love", ("cold", "masochist"), "并不多。我不相信爱情.")
    add_dialogue("free_chat_love", ("pervert", "sweet"), "当然，我在等我的骑士... *咯咯笑*", love=2, max_cap=25)
    add_dialogue("free_chat_love", ("generic"), "每个人都需要找到自己的伴侣. 也许有一天我也会?", love=1, max_cap=25)

    add_dialogue("free_chat_origins", ("generic"), ("我来自于 [girl.origin].", "我出生在 [girl.origin].", "我的父母住在 [girl.origin]."), love=1, max_cap=40) # Argument is girl.origin

    add_dialogue("free_chat_hobbies", ("generic"), ("我真的很喜欢 [hobby].", "我的爱好吗?那一定是 [hobby].", "我喜欢 [hobby], 我可以一整天都这么做."), love=1, max_cap=40) # Argument is hobby
    add_dialogue("free_chat_likes", ("generic"), ("我最喜欢的 [thing_cn] 是 [best]."), love=1, max_cap=40) # Argument is 'thing', 'favourite'
    add_dialogue("free_chat_dislikes", ("generic"), ("我不喜欢的 [thing_cn] 是 [worst]. Ew!", "我讨厌的 [thing_cn] 是 [worst]."), love=1, max_cap=40) # Argument is 'thing', 'least favourite'

    add_dialogue("free_joke_harmless", ("very dom"), "... 你就到此为止了吗?", love=-1, max_cap=50)
    add_dialogue("free_joke_harmless", ("very sub"), "嘻嘻嘻! 很好玩!", love=3, max_cap=50)
    add_dialogue("free_joke_harmless", ("generic"), "不错, 不错...", love=1, max_cap=50)

    add_dialogue("free_joke_adult", ("very modest"), "我不喜欢这个段子。你让我感觉恶心.", love=-1, max_cap=50)
    add_dialogue("free_joke_adult", ("very lewd"), "哦，你真幽默... *咯咯笑*", love=3, max_cap=50)
    add_dialogue("free_joke_adult", ("generic"), "不错, 不错...", love=1, max_cap=50)

    add_dialogue("free_joke_dark", ("very extravert"), "哇, 真地狱啊！你在家会敲木鱼吗! *皱眉*", love=-1, max_cap=50)# 英语谐音梗，翻不明白
    add_dialogue("free_joke_dark", ("very introvert"), "呣哈哈哈哈! 我喜欢这种笑话.", love=3, max_cap=50)
    add_dialogue("free_joke_dark", ("generic"), "不错, 不错...", love=1, max_cap=50)

    add_dialogue("free_joke_mean", ("very idealist"), "垃圾... 闭嘴吧! *生气*", love=-1, max_cap=50)
    add_dialogue("free_joke_mean", ("very materialist"), "啊, 你好坏哦... *咯咯笑*", love=3, max_cap=50)
    add_dialogue("free_joke_mean", ("generic"), "不错, 不错...", love=1, max_cap=50)

    add_dialogue("free_touch_hand", ("pervert", "cold"), "嘿，放开我的手。你以为你是谁.", love=-1, max_cap=90)
    add_dialogue("free_touch_hand", ("sweet", "meek", "superficial"), "这感觉... 还行...", love=3, max_cap=90)
    add_dialogue("free_touch_hand", ("generic"), "握紧了，别松开，这很浪漫...", love=2, max_cap=90)

    add_dialogue("free_touch_kiss", ("pervert", "masochist"), ["她把你推开.", "g:你是突然想要浪漫起来吗?你很奇怪."], multiple=True, love=-1, max_cap=90)
    add_dialogue("free_touch_kiss", ("sweet", "meek", "nerd"), ["当她热情地回吻你时，你们的舌头交缠在一起.", "g: 嗯... 呣..."], multiple=True, love=3, max_cap=90)
    add_dialogue("free_touch_kiss", ("generic"), ["她给了你一个轻轻的吻.", "g: 好啦，下次再给你更好的..."], multiple=True, love=2, max_cap=90)

    add_dialogue("free_touch_ass", ("rebel", "superficial"), "放手!你这个变态!我要报警了！ *生气*", love=-1, max_cap=90)
    add_dialogue("free_touch_ass", ("nerd", "cold", "masochist"), "啊! 别摸那里... *脸红*", love=3, max_cap=90)
    add_dialogue("free_touch_ass", ("generic"), "你的小手不是很干净啊... *咯咯笑*", love=2, max_cap=90)

    add_dialogue("free_touch_breasts", ("nerd", "cold"), "你在干什么?快住手！", love=-1, max_cap=90)
    add_dialogue("free_touch_breasts", ("rebel", "pervert", "superficial"), "呣呣... 感觉真舒服... *脸红*", love=3, max_cap=90)
    add_dialogue("free_touch_breasts", ("generic"), "噢...你的手法很娴熟，难道你是个按摩师傅？", love=2, max_cap=90)

    add_dialogue("free_touch_pussy", ("meek", "sweet"), "不!别碰我那里!", love=-1, max_cap=90)
    add_dialogue("free_touch_pussy", ("masochist", "pervert", "rebel"), "噢!! 呣... 噢...那里很脏的... *脸红*", love=3, max_cap=90)
    add_dialogue("free_touch_pussy", ("generic"), "你干嘛摸人家那里啊!", love=2, max_cap=90)

    add_dialogue("free_play refuses", ("generic"), "没门!滚开!!!", love=-1)
    add_dialogue("free_play very reluctant", ("generic"), "虽然我并不喜欢这么做...不过为了你，我愿意尝试", love=1, sound=s_sigh)
    add_dialogue("free_play reluctant", ("generic"), "噗... 好吧, 如果你 {i}真的想{/i} 这么做的话...", love=2, sound=s_sigh)
    add_dialogue("free_play a little reluctant", ("generic"), "噗... 好吧, 如果你 {i}期待{/i} 已久...", love=2, sound=s_sigh)
    add_dialogue("free_play indifferent", ("generic"), "嗯呣... 好吧...但是我说停你就得停", love=3)
    add_dialogue("free_play a little interested", ("generic"), "你早就等着这么一天了吧...", love=4, sound=s_mmh)
    add_dialogue("free_play interested", ("generic"), "呵呵，有点意思，让我们试试...", love=4, sound=s_mmh)
    add_dialogue("free_play very interested", ("generic"), "噢...*抿嘴唇*你想要这样玩...", love=5, sound=s_mmh)
    add_dialogue("free_play fascinated", ("generic"), "光是听你说我的那里都已经湿透了...", love=5, sound=s_mmh)

    add_dialogue("MC take virginity", ("generic"), "你是我的第一个男人...", love=5)

    add_dialogue("free_play interested after", ("generic"), "我喜欢这样... *脸红*")
    add_dialogue("free_play not interested after", ("generic"), "嗯...你现在满意了吗?")

    add_dialogue("free_flirt_beauty", ("masochist"), "你的马屁拍错人了.", love=-1, max_cap=75)
    add_dialogue("free_flirt_beauty", ("rebel"), "哼, 你觉得我是那种很容易就被骗上床的女人?", love=-1, max_cap=75)
    add_dialogue("free_flirt_beauty", ("superficial", "sweet"), "谢谢，看来你的审美很不错!", love=2, max_cap=75)
    add_dialogue("free_flirt_beauty", ("generic"), "哦，谢谢夸奖.", love=1, max_cap=75)

    add_dialogue("free_flirt_body", ("masochist"), "少多管闲事...", love=-1, max_cap=75)
    add_dialogue("free_flirt_body", ("nerd", "sweet"), "闭嘴!你这个无耻之徒 *生气*", love=-1, max_cap=75)
    add_dialogue("free_flirt_body", ("pervert", "meek", "superficial"), "你真的这么认为吗?看来你眼光不错嘛...", love=2, max_cap=75)
    add_dialogue("free_flirt_body", ("generic"), "哈哈! *微笑*", love=1, max_cap=75)

    add_dialogue("free_flirt_mind", ("masochist"), "你有透视眼是吗，你以为你很懂...", love=-1, max_cap=75)
    add_dialogue("free_flirt_mind", ("pervert", "superficial"), "是啊，这句陈词滥调我听过一千遍了... *无聊*", love=-1, max_cap=75)
    add_dialogue("free_flirt_mind", ("sweet", "nerd", "cold"), "终于有人在乎我的内在，而不仅仅是我的长相!", love=2, max_cap=75)
    add_dialogue("free_flirt_mind", ("generic"), "嘿，你的嘴巴可真甜啊...", love=1, max_cap=75)

    add_dialogue("free_flirt_spirit", ("masochist"), "好土的搭讪...", love=-1, max_cap=75)
    add_dialogue("free_flirt_spirit", ("meek"), "你....你在取笑我。你的意思是... *眼含泪水*", love=-1, max_cap=75)
    add_dialogue("free_flirt_spirit", ("sweet", "rebel"), "嘿，我感觉和你在一起总是很放松...", love=2, max_cap=75)
    add_dialogue("free_flirt_spirit", ("generic"), "谢谢夸奖!", love=1, max_cap=75)


    add_dialogue("free_flirt_sex_experience very experienced", "generic", ["她眨了眨眼，笑着说.", "g: 你太小看我了!我也许比你想的还要大胆~"], multiple=True, love=3, sound=s_laugh)
    add_dialogue("free_flirt_sex_experience experienced", "generic", ["她伸出舌头.", "g: 当然，我有些经验... *眨眼*"], multiple=True, love=2)
    add_dialogue("free_flirt_sex_experience average", "generic", ["她脸色有些红.", "g: 这个话题有点私人....不过我想我的第一次属于你，喜欢吗?"], multiple=True, love=1, sound=s_sigh)
    add_dialogue("free_flirt_sex_experience inexperienced", "generic", ["她脸红得发烫.", "g: 嘿，不是那样的!我有过男朋友，只是他还没机会和我...."], multiple=True, sound=s_surprise)
    add_dialogue("free_flirt_sex_experience very inexperienced", "generic", ["她给了你一个天真的眼神.", "g: 我不太明白你的意思?你是说...", "她皱眉."], multiple=True, love=-1)

    add_dialogue("free_flirt_sex_experience virgin", "lewd", "我从来没有... 你知道，和男人{i}做过{/i} 。我很想知道那是什么感觉... *脸红*")
    add_dialogue("free_flirt_sex_experience virgin", "generic", "我不是荡妇，你知道的!我不是，我只是在等那个对的人.")

    add_dialogue("free_flirt_sex_experience reply_waiting success", ("idealist"), "真的吗?亲爱的，我们就像灵魂伴侣...", love=3)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("materialist"), "真的吗?会不会是你不太受女生欢迎?至少你是我的...", love=2)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("lewd"), "哦,真的吗?找点乐子也无妨，你知道的....我很高兴有一天我能给你看... *眨眼*", love=2)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("pervert"), "哦! 这太无聊!", love=-1)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("modest"), "你以为我会相信吗?你一定觉得我很好骗...", love=-2)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("generic"), "嘶, 你这话听着也太假了! *眨眼*")

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("modest", "idealist"), "噢... 我想成为你的唯一，我会让你开心的!", love=2)
    add_dialogue("free_flirt_sex_experience reply_not_many success", ("modest", "materialist"), "噢. 我想这很正常，毕竟你是个正常的男人...", love=2)
    add_dialogue("free_flirt_sex_experience reply_not_many success", ("lewd"), "好吧，至少你不是一无是处! *眨眼*", love=1)
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("modest"), "你以为我会相信吗?你一定觉得我很好骗...", love=-1)
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("generic"), ("她伸出舌头.", "g: 就几个，嗯?也许有十几个? *眨眼*"), multiple=True)

    add_dialogue("free_flirt_sex_experience reply_been_around", ("very modest"), "好吧, 其实我不知道.", love=-1)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("modest"), "噢...")
    add_dialogue("free_flirt_sex_experience reply_been_around", ("lewd"), "我明白了...我相信我们可以一起学习...", love=1)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("very lewd"), "啊，你的嘴还是这么甜!也许我们可以试试更刺激的...", love=2)

    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("modest"), "噁, 你好恶心!", love=-1)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("modest", "materialist"), "我希望你没说过这句话。但男人都是大猪蹄子，所以我想这也很正常.")
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("lewd"), "嘿，你就不怕得病？你这只狗... *嘲笑*", love=2)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("pervert"), "有趣...你在这方面真是天赋异禀...", love=3)
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("modest"), ["g: 哈哈。你....你在开玩笑吧?", "mc: 嗯...当然!"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("generic"), "大话连篇，但你能证明吗?我不这么想。", love=-1)

    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("modest", "idealist"), "我知道...我想这是意料之中的... *叹气*")
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("modest", "materialist"), "别对我脸做文章!我的男朋友是个皮条客已经够糟糕的了，不用你提醒我。", love=-1)
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("lewd"), "好吧，等你变得更加熟练后再来更好地满足我...", love=2)
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("very lewd"), "嗯，你应该一直努力在你的工作中做到最好，不是吗? *微笑*", love=3)

    add_dialogue("free_flirt_sex_act refuses", "generic", ["她给了你一个天真的眼神.", "g: 说实话，我不知道你在说什么."], multiple=True, sound=s_surprise)
    add_dialogue("free_flirt_sex_act very reluctant", "generic", ["她厌恶地看了你一眼.", "g: 这方面我知之甚少。还是讨论点别的吧."], multiple=True, love=-1)
    add_dialogue("free_flirt_sex_act reluctant", "generic", ["她皱眉.", "g: 这不是我最喜欢的。我知道有些人很喜欢，但是..."], multiple=True)
    add_dialogue("free_flirt_sex_act a little reluctant", "generic", ["她皱眉.", "g: 这不是我最喜欢的。我知道有些人很喜欢，但是..."], multiple=True)
    add_dialogue("free_flirt_sex_act indifferent", "generic", ["她想了一会儿.", "g: 哦,好吧...我想我不介意..."], multiple=True, love=1)
    add_dialogue("free_flirt_sex_act a little interested", "generic", ["她脸色变红.", "g: Hmmm... 别谈这个，我会忍不住的..."], multiple=True, love=2)
    add_dialogue("free_flirt_sex_act interested", "generic", ["她脸色变红.", "g: Hmmm... 别谈这个，我会忍不住的..."], multiple=True, love=2)
    add_dialogue("free_flirt_sex_act very interested", "generic", ["她舔了舔嘴唇.", "g: 非得让我亲口说出来嘛，我喜欢....这是我最喜欢的事情之一."], multiple=True, love=3, sound=s_mmh)
    add_dialogue("free_flirt_sex_act fascinated", "generic", ["她舔了舔嘴唇.", "g: 非得让我亲口说出来嘛，我喜欢....这是我最喜欢的事情之一."], multiple=True, love=3, sound=s_mmh)

    add_dialogue("free_give_gold +++", "generic", "哦，这太多了!由衷地感谢你....我真的很需要这笔钱...", love=5, max_cap=75)
    add_dialogue("free_give_gold ++", "generic", "这么多钱，你可真是个慈善家!", love=3, max_cap=75)
    add_dialogue("free_give_gold +", "generic", "谢谢你，你向我展示了你的善意。", love=2, max_cap=75)
    add_dialogue("free_give_gold -", "generic", "你为什么要给我这些?你觉得我是那种轻浮的女人?")
    add_dialogue("free_give_gold --", "generic", "给我钱，是吗?你觉得我是个有钱就会张开腿的婊子吗? *生气*", love=-1, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("meek", "superficial", "very sub"), ["她开始哭泣.", "g: 听起来很可怕!我不想....哦，我该怎么办呢...", "g: 如....如果我到你那，你会好好照顾我吗?"], multiple=True, love=-5)
    add_dialogue("free_offer_job no_lie", ("rebel", "very dom"), ["她怒视了你一眼.", "g: 让我做妓女?你疯了吗?!", "mc: 考虑到你的选择，你还有选择吗?", "g: 什么....这太糟糕了。希望能帮我摆脱困境吧。"], multiple=True, love=-2)
    add_dialogue("free_offer_job no_lie", ("generic"), ["她用新发现的决心看着你.", "g: 除了做妓女没别的路可走了吗...", "g: 我很高兴你告诉了我真相。让我思考一下。", "g: 你...我想我可以?"], multiple=True, love=1)
    add_dialogue("free_offer_job no_lie", ("masochist", "pervert", "very lewd"), ["她好奇地看了你一眼.", "g: 你一定认为我是个下流的婊子，对吗?", "mc: 哎呀...", "g: 也许你说的没错...Mmmh...", "她咬着嘴唇.", "g: 如果我在那里工作，我每天都要和不同的人上床，对吧?"], multiple=True, love=3)

    add_dialogue("free_offer_job half_lie", ("masochist", "pervert"), ["g: 你之前不是说你是个...", "mc: 对不起我撒谎了...", "g: 这比我想象的有趣多了...你为什么瞒着我!!我讨厌欺骗...", "g: 所以如果我在你那里工作，我就可以整晚都和陌生人随便做爱，对吗? Hmm..."], multiple=True)
    add_dialogue("free_offer_job half_lie", ("generic"), ["g: 你从没告诉过我你是做这个的!", "mc: 放轻松, 这并不重要...", "g: 那里的女孩们....他们....为了钱出卖自己的身体，是吗?"], multiple=True, love=-2)

    add_dialogue("free_offer_job lie", ("idealist"), ["g: 你说什么?", "g: 你这个该死的骗子!!! 我怎么会相信你!!! *哭喊*", "g: 哦，这太可怕了....我最后的希望破灭了....为你工作能有什么好处?", "mc: 好吧, 我会保护你，包吃包住还有可观的薪水...", "g: 我该怎么办?你没有骗我吗?"], multiple=True, love=-5)
    add_dialogue("free_offer_job lie", ("very materialist"), ["g: 啊哈，所以你一直在骗我，是吗?你做到了。", "g: 可是其他人会怎么想...", "g: 为你工作会是个好主意吗?"], multiple=True, love=3)
    add_dialogue("free_offer_job lie", ("generic"), ["g: Oh, 所以你撒谎了...", "g: 我做梦都没想到会是这样... 我，变成妓女?", "mc: 嘛, 有些女孩更喜欢用'陪客'这个词...", "g: 陪客吗?听上去总比妓女强多了。", "g: 所以你不是 [girl.MC_lied], 不过也没那么糟糕，对吧?我的意思是..."], multiple=True)

    add_dialogue("free_offer_job success", ("idealist"), ["g: 好吧，我会照你说的做。反正我也无路可走了...", "g: 我是你的人了。带我去青楼吧。"], multiple=True)
    add_dialogue("free_offer_job success", ("materialist"), "好吧。听起来没有拒绝的理由，成交!")

    add_dialogue("free_offer_job thinking", ("generic"), ["g: 你的待遇很诱人，但...", "g: 我还没做好心理准备。肯定还有其他办法...", "她离开了，看起来她有认真思考你说的话。"], multiple=True)

    add_dialogue("free_offer_job failure lie", ("generic"), ["g: 你这卑鄙的家伙，我就知道!你以为你能骗到我？!", "g: 你骗了我，现在你还想让我在你的破青楼陪客!想都别想!", "g: 你给我滚!", "她离开了，看起来很生气.", "mc: 万事开头难。等她冷静下来再说吧?"], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("generic"), ["g: 你早就等着这么一天了是不是!你以为我是什么人!", "g: 你以为我不骂那些贱人我就和她们是同一类人?", "g: 你怎么有脸来找我!", "她离开了，看起来很生气.", "mc: 好事多磨。等她冷静下来再说吧?"], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("modest"), ["g: 这，这是对女性的剥削啊!大错特错!", "mc: 但至少它很赚钱，不是吗?", "g: 呃, 我..."], multiple=True, love=-5)
    add_dialogue("free_friend no_lie", ("very lewd"), ["g: 哦, 太神奇了! !你一定要让我去看看，我太好奇了!我可以去吗?", "mc: 好的, 当然... 那你呢，你是做什么的?", "g:  我吗?最近很忙，没做什么..."], multiple=True, love=5)
    add_dialogue("free_friend no_lie", ("generic"), ["g: 是这样吗?呃，我想那是一份很好的工作...", "mc: 你是做什么的?", "g: ..."], multiple=True)

    add_dialogue("free_friend half_lie", ("very idealist", "rebel"), ["g: 一个 [MC.playerclass]? 哦, 太棒了!你可以教我一些把戏吗!", "mc: 没问题, 当然... 你呢，你是做什么的?", "她的情绪有点低落。", "g: 额, 就像你一样，我也在找工作..."], multiple=True, love=2)
    add_dialogue("free_friend half_lie", ("generic"), ["g: 原来如此。冒险家在这里很常见。", "mc: 那你呢，你是做什么的?", "g: 我吗?猜猜看,嗯哼..."], multiple=True)

    add_dialogue("free_friend lie", ("very introvert"), ["她冷漠地看着你。", "g: 真的吗?奇怪。我从来没听说过你。你说的是实话吗?", "mc: 嗯,嗯...哦，天色不早了，哈哈!我真的得走了."], multiple=True, love=-5)
    add_dialogue("free_friend lie", ("very extrovert"), ["g: 真的吗?这太棒了!这是一份好工作，不是吗?", "mc: 是的, 当然...", "g: 哦，也许你需要一位美女助手，你可以雇佣我! *眨眼*"], multiple=True, love=5)
    add_dialogue("free_friend lie", ("generic"), ["g: 一个... [lie]? 我知道了.", "mc: 哈哈, 当然... 你呢，你是做什么的?", "g: 哦，你知道的，这个那个..."], multiple=True)

    add_dialogue("free_love_interest", "generic", ["mc: 嗨, [girl.name]. 发生什么事了?", "g: 哦, 我? 不... 我只是看着情侣们在这个美好的 [season] 亲吻、拥抱...", "g: 哦, 我? 没什么... 我只是看着情侣们在这个美好的 [season] 亲吻、牵手...", "g: 啊, 我现在感到有些孤独...", "g: 你知道吗?男孩给女孩送花，向她们表白。这是一个很好的暗示方法...", "mc: 还有这种事?"], multiple=True, fear=-5)

#     add_dialogue("free_girl get_flowers", "generic", "This is very romantic... Was there something you wanted from me?") # Had to disable this for now
    add_dialogue("free_ask_out", "generic", ["mc: [girl.name], 我喜欢你。做我的女朋友吧！", "g: 你想让我...做你的女朋友?", "mc: 没错。", "g: 为什么不, 你终于说出口了! 我答应你!", "她扑进你的怀抱，给了你一个深吻。", "g: 今天可能有点晚了，不过你会约我的对吧，帅哥! *眨眼*"], multiple=True)

    add_dialogue("free_girlfriend intro", "generic", ["g: 哦, [MC.name]! 快过来，亲爱的...", "mc: 嗨,我的挚爱。你今天过的怎么样?", "g: 我很好，亲爱的...跟我来，我想给你看点东西...", "mc: 什么, 好的...", "g: 不过首先，我要烤烤你。"], multiple=True, fear=-5)
    add_dialogue("free_girlfriend right", "generic", "没想到你还记得这种小事，你真的很在意我。")
    add_dialogue("free_girlfriend give_up", "generic", "哦,你再想想?我想我们还是再互相了解了解彼此吧... *皱眉*", love=-5)
    add_dialogue("free_girlfriend wrong", "generic", ["g: 你这是随便蒙了一个吧!大错特错!!你根本没把我放在心上... *生气*", "mc: 呃, 呃, 对不起..."], multiple=True, love=-10)
    add_dialogue("free_girlfriend success", "generic", ["她伸出双手，身上的衣服滑落，她紧张地凝视着你的眼睛。", "g: 你喜欢我的身体吗?", "你的裤子已经顶起了帐篷。她似乎注意到了，并微微一笑。", "g: 舔嘴唇..."], multiple=True, sound=s_dress)
    add_dialogue("free_girlfriend success naked", "generic", ["她扯下胸口的衣物，捧起胸部，指尖在乳首上摩擦旋转，你倒吸了一口气。", "g: 你知道让整个身体和自然融为一体是什么感受吗?", "g: 当我摆脱衣服的束缚时，我总是觉得很舒服。要是能一直裸体该有多好!", "g: 但我当然不会光着身子在镇上转悠... *叹气* 我可没疯。", "g: 不过，我很高兴能向你展示真实的自我，你看起来也很开心! *咯咯笑*"], multiple=True, sound=s_sigh)

    add_dialogue("free_job_request", "very sub", ["g: Oh, [MC.name], 太可怕了... *抽泣*", "mc: 宝贝，发生什么事了?", "g: 收债的人...他们把我们从房子里赶了出来...还有母亲...她生病了...我哥哥却说他们没有多余的食物可以养活我们...", "g: 现在只剩我一个人了。我可能会被饿死，或者被恶棍抓走并被强奸和杀害!", "她突然哭了起来.", "mc: [girl.name] 冷静下来，我们会找到解决办法的..."], multiple=True, fear=-5)
    add_dialogue("free_job_request", "very idealist", ["g: 哦, [MC.name]. 你知道有什么渠道能赚到些快钱吗*满头大汗*?", "mc: 嗯，可能有吧... 发生了什么事?", "g: 是学校。家里最近出了点问题，我必须想办法支付下学期的学费才能继续学习，但我所有的积蓄都用完了！*焦急*", "g: 如果我没办法支付学费，我就得辍学，失去接受教育的机会...", "她看起来很担心.", "mc: 可能有个工作... 工作时间很灵活。不过你可能不会喜欢.", "g: 拜托了，为了能继续学习我愿意做任何事。这对我来说非常重要！"], multiple=True, fear=-5)
    add_dialogue("free_job_request", "pervert", ["g: 天呐！大巴黎要离开了!", "mc: 什么...大什么??", "g: PXG！你不知道吗？他们是塞洛斯的一支著名球队!", "mc: 所以呢...", "g: 所以? 我是他们的狂热粉丝!!我曾经和前锋约会过，还有守门员，他们给了我大量的礼物和签名...", "mc: 嗯,嗯？什么?", "g: 抱歉，亲爱的，别往心里去，你很棒，但他们可是绝世好男人... 大巴黎有15名队员!!! 我到哪里去再找一批又有钱又好色的男人???", "mc: 这可真是..."], multiple=True, fear=-5)
    add_dialogue("free_job_request", "very dom", ["g: [MC.name]... 帮帮我, 求你了! *恐慌*", "mc: 怎么这么慌张?这不像你...", "g: 几周前我遇到了一个混混，他想强奸我，我踢了他的那里...几天后我就要受审了。他们会....他们会把我变成奴隶的!", "在泽恩, 如果你没有钱来赔偿受害者，法官有权利把你变成奴隶抵债...", "g: 我最后的一点钱都拿去付了保释金。但他们肯定会认定我有罪，那人的同伙会奴役我!他们会在我的余生里强奸和折磨我!", "g: 几万金币，如果赔不起我就得...", "mc: EMMMM... 你知道奴隶是不需要受审的吗?她犯的错误由主人承担。", "g: 但我不是奴隶....你的意思是?"], multiple=True, fear=-5)
    add_dialogue("free_job_request", "very materialist", ["g: Oh, [MC.name]! 为什么每个人都想毁了我的生活!", "mc: 别想太多，亲爱的...发生了什么事?", "g: 是我父亲!他的遗产...自从他去世后....我只用它买了几件东西，几个手袋，六件裙子，神奇的内衣...", "g: 但是那个愚蠢的职员说钱不见了!都不见了!现在贪婪的高利贷者想要回我借的零用钱... *哭泣*", "她泪眼婆娑地看着你.", "g: 我负债累累!我该怎么办... *啜泣*", "mc: Mmmh... 好吧，也许有一种方法...你知道，奴隶不能负债?", "g: 唔?"], multiple=True, fear=-5)
    add_dialogue("free_job_request", "very introvert", ["g: 嗨, [MC.name].", "mc: Hi, [girl.name].", "g: 我可以为你工作吗?", "mc: 呃?", "g: 我说，我可以为你工作吗？我需要钱。这能有多难呢?", "mc: 嗯....这真是个意外的请求....让我想想."], multiple=True, fear=-5)
    add_dialogue("free_job_request", "masochist", ["g: ...", "mc: 怎么了, [girl.name]?", "g: 我不值得被人尊重。", "mc: 啊???", "g: 我是个淫荡的母狗。我想让你虐待我。我想被当成你的厕所使用。我想要...", "mc: 哇，我们确实有一些奇怪的客人，但是....这真前卫.", "g: 请帮我，让人捆住我，虐待我，我想成为性奴隶...", "mc: 既然如此，欢迎加入..."], multiple=True, fear=-5)
    add_dialogue("free_job_request", "very extravert", ["g: 你...你在脚踏两只船吗?", "mc: 嗯?", "g: 告诉我真相...哦，我知道了...我看到你和她在一起做那些事...我的心都要碎了!", "mc: 对不起...我...我会解释的...", "g: 没关系。就算你不爱我了，但我还是爱着你。我想永远在你身边。", "g: 我愿意做任何事来留在你身边。我也可以成为你的奴隶。", "g: 你会...抛弃我吗？求你了，请奴役我...我是你的女人!", "mc: 嗯...我...让我想想..."], multiple=True, fear=-5)


    ### SCREEN DIALOGUE ###

    ### FARM DIALOGUE ###

    add_dialogue("accept farm", "generic", ["我是不是哪里做的不好让你不高兴了...", "哦，农场...如果必须去的话，主人...", "如您所愿，主人.", "那我去收拾行李...", "我明白了, 主人。"])
    add_dialogue("accept farm", ("masochist", "pervert", "libido"), ["农场...我听说女孩在那里会被逼着做一些下流的事... *脸红*", "那是不是意味着...我会像动物一样被关起来? *脸红*", "我知道我可能有些奇怪，但是...我感到有些兴奋..."])
    add_dialogue("accept farm fear", "generic", ["吓得发抖，她在吉泽尔向她走来时缩在墙角，不敢抵抗.", "她用眼神恳求你不要让她去农场，但她不敢违抗你的命令。", "她十分害怕，但不敢违抗你的命令。"])
    add_dialogue("refuse farm", "generic", ["不！不要去农场！我知道那里会发生什么...我拒绝!", "我不想去农场！求你了，主人，不要!", "不！不要去农场！求你了...", "我不能去，主人...我不能...请饶了我..."])
    add_dialogue("refuse farm", "dom", ["农场？不！！你不能这样对我!", "我不会去农场的，绝对不会！不!!!", "啊，农场？你在开玩笑吗?!?"])
    add_dialogue("refuse farm", "sub", ["哦，主人，请别把我丢给那个疯狂的女精灵...", "不，我不想去农场...那是个可怕的地方...", "哦，主人，我到底做错了什么让你这样对我?"])
    add_dialogue("gizel take girl to farm", "generic", "哈！过来，你这下贱的婊子，在我让你尝尝鞭子的滋味之前你最好老实点。")

    ### CONTRACT DIALOGUE 汉化标签，对应描述在BKinit variables line3578##

    add_dialogue("contract greeting", "cruise", ["嘿，你很守时嘛！欢迎上船。希望你能享受这次海上之旅。*不怀好意的笑*"])
    add_dialogue("contract intro", "cruise", ["客人们马上就要上船了!来，我领你到你的房间去，你最好先洗个澡，再喷点香水，记得换上我给你准备的特殊制服。"])
    add_dialogue("contract success", "cruise", ["亲爱的，你的表现很不错。看来你满载而归啊，钱包和那里都装的满满的~"], sound=s_surprise)
    add_dialogue("contract success special", "cruise", ["亲爱的，你天生就是干这行的料。客人盯着你的背影都挪不动脚了，你居然能同时服侍好几个客人"], sound=s_surprise)
    add_dialogue("contract buy offer", "cruise", ["嘿，你猜怎么着。那些大老板说他们看上了你的小宠物[girl.name]。他们愿意用一大箱金币来买下她。你觉得怎么样?"])
    add_dialogue("contract buy offer accept", "cruise", ["爽快！这是答应你的钱，拿去吧，瞧你那没见过世面的样子!"])
    add_dialogue("contract buy offer refuse", "cruise", ["哼，我劝你不要敬酒不吃吃罚酒！老板的面子你也敢不给。这可是你自己的决定，没有回头路了。"])
    add_dialogue("contract partial", "cruise", ["哼，你表现得太糟糕了。希望下次能换个懂事的人来。小妹妹，你的表现可配不上你的报酬*恼怒*"], sound=s_sigh)
    add_dialogue("contract partial special", "cruise", ["哼，你就是这样服务的？好吧，至少你还能完成老板的特殊要求..."], sound=s_sigh)
    add_dialogue("contract failure", "cruise", ["哼，你这没用的旱鸭子！如果你甚至连几个水手都服务不好，那我还不如把你丢进海里喂鲨鱼! *生气*"])
    add_dialogue("contract failure special", "cruise", ["哼，你这没用的旱鸭子！你或许能迎合他们的口味，但如果你不能让客人们满足，那又有什么用呢!"])

    add_dialogue("contract greeting", "party", ["嘿，有点紧张？放轻松，你会喜欢这个派对的，尽情释放自我吧!"])
    add_dialogue("contract intro", "party", ["戴上这个面具，把多余的衣服都脱掉。大家期待的是一个勇敢的派对女孩，别让他们失望!"])
    add_dialogue("contract success", "party", ["哦，你点燃了全场的气氛！希望将来我也能像你一样!"])
    add_dialogue("contract success special", "party", ["哦，你让他们为你神魂颠倒！大家都在为你欢呼呐喊，你这件衣服漏得恰到好处，设计得也很方便行事..."], sound=s_surprise)
    add_dialogue("contract buy offer", "party", ["你瞧，[MC.name]先生. 我的主人有个不情之请。他想要让[girl.fullname] 成为他的私人女宠，他愿意给你 [gold_offer] 金币，听起来不错吧?"], sound=s_surprise)
    add_dialogue("contract buy offer accept", "party", ["哦，太棒了！很高兴我的主人又新添一只宠物，我得去收拾收拾她的笼子了。"])
    add_dialogue("contract buy offer refuse", "party", ["哦，太令人失望了。不过天涯何处无芳草，我相信他一周内就会忘记她。我会让他..."])
    add_dialogue("contract partial", "party", ["你今天可没给大家留下什么好印象。你应该更加努力的训练，亲爱的。这不是你能来的场合。 *恼怒*"], sound=s_sigh)
    add_dialogue("contract partial special", "party", ["嗯，虽然你的表现很差劲。但至少，你可以满足主人的特殊要求..."], sound=s_sigh)
    add_dialogue("contract failure", "party", ["你真的是个人类吗! 真无能... 你给你的性奴姐妹带来了坏名声!!! *愤怒*"])
    add_dialogue("contract failure special", "party", ["哼，真是无能....虽然满足了他们的“特殊要求”，但这并不意味着你可以骄傲!"])

    add_dialogue("contract greeting", "ceremony", ["你好，孩子。和我们一起沐浴在主的光辉下吧。"])
    add_dialogue("contract intro", "ceremony", ["现在，履行你作为教团一员的义务吧，孩子。我们的信徒已经等候多时了。"])
    add_dialogue("contract success", "ceremony", ["恭喜你，我的孩子。你帮助信徒们清除掉了内心的污秽，你的牺牲是值得的。"], sound=s_surprise)
    add_dialogue("contract success special", "ceremony", ["恭喜你，我的孩子。听说信徒们在仪式后更加坚定了信仰，就连其他神职人员也加入了仪式。"], sound=s_surprise)
    add_dialogue("contract buy offer", "ceremony", ["啊, [MC.name]先生。大祭司想招纳 [girl.name] 加入我们的教团。他认为她的身体可以引发神迹....我是说，她的心灵。当然，我们会给你补偿的。"])
    add_dialogue("contract buy offer accept", "ceremony", ["感谢你为神的奉献，她将会成为我们的新一任圣女，帮助人们净化心灵....和欲望。"])
    add_dialogue("contract buy offer refuse", "ceremony", ["你这是对神的大不敬。你沉迷于俗世的欲望，看看那你堕落的灵魂..."])
    add_dialogue("contract partial", "ceremony", ["孩子，你为什么要拒绝仪式 *皱眉*"], sound=s_sigh)
    add_dialogue("contract partial special", "ceremony", ["孩子，你本可以做的更好的 *叹气*\n不过至少你满足了我们的特别请求，所以神会宽恕你的..."], sound=s_sigh)
    add_dialogue("contract failure", "ceremony", ["以神之名，你会受到神罚！我们要求的是一个虔诚的用于奉献的女性! *愤怒*"])
    add_dialogue("contract failure special", "ceremony", ["你就是这样对待他人的信仰的吗！？虽然你满足了我们的特殊要求，但这还远远不够!"])

    add_dialogue("contract greeting", "festival", ["欢迎参加学园祭，我们实在是太缺人手了！"])
    add_dialogue("contract intro", "festival", ["来，换上这些可爱的服装。有点紧？那再好不过了，啊，我是说你先忍忍。"])
    add_dialogue("contract success", "festival", ["过来, [girl.name], *猛的一拍屁股*你今天的表现很棒，访客们都在门口排起了长队。"], sound=s_surprise)
    add_dialogue("contract success special", "festival", ["来吧， [girl.name], 再演示一遍! 在身体上涂上炼乳供客人品尝实在是天才的点子！"], sound=s_surprise)
    add_dialogue("contract buy offer", "festival", ["啊, [MC.name]。你的 [girl.name] 让人念念不忘。事实上，一家五星级酒店的老板想让她接待那些大人物，想把她买下。"])
    add_dialogue("contract buy offer accept", "festival", ["成交，[girl.name] 肯定会做得很好的，赤身裸体的躺在桌上，身上摆满了食物，客人们用筷子在她身上拨弄，想想都刺激..."])
    add_dialogue("contract buy offer refuse", "festival", ["看来你对老板的出价不是很满意啊，不过老板很期待下一次合作。"])
    add_dialogue("contract partial", "festival", ["啊，是你。听说你今天把咖啡撒在了客人的名贵西服上。*皱眉*"], sound=s_sigh)
    add_dialogue("contract partial special", "festival", ["啊，是你....听说你今天手忙脚乱的，不过至少你让这场闹剧没那么无聊。"], sound=s_sigh)
    add_dialogue("contract failure", "festival", ["不，不，不！这样不行，完全不行。我就知道 [MC.name]靠不住... *恼怒*"])
    add_dialogue("contract failure special", "festival", ["啊，是你....听说你今天把店里弄得乌烟瘴气的，不过至少你让这场闹剧没那么无聊。"])

    add_dialogue("contract greeting", "date", ["你好，你一定就是...接下来要注意你的一言一行。"])
    add_dialogue("contract intro", "date", ["跟我来。不要离开指定的区域，主人让你做什么你就做什么。不要多嘴，否则你会后悔的。"])
    add_dialogue("contract success", "date", ["非常好，你就像是个精致的人偶，我的主人非常满意。"], sound=s_surprise)
    add_dialogue("contract success special", "date", ["你难道是位落魄的贵族千金吗？甚至 [con.organizer]都对你表示赞赏，这是一种罕见的荣誉。"], sound=s_surprise)
    add_dialogue("contract buy offer", "date", ["先生, [con.organizer] 对您的奴隶, [girl.name] 印象非常深刻。事实上，他希望她能成为他的妻子之一。他愿意替她赎身，钱当然不是问题。"])
    add_dialogue("contract buy offer accept", "date", ["很好。我会立即安排婚礼的准备工作。婚礼将在地下室举行。抱歉，主人不想把婚礼举办的太张扬..."])
    add_dialogue("contract buy offer refuse", "date", ["好吧，如果你坚持的话。主人晚上一定会用鞭子狠狠地抽我的。 *脸红*"])
    add_dialogue("contract partial", "date", ["听女仆长说你的表现很差劲，要不是主人宽宏大量，你可能会被拖出去。 *皱眉*"], sound=s_sigh)
    add_dialogue("contract partial special", "date", ["你简直就是女仆之耻！不过主人说你还有点用处。"], sound=s_sigh)
    add_dialogue("contract failure", "date", ["赶快滚，永远别让我们再见到你！"])
    add_dialogue("contract failure special", "date", ["哼，真是个没用的废物。要不是你符合我主人的品味，我早就把你扔出去了."])

    add_dialogue("contract greeting", "meeting", ["啊，你终于来了。听我说，你只需要坐在那里一直保持微笑，没人问你你就保持沉默。"])
    add_dialogue("contract intro", "meeting", ["啊忘了说，到时候大使会坐在你的身边，如果有人问你问题，你就想办法岔开话题，懂吗？"])
    add_dialogue("contract success", "meeting", ["[girl.fullname]! 感谢你为泽恩做出的贡献，啊对了，大使说你的屁股手感很不错。*坏笑*"], sound=s_surprise)
    add_dialogue("contract success special", "meeting", ["[girl.fullname]! 大使对你的表现很满意，你今天的裙子短的恰到好处，我们会寄一条最好的丝袜赔给你的。*坏笑*"], sound=s_surprise)
    add_dialogue("contract buy offer", "meeting", ["[MC.name]阁下。 [con.organizer] 希望征用你的奴隶,  [girl.lastname]小姐，执行....外交任务。她将成为我们的首席“慰问官”。当然，我们会给你报酬。"])
    add_dialogue("contract buy offer accept", "meeting", ["谢谢你，好市民。我们会立即将 [girl.lastname] 小姐的户籍手续办理好。这是答应给你的钱。"])
    add_dialogue("contract buy offer refuse", "meeting", ["这....做人要懂得变通。 *皱眉*\n既然如此，我看得找别人合作了。"])
    add_dialogue("contract partial", "meeting", ["女士，我是说，奴隶，我从他们那听说了你的表现，有点不尽如人意啊。"], sound=s_sigh)
    add_dialogue("contract partial special", "meeting", ["听着，你没能成功执行任务，但因为你很合大使的胃口，这事就这么过去了。"], sound=s_sigh)
    add_dialogue("contract failure", "meeting", ["[girl.fullname]! 难道你是想叛国吗！你知不知道你给我们带来了多少损失！ *不可理喻*!!!"])
    add_dialogue("contract failure special", "meeting", ["[girl.fullname]! 要不是看你还有点姿色，日后可能还有机会伺候大使，你现在已经身首异处了！"])

    add_dialogue("contract greeting", "magic", ["啊，你居然能自己找来这里，真不容易!!!"])
    add_dialogue("contract intro", "magic", ["跟我来，注意脚下，别踩到传送陷阱了，我可不想再去贴招聘启事。"])
    add_dialogue("contract success", "magic", ["真厉害，你明明不是个法师，但你却能施展出这么惊人的戏法..."], sound=s_surprise)
    add_dialogue("contract success special", "magic", ["太不可思议了! [con.organizer] 对你非常满意，你的肉棒吞没术和手指吸引术简直就是高级魔法！"], sound=s_surprise)
    add_dialogue("contract buy offer", "magic", ["啊，我亲爱的朋友！你的不可思议的奴隶, [girl.name]的魔法天赋和她在床上的天赋相当，至少大师是这么说的，你愿意把她卖给我们吗?"])
    add_dialogue("contract buy offer accept", "magic", ["太棒了！那个老家伙会欣喜若狂的。他一直念叨着他那些重要的实验，我想是和触手有关的....给你，拿着你的金币。"])
    add_dialogue("contract buy offer refuse", "magic", ["什么？你这是在阻止魔法进步。算了，我们会找到合适的试验品的。"])
    add_dialogue("contract partial", "magic", ["那个，呃....我该怎么说呢....也许你该读几年书再来。*皱眉*"], sound=s_sigh)
    add_dialogue("contract partial special", "magic", ["那个，呃....还好你完成了我们的特殊需求，不然那些老家伙可能会用魔法把你变成一只母猪。"], sound=s_sigh)
    add_dialogue("contract failure", "magic", ["呜呜！真是一场令人遗憾的表演！你演得糟透了! *翻白眼*"])
    add_dialogue("contract failure special", "magic", ["那是什么鬼东西？算你走运，满足了主人的要求，否则我早就把你扔進最近的传送门了!"])

    add_dialogue("contract greeting", "orgy", ["哇哦, 这只漂亮的金丝雀是谁?来吧，别害羞."])
    add_dialogue("contract intro", "orgy", ["嗯，我也很高兴见到你 但你穿得实在是{i}太多了{/i} 来吧，别吝啬展示你的魅力。"])
    add_dialogue("contract success", "orgy", ["噢... 啊啊啊... 我的意思是... 啊啊啊啊... 光是看着你我就... 呣呣呣, 噢... 操我! 用力操我!!!"], sound=s_orgasm)
    add_dialogue("contract success special", "orgy", ["噢, 我的女神，多么刺激的肉体碰撞....派对上的男人都在对着你打手枪。我也是... *呻吟*"], sound=s_moans)
    add_dialogue("contract buy offer", "orgy", ["嗷, [MC.name], 你介意把手指放在这里吗? 噢，啊啊，就是那个地方....继续弄我....他问，你愿意放弃 [girl.name]吗? 一位不愿透露姓名的绅士想要充实他的收藏品... Mmmh..."])
    add_dialogue("contract buy offer accept", "orgy", ["噢, 我的天, 啊! 啊!!! 啊啊啊啊啊啊啊!!! *喘息* *喘息*\n对不起... 我有点太爽了..."])
    add_dialogue("contract buy offer refuse", "orgy", ["噢 不... 不要! 不... 不要啊啊啊啊啊啊!!!!! *喘息* *喘息*\n真可惜... 但我反而更兴奋了... 我是个变态的母猪..."])
    add_dialogue("contract partial", "orgy", ["呋呋呋, 小金丝雀，你还有很多要学的....我可以教你，但你得有所回报... *得意的笑*"], sound=s_sigh)
    add_dialogue("contract partial special", "orgy", ["呋呋呋, 小鸟，你还有很多要学的....但他们很高兴你至少满足了他们的特殊要求."], sound=s_sigh)
    add_dialogue("contract failure", "orgy", ["因为你!我得一个人伺候他们所有人，你以为我是汤姆吗？滚出我的视线... *厌恶*"])
    add_dialogue("contract failure special", "orgy", ["那是什么鬼东西!你满足了我们的特殊要求不代表你就能随心所欲!"])
#汉化标签，待润色#
    add_dialogue("task intro", "greet", ["下一位嘉宾来了. [tsk_text] 给他们一个适当的欢迎."])
    add_dialogue("task intro", "serve", ["[tsk_text]加入员工队伍，为客人服务，提供他们需要的任何帮助."])
    add_dialogue("task intro", "mingle", ["夜晚越来越热闹了. [tsk_text] 和客人打成一片，确保他们玩得开心!"])
    add_dialogue("task intro", "event", ["现在，让我们进入高潮. [tsk_text] 将参与进来。请好好享受!"])
    add_dialogue("task intro", "private show", ["我们的一位客人要求单独演出. [tsk_text]， 要尽你所能招待他."])
    add_dialogue("task intro", "fun", ["好了，现在是玩乐的时候了!  [tsk_text] ，来后面的房间... *得意的笑*"])

    add_dialogue("task description", "clean", "[girl.fullname] 被送到 [con.venue]帮助清洁, 客人离开后，确保环境整洁。")
    add_dialogue("task success", "clean", ["这项任务对她来说很容易，青楼里平时要比这脏的多， 她把这个地方收拾得一尘不染。", "g: 真棒，你做得很不错!"], multiple=True)
    add_dialogue("task failure", "clean", ["[girl.name] 尽力去收拾客人到处乱丢的垃圾，但还是心有余而力不足，客人们开始抱怨[con.venue]里的环境。", "g: 还傻站着干什么?到处都是污渍!动起来, [girl.name]!"], multiple=True)

    add_dialogue("task description", "serve guests", "[girl.fullname] 被派去[con.venue]为客人服务. 她必须确保客人有求必应。")
    add_dialogue("task success", "serve guests", ["[girl.name] 习惯了为客人服务，她高效又利落地完成了任务。", "g: 很好!你帮了很大的忙."], multiple=True)
    add_dialogue("task failure", "serve guests", ["[girl.name] 不太乐意为顾客服务，忙着应付他们的咸猪手。结果，她把一杯红酒洒在了一位客人的衬衫上.", "g: 你!你是故意来砸场子的吗!!! *生气*"], multiple=True)

    add_dialogue("task description", "serve drinks", "[girl.fullname] 在吧台为客人提供酒水。")
    add_dialogue("task success", "serve drinks", ["[girl.name] 与顾客聊天，迅速了解他们的口味，并给出了建议。他们很开心。", "g: 你做得很好。保持下去!"], multiple=True, sound=s_potion)
    add_dialogue("task failure", "serve drinks", ["[girl.name] 不太乐意为顾客服务，不主动与客人交流。最后，客人干坐了十几分钟后转身离开了。", "g: 你!你是个雕像吗!!! *生气*"], multiple=True)

    add_dialogue("task description", "feed guests", "[girl.fullname] 在大堂为客人上菜。")
    add_dialogue("task success", "feed guests", ["[girl.name] 勤奋地穿梭于后厨和餐桌之间，端着盛满食物的餐盘，每个人都能享用美食。", "g: 很熟练嘛..."], multiple=True)
    add_dialogue("task failure", "feed guests", ["[girl.name] 费力地把餐盘从厨房端到餐桌上。路上还被几个酒鬼骚扰，不小心所有的食物都洒在了地上。", "g: 不! !真是一场灾难..."], multiple=True, sound=s_crash)

    add_dialogue("task description", "onsen", "[girl.fullname] 前往浴池，服务年长的客人.")
    add_dialogue("task success", "onsen", ["她和男人们混在一起，只穿着一件薄薄的浴袍，不经意让它滑了一点下来，让每个人都很高兴。", "g: 干得好，亲爱的，他们看着你都流口水了..."], multiple=True)
    add_dialogue("task failure", "onsen", ["她不情愿地走进混浴的水池，但当几个老色鬼试图和她亲密交流时，她立刻逃了出来。", "g: 不，那不行 *皱眉*! 这不是对待客人的方式!"], multiple=True)

    add_dialogue("task description", "swimming pool", "穿着性感泳装的 [girl.fullname] 被派去参加一个大型游泳池派对。")
    add_dialogue("task success", "swimming pool", ["[girl.name] 开心地在泳池里和来客们玩耍，她“没注意”到自己的泳衣掉了下来。", "g: 很好，让他们保持狂热和饥渴..."], multiple=True)
    add_dialogue("task failure", "swimming pool", ["[girl.name] 来到客人身边，但她始终拒绝与客人互动。", "g: 你这个没用的奴隶!我们付钱给你是为了什么!"], multiple=True)

    add_dialogue("task description", "swimming show", "[girl.fullname] 加入其他女孩在一个大游泳池参加游泳表演。就像花样游泳一样，不过里面的假阳具要多得多.")
    add_dialogue("task success", "swimming show", ["在水中, [girl.name] 确保为客人提供最好的表演.", "g: 伟大的工作!你是这部剧的明星之一!"], multiple=True)
    add_dialogue("task failure", "swimming show", ["由于在水中不自在, [girl.name] ]的表演笨拙而平淡.", "g: Booh!!! 你比湿猫还跛!"], multiple=True)

    add_dialogue("task description", "lingerie show", "[girl.fullname] 被邀请参加一场内衣秀，展示最新最大胆的性奴时尚.")
    add_dialogue("task success", "lingerie show", ["她穿着这身衣服，在客人们抛媚眼和欢呼的时候展示了她美丽的身体.", "g: 哦吼!摇一摇吧宝贝!"], multiple=True, sound=s_crowd_cheer)
    add_dialogue("task failure", "lingerie show", ["她感到数百人的目光注视着她裸露的身体，很快失去了镇静。公众开始发出嘘声.", "g: 不!你在干什么!!!"], multiple=True, sound=s_crowd_boos)

    add_dialogue("task description", "entice guests", "[girl.fullname] 被要求站在 [con.venue], 吸引客人和过路人参加活动.")
    add_dialogue("task success", "entice guests", ["[girl.name] 微笑着引诱每个人，引来一大群人.", "g: 太棒了!你是个完美的广告女郎..."], multiple=True)
    add_dialogue("task failure", "entice guests", ["[girl.name] 半心半意地试图说服人们进来，结果被拒绝了好几次。她很快失去了动力，在空旷的广场前喃喃自语.", "g: 你!你到底在干什么?"], multiple=True)

    add_dialogue("task description", "dance show", "[girl.fullname] 被要求上台参加一个全女子团体的性感舞蹈节目.")
    add_dialogue("task success", "dance show", ["[girl.name] 快速完成一些大胆的动作，成为节目的亮点之一.", "g: 加油，姑娘!你真是个偶像!"], multiple=True, sound=s_crowd_cheer)
    add_dialogue("task failure", "dance show", ["由于害怕在这么多人面前跳舞，[girl.name]退到了舞台后面，躲在其他女孩后面。客人甚至没有注意到她。", "g: 那是什么？！？你以为我们付钱给你是为了偷懒？"], multiple=True)

    add_dialogue("task description", "erotic show", "[girl.fullname] 加入了一群穿着性感、暴露服装的女孩。他们的任务是组织一场色情表演，让客人们在当晚剩下的时间里暖和起来。")
    add_dialogue("task success", "erotic show", ["[girl.name] 有很多淫荡的想法来保持节目的趣味性，她还为那些没有经验的女孩提供了指导。人群喜欢它。", "g: 哇！即使是我也绝不会想到用乒乓球做{i}那样{/i}......"], multiple=True)
    add_dialogue("task failure", "erotic show", ["[girl.name] 对在几十个陌生人面前半裸感到不高兴。每当另一个女孩碰她时，她都会蠕动。人群很快就对她失去了兴趣。", "g:  嘘！让我休息一下吧！谁听说过方形性奴隶......"], multiple=True)

    add_dialogue("task description", "cosplay", "主持人给了 [girl.fullname] 一套服装，并告诉她穿着这套服装加入客人行列。")
    add_dialogue("task success", "cosplay", ["[女孩名]很快就进入了她的角色，满足了男人们的幻想，并为她的麻烦赢得了很多性欲。", "g: 哦，你快把他们逼疯了！你穿这身衣服很摇滚！"], multiple=True)
    add_dialogue("task failure", "cosplay", ["[girl.name] 抱怨这套衣服尺码不合适，而且太放荡了。她与几位客人交谈，但未能给人留下深刻的印象。", "g: 得了吧，真无聊！ “cosplay”里还有“玩”，你知道吗？"], multiple=True)

    add_dialogue("task description", "膝上舞", "[girl.fullname] 被要求为一位最杰出的客人举办一场私人膝上舞。")
    add_dialogue("task success", "膝上舞", ["当管弦乐队演奏激动人心的合唱时，[girl.name] 熟练地为顾客提供他想要的东西。当她用屁股摩擦他时，他裤子上的巨大凸起证明了她成功了。", "g: 甜甜，老爷子真幸福...."], multiple=True)
    add_dialogue("task failure", "膝上舞", ["[girl.name] 在舞厅里发现了一个狡猾的老男人。她开始跳舞，但当男人把手伸进她的内裤时，她很快就停了下来。", "g: 嘿！你要去哪里！舞蹈还没结束！"], multiple=True)

    add_dialogue("task description", "welcome massage", "[girl.fullname] 被要求为所有新来者提供友好、热情的按摩。")
    add_dialogue("task success", "welcome massage", ["[girl.name]利用她精湛的按摩技巧，让每一位到她手上的客人都感到快乐和放松。", "g: 哇，你真是太棒了！别忘了我！"], multiple=True)
    add_dialogue("task failure", "welcome massage", ["[girl.name] 试图为客人提供简单的头部或足部按摩，但他们一直引导她的手伸向裤子。最终，她打断了某人的手，然后怒气冲冲地走了出去。", "g: 不，你在做什么！回到这来！！！"], multiple=True)

    add_dialogue("task description", "erotic massage", "[girl.fullname] 被告知为所有需要按摩的客人提供性感按摩。")
    add_dialogue("task success", "erotic massage", ["[girl.name] 带领自愿的客人进入一个安静的角落，为他们提供热辣性感的按摩，他们一定会记住。", "g: 太好了，除了对你的“技术”的赞美之外，我什么也没听到...."], multiple=True)
    add_dialogue("task failure", "erotic massage", ["尽管她习惯了按摩，但[girl.name]在公共场所为她的第一位顾客提供性感按摩时感到很尴尬。最终，客人抱怨说这毫无乐趣并离开了。", "g: 真令人失望....看来你不适合这个简单的任务....*皱眉*"], multiple=True)

    add_dialogue("task description", "conversation", "[girl.fullname] 被告知要用她学到的谈话的力量来招待客人。")
    add_dialogue("task success", "conversation", ["[girl.name] 利用她的魅力和智慧，通过一个诙谐有趣的故事毫不费力地吸引了公众。宾客们兴高采烈。", "g: 太棒了，你真是个有魅力的人......"], multiple=True)
    add_dialogue("task failure", "conversation", ["在试图与一群客人交谈时，[girl.name]显得笨拙而害羞。客人们赶紧转过身去，不理睬她。", "g: 这些天的性奴隶...你只擅长一件事...*生气*"], multiple=True)

    add_dialogue("task description", "protocol", "[girl.fullname] 的任务是确保始终遵守此类活动的正确规则和协议。")
    add_dialogue("task success", "protocol", ["[girl.name] 轻松地扮演了主持人的角色，指导仆人们掌握外交艺术，并确保庆祝活动不会因任何失礼而玷污。", "g: 噢，太棒了！如此精致，如此优雅！"], multiple=True)
    add_dialogue("task failure", "protocol", ["她不确定该怎么做，试图制定一个餐桌计划，结果却让不共戴天的敌对部落坐在一起。一场大规模的争吵随之而来。", "g: 嘿！ *躲开椅子*到底是谁造成了这个混乱？！？"], multiple=True)

    add_dialogue("task description", "ceremony", "[girl.fullname] 加入艺妓团体，负责为客人组织传统的赞尼克仪式。")
    add_dialogue("task success", "ceremony", ["经过严格的训练，[girl.name] 的表演完美无瑕，达到了如此复杂而精致的仪式的所有标准。", "g: 太棒了！你是一位真正的女士。"], multiple=True)
    add_dialogue("task failure", "ceremony", ["[girl.name] 不确定自己在团体中的角色，最终在仪式的关键时刻妨碍了更高级的成员。她被严厉地斥责。", "g: 你根本不知道自己在做什么！滚出我的视线！"], multiple=True)

    add_dialogue("task description", "welcome guests", "[girl.fullname] 被要求迎接客人并帮助他们找到座位。")
    add_dialogue("task success", "welcome guests", ["[girl.name] 在引导新来者参观 [con.venue] 时与他们愉快地聊天。客人们称赞她友善的行为。", "g: 好姑娘！很高兴有你在身边。"], multiple=True)
    add_dialogue("task failure", "welcome guests", ["[girl.name] 等待更多客人的到来很快就会感到无聊。当一位最尊贵的客人出现时，她忍不住打了个哈欠。", "g: 那到底是什么？太粗鲁了！！！"], multiple=True)

    add_dialogue("task description", "kiss guests", "主人决定迎接客人的最好方式是用满嘴的色情之吻。 [girl.fullname] 是接吻队的一员。")
    add_dialogue("task success", "kiss guests", ["通过她大量的训练，[girl.name] 确保给每一位最后的客人一个湿漉漉的、草率的吻，让他们铭记在心。他们中的大多数人显然都被这次经历所感动。", "g: 哇，看起来那些家伙的裤子里有支柱......你应该告诉我你是如何做到的。"], multiple=True)
    add_dialogue("task failure", "kiss guests", ["[girl.name] 对亲吻陌生人的想法感到厌恶，因为他们大多年老且令人厌恶。最终，她用特别难闻的口气推开了一位醉酒的领主。", "g: 你疯了吗？你的礼貌在哪里？"], multiple=True)

    add_dialogue("task description", "catwalk", "Zan 的一位顶尖设计师将在时装秀上展示他的最新作品。 [girl.fullname] 被赋予了一件暴露的裙子并被送往 T 台。")
    add_dialogue("task success", "catwalk", ["[girl.name] 在舞台上很自然，她真的让服装闪闪发光。她是该剧的亮点之一。", "g: 设计师刚刚答应给我们机构一大笔钱！恭喜！"], multiple=True)
    add_dialogue("task failure", "catwalk", ["[girl.name] 因着装的奇怪设计而笨手笨脚地走在舞台上。最终，她的衣柜出现了严重故障，引起了全场的一阵笑声。", "g: 你在愚弄我们！现在离开！"], multiple=True)

    add_dialogue("task description", "catfight", "主人决定组织斗殴活动，以供客人娱乐。 [girl.fullname] 被要求参加一场被操纵的战斗。")
    add_dialogue("task success", "catfight", ["[girl.name] 很高兴能与其他女孩竞争，赢得了一系列泥浆战，确保让观众清楚地看到她击败的对手的可耻部分。她成为人群的最爱。", "g: 哦，你真讨厌....坚强，又变态：完美的组合！"], multiple=True, sound=s_crowd_chant)
    add_dialogue("task failure", "catfight", ["[girl.name] 对与其他女孩战斗的想法并不感到兴奋，但当她很快被另一名战士逼入绝境时，她别无选择。她挣扎着逃跑，结果跌跌撞撞地冲进了人群，还摔坏了一些昂贵的家具。一场骚乱随之发生。", "g: 那到底是什么？你应该屈服的，你这个笨蛋！"], multiple=True, sound=s_crowd_riot)

    add_dialogue("task description", "art model", "[girl.fullname] 被邀请成为一群业余画家的现场模特。她需要以暗示性的姿势保持静止一个小时。")
    add_dialogue("task success", "art model", ["[girl.name] 散发着美丽和优雅，可以毫不费力地在客人面前扮演完美的模特。", "g: 哇，这幅水彩画太棒了！你是这些艺术家真正的缪斯......"], multiple=True)
    add_dialogue("task failure", "art model", ["[girl.name] 性格冷淡，脾气暴躁，因为她必须长时间站着不动。最终，她抽筋了，并抱怨她需要散步。", "g: 如果你一直摆弄，任何人都无法完成任何工作！这是浪费时间，给我另一个女孩......*生气*"], multiple=True)

    add_dialogue("task description", "sub greeting", "[girl.fullname]被要求根据每位客人的身份向他们鞠躬。")
    add_dialogue("task success", "sub greeting", ["[girl.name] 表现出适当的勤奋和顺从的表情，在客人面前低下眼睛，鞠躬得足够低，让他们可以清楚地看到她的乳沟。", "g: 很好，他们喜欢你像狗一样在他们面前卑躬屈膝......"], multiple=True)
    add_dialogue("task failure", "sub greeting", ["在每位客人面前鞠躬后，[girl.name]很快就会感到背部疼痛。最终，她的点头变得难以察觉。", "g: 这根本不是鞠躬！您怎么可以对我们尊贵的客人如此无礼！ *生气的*"], multiple=True)

    add_dialogue("task description", "dom greeting", "[girl.fullname]被要求扮演施虐狂的角色，适当地欢迎顺从的客人参加聚会。")
    add_dialogue("task success", "dom greeting", ["[girl.name] 使用道具鞭子催促客人前进，并用各种辱骂性的名字称呼他们。他们似乎很喜欢它。", "g: 哇，我可以从这里发现他们的硬汉....干得好，[girl.name]。"], multiple=True)
    add_dialogue("task failure", "dom greeting", ["[girl.name] 试图表现出虐待狂的性格，但她的奴隶训练很难消除。她看上去并不霸气，而是害羞。", "g: 你管这叫施虐狂？把那根鞭子给我，我来教你怎么做！ *生气*"], multiple=True)

    add_dialogue("task description", "sports show", "[girl.fullname]被派去参加体育表演，所有女孩都穿着短而暴露的衣服进行各种体育锻炼。")
    add_dialogue("task success", "sports show", ["[girl.name] 比大多数其他女孩都更健康，她毫不费力地赢得了一系列比赛，同时对着越来越多的粉丝微笑和眨眼。", "g:  太棒了！人群高呼你的名字！！！"], multiple=True, sound=s_crowd_chant)
    add_dialogue("task failure", "sports show", ["[girl.name] 尽了最大努力，但她的竞争对手只是更强壮、更健康。最终她放弃了完成课程，完全气喘吁吁。", "g: 你这个没用的蛆虫！你像老人一样爬障碍！！！"], multiple=True)

    add_dialogue("task description", "fondle", "[girl.fullname] 预计将加入客人并真正“交往”。预计皮肤关系。")
    add_dialogue("task success", "fondle", ["[girl.name]面带微笑，高兴地让多名客人摸索和爱抚她的私处。她似乎对这次经历感到非常兴奋。", "g: 嗯，你是个顽皮的女孩....我看到你有一个光明的未来。"], multiple=True)
    add_dialogue("task failure", "fondle", ["[girl.name] 被一群好色的老男人包围，渴望对她下手。她惊慌失措，躲开他们，逃离了人群。", "g: 不！我们付钱给你做什么，你这个蠢女人？"], multiple=True)

    add_dialogue("task description", "strip", "[girl.fullname] 被要求在饥渴的客人面前脱衣。")
    add_dialogue("task success", "strip", ["[girl.name] 已经完全习惯了在陌生人面前裸体，她利用自己的技巧使节目尽可能性感和有趣。当她把内裤掉到地上时，这位幸运的客人明显是勃起的。", "g: 哇，你真的对他下手了....看看这个可怜的家伙....我可能得处理一下。 *舔嘴唇*"], multiple=True)
    add_dialogue("task failure", "strip", ["[girl.name] 不喜欢陌生人在开始脱衣舞表演时露出变态的眼神。中途，他试图将自己强加在她身上。她逃跑了。", "g: 你！回到这来！你的礼貌去哪儿了！"], multiple=True)

    add_dialogue("task description", "nude help", "[girl.fullname] 被要求脱掉所有衣服，裸体加入客人中。")
    add_dialogue("task success", "nude help", ["[girl.name] 因裸体为客人服务而感到兴奋，当多只手伸出来触摸她或捏她的乳头时，她几乎没有脸红。", "g: 哇，看起来你不穿衣服比穿衣服更舒服！"], multiple=True)
    add_dialogue("task failure", "nude help", ["[女孩名] 脱光衣服，但她很难集中精力服务，因为多名醉酒好色的客人袭击了她。最终，她滑倒并打破了一个昂贵的水晶罐。", "g: 你这个该死的白痴！这是无价之宝！ *狂怒*"], multiple=True)

    add_dialogue("task description", "naked", "其中一位客人手里拿着他的鸡巴正在等待[girl.fullname]。奇怪的是，他说他只是想看她裸体，而不是碰她。")
    add_dialogue("task success1", "naked", ["[girl.name]习惯了在陌生人面前裸体，当男人在她面前自慰时，她露出愉快的微笑。最终，他的精液射满了她柔软的皮肤。"])
    add_dialogue("task success2", "naked", ["很好，你自己去洗吧，还有更多的顾客要服务。"])
    add_dialogue("task failure", "naked", ["[girl.name] 感到不舒服，因为这个男人用狼一样的眼神看着她。她感到羞愧并试图向他隐瞒自己的私处。最终，男人变得软弱无力，皱着眉头离开了。", "g: 发生什么事了？客人走了，还说你是个糟糕的仆人！ *生气的*"], multiple=True)

    add_dialogue("task description", "masturbate", "其中一位客人要求 [girl.fullname] 进行一场私人表演。他想看她自慰。")
    add_dialogue("task success", "masturbate", ["[girl.name] 因被注视而兴奋，很快就进入了状态，当她让自己达到高潮时，给了男人一个肮脏的眼神。", "g: 哇，你在这张沙发上留下了很多污渍....休息一下，然后在走之前一定要把它清理干净！"], multiple=True)
    add_dialogue("task failure", "masturbate", ["[girl.name]开始在客人面前抚摸自己，但她心不在焉，似乎没有心情。男人叹了口气，放弃了。", "g: 只是我的运气好，我最终得到了市场上唯一正经的性奴隶....现在就走，不要回来！"], multiple=True)

    add_dialogue("task description", "barmaid blowjob", "[girl.fullname] 被要求照料酒吧。反过来，她必须为到来的客人提供饮料和“缓解”。")
    add_dialogue("task success", "barmaid blowjob", ["在完成新一轮的比赛后，[girl.name] 正在用力吮吸鸡巴，看起来就像是完美的郊狼女孩。", "g: 非常好！在这里，你嘴里还剩下一些...."], multiple=True)
    add_dialogue("task failure", "barmaid blowjob", ["[girl.name] 被要求吸吮许多肮脏的鸡巴，直到她挣扎并喘气。客人抱怨她没有照顾他们的需求。", "g: 哎呀，连基本的工作都做不好！我得自己解决掉它们....*生气*"], multiple=True)

    add_dialogue("task description", "service", "[girl.fullname] 遇到一位绅士，他有一个简单的要求：他希望她为他服务。")
    add_dialogue("task success1", "service", ["[girl.name] 精通前戏艺术，她从容不迫地让她幸运的伴侣达到高潮。当他在她嘴里爆发时，她直视着他的眼睛。"])
    add_dialogue("task success2", "service", ["很好，确保不要洒出任何东西...给你。"])
    add_dialogue("task failure", "service", ["[girl.name] 为男人提供的服务平淡无奇，未能让他达到高潮。他抱怨她不好，然后就离开了。", "g: 说真的，你的工作很糟糕....而且不是很好！"], multiple=True)

    add_dialogue("task description", "cosplay sex", "[girl.fullname]被要求参加一个大型的cosplay活动...除了现在，嘉宾也可以参加！")
    add_dialogue("task success", "cosplay sex", ["[girl.name] 穿着她的衣服被陌生人无情地操，她很喜欢这样。众人看着她变态的反应，都疯狂了。", "g: 哇，那件衣服没有一寸是不脏的...."], multiple=True, sound=s_crowd_cheer)
    add_dialogue("task failure", "cosplay sex", ["一名裸体男子出现在舞台上，与[girl.name]一起穿着她的服装，而她被动地看着他开始操她。很明显她玩得不开心，人群很快开始发出嘘声。", "g: 真是个忘恩负义的贱人....你就不能向尊贵的客人表达一下感激之情吗？"], multiple=True, sound=s_crowd_boos)

    add_dialogue("task description", "full service massage", "[girl.fullname] 被要求为有要求的客人提供“全方位”按摩服务。")
    add_dialogue("task success", "full service massage", ["作为一名出色的按摩师，[girl.name] 为客人提供热气腾腾的性按摩，确保在她完成后他们已经完全筋疲力尽。", "g: 哎呀，我喜欢你的热情！不过，之后一定要把地板擦干净...."], multiple=True)
    add_dialogue("task failure", "full service massage", ["[girl.name] 用她的身体清洗客人的背部，但当他试图将她拉近时，她退缩了。", "g: 注意你的举止，奴隶！你怎么敢拒绝我们客人的温柔请求？ *生气的*"], multiple=True)

    add_dialogue("task description", "sex", "[girl.fullname] 和一位绅士一起进入红灯笼罩的卧室。他的心里只有一个简单的想法....")
    add_dialogue("task success1", "sex", ["当男人将坚硬的鸡巴插入她体内时，[girl.name] 和他一样感到饥渴。他们用力地做爱，直到男人最终将他的精液射入她的体内。"])
    add_dialogue("task success2", "sex", ["哇，他真的让你满足了...现在我羡慕你...*咬嘴唇*"])
    add_dialogue("task failure", "sex", ["当男人开始操她时，[girl.name] 仍然很被动。他能感觉到她的反抗，很快就瘫软下来。", "g: 我们的客人抱怨你太糟糕了，然后就离开了！解释一下你自己！ *疯狂的*"],  multiple=True)

    add_dialogue("task description", "cosplay anal", "[girl.fullname]被要求参加一个大型的cosplay活动...除了现在，嘉宾也可以参加！")
    add_dialogue("task success", "cosplay anal", ["一位客人把她的衣服推到一边，开始从后面无情地操她的肛门。她像发情的母狗一样尖叫，最后当男人射在她体内时达到高潮。", "g: 哇，肛门真的是你的最爱，不是吗？"], multiple=True)
    add_dialogue("task failure", "cosplay anal", ["在[girl.name]有机会弄清楚自己的方位之前，一个随机的陌生人开始在舞台上操她的屁股。她痛苦地尖叫并收缩她的屁股。过了一会儿，男人决定放弃，因为无法刺入她紧闭的肛门。", "g: 来吧，来点后门的乐趣有什么问题吗？你的主人称之为“训练”吗？ *生气的*"], multiple=True)

    add_dialogue("task description", "anal dance", "[girl.fullname] 被要求为一位古怪的客人跳一种非常特殊的舞蹈...她在被操屁股时能跳多好？")
    add_dialogue("task success", "anal dance", ["[girl.name] 并没有被屁股上的鸡巴所阻碍，而是在跳舞和操客人的同时变得更有创造力。两人很快就达到了高潮。", "g: 很好，你的节奏很完美....我们应该为那个舞蹈找个名字！"], multiple=True)
    add_dialogue("task failure", "anal dance", ["事实证明，一点也不好。过了一会儿，[girl.name]被顾客叫停，痛苦地捂着他的鸡巴。", "g: 你这个畜生！你就不能像一个正经的性奴隶一样控制自己的身体吗？！？"], multiple=True)

    add_dialogue("task description", "anal", "[girl.fullname] 遇到一位好色的绅士，他要求她弯腰。她很清楚接下来会发生什么....")
    add_dialogue("task success1", "anal", ["[girl.name] 当她感觉到男人的鸡巴从后面进入她时，她发出了一声色情的呻吟。当他操她时，她因欲望而尖叫。他终于把所有的东西都倾倒在她柔软的屁股上。"])
    add_dialogue("task success2", "anal", ["我没想到它会适合...但你是天生的！"])
    add_dialogue("task failure", "anal", ["[girl.name] 冷漠地让男人操她的屁股。当他在她体内移动一英寸时，她就会退缩，而这个男人很快就会对她的态度感到恼火。", "g: 我有一位愤怒的客人在抱怨你不知道如何在屁股上插鸡巴。我付钱给你到底是为了什么？ *生气的*"], multiple=True)

    add_dialogue("task description", "toy", "一位客人给了[女孩全名]一个神秘包裹，并带她去了一间私人房间。当她打开它时，她立即明白了对她的期望。")
    add_dialogue("task success", "toy", ["[girl.name] 总是很高兴被介绍新玩具，为她的仰慕者张开双腿，同时让自己达到巨大的高潮。", "g: 很好，我们的客人告诉我你在那里做得非常出色...他还问你现在是否可以归还性玩具？"], multiple=True, sound=s_vibro)
    add_dialogue("task failure", "toy", ["[girl.name] 不习惯性玩具的大小和形状，她完全不会使用它。她甚至不能把自己弄湿。", "g: 真是无能！我还以为你是职业选手呢！ *生气的*"], multiple=True)

    add_dialogue("task description", "geisha bondage", "[girl.fullname] 得到了一套绳子和一件精美的和服。 “我们举世闻名的束缚大赛到了！”")
    add_dialogue("task success", "geisha bondage", ["作为一名绳结专家，[girl.name]将自己紧紧地绑在绳索套装中，然后不小心打开了她的和服，露出了她的束缚。她的作品非常完美，评审团给了她最高分。", "g: 你做到了！我想给你松绑，但是....我什至不知道从哪里开始。"], multiple=True)
    add_dialogue("task failure", "geisha bondage", ["[girl.name] 穿着和服，努力将绳子绑在身上。最终，当她登上舞台时，她被一根松动的绳子绊倒，并在陪审团面前摔倒。", "g: 真是一场灾难....赶紧下台！"], multiple=True, sound=s_crash)

    add_dialogue("task description", "fetish", "[girl.fullname] 被要求满足一位富有绅士更“不寻常”的要求。")
    add_dialogue("task success1", "fetish", ["[girl.name] 完全可以匹配老男人的变态，她甚至建议新的、羞辱性的姿势让他们俩都享受。和她玩了一会后，他让自己在她渴望的脸上用力射精。"])
    add_dialogue("task success2", "fetish", ["看看这烂摊子....可爱！"])
    add_dialogue("task failure", "fetish", ["[girl.name]经历了很多事情，但即使是她也对这个男人的要求感到惊讶。她答应了，但并没有从中得到任何乐趣。最终，该男子意识到自己在浪费时间并离开了。", "g: 不！你好烂！而不是一个好办法！"], multiple=True)

    add_dialogue("task description", "group sex", "[girl.fullname] 加入一大群裸体男女，进行一场全面的狂欢。粗暴的双手抓住她，将她推倒在地，让她被无情地操弄。")
    add_dialogue("task success1", "group sex", ["鸡巴和爱情汁液的气味淹没了 [girl.name]，她成为了这群人的精液倾倒场。在所有男人聚集在一起进行最后一次颜射之前，她一波又一波地高潮了。"])
    add_dialogue("task success2", "group sex", ["哦，我几乎看不到你的脸在这么多的精液下......在这里，让我为你擦拭......"])
    add_dialogue("task failure", "group sex", ["当男人们开始成群操她时，[girl.name] 尖叫起来。她羞愧地捂住脸，大惊小怪。男人们很快就失去了兴趣，并选择了一个更顺从的奴隶。", "g: 你很抱歉吗？对不起还不够好！滚出我的视线！"], multiple=True)

    add_dialogue("task description", "group anal", "[girl.fullname] 加入一大群裸体男女，进行一场全面的狂欢。她被告知要弯下腰，准备好让她的洞被大家使用。")
    add_dialogue("task success1", "group anal", ["当男人们开始操她的火辣洞时，[girl.name] 狂喜地呻吟着，特别关注她的屁眼。最终，他们在集体高潮中射遍了她。"])
    add_dialogue("task success2", "group anal", ["哇，他们开枪这么多，我什至在我的制服上都有一些......把它舔干净！ *傻笑*"])
    add_dialogue("task failure", "group anal", ["当一名男子毫无准备地进入她的肛门时，[girl.name]痛苦地尖叫起来。它关闭了，男人伤了他的鸡巴。他把她扔到一边，抱怨他的伙伴们不要管这个。", "g: 那太可悲了。你还称自己为性奴隶？离开这里！ *疯狂的*"], multiple=True)

    add_dialogue("task description", "bisexual service", "[girl.fullname] 被要求为一位要求特殊服务的女性客人提供服务。")
    add_dialogue("task success1", "bisexual service", ["[girl.name] 精通女同性恋艺术，她用手指和舌头让女士达到摇滚的高潮。她舔着涌出的爱情汁液，作为女人的回报。"], sound=s_ahaa)
    add_dialogue("task success2", "bisexual service", ["哦，你们女孩们看起来玩得很开心....介意我加入吗？ *眨眼*"])
    add_dialogue("task failure", "bisexual service", ["[girl.name] 不愿意为女性提供服务。她缺乏想象力，试图将自己的一些技巧应用到男性身上，但没有成功。", "g: 那位女士离开了，她看起来很沮丧....现在就到我的办公室来！"], multiple=True)

    add_dialogue("task description", "bisexual fetish", "[girl.fullname] 被要求为一位要求更多“异国情调”服务的女客人提供服务。")
    add_dialogue("task success1", "bisexual fetish", ["打开装满配件的工具包，这位女士命令 [girl.name] 摆出各种性感姿势。两人都用玩具让自己一次次达到高潮。"])
    add_dialogue("task success2", "bisexual fetish", ["哇，看看你自己吧！就像间歇泉...我希望我能像那样喷水。"])
    add_dialogue("task failure", "bisexual fetish", ["当这位女士向她介绍各种危险工具时，[girl.name] 颤抖着。当这个女人为所欲为时，她不舒服地蠕动和尖叫。", "g: 这位女士告诉我你的表现....令人印象深刻。我的印象是你是一个很好的性奴隶。显然，这是一个错误。"], multiple=True)

    ### GENERIC ###

    add_dialogue("girl introduction", "generic", ["您好。我叫[girl.fullname]。", "我是[girl.fullname]。感谢您买下我..."])
    add_dialogue("girl introduction", "extravert", ["你好！我是[girl.name]。希望我可以让您满意。", "主人，你可以叫我[girl.name]。"])
    add_dialogue("girl introduction", "introvert", [".....",  "我是....[girl.fullname]。"])

    add_dialogue("slave thanks", ("generic"), ["谢谢。", "谢谢主人。", "谢谢你，[MC.name]。", "你真好。", "谢谢主人。我很感激。", "谢谢你，我很感激。"])
    add_dialogue("slave effusive thanks", ("generic"), ["哦谢谢！太感谢了！", "哦，我好感动！"])

    add_dialogue("slave positive reaction", "generic", ["哇！这个是来做什么的？", "真的吗，主人？ W-为什么？", "噢，主人....你为什么要对我好？", "等等，那是做什么用的？", "主人....为什么？"])
    add_dialogue("slave negative reaction", "generic", ["嘿！这个是来做什么的！", "不，主人！为什么？？？", "等等，那是干什么的？！？", "但是，主人....为什么？？？"])

    add_dialogue("slave whining", "generic", ["噢...", "但...", "但、但是....", "呃？等待...", "哦..."])
    add_dialogue("slave strongly refuse", "generic", "不，主人，不！！！ *哭泣*", sound=s_scream)

    # When admonished by the player
    add_dialogue("slave bullied", ("idealist"), ["但、但是....", "嘿，等等...", "别、别这样...."])
    add_dialogue("slave bullied", ("materialist"), ["...", "好吧，我明白..."])
    add_dialogue("slave bullied", ("dom"), ["什么？？？绝不..."])
    add_dialogue("slave bullied", ("sub"), ["不好了..."])

    add_dialogue("slave apology", ("generic"), ["对不起，主人，我不是故意的....", "对不起，我不应该...", "对不起，主人。不会再发生了...", "我不是故意的....对不起。"])

    add_dialogue("slave hit", ("dom"), ["哎哟!好痛..."])
    add_dialogue("slave hit", ("sub"), ["对不起... *抽泣*"])

    add_dialogue("slave positive fixation accept", "generic", ["哦，我喜欢这样...", "快点，给我吧...", "我感觉身体好热...", "哦，我的那里兴奋起来了......", "哦是的！用力！"])
    add_dialogue("slave negative fixation accept", "generic", ["但是主人，这太恶心了....", "我-我...不太确定...", "C-我们不能做点别的吗？", "我不喜欢，但是....温柔一点，好吗？"])
    add_dialogue("slave negative fixation refuse", "generic", ["不，这个不行！我不喜欢这样做！"])

    ### COMMON SLAVE EVENTS ###

    add_dialogue("slave first visit", ("introvert"), "什....你想让我做什么？")
    add_dialogue("slave first visit", ("extravert"), "你！你要对我做什么？")

    add_dialogue("MC kind promise", ("modest"), ["她回以一个淡淡的微笑。", "g: 谢谢。"], multiple=True, love=2, fear=-3)
    add_dialogue("MC kind promise", ("lewd"), ["她给了你一个怀疑的眼神。", "g: 那可真是太好了*捧读*。"], multiple=True, love=1, fear=-3)
    add_dialogue("MC fair promise", ("generic"), ["她看起来没那么警惕了。", "g: 我明白了。"], multiple=True, fear=-1)
    add_dialogue("MC no promise", ("generic"), ["她低下头，咬着嘴唇。", "g: 好的，主人。"], multiple=True, fear=1)
    add_dialogue("MC harsh promise", ("sub"), "她点点头，泪水无声地顺着脸颊流下。", love=-3, fear=4)
    add_dialogue("MC harsh promise", ("dom"), "她咬紧牙关，露出不爽的表情，但一个字也没有说。", love=-3, fear=2)

    add_dialogue("MC break promise", ("idealist"), "你...你答应过要温柔地对我的...*抽泣*你撒谎！", love=-8)
    add_dialogue("MC break promise", ("materialist"), "你...你答应过不会欺负我的...*抽泣*你骗我！", love=-5)

    add_dialogue("MC fight intro", ("very dom"), ["g: 不！！！你不能逼我这么做！离我远点，你这个混蛋！", "她爆发出惊人的力量与你搏斗。"], multiple=True, sound=s_scream_loud)
    add_dialogue("MC fight intro", ("dom"), ["g: 不...不可能！！！请别这么做！我不会屈服的！", "你慢慢向她走去，她试图击退你。"], multiple=True, sound=s_scream_loud)
    add_dialogue("MC fight intro", ("sub"), ["g: 你不能！这个不行...不，拜托！", "她看起来很害怕，但又充满了愤怒。没想到，她居然敢反抗你，并试图把你推开。"], multiple=True, sound=s_scream_loud)
    add_dialogue("MC fight intro", ("very sub"), " 她看起来十分震惊，但她不敢违抗你的命令。") # Very sub girls don't fight back

    add_dialogue("slave fear intro", ("generic"), "当你靠近时，她因恐惧而畏缩，她的眼睛因惊慌而困惑。她没有能力回答你的问题。")
    add_dialogue("slave fear reassure success", ("generic"), "她稍微放松了一些，似乎终于明白了你话里的意思。", fear=-2)
    add_dialogue("slave fear reassure failure", ("generic"), "她颤抖着摇着头，看上去太害怕了，无法回答你。最终，你放弃了。", fear=-1)
    add_dialogue("slave fear discipline", ("generic"), "你一巴掌打在她脸上。泪水从她的脸上流下来，她现在因恐惧而颤抖。尝试与她交谈是没有用的。", fear=1)

    add_dialogue("slave naked request permanent", ("lewd"), "我明白了...好吧，为什么不呢？光着身子的感觉真好，反正赞的天气太热了，不适合穿衣服....", sound=s_mmmh, love=2, fear=-1)
    add_dialogue("slave naked request permanent", ("modest"), ["g: 但-但是...我-我...我不能...*脸红*", "mc: 你必须这样做。我给你下了命令。", "g: 很好，那么...如果...如果我别无选择...*脸红*"], multiple=True, sound=s_sigh, love=1, fear=1)
    add_dialogue("slave naked request accept", ("generic"), "我....我要让大家看看我丢人的身体，然后....*脸红*", sound=s_ahaa, love=1)
    add_dialogue("slave naked request resist", ("generic"), "这太恶心了....不....", love=-1, fear=-2)

    add_dialogue("slave toggle naked on", "lewd", "哦，我很乐意这么做！ *微笑*", mood=1)
    add_dialogue("slave toggle naked on", "modest", "好的主人，如果这是您的命令...", mood=-1)
    add_dialogue("slave toggle naked off", "lewd", "嗯...当然...我这就去换衣服...", mood=-1)
    add_dialogue("slave toggle naked off", "modest", "总算...我感觉每个人都在盯着我...*脸红*", mood=1)

    add_dialogue("slave toggle customer sex on", "dom", "知道了，你用不着一直重复。", mood=1)
    add_dialogue("slave toggle customer sex on", "sub", "哦，我以为你想要我....没关系。", mood=-1)
    add_dialogue("slave toggle customer sex off", "dom", "什么？我连这点自由都没有吗？", mood=-1)
    add_dialogue("slave toggle customer sex off", "sub", "噢、当然了，主人。只要您开心...", mood=1)

    add_dialogue("slave train beg", ("generic"), ["[girl.name]跪下，泪流满面地恳求你。", "g: 主人，求你了，不要！！！别这样....求你了，请温柔点...."], multiple=True)
    add_dialogue("slave punish beg", ("generic"), ["[girl.name] 因恐惧而退缩，双手合十乞求你的怜悯。", "g: 主人，求你了，不要！！！我很抱歉！我不会再这样做了！"], multiple=True)
    add_dialogue("slave beg proceed", ("generic"), "不要！！！", sound=s_scream_loud, fear=1, love=-1, mood=-3)
    add_dialogue("slave beg warning", ("generic"), "我明白了，主人....", sound=s_sigh, fear=1)
    add_dialogue("slave beg give up", ("generic"), ["g: 对不...等等，您说什么？", "mc: 你没听错。我说没事了，不用紧张。", "g: 哦，谢谢你，您对我真好！"], multiple=True, sound=s_surprise, fear=-1, love=1)

    add_dialogue("slave send to master bedroom love +", "generic", ["当她听到你的话时，她高兴得浑身发抖。", "g: 噢，主人，我太高兴了....*脸红*"], multiple=True)
    add_dialogue("slave send to master bedroom love", "generic", ["她看着你，眼里闪烁着光芒。", "g:  去你的房间吗？这是不是意味着....我们会整晚都在一起？嗯..."], multiple=True)
    add_dialogue("slave send to master bedroom love -", "generic", ["她耸耸肩。", "g: 如果你这么说的话...."], multiple=True)
    add_dialogue("slave send to master bedroom fear +", "generic", ["当她听到你的声音时，她会害怕得发抖。", "g: 我...我会...主人..."], multiple=True)
    add_dialogue("slave send to master bedroom fear", "generic", ["她太害怕你而不敢不服从。", "g: 我...噢...好吧..."], multiple=True)
    add_dialogue("slave send to master bedroom fear -", "generic", ["她耸耸肩。", "g: 如果我必须...."], multiple=True)

    add_dialogue("slave leave master bedroom love +", "generic", ["她的眼睛里充满了泪水。", "g: 主人，不要让我离开....我想和你在一起！"], multiple=True)
    add_dialogue("slave leave master bedroom love", "generic", ["她叹了口气。", "g: 主人，您要解雇我吗？噢..."], multiple=True)
    add_dialogue("slave leave master bedroom love -", "generic", ["她耸耸肩。", "g: 当然。反正我已经无聊了..."], multiple=True)
    add_dialogue("slave leave master bedroom fear +", "generic", ["她如释重负地浑身发抖。", "g: 噢、当然了，主人....谢谢....谢谢...."], multiple=True)
    add_dialogue("slave leave master bedroom fear", "generic", ["她似乎松了口气。", "g: 当然，我会..."], multiple=True)
    add_dialogue("slave leave master bedroom fear -", "generic", ["她耸耸肩。", "g: 好吧！一刻也不早。"], multiple=True)

    ### SLAVE CHATTING ###

    # Most consequences of chatting are handled in the 'resolve' method.

    add_dialogue("slave chat slave_life -2", ("sub"), ["她的眼睛里充满了泪水，看上去很绝望。", "g: 我...我不知道我在这里做什么...这一定是一个可怕的错误...*抽泣*"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life -1", ("sub"), ["她看起来悲伤而失败。", "g: 我不想成为奴隶...."], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0", ("sub"), ["她给你一个悲伤的表情。", "g: 这是我的职责。我喜不喜欢并不重要。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0.5", ("sub"), ["她鞠躬。", "g: 做你的奴隶也不错，主人。还有更糟糕的事情可能发生在我身上。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 1", ("sub"), ["她笑了。", "g: 我喜欢这里，主人。我感到....安全。我不知道如果我有空我会做什么..."], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 2", ("sub"), ["她跪下并深深鞠了一躬。", "g: 主人，我喜欢做你的奴隶！和你在一起的生活比我能想到的要好得多。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 2", ("sub"), ["她用崇拜的眼神看着你。", "g: 主人，我喜欢做你的奴隶！和你在一起的生活比我能想到的要好得多。"], multiple=True, unlock="DS")

    add_dialogue("slave chat slave_life -2", ("dom"), ["她用布满血丝的眼睛看着你。", "g: 我他妈的讨厌它！我恨它！！！我又不是一块动产....放开我，该死！"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life -1", ("dom"), ["她给你一个生气的表情。", "g: 我不想当奴隶！太可怕了！"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0", ("dom"), ["她翻白眼。", "g: 我，一个奴隶！我做了什么值得这样....好吧，无论如何，我现在在这里。 *叹*"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0.5", ("dom"), ["她叹了口气。", "g: 它有它的优点和缺点。当然我更喜欢自由..."], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 1", ("dom"), ["她给你一个淡淡的微笑。", "g: 说实话，情况并没有我想象的那么糟糕。我已经习惯了。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 2", ("dom"), ["她给了你一个大大的微笑。", "g: 生活真好！我从没想过我会这么说，但我很幸运能成为你的奴隶。谢谢。"], multiple=True, unlock="DS")

    add_dialogue("slave chat brothel -2", ("lewd"), ["她看起来很沮丧。", "g: 这个地方又可怕又肮脏！这里的条件....太糟糕了！"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel -1", ("lewd"), ["她看起来很生气。", "g: 我不在乎这是青楼还是宫殿....但是这个地方就是垃圾场！"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0", ("lewd"), ["她沉默了一会儿。", "g: 这不是我想象中的青楼，你知道....哪里来的奢华和魅力？但我挺过去了..."], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0.5", ("lewd"), ["她给你一个虚弱的微笑。", "g: 虽然很难，但我想在这样的地方工作也很有趣。我学到了一些东西。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel virgin", ("lewd"), ["她脸红.", "g: 这里太疯狂了，这让我很好奇...尽管我从来没有...嗯..."], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 1", ("lewd"), ["她舔了舔嘴唇.", "g: 这里发生了很多事情，我永远不会感到无聊......而且我偶尔可以享受一次美好的性爱！ *脸红*"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 2", ("lewd"), ["她给你一个狂热的表情。你可以看到她直立的乳头从她的奴隶裙下脱颖而出。", "g: 这个地方就像天堂一样....我喜欢和男人一起享受乐趣，在这里我可以获得我想要的所有性爱。多么美妙的经历啊！"], multiple=True, unlock="LM")

    add_dialogue("slave chat brothel -2", ("modest"), ["她的眼睛燃烧着，声音因正义的愤怒而颤抖。", "g: 你他妈在开玩笑吗？这是罪恶和堕落的巢穴！让我离开这里，现在！！！"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel -1", ("modest"), ["她看起来很生气。", "g: 这个地方是肮脏的青楼！我不是那种女孩...我在这里做什么...*抽泣*"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0", ("modest"), ["她低下头。", "g: 我还是不敢相信我在这种地方工作....主人，我真的必须这么做吗？"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0.5", ("modest"), ["她耸耸肩。", "g: 我最不想在青楼工作....但现在我还好。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel virgin", ("modest"), ["她耸耸肩。", "g: 听着，你知道我没有和其他女孩一样的经历，这并不是我梦想的生活。但我挺过去了。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 1", ("modest"), ["她脸红.", "g: 我一直认为青楼是最糟糕的。但现在我在这里工作了，我想其实还不错。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 2", ("modest"), ["她脸红了，咬着嘴唇。", "g: 说起来很羞耻，但我喜欢这里...我从来没有想过我会成为这样的女孩，但是... *脸红*"], multiple=True, unlock="LM")

    add_dialogue("slave chat customers -2", ("idealist"), ["她看上去悲伤又沮丧。", "g: 我讨厌他们对待我的方式！我尽我最大的努力去服务，但他们却不断地伤害和虐待我...... "], multiple=True, unlock="MI")
    add_dialogue("slave chat customers -1", ("idealist"), ["她看起来很沮丧。", "g: 他们对待我就像对待牛一样。我明白，每个人都有自己的难处，但为什么他们要把问题发泄到我身上呢？"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 0", ("idealist"), ["她叹了口气。", "g: 我想，顾客有好有坏....不友好的顾客可能会非常粗鲁。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 0.5", ("idealist"), ["她微微一笑。", "g: 他们总是向我倾诉他们的家庭、他们的艰辛、他们破碎的心....我想我可以提供帮助，即使必须以这种奇怪的方式。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 1", ("idealist"), ["她心情轻松起来。", "g: 噢，顾客们，他们就像我的朋友一样！我们越亲密，我就越了解他们，也越了解我自己。这是一种养育关系。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 2", ("idealist"), ["她脸上洋溢着自豪的笑容。", "g: 我很高兴能够帮助顾客忘记他们的痛苦和烦恼！我真的很喜欢为他们服务....我会尽一切努力让他们开心。"], multiple=True, unlock="MI")

    add_dialogue("slave chat customers -2", ("materialist"), ["她勃然大怒。", "g: 我讨厌那些畜生！！！为什么我要侍奉这些恶心的猪？"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers -1", ("materialist"), ["她的声音因愤怒而颤抖。", "g: 一群好色的混蛋，就是这样！他们为什么不打扰其他女孩？"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 0", ("materialist"), ["她看起来很沮丧。", "g: 顾客，他们真是粗鲁....我希望没有他们我们也能继续营业，但这不是一个选择。 *叹*"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 0.5", ("materialist"), ["她耸耸肩。", "g: 他们中的一些人可能很粗鲁和吝啬，但我想我已经学会了如何应对他们。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 1", ("materialist"), ["她嗤之以鼻。", "g: 他们一直命令我做这做那....但我只要给他们正确的表情，他们就成了我的宠物！ *眨眼*"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 2", ("materialist"), ["她笑得很善意。", "g: 哦，我爱顾客！他们总是给我带来礼物并称赞我。这并不痛，你知道吗？"], multiple=True, unlock="MI")

    add_dialogue("slave chat other_girls -2", ("extravert"), ["她看上去既生气又不高兴。", "g: 交朋友？你认为我有时间做这些吗，当我被困在这个恶心的牢房里时，所有的家务事都堆积如山！"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls -1", ("extravert"), ["她看起来很沮丧。", "g: 我没有时间和其他女孩说话，而且我不喜欢她们。我希望有机会结交朋友。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 0", ("extravert"), ["她皱眉.", "g: 有些女孩比其他女孩更好。但我确信有人在背后对我说坏话。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 0.5", ("extravert"), ["她思考了一会儿.", "g: 我有时间去见其他女孩并和她们聊天。我不能说我拥有令人惊叹的社交生活，但这只是一个开始。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 1", ("extravert"), ["她笑了。", "g: 我很高兴我在这里并不孤单。这里的大多数人都很好，真的！"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 2", ("extravert"), ["她给你一个温暖而幸福的微笑。", "g: 和其他女孩在一起真是太好了！我们一起出去玩，我们一起做所有事情，甚至...... *脸红*无论如何，我爱他们！"], multiple=True, unlock="EI")

    add_dialogue("slave chat other_girls -2", ("introvert"), ["她无声地流泪，然后突然泪流满面。", "g: 我恨他们！我不想和他们有任何关系..."], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls -1", ("introvert"), ["她看上去很不高兴。", "g: 我一个都不喜欢。我希望人们别打扰我。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 0", ("introvert"), ["她低下头。", "g: 他们中的大多数人对我都很刻薄....我想这是可以预料到的。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 0.5", ("introvert"), ["她看起来很沉思。", "g: 我比较独来独往，但我想有些女孩还不错。我真的没有时间和他们一起出去玩。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 1", ("introvert"), ["她给你一个害羞的微笑。", "g: 有些女孩比其他女孩更友善。我不介意和他们一起出去玩。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 2", ("introvert"), ["她看起来很高兴。", "g: 这里的女孩们就像家人一样。有时我们会争吵、打架，但我们会互相支持。我感到开心。"], multiple=True, unlock="EI")

    add_dialogue("MC praise friend", ("generic"), "噢，谢谢主人！她会很高兴听到你这么说。 *微笑*", sound=s_laugh)
    add_dialogue("MC demean rival", ("generic"), "哦，我会告诉她的！她会生气的！ *笑*", sound=s_evil_laugh)

    add_dialogue("slave chat well_being -3", ("generic"), "我感觉很糟糕。我想离开这里。求求你了，主人，不要就这样离开我....*呜咽*", unlock="MI")
    add_dialogue("slave chat well_being -2", ("generic"), "我感觉不太舒服。这个地方实在是太拖累我了....", unlock="MI")
    add_dialogue("slave chat well_being -1", ("generic"), "哼，我不能说我在这里感觉很好。这不是一种舒适的生活。", unlock="MI")
    add_dialogue("slave chat well_being 0", ("generic"), "我想，我还好。", unlock="MI")
    add_dialogue("slave chat well_being 1", ("generic"), "我在这里很快乐。请继续好好照顾我，主人.", unlock="MI")
    add_dialogue("slave chat well_being 2", ("generic"), "我在这里很开心，主人。我想要改变的事情很少。", unlock="MI")
    add_dialogue("slave chat well_being 3", ("generic"), "我喜欢在这里工作，主人。我尽可能地感到舒适和快乐！", unlock="MI")

    add_dialogue("slave chat well_being attacked", ("generic"), "在过去的一个月里，我遭到攻击和伤害 [nb_times] 次。那太糟糕了。请保护我们吧，主人！")
    add_dialogue("slave chat well_being sick", ("generic"), "过去一个月我生病了 [nb_times] 次。这并不令人愉快。 [MC.name] 主人，请确保这个地方始终干净。")
    add_dialogue("slave chat well_being exhausted", ("generic"), "过去一个月，我因过度劳累而感到疲惫不堪[nb_times]。我太累了...请确保我的日程安排合理，[MC.name]主人...")

    add_dialogue("slave chat well_being MC apology", ("idealist"), "我明白。我会尝试忍受它。")
    add_dialogue("slave chat well_being MC apology", ("materialist"), "我不需要借口！我想要更好的条件....唉....")

    add_dialogue("slave chat feelings love -1", ("generic"), "我不觉得我们很亲近。", unlock="DS")
    add_dialogue("slave chat feelings love 0", ("generic"), "你没事吧。我觉得你很善良。", unlock="DS")
    add_dialogue("slave chat feelings love 1", ("generic"), "我喜欢你。我很高兴为您服务。", unlock="DS")
    add_dialogue("slave chat feelings love 2", ("generic"), "我爱你，主人。我想一直和你在一起。", unlock="DS")

    add_dialogue("slave chat feelings fear -1", ("generic"), "有时你可能会....有点刻薄。", unlock="DS")
    add_dialogue("slave chat feelings fear 0", ("generic"), "你....你有时让我担心。我怕让你不高兴。", unlock="DS")
    add_dialogue("slave chat feelings fear 1", ("generic"), "我不想让您失望，主人。你生气的时候很可怕。", unlock="DS")
    add_dialogue("slave chat feelings fear 2", ("generic"), "我....我会做任何事，Master。别、别....别伤害我....", unlock="DS")

    add_dialogue("slave chat feelings very disobedient", ("sub"), "虽然我是奴隶，但我不准备接受你的命令。", unlock="DS")
    add_dialogue("slave chat feelings very disobedient", ("dom"), "但我不承认你是‘Master’之类的！", unlock="DS")

    add_dialogue("slave chat feelings disobedient", ("sub"), "不过，我是奴隶，所以我会听从你的指示，只要它们是合理的。", unlock="DS")
    add_dialogue("slave chat feelings disobedient", ("dom"), "不是要戳破你的幻想，但我也不会向你低头。我希望你能正确对待我。", unlock="DS")

    add_dialogue("slave chat feelings a little obedient", ("sub"), "无论如何，我还是你的奴隶。请照顾我。", unlock="DS")
    add_dialogue("slave chat feelings a little obedient", ("dom"), "我想我是个奴隶，所以我必须听从你的命令。不过，别逼我太紧。", unlock="DS")

    add_dialogue("slave chat feelings obedient", ("sub"), "我尊敬您作为我的主和主人。", unlock="DS")
    add_dialogue("slave chat feelings obedient", ("dom"), "我是来尊重你的。作为我的....主人，我想。 *吞*", unlock="DS")

    add_dialogue("slave chat feelings very obedient", ("sub"), "我喜欢为您服务，主人。我是你忠实的仆人。", unlock="DS")
    add_dialogue("slave chat feelings very obedient", ("dom"), "为您服务是我的荣幸，主人。有什么事就问我吧。", unlock="DS")

    add_dialogue("slave chat tastes likes", ("generic"), "我最喜欢的[thing_cn]是[best]。我很喜欢！", unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("generic"), "我最不喜欢的[thing_cn]是[worst]. 呸!", unlock="LM")

    # For presents
    add_dialogue("slave chat tastes loves +", ("generic"), "你知道什么会让我如此高兴吗？我喜欢[thing_cn]...我希望我有一些。", unlock="LM")
    add_dialogue("slave chat tastes loves -", ("generic"), "我喜欢[thing_cn]。他们很好。", unlock="LM")
    add_dialogue("slave chat tastes no loves", ("generic"), "礼物对我来说没有什么好处。这不关我的事。", unlock="LM")

    add_dialogue("slave chat tastes hates", ("generic"), "我真的很讨厌[thing_cn]。请不要给我那样的东西。", unlock="LM")
    add_dialogue("slave chat tastes no hates", ("generic"), "我喜欢礼物，无论它是什么。", unlock="LM")

    add_dialogue("slave chat tastes positive act", ("modest"), "我注意到我对 [act_desc] 感兴趣...你认为这是答错了吗？", unlock="LM")
    add_dialogue("slave chat tastes positive act", ("lewd"), "最近，我更喜欢[act_desc]...我想我喜欢尝试新事物。", unlock="LM")

    add_dialogue("slave chat tastes negative act", ("modest"), "你知道，[act_desc] 让我非常不舒服......我认为它很脏。", unlock="LM")
    add_dialogue("slave chat tastes negative act", ("lewd"), "不知何故，[act_desc] 让我感到不舒服....有一些事情让我烦恼。", unlock="LM")
    add_dialogue("slave chat tastes no negative act", ("modest"), "性行为当然是可耻的，但我不认为有比其他性行为更糟糕的行为......", unlock="LM")
    add_dialogue("slave chat tastes no negative act", ("lewd"), "我认为那里有各种各样的性幻想......我真的不介意任何事情。生命短暂！", unlock="LM")


    add_dialogue("slave chat origins 1", ("extravert"), "我来自[girl.origin]。没有一个地方像家一样，不是吗？那里有我太多的回忆...", unlock="EI")
    add_dialogue("slave chat origins 1", ("introvert"), "我来自[girl.origin]。我想这是一个和其他地方一样的地方。我没见过太多的世界。", unlock="EI")
    add_dialogue("slave chat origins 2", ("extravert"), "我曾经和我的 [girl.story_guardian] 一起住在 [girl.origin] 附近的 [a_home]。那些日子...", unlock="EI")
    add_dialogue("slave chat origins 2", ("introvert"), "我曾经和我的 [girl.story_guardian] 一起住在 [girl.origin] 附近的 [a_home]。我不太适合那里....但这就是我所知道的一切。", unlock="EI")
    add_dialogue("slave chat origins 3", ("generic"), "我记得我和我的[girl.story_guardian]住的[girl.story_home]...", unlock="EI")

    ### SLAVE ORIGIN DIALOGUE ###

    add_dialogue("origin Zan", "generic", "我对昝的老街了如指掌....以前我和我的[girl.story_guardian]一起去市场，好奇那些挂着红灯笼的奇怪房子是什么....现在我知道了.... *脸红*")
    add_dialogue("origin the border with the Holy Lands", "generic", "圣地一直是一个充满战争和苦难的地方。尽管如此，我仍然记得一些平静的时刻。和我的[girl.story_guardian]一起走过古老的战场，开满红色的花朵，看着大自然收回它的权利......")
    add_dialogue("origin the Blood Islands", "generic", "血腥群岛是一个残酷的地方....我记得和我的[girl.story_guardian]一起去竞技场，看着奴隶被怪物撕成碎片....或者更糟。真是血腥又刺激。相比之下，这里的竞技场就显得非常温和了。")
    add_dialogue("origin Karkyr", "generic", "卡基尔是一座美丽而迷人的城市，由大法师议会统治。一切都是神奇的，连水井和家具都会说话。它曾经把我的[girl.story_guardian]吓坏了！当然，也有一些壮观的事件，但这也是乐趣的一部分。")
    add_dialogue("origin Westmarch", "generic", "我长大的威斯特玛公国是一个非常难以预测的地方。有一天，一座城市欣欣向荣，第二天，它就陷入无政府状态，掠夺者掠夺和掠夺城镇。我曾经认为危险是令人兴奋的，但我的[girl.story_guardian]一点也不喜欢它。")
    add_dialogue("origin the desert of Hokoma", "generic", "沙漠民族是安静而聪明的民族。我的[girl.story_guardian]知道很多秘密，并且知道如何保守它们。我怀念沙漠里夜晚的宁静。")
    add_dialogue("origin Borgo, the port city", "generic", "博尔戈在大多数日子里是多么繁忙和拥挤，无法形容，来自世界各地的水手出售你能想象到的所有东西，还有许多其他东西。我喜欢在清晨和我的 [girl.story_guardian] 坐在码头边，聆听海浪的声音。")
    add_dialogue("origin the Goliath desolations", "generic", "荒凉的地方是一个寒冷、可怕的地方。无论贫穷还是富有，每天都必须努力工作，才能勉强生存。如果我没有[girl.story_guardian]可以依靠，我不知道我是否还能活下来。")
    add_dialogue("origin the Arik mountains", "generic", "他们说阿里克山脉是世界上最高的山脉。上面的空气很纯净，不像下面那样充满污秽和魔法的味道....我的[girl.story_guardian]教会了我如何热爱和尊重山脉。")


    ### SLAVE TRAINING DIALOGUE ###

    # Most consequences of training are handled in the 'resolve' method.

    add_dialogue("slave train accepted", ("generic"), ["是的主人。", "遵命，主人。", "哦，[MC.name]主人...*脸红*", "当然，主人。"])
    add_dialogue("slave train resisted", ("dom"), ["主人请！别....别逼我这么做....", "不，等等....我不想！", "但、但是....我不喜欢这样！"])
    add_dialogue("slave train resisted", ("sub"), ["主人，求你了....不....", "主人，求求你了，我不想这么做....", "不能....我们不能做点别的吗？", "我、我必须吗，真的吗？我不能..."])
    add_dialogue("slave train refused", ("dom"), ["决不！！！我不是荡妇！", "我不会这么做！我不会。这是最终的。", "把你的脏爪子从我身上拿开！！！", "什么？不！！！滚蛋！"])
    add_dialogue("slave train refused", ("sub"), ["主人，这....不可能！不！", "主人，对不起，我....我做不到！", "不、不，不是这个....这是....它很脏！"])

    add_dialogue("slave lecture love", "extravert", "很高兴见到你，[MC.name]主人！我有很多问题...")
    add_dialogue("slave lecture love", "introvert", "噢，主人....*脸红*")

    add_dialogue("slave lecture neutral", "dom", "来给我讲授鸟类和蜜蜂的知识吗？")
    add_dialogue("slave lecture neutral", "sub", "我在听，主人。")

    add_dialogue("slave lecture fear", "lewd", "她很警惕，但又有点好奇。")
    add_dialogue("slave lecture fear", "modest", "她害怕你。")

    add_dialogue("slave lecture refuses", "lewd", "呃！我什至不想去想它。拜托，不要再提这件事了。")
    add_dialogue("slave lecture very reluctant", "lewd", "啊不，不是这个！我不是一个正经的人，但这很令人讨厌。")
    add_dialogue("slave lecture reluctant", "lewd", "我有我的极限，你知道...这太过分了...*脸红*")
    add_dialogue("slave lecture a little reluctant", "lewd", "这不是我最喜欢的...但有时，多样性是好的，我想...", sound=s_sigh)
    add_dialogue("slave lecture indifferent", "lewd", "嗯，这只是利用我们的身体来给予快乐，不是吗？就像任何事情一样。")
    add_dialogue("slave lecture a little interested", "lewd", "[MC.name]主人，关于这个....我想知道....", sound=s_surprise)
    add_dialogue("slave lecture interested", "lewd", "噢，这是个好话题！我想了解更多...", sound=s_mmh)
    add_dialogue("slave lecture very interested", "lewd", "我喜欢 [act_desc]...这让我感觉非常好...嗯。", sound=s_mmh)
    add_dialogue("slave lecture fascinated", "lewd", "哦，[act_desc] 是最好的！我可以做一整天！主人，为什么不让我给你看呢？", sound=s_aah)

    add_dialogue("slave lecture refuses", "modest", "啊，不，不可能！！！这只是针对变态和病人的！")
    add_dialogue("slave lecture very reluctant", "modest", "拜托，光是听到这件事就让我感到不舒服....")
    add_dialogue("slave lecture reluctant", "modest", "我-它...这不适合像我这样的女孩！我对此不感兴趣！ *脸红*")
    add_dialogue("slave lecture a little reluctant", "modest", "我宁愿不这样做....这有点顽皮....", sound=s_sigh)
    add_dialogue("slave lecture indifferent", "modest", "嗯...我想这是我工作的一部分...")
    add_dialogue("slave lecture a little interested", "modest", "哦这个？嗯...没那么糟糕...我的意思是，它很脏，但是...噢...*脸红*", sound=s_surprise)
    add_dialogue("slave lecture interested", "modest", "我从没想过我会这么说，但 [act_desc] 实际上...有趣？", sound=s_mmh)
    add_dialogue("slave lecture very interested", "modest", "当想到 [act_desc] 时，这让我感觉很奇怪....我感到温暖，而且....嗯....", sound=s_mmh)
    add_dialogue("slave lecture fascinated", "modest", "哦，[act_desc] 感觉真好...你一定认为我是个荡妇但是...我...我想要它...", sound=s_aah)

    add_dialogue("slave train obedience", "very dom", "呃....像个愚蠢的仆人一样被命令....")
    add_dialogue("slave train obedience", "dom", "噢，更多的家务活....我想我早该预料到的....")
    add_dialogue("slave train obedience", "very sub", "当然，主人。我会立即着手处理。")
    add_dialogue("slave train obedience", "sub", "是的主人。")

    add_dialogue("slave train constitution", "very introvert", "哦，真的，锻炼吗？我就不能看书吗？ *抱怨*")
    add_dialogue("slave train constitution", "introvert", "如果你这么说，主人.")
    add_dialogue("slave train constitution", "very extravert", "是的先生！锻炼对于健康的身体和精神很重要。")
    add_dialogue("slave train constitution", "extravert", "是的主人。我想我可以做一点运动。")

    add_dialogue("slave train refuses", "lewd", "她对 [act_desc] 的想法感到非常羞愧，甚至无法说话。她的脸是鲜红的。", sound=s_screams)
    add_dialogue("slave train refuses", "modest", "她似乎对 [act_desc] 的想法感到厌恶。她给你一个害怕的表情。", sound=s_screams)
    add_dialogue("slave train very reluctant", "lewd", ["我不喜欢这样......为什么我必须继续这样做？啊！！！", "呃，[act_desc]？你让我这么做，尽管这很变态....哇...."], sound=s_scream)
    add_dialogue("slave train very reluctant", "modest", ["这是可耻的、不道德的。你为什么要让我这样做...", "哦不...这很恶心，很脏...拜托，我们不要..."], sound=s_scream)
    add_dialogue("slave train reluctant", "lewd", "你知道我不喜欢这样...别看我...啊哈！", sound=s_scream)
    add_dialogue("slave train reluctant", "modest", "不，别看我....我感到很羞耻....", sound=s_scream)
    add_dialogue("slave train a little reluctant", "lewd", "你又对我做出变态的事了....我感觉很奇怪....", sound=s_surprise)
    add_dialogue("slave train a little reluctant", "modest", "我真的不想这样做....这是答错了....啊啊！", sound=s_surprise)
    add_dialogue("slave train indifferent", "lewd", "嗯嗯，主人....", sound=s_ahaa)
    add_dialogue("slave train indifferent", "modest", "哦，[MC.name]主人...你真是个变态...*脸红*", sound=s_ahaa)
    add_dialogue("slave train a little interested", "lewd", "哦，那很好....也许我们今天可以尝试一些新的东西？", sound=s_ahaa)
    add_dialogue("slave train a little interested", "modest", "嗯嗯，好像已经习惯了....等等，我不是这个意思！ *恐慌*", sound=s_ahaa)
    add_dialogue("slave train interested", "lewd", "嗯，[act_desc]...我已经感觉湿了...", sound=s_mmmh)
    add_dialogue("slave train interested", "modest", "嗯，[act_desc]...还不错...嗯...", sound=s_mmmh)
    add_dialogue("slave train very interested", "lewd", "我好饥渴....主人看我的时候我就湿了....啊啊啊....", sound=s_aaah)
    add_dialogue("slave train very interested", "modest", "哦，我喜欢这个...我感觉自己像个荡妇...*脸红*", sound=s_aaah)
    add_dialogue("slave train fascinated", "lewd", "哦...我已经快高潮了...啊啊，[act_desc] 真是太棒了！", sound=s_orgasm_fast)
    add_dialogue("slave train fascinated", "modest", "哦主人，[act_desc]感觉真好....我想我已经变成了一个肮脏、肮脏的母狗....", sound=s_orgasm_fast)

    add_dialogue("slave train naked failure", "dom", "不！别看我！", sound=s_surprise)
    add_dialogue("slave train naked failure", "modest", "太可耻了....你没有礼貌....", sound=s_surprise)
    add_dialogue("slave train naked failure", "generic", "停-停止...", sound=s_surprise)
    add_dialogue("slave train naked success", "lewd", "哦，主人，我想要更多....", sound=s_aaah)
    add_dialogue("slave train naked success", "modest", "主人....我喜欢你看着我....", sound=s_aaah)

    add_dialogue("slave train service failure", "lewd", "她感到沮丧和羞愧，开始哭泣。")
    add_dialogue("slave train service failure", "modest", "她完全脱离了这一切。你告诉她停下来。")
    add_dialogue("slave train service success", "dom", "主人，我想要你的精液...请不要让我乞求...")
    add_dialogue("slave train service success", "sub", "你的精液，主人....请用它来沐浴我....")

    add_dialogue("slave train sex failure", "lewd", "好痛....主人，你快结束了吗？")
    add_dialogue("slave train sex failure", "modest", "真是羞耻啊....*呜呜*")
    add_dialogue("slave train sex success", "lewd", "主人，我高潮了....啊啊啊！我喜欢被这样操！")
    add_dialogue("slave train sex success", "modest", "主人，我高潮了....啊啊啊！....当坏女孩真好....")

    add_dialogue("slave train anal failure", "lewd", "我....我不能这样做。不可能。")
    add_dialogue("slave train anal failure", "modest", "啊，好痛....*抽泣*")
    add_dialogue("slave train anal success", "lewd", "啊啊啊！！！我爱死了！啊哈！！！这真是太爽了...")
    add_dialogue("slave train anal success", "modest", "啊啊啊！！！我爱死了！啊哈！！！我就是这样一个妓女...")

    add_dialogue("slave train fetish failure", "lewd", "等等，不是这个！")
    add_dialogue("slave train fetish failure", "modest", "你在干什么！！！停下来！！！")
    add_dialogue("slave train fetish success", "lewd", "主人，请伤害我吧....这让我很开心....啊啊！")
    add_dialogue("slave train fetish success", "modest", "主人....请伤害我吧....我是个顽皮、顽皮的荡妇....")

    add_dialogue("slave train bisexual failure", "lewd", "太糟糕了！我不能对女人做任何正确的事情...")
    add_dialogue("slave train bisexual failure", "modest", "不....女孩子都是肮脏的....")
    add_dialogue("slave train bisexual success", "lewd", "请原谅我，主人，但我必须说....我喜欢小穴....", sound=s_mmh)
    add_dialogue("slave train bisexual success", "modest", "嗯....我不敢相信我现在是个女同性恋了....", sound=s_mmh)

    add_dialogue("slave train group failure", "lewd", "哎呀，三个人太多了，哥们....我们不能轮流做吗？")
    add_dialogue("slave train group failure", "modest", "三人行....真是....太堕落了！！！")
    add_dialogue("slave train group success", "lewd", "我可以服务更多！十几个人！让我证明一下...")
    add_dialogue("slave train group success", "modest", "我现在是一个彻头彻尾的狂欢荡妇...如果我的 [girl.story_guardian] 能看到我...*脸红*")

    add_dialogue("slave magic obedience success", "generic", "你是我的主人。你掌握着钥匙。", sound=s_ahaa)
    add_dialogue("slave magic libido success", "generic", "我能感觉到....好温暖....嗯....", sound=s_mmh)
    add_dialogue("slave magic sensitivity success", "generic", "嗯....我是取悦诸神的容器....", sound=s_mmh)

    add_dialogue("slave magic naked success", "generic", "我必须透露....更多....", sound=s_ahaa)
    add_dialogue("slave magic service success", "generic", "使用我...为了快乐...", sound=s_mmh)
    add_dialogue("slave magic sex success", "generic", "我的子宫....向你敞开....", sound=s_aaah)
    add_dialogue("slave magic anal success", "generic", "哦，我的混蛋....太热了....拜托，想个办法把火扑灭....", sound=s_ahaa)
    add_dialogue("slave magic fetish success", "generic", "啊啊！我感觉虚弱...", sound=s_aah)
    add_dialogue("slave magic bisexual success", "generic", "我应该和女神成为一体....", sound=s_mmh)
    add_dialogue("slave magic group success", "generic", "为一个人服务就是为多人服务...", sound=s_ahaa)

    add_dialogue("slave magic failure", "dom", ["g: 什...你到底在做什么？嘿，你在对我尝试一些肮脏的魔法！哎呀！离开！！！", "她开始尖叫并大惊小怪。当你离开时，她关上了你身后的门。"], multiple=True, sound=s_scream, unlock="DS")
    add_dialogue("slave magic failure", "sub", ["g: 主人....这是怎么回事？这是什么？啊....我感觉恶心....", "她差点晕倒，你派希露去给她拿点水。你离开了，想知道你这次搞砸了什么。"], multiple=True, sound=s_surprise, unlock="DS")


    ### REWARD AND PUNISH DIALOGUE ###

    # Some consequences of rewarding/punishing are handled in the 'resolve' method.
    # The love and fear penalties are modifiers to the interaction score

    add_dialogue("slave reward sex accepted", "very lewd", "当然，主人。我自慰了很多次，想着那一刻....*脸红*", love=2, sound=s_ahaa, unlock="LM")
    add_dialogue("slave reward sex accepted", "lewd", "当然，主人。就在我感到饥渴的时候....*微笑*。", love=1, sound=s_ahaa, unlock="LM")
    add_dialogue("slave reward sex accepted", "very modest", "噢，主人。我们就像恋人......噢......*脸红*", love=-1, sound=s_ahaa, unlock="LM")
    add_dialogue("slave reward sex accepted", "modest", "当然，主人。请...温柔点...*微笑*", love=-0.5, sound=s_ahaa, unlock="LM")

    add_dialogue("slave reward sex resisted", "very dom", "什么？不！！！这是什么奖励啊！！！", love=-2, sound=s_surprise, unlock="LM")
    add_dialogue("slave reward sex resisted", "dom", "这....这连奖励都算不上....唉....", love=-1, sound=s_surprise, unlock="LM")
    add_dialogue("slave reward sex resisted", "very sub", "但、但是....我不想....你要....强迫我吗？", love=1, sound=s_surprise, unlock="LM")
    add_dialogue("slave reward sex resisted", "sub", "噢，我不想那样做！请你想想别的办法吧！", love=0.5, sound=s_surprise, unlock="LM")

    # The love/fear penalty when refusing is handled within the 'resolve' method
    add_dialogue("slave reward sex refused", "dom", "什么？！？决不！！！离我远点！！！", sound=s_scream)
    add_dialogue("slave reward sex refused", "sub", "等等，不！！！我不想...", sound=s_surprise)

    add_dialogue("slave reward praise", "very idealist", "谢谢主人。我会让你感到骄傲。", unlock="MI", love=1)
    add_dialogue("slave reward praise", "idealist", "谢谢主人。我很高兴听到这个消息。", unlock="MI", love=0.5)
    add_dialogue("slave reward praise", "very materialist", "嗯...你要给我一些东西吗？言语很廉价。", love=-1, unlock="MI")
    add_dialogue("slave reward praise", "materialist", "谢谢，我想...这是否意味着我会得到奖励？", love=-0.5, unlock="MI")

    add_dialogue("slave reward gold", "very idealist", "嗯...感觉就像你想贿赂我...但是谢谢，我想。", love=-1, unlock="MI")
    add_dialogue("slave reward gold", "idealist", "好，谢谢。", love=-0.5, unlock="MI")
    add_dialogue("slave reward gold", "very materialist", "哦，金子！太好了....谢谢主人！", love=1, unlock="MI")
    add_dialogue("slave reward gold", "materialist", "谢谢主人。我会好好利用这个。", love=0.5, unlock="MI")

    add_dialogue("slave reward pet", "very dom", ["你试图拥抱她，但她很紧张并且回避。", "g: 拥抱，认真的吗？快点..."], multiple=True, love=-1, unlock="DS")
    add_dialogue("slave reward pet", "dom", ["你拍拍她的头一分钟，而她只是被动地站在那里。结束后她迅速离开。", "g: 谢谢....这就足够了。我得走了。"], multiple=True, love=-0.5, unlock="DS")
    add_dialogue("slave reward pet", "very sub", ["你把她抱在膝盖上，拍拍她的头一分钟。你几乎可以听到她的呼噜声。", "g: 噢，主人....在你的怀抱里我感觉很安全...."], multiple=True, love=1, unlock="DS")
    add_dialogue("slave reward pet", "sub", ["你给了她一个拥抱，她靠在你的肩上，把头靠在你的肩上。", "g: 谢谢主人。感觉不错..."], multiple=True, love=0.5, unlock="DS")

    add_dialogue("slave reward day off", ("very dom", "very extravert"), "谢谢主人！终于，我可以做任何我想做的事情了！", love=1, unlock="DS")
    add_dialogue("slave reward day off", ("dom", "extravert"), "真的吗？谢谢主人，真是一​​个惊喜....", love=0.5, unlock="DS")
    add_dialogue("slave reward day off", ("very sub", "very introvert"), "呃，什么？但、但是....我应该去哪里？？？", love=-1, unlock="DS")
    add_dialogue("slave reward day off", ("sub", "introvert"), "呃？嗯....谢谢主人。我会努力享受它。", love=-0.5, unlock="DS")
    add_dialogue("slave reward day off KO", "generic", ["g: 但是主人，今天已经是我休息的日子了....", "mc: 啊，对了。我已经忘记了。"], multiple=True)

    add_dialogue("slave punish scold deserved", "very idealist", ["她看起来被你的评论深深伤害了。", "g: 我知道，我必须做得更好....对不起。"], multiple=True, fear=1, unlock="MI")
    add_dialogue("slave punish scold deserved", "idealist", ["她看起来很受伤。", "g: 很抱歉我总是没有让您满意。"], multiple=True, fear=0.5, unlock="MI")
    add_dialogue("slave punish scold deserved", "very materialist", ["她嗤之以鼻。", "g: 是的，对....随你怎么说。"], multiple=True, fear=-1, love=-0.5, unlock="MI")
    add_dialogue("slave punish scold deserved", "materialist", ["她看起来很生气。", "g: 哼...."], multiple=True, fear=-0.5, unlock="MI")

    add_dialogue("slave punish scold undeserved", "very idealist", ["她看起来被你的评论深深伤害了。", "g: 那不是真的...我正在尽力！"], multiple=True, fear=1, love=-2, unlock="MI")
    add_dialogue("slave punish scold undeserved", "idealist", ["她看起来很受伤。", "g: 这不是真的！我不值得受到这样的虐待！"], multiple=True, fear=0.5, love=-1, unlock="MI")
    add_dialogue("slave punish scold undeserved", "very materialist", ["她嗤之以鼻。", "g: 是的，对....随你怎么说。"], multiple=True, fear=-1, love=-0.5, unlock="MI")
    add_dialogue("slave punish scold undeserved", "materialist", ["她看起来很生气。", "g: 哼...."], multiple=True, fear=-0.5, unlock="MI")

    add_dialogue("slave punish upkeep", ("very idealist"), "如果我必须....那就这样吧。", fear=-1, unlock="MI")
    add_dialogue("slave punish upkeep", ("idealist"), "噢...", fear=-0.5, unlock="MI")
    add_dialogue("slave punish upkeep", ("very materialist"), "什么？！？不！！！", fear=1, unlock="MI")
    add_dialogue("slave punish upkeep", ("materialist"), "工作没钱？噢，拜托！", fear=-0.5, unlock="MI")
    add_dialogue("slave punish upkeep KO", "generic", ["g: 但、但是....你已经剥夺了我的零用钱....", "mc: 哦，对了，哈哈....我只是在测试你。"], multiple=True)

    add_dialogue("slave punish beat", "very dom", ["当你恶毒地打她时，她会大喊大叫，无休止地辱骂她。", "g: 这是你能做的最好的事情了吗？啊啊！！！你这个混蛋....啊啊！"], multiple=True, fear=-1, sound=s_screams, unlock="DS")
    add_dialogue("slave punish beat", "dom", ["她咬紧牙关，等待惩罚结束。", "我不在乎你对我做什么...啊啊！！！"], multiple=True, fear=-0.5, sound=s_screams, unlock="DS")
    add_dialogue("slave punish beat", "very sub", ["当你打她时，她会抽泣，直到她的屁股完全变红。", "g: 哦....对不起，主人....*呜咽*"], multiple=True, fear=1, sound=s_screams, unlock="DS")
    add_dialogue("slave punish beat", "sub", ["当你让她尝尝你的管教时，她会随着每一次打击而哭泣和尖叫。", "g: 啊！啊啊哈！！！主人....拜托....啊啊！"], multiple=True, fear=0.5, sound=s_screams, unlock="DS")

    add_dialogue("slave punish farm", "very dom", "你不能这样对我！不！！！ *害怕的*", fear=1, unlock="DS")
    add_dialogue("slave punish farm", "dom", "农场？你在想什么？！？", fear=0.5, unlock="DS")
    add_dialogue("slave punish farm", "very sub", "...", fear=-1, unlock="DS")
    add_dialogue("slave punish farm", "sub", "农场....真是个可怕的地方....", fear=-0.5, unlock="DS")

    add_dialogue("slave punish naked", "very lewd", "主人....你在做什么....啊啊！", fear=-1, unlock="LM")
    add_dialogue("slave punish naked", "lewd", "不，主人....不是那样的....*抽泣*", fear=-0.5, unlock="LM")
    add_dialogue("slave punish naked", "very modest", "哎呀！！！别碰我！！！不！！！", fear=1, unlock="LM")
    add_dialogue("slave punish naked", "modest", "不！！！你以为你在做什么！！！", fear=0.5, unlock="LM")
    add_dialogue("slave punish naked KO", "generic", ["g: 呃？但是主人....我已经赤身裸体了....", "mc: 呃....当然。我知道。那是个笑话。啊哈哈哈..."], multiple=True)

    add_dialogue("slave punish rape", "very lewd", "主人....你在做什么....啊啊！", fear=0.5, unlock="LM")
    add_dialogue("slave punish rape", "lewd", "不，主人....不是那样的....*抽泣*", fear=1, unlock="LM")
    add_dialogue("slave punish rape", "very modest", "哎呀！！！别碰我！！！不！！！", fear=3, unlock="LM")
    add_dialogue("slave punish rape", "modest", "不！！！你以为你在做什么！！！", fear=2, unlock="LM")

    add_dialogue("slave raped", "generic", ["不....啊啊啊！", "啊啊！！！啊！！！"], sound=s_screams)

    add_dialogue("slave rape positive fixation", "generic", "啊，这太脏了....嗯....", love=1, fear=-1, sound=s_aaah)
    add_dialogue("slave rape negative fixation", "generic", "不，不是这个！！！不不不！！！", love=-2, fear=3, sound=s_scream_loud)

    ### GIRL TAB DIALOGUE ###

    add_dialogue("rest", "generic", "我现在要休息了。{w=1.0}{nw}")
    add_dialogue("accept job", "generic", "我现在将担任{b}[girl.job_cn]{/b}，以满足客户的需求。{w=1.0}{nw}")
    add_dialogue("work_whore", "generic", "我现在将担任{b}[girl.job_cn]{/b}和妓女，以满足客户的需求。{w=1.0}{nw}")
    add_dialogue("exhausted", "generic", "对不起主人，我还是很累，需要多休息。康复后，我将回去担任 {b}[girl.job_cn]{/b} 的工作。")

    add_dialogue("rank up", "generic", "谢谢主人。我现在是一名[newrank]奴隶。")

    add_dialogue("refuse whoring", "generic", "哇哦，没办法！！！我不是荡妇！")
    add_dialogue("refuse sex act", "generic", ["我不会那样做！", "不行....不行！！！", "我....还没准备好。"])

    ### MARKET DIALOGUE ###

    add_dialogue("bought", "generic", "请善待我，主人。")
    add_dialogue("freed", "generic", "好吧，那就再见了....")
    add_dialogue("freed", "masochist", "不！别让我走...我需要一个主人...")
    add_dialogue("sold", "generic", ["...", "这次就再见了，那么....", "主人，我这就去...."])
    add_dialogue("sold love", "generic", ["但、但是，主人！我...我爱你...*抽泣*", "不，主人！我想和你在一起... *抽泣*"], sound=s_surprise)

    ### POSTINGS DIALOGUE ###

    add_dialogue("leave for quest", "generic", "主人，我走了。很快再见。")
    add_dialogue("leave for class", "generic", "主人，我走了。很快再见。")

    ### NIGHT DIALOGUE ###

    # Note: "advertise" cannot use multiple lines
    add_dialogue("advertise", "generic", ["先生！您愿意来看看我们的商品吗？ *咯咯笑*", "我很孤独，先生....你能进来陪我吗？", "我好饥渴....我爱你很久了....", "先生，您喜欢您所看到的吗？ *傻笑*", "进来吧，先生！你知道你想。", "法律规定不能碰，但我想我看到这里有很多违法者....", "如果你想要我的身体并且你认为我很性感，来吧亲爱的，告诉我吧！ *眨眼*", "来参加聚会吗，先生？ *傻笑*", "看过我的节目吗？不，没有乒乓球，但它很好，相信我！", "进来吧，糖！我会给你一些特别的东西..."])

    ### CITY EVENTS DIALOGUE ###

    add_dialogue("beach intro", "extravert", ["[girl.fullname]正在海滩上和一群人说说笑笑，其中一些人公开欣赏她健美的身材。"], sound=s_laugh)
    add_dialogue("beach intro", "introvert", ["距离人群很远，[girl.fullname]正在看着水中反射的太阳。"], sound=s_sigh)
    add_dialogue("beach meet MC", "modest", ["g: 哦，[MC.name]主人！我没看到你来...", "她本能地用毛巾遮住自己，表现出谦虚的样子。", "mc: 算了，没什么可瞒着我的。", "g: ..."], multiple=True)
    add_dialogue("beach meet MC", "lewd", ["g: 您好，[MC.name]主人！你欣赏风景吗？", "她毫不谦虚地炫耀自己的美貌，当她观察你的反应时，眼中闪烁着顽皮的光芒。", "mc: 是啊....确实很好....", "g: 哈哈，我可以告诉你你喜欢它。 *眨眼*"], multiple=True)
    add_dialogue("beach meet MC", "sub", ["g: 师、主人？对不起，我没有偷懒....", "她在你面前畏缩，期待着你的耳朵。", "mc: 别傻了，今天是你的休息日。", "g: 咳咳，是的....谢谢。"], multiple=True)
    add_dialogue("beach meet MC", "dom", ["g: 什么？女孩就不能安安静静地享受假期吗？", "当你靠近时，她会全力防御。", "mc: 哇，注意你的语气，女孩。我平平安安地来。", "g: 哼。好吧，我想我可以在完美的早晨休息一下来和你谈谈......"], multiple=True)

    add_dialogue("beach oiling", "modest", ["哦...这很好，但是你能不能别碰我那么近...啊啊！"], sound=s_surprise)
    add_dialogue("beach oiling", "lewd", ["这太棒了，你能做得更多吗....嗯，是的，就像这样。这里也请..."], sound=s_ahaa)

    add_dialogue("beach accept oiling", "modest", ["主人，你、你在做什么....这里不是....呜呜...."])
    add_dialogue("beach accept oiling", "lewd", ["哦，你真顽皮....嗯...."])

    add_dialogue("beach refuse oiling", "dom", ["嘿！我确信我在这里不会被晒伤，非常感谢！放手。"])
    add_dialogue("beach refuse oiling", "sub", ["不、不在这里，主人！我受够了....我们停下来吧。"])

    add_dialogue("beach accept public sex", "modest", ["g: 哦，主人！人们正在看着我们，但是...我的身体感觉很热...对我做你想做的...", "当你抓住她的臀部并将她靠近时，她喘息着。"], multiple=True)
    add_dialogue("beach accept public sex", "lewd", ["g: 我以为你永远不会问！", "她立刻就抓住了你的鸡巴，用双手拉下了你的裤子。"], multiple=True)

    add_dialogue("beach refuse public sex", "dom", ["当着别人面做这事？你要疯了吗？！？"])
    add_dialogue("beach refuse public sex", "sub", ["请主人原谅，这是不可能的！对不起，对不起！"])

    add_dialogue("beach accept sex", "modest", ["哦，好的...."])
    add_dialogue("beach accept sex", "lewd", ["为什么不？应该会很好玩..."])

    add_dialogue("beach refuse sex", "dom", ["我不相信！这太过分了！今天是我的休息日，该死！"])
    add_dialogue("beach refuse sex", "sub", ["请主人原谅，这是不可能的！对不起，对不起！"])

    add_dialogue("beach whoring request", "materialist", ["免费工作？在我休息日？我勒个去！"])
    add_dialogue("beach whoring request", "idealist", ["但你却给了我休息日！你不能就这样食言...."])

    add_dialogue("beach whoring accept", "lewd", ["好吧，反正我也没有很多其他事情要做....叫我妓女吧....但我会做的。"])
    add_dialogue("beach whoring accept", "modest", ["噢，主人，您让我做的事情....好吧。"])

    add_dialogue("beach whoring refuse", "materialist", ["哼，我也不想啊！你需要付给我更多的钱才能让我放弃休息日......"])
    add_dialogue("beach whoring refuse", "idealist", ["不，这不是一个公平的交易。我需要休息。没有机会！"])

## v0.3 Dialogue addition


    add_dialogue("slave confused", "materialist", ["哎呀，刚刚发生了什么....我感觉很奇怪....至少我还完整。"])
    add_dialogue("slave confused", "idealist", ["什、发生什么事了？我突然感觉自己不像自己了"])
    add_dialogue("slave confused", "dom", ["嘿，什么....你在看什么？我脸上有东西吗？"])
    add_dialogue("slave confused", "sub", ["呃....我是不是打瞌睡了？对不起...."])

    add_dialogue("sanity broken", "dom", ["当你靠近农场时，你听到里面有很大的噪音。你认为你认得 [girl.fullname] 的声音。你满怀担忧地走进大楼。", "g: 尼亚啊！！！", "你一进门就必须躲避飞来的水壶。 [girl.name]大发雷霆，摔碎并投掷她能拿到的所有东西，在造成严重破坏时像野兽一样尖叫。", "giz: 立即停止，你这个愚蠢的母狗！我会把你开膛破肚！", "mc: 七层地狱到底发生了什么？", "当她猛击家具和窗户时，[girl.name]的眼睛里默默地流着泪水，甚至不介意她的手和手臂被严重割伤。她甚至不认识你，她就像消失了。"], multiple = True, sound=s_shatter)
    add_dialogue("sanity broken", "sub", ["当你靠近农场时，你听到从 [girl.fullname] 的围栏里传来喊叫声。", "giz: 起来吧，你这个愚蠢的、懒惰的母狗！你还有家务要做！回答我！", "g: ...", "[girl.name]在冰冷的硬地板上蜷缩成一团，盲目地凝视着虚空。", "当吉泽尔用鞭子抽打她时，她甚至没有退缩。她只是不停地低声呻吟，令人不安，就像一只受伤的猫。", "mc: 这是怎么回事？", "giz: 她整个早上都这样！除了不停地抽泣和抱怨之外，我从她身上什么也得不到。"], multiple = True, sound=s_punch)

    add_dialogue("slave witness ritual bondage", "dom", ["他们要对她做什么！放开那个可怜的女孩吧！"], mood=-3, fear=2)
    add_dialogue("slave witness ritual bondage", "sub", ["他们对她做了什么....这太淫荡和有辱人格了....*脸红*"], mood=1, fear=1)

    add_dialogue("slave witness ritual orgy", "lewd", ["她真的能承受这么多吗？她看起来需要一些帮助...."], mood=2, fear=1)
    add_dialogue("slave witness ritual orgy", "modest", ["哦不，这太丢人了！在公共场合也是如此....她会失去理智的...."], mood=-3, fear=2)

    add_dialogue("slave witness ritual violence", "idealist", ["立即停止这一切！你这是在伤害她！！！她会死的！！！"], love=-5, fear=3)
    add_dialogue("slave witness ritual violence", "materialist", ["她比我好，但是....哎呀。"], fear=2)

    add_dialogue("meet cuddly pet", "generic", ["噢，多么可爱啊！！！ [emo_heart]"])

## START PERVERT DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("pervert", "very lewd", "superficial"), ("怎么样，[MC.name]。别再表现得这么绅士了，这不适合你。我是[girl.fullname]。"), love=-1)
    add_dialogue("free_greetings_casual", ("pervert", "very lewd", "superficial"), ("为什么你好，热门的东西！我的名字是[girl.fullname]。"))
    add_dialogue("free_greetings_rude", ("pervert", "very lewd", "masochist"), ("啊，一个知道自己想要什么的男人... *微笑* 我的名字是 [girl.fullname]. 见到你很高兴."), love=4)

    add_dialogue("free_small_talk", ("pervert", "rebel", "stubborn", "bimbo"), ("*哈欠* 得了吧，这太无聊了."), max_cap=25)
    add_dialogue("free_gossip", ("pervert", "superficial", "bimbo", "princess"), ("我会给你所有有趣的细节......"), love=2, max_cap=25)
    add_dialogue("free_chat_life", ("pervert", "yandere", "creep"), ["g: 我所知道的是，我的生活、我的宇宙、我的一切都可以在泽恩这里找到。","mc: 哦？","g: *咯咯*别装模作样，你知道我在说什么！"], multiple=True, max_cap=25)
    add_dialogue("free_chat_love", ("pervert", "sweet", "princess", "pet"), ("当然，我在等我那位身披闪亮铠甲的骑士... *咯咯笑*"), love=2, max_cap=25)
    add_dialogue("free_chat_origins", ("pervert", "very lewd", "bimbo"), ("我在[girl.origin]的一家青楼旁边长大。", "我在[girl.origin]长大。那里太无聊了！", "呃，[girl.origin]。泽恩好多了！"), love=1, max_cap=40)
    add_dialogue("free_chat_hobbies", ("pervert", "rebel", "easy"), ("我{i}热爱{/i}[hobby]。", "大多数爱好都很无聊，但[hobby]还可以。", "最近我看到了一类性奴隶[hobby]的裸体。它让我湿透了。泽恩不奇怪吗？"), max_cap=40)
    add_dialogue("free_chat_likes", ("pervert", "bimbo", "easy", "tsundere"), ("我{i}最喜欢{/i}[best]。这是最好的。吸它，任何其他[thing_cn]！ *傻笑*", "我很确定每个人都同意最好的[thing_cn]就是[best]。"), love=2, max_cap=40)
    add_dialogue("free_chat_dislikes", ("pervert", "creep"), ("让我超级沮丧的一件事是[worst]。哎呀！", "我唯一比禁欲更讨厌的是[thing_cn][worst]。"), love=1, max_cap=40)

    add_dialogue("free_joke_harmless", ("pervert", "superficial", "rebel"), ("呃，你太无聊了...."), love=-1, max_cap=50)
    add_dialogue("free_joke_adult", ("pervert", "very extravert", "loyal", "superficial"), ("哦，太淘气了...*咯咯*"), love=5, max_cap=50)
    add_dialogue("free_joke_dark", ("pervert", "cold", "superficial", "pet", "bimbo"), ("呃....这太操蛋了。"), love=-1, max_cap=50)
    add_dialogue("free_joke_mean", ("generic", "very extravert", "very introvert", "very idealist", "very materialist"), ("*笑*告诉我另一个！"), love=1, max_cap=50)

    add_dialogue("free_touch_hand", ("pervert", "superficial", "bimbo", "schemer", "rebel"), ("嘿，放开我的手。这真让人尴尬."), max_cap=90)
    add_dialogue("free_touch_kiss", ("pervert", "masochist", "helper"), ["She pushes you away.", "g: 你突然这么浪漫干嘛？你真奇怪."], multiple=True, love=-1, max_cap=90)
    add_dialogue("free_touch_ass", ("pervert", "superficial", "helper", "pet", "loyal", "masochist", "creep"), ("*呻吟* 嗯，是的，继续..."), love=5, max_cap=90)
    add_dialogue("free_touch_breasts", ("pervert", "bimbo", "yandere"), ["g: 嗯...别忘了还有这个地方。", "她抓住你的一只手，将它移向她的胯部。"], multiple=True, love=4, max_cap=90)
    add_dialogue("free_touch_pussy", ("pervert", "very lewd", "bimbo"), ["g: *呻吟* 嗯，是的，就在那里！", "她用双臂搂住你，磨蹭你的腿。", "g: *低语* {i}把几根手指伸进去，[MC.name]...能感觉到我有多湿吗？{/i}"], multiple=True, love=5, max_cap=90)

    add_dialogue("free_play refuses", ("pervert", "very lewd"), ("我们就不能做点别的吗？"), love=-1)
    add_dialogue("free_play very reluctant", ("pervert", "very lewd"), ("这不是我感到兴奋的事情，但为了你我会破例。"), love=1)
    add_dialogue("free_play reluctant", ("pervert", "very lewd"), ("*咯咯笑*你不是这里唯一饥渴的人。在此之后，让我们做一些{i}我{/i}可以享受的事情吧。"), love=2)
    add_dialogue("free_play a little reluctant", ("pervert", "very lewd"), ("*咯咯笑*哦，那么你现在就是这种心情吧？"), love=2)
    add_dialogue("free_play indifferent", ("pervert", "very lewd"), ("哦，很高兴！"), love=3)
    add_dialogue("free_play a little interested", ("pervert", "very lewd"), ("*呻吟*是的，拜托！"), love=4)
    add_dialogue("free_play interested", ("pervert", "very lewd"), ("嗯...我非常喜欢它！"), love=4)
    add_dialogue("free_play very interested", ("pervert", "very lewd"), ("*呻吟*你让我如此兴奋......"), love=5)
    add_dialogue("free_play fascinated", ("pervert", "very lewd"), ["话还没说出口，她的双手就已经放在了大腿之间。", "当她开始和自己玩耍时，她高兴地呻吟着。", "g: 我非常爱你，[MC.name]...让我们开始吧。"], multiple=True, love=5)
    add_dialogue("MC take virginity", ("pervert"), ["g: 哦天哪...[MC.name]...这是我第一次...但是，我来了很多次了！", "g: 那真是太棒了。任何时候你有冲动，请告诉我！", "g: 我想日日夜夜地一遍又一遍地这样做...."], multiple=True, love=5)
    add_dialogue("free_play interested after", ("pervert", "very lewd"), ("*呻吟*那真是太棒了...我们能再做一次吗？"))
    add_dialogue("free_play not interested after", ("pervert", "very lewd"), ("抱歉，这并没有真正为我做..."))

    add_dialogue("free_flirt_beauty", ("pervert", "rebel", "holy", "helper"), ("呃...你就不能想出更原创的东西吗？"), love=-1, max_cap=75)
    add_dialogue("free_flirt_body", ("pervert", "superficial", "bimbo", "creep", "schemer", "pet"), ("你真的这么认为？嗯....不得不说，你的身体也太好了吧！"), love=2, max_cap=75)
    add_dialogue("free_flirt_mind", ("pervert", "cold", "superficial", "princess", "pet", "masochist", "rebel"), ("是的，对了，这句令人厌倦的台词听了一千遍....*无聊*"), love=-1, max_cap=75)
    add_dialogue("free_flirt_spirit", ("pervert", "sweet", "superficial", "tsundere", "yandere", "pet"), ("*咯咯笑*我可能有太多被压抑的能量。"), love=2, max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("pervert", "very lewd"), ["她靠得更近，脸上带着顽皮的微笑。", "g: 你猜对了！我想我应该以我的记录获得某种奖励......", "g: 我在无数的酒馆里和无数的醉汉度过了无数个夜晚。"], multiple=True, love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("pervert", "very lewd"), ["g: 嗯，嗯...众所周知我会煽动一些疯狂的聚会...", "她微笑着，自豪地挺起胸膛。", "g: 在我和班里所有的男生上床后，他们把我开除出学校了！"], multiple=True, love=2)
    add_dialogue("free_flirt_sex_experience average", ("pervert", "very lewd"), ["她挠挠头。", "g: 没有我想要的那么多......"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("pervert", "very lewd"), ["她看起来很悲伤。", "g:  不，不是真的。"], multiple=True)
    add_dialogue("free_flirt_sex_experience very inexperienced", ("pervert", "very lewd"), ["她看起来有点困惑。", "g: 我听过一些不雅的故事....听起来很有趣！"], multiple=True, love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("pervert", "very lewd"), ("但我从来没和男人... {i}做过{/i} 你知道的。我很想知道那是什么感觉... *脸红*"), love=1)

    add_dialogue("free_flirt_sex_experience reply_waiting success", ("pervert", "masochist", "bimbo"), ("Oh! 无聊聊聊!"), love=0)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("pervert", "creep", "schemer"), ("啊，我明白了。 *眨眼*我们不是吗？"), love=1)
    add_dialogue("free_flirt_sex_experience reply_not_many success", ("pervert", "very lewd"), ("好吧，至少你还不是完全没用! *眨眼*"), love=-1)
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("pervert", "superficial", "bimbo", "easy"), ("没必要谦虚！"), love=-2)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("pervert", "very lewd"), ("啊，现在我们说到点子上了！我希望你能给我展示一些新技巧..."), love=3)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("pervert", "bimbo", "creep", "yandere"), ("有意思....我真的可以利用你的才华..."), love=4)
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("pervert", "very extravert"), ("*笑*处女警报！"), love=1)
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("pervert", "very lewd"), ("嗯，你应该一直努力成为你工作领域的佼佼者，不是吗? *微笑*"), love=1)

    add_dialogue("free_flirt_sex_act refuses", ("pervert", "very lewd"), ("嗯...我不明白人们从中得到什么。"))
    add_dialogue("free_flirt_sex_act very reluctant", ("pervert", "very lewd"), ("这不适合我，但我喜欢看其他人这样做。 *咧嘴笑*"))
    add_dialogue("free_flirt_sex_act reluctant", ("pervert", "very lewd", "pet"), ("这并不是让我兴奋的事情，但我不介意尝试一下。"))
    add_dialogue("free_flirt_sex_act a little reluctant", ("pervert", "very lewd", "pet"), ("*咯咯*所以你喜欢{i}那样{/i}之类的东西，是吧？现在我知道如何让你继续前进。"))
    add_dialogue("free_flirt_sex_act indifferent", ("pervert", "very lewd"), ("就我而言，这是健康性生活的重要组成部分。"), love=1)
    add_dialogue("free_flirt_sex_act interested", ("pervert", "very lewd"), ("哦，这肯定让我兴奋！我不明白为什么有人不喜欢这样！"), love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("pervert", "very lewd"), ("*笑*我喜欢它！我希望我能一直这样做！"), love=2)
    add_dialogue("free_flirt_sex_act very interested", ("pervert", "yandere", "creep", "superficial"), ["g: *呻吟*哇，这次谈话真的让我兴奋！", "她捧住自己的乳房，开始抚摸自己。", "g: 我喜欢谈论它，我喜欢思考它，我喜欢这样做！"], multiple=True, love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("pervert", "yandere", "creep", "superficial", "bimbo"), ["g: *脸红*我不敢相信我们正在谈论这个......", "她将一只手滑进大腿之间，然后将几根手指滑了进去。", "g: *呻吟*","然后她举起手放在你面前，手上沾满了汁液。", "g: 我的意思是，看看这个，操...你让我他妈的欲火中烧，[MC.name]！"], multiple=True, love=3)

    add_dialogue("free_give_gold +++", ("pervert", "masochist", "creep"), ["她的眼睛亮了起来。", "g: 噢，非常感谢！想想我可以用这个买所有的玩具！"], multiple=True, love=6, max_cap=75)
    add_dialogue("free_give_gold ++", ("pervert", "meek", "holy", "helper", "repressed", "stubborn"), ("谢谢你！！我会好好利用它的。"), love=4, max_cap=75)
    add_dialogue("free_give_gold +", ("pervert", "meek", "helper", "repressed", "holy"), ("哇，你真可爱。"), love=2, max_cap=75)
    add_dialogue("free_give_gold -", ("pervert", "helper", "repressed", "stubborn", "princess"), ("这有点奇怪....你就不能给我买件礼物吗？"), max_cap=75)
    add_dialogue("free_give_gold --", ("pervert", "nerd", "sweet", "helper", "easy", "class president", "tsundere", "loyal"), ("我该怎么办？我不明白。"), love=-1, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("pervert", "very lewd"), ["她好奇地看着你.", "g: 你一定觉得我是个肮脏的婊子，对吧?", "mc: 呃...", "g: 我不是说你有错...呣...", "她咬着嘴唇.", "g: 如果我在那里工作，我就会整天被陌生人操，对吧?"], multiple=True, love=2)
    add_dialogue("free_offer_job half_lie", ("pervert", "very lewd"), ["她看起来很生气。", "g: 你本来可以早点告诉我的。我对泽恩的性交易绝对没有意见。", "mc: 嗯，有些女孩没有你那么开放....", "g: 噗....你的时间都浪费在那些女孩身上了。", "她停顿了一下，咬住嘴唇。", "g: 所以如果我在那里工作，我一天会上几次床，对吧？"], multiple=True, love=2)
    add_dialogue("free_offer_job lie", ("pervert", "very lewd"), ["她看起来很生气。", "g: 你本来可以早点告诉我的。我对泽恩的性交易绝对没有问题。", "mc: 嗯，有些女孩没有你那么开放....", "g: 噗....你的时间都浪费在那些女孩身上了。", "她停顿了一下，咬住嘴唇。", "g: 所以如果我在那里工作，我一天会上几次床，对吧？"], multiple=True)
    add_dialogue("free_offer_job success", ("pervert", "very lewd"), ["g: 这对我来说听起来像是一份梦想的工作......", "g: 我们还等什么？我们走吧！"], multiple=True)
    add_dialogue("free_offer_job thinking", ("pervert", "very lewd"), ["g: 我需要一点时间考虑一下......", "g: Zan 的性产业如此多样化，有很多选择可供考虑。"], multiple=True)
    add_dialogue("free_offer_job failure lie", ("pervert", "very lewd"), ["g: 你到底在建议什么？！", "g: 仅仅因为我喜欢玩弄你的鸡巴，那并不能让我成为你的奴隶！", "g: 你有严重的问题....我要走了！","她气冲冲地走了...."], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("pervert", "very lewd"), ["g: 哇哦...我不签合约！", "g: 我可能渴望鸡巴，但这并不会让我成为性奴隶！", "g: 你有严重的问题....我要走了！","她气冲冲地走了...."], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("pervert", "very lewd"), ["g: 哦，太迷人了！你一定哪天要让我去看看，我太好奇了！我能吗?", "mc: 嗯，当然了... 你呢，你是做什么的?", "g: 哦，我？最近没什么..."], multiple=True, love=5)
    add_dialogue("free_friend half_lie", ("pervert", "very extravert"), ["g: *打哈欠*不知怎的，你让这听起来比我所做的更无聊......", "mc: 你是做什么的？", "g: 哦，没什么！我仍在探索我的选择。"], multiple=True, love=-5)
    add_dialogue("free_friend lie", ("generic", "very extravert", "very introvert", "very idealist", "very materialist", "very modest", "very dom"), ["g: 所以你在[lie]？好奇的...", "mc: 当然....你呢？你是做什么的？", "g: 嗯...我仍在探索我的选择。"], multiple=True)

    add_dialogue("free_love_interest", ("pervert"), ["mc: 你好吗，[girl.name]？", "g: 呃....今天早上我看到一对情侣在巷子里亲热....现在我感到很难过。", "mc: 哦？这听起来不像你。", "g: 我知道！通常我喜欢看这样的东西......但他们看起来是如此......相爱！我感觉格格不入。", "g: *叹气*现在我感觉我的生活中缺少了一些东西......", "她停顿了一会儿，看上去很孤独。", "g: 我们来谈谈别的事吧？", "g: 我在想....花就像植物被切断的生殖器，对吧？有趣的是人们如何将其作为一种爱的姿态给予彼此。", "mc: 这很奇怪，我从来没有这样想过......"], multiple=True)
    add_dialogue("free_girl get_flowers", ("pervert"), ["g: 哇哦，谢谢！你给我带来了植物的生殖器！ *笑*你真是太好了。", "g: 那么，什么场合？"], multiple=True)
    add_dialogue("free_ask_out", ("pervert"), ["mc: [girl.name]，我在想....我们应该成为情侣。", "g: 你想让我....成为你的女朋友?", "mc: 是的，我愿意。", "g: 嗯...哦，为什么不呢！我期待着与你更加亲密。 *眨眼*", "她紧紧地拥抱你，然后把手放在你的胯部。", "g: 我迫不及待地想进一步了解你...我很快就会见到你！ *眨眼*"], multiple=True)

    add_dialogue("free_girlfriend intro", ("pervert"), ["g: [MC.name]！跟我来...", "mc: 很高兴见到你，[girl.name]。这是怎么回事？", "g: *脸红*我真的很喜欢和你在一起，[MC.name]。今天我感觉有点冒险....", "g: 所以如果你能回答我的问题，你将得到奖励。"], multiple=True)
    add_dialogue("free_girlfriend right", ("pervert"), ("完全正确...你准备好了吗？"), love=5)
    add_dialogue("free_girlfriend give_up", ("pervert"), ("哦，好吧....好吧，这破坏了气氛。 *疯狂的*"), love=-5)
    add_dialogue("free_girlfriend wrong", ("pervert"), ("不！那是完全答错了！破坏心情的方式。 *疯狂的*"), love=-10)
    add_dialogue("free_girlfriend success", ("pervert"), ["她脱下衣服，双手捧住胸部，轻轻抚摸乳头。", "g: *呻吟*你不认为我们应该更多地探索彼此的身体吗？", "g: *咯咯*随意触摸任何你喜欢的地方......", "你的手指慢慢地沿着她的身体从上到下抚摸。当你接近她的小穴时，她会打断你。","g: 哦，我差点忘了！我还有一个惊喜要给你！", "她翻遍了地板上的衣服，拿出了一个带遥控器的小型子弹振动器。", "她把振动器放在她的小穴上，然后把遥控器递给你。", "g: 从现在开始，我会确保每次我们见面时它都在那里。", "g: 所以，如果您有心情，请打开它告诉我！ *眨眼*"], multiple=True)
    add_dialogue("free_girlfriend success naked", ("pervert"), ["她脱下衣服，双手捧住胸部，轻轻抚摸乳头。", "g: *呻吟*衣服真是太痛苦了！我们应该拥抱自己的本性并始终赤身裸体！", "g: *咯咯*随意触摸任何你喜欢的地方......", "你的手指慢慢地沿着她的身体从上到下抚摸。当你接近她的小穴时，她会打断你。","g: 哦，我差点忘了！我还有一个惊喜要给你！", "她翻遍了地板上的衣服，拿出了一个带遥控器的小型子弹振动器。", "她把振动器放在她的小穴上，然后把遥控器递给你。", "g: 从现在开始，我会确保每次我们见面时它都在那里。", "g: 所以，如果您有心情，请打开它告诉我！ *眨眼*"], multiple=True)

    add_dialogue("free_job_request", ("pervert"), ["g: 这是一场灾难！欢乐的骑士们要离开了!", "mc: 那个....那个什么??", "g: 欢乐的骑士们！你不认识他们吗？他们是一支在 塞罗斯 全境都很有名的威兹博尔队伍!", "mc: 然后呢...", "g: 然后? 而且我是他们的支持女孩！！！我曾经和队长，还有他的副手约会，他们给了我很多礼物和关注...", "mc: 哦，嗯....什么?", "g: 抱歉，亲爱的，别往心里去，你很棒，但女孩子总得找点乐子....一个威兹博尔队有23名球员！！！我上哪儿再去找一批有钱又好色的男人???", "mc: Mmmh..."], multiple=True)

    add_dialogue("accept farm", ("pervert", "very lewd"), ["g: 呃...我必须这样做吗？泽恩这里有很多我可以训练的动物！","她盯着你看了一会儿，希望你能重新考虑。", "g: 好的主人，我这就去....啊，我真的会想念这个地方的。帮我保暖我的床，好吗？ *眨眼*"], multiple=True)
    add_dialogue("accept farm fear", ("pervert", "pet", "schemer", "repressed", "meek", "cold", "yandere", "creep"), ["[girl.name]的脸上浮现出一种茫然、震惊的表情。","g: 农场、农场....U、叔叔在等我....", "mc: 当然是。现在继续吧，命令就是命令。", "g: 是、是的，主人....我保证我会做好的。如果马再次生气，我不会告诉我的[girl.story_guardian]。","她开始抽泣，大概是在重温童年的创伤。"], multiple=True)
    add_dialogue("refuse farm", ("pervert", "very extravert"), ("不、不，不是农场....拜托，除了那个以外什么都可以。让我留在这里，我保证我会表现得很好。"))
    add_dialogue("gizel take girl to farm", ("pervert", "very lewd"), ("我和[girl.fullname]会相处得很好。我们不是吗，你这个可悲的小荡妇？"))

    add_dialogue("girl introduction", ("pervert", "very lewd"), ["g: 很高兴认识你，我是[girl.fullname]。", "g: *低语* {i}我把振动器放在了我的小穴。我希望你帮我拿着这个遥控器。今晚我们一起玩吧，好吗？{/i}"], multiple=True)
    add_dialogue("slave thanks", ("pervert", "very extravert"), ["这是我的荣幸。", "快乐全是我的。", "我的荣幸！", "不客气。"])
    add_dialogue("slave effusive thanks", ("pervert", "very extravert"), ["AWW谢谢！我永远不会忘记这一点。", "谢谢你！！这是我一生中最美好的时刻。", "天啊！太感谢了！"])
    add_dialogue("slave positive reaction", ("pervert", "very extravert"), ["哇，我很感激。", "惊人的！", "甜的！谢谢主人。"])
    add_dialogue("slave negative reaction", ("pervert", "very extravert"), ["呃....真的吗？", "噗....这一切有什么意义？", "哦，来吧！", "什么？！"])
    add_dialogue("slave whining", ("pervert", "very extravert"), ["啊...", "*抱怨*", "我简直不敢相信这该死的废话....", "什么？！"])
    add_dialogue("slave strongly refuse", ("pervert", "very lewd"), ("不、不！不是这样的..."), sound=s_screams)
    add_dialogue("slave bullied", ("pervert", "rebel", "superficial"), ["没必要这么刻薄吧...", "哇哦，你真是个杀人狂....", "嗯，破坏了气氛。"])
    add_dialogue("slave apology", ("generic", "very extravert", "very introvert", "very idealist", "very materialist", "very modest", "very sub"), ["对不起，主人....", "我的错，主人。", "对不起，我不是这个意思。"])
    add_dialogue("slave hit", ("generic", "very extravert", "very introvert", "very idealist", "very materialist", "very modest", "very sub"), ["啊啊！！停下来，你弄疼我了....", "Aah!"])
    add_dialogue("slave positive fixation accept", ("pervert", "very lewd"), ["哦，那真是太他妈的爽了！", "操，真爽，这让我兴奋......", "啊....这感觉真他妈的好！", "*呻吟*我喜欢你这样对待我。"])
    add_dialogue("slave negative fixation accept", ("pervert", "very lewd"), ["这太可怕了...", "我讨厌那个...", "呃...我们必须这样做吗？", "我不明白为什么人们喜欢这个......"])
    add_dialogue("slave negative fixation refuse", ("pervert", "very lewd"), ["他妈的不！太恶心了。", "呃....我不这么认为！", "不！！抱歉，但这真的不适合我。"])

    add_dialogue("slave first visit", ("pervert", "very extravert"), ("啊，终于有机会说话了。很高兴认识您，主人。"))
    add_dialogue("MC kind promise", ("pervert", "cold", "superficial", "bimbo", "creep", "loyal"), ["她松了一口气。", "g: 谢谢您，慈悲的主人。我一定会回报你的。"], multiple=True, love=1, fear=-3)
    add_dialogue("MC fair promise", ("generic", "very extravert", "very introvert", "very idealist", "very modest", "very sub"), ["她点点头并微笑。", "g: 我明白。我会尽我最大的努力来赢得您的信任。"], multiple=True, fear=-1)
    add_dialogue("MC no promise", ("pervert", "sweet", "helper", "stubborn"), ["她看起来很害怕。", "g:  是的，先生，我明白了。你是我的主人。"], multiple=True, love=-1, fear=1)
    add_dialogue("MC harsh promise", ("pervert", "meek", "sweet", "helper", "class president", "loyal"), ["她挺直了背，眼里涌出泪水。", "g: 是的，是的，主人。明白了。"], multiple=True, love=-3, fear=3)
    add_dialogue("MC break promise", ("pervert", "very extravert"), ("不、不，等等....我还以为您会是一位善良又慈爱的主人呢...."), love=-5, fear=1)
    add_dialogue("MC fight intro", ("pervert", "rebel", "stubborn", "schemer", "yandere", "tsundere", "creep"), ["她突然向你猛烈攻击，并将指甲抓进你的脖子。", "g: 天哪，不！我才不会为你翻身呢，混蛋！"], multiple=True, sound=s_scream_loud)
    add_dialogue("slave fear intro", ("pervert", "meek", "sweet", "cold", "nerd", "holy", "prude", "repressed"), ("当你靠近时，她用手捂住身体，蜷缩在角落里。汗珠从她的额头上淌下来。"))
    add_dialogue("slave fear reassure success", ("pervert", "meek", "cold", "nerd", "loyal", "class president", "repressed", "prude"), ("她点点头，专注地看着你。"), fear=-2)
    add_dialogue("slave fear reassure failure", ("generic", "very extravert", "very introvert", "very idealist", "very materialist", "very modest", "very sub"), ("从她空洞的眼神来看，你的话没能传达给她。她的手在颤抖，泪水顺着脸颊流下来。你决定稍后再回来。"), fear=-1)
    add_dialogue("slave fear discipline", ("generic", "very extravert", "very introvert", "very idealist", "very materialist", "very modest", "very sub"), ("你打她的肚子。她跌倒在地板上翻滚，喘着粗气。现在跟她说话已经没有意义了。"), fear=1)

    add_dialogue("slave naked request permanent", ("pervert", "easy", "yandere", "masochist"), ("哦...我喜欢这个主意！这可能会让男人们疯狂，但我喜欢他们疯狂。 *傻笑*"), love=4, fear=-3, sound=s_sigh)
    add_dialogue("slave naked request accept", ("pervert", "masochist", "bimbo", "easy"), ("啊哈哈哈，这将会非常有趣！"), love=2, sound=s_ahaa)
    add_dialogue("slave naked request resist", ("pervert", "schemer", "easy"), ("嗯，我对此不太确定...这是一个想法：如果所有顾客也都同意裸体，那么我就可以了。"), love=-1, fear=-1)
    add_dialogue("slave toggle naked on", ("pervert", "bimbo", "creep", "yandere"), ("*咧嘴笑*我很高兴！"), love=1)
    add_dialogue("slave toggle naked off", ("pervert", "bimbo", "creep", "easy", "yandere"), ("哎呀，糟蹋了..."), love=-1)
    add_dialogue("slave train beg", ("pervert", "very lewd"), ["[girl.name]看起来很沮丧。", "g: 我真的很讨厌这样。我们就不能做点别的吗？", "g: 拜托，主人....我只是对此感到不舒服。"], multiple=True)
    add_dialogue("slave discipline beg", ("pervert", "very extravert"), ["[girl.name]快要哭了。她摇摇晃晃地离开你并低下头。", "g: 我、我很抱歉让您失望了，主人。请原谅我，我会做得更好，我保证！"], multiple=True)
    add_dialogue("slave beg proceed", ("generic", "very introvert", "very idealist", "very materialist", "very modest", "very sub"), ["g: *闻一闻*但-但是...主人...", "你听到[girl.name]呜咽着，泪水在她眼里涌出。"], multiple=True, love=-1, fear=1)
    add_dialogue("slave beg warning", ("pervert", "sweet", "repressed", "class president", "loyal"), ("我明白了，主人。我不会再质疑你了。"), fear=1, sound=s_sigh)
    add_dialogue("slave beg give up", ("pervert", "helper", "sweet", "pet", "masochist"), ["你看到她的脸颊又恢复了颜色。她擦掉眼中的泪水，微笑着。","g: 主人您太仁慈了。谢谢你！"], multiple=True, fear=-1, sound=s_surprise)
    add_dialogue("slave send to master bedroom love +", ("pervert", "very lewd"), ["她对你的决定感到非常高兴。", "g: 哦，我会喜欢的！谢谢主人。我可以带我的玩具吗？"], multiple=True)
    add_dialogue("slave send to master bedroom love", ("pervert", "very lewd"), ["她对你傻笑、眨眼。", "g: 这是我的荣幸，主人。也许你甚至可以教我一些新技巧....今晚？"], multiple=True)
    add_dialogue("slave send to master bedroom love -", ("pervert", "very lewd"), ["她笑着耸了耸肩。", "g: 不知怎的，我怀疑我们会在那里睡很多时间。即使在下班时间我也会训练...", "g: 但是嘿，只要你让我射精，我就不能抱怨！"], multiple=True)
    add_dialogue("slave send to master bedroom fear +", ("pervert", "very lewd"), ["她的眼里带着不安的神情。", "g: 是、是的，主人。我很乐意为你服务，成为你的私人性奴隶。", "g: 拜托，我希望你能填补每一个漏洞。使用我们拥有的所有玩具！", "mc: 好的...我还有一份订单要给你。闭嘴好吗？"], multiple=True)
    add_dialogue("slave send to master bedroom fear", ("generic", "very introvert", "very idealist", "very materialist", "very modest", "very sub"), ["g: 我、如果你这么说的话，主人。", "她焦急地摆弄着拇指，然后急忙跑回自己的房间收拾行李。"], multiple=True)
    add_dialogue("slave send to master bedroom fear -", ("generic", "very introvert", "very idealist", "very materialist", "very modest", "very dom"), ["她耸耸肩，叹了口气。","g: 如果你这么说的话。"], multiple=True)
    add_dialogue("slave leave master bedroom love +", ("pervert", "very lewd"), ["她握紧拳头，撅起嘴。","g: 但是主人，我不明白....为什么？！", "g: 还有很多性行为我想和你一起探索。我们甚至可以发明一些新的！"], multiple=True)
    add_dialogue("slave leave master bedroom love", ("pervert", "very lewd"), ["她咯咯地笑着，向你展示了她的一个玩具，一个巨大的假阳具，看起来是仿照龙的私处设计的。","g: 我将把这个命名为 {i}Lil\' [MC.name]{/i}，以纪念我们在你的卧室里一起度过的所有美好时光。"], multiple=True)
    add_dialogue("slave leave master bedroom love -", ("pervert", "bimbo"), ["她微笑着点点头。","g: 是的，这可能是最好的。我本来希望你会这么说。", "g: 无意冒犯，但每天早上在同一个人身边醒来可不是我的风格。"], multiple=True)
    add_dialogue("slave leave master bedroom fear +", ("generic", "very introvert", "very idealist", "very materialist", "very modest", "very sub"), ["她看起来很担心.", "g: 是的，是的，主人。我、我让你失望了吗？"], multiple=True)
    add_dialogue("slave leave master bedroom fear", ("pervert", "very lewd"), ["她耸耸肩。","g: 我想是在寻找新鲜的肉来耕种吧？好吧...当你再次渴望我的小穴时请告诉我。 *眨眼*"], multiple=True)
    add_dialogue("slave leave master bedroom fear -", ("pervert", "very lewd"), ["她笑着拍手。","g: 啊哈哈，终于自由了！", "g: 我不介意偶尔骑一下你的鸡巴，但这并不意味着我们必须睡在一起，是吗？"], multiple=True)

    add_dialogue("slave chat slave_life -2", ("pervert", "very extravert"), ["她叹了口气，对你大发雷霆。","g: 滚蛋！你就是来蹭蹭的吗？！", "g: 当奴隶很糟糕，不推荐。我每天都在想自杀。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life -1", ("pervert", "very extravert"), ["她看起来很生气。","g: 对此我该怎么说呢？我喜欢当奴隶吗？我愿意这样度过我的余生吗？", "g: 显然，我有自己的欲望....我不是一个被洗脑的旅鼠，纯粹为了听从你的命令而活着。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0", ("pervert", "very extravert"), ["她思考了一会儿这个问题。","g: 还不错。当然，有些事情是你不能做的....", "g: 但是以你的自由为代价，你得到了一位照顾你并确保你保持健康和活力的主人。其价值不应被低估。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0.5", ("pervert", "very extravert"), ["她抓着头，脸上露出困惑的表情。", "g: 嗯...我真的没什么可抱怨的。谢谢您的好意，主人。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 1", ("pervert", "very extravert"), ["她咯咯地笑着，向你行了一个小小的屈膝礼。", "g: 谢谢您的关心。您是一位公正、慈悲的主人。我在这里感觉就像在家里一样。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 2", ("pervert", "very lewd"), ["她笑着亲吻你的手。", "g: 我很荣幸能够为您服务，主人。我没有什么秘密可以瞒着你。", "她示意你靠近一点，并在你耳边低语。", "g: *低语* {i}你走进来时我刚刚正在自慰。{/i}"], multiple=True, unlock="DS")
    add_dialogue("slave chat brothel -2", ("pervert", "very lewd"), ["她看起来很沮丧。","g: 真他妈糟糕！就好像我曾经对性有过的所有快乐感觉都被这个肮脏的地方吸走了。", "g: *叹气*我希望我从来没有来到这里......"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel -1", ("pervert", "very lewd"), ["她挺直背，咕哝着。", "g: 啊....别让我开始！这根本不是我所希望的那样。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0", ("pervert", "very lewd"), ["她耸耸肩。","g: 我一直想在青楼工作，但说实话，这比我预想的要多得多...."], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0.5", ("pervert", "very lewd"), ["她脸红了，用手捂住脸。","g: 这个地方很迷人。有很多新事物我有兴趣尝试....说实话，这有点让人不知所措。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel virgin", ("pervert", "very lewd"), ["当她用一只手抚摸自己的腹股沟时，她的脸涨得通红。","g: 这个地方很迷人！我还在等待我的樱桃爆开，但在那个里程碑之后，我还有很多其他的事情有兴趣尝试。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 1", ("pervert", "very lewd"), ["她笑着夸口。","g: 哦，我没什么可抱怨的！男人们正急切地排着队来犁我。女孩还能想要什么呢？"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 2", ("pervert", "very lewd"), ["g: 啊，看看这个....", "她把两根手指伸进她的小穴。当她把它们拿出来时，一长串猫汁在它们后面拱起。","g: 看那个！我每次醒着的时候都感觉超级他妈的饥渴....多亏了你的指导，我也不用花太多时间就能达到高潮！"], multiple=True, unlock="LM")
    add_dialogue("slave chat customers -2", ("pervert", "very extravert"), ["她握紧拳头，咬紧牙关。","g: 我不敢相信你们竟然允许这么多低等人渣进来。他们真的让我心烦意乱。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers -1", ("pervert", "rebel", "superficial", "bimbo", "tsundere", "yandere", "stubborn"), ["她交叉双臂，咕哝着。","g: 呃....他们中的大多数真的很可怜。难怪他们花钱买性，他们都不知道如何正确取悦女人。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 0", ("pervert", "superficial", "bimbo", "yandere"), ["她举起双手，耸耸肩。","g: 呃，有些比其他的好。有一两个常客确实让我心潮澎湃....我想这就是我所需要的一切。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 0.5", ("pervert", "very extravert"), ["她在回答之前会仔细考虑你的问题。","g: 嗯，他们中的大多数人都有点难，但我能理解为什么......", "g: 他们对自己的生活不满意，我们为他们提供服务，减轻他们的负担。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 1", ("pervert", "very lewd"), ["当你提到顾客时，她的脸容光焕发。","g: 嗯，它们让我感到被渴望。我认为这是值得珍惜的东西，也是我自慰时值得思考的东西。 *眨眼*"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 2", ("pervert", "very lewd"), ["她笑得合不拢嘴。","g: 他们确实是最好的，不是吗？顾客都是和我一样沉迷于性的疯子！ *咯咯笑*女孩还想要什么？"], multiple=True, unlock="MI")
    add_dialogue("slave chat other_girls -2", ("pervert", "rebel", "stubborn", "bimbo", "superficial", "creep", "yandere", "princess", "class president"), ["她难以置信地看着你。","g: 哦，你期待我和他们相处吗？这是命令吗？"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls -1", ("pervert", "very lewd"), ["她看起来很尴尬。","g: 这很有趣....每当他们换衣服或洗澡时，我经常尝试看一眼，但我们并没有真正交谈太多。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 0", ("pervert", "very lewd"), ["她脸红了，咯咯地笑","g: 有一天，当我在浴室自慰时，有人走进了我。我想知道他们一定会怎么看我。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 0.5", ("pervert", "very lewd"), ["她脸红了，摆弄着拇指。","g: 我想和他们更加亲密。我确信他们可以教我很多东西。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 1", ("pervert", "very lewd"), ["她向你竖起大拇指。","g: 这里有一群不错的荡妇。我从他们身上学到了很多新技巧。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 2", ("pervert", "very lewd"), ["她似乎很高兴，忍不住咯咯笑。","g: 哦，我们是最好的朋友。不要告诉他们我说过这句话，但是... *低语* {i}当客户无法胜任任务时，我们经常互相帮助，获得一些释放。{/i}"], multiple=True, unlock="EI")
    add_dialogue("MC praise friend", ("pervert", "very lewd"), ("*咯咯*哦，谢谢主人。你不会相信我们在一起讨论什么样的变态话题。"), sound=s_laugh)
    add_dialogue("MC demean rival", ("pervert", "rebel", "stubborn", "yandere", "creep"), ("是的，操她。我希望她的小穴能掉下来。"), sound=s_evil_laugh)
    add_dialogue("slave chat well_being -3", ("generic", "very extravert", "very introvert", "very idealist", "very materialist", "very modest", "very sub"), ("*呜咽*哦，主人...我不知道我还能承受多少..."), unlock="MI")
    add_dialogue("slave chat well_being -2", ("generic", "very extravert", "very introvert", "very idealist", "very materialist", "very modest", "very sub"), ("*叹气*今天太糟糕了....想想看，最近的大多数日子都很糟糕。"), unlock="MI")
    add_dialogue("slave chat well_being -1", ("pervert", "very lewd"), ("好吧，说实话，我已经很久没有达到高潮了。"), unlock="MI")
    add_dialogue("slave chat well_being 0", ("pervert", "rebel", "stubborn", "nerd", "easy"), ("嗯，我没事。"), unlock="MI")
    add_dialogue("slave chat well_being 1", ("pervert",  "rebel", "schemer", "pet", "easy",  "loyal"), ("是的，我很好。谢谢主人。"), unlock="MI")
    add_dialogue("slave chat well_being 2", ("pervert", "very extravert"), ("我感觉很好，谢谢！"), unlock="MI")
    add_dialogue("slave chat well_being 3", ("pervert", "very extravert"), ("嘿嘿嘿，你看不出来吗？我热爱生活！"), unlock="MI")
    add_dialogue("slave chat well_being attacked", ("pervert", "rebel", "stubborn", "yandere", "creep", "stubborn"), ("呃...你觉得我在一个月内被攻击和强奸[nb_times]后感觉如何？！完蛋了。请主人做点什么吧。"))
    add_dialogue("slave chat well_being sick", ("pervert", "rebel", "stubborn", "yandere", "creep", "stubborn"), ("[MC.name]主人，今后请多多关照我。这个地方就是个屎坑。这个月我病了 [nb_times] 次。"))
    add_dialogue("slave chat well_being exhausted", ("pervert", "very extravert"), ("请注意不要把我逼得太紧，[MC.name]主人。仅这个月我就因精疲力竭而晕倒了[nb_times]次。"))
    add_dialogue("slave chat well_being MC apology", ("pervert", "helper", "sweet", "nerd", "holy", "prude", "loyal", "repressed", "class president"), ("我指望你，[MC.name]主人。"))
    add_dialogue("slave chat feelings love -1", ("pervert", "very extravert"), ("我现在应该让你感觉很特别吗？我根本不关心你。"), unlock="DS")
    add_dialogue("slave chat feelings love 0", ("pervert", "stubborn", "repressed", "bimbo", "easy"), ("你是一个正派的人，我没有什么可抱怨的。"), unlock="DS")
    add_dialogue("slave chat feelings love 1", ("pervert", "very lewd"), ("我真的很喜欢和你一起度过时光。尤其是当我们都赤身裸体的时候。 *眨眼*"), unlock="DS")
    add_dialogue("slave chat feelings love 2", ("pervert", "very lewd"), ("*脸红*我无法满足你的鸡巴，主人。没有人能像你一样让我高兴。"), unlock="DS")
    add_dialogue("slave chat feelings fear -1", ("generic", "very extravert", "very idealist", "very materialist", "very modest", "very dom"), ("我在你身边感觉不舒服。"), unlock="DS")
    add_dialogue("slave chat feelings fear 0", ("generic", "very extravert", "very idealist", "very materialist", "very modest", "very dom"), ("我认为你没有像你应该的那样关心我。"), unlock="DS")
    add_dialogue("slave chat feelings fear 1", ("pervert", "very extravert"), ("我害怕当我让你不高兴时会发生什么。"), unlock="DS")
    add_dialogue("slave chat feelings fear 2", ("pervert", "meek", "cold", "masochist", "creep", "easy", "schemer"), ("什、你希望我对你有什么感觉，主人？"), unlock="DS")
    add_dialogue("slave chat feelings very disobedient", ("pervert", "very extravert"), ("对我来说，你就像泽恩的其他人一样，真的。"), unlock="DS")
    add_dialogue("slave chat feelings disobedient", ("pervert", "very lewd"), ("只要你确保我能得到乐趣，我想我就可以忍受。"), unlock="DS")
    add_dialogue("slave chat feelings a little obedient", ("pervert", "very lewd"), ("如果我们诚实的话，我主要是出于自身利益的驱使。你的订单恰好符合我的兴趣。 *眨眼*"), unlock="DS")
    add_dialogue("slave chat feelings obedient", ("pervert", "very lewd"), ("我一直认为有关你性能力的故事有些夸张，但你确实是一个值得尊重的男人。"), unlock="DS")
    add_dialogue("slave chat feelings very obedient", ("generic", "very extravert", "very idealist", "very materialist", "very modest", "very dom"), ("您是我所希望的一切，甚至更多，主人。我很荣幸能为您服务，并希望我能在您身边度过余生。"), unlock="DS")
    add_dialogue("slave chat tastes likes", ("pervert", "very extravert"), ("我{i}最喜欢{/i}[best]。这是最好的。吸它，任何其他[thing_cn]！ *傻笑*", "我很确定每个人都同意最好的[thing_cn]就是[best]。"), unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("pervert", "very extravert"), ("让我超级沮丧的一件事是[worst]。哎呀！", "我唯一比禁欲更讨厌的是[thing_cn][worst]。"), unlock="LM")
    add_dialogue("slave chat tastes loves +", ("pervert", "very lewd"), ("我{i}喜欢{/i}[thing_cn]。 *咯咯*看看我的手臂，光是谈论它就让我起鸡皮疙瘩。", "我已经有一段时间没有被赋予[thing_cn]了。我真的很想念他们。", "这听起来可能很奇怪，但[thing_cn]让我很湿。"), unlock="LM")
    add_dialogue("slave chat tastes loves -", ("generic", "very extravert", "very introvert", "very idealist", "very materialist", "very modest", "very dom"), ("小时候我经常收集[thing_cn]。现在看来已经是很久以前的事了。", "我对大多数礼物都不感兴趣。不过，我确实喜欢[thing_cn]。"), unlock="LM")
    add_dialogue("slave chat tastes no loves", ("pervert", "rebel", "stubborn", "bimbo", "schemer", "tsundere"), ("别费心给我送什么礼物了。我不喜欢那些浪漫的举动。"), unlock="LM")
    add_dialogue("slave chat tastes hates", ("pervert", "very extravert"), ("如果你给我买过[thing_cn]，我会把它直接扔进垃圾桶，让你知道。"), unlock="LM")
    add_dialogue("slave chat tastes no hates", ("pervert", "very extravert"), ("如果你给我买东西，就说明你想我了。我很欣赏这一点，即使礼物本身可能不是我喜欢的东西。"), unlock="LM")
    add_dialogue("slave chat tastes positive act", ("pervert", "very lewd"), ("最近我对 [act_desc] 非常着迷。我喜欢看其他人这样做。也许我应该尝试一下？ *咧嘴笑*"), unlock="LM")
    add_dialogue("slave chat tastes negative act", ("pervert", "very lewd"), ("我不明白人们从 [act_desc] 中得到了什么。这对我来说实在是太令人厌烦了。实在是太破坏心情了。"), unlock="LM")
    add_dialogue("slave chat tastes no negative act", ("pervert", "very lewd"), ("*笑*我非常喜欢你能想象到的每一种性爱方式。越变态越好！"), unlock="LM")

    add_dialogue("slave chat origins 1", ("pervert", "very lewd", "bimbo"), ("我在[girl.origin]的一家青楼旁边长大。", "我在[girl.origin]长大。那里太无聊了！", "呃，[girl.origin]。泽恩好多了！"), unlock="EI")
    add_dialogue("slave chat origins 2", ("pervert", "very lewd"), ("我们住在 [girl.origin] 的 [a_home]。我曾经偷偷溜进我的[girl.story_guardian]的房间看他们自慰......*咯咯*", "我们在 [girl.origin] 有一个 [a_home]...我和我的 [girl.story_guardian] 一起做所有事情。"), unlock="EI")
    add_dialogue("slave chat origins 3", ("pervert", "very lewd"), ("回到我们在 [girl.origin] 的 [girl.story_home]，我曾经偷偷溜进我的 [girl.story_guardian] 的房间看他们自慰...... *咯咯*我现在回想起那件事深情地。", "关于我们在 [girl.origin] 的 [girl.story_home] 的许多回忆...我和我的 [girl.story_guardian] 一起做了所有事情。", "*咯咯笑*我仍然记得当我发现我的[girl.story_guardian]在我洗澡时监视我。我当时真是气愤极了。现在我深情地回忆起我们在那个[girl.story_home] 一起度过的时光。"), unlock="EI")
    add_dialogue("origin Zan", ("pervert", "very lewd"), ["g: 我对泽恩的每一个角落都了如指掌。我最喜欢的地方是海滩附近。那里有一个僻静的地方，情侣们会偷偷去那里。当我还是个孩子的时候，我经常躲在岩石后面，看着他们干活。", "g: 有一次我很惊讶地看到我的 [girl.story_guardian] 在那里取悦了五名水手。当然，我仍然留下来观看...."], multiple=True)
    add_dialogue("origin the border with the Holy Lands", ("generic", "very extravert", "very idealist", "very materialist", "very lewd", "very dom"), ["g: 在圣地，人类居住区永远不会长久存在。成群结队的怪物总是潜伏在荒野中，准备夺回他们的土地。", "g: 我的 [girl.story_guardian] 教会我一次只过一天。现在我来到了泽恩，这是我一生中第一次开始梦想我的未来。"], multiple=True)
    add_dialogue("origin the Blood Islands", ("generic", "very extravert", "very idealist", "very materialist", "very lewd", "very dom"), ["g: 回到家后，我发现很难相信我的 [girl.story_guardian] 关于 Zan 的荒诞故事。这一切听起来好得令人难以置信。", "g: 即使是现在，每当顾客对我有一点尊严时，我有时还是要掐自己一下。与血色群岛相比，泽恩确实是奴隶的天堂。"], multiple=True)
    add_dialogue("origin Karkyr", ("pervert", "very lewd"), ["g: 卡克尔的生活给我们带来了沉重的打击。我和我的[girl.story_guardian]都是局外人，从来没有教过如何使用魔法或保护自己免受魔法伤害。结果，我们无力抵抗那些试图入侵我们心灵的卡克尔公民。", "g: 我们经常遇到陌生人倾听我们的想法，或者在我们的脑海中植入变态的幻想。心灵强奸，就是这样....", "g: *叹气*你可能认为我疯了，不是吗？你无法想象我所经历的精神折磨......"], multiple=True)
    add_dialogue("origin Westmarch", ("pervert", "very lewd"), ["g: 威斯特玛公国是一个混乱的地方。你可以生活在肮脏或奢华中，但角色也可以很容易互换。", "g: 当我的[girl.story_guardian]继承了一个小头衔时，我们简直不敢相信自己的运气。从我们的 [girl.story_home] 搬到一座城堡，就像梦想成真一样。", "g: 那周晚些时候，我发现自己躲在地下室里，因为我们的城堡遭到掠夺并被烧毁。我的 [girl.story_guardian] 在被强奸时痛苦地尖叫。不久之后我发现自己来到了泽恩。"], multiple=True)
    add_dialogue("origin the desert of Hokoma", ("pervert", "very lewd"), ["g: 你不会相信我们部落有这样的仪式。当孩子们成年后，他们会执行一项名为“伟大的拥抱”的传统。整个部落都会举行一场盛大的狂欢，让孩子观看，甚至参与。", "g: 我第一次来月经是在我十二岁的时候。我仍然清楚地记得那一天...看着我的[girl.story_guardian]高潮就在我面前...我经常想知道如果我在不同的环境中长大，我会有多大的不同。"], multiple=True)
    add_dialogue("origin Borgo, the port city", ("pervert", "very extravert", "very idealist", "very materialist", "very lewd", "very dom"), ["g: 我的[girl.story_guardian]会在博尔戈的港口工作，装卸船只。大部分工作都是不记名的，当然也有大量的走私活动。", "g: 奴隶贸易尤其突出。尽管博尔戈与泽恩竞争，大多数奴隶仍然首先经过博尔戈。", "g: Zan 已经获得了好处，而 Borgo 至今仍因缺乏监管而遭受损失。"], multiple=True)
    add_dialogue("origin the Goliath desolations", ("pervert", "very lewd", "very introvert", "cold", "nerd", "masochist",  "repressed", "schemer"), ["g: 在歌利亚的荒凉之地，拼命谋生是很困难的。即使是小孩子，我们也必须每天努力工作才能生存。找到时间放松下来玩耍并不容易。", "g: 在某个时候，我的 [girl.story_guardian] 坐下来跟我谈话，教我如何玩自己的小穴。这让我可以从日常的挣扎中分散注意力。"], multiple=True)
    add_dialogue("origin the Arik mountains", ("very lewd", "very extravert", "very sub", "pervert", "creep", "yandere", "helper", "pet", "loyal", "rebel"), ["g: 尽管条件恶劣，但我在阿里克山度过的童年非常舒适。我们一家人会依偎在一起，以保存体温。", "g: 我的[girl.story_guardian]过去总是说我们必须分享我们的身体才能过上健康的生活。"], multiple=True)

    add_dialogue("slave train accepted", ("pervert", "very lewd"), ("很高兴，主人。", "*咯咯笑*听起来很有趣，主人。", "哦，我很愿意！", "噢，主人，太热了！"))
    add_dialogue("slave train resisted", ("pervert", "very lewd"), ("但是....我想我还没有准备好，主人。", "拜托，主人....你能先跟我讲一下吗？我认为我还没有准备好将其付诸实践。", "我一点也不喜欢这样。这让我真的很不舒服。", "为什么你想要{i}那个{/i}？主人，我们就不能做点别的吗？"))
    add_dialogue("slave train refused", ("pervert", "very lewd"), ("啊....我讨厌那样！决不！！", "我喜欢各种性行为....但如果这就是您所寻找的，那么我不是这份工作的合适人选。", "呃....我不可能享受这样的感觉，所以还是别这么做吧。", "哈！你需要一个非常强大的咒语才能让我同意做那样的事情。"))
    add_dialogue("slave lecture love", ("pervert", "very lewd"), ("哦，谈论这个让我很兴奋！请详细描述一下。你能在我耳边低语吗，[MC.name]主人？"))
    add_dialogue("slave lecture neutral", ("pervert", "very lewd"), ("*咯咯笑*我随时准备好听你多汁的性爱谈话，主人。"))
    add_dialogue("slave lecture fear", ("pervert", "very lewd"), ("她看起来对这个话题很感兴趣，但似乎不敢问你任何问题。"))
    add_dialogue("slave lecture refuses", ("pervert", "very lewd"), ("这对我来说听起来像是一件苦差事。我想我永远不想做那样的事情。"))
    add_dialogue("slave lecture very reluctant", ("pervert", "very lewd"), ("哇，我很难相信很多人都喜欢 [act_desc]！这确实不是让我兴奋的事情。"))
    add_dialogue("slave lecture reluctant", ("pervert", "very lewd"), ("*咯咯*当你描述它时听起来很愚蠢。既然有这么多其他方式可以取悦彼此，你为什么要选择这样做呢？"))
    add_dialogue("slave lecture a little reluctant", ("pervert", "very lewd"), ("我可以理解为什么有些人可能会喜欢它，但我对 [act_desc] 不那么感兴趣。"), sound=s_sigh)
    add_dialogue("slave lecture indifferent", ("pervert", "very lewd"), ("*呻吟*你真的让我有心情去尝试！接下来我们可以上实践课吗？"))
    add_dialogue("slave lecture a little interested", ("pervert", "very lewd"), ("*呻吟*这让我如此兴奋......当我们可以尝试一下时为什么要谈论它呢？"), sound=s_surprise)
    add_dialogue("slave lecture interested", ("pervert", "very lewd"), ("嗯...你说得真他妈好！我真的需要尝试一下。"), sound=s_mmh)
    add_dialogue("slave lecture very interested", ("pervert", "very lewd"), ["正如您所描述的，[act_desc] [girl.name] 将一只手滑到大腿之间。", "当她开始和自己玩耍时，她高兴地呻吟着。", "g: 这听起来太棒了，[MC.name]...我迫不及待地想这么做。"], multiple=True, sound=s_mmh)
    add_dialogue("slave lecture fascinated", ("pervert", "very lewd"), ["当您向 [girl.name] 描述 [act_desc] 时，她开始自慰。", "你说的每一句话都被她的呻吟声打断。", "当你结束演讲时，她达到了高潮，一边诱惑地向你眨眼，一边舔干净手指。"], multiple=True, sound=s_aah)
    add_dialogue("slave train obedience", ("pervert", "very extravert"), ("我现在开始加快步伐了！ *咯咯笑*或者也许我只是变得草率和匆忙。"))
    add_dialogue("slave train constitution", ("pervert", "very lewd"), ("*叹气*有很多方法可以在不离开卧室的情况下燃烧这些卡路里......"))
    add_dialogue("slave train refuses", ("generic", "very introvert", "very idealist", "very materialist", "very lewd", "very sub"), ["她明显退缩了。空气中弥漫着一种不舒服的气氛，房间里充满了她沮丧的哭泣和抽泣。"], multiple=True, sound=s_screams)
    add_dialogue("slave train very reluctant", ("pervert", "very lewd"), ("这不是我感到兴奋的事情。请记住，我这么做只是为了你，主人。"), sound=s_scream)
    add_dialogue("slave train reluctant", ("pervert", "very lewd"), ("啊....这真是一件苦差事...."), sound=s_scream)
    add_dialogue("slave train a little reluctant", ("pervert", "very lewd"), ("*咯咯笑*我想，一旦你习惯了，这也不算太糟糕。"), sound=s_surprise)
    add_dialogue("slave train indifferent", ("pervert", "very lewd"), ("嗯...让我们尝试更多实验..."), sound=s_ahaa)
    add_dialogue("slave train a little interested", ("pervert", "very lewd"), ("哇哦，这真的让我湿透了！嗯...我从来不知道 [act_desc] 感觉会这么好。"), sound=s_ahaa)
    add_dialogue("slave train interested", ("pervert", "very lewd"), ("*呻吟*你让我如此兴奋......"), sound=s_mmh)
    add_dialogue("slave train very interested", ("pervert", "very lewd"), ("*呻吟*我快要射精了！啊....我们继续吧...."), sound=s_aah)
    add_dialogue("slave train fascinated", ("pervert", "very lewd"), ("*呻吟*啊...我喜欢你给我的感觉！我可以一遍又一遍地这样做。我非常爱你，[MC.name]..."), sound=s_orgasm_fast)
    add_dialogue("slave train naked failure", ("pervert", "very lewd"), ("C-我可以做点别的事吗？我、我应该为你张开我的小穴吗？不，等等....嗯....也许我应该弯下腰，把一根手指放在我的屁眼里？ *傻笑*"), sound=s_surprise)
    add_dialogue("slave train naked success", ("pervert", "very lewd"), ("主人....请不要再让我穿衣服了。"), sound=s_aah)
    add_dialogue("slave train service failure", ("pervert", "very lewd"), ("她完全忘记了你的命令，似乎完全被你的鸡巴迷住了，从各个角度审视它。"))
    add_dialogue("slave train service success", ("pervert", "very lewd"), ("嗯....我知道您喜欢它，主人....我也是。"))
    add_dialogue("slave train sex failure", ("pervert", "very lewd"), ("我、对不起，主人....这对我来说是全新的。我很紧张。"))
    add_dialogue("slave train sex success", ("pervert", "very lewd"), ("*呻吟*主人的鸡巴真是太棒了。我无法停止射精！"))
    add_dialogue("slave train anal failure", ("pervert", "very extravert"), ("*脸红*我-对不起主人，现在可能不是合适的时间。自昨天午餐以来我一直有一些肠道问题。"))
    add_dialogue("slave train anal success", ("pervert", "very lewd"), ("*呻吟*这感觉真他妈的好......"))
    add_dialogue("slave train fetish failure", ("pervert", "very extravert"), ("啊啊！！安全码！！请停下来，主人....我们忘记先讨论安全词了。"))
    add_dialogue("slave train fetish success", ("pervert", "very lewd"), ("嗯....*咯咯*没有任何限制，主人。尽情地利用和虐待我。"))
    add_dialogue("slave train bisexual failure", ("pervert", "very lewd"), ("我就是不明白！我想要的只是一根真正的有血有肉的鸡巴进入我的小穴....让她在这里有什么意义？"))
    add_dialogue("slave train bisexual success", ("pervert", "bimbo", "creep", "yandere"), ("*咯咯*你想知道我的秘密吗，主人？不要告诉她，但是... *低声* {i}我只是假装我正在取悦我自己的小穴{/i}。"), sound=s_mmh)
    add_dialogue("slave train group failure", ("generic", "very introvert", "very idealist", "very materialist", "very lewd", "very sub"), ("是、所以....我应该先关注谁？ 主-主人？"))
    add_dialogue("slave train group success", ("pervert", "very lewd"), ("*呻吟*它的效率...我一天可以容纳这么多鸡巴...太棒了。"))
    add_dialogue("slave magic obedience success", ("pervert", "very lewd"), ("我必须服从主人....他的鸡鸡是关键...."), sound=s_ahaa)
    add_dialogue("slave magic libido success", ("pervert", "very lewd"), ("我必须寻求尘世的快乐....我的灵魂已被丧失...."), sound=s_mmh)
    add_dialogue("slave magic sensitivity success", ("pervert", "very lewd"), ("首先我必须取悦世界....然后我才能取悦众神...."), sound=s_mmh)
    add_dialogue("slave magic naked success", ("pervert", "very lewd"), ("没有什么可耻的...我想向你展示我的内心..."), sound=s_ahaa)
    add_dialogue("slave magic service success", ("pervert", "very lewd"), ("你是我的主人...我活着就是为了取悦你..."), sound=s_mmh)
    add_dialogue("slave magic sex success", ("pervert", "very lewd"), ("你的礼物给我带来了巨大的快乐...我必须与世界分享这种快乐..."), sound=s_aah)
    add_dialogue("slave magic anal success", ("pervert", "very lewd"), ("我的肛门好美啊....我一定要给大家看一下...."), sound=s_ahaa)
    add_dialogue("slave magic fetish success", ("pervert", "very lewd"), ("M、主人....你的折磨就是我的狂喜...."), sound=s_aah)
    add_dialogue("slave magic bisexual success", ("pervert", "very lewd"), ("让众神看着我们...并被唤醒..."), sound=s_mmh)
    add_dialogue("slave magic group success", ("pervert", "very lewd"), ("我是众神不知疲倦的机器...让所有的机械师润滑我的齿轮..."), sound=s_ahaa)
    add_dialogue("slave magic failure", ("pervert", "very lewd"), ("什、什...那是什么鬼东西？！别再钻进我的脑子里了....如果你想让我做一些奇怪或反常的事情，你尽管问！"), sound=s_scream, unlock="DS")

    add_dialogue("slave reward sex accepted", ("pervert", "very lewd", "pet", "loyal"), ("非常感谢您，主人。骑着你的鸡巴总是让我高兴起来。"), love=3, sound=s_ahaa, unlock="LM")
    add_dialogue("slave reward sex resisted", ("pervert", "very lewd", "pet", "loyal"), ("嗯...现在谁在这里得到奖励？"), love=-1, sound=s_surprise, unlock="LM")
    add_dialogue("slave reward sex refused", ("pervert", "very lewd"), ("不，谢谢。我有自己的玩具可以做这种事。"), sound=s_scream)
    add_dialogue("slave reward praise", ("pervert", "very extravert"), ("*咯咯*这是我的荣幸，真的！"), love=1, unlock="MI")
    add_dialogue("slave reward gold", ("pervert", "superficial", "bimbo", "creep", "pet", "loyal", "yandere"), ("哇...我真正想要的只是你的一点时间。我们两个人，独自一人，兴奋起来....*咯咯笑*"), unlock="MI")
    add_dialogue("slave reward pet", ("pervert", "very lewd"), ["你用手指抚摸她的头发，亲吻她的额头，然后拍打她的屁股示意她离开。", "g: 如果——如果一切都到此为止了，前戏还有什么意义呢？", "g: 看，主人....看看你刚才把我弄湿了多少？", "她在你面前张开她的阴道。大串的阴液从上面滴下来。", "g: *叹气*我现在得走了...来处理这件事。"], multiple=True, love=-1, unlock="DS")
    add_dialogue("slave reward day off", ("pervert", "very lewd"), ("我很感激，主人。有时您需要一些时间来真正服务自己，如果您明白我的意思的话。 *眨眼*"), unlock="DS")
    add_dialogue("slave reward day off KO", ("generic", "very extravert", "very idealist", "very materialist", "very lewd", "very modest"), ("*咯咯*我今天已经休息一天了，傻瓜......"))
    add_dialogue("slave punish scold deserved", ("pervert", "rebel", "stubborn", "yandere", "creep", "pet", "loyal"), ["她羞愧地低下了头。", "g: 我真的搞砸了，主人....我会补偿你的。"], multiple=True, unlock="MI")
    add_dialogue("slave punish scold undeserved", ("pervert", "very extravert"), ["她挑衅地交叉双臂。", "g: 这不对！你就是来找我打架的吗？"], multiple=True, unlock="MI")
    add_dialogue("slave punish upkeep", ("pervert", "very idealist", "nerd", "sweet", "easy", "class president", "tsundere", "loyal"), ("啊，我想这很公平。"), unlock="MI")
    add_dialogue("slave punish upkeep KO", ("pervert", "very extravert"), ("*咯咯笑*嗯...我很确定那里没有什么可以带走的。"))
    add_dialogue("slave punish beat", ("pervert", "very lewd", "masochist"), ["她微笑着弯下腰。你打她的屁股直到它完全变红。每击打一下，口水就会从她嘴里飞出来。", "g: 啊！啊啊哈！！！是的主人！！请....给我....啊啊！", "从她一瘸一拐的样子来看，她显然很痛苦...."], multiple=True, sound=s_screams, unlock="DS")
    add_dialogue("slave punish farm", ("pervert", "very extravert"), ("*笑*农场？你在开玩笑？"), fear=1, unlock="DS")
    add_dialogue("slave punish naked", ("pervert", "very lewd"), ["g: *咯咯*哦不....那太可耻了！", "她想都没想就脱掉衣服，开始在青楼里跑来跑去。", "g: 大家好，看着我！我现在正在受到惩罚！"], multiple=True, fear=-1, unlock="LM")
    add_dialogue("slave punish naked KO", ("pervert", "very extravert"), ("*咯咯笑*你希望我现在开始脱什么衣服？"))
    add_dialogue("slave punish rape", ("pervert", "nerd", "sweet", "easy", "loyal", "masochist"), ("什、什么？！但你不能只是....你不会真的这么做，不是吗？"), unlock="LM")
    add_dialogue("slave raped", ("generic", "very extravert", "very introvert", "very idealist", "very materialist", "very lewd", "very modest"), ("但、但是，主人....等等....啊啊啊！！啊!"), sound=s_screams)
    add_dialogue("slave rape positive fixation", ("pervert", "very lewd"), ("*呻吟*我不敢相信这一切就发生了...T-那太他妈的热了..."), love=3, fear=-2, sound=s_aah)
    add_dialogue("slave rape negative fixation", ("pervert", "very extravert"), ("不，拜托...你知道我讨厌那个...不！"), love=-2, fear=3, sound=s_scream_loud)

    add_dialogue("rest", ("pervert", "very extravert"), ("甜的！是时候我可以放松一下了。如果您需要我，我会在我的房间里。{w=1.0}{nw}"))
    add_dialogue("accept job", ("pervert", "very extravert"), ("当然，我不介意成为一名{b}[girl.job_cn]{/b}。实际上，它有点适合我。{w=1.0}{nw}"))
    add_dialogue("work_whore", ("pervert", "very lewd"), ("所以我正式是一名{b}[girl.job_cn]{/b}，但归根结底我是一名妓女。 *咯咯笑*是的，听起来不错。 {w=1.0}{nw}"))
    add_dialogue("exhausted", ("pervert", "very lewd"), ("主人...我的小穴完全酸痛...别问...我需要更多时间休息，我会以{b}[girl.job_cn]{/b}的身份重新开始工作我一康复。"))
    add_dialogue("rank up", ("pervert", "very lewd"), ("噢，我的 [girl.story_guardian] 会非常自豪！我已经一路攀升到排名[newrank]了！"))
    add_dialogue("refuse whoring", ("pervert", "very lewd"), ("我不这么认为...他们不值得我。"))
    add_dialogue("refuse sex act", ("pervert", "very lewd"), ("啊....我讨厌那样！决不！！", "我喜欢各种性行为....但如果这就是您所寻找的，那么我不是这份工作的合适人选。", "呃....我不可能享受这样的感觉，所以还是别这么做吧。", "哈！你需要一个非常强大的咒语才能让我同意做那样的事情。"))

    add_dialogue("bought", ("pervert", "very extravert"), ("是、所以....我首先应该关注什么？ M主人？"))
    add_dialogue("freed", ("pervert", "very lewd"), ("哇...我会想念这个地方的。"))
    add_dialogue("sold", ("pervert", "very lewd"), ("*叹气*我希望我至少会去另一家青楼....再见，[MC.name]主人。"))
    add_dialogue("sold love", ("pervert", "very lewd"), ("*抽泣*我会想念这个地方的。您教会了我很多...我会永远珍惜您，[MC.name]主人。"), sound=s_surprise)
    add_dialogue("leave for quest", ("pervert", "very lewd"), ("哇哦，是的...是时候上路传播一些爱了。再见！"))
    add_dialogue("leave for class", ("pervert", "very extravert"), ("好吧，那我很快就回来。再见，主人。"))
    add_dialogue("advertise", ("pervert", "very lewd"), ["*咯咯笑*铁杆侏儒古罗！女同性恋变态仪式！你的性幻想可以在[brothel.name]变成现实！", "嘿，伙计....我希望今晚晚些时候能见到你。 *眨眼*", "我是单身，并准备打成一片。今晚我可以在[brothel.name]见你吗？", "如果你有阴茎，就来[brothel.name]向我证明吧！ *傻笑*", "饮料、娱乐、沐浴、约会和妓女！是的，先生们，我们确实拥有一切！", "如果你有一根大鸡巴，现在就向我证明一下，今晚你的第一杯酒就由我来喝！ *傻笑*"])

    add_dialogue("beach intro", ("pervert", "very lewd"), ["当[girl.fullname]走过时，一个无礼的孩子拍了她的屁股。她咯咯地笑，转过头，对男孩摇动手指。"], sound=s_laugh)
    add_dialogue("beach meet MC", ("pervert", "very lewd"), ["g: 啊，[MC.name]！你在这...", "她环视四周所有其他海滩游客，举起一只手以免阳光直射眼睛。", "g: *咯咯笑*每个人几乎都是裸体的。这里有如此多的性能量。", "mc: 确实是这样，[girl.name]...而且你也有部分责任！", "g: 呵呵呵呵....有罪，主人。"], multiple=True)
    add_dialogue("beach oiling", ("pervert", "very lewd"), ["嗯...谢谢您，主人...*低声* {i}如果您愿意，我可以给您做色情按摩。{/i}"], sound=s_ahaa)
    add_dialogue("beach accept oiling", ("pervert", "very lewd"), ["*咯咯*我希望这会导致这个...嗯嗯...继续前进，主人..."])
    add_dialogue("beach refuse oiling", ("pervert", "very lewd"), ["嗯...我会自己做这部分。 *眨眼*"])
    add_dialogue("beach accept public sex", ("pervert", "bimbo", "yandere", "creep"), ["g: 天啊，是的！！我真是太他妈的饥渴了。让我们向所有人证明我们的爱是没有极限的，不是吗？", "mc: 对我来说听起来不错，让我们给人们表演一下吧。", "她深吸一口气，转过身，尽可能大声地喊叫。", "g: 嘿大家，来看看我们互相操蛋吧！！", "果然，一群好奇的人群开始聚集在你们两个周围。", "g: *咯咯*这引起了他们的注意。让我们玩得开心吧..."], multiple=True)
    add_dialogue("beach refuse public sex", ("pervert", "very lewd"), ["不、不....我们真的不需要那种关注，不是吗？难道我们就不能找个僻静的地方吗？"])
    add_dialogue("beach accept sex", ("pervert", "very lewd"), ["你还需要问吗？当然！"])
    add_dialogue("beach refuse sex", ("pervert", "very lewd"), ["这个海滩上还有很多其他候选人。老虎，去钓鱼吧。我可能也会这样做。"])
    add_dialogue("beach whoring request", ("pervert", "very lewd"), ["诶嘿嘿....我的脑海里也闪过同样的念头。你太了解我了..."])
    add_dialogue("beach whoring accept", ("pervert", "very lewd"), ["当然，我会做的。这里所有的裸体真的让我心情愉悦。"])
    add_dialogue("beach whoring refuse", ("pervert", "very lewd"), ["不，我以前也经历过这样的阶段。对我来说已经没有什么刺激了。我是说，在我休息日。"])

## START REBEL DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("rebel", "pervert", "very dom", "cold"), ("我是[girl.fullname]。你想从我处得到些什么？"))
    add_dialogue("free_greetings_casual", ("rebel", "pervert"), ("这是怎么回事。我是[girl.fullname]。"), love=1)
    add_dialogue("free_greetings_rude", ("rebel", "pervert"), ("直接进入正题吧？他们叫我[girl.fullname]。"), love=2)

    add_dialogue("free_small_talk", ("rebel", "pervert", "schemer", "superficial"), ("别再打扰我了，伙计...", "滚蛋吧，混蛋。", "离开。", "迷路吧，蠕动。"), love=-1, max_cap=25)
    add_dialogue("free_gossip", ("rebel", "stubborn", "schemer"), ("好吧，这就是真相...."), love=2, max_cap=25)
    add_dialogue("free_chat_life", ("rebel", "pervert", "superficial"), ("妈的，我不知道....这是什么问题？"), love=1, max_cap=25)
    add_dialogue("free_chat_love", ("rebel", "stubborn", "schemer"), ("爱情是两个人发生冲突时迸发出的火花，你知道我在说什么吗？"), love=2, max_cap=25)
    add_dialogue("free_chat_origins", ("rebel"), ("我的根在[girl.origin]。", "我对[girl.origin]了如指掌。", "老兄，我去过[girl.origin]的每一个肮脏的角落。"), love=2, max_cap=40)
    add_dialogue("free_chat_hobbies", ("rebel", "pervert", "cold"), ("我更喜欢放松一下，但我想[hobby]还可以。", "我不知道，伙计....也许是[hobby]？", "他妈的，伙计...我猜是[hobby]？"), max_cap=40)
    add_dialogue("free_chat_likes", ("rebel"), ("[thing_cn][best]是不会出错的。","你让我陷入了困境....我会说[best]是一个相当愚蠢的[thing_cn]。"), love=2, max_cap=40)
    add_dialogue("free_chat_dislikes", ("rebel", "pervert"), ("呃，为什么要讲这个？你让我很沮丧。 [thing_cn][worst]很糟糕。", "他妈的[worst]是一件狗屎[thing_cn]。"), max_cap=40)

    add_dialogue("free_joke_harmless", ("rebel", "very dom", "pervert"), ("... Is that the best you can do?"), love=-2, max_cap=50)
    add_dialogue("free_joke_adult", ("rebel", "pervert"), ("哇哈哈！！真他妈歇斯底里！"), love=3, max_cap=50)
    add_dialogue("free_joke_dark", ("rebel", "schemer", "stubborn"), ("哈哈哈！这真是太有趣了！"), love=3, max_cap=50)
    add_dialogue("free_joke_mean", ("rebel", "stubborn", "schemer"), ("嘿！操你妈....他妈的混蛋...."), love=-1, max_cap=50)

    add_dialogue("free_touch_hand", ("rebel"), ("我们必须这样做吗？有点尴尬啊...."), love=1, max_cap=90)
    add_dialogue("free_touch_kiss", ("rebel", "sweet", "loyal", "bimbo", "class president"), ["她倾身向前，给了你一个充满激情的吻....", "她用舌头舔舐你的舌头，发出可爱的呻吟声。", "g: 嗯...."], multiple=True, love=1, max_cap=90)
    add_dialogue("free_touch_ass", ("rebel", "superficial", "schemer"), ("Hands off! You pervert! *生气*"), love=0, max_cap=90)
    add_dialogue("free_touch_breasts", ("rebel", "pervert", "superficial", "pet", "stubborn", "schemer", "holy"), ("Mmmh... That feels good... *脸红*"), love=4, max_cap=90)
    add_dialogue("free_touch_pussy", ("rebel", "pervert"), ("呵呵....大胆的举动！ *咧嘴笑*"), love=2, max_cap=90)

    add_dialogue("free_play refuses", ("rebel", "cold"), ("他妈的不！我们没那么亲密，宝贝。"), love=-1)
    add_dialogue("free_play very reluctant", ("rebel", "cold"), ("呃，真恶心....好吧，我们就这样结束吧...."), love=1)
    add_dialogue("free_play reluctant", ("rebel", "cold"), ("如果我这样做了，你会停止纠缠我吗？"), love=2)
    add_dialogue("free_play a little reluctant", ("rebel"), ("哥们儿，别欺负我..."), love=2)
    add_dialogue("free_play indifferent", ("rebel"), ("*笑*你真的喜欢那个吗？我实在不明白..."), love=3)
    add_dialogue("free_play a little interested", ("rebel", "cold"), ("当然可以，伙计。"), love=4)
    add_dialogue("free_play interested", ("rebel", "masochist"), ("没必要问。如果你想要的话，就拿走吧。"), love=4)
    add_dialogue("free_play very interested", ("rebel", "pet"), ("嗯...你在读我的心思！"), love=5)
    add_dialogue("free_play fascinated", ("rebel", "masochist"), ("*呻吟*操，是的，带我[MC.name]。"), love=5)
    add_dialogue("MC take virginity", ("rebel"), ("啊，操....我在流血！数字，因为这是我第一次..."), love=5)
    add_dialogue("free_play interested after", ("rebel"), ("我喜欢你让我窒息的感觉。"))
    add_dialogue("free_play not interested after", ("rebel"), ("你太温柔了。给我一些热情吧！"))

    add_dialogue("free_flirt_beauty", ("rebel"), ("哼，你以为你这软弱的恭维就能让你上我的裤子吗？"), love=-1, max_cap=75)
    add_dialogue("free_flirt_body", ("rebel", "prude", "stubborn"), ("*笑*当你整天与男人打架时，保持这种状态是很自然的。"), love=3, max_cap=75)
    add_dialogue("free_flirt_mind", ("rebel", "pervert", "bimbo"), ("嘿伙计，别再给我那淡味酱了。它很烦人。"), love=1, max_cap=75)
    add_dialogue("free_flirt_spirit", ("rebel"), ("干杯，伙计。这是因为我总是以锻炼开始新的一天。我喜欢那种肾上腺素激增的感觉。"), love=3, max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("rebel"), ["g: 我已经受够了人们因为这种狗屎来评判我了。", "g: 就算我喜欢被四面八方殴打又怎样，那是我的事！你不会阻止我的！"], multiple=True, love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("rebel"), ("我并不是想吹牛，但是是的....我真的很擅长这件事。"), love=2)
    add_dialogue("free_flirt_sex_experience average", ("rebel"), ("如果我想玩玩，那就这么做。你有什么问题吗？"), love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("rebel"), ["g: 哦，是的，当然！我已经受够了....相信我，我是城里最好的人。", "mc: 嗯....真的吗？不知怎的，我怀疑这是真的。"], multiple=True)
    add_dialogue("free_flirt_sex_experience very inexperienced", ("rebel"), ["她看起来很慌张。", "g: 噢——当然！我-我是城里最好的人，相信我。", "mc: 嗯....真的吗？不知怎的，我怀疑这是真的。"], multiple=True, love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("rebel"), ["g: 这真的不关你的事......", "g: 就算我说我是处女，你又在乎什么？"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("rebel"), ("*笑*是这样吗？介意我测试一下你的决心吗？"), love=4)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("rebel"), ("*咧嘴一笑*不错的尝试，但当我看到一个骗子时我就知道了。"), love=1)

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("rebel"), ("真令人失望。你应该活一点！"))
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("rebel"), ("*笑*当我看到一个骗子时我就知道他是骗子。"), love=-1)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("rebel"), ("就在。不要让任何事情阻止您享受乐趣。"), love=1)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("rebel"), ("甜的。你应该来参加我的聚会。"), love=2)
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("rebel"), ("少说废话，你在我看来没那么令人印象深刻。"))
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("rebel"), ("啊....你把它当作一份工作吗？我不确定我是否能够以同样的方式享受它。"), love=1)

    add_dialogue("free_flirt_sex_act refuses", ("rebel"), ["她给你一个难以置信的表情。", "g: 这太恶心了，伙计。这真的是你的幻想之一吗？"], multiple=True)
    add_dialogue("free_flirt_sex_act very reluctant", ("rebel"), ["她厌恶地看着你。", "g: 别让我生病了。我必须喝得很醉才能尝试这样做。"], multiple=True)
    add_dialogue("free_flirt_sex_act reluctant", ("rebel"), ["她想了一会儿。", "g: 很无聊....但是当我一脸糟糕的时候，一切都会发生。"], multiple=True)
    add_dialogue("free_flirt_sex_act a little reluctant", ("rebel"), ["她看起来很矛盾。", "g: 嗯...我更喜欢冒险一点。"], multiple=True)
    add_dialogue("free_flirt_sex_act indifferent", ("rebel", "cold"), ["她考虑了一会儿她的答案。", "g:  是的，我对此很满意。"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_act interested", ("rebel"), ["她咧嘴一笑，做了个手淫的动作。", "g: 你喜欢边敲打竿子边想着这些事情吗？", "g: 不能说我责怪你，我自己也挺喜欢这样的。"], multiple=True, love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("rebel"), ["她在空中挥动拳头。", "g: 我的男人！现在我们正在说话。这就是我喜欢的东西。"], multiple=True, love=2)
    add_dialogue("free_flirt_sex_act very interested", ("rebel"), ["她咬着嘴唇.", "g: 那太他妈的火热了....继续说，我很享受。"], multiple=True, love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("rebel"), ["她舔了舔嘴唇，把手放在你的肩膀上。", "g: [MC.name]，我很高兴你提出这个问题。这是我最喜欢的科目之一！"], multiple=True, love=3)

    add_dialogue("free_give_gold +++", ("rebel", "schemer"), ("在我母亲的坟墓上，我保证今晚我不会把这些第纳尔花在性奴隶和酒上。"), love=6, max_cap=75)
    add_dialogue("free_give_gold ++", ("rebel"), ("干杯，伙计。让我请您喝杯饮料。"), love=4, max_cap=75)
    add_dialogue("free_give_gold +", ("rebel", "schemer"), ("继续给我你的钱。"), love=2, max_cap=75)
    add_dialogue("free_give_gold -", ("rebel"), ("这其中的乐趣在哪里呢？我应该{i}欺负{/i}你给我现金。"), max_cap=75)
    add_dialogue("free_give_gold --", ("rebel", "princess", "superficial"), ("为了你的缘故，我希望你明天回来的时候能带上更多的东西。"), love=-1, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("rebel", "very dom"), ["她给了你一个愤怒的眼神.", "g: 我？一个妓女？你他妈的疯了吗!", "mc: 考虑到你的选择，你真的有选择吗?", "g: 这是什么....太糟糕了。至少它能帮我摆脱麻烦吗?"], multiple=True, love=2)
    add_dialogue("free_offer_job half_lie", ("rebel"), ["她看起来很生气。", "g: 你说的和我想的一样吗？我应该把你打晕，[MC.name]。", "mc: 考虑到你的情况，我认为你没有太多选择。", "g: 啊....这太操蛋了。至少它能让我摆脱困境吗？"], multiple=True)
    add_dialogue("free_offer_job lie", ("rebel"), ["她看起来很生气。", "g: 你说的和我想的一样吗？我应该把你打晕，[MC.name]。", "mc: 考虑到你的情况，我认为你没有太多选择。", "她握紧拳头，摆出战斗的姿势。", "g: 你真的想这么做吗，[MC.name]？来找我吧，混蛋！", "mc: [girl.name]，听我说。在这里考虑一下你的选择......我正在努力帮助你。"], multiple=True, love=-5)
    add_dialogue("free_offer_job success", ("rebel"), ["她恢复了平静，连忙擦去眼中涌出的泪水。", "g: 啊....操....我很抱歉我对你发脾气了，[MC.name]。这种情况让我彻底崩溃了。", "g: 你说得对，我必须振作起来....我能做到。"], multiple=True)
    add_dialogue("free_offer_job thinking", ("rebel"), ["她恢复了平静，连忙擦去眼中涌出的泪水。", "g: 啊....操....我很抱歉我对你发脾气了，[MC.name]。这种情况让我彻底崩溃了。", "g: 我需要考虑一下这个问题。如果有必要的话，我会设法解决这个问题。"], multiple=True)
    add_dialogue("free_offer_job failure lie", ("rebel"), ["她开始攻击你，左右扔钩子。你勉强躲开了她的攻击。", "g: 拿着这个，你这个混蛋！", "g: 你他妈的怎么敢！我要把你那家青楼烧毁！", "mc: 简单！简单的！", "你击退了她，让自己脱离了困境，给了她一些时间来思考问题。"], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("rebel"), ["她开始攻击你，左右扔钩子。你勉强躲开了她的攻击。", "g: 拿着这个，你这个混蛋！", "g: 你他妈的怎么敢！我会把你的牙齿打掉。", "mc: 简单！简单的！", "你击退了她，让自己脱离了困境，给了她一些时间来思考问题。"], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("rebel"), ["g: 操他妈的！那么您可以在第纳尔滚滚而来的时候放松一下吗？", "mc: 还有更多的事情要做。女孩们可能会很多。需要花费很多时间来让他们保持一致。", "她点头同意。", "g: 我完全明白你的意思。有些人只能通过艰难的方式才能学到东西。", "mc: 那么，你也做了类似的事情吗？", "g: 我？不....我现在正处于两件事之间。"], multiple=True, love=3)
    add_dialogue("free_friend half_lie", ("very idealist", "rebel"), ["g: 一个[MC.playerclass]? 哦，这太棒了！你应该教给我一些技巧!", "mc: 嗯，当然... 你呢，你是做什么的?", "她的情绪有点低落了.", "g: 嗯，就像你一样....我现在没有工作..."], multiple=True, love=-4)
    add_dialogue("free_friend lie", ("rebel"), ["g: 哦？你不是每天都能听到这样的话。听起来是一笔相当不错的交易。", "mc: 薪水不错。你呢？", "g: 我很难保住一份工作。我总是和那些对我发号施令的人打架。 *笑*"], multiple=True, love=3)

    add_dialogue("free_love_interest", ("rebel"), ["她看起来很紧张。","mc: 怎么了，[girl.name]。你看起来很紧张。", "g: [MC.name]...现在可能不是一个好时机。我很生气。", "mc: 你可以和我谈谈。也许我可以帮忙？","g: 啊，没什么。我刚刚和这个混蛋吵架了，他说我永远找不到男人。说我不{i}淑女{/i}，不管那是什么意思。", "g: 我很生气。踢他的屁股并没有让我高兴起来。我一直在想....如果他是对的怎么办？", "mc: 我很高兴听到他得到了他应得的。别让它影响到你。", "g:  是的，谢谢。抱歉打扰你了。", "现在可能是带些鲜花并约她出去的好时机。"], multiple=True)
    add_dialogue("free_girl get_flowers", ("rebel"), ["她看起来很惊讶。","g:  鲜花？做什么的？"], multiple=True)
    add_dialogue("free_ask_out", ("rebel"), ["mc: [girl.name]，我觉得你很棒。我无法停止想象我们在一起，踢屁股。", "mc: 我会跟随你去任何地方。我可以做你的男人吗？", "她的眼里涌出泪水。", "g: *呜咽* [MC.name]！你不知道我多么需要听到这个。是的！当然好！", "她很快擦掉眼泪，给了你一个漫长而热情的吻。", "她将一只手放在你的屁股上，用力挤压。", "g: 我很高兴你是我的。我真的需要一次像这样的新冒险。"], multiple=True)

    add_dialogue("free_girlfriend intro", ("rebel"), ["[girl.name] 脸上挂着顽皮的微笑。", "g: [MC.name]...你对我很好。我打赌你一定很渴，不是吗？", "mc: 你什么意思？", "g: 是时候我们采取更进一步的行动了。跟我来。我会为你脱光。", "mc: 哦，很高兴！带路。", "g: 但首先，我想问你一个问题."], multiple=True)
    add_dialogue("free_girlfriend right", ("rebel"), ("你做到了。过来吧。"), love=5)
    add_dialogue("free_girlfriend give_up", ("rebel"), ("*皱眉*呃，没关系。"), love=-5)
    add_dialogue("free_girlfriend wrong", ("rebel"), ["g: *拳击*你觉得这很有趣吗？他妈的白痴。", "mc: 哎呀，我的错。"], multiple=True, love=-10)
    add_dialogue("free_girlfriend success", ("rebel"), ["她很快脱掉衣服，将身体贴近你的身体。", "g: 我们玩得开心吧？是时候我们加强身体锻炼了。你想玩玩吗？", "她把手放在你的胯部，嘴唇放在你的唇上。当你们的舌头交融时，她抚摸着你抽动的阴茎。", "g: 哦...你已经很大了，不是吗？"], multiple=True)
    add_dialogue("free_girlfriend success naked", ("rebel"), ["她很快脱掉衣服，将身体贴近你的身体。", "g: 我终于摆脱了这些愚蠢的衣服。它们只是束缚你的另一个枷锁。我宁愿一直赤身裸体。","g: 我们玩得开心吧？是时候我们加强身体锻炼了。你想玩玩吗？", "她把手放在你的胯部，嘴唇放在你的唇上。当你们的舌头交融时，她抚摸着你抽动的阴茎。", "g: 哦...你已经很大了，不是吗？"], multiple=True)

    add_dialogue("free_job_request", ("rebel", "very dom"), ["g: [MC.name]... 帮帮我, 求你了! *恐慌*", "mc: 寻求帮助？那听起来不像是你...", "g: 我...几周前我遇到过这个人...他想强奸我。几天后我就要受审了。他们会....他们会奴役我的!", "在泽恩，如果你没有钱来支付你的罪行，法官可以判你为奴隶...", "g: 我用我最后的一点钱支付了保释金....他们会判我有罪，然后那个人的兄弟会把我变成奴隶！他们会在我有生之年一直强奸和折磨我!", "g: 数以千计的迪纳....已经没有办法了....如果我能设法逃脱这场审判就好了...", "mc: Mmmh... 你知道奴隶是不能被审判的吗？只有自由人才可以?", "g: 但我不是一个奴隶....你在暗示什么?"], multiple=True)
    add_dialogue("gizel take girl to farm", ("rebel"), ("啊哈哈哈，新鲜奴肉！我很快就会让她失去斗志。"))
    add_dialogue("MC fight intro", ("very dom"), ["g: 不！！！你不能逼我！离我远点，你这个混蛋！", "她以惊人的力量与你战斗。"], multiple=True, sound=s_scream_loud)

    add_dialogue("slave chat slave_life -2", ("very dom"), ["她用布满血丝的眼睛看着你。", "g: 我他妈的讨厌它！我恨它！！！我又不是一块动产....放开我，该死！"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life -1", ("very dom"), ["她给你一个生气的表情。", "g: 我不想当奴隶！太可怕了！"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0", ("very dom"), ["她翻白眼。", "g: 我，一个奴隶！我做了什么值得这样....好吧，无论如何，我现在在这里。 *叹*"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0.5", ("very dom"), ["她叹了口气。", "g: 它有它的优点和缺点。当然我更喜欢自由..."], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 1", ("very dom"), ["她给你一个淡淡的微笑。", "g: 说实话，情况并没有我想象的那么糟糕。我已经习惯了。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 2", ("very dom"), ["她给了你一个大大的微笑。", "g: 生活真好！我从没想过我会这么说，但我很幸运能成为你的奴隶。谢谢。"], multiple=True, unlock="DS")

    add_dialogue("slave chat tastes likes", ("rebel"), ("[thing_cn][best]是不会出错的。","你让我陷入了困境....我会说[best]是一个相当愚蠢的[thing_cn]。"), unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("rebel", "pervert"), ("呃，为什么要讲这个？你让我很沮丧。 [thing_cn][worst]很糟糕。", "他妈的[worst]是一件狗屎[thing_cn]。"), unlock="LM")
    add_dialogue("slave chat origins 1", ("rebel"), ("我的根在[girl.origin]。", "我对[girl.origin]了如指掌。", "老兄，我去过[girl.origin]的每一个肮脏的角落。"), unlock="EI")
    add_dialogue("origin the Blood Islands", ("rebel"), ["g: 我和我的[girl.story_guardian]在血群岛长大。血群岛和这里很像，只是更粗糙一些。", "g: 我对奴隶制和贵族并不陌生，他们认为自己是一个不同的品种。鲜血议会的法师们说他们的血管里流淌着精灵的血液！", "g: ....哦操，我多么恨他们啊！"], multiple=True)

## START COLD DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("cold", "masochist", "rebel"), ("...{w=1} 我是 [girl.fullname]。我真的不需要你的帮助，但还是谢谢你。"), love=2)
    add_dialogue("free_greetings_casual", ("cold", "generic", "repressed", "rebel"), ("...{w=1} 我是 [girl.fullname]。"), love=1)
    add_dialogue("free_greetings_rude", ("cold", "generic", "superficial"), ("怎么了...我是[girl.fullname]。"))

    add_dialogue("free_small_talk", ("cold", "pervert", "princess", "bimbo", "holy", "superficial"), ("谁在乎..."), love=1, max_cap=25)
    add_dialogue("free_gossip", ("cold", "pervert", "generic"), ("你听说过这个吗？"), love=1, max_cap=25)
    add_dialogue("free_chat_life", ("cold", "nerd", "generic"), ("有趣的问题！好吧，这是我想到的一个理论..."), love=1, max_cap=25)
    add_dialogue("free_chat_love", ("cold", "masochist", "superficial", "class president"), ("不多。我不相信爱情."), love=1, max_cap=25)
    add_dialogue("free_chat_origins", ("cold", "nerd", "masochist", "creep", "schemer", "yandere"), ("[girl.origin]。", "我在[girl.origin]长大。", "我来自[girl.origin]。"), max_cap=40)
    add_dialogue("free_chat_hobbies", ("cold", "very introvert", "holy"), ("我喜欢 [hobby].", "我觉得 [hobby] 还可以.", "大部分时间都在 [hobby]."), love=3, max_cap=40)
    add_dialogue("free_chat_likes", ("cold", "very introvert", "stubborn", "princess"), ("最好的东西]？这是[best]。"), love=1, max_cap=40)
    add_dialogue("free_chat_dislikes", ("cold", "rebel", "superficial", "bimbo", "prude", "schemer", "stubborn", "repressed"), ("你知道，[worst]是一件可怕的[thing_cn]。"), max_cap=40)

    add_dialogue("free_joke_harmless", ("cold", "very introvert", "bimbo", "repressed", "prude"), ("*咯咯笑*好吧，你让我知道了。"), love=2, max_cap=50)
    add_dialogue("free_joke_adult", ("cold", "nerd", "masochist", "schemer", "stubborn", "princess"), ("哎呀...继续练习。"), love=-1, max_cap=50)
    add_dialogue("free_joke_dark", ("cold", "pervert", "superficial", "creep"), ("你的材料需要一些工作。"), love=-1, max_cap=50)
    add_dialogue("free_joke_mean", ("cold", "masochist", "meek", "princess"), ("好一个。"), love=3, max_cap=50)

    add_dialogue("free_touch_hand", ("cold", "pervert", "superficial", "bimbo"), ("不要那么做！", "把手留给自己！"), love=0, max_cap=90)
    add_dialogue("free_touch_kiss", ("cold", "nerd", "repressed", "schemer", "tsundere", "stubborn"), ["她亲吻你的脸颊。", "g: 高兴吗？"], multiple=True, love=5, max_cap=90)
    add_dialogue("free_touch_ass", ("cold", "pervert", "rebel", "bimbo", "pet", "easy", "loyal"), ("嗯...继续..."), love=3, max_cap=90)
    add_dialogue("free_touch_breasts", ("cold", "tsundere", "easy", "class president"), ("嗬，哼....去玩自己的乳头吧。"), love=2, max_cap=90)
    add_dialogue("free_touch_pussy", ("cold", "nerd", "schemer", "princess", "stubborn"), ("*呻吟*我们现在必须这样做吗？"), max_cap=90)

    add_dialogue("free_play refuses", ("cold", "stubborn", "rebel", "creep", "yandere"), ["她冷冷地瞪了你一眼。", "g: 没有。"], multiple=True, love=-1)
    add_dialogue("free_play very reluctant", ("cold", "rebel", "stubborn", "schemer", "tsundere"), ["g: 呃...我必须这样做吗？", "g:  好吧！就这一次，好吗？"], multiple=True, love=1)
    add_dialogue("free_play reluctant", ("cold", "meek", "stubborn", "very introvert"), ("如果我这样做，你会留下我一个人吗？"), love=2)
    add_dialogue("free_play a little reluctant", ("cold", "stubborn", "schemer", "very introvert"), ("好吧...下次我们来做一些{i}我{/i}喜欢的事情吧。"), love=2)
    add_dialogue("free_play indifferent", ("cold", "stubborn", "rebel", "very materialist"), ("当然...让我们快点吧。"), love=3)
    add_dialogue("free_play a little interested", ("cold", "rebel", "very introvert"), ("好的..."), love=4)
    add_dialogue("free_play interested", ("cold", "rebel", "very introvert"), ("听起来不错。"), love=4)
    add_dialogue("free_play very interested", ("cold", "very introvert"), ("我们开始做吧。"), love=5)
    add_dialogue("free_play fascinated", ("cold", "rebel"), ("他妈的是的。"), love=5)
    add_dialogue("MC take virginity", ("cold"), ("我以前从未这样做过。"), love=5)
    add_dialogue("free_play interested after", ("cold", "masochist"), ("谢谢。"))
    add_dialogue("free_play not interested after", ("cold", "tsundere", "yandere", "very materialist"), ("那太糟糕了。"))

    add_dialogue("free_flirt_beauty", ("cold", "masochist", "rebel", "stubborn"), ("和其他日子一样。"), love=1, max_cap=75)
    add_dialogue("free_flirt_body", ("cold", "masochist"), ("是的？"), love=2, max_cap=75)
    add_dialogue("free_flirt_mind", ("cold", "stubborn", "nerd", "holy", "loyal"), ("谢谢。"), love=2, max_cap=75)
    add_dialogue("free_flirt_spirit", ("cold", "masochist", "creep", "repressed"), ("...{w=1} 什么？"), max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("cold", "rebel", "very materialist"), ("是的，我几乎已经完成了这一切。"), love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("cold", "very dom", "very materialist"), ("我和很多不同的男人一起尝试过很多事情。"), love=2)
    add_dialogue("free_flirt_sex_experience average", ("cold", "very materialist"), ("我尝试过一些事情。"), love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("cold", "very introvert"), ("我想并非如此。"))
    add_dialogue("free_flirt_sex_experience very inexperienced", ("cold", "nerd", "masochist", "schemer", "stubborn"), ("一点都不。"), love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("cold", "sweet", "helper", "easy", "loyal", "very introvert"), ("我还是像新的一样。"), love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("cold", "rebel", "masochist", "easy", "loyal"), ("这很酷。"), love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("cold", "meek", "superficial", "pet"), ("是啊，对..."), love=-2)

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("cold", "masochist", "schemer", "class president"), ("你还有足够的时间来提高。"), love=4)
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("cold", "nerd", "masochist", "meek", "creep", "schemer", "class president"), ("我觉得很难相信。"), love=1)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("cold", "creep", "tsundere", "yandere", "stubborn"), ("当然，无论如何。"), love=-1)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("cold", "very lewd", "very materialist"), ("证明给我看。"), love=3)
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("cold", "very lewd", "very materialist"), ("动物不算数。"))
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("cold", "very materialist"), ("对你有好处！"), love=3)

    add_dialogue("free_flirt_sex_act refuses", ("cold", "stubborn", "rebel", "creep", "yandere"), ["她冷冷地瞪了你一眼。", "g: 没有。"], multiple=True)
    add_dialogue("free_flirt_sex_act very reluctant", ("cold", "stubborn", "rebel", "creep", "yandere"), ["她冷冷地瞪了你一眼。", "g: 我们能谈谈别的事吗？"], multiple=True)
    add_dialogue("free_flirt_sex_act reluctant", ("cold", "stubborn", "rebel"), ["她看起来很生气。", "g: 你为什么对这种东西这么着迷？"], multiple=True)
    add_dialogue("free_flirt_sex_act a little reluctant", ("cold", "stubborn", "rebel"), ["g:  是的，当然。", "g: 如果你问我的话，这没什么特别的......"], multiple=True)
    add_dialogue("free_flirt_sex_act indifferent", ("cold", "stubborn", "rebel"), ("我想，和其他人一样。"), love=1)
    add_dialogue("free_flirt_sex_act interested", ("cold", "rebel", "schemer"), ["她笑了。", "g: 哦，当然！我很感兴趣。"], multiple=True, love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("cold", "rebel", "very materialist"), ["她笑了。", "g: 是的，我喜欢。"], multiple=True, love=2)
    add_dialogue("free_flirt_sex_act very interested", ("cold", "rebel", "very materialist"), ["她笑着说.", "g: 我第一次听说这个是在小学的时候。", "g: 即使是现在，我仍然想很多。"], multiple=True, love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("cold", "bimbo", "pet"), ["她的脸颊涨得通红。", "g: 你从哪里听说的？", "g: 我可以告诉你很多关于那件事的尴尬故事......但我仍然喜欢它。 *眨眼*"], multiple=True, love=3)

    add_dialogue("free_give_gold +++", ("cold", "rebel", "superficial", "bimbo"), ("哇哦，进球了！你中了彩票还是什么的？"), love=8, max_cap=75)
    add_dialogue("free_give_gold ++", ("cold", "superficial", "prude", "princess"), ("我很感激！"), love=5, max_cap=75)
    add_dialogue("free_give_gold +", ("cold", "rebel", "schemer", "bimbo", "princess"), ("我很乐意从你手中接过这个。"), love=3, max_cap=75)
    add_dialogue("free_give_gold -", ("cold", "superficial", "prude", "princess"), ("你突然怎么了？"), love=1, max_cap=75)
    add_dialogue("free_give_gold --", ("cold", "rebel", "stubborn", "princess"), ("我不需要你的第纳尔。"), love=-2, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("cold"), ["她沉思了一会儿。", "g: 那么，你认为....足够多的悲伤笨蛋会把他们的金子扔给我吗？", "g: 我不会撒谎，这个想法确实在某个时候闪过我的脑海。", "g: 谢谢你告诉我真相。我需要考虑一下。"], multiple=True, love=1)
    add_dialogue("free_offer_job half_lie", ("cold"), ["g: 他妈的什么？！青楼老板和[MC.playerclass]之间有很大的区别！", "mc: 哦，对不起....有吗？", "mc: 到目前为止，我作为[MC.playerclass]的技能似乎与日常操作密切相关......", "g: 那么一般女孩每天能赚多少钱？"], multiple=True, love=1)
    add_dialogue("free_offer_job lie", ("cold"), ["g: 我猜你在隐瞒什么....", "g: 在青楼工作听起来还不错....", "mc: 我相信你会喜欢的。你会有自己的房间和一切！", "mc: 你可以免费使用所有设施，甚至可以对我的私人奴隶西尔发号施令。", "g: 听起来不错....", "她茫然地望着远方，陷入了沉思。"], multiple=True)
    add_dialogue("free_offer_job success", ("cold"), ("不管怎样，让我们​​试一试吧！"))
    add_dialogue("free_offer_job thinking", ("cold"), ["g: 我会过去的。这不适合我。", "g: 我想进一步探索我的选择。", "她离开了。"], multiple=True)
    add_dialogue("free_offer_job failure lie", ("cold"), ["她一拳打在你的下巴上。", "g: 我认为你提出这样的建议就是一个大混蛋。", "g: 也许我们应该不再见面了。", "她握紧拳头走开。", "mc: 哎哟....","mc: 她稍后会付钱的。"], multiple=True, love=-15, sound=s_punch)
    add_dialogue("free_offer_job failure no_lie", ("cold"), ["她一拳打在你的下巴上。", "g: 你的奴隶之一？你就是这么想我的吗？", "g: 也许我们应该不再见面了。", "她握紧拳头走开。", "mc: 哎哟....","mc: 她稍后会付钱的。"], multiple=True, love=-15, sound=s_punch)

    add_dialogue("free_friend no_lie", ("cold"), ["g: 数字....至少你是直接的。", "mc: 那你呢？", "g: 我还过得去。到处打零工..."], multiple=True)
    add_dialogue("free_friend half_lie", ("cold"), ["g: 好的。说实话，我真的不在乎。", "mc: 那你是做什么的呢?", "g: 不多，如果我能帮忙的话...."], multiple=True, love=2)
    add_dialogue("free_friend lie", ("cold"), ["g: 对你有好处。", "mc: 是的，谢谢。你是做什么的？", "g: 不多，真的...."], multiple=True, love=-2)

    add_dialogue("free_love_interest", ("cold"), ["mc: 很高兴再次见到你，[girl.name]。", "g: 是啊是啊，别废话了。那么你什么时候终于要约我出去呢？", "mc: 慢点，女孩。这有点出乎意料，你说呢？", "g: 这种关系必须走向某个地方。要么约我出去，要么你就别管我了。", "g: 并且不要成为一个小气鬼。带上鲜花。", "mc: 嗯，我考虑一下...."], multiple=True)
    add_dialogue("free_girl get_flowers", ("cold"), ["g: ...", "她满怀期待地看着你。", "g: 嗯？您还有什么想问的吗？"], multiple=True)
    add_dialogue("free_ask_out", ("cold"), ["g: 终于。花了你足够长的时间...", "她把头发向后梳，倾身吻了吻。"], multiple=True)

    add_dialogue("free_girlfriend intro", ("cold"), ["g: 嘿[MC.name]，我们现在已经很了解了，对吧？", "mc: 是的，你可以这么说。", "g: 是吗？向我证明一下。"], multiple=True)
    add_dialogue("free_girlfriend right", ("cold"), ("这是正确的。我想你确实了解我一点。"), love=5)
    add_dialogue("free_girlfriend give_up", ("cold"), ("你对我一无所知，是吗？"), love=-5)
    add_dialogue("free_girlfriend wrong", ("cold"), ("答错了！你对我一无所知，是吗？"), love=-10)
    add_dialogue("free_girlfriend success", ("cold"), ["她开始在你面前脱衣服。", "g: 你知道吗，每当我们在一起的时候，我就想和你做一些猥亵的事情？", "g: 如果你愿意的话，你也可以裸体。"], multiple=True)
    add_dialogue("free_girlfriend success naked", ("cold"), ["她开始在你面前脱衣服。", "g: 你知道我更喜欢一直裸体吗？", "g: 而且，每当我们在一起时，我就忍不住想和你做一些猥亵的事情。", "g: 如果你愿意的话，你也可以裸体。"], multiple=True)

    add_dialogue("free_job_request", ("cold"), ["g: 嘿[MC名称]...", "她看起来心烦意乱。", "g: 我有件事想请你帮个忙。", "mc: 这是什么，[girl.name]？", "g: 我....我最近遇到了一些严重的挫折。", "g: 我希望你能让我重新站起来。我需要一个地方住下，解决问题。", "她叹了口气，抓住了你的手臂。", "mc: 别担心，[girl.name]。你会反弹的。"], multiple=True)

    add_dialogue("accept farm", ("cold", "rebel", "superficial", "bimbo", "stubborn"), ("唉，真是拖累啊...."))
    add_dialogue("accept farm fear", ("cold", "very dom"), ("好吧好吧！让我们结束这一切吧..."))
    add_dialogue("refuse farm", ("cold", "rebel", "superficial", "bimbo", "stubborn"), ("他妈的不！"))
    add_dialogue("gizel take girl to farm", ("cold", "very dom"), ("哈！你放心，我很快就会打倒她。"))

    add_dialogue("girl introduction", ("cold", "very introvert"), ("...",  "我是....[girl.fullname]。"))
    add_dialogue("slave thanks", ("cold", "very introvert"), ("没什么特别的。"))
    add_dialogue("slave effusive thanks", ("cold", "very introvert"), ("这很酷。我想你没问题，[MC.name]。"))
    add_dialogue("slave positive reaction", ("cold", "very materialist"), ("好吧....你为什么要拍我的马屁？", "做什么的？", "解释一下你自己，[MC.name]。"))
    add_dialogue("slave negative reaction", ("cold", "very materialist"), ("这有什么原因吗？", "什么？", "做什么的？"))
    add_dialogue("slave whining", ("cold", "very materialist"), ("很公平..."))
    add_dialogue("slave strongly refuse", ("cold", "schemer", "creep", "yandere"), ("*叹气*让我们结束这一切......"))
    add_dialogue("slave bullied", ("cold", "very introvert"), ("是啊是啊，我明白了..."))
    add_dialogue("slave apology", ("cold", "very dom"), ("当你是对的时候，你就是对的。"))
    add_dialogue("slave hit", ("cold", "very dom"), ("啊!他妈的！"))
    add_dialogue("slave positive fixation accept", ("cold", "very introvert"), ("当然可以，[MC.name]。", "如果你这么说的话，[MC.name]。", "好的。"))
    add_dialogue("slave negative fixation accept", ("cold", "very materialist"), ("你想触动我的按钮吗？", "你对此很着迷，不是吗？", "呃，好吧...."))
    add_dialogue("slave negative fixation refuse", ("cold", "very materialist"), ("如果我说不怎么办？", "我不想。", "我要把那个传下去。"))

    add_dialogue("slave first visit", ("cold", "very introvert"), ["g: ...", "她闭住了舌头，冰冷地瞪着你。"], multiple=True)
    add_dialogue("MC kind promise", ("cold", "very introvert", "very materialist"), ["她疑惑地看了你一眼并点点头。", "g: 随你怎么说。"], multiple=True, love=1, fear=-3)
    add_dialogue("MC fair promise", ("cold", "very introvert", "very materialist"), ["她考虑了一会儿你的话并点点头。", "g: 随你怎么说。"], multiple=True, fear=-1)
    add_dialogue("MC no promise", ("cold", "very introvert", "very materialist"), ["她考虑了一会儿你的话并点点头。", "g: 随——随你怎么说。"], multiple=True, fear=1)
    add_dialogue("MC harsh promise", ("cold", "very introvert"), ("她点点头，却出奇地平静，就好像她以前经历过这一切一样。"), love=-4, fear=3)
    add_dialogue("MC break promise", ("cold", "very introvert", "very idealist"), ("我也这么认为...你的话很空洞。"), love=-5, fear=1)
    add_dialogue("MC fight intro", ("cold", "very introvert"), ["g: 不，我不想和你玩这个游戏。", "她转身背对着你并试图离开。"], multiple=True, sound=s_scream_loud)
    add_dialogue("slave fear intro", ("cold", "very introvert"), ("她茫然地看着你。你的问题似乎一只耳朵进，另一只耳朵出。"))
    add_dialogue("slave fear reassure success", ("cold", "very introvert"), ("她眨眨眼，点点头。"), love=1, fear=-2)
    add_dialogue("slave fear reassure failure", ("cold", "very introvert"), ("她直视你的眼睛，但保持沉默。你会失去耐心并暂时放弃。"), love=-1, fear=-1)
    add_dialogue("slave fear discipline", ("cold", "very introvert"), ("你打她的脸。她发出一声小叫，但似乎决心不说话。您决定暂时不让事态进一步升级。"), fear=1)

    add_dialogue("slave naked request permanent", ("cold", "very introvert", "very materialist"), ("*叹气*我想这就是我现在的生活......"), love=-1, fear=1, sound=s_sigh)
    add_dialogue("slave naked request accept", ("cold", "very materialist"), ["她忍不住露出顽皮的笑容。", "g: 男人很容易取悦。"], multiple=True, love=2, sound=s_ahaa)
    add_dialogue("slave naked request resist", ("cold", "very introvert", "very materialist"), ("*抱怨*你真是个变态....我不玩你的游戏。"), love=-1, fear=-2)
    add_dialogue("slave toggle naked on", ("cold", "very introvert"), ("好的。"))
    add_dialogue("slave toggle naked off", ("cold", "very introvert"), ("这对我来说没问题。"))
    add_dialogue("slave train beg", ("cold", "very materialist"), ("呃，真是太累了....我真的没有心情。"))
    add_dialogue("slave discipline beg", ("cold", "very introvert", "very materialist"), ("喂、喂....没这个必要吧！"))
    add_dialogue("slave beg proceed", ("cold", "very materialist"), ("啊啊啊，操！"), love=-1, fear=1)
    add_dialogue("slave beg warning", ("cold", "very introvert", "generic"), ("明白了，主人...."), fear=1, sound=s_sigh)
    add_dialogue("slave beg give up", ("cold", "very introvert", "generic"), ["g: 对——真的吗？", "mc: 当然。你现在可以走了，不用担心。", "g: 哦，谢谢你，谢谢你！"], multiple=True, love=1, fear=-1, sound=s_surprise)
    add_dialogue("slave send to master bedroom love +", ("cold", "very introvert"), ["她看起来有点慌张。", "g: 当然，老板。"], multiple=True)
    add_dialogue("slave send to master bedroom love", ("cold", "very introvert", "very materialist"), ["她抱起双臂，点点头。", "g:  太酷了。你的床比我的好。"], multiple=True)
    add_dialogue("slave send to master bedroom love -", ("cold", "very introvert"), ["她翻白眼。", "g: *叹气*我猜这是工作的一部分。"], multiple=True)
    add_dialogue("slave send to master bedroom fear +", ("cold", "very introvert"), ["她看上去苍白如鬼。", "g: 我、如果主人吩咐的话...."], multiple=True)
    add_dialogue("slave send to master bedroom fear", ("cold", "very introvert", "very materialist"), ["她长长地叹了口气。", "g: 呃....很好...."], multiple=True)
    add_dialogue("slave send to master bedroom fear -", ("cold", "very introvert", "very materialist"), ["她长长地叹了口气。", "g: 呃...你找不到其他人吗？"], multiple=True)
    add_dialogue("slave leave master bedroom love +", ("cold", "very introvert", "very materialist"), ["g: 明白了，主人。", "g: 别当陌生人。随时欢迎您来到我的卧室。"], multiple=True)
    add_dialogue("slave leave master bedroom love", ("cold", "very introvert"), ("如您所愿，主人。"))
    add_dialogue("slave leave master bedroom love -", ("cold", "very introvert"), ("最后..."))
    add_dialogue("slave leave master bedroom fear +", ("cold", "very introvert"), ("谢谢主人。"))
    add_dialogue("slave leave master bedroom fear", ("cold", "rebel", "very introvert"), ("是啊是啊，无论怎样..."))
    add_dialogue("slave leave master bedroom fear -", ("cold", "very introvert"), ("再见..."))

    add_dialogue("slave chat slave_life -2", ("cold", "very introvert"), ["在给出答案之前，她会长时间地注视着你。", "g: 别打扰我....我从来没有要求过这个。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life -1", ("cold", "very introvert", "very materialist"), ["她交叉双臂，避免目光接触。", "g: 你不在乎....别再假装你在乎了。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0", ("cold", "very introvert", "very materialist"), ("*叹气*这有关系吗？"), unlock="DS")
    add_dialogue("slave chat slave_life 0.5", ("cold", "very introvert"), ("没关系...还有什么吗？"), unlock="DS")
    add_dialogue("slave chat slave_life 1", ("cold", "very introvert"), ["她耸耸肩。", "g: 呃...我不介意。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 2", ("cold", "very introvert"), ["当你们目光相遇时，她短暂地微笑了。", "g: 有什么不喜欢的？"], multiple=True, unlock="DS")
    add_dialogue("slave chat brothel -2", ("cold", "very dom"), ["她用轻蔑的眼神看着你。", "g: 滚开...."], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel -1", ("cold", "very introvert"), ("*叹气*没关系...我只是一天一天地服用..."), unlock="LM")
    add_dialogue("slave chat brothel 0", ("cold", "very introvert"), ("对我来说没问题..."), unlock="LM")
    add_dialogue("slave chat brothel 0.5", ("cold", "very introvert"), ("我-我不能正确地说...这对我来说似乎不真实。"), unlock="LM")
    add_dialogue("slave chat brothel virgin", ("cold", "very introvert"), ("我-我不能正确地说...这对我来说似乎不真实。"), unlock="LM")
    add_dialogue("slave chat brothel 1", ("cold", "very introvert"), ("好，当然..."), unlock="LM")
    add_dialogue("slave chat brothel 2", ("cold", "very materialist"), ["她向你竖起两个大拇指。", "g: 性很有趣，所以这里就是你该去的地方。"], multiple=True, unlock="LM")
    add_dialogue("slave chat customers -2", ("cold", "very dom", "very materialist"), ["她翻白眼。", "g: 呃....操他们！"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers -1", ("cold", "very introvert"), ("噗....我最多只能忍一会而已。"), unlock="MI")
    add_dialogue("slave chat customers 0", ("cold", "very introvert"), ("不确定我是否有很多选择......"), unlock="MI")
    add_dialogue("slave chat customers 0.5", ("cold", "very introvert"), ("呃，他们没事。"), unlock="MI")
    add_dialogue("slave chat customers 1", ("cold", "very introvert"), ("当然，我不介意他们..."), unlock="MI")
    add_dialogue("slave chat customers 2", ("cold", "very materialist"), ("我想你可以说我们是朋友...只要他们支付费用。"), unlock="MI")
    add_dialogue("slave chat other_girls -2", ("cold", "very introvert"), ("我真的不想陷入其中....我不关心他们，他们也不应该关心我。"), unlock="EI")
    add_dialogue("slave chat other_girls -1", ("cold", "very introvert"), ("他们是什么....我并没有特别关心他们，他们也不应该关心我。"), unlock="EI")
    add_dialogue("slave chat other_girls 0", ("cold", "very introvert"), ("他们是什么....我并没有特别关心他们，他们也不应该关心我。"), unlock="EI")
    add_dialogue("slave chat other_girls 0.5", ("cold", "very introvert"), ("其中一些还不错。"), unlock="EI")
    add_dialogue("slave chat other_girls 1", ("cold", "very introvert"), ("你们这里有一群很好的人...好好照顾他们，好吗？"), unlock="EI")
    add_dialogue("slave chat other_girls 2", ("cold", "very introvert"), ("爱他们。好好照顾他们，好吗？"), unlock="EI")
    add_dialogue("MC praise friend", ("cold", "very introvert", "very materialist"), ("*笑*你为什么要提起这个？三人行钓鱼？"), sound=s_laugh)
    add_dialogue("MC demean rival", ("cold", "very introvert"), ("什、谁？我不关心她..."), sound=s_evil_laugh)
    add_dialogue("slave chat well_being -3", ("cold", "very introvert"), ("*抽泣*请-请离开..."), unlock="MI")
    add_dialogue("slave chat well_being -2", ("cold", "very introvert"), ("*叹气*让我一个人呆着..."), unlock="MI")
    add_dialogue("slave chat well_being -1", ("cold", "very introvert"), ("嗯...我经历过更糟糕的事情。"), unlock="MI")
    add_dialogue("slave chat well_being 0", ("cold", "very introvert"), ("你想听我说什么？"), unlock="MI")
    add_dialogue("slave chat well_being 1", ("cold", "very introvert"), ("你为什么要问？"), unlock="MI")
    add_dialogue("slave chat well_being 2", ("cold", "very introvert"), ("呃，我很好。"), unlock="MI")
    add_dialogue("slave chat well_being 3", ("cold", "very introvert"), ("为什么不会呢？"), unlock="MI")
    add_dialogue("slave chat well_being attacked", ("cold", "very introvert", "very dom"), ("被打得遍体鳞伤，但我会处理的...."))
    add_dialogue("slave chat well_being sick", ("cold", "very introvert", "very dom"), ("是的，无论如何....只是恢复健康，仅此而已。"))
    add_dialogue("slave chat well_being exhausted", ("cold", "very introvert", "very dom"), ("是的，无论如何....只是累了，仅此而已。"))
    add_dialogue("slave chat well_being MC apology", ("cold", "very introvert"), ("明白了。"))
    add_dialogue("slave chat feelings love -1", ("cold", "very dom", "very materialist"), ("很抱歉打扰你。但没有人喜欢他们的老板。"), unlock="DS")
    add_dialogue("slave chat feelings love 0", ("cold", "very dom"), ("不是为了伤害你的感情，但我不关心你或其他任何人。"), unlock="DS")
    add_dialogue("slave chat feelings love 1", ("cold", "very introvert"), ("我不介意你..."), unlock="DS")
    add_dialogue("slave chat feelings love 2", ("cold", "very introvert", "very dom"), ("你没事吧。"), unlock="DS")
    add_dialogue("slave chat feelings fear -1", ("cold", "very introvert", "very dom"), ("考虑到这里的权力动态，你不会得到诚实的答案。那么为什么要问这个问题呢？"), unlock="DS")
    add_dialogue("slave chat feelings fear 0", ("cold", "very introvert", "very materialist"), ("你为什么要问？缺乏信心？"), unlock="DS")
    add_dialogue("slave chat feelings fear 1", ("cold", "very introvert", "very materialist"), ("有时你会失控。"), unlock="DS")
    add_dialogue("slave chat feelings fear 2", ("cold", "very introvert", "very sub"), ("嗯...你希望我对你有什么感觉？"), unlock="DS")
    add_dialogue("slave chat feelings very disobedient", ("cold", "very introvert", "very materialist"), ("你就不能去打扰别人吗？"), unlock="DS")
    add_dialogue("slave chat feelings disobedient", ("cold", "very introvert", "very materialist"), ("我是你的奴隶。我们到这里就完成了吗？"), unlock="DS")
    add_dialogue("slave chat feelings a little obedient", ("cold", "very introvert", "very materialist"), ("从什么时候开始我的感受变得重要了？"), unlock="DS")
    add_dialogue("slave chat feelings obedient", ("cold", "very introvert", "very materialist"), ("我知道我能对你有什么期望。"), unlock="DS")
    add_dialogue("slave chat feelings very obedient", ("cold", "very introvert"), ("我已经非常了解你了。"), unlock="DS")
    add_dialogue("slave chat tastes likes", ("cold", "very introvert", "stubborn", "princess"), ("最好的东西]？这是[best]。"), unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("cold", "rebel", "superficial", "bimbo", "prude", "schemer", "stubborn", "repressed"), ("你知道，[worst]是一件可怕的[thing_cn]。"), unlock="LM")
    add_dialogue("slave chat tastes loves +", ("cold", "very introvert"), ("你可以随时叫醒我[thing_cn]。"), unlock="LM")
    add_dialogue("slave chat tastes loves -", ("cold", "very introvert"), ("[thing_cn]有什么意义？我不明白。"), unlock="LM")
    add_dialogue("slave chat tastes no loves", ("cold", "very dom"), ("把礼物留给自己吧。"), unlock="LM")
    add_dialogue("slave chat tastes hates", ("cold", "very dom"), ("永远不要递给我[thing_cn]。我会毁掉它。"), unlock="LM")
    add_dialogue("slave chat tastes no hates", ("cold", "very introvert"), ("重要的是想法。"), unlock="LM")
    add_dialogue("slave chat tastes positive act", ("cold", "very introvert", "very materialist"), ("呃...无法停止思考[act_desc]..."), unlock="LM")
    add_dialogue("slave chat tastes negative act", ("cold", "very introvert"), ("哦，[act_desc]...你真的喜欢这样吗？"), unlock="LM")
    add_dialogue("slave chat tastes no negative act", ("cold", "very dom", "very materialist"), ("他妈的，我现在全身湿透了....准备好做任何事情，真的...."), unlock="LM")

    add_dialogue("slave chat origins 1", ("cold", "nerd", "masochist", "creep", "schemer", "yandere"), ("[girl.origin]。", "我在[girl.origin]长大。", "我来自[girl.origin]。"), unlock="EI")
    add_dialogue("origin the Goliath desolations", ("cold"), ("歌利亚荒原真是他妈的荒凉！你对这样的名字有什么期望？我应该知道，因为我和我的[girl.story_guardian]一起在那里度过了毫无意义的人生最初几年。很高兴来到泽恩，那里确实发生了一些事情......"))
    add_dialogue("slave train accepted", ("cold", "very introvert"), ("..."))
    add_dialogue("slave train resisted", ("cold", "very introvert"), ("啊..."))
    add_dialogue("slave train refused", ("cold", "very introvert"), ("不！我为什么要？"))
    add_dialogue("slave lecture love", ("cold", "very introvert"), ("是的主人？"))
    add_dialogue("slave lecture neutral", ("cold", "very introvert"), ("它是什么？"))
    add_dialogue("slave lecture fear", ("cold", "very introvert"), ("Master?"))
    add_dialogue("slave lecture refuses", ("cold", "very introvert"), ("抱歉，我半路跑题了...."))
    add_dialogue("slave lecture very reluctant", ("cold", "very introvert"), ("我们完了吗？"))
    add_dialogue("slave lecture reluctant", ("cold", "very introvert"), ("抱歉，我半路跑题了...."))
    add_dialogue("slave lecture a little reluctant", ("cold", "very introvert"), ("*叹气*是这样吗？"), sound=s_sigh)
    add_dialogue("slave lecture indifferent", ("cold", "very introvert"), ("就是这样？"))
    add_dialogue("slave lecture a little interested", ("cold", "very introvert"), ("好吧..."), sound=s_surprise)
    add_dialogue("slave lecture interested", ("cold", "very introvert"), ("那还不错...."), sound=s_mmh)
    add_dialogue("slave lecture very interested", ("cold", "very introvert"), ("明白了，主人。"), sound=s_mmh)
    add_dialogue("slave lecture fascinated", ("cold", "very introvert"), ("明白了....谢谢主人。"), sound=s_aah)
    add_dialogue("slave train obedience", ("cold", "very introvert"), ("唔..."))
    add_dialogue("slave train constitution", ("cold", "very introvert"), ("*呼气* *呼气*"))
    add_dialogue("slave train refuses", ("cold", "very introvert"), ("她转身试图走开。"), sound=s_screams)
    add_dialogue("slave train very reluctant", ("cold", "very introvert"), ["她因不舒服而呻吟。","g: 嗯....继续吧！"], multiple=True, sound=s_scream)
    add_dialogue("slave train reluctant", ("cold", "very introvert"), ["她看上去很不舒服。","g: 我们结束了吗？"], multiple=True, sound=s_scream)
    add_dialogue("slave train a little reluctant", ("cold", "very introvert"), ("啊....操我...."), sound=s_surprise)
    add_dialogue("slave train indifferent", ("cold", "very introvert"), ("好的..."), sound=s_ahaa)
    add_dialogue("slave train a little interested", ("cold", "very introvert"), ("是的主人..."), sound=s_ahaa)
    add_dialogue("slave train interested", ("cold", "very introvert"), ("当然...."), sound=s_mmh)
    add_dialogue("slave train very interested", ("cold", "very introvert"), ("*脸红*当然可以..."), sound=s_aah)
    add_dialogue("slave train fascinated", ("cold", "very introvert", "very materialist"), ("哦！这是我的荣幸，主人。"), sound=s_orgasm_fast)
    add_dialogue("slave train naked failure", ("cold", "very introvert"), ("*抱怨*你毛骨悚然...你满意吗？"), sound=s_surprise)
    add_dialogue("slave train naked success", ("cold", "very introvert"), ("A-你满意吗？"), sound=s_aah)
    add_dialogue("slave train service failure", ("cold", "very materialist"), ("*叹气*现在几点了？"))
    add_dialogue("slave train service success", ("cold", "very introvert"), ("等等...我可以再玩一会儿吗？"))
    add_dialogue("slave train sex failure", ("cold", "very introvert"), ("你做完了吗？"))
    add_dialogue("slave train sex success", ("cold", "very introvert"), ("啊，操我....那太好了...."))
    add_dialogue("slave train anal failure", ("cold", "very introvert"), ("我们在这里浪费时间..."))
    add_dialogue("slave train anal success", ("cold", "very dom", "very materialist"), ("啊！！真他妈的好啊！"))
    add_dialogue("slave train fetish failure", ("cold", "very introvert"), ("什、你在做什么？！"))
    add_dialogue("slave train fetish success", ("cold", "very introvert"), ("噢，主人！我想同时哭泣和射精。"))
    add_dialogue("slave train bisexual failure", ("cold", "very dom", "very materialist"), ("滚蛋吧，希露。没有人喜欢你。"))
    add_dialogue("slave train bisexual success", ("cold", "very dom", "very materialist"), ("妈的，她好样的！"), sound=s_mmh)
    add_dialogue("slave train group failure", ("cold", "very introvert", "very dom"), ("停止目光接触！你们两个去开个房间吧！"))
    add_dialogue("slave train group success", ("cold", "very introvert", "very materialist"), ("摆脱其他女孩。大家都可以利用我！"))
    add_dialogue("slave magic obedience success", ("cold", "very materialist"), ("随、随你怎么说...."), sound=s_ahaa)
    add_dialogue("slave magic libido success", ("cold", "very introvert"), ("啊！ 别、别碰我..."), sound=s_mmh)
    add_dialogue("slave magic sensitivity success", ("cold", "very introvert"), ("呃....感觉头晕...."), sound=s_mmh)
    add_dialogue("slave magic naked success", ("cold", "very materialist"), ("*笑*嘿，好东西...."), sound=s_ahaa)
    add_dialogue("slave magic service success", ("cold", "very introvert"), ("好饿....为了你...."), sound=s_mmh)
    add_dialogue("slave magic sex success", ("cold", "very dom"), ("他妈的我..."), sound=s_aah)
    add_dialogue("slave magic anal success", ("cold", "very dom"), ("该死....即使在那里...."), sound=s_ahaa)
    add_dialogue("slave magic fetish success", ("cold", "masochist"), ("嗯....痛苦就是幸福...."), sound=s_aah)
    add_dialogue("slave magic bisexual success", ("cold", "creep"), ("一个女人....有阴茎？！"), sound=s_mmh)
    add_dialogue("slave magic group success", ("cold", "schemer", "creep", "yandere"), ("*笑*更多！召唤更多！"), sound=s_ahaa)
    add_dialogue("slave magic failure", ("cold", "very materialist"), ["她茫然地看着你。", "g: 噗....你在这方面很糟糕....", "g: 当你进行一些练习时请告诉我。"], multiple=True, sound=s_scream, unlock="DS")

    add_dialogue("slave reward sex accepted", ("cold", "very introvert"), ("我没有任何抱怨！"), love=1, sound=s_ahaa, unlock="LM")
    add_dialogue("slave reward sex resisted", ("cold", "very introvert"), ("不，谢谢..."), love=-1, sound=s_surprise, unlock="LM")
    add_dialogue("slave reward sex refused", ("cold", "very dom"), ("滚蛋吧..."), sound=s_scream)
    add_dialogue("slave reward praise", ("cold", "very introvert"), ("我不是在寻求你的认可。"), love=-1, unlock="MI")
    add_dialogue("slave reward gold", ("cold", "very materialist"), ("哦，真是一个惊喜！"), love=2, unlock="MI")
    add_dialogue("slave reward pet", ("cold", "very introvert"), ["当你拍拍她的头时，她闭上眼睛，用鼻子蹭着你。", "g: 不说话了....这很好...."], multiple=True, love=1, unlock="DS")
    add_dialogue("slave reward day off", ("cold", "very introvert"), ("啊，终于...."), love=1, unlock="DS")
    add_dialogue("slave reward day off KO", ("cold", "very introvert", "very materialist"), ("不用谢...今天已经是我的休息日了。"))
    add_dialogue("slave punish scold deserved", ("cold", "very introvert"), ("好吧，也许你对我的期望太高了！"), fear=-2, unlock="MI")
    add_dialogue("slave punish scold undeserved", ("cold", "very introvert"), ("你现在吵完了吗？"), fear=-1, unlock="MI")
    add_dialogue("slave punish upkeep", ("cold", "very dom", "very materialist"), ("不酷..."), fear=1, unlock="MI")
    add_dialogue("slave punish upkeep KO", ("cold", "very introvert"), ("那里没什么可带走的。"))
    add_dialogue("slave punish beat", ("cold", "very dom"), ("恩...这就是你的全部吗？"), sound=s_screams, unlock="DS")
    add_dialogue("slave punish farm", ("cold", "very introvert", "very dom"), ("啊，我可以利用一个假期。"), unlock="DS")
    add_dialogue("slave punish naked", ("cold", "very introvert"), ("你这个变态..."), fear=1, unlock="LM")
    add_dialogue("slave punish naked KO", ("cold", "very introvert"), ("好好看看，蠕动...."))
    add_dialogue("slave punish rape", ("cold", "very introvert"), ("不、不是那个，拜托...."), fear=2, unlock="LM")
    add_dialogue("slave raped", ("cold", "very introvert"), ("呃....*抽泣*"), sound=s_screams)
    add_dialogue("slave rape positive fixation", ("cold", "very introvert"), ("那、那还不错。"), love=1, fear=-1, sound=s_aah)
    add_dialogue("slave rape negative fixation", ("cold", "very introvert"), ("*呜咽*主人！不！"), love=-2, fear=3, sound=s_scream_loud)

    add_dialogue("rest", ("cold", "very introvert"), ("我会在我的房间里。"))
    add_dialogue("accept job", ("cold", "very introvert"), ("成为一名{b}[girl.job_cn]{/b}？听起来很容易。","当然，我会成为你的{b}[girl.job_cn]{/b}。","好的，{b}[girl.job_cn]{/b} 是的。"))
    add_dialogue("work_whore", ("cold", "very introvert"), ("我可以将{b}[girl.job_cn]{/b}和嫖娼结合起来，没问题。","当然可以。 {b}[girl.job_cn]{/b} 和嫖娼。","我是个放荡的{b}[girl.job_cn]{/b}。确认的。"))
    add_dialogue("exhausted", ("cold", "very introvert"), ("不是现在，主人。我累极了。当我准备好后，我会以{b}[girl.job_cn]{/b}的身份回来。"))
    add_dialogue("rank up", ("cold", "very introvert"), ("我想我现在是一个等级[newrank]的奴隶。别费心为我举办任何派对。"))
    add_dialogue("refuse whoring", ("cold", "very introvert", "very dom"), ("我不这么认为。"))
    add_dialogue("refuse sex act", ("cold", "very introvert"), ("不！我为什么要？"))

    add_dialogue("bought", ("cold", "very introvert"), ("...{w=1} 叫我[girl.name]。"))
    add_dialogue("freed", ("cold", "very introvert"), ("...{w=1} 我明白了...那么，那么..."))
    add_dialogue("sold", ("cold", "very introvert"), ("...{w=1} 我明白了...那么，那么..."))
    add_dialogue("sold love", ("cold", "very introvert"), ["*叹气*我明白了...所以这就是结局？", "主人....我会想念你的。"], sound=s_surprise)
    add_dialogue("leave for quest", ("cold", "very introvert"), ("我走了！"))
    add_dialogue("leave for class", ("cold", "very introvert"), ("我去上课了！"))
    add_dialogue("advertise", ("cold", "very introvert"), ("访问[brothel.name]。这是一家青楼。你知道会发生什么。", "生活让你沮丧吗？参观青楼。", "参观[brothel.name]，为什么不呢？", "阅读标志。", "访问[brothel.name]。或者不这样做。我不在乎。"))

    add_dialogue("beach intro", ("cold", "very introvert"), ["[girl.fullname] 正在享受休息日，在棕榈树的树荫下独自放松。"])
    add_dialogue("beach meet MC", ("cold", "very introvert"), ["她见到你似乎很惊讶。", "g: [MC.name]主人...你为什么在这里？"], multiple=True)
    add_dialogue("beach oiling", ("cold", "very introvert"), ("如果我的泳衣妨碍了请告诉我..."), sound=s_ahaa)
    add_dialogue("beach accept oiling", ("cold", "very introvert"), ("你在等什么？"))
    add_dialogue("beach refuse oiling", ("cold", "very introvert"), ("够了..."))
    add_dialogue("beach accept public sex", ("cold", "very introvert"), ["她为你张开她的小穴。", "g: 来吧....已经放进去了！"], multiple=True)
    add_dialogue("beach refuse public sex", ("cold", "very introvert"), ["她发出一声恼怒的咕哝声。", "g: 不在这里，[MC.name]！"], multiple=True)
    add_dialogue("beach accept sex", ("cold", "very introvert"), ("哦-好吧...你有心仪的地方吗？"))
    add_dialogue("beach refuse sex", ("cold", "very introvert"), ("我为什么要？我今天不是休息吗？"))
    add_dialogue("beach whoring request", ("cold", "very introvert"), ("你还有点神经...."))
    add_dialogue("beach whoring accept", ("cold", "very introvert"), ("啊，不管怎样....我们就这么做吧。"))
    add_dialogue("beach whoring refuse", ("cold", "very introvert"), ("这个不值得讨论。"))

## START NERD DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("nerd", "loyal", "helper"), ("你好...我，呃，希望你今天过得愉快。 [girl.fullname] 是名字。"), love=2)
    add_dialogue("free_greetings_casual", ("nerd", "repressed", "masochist"), ("H-你好。我是[girl.fullname]。","嗯？哦，我、我可以帮你吗？我是[girl.fullname]。"), love=3)
    add_dialogue("free_greetings_rude", ("nerd", "stubborn", "loyal", "schemer"), ("哦，呃...我不认识你。我是[girl.fullname]。","我是[girl.fullname]。如果你没有别的话要说，请让我一个人静一静。"), love=-2)

    add_dialogue("free_small_talk", ("nerd", "prude"), ("你说得对。我最近读到了一些有趣的事情......","这让我想起一个故事。","哦。你-你是对的，当然。和你共度时光是有好处的——它让我一整天都充满阳光。", "一定。有一些令人放松的东西。"), love=2, max_cap=25)
    add_dialogue("free_gossip", ("nerd", "sweet", "masochist"), ("嗯，你知道的，我真的不在乎八卦。"), love=-1, max_cap=25)
    add_dialogue("free_chat_life", ("nerd", "class president"), ("嗯...好问题！谨慎是一个很好的品质。宇宙充满了危险....","你认为有人可以从外太空监视我们吗？这....可能有点尴尬吧。", "不幸的是，与故事相比，生活常常黯然失色。但这正是思考和讨论此类问题如此有趣的原因。"), love=2, max_cap=25)
    add_dialogue("free_chat_love", ("nerd"), ("嗯....现实生活很少像故事那样。我发现爱情往往注定是得不到回报的。", "你不觉得大多数人只是在恋爱吗？", "我一直在想这个。有时我就像爱上了恋爱的想法。"), love=1, max_cap=25)
    add_dialogue("free_chat_origins", ("nerd", "pervert", "loyal", "superficial"), ("这是一个又长又无聊的故事。我来自[girl.origin]。", "[girl.origin]。您真的不想听到更多有关此的信息。"), max_cap=40)
    add_dialogue("free_chat_hobbies", ("nerd"), ("关于[hobby]的故事是我最喜欢的。","我现在正在读这本书，女主角在一所著名的[hobby]学校上学。","我喜欢[hobby]。嗯，坦白说，我最喜欢阅读有关[hobby]的内容。"), love=1, max_cap=40)
    add_dialogue("free_chat_likes", ("nerd", "class president"), ("我喜欢更多地了解[thing_cn]。特别是[best]。", "我对每一种[thing_cn]都很着迷，但我发现[best]特别有趣。"), love=1, max_cap=40)
    add_dialogue("free_chat_dislikes", ("nerd", "class president", "repressed"), ("我对[thing_cn]了解得越多，我就越意识到[worst]是多么可怕。", "每当提到[worst]我就会生气。任何其他[thing_cn]都将是首选。"), love=2, max_cap=40)

    add_dialogue("free_joke_harmless", ("nerd", "creep"), ("啊哈哈哈！我喜欢那个笑话的节奏。", "极好的！你的表现非常出色。", "哈哈哈！结构非常好。"), love=3, max_cap=50)
    add_dialogue("free_joke_adult", ("nerd", "meek"), ("抱歉，这让我感到不舒服。我们可以谈点别的吗？"), love=-1, max_cap=50)
    add_dialogue("free_joke_dark", ("nerd", "very introvert", "stubborn", "class president", "holy"), ("哈哈哈哈！我喜欢这种笑话。"), love=3, max_cap=50)
    add_dialogue("free_joke_mean", ("nerd", "class president"), ("多么残酷啊。我认为这一点都不好笑。"), love=-1, max_cap=50)

    add_dialogue("free_touch_hand", ("nerd", "repressed", "masochist", "class president"), ("哦！呵呵。握着你的手的感觉是多么自然。","啊啊啊！真的吗，这里？好吧，就一会儿。","哈哈。这感觉真让人安慰。"), love=4, max_cap=90)
    add_dialogue("free_touch_kiss", ("nerd"), ("*亲吻*和你在一起的时间越长，分开就越难。", "啊啊....好温馨的一幕啊。", "呵呵。看看我们，一对溺爱的情侣。"), love=5, max_cap=90)
    add_dialogue("free_touch_ass", ("nerd", "cold", "masochist", "pervert", "class president"), ("Ah! Mmh... *脸红*"), max_cap=90)
    add_dialogue("free_touch_breasts", ("nerd", "cold", "loyal", "class president"), ("What are you doing? Stop."), love=-1, max_cap=90)
    add_dialogue("free_touch_pussy", ("nerd", "class president", "meek"), ("我很高兴你对我如此着迷，但要有耐心，我们不应该在这里采取行动。", "我知道你的感受，但是在这里呢？任何人都可以看到我们。", "哇？！别、别突然碰我！"), max_cap=90)

    add_dialogue("free_play refuses", ("nerd", "yandere", "loyal", "class president"), ("啊啊。 *疯狂*你为什么要问我这个？！"), love=-1)
    add_dialogue("free_play very reluctant", ("nerd", "loyal"), ("哇啊啊。拜托，我求求你，不是这个...."), love=1)
    add_dialogue("free_play reluctant", ("nerd"), ("*脸红*这-这是性骚扰，你知道吗？"), love=2)
    add_dialogue("free_play a little reluctant", ("nerd", "meek", "helper"), ("你-你怎么了？我不确定我是否已经准备好......请温柔一点。"), love=2)
    add_dialogue("free_play indifferent", ("nerd"), ("我，呃....我不怕说我想象我们一起做这件事。 *脸红*"), love=3)
    add_dialogue("free_play a little interested", ("nerd", "pet"), ("嗯....我真的{i}真的{/i}有这样的心情。"), love=4)
    add_dialogue("free_play interested", ("nerd", "pet"), ("是的！我一直在幻想，但和你一起做感觉好多了。"), love=4)
    add_dialogue("free_play very interested", ("nerd", "pet", "class president", "generic"), ("*脸红*好吧。我能感觉到自己已经湿透了。"), love=5)
    add_dialogue("free_play fascinated", ("nerd", "pet", "class president"), ("*脸红*我的心不停地跳动。我喜欢它。"), love=5)
    add_dialogue("MC take virginity", ("nerd"), ("这——这又是一个被划掉的第一个。你让我看到了很多新东西。"), love=5)
    add_dialogue("free_play interested after", ("nerd", "pet"), ("那太令人着迷了！我们应该再试一次。", "让我们更频繁地这样做。", "你太令人惊奇了！ *脸红*", "太棒了！ *脸红*"))
    add_dialogue("free_play not interested after", ("nerd"), ("我一点也不喜欢这样。", "*叹气*令人失望。", "嗯....与故事相比，现实再次黯然失色。", "我从中一无所获。"))

    add_dialogue("free_flirt_beauty", ("nerd", "pet", "repressed"), ("哇....你这样看着我，我的心砰砰直跳。"), love=2, max_cap=75)
    add_dialogue("free_flirt_body", ("nerd", "sweet", "repressed"), ("Shut up! Who wants to hear lewd comments like that! *生气*"), max_cap=75)
    add_dialogue("free_flirt_mind", ("nerd", "class president"), ("谢谢。我想我是和大多数女孩比较的。", "*笑*你是对的。", "*微笑*谢谢！"), love=3, max_cap=75)
    add_dialogue("free_flirt_spirit", ("nerd", "helper", "prude"), ("嗯....我的一些朋友一直说，自从认识了你之后，我看起来更加无忧无虑了。我不知道对此有何看法。"), max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("nerd"), ["她咯咯地笑着，伸出舌头。", "g: *咯咯*我可以写一本关于我所做的所有事情的书。如果我这样做的话，它可能会成为泽恩的畅销书。"], multiple=True, love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("nerd"), ["她笑着对你眨眼。", "g: 哦，我还不够。我喜欢阅读它，我喜欢思考它，我喜欢这样做。"], multiple=True, love=2)
    add_dialogue("free_flirt_sex_experience average", ("nerd"), ["她脸红.", "g: 嗯，我喜欢更多地了解这类事情....多年来我有一些不同的合作伙伴可以一起学习。"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("nerd"), ("每个人都是不同的，我不经常将自己与其他人进行比较......但我有一些经验。从这个意义上说，我可能有点低于平均水平。"))
    add_dialogue("free_flirt_sex_experience very inexperienced", ("nerd"), ("尝试过一次，一点也不喜欢....它们在故事中听起来更令人兴奋。"), love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("nerd"), ["g: 我，呃，有时确实会想象自己处于我读过的小说中一些更....多情的场景中。", "g: 但是不，我自己从来没有这样做过。"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("nerd"), ["g: *咯咯*这很可爱，你知道吗？", "g: 你就像直接从童话故事里走出来一样。像你这样的王子等待他完美的公主并没有什么错。"], multiple=True, love=3)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("nerd"), ["g: 很容易看出你混淆了事实和虚构。", "g: 没必要为此感到难过。跟随你的性冲动是很自然的事情。"], multiple=True, love=2)

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("nerd"), ["g: *咯咯*这很可爱，你知道吗？", "g: 你就像直接从童话故事里走出来一样。像你这样的王子等待他完美的公主并没有什么错。"], multiple=True, love=4)
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("nerd"), ["g: 很容易看出你混淆了事实和虚构。", "g: 没必要为此感到难过。跟随你的性冲动是很自然的事情。"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("nerd"), ("*叹气*所以你就像其他人一样......令人失望......"), love=-1)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("nerd"), ["g: *笑*你听起来对自己很有信心。所以你是专家，是吗？", "g: 也许有一天你可以给我上一些课。"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("nerd"), ["g: 很容易看出你混淆了事实和虚构。", "g: *叹气*我想说的是，谦虚是一种美德。"], multiple=True)
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("nerd"), ["g: *叹气*别提醒我。", "g: 一想到你在那里和什么样的女孩交往就让我感到恶心。有一些标准。"], multiple=True, love=-1)

    add_dialogue("free_flirt_sex_act refuses", ("nerd", "stubborn"), ("不，我认为这不值得我花时间。"))
    add_dialogue("free_flirt_sex_act very reluctant", ("nerd", "helper", "meek"), ("呃，我们聊点别的可以吗？我不喜欢它。"))
    add_dialogue("free_flirt_sex_act reluctant", ("nerd", "class president", "meek"), ("嗯，这不是一个简单的问题。我不能肯定地说，我对此没有太多经验。"))
    add_dialogue("free_flirt_sex_act a little reluctant", ("nerd", "helper"), ("我们可以停止谈论这个了吗？我不是不喜欢它....但就是不。"))
    add_dialogue("free_flirt_sex_act indifferent", ("nerd"), ("我很感兴趣，但有些东西我不明白。也许你可以向我解释一下？"), love=1)
    add_dialogue("free_flirt_sex_act interested", ("nerd", "pet"), ("*脸红*我不知道那是什么，但只是和你谈论这件事让我心情很好。"), love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("nerd"), ("*脸红*我知道，但我不会告诉你任何细节。"), love=2)
    add_dialogue("free_flirt_sex_act very interested", ("nerd"), ("*脸红*当然。我幻想在公共场合这样做。我的心无法停止跳动，因为我知道我可能会被抓住！"), love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("nerd", "repressed"), ("*脸红*我-我想如果我回答这个问题我会尴尬死的！ *低语* {i}答案是肯定的。{/i}"), love=3)

    add_dialogue("free_give_gold +++", ("nerd", "helper", "creep", "yandere", "sweet"), ("啊啊啊！谢谢你！我很高兴我可以死了。我爱你！"), love=4, max_cap=75)
    add_dialogue("free_give_gold ++", ("nerd", "stubborn", "loyal", "pet", "sweet"), ("真的吗？真是太好了，谢谢。"), love=3, max_cap=75)
    add_dialogue("free_give_gold +", ("nerd", "meek", "cold"), ("谢谢。"), love=1, max_cap=75)
    add_dialogue("free_give_gold -", ("nerd", "stubborn", "cold"), ("嗯....我能照顾好自己。"), love=-1, max_cap=75)
    add_dialogue("free_give_gold --", ("nerd"), ("你不需要给我这样的东西。你让我们之间的关系变得很尴尬。"), love=-1, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("nerd", "cold", "sweet", "very idealist"), ["她用新发现的决心看着你.", "g: Me? A whore? Isn't there any other way...", "g: I'm glad you told me the truth about your job. It gave me time to think it over.", "g: Do you... think I could do it?"], multiple=True, love=2)
    add_dialogue("free_offer_job half_lie", ("nerd"), ["g: 我还是第一次听说。你为什么不告诉我？", "mc: 我并不是有意隐瞒你。我确实是一个[MC.playerclass]。青楼只是我的副业。", "g: 嗯....嗯，这是一个危险信号。你应该让我知道的。"], multiple=True, love=-2)
    add_dialogue("free_offer_job lie", ("nerd"), ["g: 我还是第一次听说。你为什么不告诉我？", "mc: 我并不是有意隐瞒你。我实际上是一个[MC.playerclass]。青楼只是我的副业。", "g: 嗯，他妈的怎么了。你不应该对我撒谎。真乱来。"], multiple=True, love=-4)
    add_dialogue("free_offer_job success", ("nerd"), ["她深吸了一口气。", "g: 哦，到底是什么....我其实有点好奇。不妨尝试一下。"], multiple=True)
    add_dialogue("free_offer_job thinking", ("nerd"), ["g: *叹气* ...说实话，我其实有点好奇。", "g: 我需要一些时间考虑一下这个问题。考虑我的选择。", "mc: 当然，慢慢来[girl.name]。再见。"], multiple=True)
    add_dialogue("free_offer_job failure lie", ("nerd"), ["g: 不....我不会签署你的奴隶契约。别开玩笑了。", "g: 这个情节的转折真的让我很沮丧。直到这一刻我们的故事都很有趣。", "mc: 你再考虑一下，好吗？", "g: 我得走了。我需要一些独处的时间...一些远离{i}你{/i}的时间。 *疯狂的*"], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("nerd"), ["g: 不....我不会签署你的奴隶契约。别开玩笑了。", "g: 这个情节的转折真的让我很沮丧。直到这一刻我们的故事都很有趣。", "mc: 你再考虑一下，好吗？", "g: 我得走了。我需要一些独处的时间...一些远离{i}你{/i}的时间。 *疯狂的*"], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("nerd"), ["g: 哎呀...这不完全是一份理想的工作，不是吗？", "mc: *笑*你会感到惊讶的。有些人绝对会认为这是一份梦想的工作。", "g: 那些人都是妄想症。青楼可能听起来很有趣，但你我都知道它们吸引的是最糟糕的人。", "mc: 哦，我知道如何让他们保持一致。这对我的女儿们和我的顾客来说都是如此。那么你梦想的工作是什么？", "g: 嗯...我猜你已经找到我了。我真的没有一个..."], multiple=True, love=-6)
    add_dialogue("free_friend half_lie", ("nerd"), ["g: 嗯....我相信你在转行时会有很多选择。 [MC.playerclass] 的技能可以在各个方面发挥作用。", "mc: 是的，这就是我所希望的。你呢？", "g: 啊....我还没有真正找到我的才能的好用处。小时候我一直想成为一名图书管理员。但在泽恩呆了一段时间后，我不再那么确定了......"], multiple=True, love=2)
    add_dialogue("free_friend lie", ("very introvert"), ["她冷冷地看着你.", "g: 是这样吗?奇怪。我从来没听说过你。你说的是实话吗?", "mc: 嗯,嗯...哦，看看时间，哈哈!我真的得走了."], multiple=True, love=2)

    add_dialogue("free_love_interest", ("nerd"), ["mc: 嗨，[girl.name]。你看起来闷闷不乐。一切都好吗？", "g: 啊，我没事....我想只是有点情绪化。", "g: 我正在读一个浪漫的故事。恋人们刚刚向对方表白了自己的真情....说起来我的心都在漏跳。", "g: 有一位英俊的王子....他爱上了一个平民，在经历了几章浪漫的紧张之后，他递给她一束鲜花并约她出去。", "mc: Is that so?"], multiple=True)
    add_dialogue("free_girl get_flowers", ("nerd"), ("这非常浪漫....它们很漂亮。"))
    add_dialogue("free_ask_out", ("nerd"), ["mc: [girl.name]，我很想成为你的王子，让你在我身边。", "g: 你想让我...做你的女朋友?", "mc: 没有什么能让我更快乐。", "g: 哦，[MC.name]！我感觉自己好像在做梦。这真的发生了吗？我的意思是....是的！我的回答是，当然可以！", "她扑进你的怀抱，给你一个又长又深的吻.", "g: 我现在得走了....不过很快就会见到你的，英俊的王子！ *眨眼*"], multiple=True)

    add_dialogue("free_girlfriend intro", ("nerd"), ["g: 啊，[MC.name]！我有件事需要你帮忙...", "mc: 你好，[girl.name]。我能提供什么帮助吗？", "g: 我已经开始写这本小说了....但我被困在一个特定的场景中。我想如果我们能把它付诸实践，也许就能让想法流动起来。", "mc: 为什么，当然....是关于什么的。", "g: *咯咯笑*嗯，这是一个色情故事。有一个女孩疯狂地爱上了一位英俊的王子。", "g: 他们之间确实有联系。他们有很多共同点...比如...你能猜到吗？"], multiple=True)
    add_dialogue("free_girlfriend right", ("nerd"), ["g:  *眨眼* 完全正确。艺术模仿生活。", "g: 所以在故事的这一点上，女孩和王子之间存在着令人难以置信的性紧张。女孩决定采取行动。 *咧嘴笑*", "mc: 哦，我喜欢这样的发展方向。"], multiple=True, love=5)
    add_dialogue("free_girlfriend give_up", ("nerd"), ("至少尝试猜测... *皱眉*我想你对我的故事不太感兴趣，是吧？"), love=-5)
    add_dialogue("free_girlfriend wrong", ("nerd"), ["g: 不！ *疯狂*那会是一个可怕的故事。谁会相信呢？", "mc: 噢，我的错...."], multiple=True, love=-10)
    add_dialogue("free_girlfriend success", ("nerd"), ["[girl.name] 在你面前脱衣服。她的动作有些尴尬，但你还是会被它唤起。", "她显然非常紧张。她继续说着，脸就红了。", "g: *脸红*A-于是，女孩在她英俊的王子面前脱掉衣服。然后....呃....然后....", "她盯着你的腹股沟，发现你的鸡巴每一秒都变得更硬。", "g: *脸红*啊哈！我想我已经知道接下来会发生什么了。感谢您的帮助，[MC.name]。", "g: *脸红*F-从现在开始，我希望你们继续支持我探索各种风情场景。"], multiple=True)
    add_dialogue("free_girlfriend success naked", ("nerd"), ["[girl.name] 在你面前脱衣服。她的动作有些尴尬，但你还是会被它唤起。", "她显然非常紧张。她继续说着，脸就红了。", "g: 在家里，女孩其实已经习惯了一直赤身裸体。 *脸红*但这一次，英俊的王子看着她，情况有所不同。", "g: *脸红*A-于是，女孩在她英俊的王子面前脱掉衣服。然后....呃....然后....", "她盯着你的腹股沟，发现你的鸡巴每一秒都变得更硬。", "g: *脸红*啊哈！我想我已经知道接下来会发生什么了。感谢您的帮助，[MC.name]。", "g: *脸红*F-从现在开始，我希望你们继续支持我探索各种风情场景。"], multiple=True)

    add_dialogue("free_job_request", ("very introvert"), ["g: 嗨, [MC.name].", "mc: 嗨, [girl.name].", "g: 我能为你工作吗?", "mc: 呃?", "g: 我说, 我能为你工作吗? 我需要钱。这能有多难呢?", "mc: 嗯...这是一个出乎意料的要求....让我想想."], multiple=True)
    add_dialogue("refuse farm", ("generic"), ["不！不要去农场！我清楚那里发生了什么事情....我拒绝去!", "我不想去农场！求你了，主人，不要!", "不！不要去农场！求你了...", "我不能去，主人....我不能....请饶了我..."])
    add_dialogue("gizel take girl to farm", ("nerd"), ("完美的！鲜血群岛种马迫切需要奴隶的小穴。"))
    add_dialogue("slave bullied", ("very idealist"), ["但、但是....", "嘿，等等...", "别、别这样...."])
    add_dialogue("slave naked request permanent", ("nerd", "very modest"), ["g: 但-但是...我-我...我不能...*脸红*", "mc: 你必须这样做。我给你下了命令。", "g: 很好，那么...如果...如果我别无选择...*脸红*"], multiple=True, fear=1, sound=s_sigh)
    add_dialogue("slave train beg", ("generic"), ["[girl.name]跪下，开始含泪恳求你。", "g: 主人，求你了，不要！！！不是这样的....我求你了，请温柔点...."], multiple=True)
    add_dialogue("slave beg proceed", ("generic"), ("不！！！"), love=-1, fear=2)
    add_dialogue("slave chat tastes likes", ("nerd", "class president"), ("我喜欢更多地了解[thing_cn]。特别是[best]。", "我对每一种[thing_cn]都很着迷，但我发现[best]特别有趣。"), unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("nerd", "class president", "repressed"), ("我对[thing_cn]了解得越多，我就越意识到[worst]是多么可怕。", "每当提到[worst]我就会生气。任何其他[thing_cn]都将是首选。"), unlock="LM")
    add_dialogue("slave chat origins 1", ("nerd", "pervert", "loyal", "superficial"), ("这是一个又长又无聊的故事。我来自[girl.origin]。", "[girl.origin]。您真的不想听到更多有关此的信息。"), unlock="EI")
    add_dialogue("slave lecture love", ("nerd", "very extravert"), ("很高兴见到你，[MC.name]主人！我有很多问题..."))
    add_dialogue("slave lecture neutral", ("nerd", "very dom"), ("来给我讲授鸟类和蜜蜂的知识吗？"))
    add_dialogue("slave lecture fear", ("nerd", "very lewd"), ("她很警惕，但又有点好奇。"))
    add_dialogue("slave train obedience", ("nerd", "very dom"), ("噢，更多的家务活....我想我早该预料到的...."))
    add_dialogue("slave train constitution", ("very introvert"), ("哦，真的，锻炼吗？我就不能看书吗？ *抱怨*"))
    add_dialogue("slave reward gold", ("very idealist"), ("嗯...感觉就像你想贿赂我...但是谢谢，我想。"), unlock="MI")

## START MASOCHIST DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("masochist", "helper", "loyal"), ("美好的一天，先生。我的名字是[girl.fullname]。"), love=0)
    add_dialogue("free_greetings_casual", ("masochist", "helper", "loyal", "cold", "class president", "class president"), ("我的名字是[girl.fullname]。我怎么帮你？"), love=1)
    add_dialogue("free_greetings_rude", ("masochist", "helper", "rebel"), ("哇....*脸红*我的眼睛在上面，变态！我是[girl.fullname]。","我是[girl.fullname]。你有什么想要从我这里得到的吗？"), love=2)

    add_dialogue("free_small_talk", ("masochist", "repressed", "meek"), ("R-真的吗？你这么认为吗？嗯，我想你是对的...", "哦哦，有趣！我也这么认为..."), love=3, max_cap=25)
    add_dialogue("free_gossip", ("masochist", "nerd", "repressed", "creep"), ("我本来想谈谈别的事，但是...."), max_cap=25)
    add_dialogue("free_chat_life", ("masochist", "meek"), ("这是一个很难回答的问题。我真的不知道该怎么想。", "宇宙是一个很大的地方。当我开始思考这个问题时，我感觉我的生命是如此的微不足道。"), love=0, max_cap=25)
    add_dialogue("free_chat_love", ("masochist", "pervert", "helper"), ("呃....爱情很复杂。", "嗯...爱情有时可以让你变成另一个人，你不同意吗？"), max_cap=25)
    add_dialogue("free_chat_origins", ("masochist", "pervert", "generic", "class president", "princess", "schemer", "cold"), ("我在 [girl.origin] 附近长大。"), max_cap=40)
    add_dialogue("free_chat_hobbies", ("masochist", "meek"), ("我基本上属于宅在家里的类型。但我喜欢[hobby]。", "我经常去[hobby]。我好像没有其他事可做。"), love=2, max_cap=40)
    add_dialogue("free_chat_likes", ("masochist", "meek"), ("你为什么会对我最喜欢的[thing_cn]感兴趣？我感觉自己就像显微镜下的虫子。嗯...[best]，我猜？", "[thing_cn][best]还可以。我们可以谈谈别的事情吗？"), max_cap=40)
    add_dialogue("free_chat_dislikes", ("masochist", "loyal", "helper"), ("我是那些讨厌[thing_cn][worst]的女孩之一。", "不要因此而恨我，但我认为[worst]是一件可怕的[thing_cn]。"), love=2, max_cap=40)

    add_dialogue("free_joke_harmless", ("masochist", "generic", "repressed", "prude", "cold"), ("*微笑*有趣。我想我以前听过这句话。"), love=1, max_cap=50)
    add_dialogue("free_joke_adult", ("masochist", "helper"), ("*脸红*这-够了，好吗？！如果有人听到你的声音怎么办...", "*脸红*D-别拿这种事开玩笑。"), love=1, max_cap=50)
    add_dialogue("free_joke_dark", ("masochist", "pervert", "princess"), ("嗯....我不知道该笑还是该哭。"), love=0, max_cap=50)
    add_dialogue("free_joke_mean", ("masochist", "pervert", "pet", "helper", "creep"), ("啊哈哈哈哈！我{i}喜欢{/i}你！", "哇哈哈！我应得的。", "该死！虽然很卑鄙，但我会接受！"), love=3, max_cap=50)

    add_dialogue("free_touch_hand", ("masochist", "meek", "repressed", "pet", "prude"), ("只有我们两个人....真是太浪漫了！", "*脸红*这有点尴尬......", "嗯....这样牵着手，有种让人安心的感觉。"), love=2, max_cap=90)
    add_dialogue("free_touch_kiss", ("masochist", "pet"), ("这个地方美好而安静——是亲热的完美场所。诶嘿嘿。", "我爱你，[MC.name]。"), love=2, max_cap=90)
    add_dialogue("free_touch_ass", ("masochist", "pervert", "helper"), ("哎呀？！什、什么鬼！ *脸红* ...D-再做一次。", "啊啊！！ *脸红*用力地打我。", "啊!当你如此咄咄逼人时，我真的很兴奋。", "啊! *脸红*我喜欢你掌控一切。", "啊啊，停下来，这种感觉太好了！ *喘气*，啊！你这个小气鬼！"), love=4, max_cap=90)
    add_dialogue("free_touch_breasts", ("masochist", "meek", "repressed", "loyal"), ("快住手吧！我不是玩具！", "嘿嘿，停下来！你让我毛骨悚然！", "呵呵，你、你骗不了人的！别再试图抓住我的胸部了！"), love=1, max_cap=90)
    add_dialogue("free_touch_pussy", ("masochist", "pervert", "rebel"), ("Oh!! Mmm... Oh yes, keep... doing that... *脸红*"), love=4, max_cap=90)

    add_dialogue("free_play refuses", ("masochist"), ("不！我确信有很多女孩喜欢这个，但这并不意味着我喜欢。"), love=-1)
    add_dialogue("free_play very reluctant", ("masochist", "creep"), ["g: 啊....抱歉，抱歉，这太突然了。我不知道该说些什么...", "g: *脸红*我希望你强迫我。你能用你的腰带吗？"], multiple=True, love=1)
    add_dialogue("free_play reluctant", ("masochist", "creep"), ("*喘气*那-那个？！我并不反对....但仍然如此。"), love=2)
    add_dialogue("free_play a little reluctant", ("masochist", "creep"), ("*脸红*如果我开始尖叫或哭泣...请-请继续。"), love=2)
    add_dialogue("free_play indifferent", ("masochist", "creep"), ("当然... *脸红* C-你能掐死我吗？"), love=3)
    add_dialogue("free_play a little interested", ("masochist", "creep"), ("我又没有其他事可做，所以当然，为什么不呢？我要你羞辱我。"), love=4)
    add_dialogue("free_play interested", ("masochist", "creep"), ("叫我妓女，我喜欢！ ...不，我认真的。我要你叫我妓女。"), love=4)
    add_dialogue("free_play very interested", ("masochist", "creep"), ("他妈的是的。随心所欲地使用和虐待我。我将为您提供即时性爱。呃呃呃。"), love=5)
    add_dialogue("free_play fascinated", ("masochist", "creep"), ("你知道，很多人说我有点性怪胎....但我敢打赌，这些人在高潮时从来没有被掐死或鞭打过。这是纯粹的幸福！"), love=5)
    add_dialogue("MC take virginity", ("masochist"), ("啊哈哈哈....你、你弄破了我的处女膜...."), love=5)
    add_dialogue("free_play interested after", ("masochist"), ("嗯....*咳嗽*我喜欢你有力的双手搂住我脖子的感觉。 *喘息声*"))
    add_dialogue("free_play not interested after", ("masochist"), ("不会撒谎，这有点无聊。"))

    add_dialogue("free_flirt_beauty", ("masochist", "cold", "schemer"), ("...嗯？"), love=2, max_cap=75)
    add_dialogue("free_flirt_body", ("masochist", "cold"), ("...呃？我不在乎。"), love=0, max_cap=75)
    add_dialogue("free_flirt_mind", ("masochist", "bimbo"), ("...哦？这对我来说应该意味着什么吗？"), love=0, max_cap=75)
    add_dialogue("free_flirt_spirit", ("masochist", "cold"), ("...好的？"), love=2, max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("masochist"), ["g: 呃呃呃。不要告诉任何人，但是...", "她靠近你，在你耳边低语。", "g: {i}我喜欢多个人对我开火车。{/i}"], multiple=True, love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("masochist"), ("唉，我根本不是人们想象中的那个纯洁无邪的女孩啊！"), love=2)
    add_dialogue("free_flirt_sex_experience average", ("masochist"), ("哦，所以你很好奇，是吗？嗯，我想说我很有经验。"), love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("masochist"), ("呃，显然我有{i}一些{/i}经验。我不是小孩子了好吗？"))
    add_dialogue("free_flirt_sex_experience very inexperienced", ("masochist"), ("假装我根本没有做过那是骗人的....但我非常缺乏经验。"), love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("masochist"), ("不！我还没用过。 *咧嘴笑*"), love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("masochist"), ("你是绿色的吗？ *呻吟*多么沉闷..."))
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("masochist"), ("*呻吟*对...你希望我相信这一点？"), love=-1)

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("masochist"), ("也许我会告诉你它可以变得多么堕落。 *眨眼*"), love=2)
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("masochist"), ("嗯....你有事瞒着我，我才知道。"), love=0)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("masochist"), ("我确信你有，但这里有一个小秘密....我和其他人不一样。 *眨眼*"), love=3)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("masochist"), ["她舔了舔嘴唇.", "g: 噢，是吗？现在我越来越好奇了..."], multiple=True, love=4)
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("masochist"), ("*呻吟*这就是他们都说的..​​.我期待着最坏的情况。"))
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("masochist"), ("我想....那么告诉我，你会如何惩罚一个行为不端的女孩？"), love=1)

    add_dialogue("free_flirt_sex_act refuses", ("masochist"), ("呃，这不是我可以谈论的事情！"))
    add_dialogue("free_flirt_sex_act very reluctant", ("masochist"), ("只有在强行约束的情况下，我才会做出这样的事。"))
    add_dialogue("free_flirt_sex_act reluctant", ("masochist", "loyal", "pet"), ("我真的不关心它。哦，但是....当我和我喜欢的人在一起时，情况就不一样了。"))
    add_dialogue("free_flirt_sex_act a little reluctant", ("masochist"), ("我必须被说服才去做那样的事情。也许用鞭子？"))
    add_dialogue("free_flirt_sex_act indifferent", ("masochist", "creep"), ("听起来还不错。"), love=1)
    add_dialogue("free_flirt_sex_act interested", ("masochist", "creep"), ("*咧嘴一笑*我对此没意见，但我可能想给它增添一点趣味....例如，戴上手铐。"), love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("masochist"), ("哦，是的...现在你正在说我的语言。在公共场合这样做真是一种体验！"), love=2)
    add_dialogue("free_flirt_sex_act very interested", ("masochist"), ["她呻吟着，舔着嘴唇。", "g: 我希望能被置于这种境地。"], multiple=True, love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("masochist"), ["她呻吟着，舔着嘴唇。", "g: 我从中得到的冲击....绝对惊人！", "g: 越接近酷刑，我就越享受。"], multiple=True, love=3)

    add_dialogue("free_give_gold +++", ("masochist", "cold"), ("谢谢。"), love=6, max_cap=75)
    add_dialogue("free_give_gold ++", ("masochist", "class president", "cold"), ("谢谢。"), love=4, max_cap=75)
    add_dialogue("free_give_gold +", ("masochist", "meek", "cold"), ("好的。"), love=2, max_cap=75)
    add_dialogue("free_give_gold -", ("masochist", "meek", "schemer", "creep", "cold"), ("唔..."), max_cap=75)
    add_dialogue("free_give_gold --", ("masochist", "meek", "creep", "cold"), ("..."), love=-1, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("masochist", "pervert", "very lewd"), ["她好奇地看了你一眼.", "g: 你肯定觉得我是个肮脏的婊子，对吧?", "mc: 呃...", "g: 我没说你错...Mmmh...", "她咬了咬嘴唇.", "g: 如果我在那里工作，我就会整天被陌生人操，对吧?"], multiple=True, love=2)
    add_dialogue("free_offer_job half_lie", ("masochist", "pervert"), ["g: 去他妈的!你之前可以提到的...", "mc: 我很抱歉...", "g: 这比我想象的有趣多了...你为什么瞒着我!!我很生气...", "g: 所以如果我在那里工作，我就可以整天和陌生人随便做爱，对吗? Hmm..."], multiple=True, love=3)
    add_dialogue("free_offer_job lie", ("masochist"), ["g: 去他妈的!你之前可以提到的...", "mc: 我很抱歉...", "g: 这比我想象的有趣多了...你为什么瞒着我!!我很生气...", "g: 所以如果我在那里工作，我就可以整天和陌生人随便做爱，对吗? Hmm..."], multiple=True, love=3)
    add_dialogue("free_offer_job success", ("masochist"), ["g: 我什至可以正式成为你的奴隶？这是一个很棒的优惠！我要买它。", "g: 你能保证当我不守规矩时惩罚我吗？ *笑*"], multiple=True)
    add_dialogue("free_offer_job thinking", ("masochist"), ["g: 我什至可以正式成为你的奴隶？这是一个很棒的优惠！我等不及了！", "g: 你能保证当我不守规矩时惩罚我吗？ *笑*", "g: 但是在我们签署文件之前，我需要处理一些事情....我会尽快处理的！尽快回复你。"], multiple=True)
    add_dialogue("free_offer_job failure lie", ("masochist"), ["她看起来很失望。", "g: 哦....只是临时合约？唔...", "g: 我需要一些时间考虑一下这个问题。你并没有让这听起来像我希望的那样有辱人格。", "她走开，看上去若有所思。"], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("masochist"), ["她看起来很失望。", "g: 哦....只是临时合约？唔...", "g: 我需要一些时间考虑一下这个问题。你并没有让这听起来像我希望的那样有辱人格。", "她走开，看上去若有所思。"], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("masochist"), ["g: 真的吗？我很好奇...你有命令过你的奴隶舔你的脚吗？", "mc: 呃....不，我不记得了。所以你会怎么做？", "g: 噢...不多..."], multiple=True, love=0)
    add_dialogue("free_friend half_lie", ("masochist"), ["g:  很公平。你和泽恩的其他一千个[MC.playerclass]。 *笑*", "mc: 是的，我注意到这里的竞争很激烈。那你有工作吗？", "g:  不，现在不是...."], multiple=True, love=2)
    add_dialogue("free_friend lie", ("masochist"), ["g: 你看上去不太像那个角色。你确定吗？", "mc: 当然可以！你呢？", "g: 哦...我还没有真正决定要做什么..."], multiple=True, love=-3)

    add_dialogue("free_love_interest", ("masochist"), ["mc: 嗨，[girl.name]。一切都好吗？", "g: *叹气*我想...我刚刚看到一对夫妇在打架。我不确定那是关于什么的。女人大喊大叫，然后男人就打了她的脸。现在我无法停止思考它。", "mc: 噢，亲爱的。你想谈谈吗？", "g: 这是最奇怪的事情......我一直想象自己处于女人的位置。不知怎的，我很享受它。 *脸红*", "g: 像这样被人贬低，被一个男人引导和支配....这让我着迷。", "mc: Is that so?", "g: 我希望我的生活中有一个像他这样的人。有人踩我。难道我不值得吗？"], multiple=True)
    add_dialogue("free_girl get_flowers", ("masochist"), ("它们闻起来很可爱....你真的不应该这样，你用这些把我宠坏了。"))
    add_dialogue("free_ask_out", ("masochist"), ["你从她手里夺回花，扔到地上。", "mc: 你说得完全正确，[girl.name]。你不值得他们。", "g: *喘息* [MC.name]？这是怎么回事？", "mc: 我愿意给你你想要的东西。我会把你当作垃圾一样对待，你也会因此而爱我。", "g: 嗯....你怎么了！我{i}喜欢{/i}这个游戏...", "你用一只手将她的头发向后拉，另一只手将她的内裤压下去。", "mc: 告诉我真相。你喜欢这个，不是吗？", "g: *呻吟*哦，[MC.name]...我-我愿意...","mc: 好。从现在开始，你就听话了。明白了吗？", "g: 是-是的，[MC.name]。明白了。"], multiple=True)

    add_dialogue("free_girlfriend intro", ("masochist"), ["mc: 很高兴见到你，[girl.name]。", "g: 嗨[MC.name]，我想念你。", "mc: 你说，我们现在已经很熟悉了，不是吗？", "g: 是的，我想是的。", "mc: 事实上，我敢打赌我比你更了解你自己！", "g: *咧嘴笑*哦？你想测试一下吗？", "mc: 为什么，当然....你一晚上能服务多少只鸡巴？", "她看起来有点困惑，但你可以看出这个问题让她很兴奋。", "g: *脸红*什-什么？！你到底是什么....我不知道该怎么回答！！", "mc: 嗯，我愿意。这对你来说是一击。问我任何关于你的事情。", "g: 呃....呃....怎么样...."], multiple=True)
    add_dialogue("free_girlfriend right", ("masochist"), ["她似乎很喜欢和你一起玩，当你给出正确答案时她会点头。", "g: 现在再给我一份。", "mc: 这个怎么样？你是什​​么动物？", "g: A...呃...人类？", "mc: 又错了！你是一头猪，不是吗？", "g: 啊....你说得对。我是一只猪。也许我现在应该四肢着地！", "mc: 确实应该这样做。但在你这样做之前....猪不穿衣服，不是吗？", "g: 不、不，你说得对....猪不穿衣服。", "g: 你已经证明了你的观点。你很了解我..."], multiple=True, love=5)
    add_dialogue("free_girlfriend give_up", ("masochist"), ["她抓着头，完全困惑了。", "g: 抱歉，我不明白我们在玩什么游戏。", "g: 我想我们俩都不太了解我吧？"], multiple=True, love=-5)
    add_dialogue("free_girlfriend wrong", ("masochist"), ["她抓着头，完全困惑了。", "g: 抱歉，我不明白我们在玩什么游戏。", "g: 我不知道我们怎么会错得这么离谱。"], multiple=True, love=-10)
    add_dialogue("free_girlfriend success", ("masochist"), ["她脱掉衣服，开始四肢着地在地板上爬行。", "g: 呜呜呜....我是一只小猪....我是一块等待被宰杀的肉....呜呜....", "mc: 当她在房间里走来走去时，你为她鼓掌，就像她出生时一样赤身裸体。","mc: 为我尖叫吧，小猪！", "你打她的屁股，她就会像猪一样尖叫。", "玩了几分钟后，你让她再次站起来。", "g: *脸红*啊哈哈...我已经很久没有玩得那么开心了。你知道如何让我继续前进，[MC.name]。"], multiple=True)
    add_dialogue("free_girlfriend success naked", ("masochist"), ["她脱掉衣服，开始四肢着地在地板上爬行。", "g: 呜呜呜....我是一只小猪....我是一块等待被宰杀的肉....呜呜....", "mc: 当她在房间里走来走去时，你为她鼓掌，就像她出生时一样赤身裸体。","mc: 为我尖叫吧，小猪！", "你打她的屁股，她就会像猪一样尖叫。", "玩了几分钟后，你让她再次站起来。", "g: *脸红*啊哈哈...我已经很久没有玩得那么开心了。你知道如何让我继续前进，[MC.name]。", "mc: 这是一场令人印象深刻的表演。你以前做过这个吗？", "g: 呃呃...是的，我有...几次，独自在我的房间里。", "g: 我很高兴你这次能观看。这让它变得更加令人兴奋。 *眨眼*"], multiple=True)

    add_dialogue("free_job_request", ("masochist"), ["g: ...", "mc: 怎么了, [girl.name]?", "g: 我一文不值.", "mc: 呃???", "g: 我是个没用的废物。我想让你虐待我。我想被像厕所一样利用。我想要...", "mc: 哇，我们有过一些古怪的时刻，但是....这真前卫.", "g: 帮帮我。让我跪下来。打我。我想成为一个奴隶...", "mc: 你现在知道了，是吗..."], multiple=True)

    add_dialogue("accept farm", ("masochist", "pervert", "libido"), ["农场...我听说吉泽尔在那里干着很脏很脏的事... *脸红*", "这是否意味着....这是否意味着我会像动物一样被锁起来? *脸红*", "我知道我不该这么做，但是...不知为何我感到兴奋..."])
    add_dialogue("gizel take girl to farm", ("masochist"), ("过来吧，你这个愚蠢的垃圾。是时候向您介绍所有会强奸您的事物了。"))
    add_dialogue("slave chat tastes likes", ("masochist", "meek"), ("你为什么会对我最喜欢的[thing_cn]感兴趣？我感觉自己就像显微镜下的虫子。嗯...[best]，我猜？", "[thing_cn][best]还可以。我们可以谈谈别的事情吗？"), unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("masochist", "loyal", "helper"), ("我是那些讨厌[thing_cn][worst]的女孩之一。", "不要因此而恨我，但我认为[worst]是一件可怕的[thing_cn]。"), unlock="LM")
    add_dialogue("slave chat origins 1", ("masochist", "pervert", "generic", "class president", "princess", "schemer", "cold"), ("我在 [girl.origin] 附近长大。"), unlock="EI")

## START MEEK DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("meek", "very sub", "pervert"), ("D-我认识你吗？我的名字是[girl.fullname]。"), love=2)
    add_dialogue("free_greetings_casual", ("meek", "generic", "very idealist", "very sub", "prude"), ("噢,嗨。我是 [girl.fullname]. 很高兴见到你"), love=2)
    add_dialogue("free_greetings_rude", ("meek", "very sub", "nerd"), ("什、什么？别这样吓我。我是[girl.fullname]。"), love=-1)

    add_dialogue("free_small_talk", ("meek", "masochist", "repressed", "pet"), ("Oh, you're right, haha..."), love=2, max_cap=25)
    add_dialogue("free_gossip", ("meek", "generic", "very introvert", "very materialist", "very modest"), ("我听到了最有趣的谣言..."), love=1, max_cap=25)
    add_dialogue("free_chat_life", ("meek", "nerd", "sweet", "repressed", "holy", "prude", "class president", "tsundere", "loyal"), ("我得考虑一下...没有正确的答案，不是吗？", "其实....这个问题我想了很多，但没有一个确切的答案。"), love=2, max_cap=25)
    add_dialogue("free_chat_love", ("meek", "very modest", "repressed"), ("呃....我、这太复杂了。我有很多麻烦..."), love=-1, max_cap=25)
    add_dialogue("free_chat_origins", ("very sub", "meek", "helper", "pet", "loyal"), ("我在[girl.origin]长大。尽管如此，我想我现在还在成长。"), love=2, max_cap=40)
    add_dialogue("free_chat_hobbies", ("generic", "very introvert", "very idealist", "very modest", "very sub", "bimbo", "pet"), ("没、没什么特别的....也许是[hobby]？", "我想这个周末我可以去[hobby]。"), love=1, max_cap=40)
    add_dialogue("free_chat_likes", ("meek", "loyal", "helper", "masochist", "prude"), "嗯....[best]相当不错。这也是我母亲最喜欢的[thing_cn]。但我更愿意讨论另一个话题。", max_cap=40)
    add_dialogue("free_chat_dislikes", ("meek", "very sub"), "[thing_cn][worst]让我感到毛骨悚然！我还是不明白为什么...", love=2, max_cap=40)

    add_dialogue("free_joke_harmless", ("meek", "very sub", "bimbo"), ("这有点好笑。"), max_cap=50)
    add_dialogue("free_joke_adult", ("meek", "nerd", "very modest", "holy", "repressed", "prude", "class president", "stubborn"), ("抱歉，请不要开这样的玩笑。"), love=-1, max_cap=50)
    add_dialogue("free_joke_dark", ("meek", "very modest"), ("*傻笑* N-不，你怎么了？！", "呃....我、我不应该笑这个。"), love=3, max_cap=50)
    add_dialogue("free_joke_mean", ("meek", "very sub"), ("*傻笑* N-不，你怎么了？！", "呃....我、我不应该笑这个。"), love=3, max_cap=50)

    add_dialogue("free_touch_hand", ("meek", "very sub"), ("*微笑*你是个好人。我一点也不怕你，虽然你是个男人。", "哇！这、这很好...."), love=3, max_cap=90)
    add_dialogue("free_touch_kiss", ("meek", "very introvert", "cold", "nerd", "masochist", "creep", "repressed", "schemer"), ("*微笑*我每天都越来越喜欢你...永远陪在我身边？", "和你在一起总是让我心跳加速，[MC.name]..."), love=2, max_cap=90)
    add_dialogue("free_touch_ass", ("meek", "very sub", "sweet", "easy"), ("呵呵...很高兴和你在一起。作为一份特别的礼物，我会让你随心所欲地触摸它。", "*咯咯笑*它的尺寸非常适合您的手。"), love=2, max_cap=90)
    add_dialogue("free_touch_breasts", ("meek", "masochist", "very idealist", "loyal"), ("哦-好的，你完成了！免费触摸时间正式结束！", "哇！别、别说了，我是认真的！", "哎呀！别、别玩了！", "住、住手，这太尴尬了！"), max_cap=90)
    add_dialogue("free_touch_pussy", ("meek", "very modest", "sweet", "class president"), ("啊!什、你在做什么？！"), love=1, max_cap=90)

    add_dialogue("free_play refuses", ("meek", "very sub", "nerd", "repressed"), ("嗯，我对这类事情不太舒服。我们可以做点别的吗？"), love=-1)
    add_dialogue("free_play very reluctant", ("meek", "very sub", "very modest"), ("嗯，我们就没有别的事可以做吗？我不喜欢这个..."), love=1)
    add_dialogue("free_play reluctant", ("meek", "very sub", "sweet", "nerd", "repressed", "tsundere"), ("我不太擅长这类事情。请温柔一点..."), love=2)
    add_dialogue("free_play a little reluctant", ("meek", "very sub", "nerd", "class president"), ("我....对此没有太多经验。你会教我么？"), love=2)
    add_dialogue("free_play indifferent", ("meek", "very introvert", "very sub"), ("*脸红*别-别用那种表情...我会做的，为了你..."), love=3)
    add_dialogue("free_play a little interested", ("meek", "very sub", "creep", "yandere"), ("*脸红*如果你想让我这么做，我会，好吧...我会做各种各样的事情..."), love=4)
    add_dialogue("free_play interested", ("meek", "very modest"), ("*喘气*你-你太无耻了...我喜欢它！"), love=4)
    add_dialogue("free_play very interested", ("meek", "very modest"), ["g: 哇！？我不敢相信你突然问这个问题！", "g: 我-我不是说不...听起来真的很令人兴奋，实际上..."], multiple=True, love=5)
    add_dialogue("free_play fascinated", ("meek", "very sub"), ("是-是的！谢谢你...每当我和你在一起时，我就开始变得...真的有心情..."), love=5)
    add_dialogue("MC take virginity", ("meek"), ("啊...我以前从未这样做过...*脸红*我很高兴我的第一次是和你在一起。"), love=5)
    add_dialogue("free_play interested after", ("meek", "very modest", "masochist"), ("我不知道我在那里发生了什么....太棒了！"))
    add_dialogue("free_play not interested after", ("meek", "very modest", "very sub"), ("*噘嘴*你知道我为什么生你的气吗？在你这样做之前我不会原谅你。"))

    add_dialogue("free_flirt_beauty", ("meek", "nerd", "prude", "pet", "stubborn"), ("谢谢你的称赞。我知道我看起来很普通，但我很高兴我是你喜欢的类型。", "*脸红*哦，别那样看着我......", "*脸红*这太尴尬了..."), love=1, max_cap=75)
    add_dialogue("free_flirt_body", ("meek", "masochist", "sweet", "holy", "helper", "class president"), ("你为什么盯着我？太丢脸了。", "T-看太多了。事情变得很奇怪了。", "你是不是看起来有点过分了？不如谈谈怎么样？"), love=-2, max_cap=75)
    add_dialogue("free_flirt_mind", ("meek", "very modest", "very idealist"), ("哇谢谢你！", "谢谢你总是抽出时间来和我说话。这让我振奋起来。", "谢谢你...每当我和你在一起时，我就开始感觉...真的很开心..."), love=3, max_cap=75)
    add_dialogue("free_flirt_spirit", ("meek", "very sub"), ("哇谢谢你！", "谢谢你总是抽出时间来和我说话。这让我振奋起来。", "谢谢你...每当我和你在一起时，我就开始感觉...真的很开心..."), love=2, max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("meek", "very introvert"), ("我真的很擅长这类事情。 *脸红*B-但是和男人说话对我来说仍然有点可怕。"), love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("meek", "very introvert"), ("我以前也做过这样的事....但尽管如此，我在男孩面前还是太紧张，不敢去约会。"), love=2)
    add_dialogue("free_flirt_sex_experience average", ("meek", "very introvert"), ("嗯....说实话，和男人在一起我很不舒服。"), love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("meek", "very introvert"), ("我真的很想克服在男生面前的尴尬！到目前为止进展不太顺利。"))
    add_dialogue("free_flirt_sex_experience very inexperienced", ("meek", "very introvert"), ("我....没有任何恋爱经验。"), love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("meek", "very modest"), ("我很困惑...你到底是什么意思？"), love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("meek", "very modest", "very idealist"), ("真的吗？我很惊讶...像你这样的人？"), love=2)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("meek", "very sub"), ("真的吗？我不相信你！"), love=-2)

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("meek", "very modest"), ("这就说得通了。简短地探索这些事情是很自然的，特别是对于像你这样的帅哥来说。"), love=4)
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("meek", "very modest"), ("唔？你的眼神里充满了危险....你知道，我和其他女孩不一样。"), love=1)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("meek", "very sub"), ("这就说得通了。这是很自然的，尤其是对于像你这样的帅哥来说。"), love=3)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("meek", "very modest", "very idealist"), ("*脸红*这——这不是什么值得吹嘘的事情！"))
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("meek", "very modest", "very idealist"), ("*脸红*这-这不好笑！"), love=-1)
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("meek", "very idealist"), ("*脸红* L-我们下次再说吧！"), love=1)

    add_dialogue("free_flirt_sex_act refuses", ("meek", "very modest", "very sub"), ("嗯，抱歉...我们可以谈谈别的事情吗？你让我不舒服。"))
    add_dialogue("free_flirt_sex_act very reluctant", ("very introvert", "cold", "nerd", "masochist", "creep", "repressed", "schemer", "very modest"), ("不、不！这听起来不像是我会感兴趣的事情......"))
    add_dialogue("free_flirt_sex_act reluctant", ("very introvert", "cold", "nerd", "masochist", "creep", "repressed", "schemer", "very sub"), ("我不太擅长这类事情。我们可以谈点别的吗？"))
    add_dialogue("free_flirt_sex_act a little reluctant", ("meek", "very modest", "nerd", "helper", "loyal"), ("那——那是从左场出来的....我听起来有点奇怪。"))
    add_dialogue("free_flirt_sex_act indifferent", ("meek", "very sub"), ("我？！我什至无法想象....但如果是对的人，也许我可以被说服。"), love=1)
    add_dialogue("free_flirt_sex_act interested", ("meek", "very idealist"), ("承认很尴尬，但是....是的，我愿意。"), love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("meek", "very sub"), ("这样我就很舒服了....嗯，只要对的人在我身边...."), love=2)
    add_dialogue("free_flirt_sex_act very interested", ("meek", "very sub", "very introvert" ), ("*脸红*通常我不会想那么多。但每当我和你在一起时，我就开始变得....真的有心情....", "*脸红* 嗯...我不知道我和其他女孩相比怎么样，但是...我觉得我很容易被这个吸引？"), love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("meek", "very sub", "very modest"), ("*脸红* Y-是的，呃！相信每个女孩都喜欢", "*脸红* 嗯...我不知道我和其他女孩相比怎么样，但是...我觉得我很容易被这个吸引？"), love=3)

    add_dialogue("free_give_gold +++", ("generic", "very introvert", "very idealist", "very modest", "very sub"), ("你太好了！谢谢。"), love=6, max_cap=75)
    add_dialogue("free_give_gold ++", ("meek", "very sub", "very modest"), ("T、你真可爱...."), love=4, max_cap=75)
    add_dialogue("free_give_gold +", ("generic", "very introvert", "very idealist", "very modest", "very sub", "nerd"), ("哦好的。"), love=2, max_cap=75)
    add_dialogue("free_give_gold -", ("meek", "very modest", "very idealist"), ("这个是干什么的？"), max_cap=75)
    add_dialogue("free_give_gold --", ("meek", "pet", "very idealist"), ("你怎么了？ *疯狂*你不必付钱给我来陪我。"), love=-1, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("meek", "superficial", "very sub"), ["她开始哭泣.", "g: 听起来很可怕!我不想....哦，我该怎么办呢...", "g: 如果我这么做，你会好好照顾我吗？?"], multiple=True)
    add_dialogue("free_offer_job half_lie", ("meek", "superficial", "very sub"), ["她开始哭泣.", "g: 我不敢相信你...你在说什么！我感到很困惑...", "g: 听起来很可怕!我不想....哦，我该怎么办呢..."], multiple=True)
    add_dialogue("free_offer_job lie", ("meek", "superficial", "very sub"), ["她开始哭泣.", "g: 我不敢相信你...你在说什么！我感到很困惑...", "g: 听起来很可怕!我不想....哦，我该怎么办呢...", "g: 如果我为你工作，你会照顾我吗？"], multiple=True, love=1)
    add_dialogue("free_offer_job success", ("meek", "very modest", "very sub"), ["g: 这太糟糕了....但我看不出有任何其他方法可以摆脱这种情况....", "g: 如果你是我的主人，你会好好照顾我的，不是吗？"], multiple=True)
    add_dialogue("free_offer_job thinking", ("meek", "very modest", "very sub"), ["g: 这太糟糕了....但我看不出有任何其他方法可以摆脱这种情况....", "g: 如果你是我的主人，你会好好照顾我的，不是吗？", "她突然哭了起来.", "g: 不、不....我做不到！我不能！！"], multiple=True)
    add_dialogue("free_offer_job failure lie", ("meek", "very modest", "very sub"), ["g: 这太糟糕了....但我看不出有任何其他方法可以摆脱这种情况....", "g: 如果你是我的主人，你会好好照顾我的，不是吗？", "她突然哭了起来.", "g: 不、不....我做不到！我不能！请别打扰我！"], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("meek", "very modest", "very sub"), ["g: 这太糟糕了....但我看不出有任何其他方法可以摆脱这种情况....", "g: 如果你是我的主人，你会好好照顾我的，不是吗？", "她突然哭了起来.", "g: 不、不....我做不到！我不能！请别打扰我！"], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("very modest", "meek", "very sub"), ["g: 不！！你、你吓到我了....我们来谈谈别的吧。", "mc: 好吧....你是做什么的？", "g: 嗯...."], multiple=True, love=-2)
    add_dialogue("free_friend half_lie", ("very modest", "meek", "very sub"), ["g: 哇，听起来真不错！", "mc: 它支付账单...你是做什么的？", "g: 嗯...."], multiple=True, love=5)
    add_dialogue("free_friend lie", ("very modest", "meek", "very sub"), ["g: 这是一份真正的工作，还是某种游戏？", "mc: 不，我就是这么做的....你呢？", "g: 嗯...."], multiple=True, love=-3)

    add_dialogue("free_love_interest", ("meek"), ["她看起来很慌张", "mc: 一切都好吗，[girl.name]？", "g:  嗯....是的，但我需要和你谈谈。 *脸红*", "mc: 我就在这里，不是吗？", "g: 呃，是的....自从遇见你以来，很多事情都改变了。", "g: 只要想到你，我的心就会漏跳....而且我无法停止想你。", "g: 我以前从未真正和任何人约会过，但是如果你不介意的话....你愿意和我出去吗？", "她的脸色涨得通红，显然需要很大的勇气才能说出这句话。", "mc: 很高兴收到你的来信，[girl.name]。我为你感到自豪。", "g: 哇！你、你不用马上回答....请你替我考虑一下好吗？", "mc: 我会的。谢谢。", "g: 啊！当你准备好给出答案时，可以给我送花！"], multiple=True)
    add_dialogue("free_girl get_flowers", ("meek"), ["她抬头看着你，眼里含着泪水。", "你看到她因期待即将发生的事情而颤抖......", "g: 呃-呃...[MC.name]？", "你故意保持沉默一段时间，保持目光接触。", "g: 请-请...哦，请...[MC.name]？", "她咬着嘴唇，发出一声小叫，泪水从脸上滚落。", "g: 呜呜....你、你在逗我。"], multiple=True)
    add_dialogue("free_ask_out", ("meek"), ["mc: [girl.name], 我喜欢你。让我们在一起.", "当她投入你的怀抱并给你一个漫长而深沉的吻时，她流下了喜悦的泪水。", "g: 我、我太高兴了！我们在约会！！"], multiple=True)

    add_dialogue("free_girlfriend intro", ("meek"), ["g: 啊，[MC.name]... ", "mc: 嗨，亲爱的。你今天怎么样？", "她看起来很兴奋。她的脸是鲜红的。", "g: 我很高兴。我-知道我们要出去感觉很奇怪。", "mc: 和男人说话你还会感到紧张吗？你知道，在我身边你可以放松。", "g: 我知道....我、我可以问你一件事吗？"], multiple=True)
    add_dialogue("free_girlfriend right", ("meek"), ["g: 是的，没错....所以....呃....", "g: W-每当我和你在一起时，我...我都会湿-湿。", "mc: 哇哦，是这样吗？", "g: 是-是的...嗯...所以...我-我有点心情不好。你是...？", "mc: 哦...也许你可以带我去那里。我需要一点帮助，明白吗？", "你脱下裤子，向[girl.name]展示你松弛的阴茎。", "g: 哦....那、那如果我....怎么办？"], multiple=True, love=5)
    add_dialogue("free_girlfriend give_up", ("meek"), ["mc: 那到底是怎么回事？你看起来好像有什么心事。", "g: 呃-嗯，你-你想不想...不-没关系，忘了我说过什么吧！"], multiple=True, love=-5)
    add_dialogue("free_girlfriend wrong", ("meek"), ["mc: 那到底是怎么回事？你看起来好像有什么心事。", "g: 嗯，嗯，我想谈谈....不，没关系，忘了我说过什么吧！"], multiple=True, love=-10)
    add_dialogue("free_girlfriend success", ("meek"), ["她一件一件地脱掉衣服。", "当她脱下内裤时，空气中悬挂着一串浓浓的阴液。", "g: 看到了吗？！每当我和你说话的时候都是这样！", "她张开她的阴唇，露出她闪闪发光的湿润小穴。果汁继续滴到地板上。", "当她把它放在你面前时，你会感觉到血液涌入你的阴茎。", "g: 啊看！ ....越来越难了！", "你们花了一点时间彼此更加熟悉。"], multiple=True)
    add_dialogue("free_girlfriend success naked", ("meek"), ["她一件一件地脱掉衣服。", "当她脱下内裤时，空气中悬挂着一串浓浓的阴液。", "g: 看到了吗？！每当我和你说话的时候都是这样！", "她张开她的阴唇，露出她闪闪发光的湿润小穴。果汁继续滴到地板上。", "当她把它放在你面前时，你会感觉到血液涌入你的阴茎。", "g: 啊看！ ....越来越难了！", "你们花了一点时间彼此更加熟悉。"], multiple=True)

    add_dialogue("free_job_request", ("meek", "very sub"), ["g: 噢, [MC.name], 这太可怕了... *啜泣*", "mc: 宝贝，发生什么事了?", "g: 警卫...他们把我们赶出了房子。和母亲....她生病了...我的兄弟们告诉我，他们已经养不出一张嘴了...", "g: 我现在孤身一人了。我怎样才能赚到足够的钱来维持生活？肯定会饿死，不然就会被恶棍抓住，奸杀我！", "她突然哭了起来.", "mc: [girl.name] 冷静点，我们会找到解决办法的..."], multiple=True)

    add_dialogue("accept farm", ("meek", "very sub"), ["我、如果这就是你想要的，主人....", "*抽泣*是-是的，主人...如果这就是你想要的。", "*抽泣*我明白了，主人。"])
    add_dialogue("accept farm fear", ("generic", "very introvert", "very idealist", "very modest", "very sub"), ["当吉泽尔向她走来时，她害怕得发抖，退缩了，但她不敢反抗.", "她用眼睛恳求不要去，但又不敢违抗你的命令.", "她太害怕了，不敢违抗你的命令."])
    add_dialogue("refuse farm", ("meek", "very sub"), ["*呜咽*请主人怜悯....", "*呜咽*但-但是主人...农场肯定会让我崩溃...我求求你，请放过我...", "*抽泣*不——不要农场，主人....拜托，除了那个以外什么都可以！"])
    add_dialogue("gizel take girl to farm", ("meek", "holy", "prude", "easy"), ("呃....这个看起来很弱啊。我会开始准备复活咒语，以防万一。"))

    add_dialogue("girl introduction", ("meek", "very sub"), ["你-明白了！ [girl.fullname]，很高兴认识你。", "我-我明白...[girl.fullname]。我会照我说的去做。", "是-是的，听你的命令。我的名字是主人 [MC.name] 的 [girl.fullname]。"])
    add_dialogue("slave thanks", ("meek", "very modest", "very sub"), ("*脸红*谢谢您，主人。", "*脸红*哦，主人太仁慈了....", "*脸红* 我、我不值得这样的善意，主人...."))
    add_dialogue("slave effusive thanks", ("meek", "very modest", "very sub"), ("*脸红*我、我不知道该说什么...太感谢你了，主人！", "谢谢你所做的一切，主人。这真让我振奋。", "谢谢您，主人....每当和您在一起时，我就开始感觉....真的很幸福...."))
    add_dialogue("slave positive reaction", ("meek", "very modest", "very sub"), ("*脸红* M、主人....你太善良了....", "谢谢，主人。", "*脸红*我不值得这样的善意，主人。"))
    add_dialogue("slave negative reaction", ("meek", "very sub"), ("主人、主人....是我行为不当吗？", "*呜咽*我让您失望了吗，主人？", "*呜咽*哦，主人...请告诉我我应该做什么..."))
    add_dialogue("slave whining", ("meek", "sweet", "superficial", "pet", "tsundere"), ("*呜咽*呜呜.... ", "*呜咽* M-主人...", "*抽泣*但-但是..."))
    add_dialogue("slave strongly refuse", ("meek", "very modest", "very sub"), ("*抽泣*不、不....请怜悯，主人....", "*呜咽*啊啊！！ M主人...", "*抽泣* N-不是这样的..."), sound=s_screams)
    add_dialogue("slave bullied", ("meek", "sweet", "pet", "tsundere", "loyal"), ("*呜咽*呜呜.... ", "*抽泣*是-是的，主人...", "*抽泣*我-我明白了，主人..."))
    add_dialogue("slave apology", ("meek", "very modest", "very sub"), ("主人、主人....实在抱歉....", "*抽泣*请原谅我，主人。", "*呜咽*噢，主人....请原谅我！"))
    add_dialogue("slave hit", ("meek", "very sub"), ["对不起... *抽泣*"])
    add_dialogue("slave positive fixation accept", ("meek", "very modest", "very sub"), ["哦，主人....这太令人兴奋了....","*咯咯*主人...我喜欢...", "嗯....我喜欢这个，主人...."])
    add_dialogue("slave negative fixation accept", ("meek", "very modest", "very sub"), ["*呜咽*但-但是主人...我们必须这样做吗？","*噘嘴*我-我不喜欢这样，主人...", "拜、请温柔一点，主人....", "我、如果我必须的话，主人...."])
    add_dialogue("slave negative fixation refuse", ("meek", "very modest", "very sub"), ["*噘嘴*但——但我不是那种女孩，主人。","*噘嘴*不-不，主人...我不能这样做..."])

    add_dialogue("slave first visit", ("meek", "very sub"), ("主人....请多多关照...."))
    add_dialogue("MC kind promise", ("meek", "very sub"), ["她跪在你的脚边。","g: 谢谢您，主人....您是个好人。"], multiple=True, love=2, fear=-3)
    add_dialogue("MC fair promise", ("meek", "very sub", "masochist"), ["g: 呃-呃...但是主人...我是你的奴隶，不是吗？", "她似乎对你公平对待她的承诺感到有点困惑。"], multiple=True, fear=-1)
    add_dialogue("MC no promise", ("meek", "very sub"), ["她挺直了背，看到你表现得如此强势，看上去有些松了口气。","g: 是-是的，先生...我明白。你是我的主人。"], multiple=True, love=1, fear=1)
    add_dialogue("MC harsh promise", ("meek", "very sub"), ("她点点头，泪水无声地顺着脸颊流下。"), love=-3, fear=4)
    add_dialogue("MC break promise", ("generic", "very introvert", "very idealist", "very modest", "very sub"), ("但-但你...你答应过事情会有所不同...*抽泣*"), love=-7, fear=1)
    add_dialogue("MC fight intro", ("meek", "very sub"), ("她看起来很震惊，但她不敢违抗你。"), sound=s_scream_loud)
    add_dialogue("slave fear intro", ("meek", "repressed", "holy", "prude"), ("当她哭泣时，她的身体抽搐，因为害怕见到你。你的话无法传达给她。"))
    add_dialogue("slave fear reassure success", ("meek"), ("当你擦去她脸上的泪水时，她会暂时停止哭泣。她凝视着你的眼睛，脸上带着困惑的表情。"), love=1, fear=-2)
    add_dialogue("slave fear reassure failure", ("meek"), ("你靠近她的时间越长，她的哭声就越大。你决定等她平静下来后再回来。"), fear=-1)
    add_dialogue("slave fear discipline", ("meek", "generic", "very introvert", "very sub"), ("你握紧拳头，直接打在她脸上。她痛苦地哭泣，然后从你身边爬开，非常害怕。血从她的鼻子里流下来，在她身后的地板上留下一道痕迹。"), fear=1)

    add_dialogue("slave naked request permanent", ("meek", "very modest", "very sub"), ["她看起来对你的请求感到不安，但还是接受了你的命令。", "g: 我、如果这是你对我的期望，我就会这么做。"], multiple=True, fear=2, sound=s_sigh)
    add_dialogue("slave naked request accept", ("meek", "very sub"), ["她脸红了，鞠躬。", "g: 我-如果你真的认为我应该...我会为你做这件事，主人。"], multiple=True, sound=s_ahaa)
    add_dialogue("slave naked request resist", ("meek", "very modest"), ["她本能地试图用手遮住自己的身体。", "g: *喘气* M-主人！我不能这么做....这太不正常了...."], multiple=True, love=-2, fear=-3)
    add_dialogue("slave toggle naked on", ("meek", "very modest", "very sub"), ["她看起来对你的请求感到不安，但还是接受了你的命令。", "g: 我、如果这是你对我的期望，我就会这么做。"], multiple=True, love=-1)
    add_dialogue("slave toggle naked off", ("meek", "very modest", "very sub"), ["她看上去松了口气。", "g: 谢谢您，主人。"], multiple=True, love=1)
    add_dialogue("slave train beg", ("meek", "very modest", "very sub"), ("*呜咽*不、不，不是这样....请怜悯，主人....", "*呜咽*啊啊！！主人....请不要....", "*呜咽* N-不是那个，请主人..."))
    add_dialogue("slave discipline beg", ("meek", "very sub", "very idealist"), ["她害怕地蜷缩起来，用手捂住头。", "啊啊！！ *抽泣*请——请怜悯，主人...."], multiple=True)
    add_dialogue("slave beg proceed", ("meek", "pet"), ("*呜咽*呜呜.... ", "*呜咽* M-主人...", "*抽泣*但-但是..."), love=-1, fear=-1)
    add_dialogue("slave beg warning", ("meek", "very sub", "holy", "creep", "easy"), ["明白了，主人！", "我、我明白了，主人。我会照我说的去做。", "是、是的，我明白了，主人。"], fear=2, sound=s_sigh)
    add_dialogue("slave beg give up", ("meek", "very sub", "very idealist"), ("*呜呜*主人....你太善良了....", "谢谢，主人。", "我、我不值得如此仁慈，主人。"), love=1, fear=-2, sound=s_surprise)
    add_dialogue("slave send to master bedroom love +", ("generic", "very introvert", "very idealist", "very modest", "very sub"), ["当她听到你的话时，她高兴得浑身发抖。", "g: 噢，主人，我太高兴了....*脸红*"], multiple=True)
    add_dialogue("slave send to master bedroom love", ("generic", "very introvert", "very idealist", "very modest", "very sub"), ["她微笑着鞠躬。", "g: 谢谢，谢谢主人。"], multiple=True)
    add_dialogue("slave send to master bedroom love -", ("generic", "very introvert", "very idealist", "very modest", "very sub"), ["她看上去不太自在，但还是恭敬地鞠了一躬。", "g: 如果这就是您想要的，主人。"], multiple=True)
    add_dialogue("slave send to master bedroom fear +", ("generic", "very introvert", "very idealist", "very modest", "very sub"), ["当她听到你的声音时，她会害怕得发抖。", "g: 我...我会...主人..."], multiple=True)
    add_dialogue("slave send to master bedroom fear", ("generic", "very introvert", "very idealist", "very modest", "very sub"), ["她太害怕你而不敢不服从。", "g: 我...噢...好吧..."], multiple=True)
    add_dialogue("slave send to master bedroom fear -", ("meek", "very sub"), ["她叹了口气，撅起嘴。", "g: 噢....如果我必须的话，主人。"], multiple=True)
    add_dialogue("slave leave master bedroom love +", ("generic", "very introvert", "very idealist", "very modest", "very sub"), ["她的眼睛里充满了泪水。", "g: 主人，不要让我离开....我想和你在一起！"], multiple=True)
    add_dialogue("slave leave master bedroom love", ("meek", "very sub"), ["她看起来很失望。", "g: 明白了，主人....我是不是做错了什么？"], multiple=True)
    add_dialogue("slave leave master bedroom love -", ("meek", "very modest", "very sub"), ["她看起来很想回到自己的房间。", "g: 如您所愿，主人。"], multiple=True)
    add_dialogue("slave leave master bedroom fear +", ("generic", "very introvert", "very idealist", "very modest", "very sub"), ["她松了一口气。", "g: 噢、当然了，主人....谢谢....谢谢...."], multiple=True)
    add_dialogue("slave leave master bedroom fear", ("meek", "very sub"), ["她看起来很紧张，笨拙地向你鞠躬。", "g: 遵命，主人。"], multiple=True)
    add_dialogue("slave leave master bedroom fear -", ("meek", "very introvert"), ("她点点头，一言不发地跑回自己的房间。"))

    add_dialogue("slave chat slave_life -2", ("meek", "very sub", "holy", "sweet", "repressed"), ["她的眼睛里充满了泪水，看上去很绝望。", "g: 我...我不知道我在这里做什么...这一定是一个可怕的错误...*抽泣*"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life -1", ("meek", "very modest"), ["她看起来悲伤而失败。", "g: 没有人愿意成为奴隶...."], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0", ("meek", "very sub", "very extravert"), ["她鞠躬。", "g: 做你的奴隶也不错，主人。还有更糟糕的事情可能发生在我身上。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0.5", ("meek", "very introvert"), ["她握紧双手，微笑着。", "g: 嗯....我没什么可抱怨的，主人。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 1", ("meek", "very sub", "sweet", "easy"), ["她跪下并深深鞠了一躬。", "g: 主人，我喜欢做你的奴隶！和你在一起的生活比我能想到的要好得多。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 2", ("meek", "very sub", "sweet", "easy"), ["她用崇拜的眼神看着你。", "g: 主人，我喜欢做你的奴隶！和你在一起的生活比我能想到的要好得多。"], multiple=True, unlock="DS")
    add_dialogue("slave chat brothel -2", ("meek", "very modest"), ["显然你提出了一个令人痛心的话题，她立即泪流满面。", "g: *哭*哦，太可怕了，主人....太可怕了！"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel -1", ("meek", "very modest", "very idealist"), ["她的眼里涌出泪水。", "g: *呜咽*哦，这个地方太糟糕了，主人....我不属于这里...."], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0", ("meek", "very modest", "very idealist"), ["她的眼里涌出泪水。", "g: 呃....我、我睡不着，主人。我的房间里有蟑螂！"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0.5", ("meek", "very modest", "very idealist"), ["她紧张地用手指梳理着头发，微笑着。", "g: 你、你看到我的房间了吗，主人？我一直在装修..."], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel virgin", ("meek", "very modest", "very introvert"), ["她看起来很紧张。", "g: 呃、呃，这个地方不错....但、但我还是觉得我不属于这里，主人。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 1", ("meek", "generic", "very extravert", "very idealist", "very lewd", "very dom"), ["她笑得合不拢嘴。", "g: 哦，主人....我感觉就像在家里一样！"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 2", ("meek", "generic", "very extravert", "very idealist", "very lewd", "very dom"), ["她冲动地亲吻你的脸颊，笑得合不拢嘴。", "g: 我喜欢这里，主人。我感觉就像在家里一样！"], multiple=True, unlock="LM")
    add_dialogue("slave chat customers -2", ("meek", "very materialist"), ["她握紧拳头，咬住嘴唇。", "g: 那些、那些渣男....我很讨厌他们。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers -1", ("meek", "very introvert"), ["她叹了口气，看上去很沮丧。", "g: 不、不....他们总是欺负我。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 0", ("meek", "very introvert"), ["她交叉双臂，撅起嘴。", "g: 不、不完全是，主人。我宁愿一个人呆着。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 0.5", ("generic", "very introvert", "very lewd", "very sub"), ["她虚弱地笑了笑。", "g: 我想他们还不错。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 1", ("meek", "very idealist"), ["她微笑着点点头。", "g: 他们真的很好而且很体贴。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 2", ("meek", "very lewd"), ["她似乎欣喜若狂。", "g: 我们相处得很好！如果可以的话，我很乐意免费为他们提供服务。"], multiple=True, unlock="MI")
    add_dialogue("slave chat other_girls -2", ("generic", "very introvert", "very modest", "very sub"), ["她无声地流泪，然后突然泪流满面。", "g: 我恨他们！我不想和他们有任何关系..."], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls -1", ("meek", "very introvert"), ["她看上去很不高兴。", "g: 我一个都不喜欢。我希望人们别打扰我。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 0", ("meek", "very sub", "very introvert"), ["她低下头。", "g: 他们中的大多数人对我都很刻薄....我想这是可以预料到的。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 0.5", ("meek", "very introvert"), ["她看起来很沉思。", "g: 我比较独来独往，但我想有些女孩还不错。我真的没有时间和他们一起出去玩。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 1", ("meek", "very sub", "very introvert"), ["她给你一个害羞的微笑。", "g: 有些女孩比其他女孩更友善。我不介意和他们一起出去玩。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 2", ("meek", "very introvert", "very idealist"), ["她看起来很高兴。", "g: 这里的女孩们就像家人一样。有时我们会争吵、打架，但我们会互相支持。我感到开心。"], multiple=True, unlock="EI")
    add_dialogue("MC praise friend", ("meek", "very sub"), ("谢谢你，主人。我很高兴你能批准。"), sound=s_laugh)
    add_dialogue("MC demean rival", ("meek", "very idealist"), ("*喘气*你-你不应该说那样的话！我希望我们能和睦相处。"), sound=s_evil_laugh)
    add_dialogue("slave chat well_being -3", ("meek", "very sub"), ["她看起来有自杀倾向。", "g: *呜咽*我-我不能再这样下去了...我想我不会活太久了，主人。", "g: 我想知道天堂会是什么样子......"], multiple=True, unlock="MI")
    add_dialogue("slave chat well_being -2", ("meek", "very sub", "very introvert"), ["她看起来很沮丧。", "g: *呜咽*我好累....", "g: 我只想一个人呆着，主人。"], multiple=True, unlock="MI")
    add_dialogue("slave chat well_being -1", ("meek", "very introvert"), ["她看起来很悲伤。", "g: 我只是希望我能有一些隐私，仅此而已。"], multiple=True, unlock="MI")
    add_dialogue("slave chat well_being 0", ("meek", "very sub", "very introvert"), ["她似乎对你的兴趣感到惊讶。", "g: 当然！你为什么要问？"], multiple=True, unlock="MI")
    add_dialogue("slave chat well_being 1", ("meek", "very introvert"), ("不用担心我，主人。我很好。"), unlock="MI")
    add_dialogue("slave chat well_being 2", ("meek", "very extravert"), ["她开始跳舞和唱歌。", "g: {i}我仍然很享受昨晚！啊啊啊！{/i}", "这首歌似乎是现场即兴创作的。", "g: {i}所以一切都好！啊啊啊！{/i}", "她以屈膝礼结束了她的例行公事。", "mc: 那好吧。下次简单地说“是”就可以了。"], multiple=True, unlock="MI")
    add_dialogue("slave chat well_being 3", ("meek",  "generic", "very extravert", "very idealist", "very materialist"), ["她笑得合不拢嘴。", "g: 我感觉很好，主人。从来没有这么好过！"], multiple=True, unlock="MI")
    add_dialogue("slave chat well_being attacked", ("meek", "very sub", "very modest"), ["她看起来有自杀倾向。", "g: *呜咽*不，当然不是....", "g: 我一直被攻击，主人。这不是活路。"], multiple=True)
    add_dialogue("slave chat well_being sick", ("generic", "very modest", "very sub"), ["她看起来很悲伤。", "g: *叹气*我不确定我的身体还能承受多少。这个地方比贫民窟的排水沟还脏。"], multiple=True)
    add_dialogue("slave chat well_being exhausted", ("meek", "very introvert"), ["她看起来很沮丧。", "g: 我想我还好。我只是太累了！我需要更多独处的时间。"], multiple=True)
    add_dialogue("slave chat well_being MC apology", ("meek", "very sub", "very idealist"), ("谢谢你，主人。我知道你会让事情变得正确。"))
    add_dialogue("slave chat feelings love -1", ("meek", "very sub"), ("*抽泣* W-你想听什么，主人？"), unlock="DS")
    add_dialogue("slave chat feelings love 0", ("meek", "very sub"), ("你、你是主人....我该怎么说呢？"), unlock="DS")
    add_dialogue("slave chat feelings love 1", ("generic", "very idealist", "very materialist", "very modest", "very sub"), ("我觉得我们相处得很好，不是吗？"), unlock="DS")
    add_dialogue("slave chat feelings love 2", ("generic", "very idealist", "very materialist", "very modest", "very sub"), ("能和你在一起我感到很幸运。"), unlock="DS")
    add_dialogue("slave chat feelings fear -1", ("generic", "very idealist", "very materialist", "very modest", "very sub"), ("你有时可能会有点不讲道理。"), unlock="DS")
    add_dialogue("slave chat feelings fear 0", ("meek", "very sub"), ("我知道最好不要质疑你的命令。"), unlock="DS")
    add_dialogue("slave chat feelings fear 1", ("meek", "very sub"), ("我真的希望我们能和睦相处，所以我会尽力听从你的命令。"), unlock="DS")
    add_dialogue("slave chat feelings fear 2", ("meek", "very sub"), ("我知道反抗你只会让事情变得更糟。我会照你说的做。"), unlock="DS")
    add_dialogue("slave chat feelings very disobedient", ("meek", "very sub", "very materialist"), ["她开始哭泣。", "g: *呜呜*这总是与{i}你{/i}有关...你应该更加考虑{i}我{/i}的感受。"], multiple=True, unlock="DS")
    add_dialogue("slave chat feelings disobedient", ("meek", "very sub"), ["她开始哭泣。", "g: *抽泣*我很抱歉，我不知道我应该如何回应。"], multiple=True, unlock="DS")
    add_dialogue("slave chat feelings a little obedient", ("meek", "very sub"), ("我-您有什么具体想听的吗？"), unlock="DS")
    add_dialogue("slave chat feelings obedient", ("generic", "very modest", "very sub"), ("我很高兴我们相处得很好，主人。"), unlock="DS")
    add_dialogue("slave chat feelings very obedient", ("generic", "very modest", "very sub"), ("很高兴为您服务，主人。"), unlock="DS")
    add_dialogue("slave chat tastes likes", ("meek", "loyal", "helper", "masochist", "prude"), "嗯....[best]相当不错。这也是我母亲最喜欢的[thing_cn]。但我更愿意讨论另一个话题。", unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("meek", "very sub"), "[thing_cn][worst]让我感到毛骨悚然！我还是不明白为什么...", unlock="LM")
    add_dialogue("slave chat tastes loves +", ("generic", "very modest", "very sub"), ("啊....我一直很喜欢[thing_cn]，就像我妈妈一样。这么说是不是很奇怪？"), unlock="LM")
    add_dialogue("slave chat tastes loves -", ("meek", "very sub"), ("我想我喜欢[thing_cn]，但我还没有完全探索所有选项。"), unlock="LM")
    add_dialogue("slave chat tastes no loves", ("meek", "very sub", "very idealist"), ("你不需要给我买任何礼物。花时间在一起并相处就是我想要的。"), unlock="LM")
    add_dialogue("slave chat tastes hates", ("meek", "very idealist"), ("当我小的时候，我看到两个妓女为了一些事情而打架。从那以后我就讨厌它了。"), unlock="LM")
    add_dialogue("slave chat tastes no hates", ("meek", "very idealist"), ("重要的不是礼物，而是想法。我真的是这个意思。"), unlock="LM")
    add_dialogue("slave chat tastes positive act", ("meek", "nerd", "very modest"), ("我想知道...我们有关于 [act_desc] 的书吗？"), unlock="LM")
    add_dialogue("slave chat tastes negative act", ("meek", "very modest"), ("[act_desc] 有一些令人不安的地方，你不这么认为吗？"), unlock="LM")
    add_dialogue("slave chat tastes no negative act", ("meek", "very modest"), ("任何事情都是公平的，只要它能让你满足你的伴侣。是不是这样？"), unlock="LM")

    add_dialogue("slave chat origins 1", ("very sub", "meek", "helper", "pet", "loyal"), ("我在[girl.origin]长大。尽管如此，我想我现在还在成长。"), unlock="EI")
    add_dialogue("slave chat origins 2", ("meek", "very modest"), ("我们在 [girl.origin] 有自己的 [a_home]。我的[girl.story_guardian]非常严格。"), unlock="EI")
    add_dialogue("slave chat origins 3", ("meek", "very modest", "very sub"), ("在我的老家，一个古老的[girl.story_home]，有一次我把卧室的一堵墙漆成粉红色。我的[girl.story_guardian]很生气，把我打得不省人事....你认为我活该吗？"), unlock="EI")
    add_dialogue("origin Zan", ("meek", "very introvert"), ["g: 在像泽恩这样的大城市，找到并珍惜那些可以让自己与世隔绝的地方很重要。", "g: 每当我的[girl.story_guardian]喝醉时，我总是躲在港口的一座桥下。"], multiple=True)
    add_dialogue("origin the border with the Holy Lands", ("meek", "very idealist"), ("圣地里有太多的苦难。这不是一个养育孩子的好地方。尽管如此，我的[girl.story_guardian]还是用我们收到的牌做了一切能做的事情。"))
    add_dialogue("origin the Blood Islands", ("generic", "very modest", "very sub"), ["g: 关于血腥群岛的事越少越好....这是一个残酷无情的地方。", "g: 有一次，他们让一群手无寸铁的奴隶在竞技场上对抗一群鬣狗。我仍然记得当时的尖叫声。这是压垮我和我的[girl.story_guardian]的最后一根稻草。"], multiple=True)
    add_dialogue("origin Karkyr", ("meek", "very introvert"), ["g: 卡克尔的一切都被魔法污染了。这听起来可能很有趣，但它很快就会过时。", "g: 想象一下：你正在和你的[girl.story_guardian]一起吃晚饭。你想问他们今天过得怎么样，但墙壁长了眼睛，桌布开始飞扬，餐具尖叫着侮辱你。每个糟糕透顶的日子。"], multiple=True)
    add_dialogue("origin Westmarch", ("meek", "very sub"), ("在威斯特玛公国，叛乱司空见惯，以至于我的[girl.story_guardian]每隔几周就会侍奉一位新主人。我想这就是为什么我讨厌冲突，即使是现在。"), multiple=True)
    add_dialogue("origin the desert of Hokoma", ("meek", "very idealist"), ["g: 我的[girl.story_guardian]因调解不同部落之间的冲突而在霍科马颇有名气。", "g: 参观那些紧密团结的社区是我对沙漠最怀念的。 Xeros 的其他地方没有类似的东西。"], multiple=True)
    add_dialogue("origin Borgo, the port city", ("meek", "very sub", "very introvert"), ("博尔戈有它的问题，但我深情地回顾我在那里的时光。我的 [girl.story_guardian] 一直在照顾我，保护我免受家门口严酷现实的影响。"), multiple=True)
    add_dialogue("origin the Goliath desolations", ("meek", "very modest", "very sub"), ["g: 你很快就会学会如何应对在歌利亚荒凉中所面临的困难。我们每天都必须为取暖和食物而奋斗。", "g: 这与泽恩这里的生活完全不同。即使是穷人也能享受这样的奢侈！我希望我的 [girl.story_guardian] 能在这里看到它。"], multiple=True)
    add_dialogue("origin the Arik mountains", ("meek", "very modest", "very idealist"), ["g: 我的[girl.story_guardian]非常了解阿里克山脉。我们甚至还一起爬过几座山峰。", "g: 景色难以形容。我真的很想有一天回到那里。"], multiple=True)

    add_dialogue("slave train accepted", ("meek", "very sub"), ["如您所愿，主人。", "主人你说什么都行。", "好的，主人...", "遵命，主人。"])
    add_dialogue("slave train resisted", ("meek", "very modest", "very sub"), ["*抽泣*但-但是...主人...", "D-你真的希望我这么做吗？", "您真的希望我这么做吗，主人？", "我-我不确定我是否能做到这一点......"])
    add_dialogue("slave train refused", ("meek", "very modest", "very sub"), ["*抽泣*哦，主人...我很抱歉...我不能！", "*呜咽*哦，主人....我做不到！请原谅我！", "能、能再给我解释一下基础知识吗，主人？", "*呜咽* M-也许我们可以先谈谈，主人？"])
    add_dialogue("slave lecture love", ("very sub", "masochist", "meek", "helper", "pet", "loyal"), ("我很高兴有你作为我的主人，[MC.name]主人。"))
    add_dialogue("slave lecture neutral", ("very sub", "masochist", "meek", "helper", "pet", "loyal"), ("谢谢您抽出时间来教我，主人。"))
    add_dialogue("slave lecture fear", ("very sub", "masochist", "meek", "helper", "pet", "loyal"), ("*抽泣*请-请教我，主人。"))
    add_dialogue("slave lecture refuses", ("meek", "very modest", "very sub"), ("*哭*哇啊啊！！你、你为什么要教我这个？！"))
    add_dialogue("slave lecture very reluctant", ("meek", "very modest"), ("*呜咽*你-你为什么要教我{i}那个{/i}？！"))
    add_dialogue("slave lecture reluctant", ("meek", "very modest"), ("我简直不敢相信....这太尴尬了！"))
    add_dialogue("slave lecture a little reluctant", ("meek", "very sub"), ("原来如此....只要快点结束就好了...."), sound=s_sigh)
    add_dialogue("slave lecture indifferent", ("meek", "very sub"), ("、、这么说来....如果女人闭上眼睛跟着就可以吗？"))
    add_dialogue("slave lecture a little interested", ("meek", "very sub", "very introvert"), ("啊哈....这样的事我大概能忍受吧。"), sound=s_surprise)
    add_dialogue("slave lecture interested", ("meek", "very modest", "very sub"), ("我懂了。谢谢你，主人。"), sound=s_mmh)
    add_dialogue("slave lecture very interested", ("meek", "very sub", "very introvert"), ("有趣的！谢谢你，主人。"), sound=s_mmh)
    add_dialogue("slave lecture fascinated", ("meek", "very sub", "very introvert"), ("M-master...请告诉我更多关于[act_desc]的信息。"), sound=s_aah)
    add_dialogue("slave train obedience", ("meek", "very sub", "very extravert"), ["[girl.name]一边工作一边安静地给自己唱歌。" ,"g: *唱* {i}嗡嗡嗡....扫帚发出清脆的声音....如果我们保持青楼清洁，没有人会刻薄....{/i}"], multiple=True)
    add_dialogue("slave train constitution", ("meek", "very sub"), ("是的主人。马上！"))
    add_dialogue("slave train refuses", ("meek", "very sub"), ("我不能那样做！ *哭泣*"), sound=s_screams)
    add_dialogue("slave train very reluctant", ("meek", "very sub", "very introvert"), ("*抽泣*请-请停止..."), sound=s_scream)
    add_dialogue("slave train reluctant", ("meek", "very modest", "very sub"), ("*抽泣* W-为什么..."), sound=s_scream)
    add_dialogue("slave train a little reluctant", ("meek", "very sub", "very introvert"), ("呼、还要多久...."), sound=s_surprise)
    add_dialogue("slave train indifferent", ("meek", "very sub", "very introvert"), ("主人，你想对我做什么就做什么吧。"), sound=s_ahaa)
    add_dialogue("slave train a little interested", ("meek", "very sub"), ("哦、好吧....你可以这样使用我的身体...."), sound=s_ahaa)
    add_dialogue("slave train interested", ("meek", "very modest", "very sub"), ("*脸红* 嗯...[MC.name]主人..."), sound=s_mmh)
    add_dialogue("slave train very interested", ("meek", "very modest", "very sub"), ("谢谢你，主人。"), sound=s_aah)
    add_dialogue("slave train fascinated", ("meek", "very sub", "very introvert"), ("主人....我爱你...."), sound=s_orgasm_fast)
    add_dialogue("slave train naked failure", ("generic", "very modest", "very sub"), ("S-停止..."), sound=s_surprise)
    add_dialogue("slave train naked success", ("meek", "very modest", "very sub"), ("D、这让你高兴吗？"), sound=s_aah)
    add_dialogue("slave train service failure", ("meek", "very modest"), ("她完全脱离了这一切。你告诉她停下来。"))
    add_dialogue("slave train service success", ("generic", "very introvert", "very idealist", "very modest", "very sub"), ("嗯....好吃...."))
    add_dialogue("slave train sex failure", ("meek", "very lewd"), ("好痛....主人，你快结束了吗？"))
    add_dialogue("slave train sex success", ("meek", "very idealist"), ("对不起....我喷了很多...."))
    add_dialogue("slave train anal failure", ("meek", "very modest"), ("啊，好痛....*抽泣*"))
    add_dialogue("slave train anal success", ("meek", "very sub", "very introvert"), ("谢谢你，主人。那太好了。"))
    add_dialogue("slave train fetish failure", ("meek", "very sub", "very idealist"), ("*抽泣*你-你在欺负我..."))
    add_dialogue("slave train fetish success", ("meek", "very sub", "very materialist"), ("啊啊啊！！我想要更多，主人！"))
    add_dialogue("slave train bisexual failure", ("meek", "very introvert", "very idealist"), ("对不起，希露，不是你...."))
    add_dialogue("slave train bisexual success", ("meek", "very extravert", "very idealist"), ("呃....我爱你！"), sound=s_mmh)
    add_dialogue("slave train group failure", ("meek", "very modest", "very sub"), ("*抽泣*这-这太过分了..."))
    add_dialogue("slave train group success", ("generic", "very modest", "very sub"), ("啊啊....那是神圣的...."))
    add_dialogue("slave magic obedience success", ("generic", "very modest", "very sub"), ("你是我的主人。你掌握着钥匙。"), sound=s_ahaa)
    add_dialogue("slave magic libido success", ("generic", "very modest", "very sub"), ("我能感觉到....好温暖....嗯...."), sound=s_mmh)
    add_dialogue("slave magic sensitivity success", (), ("取悦别人，就是取悦自己...."), sound=s_mmh)
    add_dialogue("slave magic naked success", ("generic", "very modest", "very sub"), ("我必须透露....更多...."), sound=s_ahaa)
    add_dialogue("slave magic service success", ("generic", "very modest", "very sub"), ("使用我...为了快乐..."), sound=s_mmh)
    add_dialogue("slave magic sex success", ("generic", "very modest", "very sub"), ("我的子宫....向你敞开...."), sound=s_aah)
    add_dialogue("slave magic anal success", ("generic", "very modest", "very sub"), ("哦，我的混蛋....太热了....拜托，想个办法把火扑灭...."), sound=s_ahaa)
    add_dialogue("slave magic fetish success", ("generic", "very modest", "very sub"), ("啊啊！我感觉虚弱..."), sound=s_aah)
    add_dialogue("slave magic bisexual success", ("generic", "very modest", "very sub"), ("我应该和女神成为一体...."), sound=s_mmh)
    add_dialogue("slave magic group success", ("generic", "very modest", "very sub"), ("为一个人服务就是为多人服务..."), sound=s_ahaa)
    add_dialogue("slave magic failure", ("meek", "very sub", "very introvert"), ["g: 主人....这是怎么回事？这是什么？啊....我感觉恶心....", "她差点晕倒，你派希露去给她拿点水。你离开了，想知道你这次搞砸了什么。"], multiple=True, sound=s_scream, unlock="DS")

    add_dialogue("slave reward sex accepted", ("meek", "very sub"), ("谢谢你，主人。你太客气了。"), sound=s_ahaa, unlock="LM")
    add_dialogue("slave reward sex resisted", ("meek", "very sub", "very extravert"), ("但、但是....我不想....你要....强迫我吗？"), sound=s_surprise, unlock="LM")
    add_dialogue("slave reward sex refused", ("meek", "very modest", "very sub"), ("所以你现在要强奸我吗？ *哭泣*"), sound=s_scream)
    add_dialogue("slave reward praise", ("meek", "very modest", "very sub"), ("我很感激，主人。"), love=1, unlock="MI")
    add_dialogue("slave reward gold", ("meek", "very sub"), ("哦好的..."), love=-1, unlock="MI")
    add_dialogue("slave reward pet", ("meek", "very sub"), ["g: 谢谢您，主人....您太了解我了。", "当你抚摸她时，她把脸埋在你的胸口，轻轻地呻吟。"], multiple=True, love=2, unlock="DS")
    add_dialogue("slave reward day off", ("meek", "very sub"), ("哦...你不想让我在这里吗？ *哭泣*"), love=-2, unlock="DS")
    add_dialogue("slave reward day off KO", ("generic",  "very introvert", "very materialist", "very modest", "very sub"), ("是的，我知道...你已经告诉过我了。"))
    add_dialogue("slave punish scold deserved", ("meek", "very sub"), ("*抽泣*请停止对我大喊大叫......"), fear=1, unlock="MI")
    add_dialogue("slave punish scold undeserved", ("meek", "very sub", "very idealist"), ("*抽泣*你为什么要这么刻薄？"), love=-1, unlock="MI")
    add_dialogue("slave punish upkeep", ("meek", "very sub", "very idealist"), ("我明白了，主人。"), unlock="MI")
    add_dialogue("slave punish upkeep KO", ("meek", "very sub", "very idealist"), ("主人你还好吗？"))
    add_dialogue("slave punish beat", ("meek", "very sub"), ("啊啊！你实在是太伤我心了！ *哭泣*"), fear=1, sound=s_screams, unlock="DS")
    add_dialogue("slave punish farm", ("meek", "very sub"), ("*抽泣*T-农场？！我想你可能是对的...如果你想要的话我就去那里。"), fear=-1, unlock="DS")
    add_dialogue("slave punish naked", ("meek", "very sub", "very introvert"), ("但、但每个人都会盯着看....他们会打扰我...."), fear=2, unlock="LM")
    add_dialogue("slave punish naked KO", ("generic",  "very introvert", "very materialist", "very modest", "very sub"), ("*噘嘴*哈哈，真是有趣的主人......"))
    add_dialogue("slave punish rape", ("meek", "very modest", "very sub", "very idealist"), ("*抽泣*你是个邪恶的人......"), fear=1, unlock="LM")
    add_dialogue("slave raped", ("very modest", "meek", "holy", "repressed", "prude"), ["g: *哭*哇啊！！", "她很难受。"], multiple=True, sound=s_screams)
    add_dialogue("slave rape positive fixation", ("meek", "very sub"), ["g: 谢谢您，主人。", "mc: 我的荣幸！你很少会因强奸某人而受到感谢。"], multiple=True, love=2, sound=s_aah)
    add_dialogue("slave rape negative fixation", ("meek", "very modest", "very sub"), ["g: *哭*哇啊！！", "她在地板上抽搐。你担心这件事可能对她造成了创伤。"], multiple=True, love=-3, fear=5, sound=s_scream_loud)

    add_dialogue("rest", ("meek", "very sub", "very introvert"), ("我会在我的房间里，主人。 {w=1.0}{nw}"))
    add_dialogue("accept job", ("meek", "very sub", "very materialist"), ("当然。我将成为一名{b}[girl.job_cn]{/b}。{w=1.0}{nw}"))
    add_dialogue("work_whore", ("meek", "very sub", "very materialist"), ("当然，我不介意。除了成为一名{b}[girl.job_cn]{/b}之外，我还将为客户提供服务。{w=1.0}{nw}"))
    add_dialogue("exhausted", ("meek", "very sub", "very materialist"), ("*叹气*我大便了...我会尽快恢复成为一名{b}[girl.job_cn]{/b}。"))
    add_dialogue("rank up", ("meek", "very modest", "very sub"), ("我想我在这方面做得越来越好..."))
    add_dialogue("refuse whoring", ("meek", "meek", "very introvert"), ("但、但是....*抽泣*"))
    add_dialogue("refuse sex act", ("meek", "very modest", "very sub"), ["*抽泣*哦，主人...我很抱歉...我不能！", "*呜咽*哦，主人....我做不到！请原谅我！", "能、能再给我解释一下基础知识吗，主人？", "*呜咽* M-也许我们可以先谈谈，主人？"])

    add_dialogue("bought", ("meek", "very sub", "very introvert"), ("N-很高兴认识你..."))
    add_dialogue("freed", ("meek", "very sub"), ("哦-好吧...如果你认为这是最好的..."))
    add_dialogue("sold", ("meek", "very introvert"), ("哦，我懂。那么久违了，主人。"))
    add_dialogue("sold love", ("meek", "very sub"), ("*抽泣*我会想念你的..."), sound=s_surprise)
    add_dialogue("leave for quest", ("meek", "very sub", "very introvert"), ("我有点紧张....我很快就会回来的，主人！"))
    add_dialogue("leave for class", ("meek", "very sub", "very introvert"), ("啊!我应该快点....不想迟到！"))
    add_dialogue("advertise", ("meek", "very introvert"), ["请、请来我们的青楼参观....","E-享受[brothel.name]的服务...", "今晚来找我吧..."])

    add_dialogue("beach intro", ("meek", "very introvert"), ["距离人群很远，[girl.fullname]正在看着水中反射的太阳。"], sound=s_laugh)
    add_dialogue("beach meet MC", ("meek", "very modest"), ["g: 哦，[MC.name]主人！我没看到你来...", "她本能地用毛巾遮住自己，表现出谦虚的样子。", "mc: 算了，没什么可瞒着我的。", "g: ..."], multiple=True)
    add_dialogue("beach oiling", ("meek", "very modest"), ["哦...这很好，但是你能不能别碰我那么近...啊啊！"], sound=s_ahaa)
    add_dialogue("beach accept oiling", ("meek", "very modest"), ["主人，你、你在做什么....这里不是....呜呜...."])
    add_dialogue("beach refuse oiling", ("meek", "very modest"), ["啊啊！！我....我想我可能对这些东西过敏...."])
    add_dialogue("beach accept public sex", ("meek", "very modest"), ["哦，好的...."])
    add_dialogue("beach refuse public sex", ("meek", "very introvert"), ["*抽泣*但-但是...每个人都在看着我们..."])
    add_dialogue("beach accept sex", ("meek", "very modest", "very sub"), ["*脸红*是的！我们应该这样做。"])
    add_dialogue("beach refuse sex", ("meek", "very modest", "very sub"), ["哦，我休息日吗？ *哭泣*"])
    add_dialogue("beach whoring request", ("meek", "very modest", "very sub"), ["我、我今天不是休息吗？"])
    add_dialogue("beach whoring accept", ("meek", "very modest", "very sub"), ["哦，好的...."])
    add_dialogue("beach whoring refuse", ("meek", "very modest", "very sub"), ["*抽泣*我以为我今天不必这样做......"])

## START SWEET DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("sweet", "helper", "loyal"), ("嘿，我是[girl.fullname]。我们以前见过么？"), love=1)
    add_dialogue("free_greetings_casual", ("sweet", "helper", "loyal", "pet", "holy", "class president"), ("*微笑*哦，我的名字是[girl.fullname]。我怎样能帮到你？", "哦，嗯...我可以帮你吗？我的名字是[girl.fullname]。 *微笑*"), love=2)
    add_dialogue("free_greetings_rude", ("sweet", "pervert", "helper", "pet"), ("亲，你是不是精力充沛啊？我是[girl.fullname]。"))

    add_dialogue("free_small_talk", ("sweet", "pervert", "repressed"), ("我想....我其实也正想说同样的话。", "这并不重要，不是吗？"), max_cap=25)
    add_dialogue("free_gossip", ("sweet", "pervert", "helper", "generic", "meek", "cold"), ("你听说过吗？听听这个..."), love=1, max_cap=25)
    add_dialogue("free_chat_life", ("sweet", "helper"), ("我不相信命运，但我相信，只要你努力做好人，人们就会报答你。 *微笑*", "其实我对别人的感受很敏感。所以当我看到别人微笑时，我自己也会忍不住微笑。当他们难过的时候，我会尽我最大的努力让他们开心起来！ *微笑*"), love=2, max_cap=25)
    add_dialogue("free_chat_love", ("sweet", "helper"), ("爱情就是这么混乱。一定要和男生一起吗？", "我爱我的家人和朋友，但我猜你的意思是别的？", "爱？嗯....让我想起阳光，在公园里牵着手，分享快乐的回忆....诸如此类的事情！"), love=1, max_cap=25)
    add_dialogue("free_chat_origins", ("sweet", "repressed"), ("*微笑* 啊，[girl.origin] 的生活是如此简单。", "*微笑*我希望我能回到[girl.origin]的那些日子。", "我的家人来自[girl.origin]。我们很高兴...那时的生活更简单。"), love=2, max_cap=40)
    add_dialogue("free_chat_hobbies", ("sweet", "helper", "loyal"), ("嗯....我喜欢童话故事，总有一个美好的结局。 [hobby]也挺好玩的。", "大多数时候我很忙很忙......但我尝试为[hobby]腾出一些时间。", "当我[hobby]的时候，时间过得真快。"), max_cap=40)
    add_dialogue("free_chat_likes", ("very extravert", "helper", "creep"), ("啊，我最喜欢的[thing_cn]？我最喜欢]。", "最喜欢的[thing_cn]？这是一次千钧一发的机会，但我不得不说[best]就是最好的。 *微笑*"), love=1, max_cap=40)
    add_dialogue("free_chat_dislikes", ("sweet", "helper"), ("我不喜欢[thing_cn][worst]。我很好奇人们在其中看到了什么。我肯定错过了什么！", "我不喜欢[worst]这样的[thing_cn]。对我来说似乎很平淡。也许我有什么问题？ *傻笑*"), love=2, max_cap=40)

    add_dialogue("free_joke_harmless", ("sweet", "pet"), ("哦，你...", "我叔叔想要那个。", "我要把这件事告诉我的祖母。"), love=-1, max_cap=50)
    add_dialogue("free_joke_adult", ("sweet", "helper"), ("*咯咯*这有点肮脏，不是吗？", "*笑*男孩子怎么知道这么多黄色笑话？"), love=3, max_cap=50)
    add_dialogue("free_joke_dark", ("sweet"), ("*微笑*这很奇怪！", "*咯咯*你不能就这样说，不是吗？"), love=3, max_cap=50)
    add_dialogue("free_joke_mean", ("very idealist"), ("What the... Stop it! *生气*"), love=-1, max_cap=50)

    add_dialogue("free_touch_hand", ("sweet", "meek", "superficial", "helper", "loyal", "princess"), "这种感觉...真好...", love=2, max_cap=90)
    add_dialogue("free_touch_kiss", ("sweet", "meek", "nerd", "loyal", "repressed", "pet", "class president"), ["当她热情地回吻你时，你们的舌头交缠在一起.", "g: 嗯... 啊..."], multiple=True, love=1, max_cap=90)
    add_dialogue("free_touch_ass", ("sweet", "pervert", "helper", "loyal", "meek"), ("*咯咯笑*你这个流氓！", "*笑*头晕！", "嗯嗯...", "哦...那很好。"), love=4, max_cap=90)
    add_dialogue("free_touch_breasts", ("sweet", "pet"), ("你总是试图抓住我的胸部。是因为你喜欢他们吗？", "什、为什么你一直想抓我的胸部？"), love=1, max_cap=90)
    add_dialogue("free_touch_pussy", ("sweet", "loyal", "superficial"), ("*脸红*什-什么？！突然间这是怎么回事？", "*脸红* 别-别碰我那么多，我有点紧张！", "*脸红*什么....？！你-你让我很惊讶...", "啊!", "*脸红*哎呀！"), love=2, max_cap=90)

    add_dialogue("free_play refuses", ("sweet", "helper"), ("不、不，我不会那样做的！"), love=-1)
    add_dialogue("free_play very reluctant", ("sweet", "helper"), ("*喘气*我做不到！也许如果你能慢慢来并向我展示它是如何完成的......"), love=1)
    add_dialogue("free_play reluctant", ("sweet", "helper"), ("嗯...有点吓人但是...好吧。我会做的。"), love=2)
    add_dialogue("free_play a little reluctant", ("sweet", "helper"), ("*叹气*好吧，我加入了。但我们必须小心，不要被抓住。"), love=2)
    add_dialogue("free_play indifferent", ("sweet", "helper"), ("嗯...好吧，我并不是不喜欢它，所以...好吧。"), love=3)
    add_dialogue("free_play a little interested", ("sweet", "helper", "pet"), ("周围有人....我、我对此没意见。你？ *傻笑*"), love=4)
    add_dialogue("free_play interested", ("sweet", "loyal", "pet"), ("*脸红*当然！我正想问你呢！"), love=4)
    add_dialogue("free_play very interested", ("sweet", "helper", "loyal", "pet"), ("*咯咯*我很高兴你问。我完全同意！"), love=5)
    add_dialogue("free_play fascinated", ("sweet"), ("嗯....是的！我变成这样的性狂都是你的错，你有责任让我满意！"), love=5)
    add_dialogue("MC take virginity", ("sweet"), ("*脸红*我和你一起做的每一件事对我来说都是第一次，包括这个......"), love=5)
    add_dialogue("free_play interested after", ("sweet", "helper"), ("啊....真是太有趣了！感觉绝对棒极了。"))
    add_dialogue("free_play not interested after", ("sweet"), ("嗯，我不明白......这对我没有任何作用。"))

    add_dialogue("free_flirt_beauty", ("sweet", "loyal", "class president"), ("真的吗？我觉得不是特别漂亮...", "你在说什么？", "别再这样盯着了！你让我难堪。", "别那么用力地盯着我看。我开始感到尴尬了。",  "你看太多了。越来越尴尬了"), love=-2, max_cap=75)
    add_dialogue("free_flirt_body", ("sweet", "helper"), ("你在开玩笑吧？我什至不记得上次锻炼是什么时候了。", "别再这样盯着了！你让我难堪。", "哦快停下！你让我难堪！", "嘿-嘿！女孩可以知道你在看哪里，你知道的！", "*叹气*你只是觉得不羞耻，是吗？", "被、被这样盯着看真是太丢人了！"), max_cap=75)
    add_dialogue("free_flirt_mind", ("sweet", "nerd"), ("终于有人在乎我的智慧，而不只是我的外表了!"), love=3, max_cap=75)
    add_dialogue("free_flirt_spirit", ("sweet", "rebel", "helper", "loyal", "pet"), ("嘿，这很贴心！我觉得自己在你身边放松了戒备..."), love=2, max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("sweet"), ("她笑了，伸出舌头。","威尔，如果你告诉我你的秘密，我就会告诉你我所有的肮脏秘密。 *眨眼*"), love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("sweet"), ("嗯，这是个好问题。我自己也有一些经验，但这不是我可以吹嘘的。"), love=2)
    add_dialogue("free_flirt_sex_experience average", ("sweet"), ("呃，有些女孩对这些事情很开放，但我宁愿把它留给自己。"), love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("sweet"), ("不太....直到最近我才真正对那些东西感兴趣。"))
    add_dialogue("free_flirt_sex_experience very inexperienced", ("sweet"), ("不！说实话，我从来没有和一个男人如此亲密过。"), love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("sweet"), ("不！绝不！说实话，我从来没有和一个男人如此亲密过。"), love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("very idealist"), ("真的吗?亲爱的，我们就像灵魂伴侣..."), love=3)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("sweet"), ("嗯....我想重要的是想法。"), love=2)

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("sweet", "helper"), ("嘿，现在！ *悲伤*你平时的虚张声势去哪儿了？这就是我欣赏你的地方。"))
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("sweet", "helper"), ("是的，我一点也不相信....而你试图对此撒谎的事实让我担心。"), love=-1)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("sweet"), ("我可以同情...仍在寻找那个特别的人，Zan方式。 *眨眼*"), love=3)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("sweet"), ("*笑*我可以坐在这里听你吹嘘几天。你就像积极思考的源泉！"), love=1)
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("sweet"), ("是的，我一点也不相信....而你试图对此撒谎的事实让我担心。"))
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("sweet"), ("啊，对了，我忘了....*悲伤*好吧，这让情绪低落。"), love=-1)
    add_dialogue("free_flirt_sex_act very reluctant", ("sweet", "helper"), ("别再试图让我难堪了。我们聊点别的吧！"))
    add_dialogue("free_flirt_sex_act reluctant", ("sweet", "helper"), ("你们谈论的都是性、性、性。我们暂时谈谈别的事情吧。"))
    add_dialogue("free_flirt_sex_act a little reluctant", ("sweet", "helper"), ("嗯...直到最近我才对那些东西真正感兴趣。"))
    add_dialogue("free_flirt_sex_act indifferent", ("sweet", "helper"), ("我明白这个想法，但我自己还没有尝试过。我很好奇它是什么样的。"), love=1)
    add_dialogue("free_flirt_sex_act interested", ("sweet", "helper"), ("哦，我刚刚和我的一个朋友谈论这个。如果有人给我上一堂速成课那就太好了。"), love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("sweet", "helper"), ("啊，原来你也有那些奇怪的幻想？ *傻笑*"), love=2)
    add_dialogue("free_flirt_sex_act very interested", ("sweet", "helper"), ("*咯咯笑*光是想想就觉得很有趣。"), love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("sweet", "helper", "nerd"), ("*脸红*哦，我想不出别的了。真是令人兴奋。诚实的！"), love=3)

    add_dialogue("free_give_gold +++", ("sweet", "helper"), ("谢谢你！如果我对你来说很特别，那就很重要了！"), love=4, max_cap=75)
    add_dialogue("free_give_gold ++", ("sweet", "helper"), ("谢谢你，但我真的更感兴趣的是花时间在一起。"), love=3, max_cap=75)
    add_dialogue("free_give_gold +", ("sweet", "helper", "loyal"), ("你不必...好吧，无论如何，谢谢！"), love=1, max_cap=75)
    add_dialogue("free_give_gold -", ("sweet", "helper", "loyal", "class president"), ("我该怎么办？我对你的钱不感兴趣。"), love=-1, max_cap=75)
    add_dialogue("free_give_gold --", ("sweet"), ("我是什么，你的妓女？在这里我以为我们有联系！"), love=-1, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("sweet"), ["g: 等等....你不会是认真的吧？！", "g: *哭*哦，这太可怕了...为你工作我能得到什么？", "mc: 我会保护你，给你住宿和固定工资...", "g: 我该怎么办...."], multiple=True, love=2)
    add_dialogue("free_offer_job half_lie", ("sweet"), ["g: 你什么？我不敢相信我竟然信任你！ *哭泣*", "g: 哦，这太可怕了....我最后的希望破灭了....我为你工作能得到什么?", "mc: 我会保护你，给你住宿和固定工资...", "g: 我该怎么办?你是认真的吗?"], multiple=True, love=-2)
    add_dialogue("free_offer_job lie", ("very idealist"), ["g: 你说什么?", "g: 你他妈的骗子!!我怎么能相信你!!! *哭喊*", "g: 哦，这太可怕了....我最后的希望破灭了....我为你工作能得到什么?", "mc: 我会保护你，给你住宿和固定工资...", "g: 我该怎么办?你是认真的吗?"], multiple=True, love=-4)
    add_dialogue("free_offer_job success", ("very idealist"), ["g: 好吧，我会照你说的做。反正我也没办法了...", "g: 我是你的人了.带我走吧."], multiple=True)
    add_dialogue("free_offer_job thinking", ("sweet"), ["g: 我永远不会...一定有别的办法！", "g: *呜咽*请给我一些时间考虑一下。", "g: 她低着头离开。"], multiple=True)
    add_dialogue("free_offer_job failure lie", ("sweet", "helper"), ["g: 我不敢相信你甚至建议这是一个可行的选择。就好像你根本不认识我一样！", "g: 哼！如果你认为我会成为你的小妓女，那你就有另一件事了！", "g: 我现在很生你的气！", "她擦干眼泪，气冲冲地走了。"], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("sweet"), ["g: 我不敢相信你甚至建议将此作为一种选择。就好像你根本不认识我一样！", "g: 哼！如果你认为我会成为你的妓女之一，那你就有另一种想法了！", "g: 我现在很生你的气！", "她擦干眼泪，气冲冲地走了。"], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("sweet"), ["g: 噢，那破坏了气氛。你就不能找到更好的事情做吗？", "mc: 我为自己的工作感到自豪。我知道这听起来可能很肮脏，但我想你会感到惊讶....青楼为这个世界贡献了很多积极性和爱。", "g: 也许我判断得太快了。我现在并没有做出太多贡献......*悲伤*"], multiple=True)
    add_dialogue("free_friend half_lie", ("sweet"), ["g: 哇，你就像我今天遇到的第七个[MC.playerclass]。我不想重复那些谈话，如果你同意的话。", "mc: 好吧。那我们来谈谈你吧。", "g: 啊，其实没什么可说的...."], multiple=True, love=-2)
    add_dialogue("free_friend lie", ("sweet"), ["g: 你可不是每天都能听到这样的话！我很想听听这个职业的来龙去脉。", "mc: 当然！但首先，我们来谈谈你。", "g: 啊，其实没什么可说的...."], multiple=True, love=2)

    add_dialogue("free_love_interest", ("sweet"), ["mc: 嗨，[girl.name]。你低头一看，这不像你！", "g: 啊....没什么。我刚刚看到几对情侣在这个可爱的[season]日子里依偎在一起......", "g: 这让我感到有点孤独....我很高兴你现在在这里。", "g: 你听说过吗....男孩给女孩送花是为了告诉她们喜欢她们。这是一个多么甜蜜的举动，不是吗？", "mc: 是的，我想是...."], multiple=True)
    add_dialogue("free_girl get_flowers", ("sweet"), ("这很浪漫....他们很可爱！"))
    add_dialogue("free_ask_out", ("sweet"), ["mc: [girl.name]，我喜欢你。你能做我女朋友吗？", "g: 你真的想让我...做你的女朋友吗？", "mc: 是的，我愿意。", "g: 哦，这让我很高兴！当然！", "她扑进你的怀抱，给你一个又长又深的吻.", "g: 我现在得走了....不过我们很快就会再见面的，亲爱的！ *眨眼*"], multiple=True)

    add_dialogue("free_girlfriend intro", ("sweet"), ["g: 哦，[MC.name]！我一直在等你，亲爱的...", "mc: 嗨，亲爱的。美好的一天，不是吗？", "g: 当然！现在我们在一起就像阳光变得更加明亮。 *傻笑*", "g: 但是听着，我想问你一件事。"], multiple=True)
    add_dialogue("free_girlfriend right", ("sweet"), ("*咯咯笑*你是对的，当然！过来吧。"), love=5)
    add_dialogue("free_girlfriend give_up", ("sweet"), ("不？哦，好吧... *皱眉*"), love=-5)
    add_dialogue("free_girlfriend wrong", ("sweet"), ["g: 我以为你比那更了解我。 *皱眉*", "mc: 哦，抱歉...."], multiple=True, love=-10)
    add_dialogue("free_girlfriend success", ("sweet"), ["她把衣服扔到地上，给你一个温暖的拥抱。", "g: 你兴奋吗？我知道我是。", "你可以感觉到你的阴茎变得勃起。她注意到了这一点，并隔着衣服抚摸着你的阴茎。", "g: 哦哦...就是这样...*咯咯*"], multiple=True)
    add_dialogue("free_girlfriend success naked", ("sweet"), ["她把衣服扔到地上，给你一个温暖的拥抱。", "g: 我觉得我终于可以在你身边做我自己了。", "g: 你兴奋吗？我知道我是。", "你可以感觉到你的阴茎变得勃起。她注意到了这一点，并隔着衣服抚摸着你的阴茎。", "g: 哦哦...就是这样...*咯咯*", "g: 如果你愿意的话，你也可以丢掉衣服。", "g: 这可能听起来很奇怪，但就我个人而言，无论在哪里，我总是会赤身裸体。"], multiple=True)

    add_dialogue("free_job_request", ("very idealist"), ["g: Oh, [MC.name]. 你不会碰巧知道一种又快又有效的赚钱方法吧?", "mc: 好吧，我可能有方法....怎么回事?", "g: 是学校。我必须以某种方式支付学费才能继续在那里学习，但现在我所有的积蓄都花光了。", "g: 如果我找不到快速赚钱的方法，我就会辍学，失去受教育的机会...", "她看起来很担心.", "mc: 也许有个办法....灵活的工作时间等等。不过，你可能不会喜欢它.", "g: 拜托，为了继续学习我什么都愿意做。这对我很重要."], multiple=True)
    add_dialogue("gizel take girl to farm", ("sweet"), ("啊，新鲜的荡妇！他们眼中闪烁着光芒。我永远不会厌倦看到它消失。"))

    add_dialogue("girl introduction", ("generic"), ("你好。我是[girl.fullname]。", "嗨，我是[girl.fullname]。很高兴认识你..."))

    add_dialogue("slave effusive thanks", ("generic"), ["哦谢谢！太感谢了！", "哦，我真是太感激了！谢谢你！"])
    add_dialogue("slave apology", ("generic"), ["对不起，主人，我不是故意的....", "对不起，我不应该...", "对不起，主人。不会再发生了...", "我不是故意的....对不起。"])
    add_dialogue("MC break promise", ("very idealist"), ("你...你答应过要好好对待我...*抽泣*你撒谎了！"), love=-8, fear=3)
    add_dialogue("slave naked request permanent", ("sweet"), ("哈哈....很高兴，主人！当我上前为他们服务时，除了微笑，什么也没穿，我非常喜欢他们脸上的表情！它真可爱！ *咯咯笑*"), love=2, fear=-1, sound=s_sigh)
    add_dialogue("slave naked request accept", ("sweet"), ["她恳求地看着你。你可以从她的眼中看到恐惧。", "g: Master，这真是太难受了....", "g: ....他们会看到我的身体，Master！我{i}真的{/i}不想这样做！我什至不记得上次锻炼是什么时候了！", "mc: 你的身体很漂亮！你应该学会适应它。", "mc: 你有一个可爱、阳光的性格，这给来这里的男人带来了很多欢乐。想象一下，当你裸体时，它会带来多少快乐！", "哦，主人。我想我会让顾客看到我的身体...我希望他们会喜欢它。 *她微笑着并试图显得勇敢*", "mc: 那是我的女儿！现在你去上班吧。他们会喜欢你甜美年轻的身体。", "你轻轻拍打她的屁股。"], multiple=True, love=1, sound=s_ahaa)
    add_dialogue("slave naked request resist", ("sweet"), ["她恳求地看着你。你可以从她的眼中看到恐惧。", "g: Master，这真是太难受了....", "g: ....他们会看到我的身体，Master！我{i}真的{/i}不想这样做！我什至不记得上次锻炼是什么时候了！", "她拒绝裸体。"], love=-3, fear=-2)

    add_dialogue("slave toggle naked off", ("sweet", "loyal"), ["g: 好吧，主人....我去穿衣服。", "你认为她看起来有点失望。"], multiple=True)
    add_dialogue("slave chat slave_life 0.5", ("sweet", "very sub"), ["她笑了。", "g: 我喜欢这里，主人。我感到....安全。我不知道如果我有空我会做什么..."], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 2", ("very idealist"), ["她微笑着向你鞠躬。", "g: 哦，我感觉像小鸟一样自由，主人。如果没有您的指导，我会感到被这个社会束缚和奴役。"], multiple=True, unlock="DS")
    add_dialogue("slave chat customers -2", ("very idealist"), ["她看上去悲伤又沮丧。", "g: 我讨厌他们对待我的方式！我尽我最大的努力去服务，但他们却不断地伤害和虐待我...... "], multiple=True, unlock="MI")
    add_dialogue("slave chat customers -1", ("very idealist"), ["她看起来很沮丧。", "g: 他们对待我就像对待牛一样。我明白，每个人都有自己的难处，但为什么他们要把问题发泄到我身上呢？"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 0", ("very idealist"), ["她叹了口气。", "g: 我想，顾客有好有坏....不友好的顾客可能会非常粗鲁。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 0.5", ("very idealist"), ["她微微一笑。", "g: 他们总是向我倾诉他们的家庭、他们的艰辛、他们破碎的心....我想我可以提供帮助，即使必须以这种奇怪的方式。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 1", ("very idealist"), ["她心情轻松起来。", "g: 噢，顾客们，他们就像我的朋友一样！我们越亲密，我就越了解他们，也越了解我自己。这是一种养育关系。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 2", ("very idealist"), ["她脸上洋溢着自豪的笑容。", "g: 我很高兴能够帮助顾客忘记他们的痛苦和烦恼！我真的很喜欢为他们服务....我会尽一切努力让他们开心。"], multiple=True, unlock="MI")
    add_dialogue("slave chat other_girls -2", ("very extravert"), ["她看上去既生气又不高兴。", "g: 交朋友？你认为我有时间做这些吗，当我被困在这个恶心的牢房里时，所有的家务事都堆积如山！"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls -1", ("very extravert"), ["她看起来很沮丧。", "g: 我没有时间和其他女孩说话，而且我不喜欢她们。我希望有机会结交朋友。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 0", ("very extravert"), ["她皱眉.", "g: 有些女孩比其他女孩更好。但我确信有人在背后对我说坏话。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 0.5", ("very extravert"), ["她想了一会儿.", "g: 我有时间去见其他女孩并和她们聊天。我不能说我拥有令人惊叹的社交生活，但这只是一个开始。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 1", ("very extravert"), ["她笑了。", "g: 我很高兴我在这里并不孤单。这里的大多数人都很好，真的！"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 2", ("very extravert"), ["她给你一个温暖而幸福的微笑。", "g: 和其他女孩在一起真是太好了！我们一起出去玩，我们一起做所有事情，甚至...... *脸红*无论如何，我爱他们！"], multiple=True, unlock="EI")
    add_dialogue("slave chat tastes likes", ("very extravert", "helper", "creep"), ("啊，我最喜欢的[thing_cn]？我最喜欢]。", "最喜欢的[thing_cn]？这是一次千钧一发的机会，但我不得不说[best]就是最好的。 *微笑*"), unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("sweet", "helper"), ("我不喜欢[thing_cn][worst]。我很好奇人们在其中看到了什么。我肯定错过了什么！", "我不喜欢[worst]这样的[thing_cn]。对我来说似乎很平淡。也许我有什么问题？ *傻笑*"), unlock="LM")
    add_dialogue("slave chat origins 1", ("sweet", "repressed"), ("*微笑* 啊，[girl.origin] 的生活是如此简单。", "*微笑*我希望我能回到[girl.origin]的那些日子。", "我的家人来自[girl.origin]。我们很高兴...那时的生活更简单。"), unlock="EI")
    add_dialogue("slave reward sex resisted", ("sweet", "very sub"), ("噢，我不想那样做！请你想想别的办法吧！"), love=-1, sound=s_surprise, unlock="LM")
    add_dialogue("slave reward gold", ("sweet", "very modest"), ("谢谢主人。我会好好利用这个。"), unlock="MI")
    add_dialogue("slave punish scold deserved", ("very idealist"), ["她看起来被你的评论深深伤害了。", "g: 我知道，我必须做得更好....对不起。"], multiple=True, fear=1, unlock="MI")
    add_dialogue("slave punish scold undeserved", ("very idealist"), ["她看起来被你的评论深深伤害了。", "g: 那不是真的...我正在尽力！"], multiple=True, love=-2, fear=1, unlock="MI")
    add_dialogue("slave punish upkeep", ("very idealist"), ("如果我必须....那就这样吧。"), fear=-1, unlock="MI")
    add_dialogue("slave punish naked", ("very modest"), ("不！！！你以为你在做什么！！！"), unlock="LM")

## START SUPERFICIAL DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("superficial", "masochist", "sweet", "bimbo", "holy", "schemer", "easy"), ("天啊，我没想到会在这里遇到一个真正的绅士! *嘲笑* 我是 [girl.fullname]. 很高兴见到你"), love=1)
    add_dialogue("free_greetings_casual", ("superficial", "pervert", "bimbo", "creep", "princess", "yandere"), ["g: 你在想什么，这样来找我?你就不能想出更有创意的点子吗?", "g: 我的名字是[girl.fullname].现在，走开."], multiple=True)
    add_dialogue("free_greetings_rude", ("superficial", "bimbo", "helper", "creep", "yandere", "generic", "pet", "cold"), ("噢,嗨。我是 [girl.fullname]."), love=2)

    add_dialogue("free_small_talk", ("superficial", "pervert", "rebel", "sweet", "tsundere"), ("我们能谈谈一些更有趣的事情吗？","*打哈欠* ...抱歉，我有点困了。","...好吧，如果你不需要什么东西，我就真的离开了。","呃，我今天其实不想再跟你说话了。再见！", "哇，时间过得真快！再见！","下次我们就彻底解决这个问题吧。之后！","抱歉，我今天有{i}很多{/i}要做，你知道吗？","抱歉，我现在太忙了。","哦。好吧，当然，那就是，完全没问题，无论如何。","嗯，我现在确实没什么可对你说的，所以..."), max_cap=25)
    add_dialogue("free_gossip", ("superficial", "pervert", "rebel", "bimbo", "helper", "prude", "princess", "pet"), ("你没听说吗?我有一些有趣的八卦要告诉你!"), love=3, max_cap=25)
    add_dialogue("free_chat_life", ("superficial", "pervert", "cold", "bimbo", "creep", "yandere", "masochist", "pet", "rebel"), ("哦，我不知道。这是什么问题啊?"), max_cap=25)
    add_dialogue("free_chat_love", ("superficial", "bimbo"), ("{i}可爱。{/i}我的意思是，这就是字面上的“我”，你知道吗？", "我的意思是它比仅仅喜欢某件事要严肃得多，你知道吗？"), love=1, max_cap=25)
    add_dialogue("free_chat_origins", ("superficial", "rebel", "bimbo" ), ("我来自[girl.origin]。那里实在是太无聊了。", "我来自[girl.origin]。我决定尽快搬到泽恩。", "我很高兴我们能够从 [girl.origin] 搬到 Zan。 [girl.origin] 简直就是一个屎坑。"), love=2, max_cap=40)
    add_dialogue("free_chat_hobbies", ("superficial", "pervert", "yandere"), ("喜欢[hobby]的人都非常性感。", "嗯，我的意思是，我是个女孩，所以....显然我喜欢[hobby]。","嗯，我怎么可能不喜欢[hobby]呢？","我，就像，完全是[hobby]类型！"), love=1, max_cap=40)
    add_dialogue("free_chat_likes", ("superficial", "sweet", "bimbo"), ("嗯，我的意思是，我是个女孩，所以....显然我喜欢[thing_cn]。特别是[best]。","嗯，我怎么可能不喜欢[best]呢？没有其他[thing_cn]可以与之相媲美。","就[thing_cn]而言，我完全是[best]类型！"), love=1, max_cap=40)
    add_dialogue("free_chat_dislikes", ("superficial", "rebel", "bimbo" ), ("嗯，如果[worst]是你最喜欢的[thing_cn]，我真的不想被看到和你在一起，所以......", "我朋友现在就面临这样的情况。她最喜欢的[thing_cn]是[worst]，我想....嗯....不怎么样？！友谊结束了。", "实际上，我并不喜欢[worst]的[thing_cn]。"), max_cap=40)

    add_dialogue("free_joke_harmless", ("superficial", "pervert", "sweet", "holy"), ("我们能谈谈一些更有趣的事情吗？","*打哈欠* ...抱歉，我有点困了。","...好吧，如果你不需要什么东西，我就真的离开了。","呃，我今天其实不想再跟你说话了。再见！", "哇，时间过得真快！再见！","下次我们就彻底解决这个问题吧。之后！","抱歉，我今天有{i}很多{/i}要做，你知道吗？","抱歉，我现在太忙了。","哦。好吧，当然，那就是，完全没问题，无论如何。","嗯，我现在确实没什么可对你说的，所以..."), love=-1, max_cap=50)
    add_dialogue("free_joke_adult", ("superficial", "pervert", "bimbo", "easy", "yandere"), ("天哪，你现在很{i}热{/i}吗？也许只是我一个人......我感觉很饥渴！","为什么和你说话{i}这么有趣{/i}？ *傻笑*", "天哪，这太有趣了！我真的很想再听一遍！"), love=3, max_cap=50)
    add_dialogue("free_joke_dark", ("superficial", "cold", "pet", "bimbo"), ("Wow, that was dark... Lighten up, will you! *皱眉*", "嗯，热点提示？这对我来说不太好。"), love=-1, max_cap=50)
    add_dialogue("free_joke_mean", ("superficial", "bimbo", "helper", "prude", "masochist"), ("就像....我知道这是错的，但这让它{i}如此{/i}有趣，明白我的意思吗？","为什么和你说话{i}这么有趣{/i}？ *傻笑*", "天哪，这太有趣了！我想再听一遍！"), love=3, max_cap=50)

    add_dialogue("free_touch_hand", ("superficial", "pervert", "bimbo", "yandere"), ("嗯，我有说过我们可以牵手吗？","天哪，快放手吧！","原谅你？！先征求许可怎么样？", "{i}粗鲁{/i}。我，就像，快要生气了，好吗？","好吧，我想让你读一下我的嘴唇，好吗？不！"), max_cap=90)
    add_dialogue("free_touch_kiss", ("superficial", "rebel", "sweet"), ("*亲吻*我非常喜欢你！", "嗯，你到底在做什么？哈哈，天啊，我开玩笑的！但你悲伤的样子很可爱！ *吻*","嗯，所以如果你喜欢我的嘴唇，你就会{i}喜欢{/i}我的其他部分。"), love=1, max_cap=90)
    add_dialogue("free_touch_ass", ("superficial", "pervert", "bimbo"), ("嗯...那么如果你继续这样呢？我要{i}实际上{/i}亲吻你！","啊...你现在很{i}热{/i}吗？也许只是我一个人......我感觉很饥渴！","嗯....如此感人实际上让我{i}超级{/i}饥渴。"), love=4, max_cap=90)
    add_dialogue("free_touch_breasts", ("superficial", "pervert", "bimbo", "princess", "pet"), ("啊...这对我来说真的很激烈...我很兴奋！", "啊啊啊....能带头的家伙吗？非常热。", "呀呀！当你去那里时，我非常{i}喜欢{/i}！", "*呻吟*好吧！想要我现在就裸体吗？哈哈天哪，开玩笑吧！"), love=5, max_cap=90)
    add_dialogue("free_touch_pussy", ("superficial", "rebel", "masochist", "pet"), ("啊！！嗯，对不起！进去有点太超前了，你不觉得吗？", "啊...比如，{i}这里{/i}？到处都是人！", "听着，我知道你很喜欢我，但下次请先征得我的同意。", "*呻吟*你真的知道如何掌控一切，不是吗？","*呻吟*你渴吗？"), love=2, max_cap=90)

    add_dialogue("free_play refuses", ("superficial", "rebel", "nerd", "bimbo", "creep", "easy"), ("嗯，{i}这里{/i}？决不。我们为什么不等一会儿没有人在的时候再忙呢？"), love=-1)
    add_dialogue("free_play very reluctant", ("superficial", "pervert", "rebel", "nerd", "schemer", "princess", "tsundere", "class president", "stubborn"), ("嗯，认真的吗？好吧....但你必须尊重我的界限，好吗？"), love=1)
    add_dialogue("free_play reluctant", ("superficial", "nerd", "masochist", "sweet", "helper"), ("你和我的波长不同，但没关系。"), love=2)
    add_dialogue("free_play a little reluctant", ("superficial", "sweet", "schemer", "loyal", "stubborn", "bimbo"), ("好的。这次我完全愿意和你一起玩。"), love=2)
    add_dialogue("free_play indifferent", ("superficial", "very sub", "very introvert", "bimbo"), ("嗯，好吧。无论你喜欢什么。"), love=3)
    add_dialogue("free_play a little interested", ("superficial", "nerd", "bimbo"), ("好吧，那么现在呢？我很确定我们应该忙起来。"), love=4)
    add_dialogue("free_play interested", ("superficial", "pervert", "bimbo", "schemer", "loyal"), ("嗯....你先赤身裸体并闭上眼睛一秒钟怎么样？我只是在胡思乱想。"), love=4)
    add_dialogue("free_play very interested", ("superficial", "very lewd", "bimbo"), ("操，是的，我太兴奋了....我简直不敢相信我真的这么说了！我就是个荡妇！"), love=5)
    add_dialogue("free_play fascinated", ("superficial", "generic", "bimbo"), ("嗯...很高兴您能想到我的想法。"), love=5)
    add_dialogue("MC take virginity", ("superficial"), ("伙计们总是来找我。但我以前从来没有和他们一起走这么远......"), love=5)
    add_dialogue("free_play interested after", ("superficial", "pervert", "sweet", "bimbo", "easy"), ("那真是太有趣了！ {i}字面上{/i}迫不及待地想再次这样做！"))
    add_dialogue("free_play not interested after", ("superficial", "very extravert", "generic"), ("*生气* 嗯，你能{i}想想{/i}为什么我现在这么生气吗？"))

    add_dialogue("free_flirt_beauty", ("superficial", "helper", "easy", "class president", "tsundere", "loyal"), ("*脸红* 嗯...这有点尴尬，你的勃起从裤子里露出来了。"), max_cap=75)
    add_dialogue("free_flirt_body", ("superficial", "pervert", "bimbo", "tsundere", "easy"), ("天啊，这整个凝视的情况需要停止了！我现在{i}实际上{/i}很兴奋。","嗯，你确实意识到盯着它们不会让我给你看，对吧？无论如何，现在还不行。"), love=2, max_cap=75)
    add_dialogue("free_flirt_mind", ("superficial", "pervert", "cold", "creep", "princess", "pet", "bimbo"), ("嗯，我有点无聊。我们可以换个话题吗？"), love=-1, max_cap=75)
    add_dialogue("free_flirt_spirit", ("superficial", "meek", "sweet", "holy", "pet", "loyal"), ("哇谢谢你！","嗯，哇...就像...谢谢你这么说。"), love=2, max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("superficial", "very lewd"), ("呀呀呀呀，你知道的！迪克斯，就像，完全让我发疯。"), love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("superficial", "very extravert", "generic"), ("嗯，如果我告诉你所有这些，那就太多了！你这个变态！"), love=2)
    add_dialogue("free_flirt_sex_experience average", ("superficial", "very extravert", "generic"), ("嗯，哇....即使我知道了....那也是机密信息，好吗？！"), love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("superficial", "very extravert", "generic"), ("好吧，你能停止谈论性话题了吗？新话题！"))
    add_dialogue("free_flirt_sex_experience very inexperienced", ("superficial", "very extravert", "generic"), ("决不！说真的，我们可以{i}不{/i}谈论这个吗？我现在感觉很尴尬。"), love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("superficial", "very extravert", "generic"), ("所以，这个话题实际上让我感到{i}超级{/i}尴尬！我从来没有这样做过，好吗？"), love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("superficial", "pervert", "easy", "masochist"), ("哇你真的是认真的吗？那就超级尴尬了。"), love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("superficial", "cold", "bimbo", "princess"), ("你现在只是太过努力了。"), love=-2)

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("superficial", "rebel", "sweet", "bimbo", "helper", "easy"), ("嗯，可以吗？我想这就是，无论你喜欢什么，或者什么。"))
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("superficial", "rebel", "sweet", "bimbo", "helper", "easy"), ("嗯，哇，好吧。我很确定我们应该保持朋友关系。"), love=-1)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("superficial", "pervert", "sweet", "pet", "loyal"), ("嗯....甜甜的！就像，完全没问题，无论如何。"), love=3)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("superficial", "princess", "pet", "easy", "masochist"), ("哦，认真的吗？这太{i}太{/i}了！我很兴奋！"), love=3)
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("superficial", "very extravert", "very idealist"), ("我觉得{i}某人{/i}有点太自信了！"))
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("superficial", "very lewd"), ("好吧，这太令人兴奋了。我想，完全愿意来拜访，或者别的什么。"), love=3)

    add_dialogue("free_flirt_sex_act refuses", ("superficial", "very extravert"), ("怎么样，比如，不？就像，不可能？"))
    add_dialogue("free_flirt_sex_act very reluctant", ("superficial", "very extravert"), ("嗯，我不可能谈论这样的事情！"))
    add_dialogue("free_flirt_sex_act reluctant", ("superficial", "very extravert"), ("个人问题提醒？！我的意思是，也许？"))
    add_dialogue("free_flirt_sex_act a little reluctant", ("superficial", "very extravert", "very lewd"), ("嗯，是的，但是....等一下，你现在只是{i}完全{/i}想象我裸体，对吧？你这个荡妇！"))
    add_dialogue("free_flirt_sex_act indifferent", ("superficial", "very extravert", "very lewd"), ("哦，是的，我{i}完全{/i}感兴趣。什么，你以为我会吓坏什么的？"), love=1)
    add_dialogue("free_flirt_sex_act interested", ("superficial", "very extravert"), ("这真是太有趣了！我很喜欢！"), love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("superficial", "very extravert"), ("呀呀！太神奇了！"), love=2)
    add_dialogue("free_flirt_sex_act very interested", ("superficial", "very extravert"), ("呀呀！我非常喜欢它！"), love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("superficial", "generic"), ("*呻吟* 天啊，停下来！你会让我全身心都兴奋起来！"), love=3)

    add_dialogue("free_give_gold +++", ("very materialist", "princess", "bimbo", "superficial", "pervert"), ("呀呀！谢谢你呜呜！我喜欢被当作公主一样对待！"), love=8, max_cap=75)
    add_dialogue("free_give_gold ++", ("very materialist", "bimbo", "superficial", "pervert"), ("谢谢你呜呜！我喜欢一个男人想到我，你知道吗？"), love=5, max_cap=75)
    add_dialogue("free_give_gold +", ("very extravert", "very lewd", "superficial", "pervert"), ("我穿的内裤是{i}最好的{/i}。我会用这个来购买更多...想看看它们吗？ ...哈，PSYCH！"), love=3, max_cap=75)
    add_dialogue("free_give_gold -", ("very extravert", "superficial", "pervert"), ("嗯，{i}真的{/i}？任何。"), love=1, max_cap=75)
    add_dialogue("free_give_gold --", ("very materialist", "princess", "bimbo", "superficial", "pervert"), ("就是这样？哇，好吧。我现在很生气。"), love=-2, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("superficial", "very materialist"), ["她看上去很不高兴。", "g: 天哪，我不像个荡妇什么的....", "g: 但是....我现在完全可以用这笔钱。"], multiple=True, love=1)
    add_dialogue("free_offer_job half_lie", ("superficial", "very materialist"), ["g: 哦，认真的吗？！嗯，这太酷了，但为什么我是第一次听到呢？", "mc: 嗯，我不知道如何提出来......", "g: 所以，就像...并不是说我有兴趣或其他什么，但钱很好吗？"], multiple=True, love=1)
    add_dialogue("free_offer_job lie", ("superficial", "very materialist"), ["g: 哦，认真的吗？！嗯，这就像什么，但你为什么告诉我你是[girl.MC_lied]。", "mc: 嗯，我不知道如果我说实话你会如何接受......", "g: *叹气*呃，这太蹩脚了，你知道吗？你现在简直让我心烦意乱....", "g: 所以，就像...并不是说我有兴趣或其他什么，但钱很好吗？"], multiple=True)
    add_dialogue("free_offer_job success", ("superficial", "very extravert"), ["mc: 这是一项容易的工作。当然，我会在那里支持你。","g: 嗯，好的。我觉得你和我现在已经完全了解彼此了。", "g: 我想我其实很感兴趣。算我一个。"], multiple=True)
    add_dialogue("free_offer_job thinking", ("superficial", "very extravert"), ["mc: 这是一项容易的工作。当然，我会在那里支持你。","g: 嗯，好的。我觉得你和我现在已经完全了解彼此了。", "g: 我现在需要一些空间。我有{i}太多{/i}要考虑，你知道吗？"], multiple=True)
    add_dialogue("free_offer_job failure lie", ("superficial", "very extravert"), ["mc: 这是一项容易的工作。当然，我会在那里支持你。","g: 嗯，怎么样，比如，不？就像，不可能？无论如何，为什么我需要你的帮助才能张开双腿，你这个怪物。", "g: 我现在需要你离开我的脸。我有{i}太多{/i}要考虑，你知道吗？"], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("superficial", "very extravert"), ["mc: 这是一项容易的工作。当然，我会在那里支持你。","g: 嗯，怎么样，比如，不？就像，不可能？无论如何，为什么我需要你的帮助才能张开双腿，你这个怪物。", "g: 我现在需要你离开我的脸。我有{i}太多{/i}要考虑，你知道吗？"], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("superficial", "very extravert"), ["g: 哦？我完全在挖掘这一点。听起来你知道如何参加派对！", "mc: 你是做什么的?", "g: ....介意我们彻底换个话题吗？"], multiple=True, love=6)
    add_dialogue("free_friend half_lie", ("superficial", "very extravert"), ["g: 哦，那很酷或者怎么样。", "mc: 你是做什么的?", "g: 我？没关系，我们可以换个话题吗？"], multiple=True, love=-2)
    add_dialogue("free_friend lie", ("superficial", "very extravert"), ["g: 哦，那很酷或者怎么样。", "mc: 你是做什么的?", "g: 我？没关系，我们可以换个话题吗？"], multiple=True, love=-2)

    add_dialogue("free_love_interest", ("superficial"), ["mc: 嗨[girl.name]。这是美好的一天，不是吗？", "g: 嗯，我想...嘿，听着。我们完全应该找到一项可以一起做的新{i}活动{/i}。", "g: 我知道你很喜欢我。我已经完全忘记了这一切友谊之类的事情。我已经准备好接受更多了。", "g: 是时候认真起来或者离开了，你知道我的意思吗[MC.name]？", "g: 给我一些花，单膝下跪，做任何你必须做的事....我们应该完全{i}在一起{/i}。是的？", "mc: 嗯....我会考虑一下。"], multiple=True)
    add_dialogue("free_girl get_flowers", ("superficial"), ("天啊，这真是太浪漫了....你有什么话要对我说吗？"))
    add_dialogue("free_ask_out", ("superficial"), ["mc: [girl.name], 我喜欢你。让我们在一起.", "g: 天啊，是啊！  我很高兴您提出这个问题。我简直{i}渴望{/i}你约我出去。", "g: 我得去告诉我所有的朋友，就像现在一样。所以也许下次我们可以，比如....没关系！再见！"], multiple=True)

    add_dialogue("free_girlfriend intro", ("superficial"), ["g: 完美的时机，[MC.name]。", "g: 我和朋友们在温泉里，我们{i}完全{/i}陷入了关于我的身体或其他什么的争论。","g: 这个女孩告诉我，我的乳头看起来很奇怪，但我确信她实际上只是嫉妒你是我的男朋友。","g: 嗯，我想我的意思是我只是想让{i}你{/i}看到我。我感觉自己完全沉浸在其中，{i}在情感上{/i}。", "g: 但我又不是荡妇什么的，所以你为什么不先回答这个问题呢？"], multiple=True)
    add_dialogue("free_girlfriend right", ("superficial"), ("呀呀！我完全知道你会回答这个问题。你现在脸红的样子真是太可爱了。过来吧。"), love=5)
    add_dialogue("free_girlfriend give_up", ("superficial"), ("哇，我真的不能....嗯，抱歉，但我不能再和你在一起了？之后。"), love=-5)
    add_dialogue("free_girlfriend wrong", ("superficial"), ("哇，我真的不能....嗯，抱歉，但我不能再和你在一起了？"), love=-10)
    add_dialogue("free_girlfriend success", ("superficial"), ["她把衣服扔在地板上，双手抱住乳房。", "g: ...你盯着我看，我感到非常兴奋！所以你怎么看？", "她满怀期待地看着你。你感觉你的鸡鸡每一秒都变得更硬。", "mc: 你本来的样子就非常漂亮了，[girl.name]。", "g: 嗯，哇，你现在真是太饱了！好吧，我知道你喜欢我，但仍然如此。", "g: 我可以....摸摸它吗？"], multiple=True)
    add_dialogue("free_girlfriend success naked", ("superficial"), ["她把衣服扔在地板上，双手抱住乳房。", "g: ...你盯着我看，我感到非常兴奋！所以你怎么看？", "她满怀期待地看着你。你感觉你的鸡鸡每一秒都变得更硬。", "mc: 你本来的样子就非常漂亮了，[girl.name]。", "g: 嗯，哇，你现在真是太饱了！好吧，我知道你喜欢我，但仍然如此。", "g: 如果我们要住在同一个屋檐下，我会一直赤身裸体，所以你最好习惯一下。","g: 那我可以，比如....触摸它吗？"], multiple=True)

    add_dialogue("free_job_request", ("superficial"), ["g: 哦，[MC.name]。我什至不能。我现在非常需要你{i}听{/i}我的话，我{i}实际上{/i}吓坏了。", "mc: 这是什么，女孩？", "g: 所以，嗯...我和朋友们去购物时，一群暴徒{i}完全{/i}围住了我们并抢劫了我们。他们甚至拿走了我的珠宝！当他们强奸我的两个朋友或其他什么的时候，我设法逃跑了。", "g: 但现在我完全破产了，负债累累，我{i}所以{/i}现在无法处理这个问题！", "她开始歇斯底里地哭泣。", "mc: [girl.name]，冷静点，不会有事的...."], multiple=True)

    add_dialogue("accept farm", ("superficial", "very introvert"), ["我的天啊！对我来说听起来像是一种折磨....但是为了你我会这么做，主人。"])
    add_dialogue("accept farm fear", ("superficial", "generic", "very materialist"), ["她显然很讨厌这个主意，鄙视地看着吉泽尔，却不敢说话。"])
    add_dialogue("refuse farm", ("superficial", "very extravert"), ["嗯...“不”怎么样？！那个屎坑是我最不想去的地方。"])
    add_dialogue("gizel take girl to farm", ("superficial", "bimbo", "very extravert"), ("别担心，你这个蠢女人。我会确保你得到应有的关注。哈哈哈！"))

    add_dialogue("girl introduction", ("superficial", "very materialist"), ("*咯咯笑*天哪，看看你...你决定在这个场合穿{i}that{/i}吗？", "我们边走边聊吧，在你身边我会显得不可思议。顺便说一句，我是[girl.fullname]。"))
    add_dialogue("slave thanks", ("superficial", "very materialist"), ("*咯咯笑*我应得的。", "我知道，我太不可思议了....", "我玩得很开心！", "来自你的声音，让我如此幸福....", "哇谢谢你！","嗯，哇...就像...谢谢你。"))
    add_dialogue("slave effusive thanks", ("superficial", "generic"), ("哇哦，你快要让我哭了...非常感谢你！{i}SO{/i}！", "*抽泣*谢谢！！我很荣幸能够发光发热，你知道吗？", "噢，主人....被人赏识的感觉真好。非常感谢您！", "哇谢谢你！","嗯，哇...就像...谢谢你。"))
    add_dialogue("slave positive reaction", ("superficial", "very materialist"), ("被人欣赏的感觉真好！", "*咯咯*我很高兴看到我的价值得到认可。", "谢谢你，主人。我值得这样的待遇。", "我的，多么可爱啊！"))
    add_dialogue("slave negative reaction", ("superficial", "very extravert"), ("掌握？！我勒个去？", "呃...你现在真是太痛苦了。", "什、什么？！我简直不敢相信....我应该得到比这更好的待遇。", "*生气* 嗯，你能{i}想想{/i}为什么我现在这么生气吗？"))
    add_dialogue("slave whining", ("superficial", "very extravert"), ("呃...{i}真的吗？{/i}", "这真是废话....", "啊...", "哼哼...", "*生气* 嗯，你能{i}想想{/i}为什么我现在这么生气吗？"))
    add_dialogue("slave strongly refuse", ("superficial", "very extravert"), ["g: 嘿-嘿现在...让我们退后一步放松一下，好吗？ {w=1.0}{nw}", "g: ....请问？ {w=1.0}{nw}", "g: 嘿嘿嘿！！哇啊啊！！"], multiple=True, sound=s_screams)
    add_dialogue("slave bullied", ("superficial", "very extravert"), ("掌握？！我勒个去？", "呃...你现在真是太痛苦了。", "什、什么？！我简直不敢相信....我应该得到比这更好的待遇。"))
    add_dialogue("slave apology", ("superficial", "very materialist"), ("是的，是的，我知道....你就像是主人，一切....", "无论如何...我想你是对的...", "*叹气*我对此感到非常抱歉......", "你和我的波长不同，但没关系。"))
    add_dialogue("slave hit", ("superficial", "very materialist"), ("啊啊，操！ *疯狂*这需要很多化妆品才能掩盖。", "哎呀！你、你怎么敢！", "哇啊啊！！"))
    add_dialogue("slave positive fixation accept", ("superficial", "very extravert"), ("这太有趣了！让我们{i}字面意思{/i}花几个小时吧！", "这真是太有趣了！我迫不及待地想向大家夸耀它！", "呀呀！这真太了不起了！", "呀呀！我非常喜欢它！"))
    add_dialogue("slave negative fixation accept", ("superficial", "very extravert"), ("呃...{i}有人{/i}正在突破界限...", "我现在感觉很尴尬。", "*生气*呃...也许你应该想想这让我感觉如何？！", "嗯，认真的吗？好吧....但你必须尊重我的界限，好吗？"))
    add_dialogue("slave negative fixation refuse", ("superficial", "very extravert"), ("决不。那不是我，主人。", "哇你真的是认真的吗？那就超级尴尬了。决不！！", "嗯，哇....我很确定我们应该假装这次谈话从未发生过，然后继续前进。", "怎么样，比如，不？就像，不可能？", "嗯，我绝对不会做那样的事！"))

    add_dialogue("slave first visit", ("superficial", "very extravert"), ("你好，热门的东西...愿意告诉我到底发生了什么事吗？！"))
    add_dialogue("MC kind promise", ("superficial", "very materialist", "very dom"), ["她自信地挺起胸膛。" , "g: 嗯，是的，{i}对{/i}！我最好是这样！"], multiple=True, love=1, fear=-3)
    add_dialogue("MC fair promise", ("superficial", "very materialist"), ["她倾身向前，傻笑起来。" , "g: 我明白....只要你对我比对任何人都{i}更{/i}公平即可。 *眨眼*"], multiple=True, fear=-1)
    add_dialogue("MC no promise", ("superficial", "very materialist", "very dom"), ["她吃了一惊。" , "g: 什、什么？！我知道你怎么能这样对待其他女孩....但是，我？！"], multiple=True, love=-1, fear=1)
    add_dialogue("MC harsh promise", ("superficial", "very materialist", "very dom"), ("她咕哝着，轻蔑地看着你。"), love=-4, fear=3)
    add_dialogue("MC break promise", ("superficial", "very materialist", "very dom"), ("掌握？！我勒个去？你答应过要对我比这好得多。我{i}应该{/i}得到比这更好的待遇！"), love=-5, fear=1)
    add_dialogue("MC fight intro", ("superficial", "very dom"), ["她挑衅地转身背对你并试图走开。", "g: 克服它，这不会发生！"], multiple=True)
    add_dialogue("slave fear intro", ("superficial", "generic", "very materialist"), ("当你走向她时，她变得非常焦虑。她吐到附近的一个花瓶里，然后倒在地板上。"))
    add_dialogue("slave fear reassure success", ("superficial", "very introvert", "very modest"), ("她羞愧地低下头，点点头。"), fear=-2)
    add_dialogue("slave fear reassure failure", ("superficial", "very introvert", "very modest"), ("当你说话的时候，她的呼吸变得急促，眼睛向后翻。她问到一半就晕倒了。"), fear=-1)
    add_dialogue("slave fear discipline", ("superficial", "very introvert", "very modest"), ("你张开手掌打了她。令你惊讶的是，她在地板上抽搐并失去了知觉。"), fear=1)

    add_dialogue("slave naked request permanent", ("superficial", "very extravert","very materialist"), ("*咧嘴一笑*那太脏了...他们的目光将无法从我身上移开...我{i}喜欢{/i}它！"), love=1, fear=-1, sound=s_sigh)
    add_dialogue("slave naked request accept", ("superficial", "very extravert","very materialist"), ("*叹气*我必须这样做吗？我想我不介意抢风头，只要那些堕落者能把他们的爪子离我远点...."), love=1, sound=s_ahaa)
    add_dialogue("slave naked request resist", ("superficial", "very extravert", "very introvert"), ("呃...那会很尴尬...我们不要这样。"), love=-2, fear=-2)
    add_dialogue("slave toggle naked on", ("superficial", "very extravert"), ("*咯咯*请大饱眼福吧，主人。"))
    add_dialogue("slave toggle naked off", ("superficial", "very materialist"), ("当然可以，主人。只要你看...凭借{i}我{/i}精美的衣柜，我仍然会引人注目。 *眨眼*"))
    add_dialogue("slave train beg", ("superficial", "very extravert"), ["她把手放在臀部并向你挑战。", "g: 呃，你这个变态....这是答错了....我不会那样做。"], multiple=True)
    add_dialogue("slave discipline beg", ("superficial", "very extravert", "very dom"), ["[girl.name] 抓住你的手，泪流满面地试图缓和局势。", "g: 等、等一下，主人....我们不能谈谈这个吗？"], multiple=True)
    add_dialogue("slave beg proceed", ("superficial", "very materialist", "very dom"), ("什、什么？！我明白你怎么可以这样对待其他女孩....但是，{i}me{/i}？！"), love=-1, fear=1)
    add_dialogue("slave beg warning", ("superficial", "very materialist"), ("噢，我完全明白了，主人。谢谢你！！"), fear=1, sound=s_sigh)
    add_dialogue("slave beg give up", ("superficial", "very extravert", "very dom"), ["她看上去松了口气。", "g: 哦，主人....您真的很关心我。非常感谢您！"], multiple=True, fear=-1, sound=s_surprise)
    add_dialogue("slave send to master bedroom love +", ("superficial", "very extravert"), ["她跳进你的怀里，热情地吻你。", "g: 呀啊！谢谢你呜呜！"], multiple=True)
    add_dialogue("slave send to master bedroom love", ("superficial", "very extravert"), ["她跳进你的怀里拥抱你。", "g: 谢谢你啊啊啊！我喜欢男人思考我想要什么，你知道吗？"], multiple=True)
    add_dialogue("slave send to master bedroom love -", ("superficial", "very extravert", "very dom"), ["她双手叉腰，叹了口气。", "g: 你这个狡猾的狗....你就是看不够我，不是吗？"], multiple=True)
    add_dialogue("slave send to master bedroom fear +", ("superficial", "generic", "very sub"), ["你的声音让她脊背发凉。", "g: 明白了，主人。任何你想要的。"], multiple=True)
    add_dialogue("slave send to master bedroom fear", ("superficial", "generic", "very materialist"), ["她看起来很生气。", "g: *叹气*是的，当然，无论如何......"], multiple=True)
    add_dialogue("slave send to master bedroom fear -", ("superficial", "very extravert", "very idealist"), ["她用鄙视的眼神看着你。", "g: *叹息*您真是可怜啊，主人。甚至别想尝试任何有趣的事情。"], multiple=True)
    add_dialogue("slave leave master bedroom love +", ("superficial", "very materialist"), ["她表现得好像这个地方是她的，并且发出嘶嘶声。", "g: 你什么意思？我{i}值得{/i}与您在一起。这是{i}我们的{/i}卧室！"], multiple=True)
    add_dialogue("slave leave master bedroom love", ("superficial", "very materialist"), ["她无法掩饰她的失望。", "g: 哇....没有像我这样的女王在你身边，一张特大号床有什么用呢？"], multiple=True)
    add_dialogue("slave leave master bedroom love -", ("superficial", "very extravert"), ["她看上去松了口气。", "g: 谢天谢地....那真是太尴尬了。"], multiple=True)
    add_dialogue("slave leave master bedroom fear +", ("superficial", "very introvert", "very sub"), ["她害怕面对你的目光，紧握双手，盯着你的脚。", "g: *嗅一嗅*我是不是不值得您的关注，主人？"], multiple=True)
    add_dialogue("slave leave master bedroom fear", ("superficial", "very extravert", "very dom"), ["她看上去松了口气。", "g: 我很高兴听到你这么说。"], multiple=True)
    add_dialogue("slave leave master bedroom fear -", ("superficial", "very extravert", "very dom"), ["她拍着手，当着你的面笑。", "g: 终于！！这真是太尴尬了....我们再也不会这样做了。"], multiple=True)

    add_dialogue("slave chat slave_life -2", ("superficial", "very materialist", "very dom"), ["她陷入了否认，无法接受自己的命运。", "g: *生气* {i}我{/i}？我不是奴隶....奴隶是可悲的，是下等人中的下等人。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life -1", ("superficial", "very materialist"), ["她崩溃并哭泣。", "g: *抽泣*哦，这太糟糕了...我比这更好。我值得拥有更多！"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0", ("superficial", "very introvert"), ["她看起来很沮丧。", "g: 呃...你希望我说什么？像我这样的女孩应该受到尊重和宠爱，而不是被命令。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0.5", ("superficial", "very dom"), ["她叹了口气，抱起双臂。", "g: 啊，谁在乎呢....我遇到过更糟糕的情况。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 1", ("superficial", "very materialist", "very dom"), ["她交叉双臂，自信地挺起胸膛。", "g: 嗯，我不只是一个普通的奴隶。我比其他人好多了！只要你知道这一点，我也知道这一点，我就可以忍受。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 2", ("superficial", "very materialist"), ["她笑了，自信地挺起胸膛。", "g: 只要顾客继续像公主一样对待我，给我送礼物，我不介意当奴隶。"], multiple=True, unlock="DS")
    add_dialogue("slave chat brothel -2", ("superficial", "very extravert", "very dom"), ["她吐在地板上。", "g: 呸！这个地方脏得像流浪汉的肛门。", "g: 我特别鄙视地板上覆盖着一层层干燥的精液，每走一步，脚下都会发出噼啪声。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel -1", ("superficial", "very extravert", "very materialist"), ["她抬起头，捏住鼻子。", "g: 气味难以忍受。如果我睡在阴沟里，至少还能呼吸到新鲜空气。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0", ("superficial", "very dom"), ["她耸耸肩，叹了口气。", "g: 这个地方是垃圾场，还有什么新鲜事吗？随便吧。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0.5", ("superficial", "very extravert", "very materialist"), ["她耸耸肩，叹了口气。", "g: 呃....这不是什么我可以向朋友们吹嘘的事情，不是吗？"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel virgin", ("superficial", "very extravert"), ["她看起来很困惑。", "g: 太奇怪了，对吧？我没想到我最终会进青楼。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 1", ("superficial", "very extravert", "very materialist"), ["她摇动手指，微笑着。", "g: 我更喜欢称其为绅士俱乐部。这样吹嘘起来容易多了。我喜欢与客户交往。我想之后的性生活也还可以。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 2", ("superficial", "very extravert", "very materialist"), ["她脸上洋溢着自豪的笑容。", "g: 我{i}喜欢{/i}我们在这里建立的快乐宫殿。它有我想要的一切，真的。与客户交流是我最喜欢的事情。我们能持续拥有的美好性爱只是锦上添花。"], multiple=True, unlock="LM")
    add_dialogue("slave chat customers -2", ("superficial", "very dom"), ["她握紧拳头，咬紧牙关。", "g: 呸！对他们来说，我只不过是一个可以使用和虐待的性玩偶。操他们！"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers -1", ("superficial", "very idealist", "very dom"), ["她叹了口气，用拳头做出了手淫的动作。", "g: 那些失败者只能想到一件事。太可怜了！"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 0", ("superficial", "very materialist"), ["她翻了个白眼，叹了口气。", "g: 他们都太努力地想要穿上我的裤子了，而我想...{i}这真的没那么难，只要给我买昂贵的珠宝就可以了。{/i但他们中的大多数人都太穷了。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 0.5", ("superficial", "very materialist"), ["她的脸上浮现出淡淡的微笑。", "g: 我喜欢他们对我阿谀奉承，就像我是某种公主一样。不过，有时酒精会让他们变得有点暴力。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 1", ("superficial", "very extravert"), ["她微笑着对你眨眼。", "g: 当然！他们中的大多数人都非常喜欢我。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 2", ("superficial", "very extravert"), ["她笑着拍手。", "g: 呀啊啊！他们都喜欢，完全迷恋我。所以显然我应该操她们每一个，让其他女孩嫉妒！", "g: 天啊，我简直不敢相信我真的这么说了！我就是个荡妇！"], multiple=True, unlock="MI")
    add_dialogue("slave chat other_girls -2", ("superficial", "very extravert", "very dom"), ["她看起来很生气。", "g: 呃...我们为什么要谈论{i}那个{/i}？我现在根本无法考虑交朋友。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls -1", ("superficial", "very materialist"), ["她看起来很沮丧。", "g: 我看得出来他们嫉妒我。我们相处得不太好。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 0", ("superficial", "very dom"), ["她翻了个白眼，叹了口气。", "g: 现在我的事情太多了....我真的没有心情去交朋友。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 0.5", ("superficial", "very materialist"), ["她的脸上露出顽皮的笑容。", "g: 他们非常嫉妒我。我确信他们中的大多数人都会排队等候，以便花更多的时间和我在一起。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 1", ("superficial", "very extravert"), ["她用双手和微笑创造了一个心形。", "g: 我们相处得很好。他们真的很尊敬我，你知道吗？"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 2", ("superficial", "very extravert"), ["她张开双臂，兴奋地提高了声音。", "g: 天哪，他们太棒了！我想你可以说我们是好朋友。 *傻笑*"], multiple=True, unlock="EI")
    add_dialogue("MC praise friend", ("superficial", "very extravert"), ("天哪，她真是太棒了！"), sound=s_laugh)
    add_dialogue("MC demean rival", ("superficial", "very materialist"), ("呃....你看到她买的那件新衣服了吗？太俗气了！我确信顾客也讨厌她。"), sound=s_evil_laugh)
    add_dialogue("slave chat well_being -3", ("superficial", "very extravert"), ("呃....不是开玩笑，我现在就想自杀。"), unlock="MI")
    add_dialogue("slave chat well_being -2", ("superficial", "very dom"), ("他妈的不！一切都太可怕了！"), unlock="MI")
    add_dialogue("slave chat well_being -1", ("superficial", "very dom"), ("呃....为什么还要问？当然不是！"), unlock="MI")
    add_dialogue("slave chat well_being 0", ("superficial", "very dom"), ("呃...就像，无论如何。"), unlock="MI")
    add_dialogue("slave chat well_being 1", ("superficial", "very materialist"), ("*咯咯笑*当你是像我这样的超级辣妹时，即使是糟糕的一天也仍然非常美好。"), unlock="MI")
    add_dialogue("slave chat well_being 2", ("superficial", "very extravert"), ("呀呀呀呀，你知道的！"), unlock="MI")
    add_dialogue("slave chat well_being 3", ("superficial", "very materialist"), ("天哪，我的生活真是太棒了。难怪其他女孩总是嫉妒。"), unlock="MI")
    add_dialogue("slave chat well_being attacked", ("superficial", "very materialist"), ("我知道我是不可抗拒的，但一个月内被攻击[nb_times]可不是闹着玩的。请主人做点什么吧！"))
    add_dialogue("slave chat well_being sick", ("superficial", "generic", "very materialist", "very dom"), ("我现在感觉不那么热了...我一直在生病。我认为这里的工作条件不健康。"))
    add_dialogue("slave chat well_being exhausted", ("superficial", "very extravert"), ("呃...整个月我都{i}完全{/i}筋疲力尽了。让我们猛踩一下刹车，好吗？"))
    add_dialogue("slave chat well_being MC apology", ("superficial", "very extravert"), ("我很高兴听到这个消息，主人。"))
    add_dialogue("slave chat feelings love -1", ("superficial", "very extravert"), ("这太尴尬了....对不起，我现在正在努力想赞美的话。"), unlock="DS")
    add_dialogue("slave chat feelings love 0", ("superficial", "generic", "very materialist"), ("呃....我真的不知道该怎么想你...."), unlock="DS")
    add_dialogue("slave chat feelings love 1", ("superficial", "very extravert", "very materialist"), ("我猜你是个正派的人或者什么的。"), unlock="DS")
    add_dialogue("slave chat feelings love 2", ("superficial", "very materialist"), ("你就像是世界上我最喜欢的人。我{i}完全{/i}希望你在我体内生一个孩​​子。我们的孩子将拥有{i}有史以来最好的基因{/i}，您不觉得吗？"), unlock="DS")
    add_dialogue("slave chat feelings fear -1", ("superficial", "very extravert", "very dom"), ("和你在一起真是个尴尬的家伙。比如，培养一些社交技能，伙计...."), unlock="DS")
    add_dialogue("slave chat feelings fear 0", ("superficial", "very extravert", "very dom"), ("我想你可能会有点害怕之类的。"), unlock="DS")
    add_dialogue("slave chat feelings fear 1", ("superficial", "very dom"), ("主人注重结果，不喜欢乱来。我可能并不总是喜欢它，但我可以尊重它。"), unlock="DS")
    add_dialogue("slave chat feelings fear 2", ("superficial", "very dom"), ("你就像，我的主人和一切。我知道违背你的命令将会产生后果。所以我会小心，不要冒着激怒你的风险。"), unlock="DS")
    add_dialogue("slave chat feelings very disobedient", ("superficial", "very materialist", "very dom"), ("你很笨，我不介意当面告诉你这一点。"), unlock="DS")
    add_dialogue("slave chat feelings disobedient", ("superficial", "very materialist"), ("我和其他女孩不同，所以我完全有权利接受一些特殊待遇。"), unlock="DS")
    add_dialogue("slave chat feelings a little obedient", ("superficial", "very extravert", "very materialist"), ("我很乐意服从命令之类的，只要它们不会变得太奇怪。"), unlock="DS")
    add_dialogue("slave chat feelings obedient", ("superficial", "very extravert", "very materialist"), ("你完全赢得了我的尊敬，主人。"), unlock="DS")
    add_dialogue("slave chat feelings very obedient", ("superficial", "very extravert"), ("我会{i}完全{/i}为你加倍努力，因为你是我的主人，你对我来说很特别。"), unlock="DS")
    add_dialogue("slave chat tastes likes", ("superficial", "sweet", "bimbo"), ("嗯，我的意思是，我是个女孩，所以....显然我喜欢[thing_cn]。特别是[best]。","嗯，我怎么可能不喜欢[best]呢？没有其他[thing_cn]可以与之相媲美。","就[thing_cn]而言，我完全是[best]类型！"), unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("superficial", "rebel", "bimbo" ), ("嗯，如果[worst]是你最喜欢的[thing_cn]，我真的不想被看到和你在一起，所以......", "我朋友现在就面临这样的情况。她最喜欢的[thing_cn]是[worst]，我想....嗯....不怎么样？！友谊结束了。", "实际上，我并不喜欢[worst]的[thing_cn]。"), unlock="LM")
    add_dialogue("slave chat tastes loves +", ("superficial", "rebel", "bimbo"), ("我愿意为[thing_cn]做任何事情。","嗯，我怎么可能不喜欢[thing_cn]呢？","我，就像，完全是[thing_cn]类型！"), unlock="LM")
    add_dialogue("slave chat tastes loves -", ("superficial", "very extravert"), ("我想[thing_cn]没问题或者怎么样。","您对[thing_cn]有何看法？我的朋友不会对此闭嘴。"), unlock="LM")
    add_dialogue("slave chat tastes no loves", ("superficial", "very materialist"), ("呃...不要为这些小事而烦恼...如果你真的想招待我，就给我买一些非常昂贵的珠宝或类似的东西，一座城堡之类的。"), unlock="LM")
    add_dialogue("slave chat tastes hates", ("superficial", "very extravert"), ("嗯，如果你喜欢[thing_cn]，我真的不想被看到和你在一起，所以......", "我朋友现在就面临这样的情况。她喜欢[thing_cn]，而我就像....嗯....不怎么样？！友谊结束了。", "实际上，我{i}真的{/i}不喜欢[thing_cn]。"), unlock="LM")
    add_dialogue("slave chat tastes no hates", ("superficial", "very materialist"), ("*咯咯笑*我喜欢受到各种各样的对待，并让其他女孩嫉妒。"), unlock="LM")
    add_dialogue("slave chat tastes positive act", ("superficial", "very extravert"), ("哦，是的，我对 [act_desc] {i}完全{/i}感兴趣！", "像 [act_desc] 这样的东西非常有趣！我很喜欢！", "我希望更多的客户参与 [act_desc]。我非常喜欢它！"), unlock="LM")
    add_dialogue("slave chat tastes negative act", ("superficial", "very extravert"), ("您不同意 [act_desc] 非常奇怪吗？不是我喜欢的类型。","像 [act_desc] 这样的东西让我感觉很尴尬....不，谢谢！", "嗯，我不可能做类似 [act_desc] 的事情！"), unlock="LM")
    add_dialogue("slave chat tastes no negative act", ("superficial", "very extravert", "very lewd"), ("*咯咯笑*我愿意做任何事情。让我们玩得开心吧？"), unlock="LM")

    add_dialogue("slave chat origins 1", ("superficial", "rebel", "bimbo" ), ("我来自[girl.origin]。那里实在是太无聊了。", "我来自[girl.origin]。我决定尽快搬到泽恩。", "我很高兴我们能够从 [girl.origin] 搬到 Zan。 [girl.origin] 简直就是一个屎坑。"), unlock="EI")
    add_dialogue("slave chat origins 2", ("superficial", "rebel", "princess", "schemer", "stubborn"), ["g: 回到[girl.origin]，我曾经爬上我们的[a_home]顶，激怒了我的[girl.story_guardian]。", "g: 我不知道为什么我会想到这样做....我想这只是一种引起他们注意的方式。"], multiple=True, unlock="EI")
    add_dialogue("slave chat origins 3", ("superficial", "very materialist"), ["g: 我已经很久没有在那个[girl.story_home]了，但我仍然清楚地记得和我的[girl.story_guardian]一起用雏菊制作一条项链。", "g: 我想这就是我对珠宝的喜爱的开始。"], multiple=True, unlock="EI")
    add_dialogue("origin Zan", ("superficial", "very materialist"), ["g: 我和我的[girl.story_guardian]经常会在大教堂附近闲逛。", "g: 如果你仔细看看大教堂广场附近的那棵老树，你会发现它的树皮上刻着一颗小心，两边都有我名字的缩写。"], multiple=True)
    add_dialogue("origin the border with the Holy Lands", ("superficial", "very extravert"), ["当你听到呼啸的风吹过圣地的山丘时，你会感到难以忍受的悲伤。", "g: 我的[girl.story_guardian]会自发地唱歌，只是为了淹没风的噪音。"], multiple=True)
    add_dialogue("origin the Blood Islands", ("superficial", "very extravert", "very materialist"), ("回到血群岛时我一直生活在恐惧之中。吸引过多的注意力可能会导致快速死亡。在泽恩这里，我终于可以做我自己了。"))
    add_dialogue("origin Karkyr", ("superficial", "very extravert", "very materialist"), ["g: 你应该看看他们在 Karkyr 举办的模特秀！", "g: 迷人的时装秀有自己的想法。你永远不知道他们什么时候会绊倒模特，或者吹起一阵风吹动她们的裙子。"], multiple=True)
    add_dialogue("origin Westmarch", ("superficial", "very extravert", "very materialist", "very modest"), ["g: 我们在威斯特玛公国的生活很混乱。你永远不确定自己的存在。", "g: 战争还是和平。奢侈或无家可归。生活每天都会发生巨大的变化。我可以依靠我的[girl.story_guardian]，这是一件好事。"], multiple=True)
    add_dialogue("origin the desert of Hokoma", ("superficial", "very extravert"), ("在霍科马沙漠中，大多数人更喜欢安静、沉思的生活。这种生活不适合我，所以我有点被排斥。"))
    add_dialogue("origin Borgo, the port city", ("superficial", "very idealist", "very dom"), ["g: 嗯....我该怎么形容博尔戈....", "g: 就像是一个无望的、满头大汗的、低劣版本的赞。", "g: 他们试图通过付出更多的努力来取得成功，但是只要所有猖獗的腐败和犯罪活动都在拖慢你的速度，付出更多的努力并不会让你走得太远！"], multiple=True)
    add_dialogue("origin the Goliath desolations", ("superficial", "generic", "very idealist", "very materialist"), ["g: 我不想谈论我在荒凉中度过的时光。这是一个没有生命和希望的地方。", "g: 歌利亚的荒凉永远停留在过去，而在泽恩这里，我们可以展望未来。我认为人们没有意识到这是多么值得珍惜的特别事情。"], multiple=True)
    add_dialogue("origin the Arik mountains", ("superficial", "very extravert", "very materialist"), ["g: 在阿里克山上，我曾经对我的[girl.story_guardian]大喊大叫，引发了雪崩。", "g: 我什至不记得我在喊什么了......", "g: 幸运的是我们没有在雪崩的路径上，否则我们的生命就会在那时结束。"], multiple=True)

    add_dialogue("slave train accepted", ("superficial", "very extravert"), ("噢，主人。我们{i}完全{/i}意见一致。","主人，让我们一起创造一些回忆吧。","我很愿意，主人。"))
    add_dialogue("slave train resisted", ("superficial", "very extravert", "very dom"), ("掌握？！我勒个去？","呃....我为什么要这么做？你现在真是太痛苦了。","*生气*你应该知道我讨厌那种事情。"))
    add_dialogue("slave train refused", ("superficial", "very extravert"), ("怎么样，比如，不？就像，不可能？","嗯，你不可能让我做那样的事！","哈！也许在你的梦里吧！"))
    add_dialogue("slave lecture love", ("superficial", "very extravert"), ("我完全可以听你讲几个小时，主人。"))
    add_dialogue("slave lecture neutral", ("superficial", "very materialist"), ("呃...这真是太痛苦了。我们可以跳过所有无聊的部分吗？"))
    add_dialogue("slave lecture fear", ("superficial", "very extravert"), ("经过一番努力，她设法集中注意力而不分心。"))
    add_dialogue("slave lecture refuses", ("superficial", "very extravert"), ("嗯...是的...我从来没有做过那样的事情。"))
    add_dialogue("slave lecture very reluctant", ("superficial", "very extravert"), ("呃！这听起来很尴尬！"))
    add_dialogue("slave lecture reluctant", ("superficial", "generic", "very materialist"), ("呃....抱歉，我真的不明白。"))
    add_dialogue("slave lecture a little reluctant", ("superficial", "generic", "very materialist"), ("就像....这会让我湿透吗？我不确定我是否明白了。"), sound=s_sigh)
    add_dialogue("slave lecture indifferent", ("superficial", "very extravert"), ("啊，我的一位朋友告诉我这件事。我想我完全可以想象自己会这么做。"))
    add_dialogue("slave lecture a little interested", ("superficial", "very extravert"), ("哦，是的，我对 [act_desc] {i}完全{/i}感兴趣。什么，你以为我会吓坏什么的？"), sound=s_surprise)
    add_dialogue("slave lecture interested", ("superficial", "very extravert"), ("这真是太有趣了！我真的很喜欢[act_desc]！"), sound=s_mmh)
    add_dialogue("slave lecture very interested", ("superficial", "very extravert"), ("呀呀！是只有我一个人觉得这样，还是 [act_desc] 是地球上最好的事情？"), sound=s_mmh)
    add_dialogue("slave lecture fascinated", ("superficial", "very extravert", "very lewd"), ("*呻吟* 天哪，[act_desc] 听起来太棒了！这让我整个人都兴奋起来！"), sound=s_aah)
    add_dialogue("slave train obedience", ("superficial", "very materialist"), ("*呻吟*这真是太痛苦了。难道希露不应该是做这些令人头脑麻木的乏味任务的人吗？"))
    add_dialogue("slave train constitution", ("superficial", "generic", "very materialist"), ("*喘气*还要多久，主人？ *呼气*这之后我真的需要洗个澡。"))
    add_dialogue("slave train refuses", ("superficial", "generic", "very dom", "very materialist"), ("她看起来非常愤怒，因为你甚至建议尝试[act_desc]。"), sound=s_screams)
    add_dialogue("slave train very reluctant", ("superficial", "very extravert"), ("嗯，认真的吗？呃....你和我的波长不同，主人。这太糟糕了！"), sound=s_scream)
    add_dialogue("slave train reluctant", ("superficial", "very extravert"), ("呃....不管怎样，我想我会这么做，因为它就像是一个命令和一切...."), sound=s_scream)
    add_dialogue("slave train a little reluctant", ("superficial", "very extravert", "very sub"), ("啊!什、无论你喜欢什么，主人...."), sound=s_surprise)
    add_dialogue("slave train indifferent", ("superficial", "very extravert"), ("好的，主人。那我们就忙起来吧。"), sound=s_ahaa)
    add_dialogue("slave train a little interested", ("superficial", "very extravert"), ("嗯....我喜欢这样....我要求你裸体会不会太前卫了，主人？"), sound=s_ahaa)
    add_dialogue("slave train interested", ("superficial", "very extravert", "very dom"), ("操，是的，[act_desc]！我{i}如此{/i}兴奋...*咯咯*我不敢相信我真的这么说了！我就是个荡妇！"), sound=s_mmh)
    add_dialogue("slave train very interested", ("superficial", "generic", "very materialist", "very lewd"), ("嗯...很高兴您能想到我的想法。如果我想在公共场合尝试 [act_desc]，这会让我成为一个荡妇吗？"), sound=s_aah)
    add_dialogue("slave train fascinated", ("superficial", "very extravert"), ("*呻吟*天哪，呀啊啊！我非常喜欢[act_desc]！你是最棒的，[MC.name]主人。"), sound=s_orgasm_fast)
    add_dialogue("slave train naked failure", ("superficial", "very materialist"), ("呃....没课！没有一件奢华的衣服我就无法抢尽风头！"), sound=s_surprise)
    add_dialogue("slave train naked success", ("superficial", "very materialist"), ("嗯...我希望每个人都能看到我的光芒。"), sound=s_aah)
    add_dialogue("slave train service failure", ("superficial", "very materialist", "very modest"), ("呃....这太丢人了！"))
    add_dialogue("slave train service success", ("superficial", "very extravert", "very sub"), ("啊...我非常喜欢主人精液的味道！"))
    add_dialogue("slave train sex failure", ("superficial", "generic", "very materialist", "very idealist"), ("我讨厌这样，主人....请停下来...."))
    add_dialogue("slave train sex success", ("superficial", "very extravert"), ("*呻吟*啊啊！掌握！这真是太好了！我们来进行第二轮吧！"))
    add_dialogue("slave train anal failure", ("superficial", "very extravert"), ("啊....这太尴尬了...."))
    add_dialogue("slave train anal success", ("superficial", "very extravert"), ("天哪，我就像个荡妇....而且我{i}喜欢它{/i}！"))
    add_dialogue("slave train fetish failure", ("superficial", "generic", "very introvert", "very materialist"), ("主人，请停下来！我不能这样做..."))
    add_dialogue("slave train fetish success", ("superficial", "very extravert", "very materialist"), ("嗯...我很想在舞台上表演，主人...让顾客观看！"))
    add_dialogue("slave train bisexual failure", ("superficial", "very extravert"), ("对不起....我只是不那样摇摆，主人...."))
    add_dialogue("slave train bisexual success", ("superficial", "generic", "very lewd", "very dom"), ("呃呃....我比任何男人都更能取悦她。"), sound=s_mmh)
    add_dialogue("slave train group failure", ("superficial", "very materialist", "very dom"), ("呃....别再到处摸我了！就不能排队吗？"))
    add_dialogue("slave train group success", ("superficial", "very materialist"), ("*呻吟*我不敢相信我们来了多少次...而且我觉得我可以承受更多！如果我再这样下去，其他女孩就会失业。"))
    add_dialogue("slave magic obedience success", ("superficial", "generic", "very extravert", "very materialist"), ("我必须打开....为了主人...."), sound=s_ahaa)
    add_dialogue("slave magic libido success", ("superficial", "generic", "very extravert", "very materialist"), ("我渴望....挣脱束缚我灵魂的枷锁...."), sound=s_mmh)
    add_dialogue("slave magic sensitivity success", ("superficial", "very extravert", "very idealist", "very modest"), ("我就像一个天使......我必须让我的身体为众神歌唱......"), sound=s_mmh)
    add_dialogue("slave magic naked success", ("superficial", "very materialist", "very introvert"), ("让我的身体呼吸....让我的汁液流动...."), sound=s_ahaa)
    add_dialogue("slave magic service success", ("superficial", "very extravert", "very modest", "very sub"), ("你播下种子...我的愿望成长..."), sound=s_mmh)
    add_dialogue("slave magic sex success", ("superficial", "very materialist", "very sub"), ("你的金色吊坠....在我体内悸动...."), sound=s_aah)
    add_dialogue("slave magic anal success", ("superficial", "very materialist", "very sub"), ("一份闪闪发光的礼物......我渴望收到......"), sound=s_ahaa)
    add_dialogue("slave magic fetish success", ("superficial", "very materialist"), ("请更多珠宝...用它窒息我..."), sound=s_aah)
    add_dialogue("slave magic bisexual success", ("superficial", "very extravert", "very materialist"), ("就连女人....也为我竖起...."), sound=s_mmh)
    add_dialogue("slave magic group success", ("superficial", "very extravert", "very materialist"), ("我需要每个人的关注...每个人的种子..."), sound=s_ahaa)
    add_dialogue("slave magic failure", ("superficial", "very extravert", "very materialist", "very dom"), ["她踉踉跄跄地向后退去，脸上露出惊恐的表情。", "g: 什-到底是什么？你刚才是想对我施咒吗？"], multiple=True, sound=s_scream, unlock="DS")

    add_dialogue("slave reward sex accepted", ("superficial", "very extravert", "very lewd"), ["她眨了眨眼睛，把手放在臀部上。", "g: *咯咯*你这个变态...你就是无法满足我，不是吗？"], multiple=True, love=1, sound=s_ahaa, unlock="LM")
    add_dialogue("slave reward sex resisted", ("superficial", "very extravert"), ["她看起来很生气，叹了口气。", "g: 你在这里向我发出了混合信号....这是工作还是娱乐？"], multiple=True, love=-1, sound=s_surprise, unlock="LM")
    add_dialogue("slave reward sex refused", ("superficial", "very extravert"), ("嗯，哇。我很确定你现在完全不讲道理。"), sound=s_scream)
    add_dialogue("slave reward praise", ("superficial", "very materialist"), ("呃....你能停止赞美了吗？如果你想表达你的爱，就送我一件衣服或者一些珠宝什么的吧。"), love=-1, unlock="MI")
    add_dialogue("slave reward gold", ("superficial", "very materialist"), ("谢谢你呜呜！我喜欢一个男人想到我，你知道吗？"), love=2, unlock="MI")
    add_dialogue("slave reward pet", ("superficial", "nerd", "sweet", "holy", "repressed", "prude"), ("哇哦，主人 [MC.name]...你真是太可爱了，你知道吗？"), love=1, unlock="DS")
    add_dialogue("slave reward day off", ("superficial", "very extravert"), ("我现在完全值得一些自己的时间。谢谢主人！"), love=1, unlock="DS")
    add_dialogue("slave reward day off KO", ("superficial", "superficial", "very dom"), ["g: 我现在是不是很兴奋？我很确定你已经给我放了一天假。", "mc: 哦，你是对的[girl.name]。我完全忘记了这一点。"], multiple=True)
    add_dialogue("slave punish scold deserved", ("superficial", "superficial", "very dom"), ["她看起来对你的批评并不担心。","g: 我很抱歉我这么做了或者其他什么....但如果你处于我的位置，你就会完全明白我的意思。"], multiple=True, fear=-2, unlock="MI")
    add_dialogue("slave punish scold undeserved", ("superficial", "very extravert", "very materialist"), ["当她保持目光接触时，她看起来并不担心。","g: 嗯，哇。你做完了吗？我很确定你现在完全不讲道理。"], multiple=True, fear=-1, unlock="MI")
    add_dialogue("slave punish upkeep", ("superficial", "very materialist"), ("不！我需要它！"), fear=1, unlock="MI")
    add_dialogue("slave punish upkeep KO", ("superficial", "very extravert", "very materialist"), ["g: 你是否负债累累？我很确定你已经拿走了我的零用钱。", "mc: 哦，你是对的[girl.name]。我忘了那件事了。"], multiple=True)
    add_dialogue("slave punish beat", ("superficial", "very dom"), ["当你管教她时，她会保持坚强。", "g: 啊啊！真他妈的疼....你完了吗，主人？"], multiple=True, sound=s_screams, unlock="DS")
    add_dialogue("slave punish farm", ("superficial", "very extravert"), ("天啊，我听说过那个地方....听起来很恶心。"), multiple=True, fear=1, unlock="DS")
    add_dialogue("slave punish naked", ("superficial", "rebel", "sweet", "helper", "creep", "princess", "pet", "tsundere", "loyal"), ("哦，就这些吗？当然，无论如何。"), multiple=True, unlock="LM")
    add_dialogue("slave punish naked KO", ("superficial", "very extravert", "very dom"), ["g: 您需要检查一下您的眼睛，主人。我想，我已经{i}完全{/i}赤身裸体了。", "mc: 啊，原来如此。在这种情况下，没关系。"], multiple=True)
    add_dialogue("slave punish rape", ("superficial", "rebel", "holy", "repressed", "schemer"), ["她看起来很害怕。", "g: 嘿-嘿现在...让我们退后一步，吃点镇定剂，好吗？ {w=1.0}{nw}", "g: ....请问？ {w=1.0}{nw}", "g: 嘿嘿嘿！！哇啊啊！！"], multiple=True, fear=2, unlock="LM")
    add_dialogue("slave raped", ("superficial", "generic", "very materialist"), ("呃....啊！没那么粗暴....嗯！啊！！"), sound=s_screams)
    add_dialogue("slave rape positive fixation", ("superficial", "very extravert", "very dom"), ("嗯...我不敢相信我会这么说，但这实际上感觉{i}so{/i}很好。"), love=1, fear=-1, sound=s_aah)
    add_dialogue("slave rape negative fixation", ("superficial", "very extravert"), ("啊啊，好痛啊....你最坏了，主人。"), love=-2, fear=3, sound=s_scream_loud)

    add_dialogue("rest", ("superficial", "very extravert", "very introvert"), ("终于有时间了！ {w=1.0}{nw}"))
    add_dialogue("accept job", ("superficial", "very materialist"), ("您见过这么漂亮的{b}[girl.job_cn]{/b}吗？ {w=1.0}{nw}"))
    add_dialogue("work_whore", ("superficial", "very extravert"), ("*咯咯笑*我会成为最放荡的{b}[girl.job_cn]{/b}{i}有史以来{/i}。 {w=1.0}{nw}"))
    add_dialogue("exhausted", ("superficial", "generic", "very materialist"), ("我现在已经精疲力尽了...我会尽快以{b}[girl.job_cn]{/b}的身份回来。"))
    add_dialogue("rank up", ("superficial", "very extravert"), ("呀呀呀，聚会时间到了！我现在是一名[newrank]奴隶。"))
    add_dialogue("refuse whoring", ("superficial", "very extravert"), ("哇你真的是认真的吗？那就超级尴尬了。我不是妓女什么的。"))
    add_dialogue("refuse sex act", ("superficial", "very extravert"), ("怎么样，比如，不？就像，不可能？","嗯，你不可能让我做那样的事！","哈！也许在你的梦里吧！"))

    add_dialogue("bought", ("superficial", "very extravert", "very materialist"), ["她看上去松了口气。", "g: 哦....你是我的新主人？没想到有人这么，嗯....帅。"], multiple=True)
    add_dialogue("freed", ("superficial", "generic", "very materialist"), ("这么久了，我想..."))
    add_dialogue("sold", ("superficial", "very materialist"), ("哇，你被骗了....我的身价至少是你的五倍！"))
    add_dialogue("sold love", ("superficial", "generic", "very extravert"), ("*呜咽* 哇，我会非常想念你的，主人..."), sound=s_surprise)
    add_dialogue("leave for quest", ("superficial", "very extravert"), ("你等着吧，主人....我会帮你把它从公园里敲出来的！"))
    add_dialogue("leave for class", ("superficial", "very materialist", "very dom"), ("*呻吟*这会很无聊...但我会尽力而为！"))
    add_dialogue("advertise", ("superficial", "very extravert"), ["来[brothel.name]找我吧！我们会一起享受{i}很多乐趣{/i}！", "哦，先生...就像...我知道欺骗你的妻子可能是答错了，但这正是它变得{i}如此{/i}有趣的原因，明白我的意思吗？","{i}字面上{/i}迫不及待地想在[brothel.name]招待您！","我们的青楼里有很多荡妇，太疯狂了！", "让我们一起创造一些回忆吧，先生。", "呀呀！我非常喜欢[brothel.name]！您绝对应该来拜访我们。"])

    add_dialogue("beach intro", ("superficial", "very extravert"), ["[girl.fullname] 正在玩沙滩排球。她的技术还有很多不足之处，但她利用她在[brothel.name]学到的技能设法弥补了这一点。", "在比赛的关键时刻，她狡猾地向对手展示自己的小穴，分散了对手的注意力。"], multiple=True, sound=s_laugh)
    add_dialogue("beach meet MC", ("superficial", "generic", "very extravert"), ["g: [MC.name]！天气是不是很棒？", "mc: 是啊....确实如此！", "g: 这感觉就像约会，不是吗？ *咯咯*我们应该多出去玩。"], multiple=True)
    add_dialogue("beach oiling", ("superficial", "generic", "very lewd"), ["啊...我{i}喜欢{/i}当你的手指像那样在我的身体上滑动..."], sound=s_ahaa)
    add_dialogue("beach accept oiling", ("superficial", "very lewd"), ["哦，太热了！我的缝隙感觉已经上油了！ *傻笑*"])
    add_dialogue("beach refuse oiling", ("superficial", "very extravert"), ["等待！我们不要走那么远，好吗？边界。你有点像我的老板，知道吗？"])
    add_dialogue("beach accept public sex", ("superficial", "very extravert", "very materialist"), ["g: 啊哈哈，你真是个变态！当着这么多人的面，{i}真的{/i}吗？", "她低头看了一眼你勃起的阴茎，舔了舔嘴唇。", "g: 噢，到底是什么....我无法抗拒你，主人。"], multiple=True)
    add_dialogue("beach refuse public sex", ("superficial", "very extravert", "very materialist"), ["g: 啊哈哈，你真是个变态！当着这么多人的面，{i}真的{/i}吗？","她低头看了一眼你勃起的阴茎。", "g: 请其他人来处理这件事，好吗？今天是我休息日。"], multiple=True)
    add_dialogue("beach accept sex", ("superficial", "very extravert", "very materialist"), ["g: 啊哈哈，你真是个变态！", "她低头看了一眼你勃起的阴茎，舔了舔嘴唇。", "g: 噢，到底是什么....我无法抗拒你，主人。"], multiple=True)
    add_dialogue("beach refuse sex", ("superficial", "very extravert", "very materialist"), ["g: 啊哈哈，你真是个变态！","她低头看了一眼你勃起的阴茎。", "g: 请其他人来处理这件事，好吗？今天是我休息日。"], multiple=True)
    add_dialogue("beach whoring request", ("superficial", "generic", "very materialist"), ["主人，今天不是应该休息吗？"], multiple=True)
    add_dialogue("beach whoring accept", ("superficial", "very extravert", "very lewd"), ["我想我现在有点兴奋....我还不如得到报酬。 *咯咯笑*我就是个荡妇！"], multiple=True)
    add_dialogue("beach whoring refuse", ("superficial", "generic", "very dom"), ["没办法，主人。你就不能给我一天，让我不用听从命令吗？"], multiple=True)

## START BIMBO DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("bimbo", "pervert"), ("*咯咯*你这么努力，太可爱了！继续努力吧！我是[girl.fullname]。"), love=1)
    add_dialogue("free_greetings_casual", ("bimbo", "princess"), ("唔？噢，只是一个无名的陌生人。我是[girl.fullname]。"), love=-1)
    add_dialogue("free_greetings_rude", ("bimbo", "princess"), ("呵呵，我现在信心满满了！谢谢！我是 [girl.fullname]，我相信您听说过我。"), love=3)

    add_dialogue("free_small_talk", ("bimbo", "pervert", "cold"), ("好吧，无所谓了..."), love=1, max_cap=25)
    add_dialogue("free_gossip", ("bimbo", "helper"), ("我的朋友们对我还不够。他们告诉了我一些有趣的事情......"), love=2, max_cap=25)
    add_dialogue("free_chat_life", ("bimbo", "pervert", "princess", "superficial", "rebel"), ("我从来没有真正考虑过这个问题。"), love=-1, max_cap=25)
    add_dialogue("free_chat_love", ("bimbo", "pervert"), ("有时它只是触及表面，有时它会深入到真正的深处。", "我总是说，如果魔法存在，为什么不让它发生呢？"), love=2, max_cap=25)
    add_dialogue("free_chat_origins", ("bimbo", "pervert"), ("没关系，不是吗？ [girl.origin]。"), max_cap=40)
    add_dialogue("free_chat_hobbies", ("bimbo", "pervert"), ("我经常和我的朋友一起去[hobby]。但最近我感觉我已经克服了它。"), love=2, max_cap=40)
    add_dialogue("free_chat_likes", ("bimbo", "pervert", "superficial", "princess"), ("我在[best]俱乐部里。真正的[thing_cn]王。 *笑*"), love=2, max_cap=40)
    add_dialogue("free_chat_dislikes", ("bimbo", "superficial", "princess", "cold"), ("我不喜欢[worst]。那是小孩子的[thing_cn]。"), max_cap=40)

    add_dialogue("free_joke_harmless", ("bimbo", "class president"), ("呵呵，好吧好吧。"), love=1, max_cap=50)
    add_dialogue("free_joke_adult", ("bimbo", "pervert", "loyal", "superficial", "rebel"), ("*笑*这是一个{i}经典{/i}！"), love=3, max_cap=50)
    add_dialogue("free_joke_dark", ("bimbo", "pervert"), ("这有点扭曲，伙计。"), love=-3, max_cap=50)
    add_dialogue("free_joke_mean", ("very materialist", "pervert"), ("Aw, you're awful... *咯咯笑*"), love=3, max_cap=50)

    add_dialogue("free_touch_hand", ("bimbo", "pervert", "cold"), ("不要那么做。我不喜欢被当作小孩子对待。", "*叹气*你真的认为我现在有心情这么做吗？", "*叹气*为什么不直接告诉我你想要什么？"), max_cap=90)
    add_dialogue("free_touch_kiss", ("bimbo", "pervert", "superficial"), ("*亲吻*哦，亲爱的...我对前戏太不耐烦了。你知道我想要什么。", "*smooch*呵呵...想用舌头试试吗？"), love=2, max_cap=90)
    add_dialogue("free_touch_ass", ("bimbo", "class president"), ("嗯...再摸索一下就可以了，好吗？", "嘿，你这双手太调皮了。下来吧，男孩。"), love=3, max_cap=90)
    add_dialogue("free_touch_breasts", ("bimbo", "pervert"), ("安！很难压低我的声音....感觉很好。", "*呻吟*你让我有心情了！", "*咯咯*一秒钟，我会闪现给你。 *眨眼*"), love=5, max_cap=90)
    add_dialogue("free_touch_pussy", ("bimbo", "pervert", "creep"), ("哦，你喜欢顽皮、肮脏的前戏吗？我喜欢！", "*咯咯笑*我为自己的身体感到自豪。你怎么看呢？",  "*咧嘴笑*想要我给你看一下下面吗？"), love=3, max_cap=90)

    add_dialogue("free_play refuses", ("bimbo", "very lewd"), ("*呻吟*你能克制住自己吗？我心情不好。"), love=-1)
    add_dialogue("free_play very reluctant", ("bimbo", "superficial", "class president"), ("这是个笑话，对吧？等等，不是吗？"), love=1)
    add_dialogue("free_play reluctant", ("bimbo", "superficial", "schemer"), ("有时试着想想除了自己之外的其他人，好吗？啊啊，什么鬼啊...."), love=2)
    add_dialogue("free_play a little reluctant", ("bimbo", "superficial", "schemer"), ("你是想考验我吗？好吧，我会接受这个挑战！我们开工吧！"), love=2)
    add_dialogue("free_play indifferent", ("bimbo", "superficial", "schemer"), ("*微笑*当然，算我一个。我会扮演主人，给你上一堂你不会忘记的课。"), love=3)
    add_dialogue("free_play a little interested", ("bimbo", "superficial", "schemer"), ("嗯....我就知道你会这么说！ *微笑*我会让你成为我的奴隶，身体和灵魂。"), love=4)
    add_dialogue("free_play interested", ("bimbo", "superficial", "schemer"), ("当然，听起来不错。我会给你一些特别的服务。 *眨眼*"), love=4)
    add_dialogue("free_play very interested", ("bimbo", "superficial", "schemer"), ("*呻吟*你终于问了！我一直在等待。现在来吧，我已经等不及要开始了！"), love=5)
    add_dialogue("free_play fascinated", ("bimbo", "superficial", "schemer"), ("*脸红*你这么说只是为了看我脸红，不是吗？你这个性感的挑逗...你现在已经打开了闸门，没有什么可以阻止我！"), love=5)
    add_dialogue("MC take virginity", ("bimbo"), ("*脸红*事实是，你是我的第一个......"), love=5)
    add_dialogue("free_play interested after", ("bimbo"), ("啊....我来过几次了...."))
    add_dialogue("free_play not interested after", ("bimbo"), ("*叹息*情绪杀手。我现在可以走了吗？"))

    add_dialogue("free_flirt_beauty", ("bimbo", "pet", "meek", "repressed", "superficial"), ("啊，我脸红得像疯了一样！别再盯着看，好吗？"), love=2, max_cap=75)
    add_dialogue("free_flirt_body", ("bimbo", "schemer", "rebel"), ("*笑*我为这个数字而努力。我{i}必须{/i}炫耀一下！"), love=3, max_cap=75)
    add_dialogue("free_flirt_mind", ("bimbo", "rebel"), ("你真是太不擅长赞美了。我讨厌你这一点。"), love=-3, max_cap=75)
    add_dialogue("free_flirt_spirit", ("bimbo", "pet"), ("我不确定你到底是什么意思，但我想我对你的声音上瘾了。"), love=1, max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("bimbo"), ("*咧嘴笑*你确定要去那里吗？只是不要对我的回答感到震惊，老虎。我的数可能有数百个。"), love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("bimbo"), ("*咯咯笑*答案是肯定的。我将把细节留给你想象。"), love=2)
    add_dialogue("free_flirt_sex_experience average", ("bimbo"), ("*咯咯*如果我说“是”，你打算问我什么？"), love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("bimbo"), ("很抱歉让您失望，但没有您期望的那么多。"))
    add_dialogue("free_flirt_sex_experience very inexperienced", ("bimbo"), ("*叹气*你们这些孩子和你们的脏话。去问任何其他会被你扇耳光的女孩。"), love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("bimbo"), ("我想尝试各种性感的东西，但我还没有这样做。"), love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("very materialist"), ("真的吗?会不会是你不太受女生欢迎?至少你是我的..."), love=-1)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("very lewd"), ("哦,真的吗?找点乐子也无妨，你知道的....我很高兴有一天我能给你看... *眨眼*"), love=-1)

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("bimbo"), ("理论固然很好，但我更喜欢有实践经验的人。"))
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("bimbo"), ("*叹气*超时！这行不通....我们可以对彼此的性话题更加开放吗？"), love=-1)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("very lewd"), ("我明白了...我相信我们可以互相学习..."), love=1)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("very lewd"), ("嘿，小心疾病，你这只公狗... *嘲笑*"), love=5)
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("bimbo"), ("*叹息*我们可以对彼此的性话题更加开放吗？"), love=1)
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("very lewd"), ("好吧，我相信你会积累足够的经验来更好地满足我..."), love=3)

    add_dialogue("free_flirt_sex_act refuses", ("bimbo"), ("我认为还有其他女孩更适合你，所以....抱歉。"))
    add_dialogue("free_flirt_sex_act very reluctant", ("bimbo"), ("如果我回答这个问题，你只会问更多变态的问题，你这个顽皮的孩子。"))
    add_dialogue("free_flirt_sex_act reluctant", ("bimbo"), ("如果我足够喜欢这个人，我就会成功。那么...你的癖好是什么？"))
    add_dialogue("free_flirt_sex_act a little reluctant", ("bimbo"), ("我不太熟悉它，但这听起来像是我喜欢的东西。"))
    add_dialogue("free_flirt_sex_act indifferent", ("bimbo"), ("嘻嘻。我不介意，偶尔。"), love=1)
    add_dialogue("free_flirt_sex_act interested", ("bimbo"), ("你会对我和朋友讨论的事情感到震惊。当然，主要是我在说话。"), love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("bimbo", "pet"), ("嗯...不会撒谎，我有点想和你一起做，就在这里，现在。"), love=2)
    add_dialogue("free_flirt_sex_act very interested", ("bimbo", "pet"), ("哦耶。我一直在做白日梦...*低语*{i}特别是{/i}每当我和你说话时。"), love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("bimbo", "pet"), ("*咧嘴笑*那么，介意我撕掉你的衣服吗？如果我们继续谈论这件事，我就无法再抑制自己了。"), love=3)

    add_dialogue("free_give_gold +++", ("bimbo", "princess", "pervert"), ("你还有时间聊天吗？我喜欢一个有钱可以花的人。 *咧嘴笑*"), love=8, max_cap=75)
    add_dialogue("free_give_gold ++", ("bimbo", "schemer", "pervert"), ("噢！你真的很懂得如何对待女孩！"), love=5, max_cap=75)
    add_dialogue("free_give_gold +", ("bimbo", "schemer", "pervert"), ("抱歉，但这比我平常的费率有点低。*眨眼*开玩笑！"), love=3, max_cap=75)
    add_dialogue("free_give_gold -", ("bimbo", "pervert"), ("对不起，老虎。我没那么容易。"), love=1, max_cap=75)
    add_dialogue("free_give_gold --", ("bimbo", "stubborn", "pervert"), ("别再给我你的零钱了！"), love=-2, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("bimbo"), ["g: 啊，非常感谢您的邀请！我一直在为此钓鱼。我很高兴你终于明白了。 *眨眼*", "g: 你知道，金币和鸡巴 是我最喜欢的两个东西。", "g: 嗯...我很好奇是否可以从您的竞争对手那里撬取一些竞争性报价，但是..."], multiple=True, love=3)
    add_dialogue("free_offer_job half_lie", ("bimbo"), ["g: 啊，你的心里充满了肮脏的秘密，不是吗？ *傻笑*", "g: 这是一个非常诱人的报价....", "g: 我想知道...为您工作是个好主意吗？"], multiple=True, love=5)
    add_dialogue("free_offer_job lie", ("very materialist"), ["g: 啊，所以你一直在撒谎，是吗?这很聪明.", "g: 我想知道人们会怎么想，虽然...", "g: 为你工作是个好主意吗?"], multiple=True, love=4)
    add_dialogue("free_offer_job success", ("very materialist"), ("好吧。这是一个公平的提议。我买了!"))
    add_dialogue("free_offer_job thinking", ("bimbo"), ["g: 给我一些时间来权衡我的选择。", "g: 不是我不信任你，而是我想亲眼看看这个地方再做决定。", "g: 再见！"], multiple=True)
    add_dialogue("free_offer_job failure lie", ("bimbo"), ["g: 你希望我说什么？", "g: 与一条刚刚透露自己喜欢隐藏秘密的蛇签订合约....这可不是什么明智之举，不是吗？", "g: 在我开始发脾气之前，我们就在这里结束这次讨论吧。"], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("bimbo"), ["g: 我不相信将工作与娱乐结合起来是一个好主意。毕竟你会成为我的主人....", "g: 如果我们没有恋爱关系，我会立刻签下这份合约。", "g: 咱们聊点别的吧，我没心情考虑。"], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("bimbo"), ["g: 哇哦！你可能只是走得很远。我印象深刻！", "mc: 那你呢？", "g: 你猜到了吗？我用我的女性魅力来度过....*眨眼*", "g: 我想很像你的女儿们。 *傻笑*"], multiple=True, love=5)
    add_dialogue("free_friend half_lie", ("bimbo"), ["g: 呃...每当我听到 {i}[MC.playerclass]{/i} 这个词时，我就会犯困。", "mc: 那你呢？", "g: 你猜到了吗？我用我的女性魅力来度过....*眨眼*"], multiple=True, love=-3)
    add_dialogue("free_friend lie", ("bimbo"), ["g: 是这样吗？听起来有点无聊，不是吗？", "mc: 那你呢？", "g: 你猜到了吗？我用我的女性魅力来度过....*眨眼*"], multiple=True, love=-2)

    add_dialogue("free_love_interest", ("bimbo"), ["mc: 很高兴见到你，[girl.name]。最近怎么样？", "g:  很好，很好....听着，亲爱的。是时候加强一点了。", "mc: 你什么意思？", "g: 我想我应该是那个说这句话的人吧？", "g: 你想操我吗？因为我知道我想操你。", "mc: 天啊，你真是令人耳目一新。我喜欢！", "g: 是的，是的....你甚至不需要回答这个问题。我知道你想要它。", "g: 我想说的是，如果你想去那里，我们需要让我们之间的事情变得更加正式一些。在我们进入床单之前表现出一些承诺，是吗？"], multiple=True)
    add_dialogue("free_girl get_flowers", ("bimbo"), ("它们看起来很贵！对他们来说有什么意义吗？"))
    add_dialogue("free_ask_out", ("bimbo"), ["mc: 我希望你成为我超级性感的女朋友。", "g: 是的！！我{i}永远{/i}一直在等你说这句话。我太高兴了！", "g: 我迫不及待地想向我所有的朋友吹嘘我的性感男友。 *眨眼*", "g: 让我们很快再次共度美好时光，好吗？"], multiple=True)

    add_dialogue("free_girlfriend intro", ("bimbo"), ["g: [MC.name]，很高兴见到你！你最近怎么样？", "mc: 我很好，我很好....", "当您与 [girl.name] 交谈时，您注意到另一个漂亮的女孩走过，您情不自禁地盯着看。", "g: 嘿，[MC.name]...注意...哈喽？", "你的目光注视着她走路时顽皮地前后摆动的小裙子。", "g: 别再盯着其他女孩了。我希望你的眼睛里只有我一个人。", "突然，一阵风吹起她的裙子！当黑色蕾丝丁字裤的图像烙印在你的视网膜上时，女孩尖叫起来。", "g: ....你有在听吗？", "当您想象剥下那条黑色蕾丝丁字裤时，您突然注意到[girl.name]正满怀期待地盯着您。也许她只是问了你一个问题？", "mc: 哦，哦，是的，亲爱的....当然....", "g: 嗯，真的吗？然后回答我这个..."], multiple=True)
    add_dialogue("free_girlfriend right", ("bimbo"), ["g: *咯咯*所以你在听我说话。", "g: 说实话，有我在的话，没必要这样向其他女孩抛媚眼。", "g: 如果你想欣赏性感的屁股，可以叫我给你脱光。 {i}任何{/i}时间。"], multiple=True, love=5)
    add_dialogue("free_girlfriend give_up", ("bimbo"), ("你没有在听我说话，是吗？ *疯狂的*"), love=-5)
    add_dialogue("free_girlfriend wrong", ("bimbo"), ("你根本没有在听我说话，是吗？ *疯狂的*"), love=-10)
    add_dialogue("free_girlfriend success", ("bimbo"), ["当她把衣服扔到地上时，她会与你保持目光接触。", "她甚至懒得带你去一个僻静的地方。不少围观者驻足观看，目瞪口呆。", "g: *笑*我们开始...所有的目光都集中在我身上！", "g: 如果你有兴趣做任何事情....我愿意。请告诉我！"], multiple=True)
    add_dialogue("free_girlfriend success naked", ("bimbo"), ["当她把衣服扔到地上时，她会与你保持目光接触。", "她甚至懒得带你去一个僻静的地方。不少围观者驻足观看，目瞪口呆。", "g: *笑*我真的不明白有什么大不了的。在家里我总是赤身裸体。", "g: 如果我这样做可以让你的注意力集中在我身上，那我就可以了。", "g: 如果你有兴趣做任何事情....我愿意。请告诉我！"], multiple=True)

    add_dialogue("free_job_request", ("bimbo"), ["g: 哦，[MC.name]！我需要一些建议...", "mc: 发生什么事了？听起来很严重。", "g: 所以我在旁边勾引了一些人....我的意思是，我确信你经常在自己身上胡闹，是吗？", "mc: 呃....不能说我是无辜的....继续吗？", "g: 我惹错了人....是个跟踪狂，对我着迷了....然后那个怪物突然拿着刀出现在我家！", "她看起来心烦意乱。", "g: 我猜他不知何故发现了我们的事。他问了我各种各样关于你和我的问题......", "g: 最终我设法说服他不要做任何鲁莽的事情，但是....", "g: 我、我在自己家里不再感到安全了。如果他回来怎么办？如果他一直跟踪我怎么办？ *哭*", "她泪眼婆娑地看着你.", "g: 我要搬家....我需要保镖....这家伙真是个神经病！ *哭泣*", "mc: 嗯....嗯，也许有一个办法....我的守卫会很容易制服这样的家伙。", "g: 啊？"], multiple=True)
    add_dialogue("gizel take girl to farm", ("bimbo"), ("哈哈！是时候给你这个奴隶荡妇一些理智了。"))
    add_dialogue("slave positive fixation accept", ("generic"), ["哦，我喜欢这个...", "是的，给我吧...", "这太热了...", "哦，这让我兴奋......", "哦是的！我们开工吧。"])
    add_dialogue("slave naked request permanent", ("very lewd"), ("我明白了...好吧，为什么不呢？光着身子的感觉真好，反正泽恩的天气太热了，不适合穿衣服...."), love=2, fear=-2, sound=s_sigh)
    add_dialogue("MC demean rival", ("generic"), ("哦，我会告诉她的！她会生气的！ *笑*"), sound=s_evil_laugh)
    add_dialogue("slave chat tastes likes", ("bimbo", "pervert", "superficial", "princess"), ("我在[best]俱乐部里。真正的[thing_cn]王。 *笑*"), unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("bimbo", "superficial", "princess", "cold"), ("我不喜欢[worst]。那是小孩子的[thing_cn]。"), unlock="LM")
    add_dialogue("slave chat origins 1", ("bimbo", "pervert"), ("没关系，不是吗？ [girl.origin]。"), unlock="EI")
    add_dialogue("slave lecture refuses", ("very lewd"), ("呃！我什至不想去想它。拜托，不要再提这件事了。"))
    add_dialogue("slave lecture very reluctant", ("very lewd"), ("啊不，不是这个！我不是一个正经的人，但这很令人讨厌。"))
    add_dialogue("slave lecture reluctant", ("very lewd"), ("我有我的极限，你知道...这太过分了...*脸红*"))
    add_dialogue("slave lecture a little reluctant", ("very lewd"), ("这不是我最喜欢的...但有时，多样性是好的，我想..."), sound=s_sigh)
    add_dialogue("slave lecture indifferent", ("very lewd"), ("嗯，这只是利用我们的身体来给予快乐，不是吗？就像任何事情一样。"))
    add_dialogue("slave lecture a little interested", ("very lewd"), ("[MC.name]主人，关于这个....我想知道...."), sound=s_surprise)
    add_dialogue("slave lecture interested", ("very lewd"), ("噢，这是个好话题！我想了解更多..."), sound=s_mmh)
    add_dialogue("slave lecture very interested", ("very lewd"), ("我喜欢 [act_desc]...这让我感觉非常好...嗯。"), sound=s_mmh)
    add_dialogue("slave lecture fascinated", ("very lewd"), ("哦，[act_desc] 是最好的！我可以做一整天！主人，为什么不让我给你看呢？"), sound=s_aah)

    add_dialogue("slave train constitution", ("bimbo", "very extravert"), ("是的主人。我想我可以做一点运动。"))
    add_dialogue("slave train refuses", ("very lewd"), ("她对 [act_desc] 的想法感到非常羞愧，甚至无法说话。她的脸是鲜红的。"), sound=s_screams)
    add_dialogue("slave train very reluctant", ("very lewd"), ["我不喜欢这样......为什么我必须继续这样做？啊！！！", "呃，[act_desc]？你让我这么做，尽管这很变态....哇...."], sound=s_scream)
    add_dialogue("slave train reluctant", ("very lewd"), ("你知道我不喜欢这样...别看我...啊哈！"), sound=s_scream)
    add_dialogue("slave train a little reluctant", ("very lewd"), ("你又对我做出变态的事了....我感觉很奇怪...."), sound=s_surprise)
    add_dialogue("slave train indifferent", ("very lewd"), ("嗯嗯，主人...."), sound=s_ahaa)
    add_dialogue("slave train a little interested", ("very lewd"), ("哦，那很好....也许我们今天可以尝试一些新的东西？"), sound=s_ahaa)
    add_dialogue("slave train interested", ("very lewd"), ("嗯，[act_desc]...我已经感觉湿了..."), sound=s_mmh)
    add_dialogue("slave train very interested", ("very lewd"), ("我好饥渴....主人看我的时候我就湿了....啊啊啊...."), sound=s_aah)
    add_dialogue("slave train fascinated", ("very lewd"), ("哦...我已经快高潮了...啊啊，[act_desc] 真是太棒了！"), sound=s_orgasm_fast)

    add_dialogue("slave train naked success", ("very lewd"), ("哦，主人，我想要更多...."), sound=s_aah)
    add_dialogue("slave train service failure", ("very lewd"), ("她感到沮丧和羞愧，开始哭泣。"))
    add_dialogue("slave train sex success", ("very lewd"), ("主人，我高潮了....啊啊啊！我喜欢被这样操！"))
    add_dialogue("slave train anal failure", ("very lewd"), ("我....我不能这样做。不可能。"))
    add_dialogue("slave train anal success", ("very lewd"), ("啊啊啊！！！我爱死了！啊哈！！！这是最好的..."))
    add_dialogue("slave train fetish failure", ("very lewd"), ("等等，不是这个！"))
    add_dialogue("slave train fetish success", ("very lewd"), ("主人，请伤害我吧....这让我很开心....啊啊！"))
    add_dialogue("slave train bisexual failure", ("very lewd"), ("太糟糕了！我不能对女人做任何正确的事情..."))
    add_dialogue("slave train bisexual success", ("very lewd"), ("请原谅我，主人，但我必须说....我喜欢小穴...."), sound=s_mmh)
    add_dialogue("slave train group failure", ("very lewd"), ("哎呀，三个人太多了，哥们....我们不能轮流做吗？"))
    add_dialogue("slave train group success", ("very lewd"), ("我可以服务更多！十几个人！让我证明一下..."))
    add_dialogue("slave reward sex accepted", ("very lewd"), ("当然，主人。我自慰了很多次，想着那一刻....*脸红*"), love=3, sound=s_ahaa, unlock="LM")
    add_dialogue("slave reward sex resisted", ("bimbo", "very dom"), ("这....这连奖励都算不上....唉...."), love=-1, sound=s_surprise, unlock="LM")

    add_dialogue("slave reward praise", ("very materialist"), ("嗯...你要给我一些东西吗？言语很廉价。"), love=-1, unlock="MI")
    add_dialogue("slave reward gold", ("very materialist"), ("哦，金子！太好了....谢谢主人！"), love=2, unlock="MI")
    add_dialogue("slave reward pet", ("bimbo", "very dom"), ["你拍拍她的头一分钟，而她只是被动地站在那里。结束后她迅速离开。", "g: 谢谢....这就足够了。我得走了。"], multiple=True, love=-1, unlock="DS")
    add_dialogue("slave reward day off", ("bimbo" , "very sub", "very introvert"), ("呃？嗯....谢谢主人。我会努力享受它。"), love=-1, unlock="DS")

    add_dialogue("slave punish scold deserved", ("very materialist"), ["她嗤之以鼻。", "g: 是的，对....随你怎么说。"], multiple=True, fear=-2, unlock="MI")
    add_dialogue("slave punish scold undeserved", ("very materialist"), ["她嗤之以鼻。", "g: 是的，对....随你怎么说。"], multiple=True, fear=-1, unlock="MI")
    add_dialogue("slave punish upkeep", ("very materialist"), ("什么？！？不！！！"), fear=1, unlock="MI")

    add_dialogue("slave punish beat", ("bimbo", "very dom"), ["她咬紧牙关，等待惩罚结束。", "我不在乎你对我做什么...啊啊！！！"], multiple=True, sound=s_screams, unlock="DS")
    add_dialogue("slave punish farm", ("bimbo", "very sub"), ("农场....真是个可怕的地方...."), unlock="DS")
    add_dialogue("slave punish naked", ("very lewd"), ("主人....你在做什么....啊啊！"), fear=-1, unlock="LM")
    add_dialogue("slave punish naked KO", ("generic"), ["g: 呃？但是主人....我已经赤身裸体了....", "mc: 呃....当然。我知道。那是个笑话。啊哈哈哈..."], multiple=True)
    add_dialogue("slave punish rape", ("very lewd"), ("主人....你在做什么....啊啊！"), fear=1, unlock="LM")
    add_dialogue("slave rape negative fixation", ("generic"), ("不，不是这个！！！不不不！！！"), love=-2, fear=3, sound=s_scream_loud)
    add_dialogue("advertise", ("generic"), ["先生！您愿意来看看我们的商品吗？ *咯咯笑*", "我很孤独，先生....你能进来陪我吗？", "我好饥渴....我爱你很久了....", "先生，您喜欢您所看到的吗？ *傻笑*", "进来吧，先生！你知道你想。", "法律规定不能碰，但我想我看到这里有很多违法者....", "如果你想要我的身体并且你认为我很性感，来吧亲爱的，告诉我吧！ *眨眼*", "来参加聚会吗，先生？ *傻笑*", "看过我的节目吗？不，没有乒乓球，但它很好，相信我！", "进来吧，糖！我会给你一些特别的东西..."])
    add_dialogue("beach meet MC", ("very lewd"), ["g: 您好，[MC.name]主人！你欣赏风景吗？", "她毫不谦虚地炫耀自己的美貌，当她观察你的反应时，眼中闪烁着顽皮的光芒。", "mc: 是啊....确实很好....", "g: 哈哈，我可以告诉你你喜欢它。 *眨眼*"], multiple=True)
    add_dialogue("beach oiling", ("very lewd"), ["这太棒了，你能做得更多吗....嗯，是的，就像这样。这里也请..."], sound=s_ahaa)
    add_dialogue("beach accept oiling", ("very lewd"), ["哦，你真顽皮....嗯...."])

    add_dialogue("beach accept public sex", ("very lewd"), ["g: 我以为你永远不会问！", "她立刻就抓住了你的鸡巴，用双手拉下了你的裤子。"], multiple=True)

    add_dialogue("beach accept sex", ("very lewd"), ["为什么不？应该会很好玩..."])

    add_dialogue("beach whoring request", ("very materialist"), ["免费工作？在我休息日？我勒个去！"])
    add_dialogue("beach whoring accept", ("very lewd"), ["好吧，反正我也没有很多其他事情要做....叫我妓女吧....但我会做的。"])
    add_dialogue("beach whoring refuse", ("very materialist"), ["哼，我也不想啊！你需要付给我更多的钱才能让我放弃休息日......"])

## START HELPER DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("helper", "sweet", "pet"), ["g: 哈哈，不用跟我这么正式....", "g: 我是[girl.fullname]，先生....或者我应该称您为您最尊贵、最尊贵、最值得尊敬的阁下还是什么？！ *咯咯笑*"], multiple=True)
    add_dialogue("free_greetings_casual", ("helper", "sweet", "pet", "prude"), ("很高兴认识你，我是[girl.fullname]。你的口音不是这里的！我很好奇;是什么让像[MC.name]这样的人来到Zan？ "), love=1)
    add_dialogue("free_greetings_rude", ("helper", "sweet", "pet"), ["g: 哦，你很直接，不是吗？我是[girl.fullname]。", "g: 我想知道你想要什么。 *咯咯笑*", "g:  很高兴能更多地了解您。你的口音不是这里的！是什么让像 [MC.name] 这样的人来到 Zan 身边？"], multiple=True, love=2)

    add_dialogue("free_small_talk", ("helper", "nerd"), ("非常真实...很高兴与您聊天！", "这是真实的！顺便说一句，昨天我发生了一件奇怪的事情。我遇到了一只长相很奇怪的猫！", "很好的观察！这确实让你想知道，不是吗？", "好吧，[MC.name] 先生，您今天不是充满了观察吗？", "我也这么认为。很高兴与您谈论各种事情。我只是在想，稍后可能会下雨。", "哈哈，没错！对了，我有没有告诉过你我最近是怎么遇到一只长相奇怪的猫的....或者可能是一个打扮成猫的女孩！"), love=1, max_cap=25)
    add_dialogue("free_gossip", ("helper", "pet"), ("哈哈，前几天我和我的一个女朋友聊天，她告诉我一些非常好奇的事情！", "我听到了一些非常有趣的事情！", "八卦吧？我最好的朋友告诉我一些非常有趣的事情！", "你是一个什么都喜欢聊，又什么都喜欢聊的人。这就是我喜欢你的地方，[MC.name]！你听说过这个吗...？", "我喜欢你如此愿意聊天和八卦。这就像和我的一位女朋友说话，尽管你是个男人！就在前几天，我听说..."), love=2, max_cap=25)
    add_dialogue("free_chat_life", ("helper", "sweet"), ("这些都是非常大的事情！我一般不会考虑这么深层次的问题。我只是喜欢和我的朋友见面并和他们一起出去玩。我想我是一个很正常的女孩。", "在我的生活中，我喜欢和朋友们一起出去玩。他们对我来说非常重要。当他们遇到困难时，我提供一个可以依靠的肩膀。", "我想我只是一个很普通的女孩。我很享受我的生活。我喜欢做我喜欢的事情。我也喜欢做我朋友喜欢的事情。差不多就这样了。"), love=1, max_cap=25)
    add_dialogue("free_chat_love", ("helper"), ["g: 当我的女朋友遇到男孩麻烦时，我经常会帮助她们。", "g: 这意味着我对你们了解很多。", "g: 当他们找到一个特别的人时，这让我非常高兴......", "g: 但有时我想知道，这种事会发生在我身上吗？", "她看起来有点悲伤。"], multiple=True, max_cap=25)
    add_dialogue("free_chat_origins", ("helper"), ("哦，原来你今天要聊的就是这个！我来自[girl.origin]。", "哦，原来你今天要聊的就是这个！我出生在[girl.origin]。", "哦，这就是你今天想聊的内容，[MC.name] 先生！我的家人来自[girl.origin]。"), love=2, max_cap=40)
    add_dialogue("free_chat_hobbies", ("helper"), ("我的空闲时间？虽然我喜欢出去，但我并不总是有那么多时间专注于我真正喜欢的事情。不过，我还是会说[hobby]。", "如果有空闲时间，我喜欢[hobby]，那就最好了！", "我喜欢和朋友一起出去玩、聊天。我们通常只是做他们喜欢的事情，但一旦它成为[hobby]，我真的很喜欢！"), max_cap=40)
    add_dialogue("free_chat_likes", ("helper", "sweet", "pet"), ("哈哈，我喜欢告诉我的朋友，我最喜欢的[thing_cn]是[best]。", "哦....你真的想知道吗？我认为[best]就是最好的[thing_cn]。", "在这个女孩看来，[best]就是最好的[thing_cn]。"), max_cap=40)
    add_dialogue("free_chat_dislikes", ("helper", "pet", "sweet"), ("我曾经和一些朋友谈到过这个问题，我真正不喜欢的一件事是[worst]。呃！", "哦...好问题...我讨厌的一件事是[worst]。", "虽然我喜欢陪伴我的朋友，但有一次他们中的一个人说他们喜欢[worst]。我没有告诉她，但我只是不明白这一点......", "我真的不喜欢[worst]。我认为这是最糟糕的[thing_cn]。不过，如果我的朋友喜欢它，我会尽量不去评判，因为我更看重与她的友谊。"), love=2, max_cap=40)

    add_dialogue("free_joke_harmless", ("helper", "loyal"), ("呃，这太愚蠢了！", "愚蠢的笑话。不好笑。", "你的笑话太愚蠢了。", "这很荒谬，但不是一个好的方式。"), love=-2, max_cap=50)
    add_dialogue("free_joke_adult", ("helper", "pet", "loyal"), ("啊啊啊....太搞笑了！你真搞笑！", "诶诶诶....真是太脏了！ *脸红和咯咯笑*", "tshihii...也许我不应该笑这种黄色的笑话，但我就是控制不住自己！"), love=3, max_cap=50)
    add_dialogue("free_joke_dark", ("helper", "prude"), ("哈哈....我想这很有趣。适合喜欢黑色笑话的人。", "呃呃....还不错。不过，这些类型的笑话并不是我真正喜欢的。", "这对我来说有点黑色幽默...."), love=1, max_cap=50)
    add_dialogue("free_joke_mean", ("helper", "pet", "holy"), ("由太阳神！这实在是太卑鄙了，但却很有趣！", "我简直不敢相信你刚才说的话，[MC.name]！", "我还没有遇到过有胆量开这样的玩笑的人。", "很刻薄，但很有趣！", "哈哈....你真是个混蛋！像我这样的女孩该拿你做什么？ *脸红*"), love=3, max_cap=50)

    add_dialogue("free_touch_hand", ("helper", "loyal", "sweet", "generic"), ("感觉真好！", "你真可爱，亲爱的！", "很不错。", "很浪漫！", "太浪漫了！", "你今天真是个绅士，[MC.name]。"), love=1, max_cap=90)
    add_dialogue("free_touch_kiss", ("helper"), ("有点太个人化了。我不值得这个...", "但为什么？", "你为什么吻我？"), love=-1, max_cap=90)
    add_dialogue("free_touch_ass", ("helper", "pet", "holy"), ("哎呀，太强了！ *脸红*", "我喜欢你这样对待我！虽然也许我不应该...*脸红*", "*哎哟*你真是把这个女孩放在了她的位置上！ *咯咯笑*", "喂....你真是个混蛋！像我这样的女孩该拿你做什么？ *有点脸红和咯咯笑*"), love=5, max_cap=90)
    add_dialogue("free_touch_breasts", ("helper", "pet"), ("不知怎的，我感觉你喜欢我的乳头。 *腼腆地微笑*", "当你触摸我那里时，感觉很好。", "我喜欢你爱抚我的乳头，但你愿意做更多吗？ *脸红*"), love=2, max_cap=90)
    add_dialogue("free_touch_pussy", ("helper", "pet"), ("哇，你真的是在追求自己想要的东西！", "天哪，太阳神！那种感觉很好...", "哦哦...*脸红*", "啊啊啊....", "我是你的，[MC.name]。", "哎呀，我的两腿之间有一只男人的手！我们怎么这么快就陷入了这种境地？ *微笑*"), love=4, max_cap=90)

    add_dialogue("free_play refuses", ("helper"), ("没有机会！迷路！！！"), love=-1)
    add_dialogue("free_play very reluctant", ("helper", "pet"), ("如果你真的愿意的话我会做的...但这根本不是我喜欢的事情..."), love=1)
    add_dialogue("free_play reluctant", ("helper", "pet"), ("没关系，如果这就是您{i}真正{/i}想要做的..."), love=2)
    add_dialogue("free_play a little reluctant", ("helper", "pet"), ("如果这就是您{i}真正{/i}想做的事情，那么我们就开始吧..."), love=2)
    add_dialogue("free_play indifferent", ("helper", "pet", "generic"), ("嗯....是的...."), love=3)
    add_dialogue("free_play a little interested", ("helper", "pet", "very sub"), ("嗯...我是你的，[MC.name]..."), love=4)
    add_dialogue("free_play interested", ("helper", "pet", "very sub"), ("哦...请带我，[MC.name]...我想成为你的。"), love=4)
    add_dialogue("free_play very interested", ("helper", "pet", "very sub"), ("哦，是的...我已经想起来很湿了...我想成为你的...完全属于你。"), love=5)
    add_dialogue("free_play fascinated", ("helper", "pet", "very sub"), ("哦哦，是的....我已经湿透了....我想完全臣服于你！就带我做你想做的事吧，[MC.name]！"), love=5)
    add_dialogue("MC take virginity", ("helper"), ["g: 你...你是我的第一个男人...", "g: 我迫不及待地想和我的女朋友们谈论这个！", "g: 我第一次听说过他们的一切....现在我们终于可以比较了！"], multiple=True, love=5)
    add_dialogue("free_play interested after", ("helper", "pet"), ("哦，那真是太好了....*脸红*", "哦，那太好了！我喜欢把自己奉献给你...*害羞地微笑*", "我希望这对你和对我一样好！"))
    add_dialogue("free_play not interested after", ("helper"), ["g: 我帮你满足了你的需求......", "g: 我希望这对您有好处，[MC.name]先生....", "g: 我确实很享受把自己奉献给你...但同时我希望，也许你可以多关注一下我喜欢的东西..."], multiple=True)

    add_dialogue("free_flirt_beauty", ("helper"), ("你这么说只是因为你想欺负我。", "哦真的吗...？", "这感觉不对。你真的是这个意思吗？", "从你说的方式来看，感觉你不是真心的....", "你让我很好奇。为什么这么说？周围有很多漂亮的女孩，其中一些就在同一条街上......"), love=-1, max_cap=75)
    add_dialogue("free_flirt_body", ("helper", "loyal"), ("这是我的身体。就是这样。我无能为力。我希望你更关心里面的东西。", "我不禁想知道，你为什么对我的身体这么感兴趣？"), love=-1, max_cap=75)
    add_dialogue("free_flirt_mind", ("helper", "loyal"), ("谢谢你！看来你今天还真是考虑周全啊....", "谢谢，也许你关心的不仅仅是外表....", "谢谢，我很高兴你认为我很聪明！我一直以为我只是一个很普通的女孩。 *快乐的*", "你喜欢我的心思吗？这个赞美让我很开心！ *微笑*"), love=1, max_cap=75)
    add_dialogue("free_flirt_spirit", ("helper", "sweet"), ("非常感谢！我尝试帮助我周围的人。", "谢谢你，[MC.name]。我喜欢保持精神振奋，让我的朋友和亲人高兴起来。", "谢谢！我努力做到。没有人喜欢总是脾气暴躁的人。我的[girl.story_guardian]经常是这样，我必须小心并保持精神振奋。", "为什么要谢你！你觉得有精神吗？这个赞美不知何故让我很开心！ *快乐的*"), love=3, max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("helper"), ["她笑着说.", "g: 嘿！如果您知道就好了....我确实有社交生活，而且不仅仅限于拥有很多朋友。", "g: 我已经在卧室里做了所有的事情，而且还做了更多！ *眨眼*"], multiple=True, love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("helper"), ["她伸出舌头.", "g: 我确实有社交生活，而且不仅仅限于你认识的女朋友....*眨眼*"], multiple=True, love=2)
    add_dialogue("free_flirt_sex_experience average", ("helper"), ["她脸红.", "g: 天啊，你真是个开门见山的人....", "g: 当然，我也有过一些情人。", "g: 你难道希望我一生都在等待[MC.name]先生出现的那一天吗？ *咯咯笑*"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("helper"), ["她脸通红.", "g:  根本不是那样的！我有过几个情人，但都不是很认真的。"], multiple=True)
    add_dialogue("free_flirt_sex_experience very inexperienced", ("helper"), ["她看起来有些惊讶，甚至震惊。", "g: 我不是那种女孩....我不会和很多男人鬼混。", "她皱眉."], multiple=True, love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("helper"), ["她看起来完全震惊了", "g: 我不是荡妇，你知道的！", "g: 我从来没有做过....{b}它{/b}。*脸红*", "g: 我正在等待合适的男人，就像一个好女孩应该做的那样。"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("helper"), ("哦真的吗？我没想到你这么缺乏经验...."))
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("helper"), ["g: 哦，真的吗？我没想到你这么缺乏经验....", "g: 我可能只是一个傻女孩，但你真的希望我傻到相信这一点吗？"], multiple=True, love=-1)

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("helper"), ["她皱眉.", "g: 就几个吧？你看起来睡过很多女孩。", "g: 当我的朋友警告我关于你的事情时，也许我应该注意。"], multiple=True)
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("helper"), ["她皱眉.", "g: 就几个吧？我看得出来，你睡过很多女孩，却对我不诚实。", "g: 当我的朋友警告我有关你的事情时，我应该注意的。"], multiple=True, love=-1)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("helper"), ["g: 我明白了....*她会意地笑了*", "g: 我{i}以为{/i}你是一个知道如何吸引女孩的男人。", "g: 我有点受宠若惊，这么一位经验丰富的人竟然把目光投向了我....", "g: 通过听我的朋友谈论他们与男孩的经历，我学到了很多东西。", "g: 也许我可以从你那里学到更多....", "g: 你知道，更直接一点...如果你能告诉我就好了...*害羞地微笑*"], multiple=True, love=5)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("helper"), ("哦，哇，你真是个猛男！我的 [girl.story_guardian] 警告过像你这样的男人....但我忍不住发现你很有趣。 *笑*"), love=2)
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("helper"), ("哦，你是？你为什么告诉我？我不太关心这个..."))
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("helper"), ["g: 我想这是预料之中的....", "g: 我很欣赏你对工作的诚实....", "g: ....我想在你的工作中你最终会和很多女孩上床。", "g: 我想知道，像我这样的普通女孩相比之下会有何感受。 *脸红*"], multiple=True, love=1)

    add_dialogue("free_flirt_sex_act refuses", ("helper", "pet"), ["她好像没听懂，所以你必须重复这个问题。", "g: 我不知道你在说什么。", "她看起来真的很困惑，你就放弃了话题。"], multiple=True)
    add_dialogue("free_flirt_sex_act very reluctant", ("helper"), ["她厌恶地看了你一眼.", "g: 这些问题是怎么回事？我不是那种女孩。我更喜欢我们的聊天内容是天气和八卦。"], multiple=True)
    add_dialogue("free_flirt_sex_act reluctant", ("helper"), ["她皱眉.", "g: 我{i}很{/i}熟悉这一点，尽管我希望我不是....我们可以谈谈别的事情吗....？甚至生命、宇宙、一切....", "g: ....虽然我对此了解不多。"], multiple=True)
    add_dialogue("free_flirt_sex_act a little reluctant", ("helper"), ["她皱眉.", "g: 我真的不是特别喜欢这个。我想我可以被说服去尝试，但可能不会...."], multiple=True)
    add_dialogue("free_flirt_sex_act indifferent", ("helper", "sweet", "loyal"), ["她想了一会儿.", "g: 那还不错....我不介意...."], multiple=True, love=1)
    add_dialogue("free_flirt_sex_act interested", ("helper"), ["她脸红.", "g: 嗯....天啊，最好不要谈论这个，你会让我想做的....", "谈论奇怪的动物和天气更安全。"], multiple=True, love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("helper", "sweet"), ["她脸红.", "g: 嗯....哦天哪，最好不要谈论这个，你会让我性欲旺盛的...."], multiple=True, love=2)
    add_dialogue("free_flirt_sex_act very interested", ("helper", "sweet", "pet"), ["她舔了舔嘴唇.", "g: 我喜欢它...这是我在床上最喜欢的东西之一。"], multiple=True, love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("helper", "sweet", "pet"), ["她舔了舔嘴唇.", "g: 别让我开始，我喜欢它......这是世界上我最喜欢的东西之一。", "g:  真是太棒了！"], multiple=True, love=3)

    add_dialogue("free_give_gold +++", ("helper", "generic", "very sub", "nerd", "sweet"), ("我从来没有见过这么多钱！真的，我发自内心的感谢你们！谢谢你，[MC.name]！"), love=6, max_cap=75)
    add_dialogue("free_give_gold ++", ("helper", "holy", "prude"), ("作者：Arios，真的很多，非常感谢！", "哦谢谢！这是一个很大的帮助！我想知道，你从哪里得到这么多钱？"), love=4, max_cap=75)
    add_dialogue("free_give_gold +", ("helper"), ("谢谢你，你人很好，会给我很大帮助。", "哦谢谢！这是一个很大的帮助！我想知道，你从哪里得到这么多钱？"), love=2, max_cap=75)
    add_dialogue("free_give_gold -", ("helper"), ("你为什么要给我钱？你让我很好奇...你想从我这里得到什么吗？"), max_cap=75)
    add_dialogue("free_give_gold --", ("helper", "repressed", "class president"), ("你的钱从哪里来？！", "这笔钱从哪里来？你为什么要把它给我？你的行为很可疑，[MC.name] 先生。"), love=-1, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("helper"), ["她给你一种害羞、崇拜的表情。", "g: 我很高兴你告诉我有关你工作的真相。这给了我时间去思考...",  "g: 我想和你在一起，即使这意味着成为你的奴隶。事实上，我很想成为那样的人。 *脸红*", "g: 你认为我可以在你的青楼工作吗？", "g: 周围还有很多其他女孩，不是吗？", "g: 我喜欢有很多女朋友在身边聊天！"], multiple=True, love=1)
    add_dialogue("free_offer_job half_lie", ("helper"), ["g: 你从没告诉过我!", "mc: 我当时认为这并不重要...", "g: 所以我的朋友警告我关于你的事是对的？你是青楼老板。", "g: 但我不介意。你看，就在前几天，当我的朋友警告我不要再花这么多时间和你在一起时，我告诉她......", "g: 那如果他是呢？这是世界上最古老的职业，许多人在泽恩这里从事这种职业！", "g: [MC.name]对我很好。也许我会去青楼帮助他，而不是总是帮助你解决问题！"], multiple=True, love=1)
    add_dialogue("free_offer_job lie", ("helper"), ["g: 你从没告诉过我!", "mc: 我当时认为这并不重要...", "g: 所以我的朋友警告我关于你的事是对的？你是青楼老板！", "g: 但是....我不介意。你看，就在前几天，当我的朋友警告我不要再花这么多时间和你在一起时，我告诉她......", "g: 那如果他是呢？这是世界上最古老的职业，许多人在泽恩这里从事这种职业！",  "g: [MC.name]对我很好。也许我会去帮助他去青楼，而不是帮助你解决所有的问题！"], multiple=True, love=1)
    add_dialogue("free_offer_job success", ("helper"), ["g: 好吧，我别无选择....", "g: 我想永远靠近你。我会尽一切努力留在你身边。", "g: 我会成为你的奴隶和妓女，并帮助你打理你的青楼。我是你的。请带我看看我的新家，[MC.name]主人。"], multiple=True)
    add_dialogue("free_offer_job thinking", ("helper"), ["g: 谢谢你的邀请....但是...", "g: 我很受诱惑....尽管我爱你，想永远靠近你，但成为奴隶和妓女是一件大事。我需要想一想。", "她离开了，看上去若有所思."], multiple=True)
    add_dialogue("free_offer_job failure lie", ("helper"), ["g: 让 Shalia 让你见鬼去吧，我就是这么想的！你觉得我是个什么样的女孩子啊！", "g: 你骗了我，现在你还想让我去你那愚蠢的青楼工作！我还不如死了，你这个撒谎的混蛋！", "g: 滚蛋!", "她离开了，看起来很生气.", "mc: 进展顺利。等她冷静下来再说吧?"], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("helper"), ["g: 让 Shalia 让你见鬼去吧，我就是这么想的！你觉得我是个什么样的女孩子啊！", "g: 你认为因为我愿意在你的生意上做饭或做衣服，我会成为一个漂亮的小妓女吗？", "g: 滚蛋!", "她离开了，看起来很生气.", "mc: 进展顺利。等她冷静下来再说吧?"], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("helper"), ["g: 你就是这么做的吗？！", "g: 我很欣赏你的诚实态度。", "g: 说实话，我对那种地方里面的样子有点感兴趣！也许你可以找个时间带我看看那个地方？", "g: 也许我可以帮助你？", "g: 你需要做饭或者为女孩们做衣服方面的帮助吗？我确信我可以做{i}某事{/i}。", "mc: 你真是太好了，[girl.fullname]。", "mc: 女孩们经常没有衣服，我们有食物，但你还可以做其他工作......", "mc: ....但是因为我们才刚刚成为朋友，所以我首先需要更好地了解你....", "mc: ...并进一步评估您的技能...嗯...密切..."], multiple=True, love=3)
    add_dialogue("free_friend half_lie", ("helper"), ["g: 哦，我明白了。 [MC.playerclass] 听起来非常适合您！", "g: 我和一位好朋友聊天。她说不要相信那个人，[MC.name]。他看起来像个青楼老板！", "g: 我说，不可能！不是[MC.name]。他太善良了！我们只是好朋友。", "g: 有时我们只是闲聊，有时讨论一些深奥的事情，比如生命、宇宙和一切，尽管[MC.name]比我更理解。", "g: 有时他会给我钱，还开玩笑说我身材火辣。", "g: 这都是朋友做的事。", "g: 下次见到我的朋友时，我会告诉她你是[MC.playerclass]。那她就会相信我了！"], multiple=True)
    add_dialogue("free_friend lie", ("helper"), ["g: A...[lie]？我应该相信你吗？", "g: 你让我对你很好奇。我可以告诉你的一件事是你没有[lie]。", "g: 我和一位好朋友聊天。她说不要相信那个人，[MC.name]。他看起来像个青楼老板！", "g: 我说，不可能！不是[MC.name]。他太好了，但我真的应该相信你是一个[lie]吗？ *皱眉*", "mc: 哈哈,肯定...你呢，你是做什么的?", "g: 哦，你知道的，这个那个..."], multiple=True, love=-3)

    add_dialogue("free_love_interest", ("helper"), ["mc: Hi, [girl.name]. 出什么事了吗?", "g: 呃，我？不....几天前，在一个美丽的[season]日，我刚刚和我最好的朋友之一聊天....", "g: 一位非常和蔼可亲的年轻人来找她，还给她带来了一朵可爱的花。", "g: 我当然为她感到非常高兴....", "g: 但内心深处让我想知道，这种事会发生在我身上吗？我想可能不会。我什至还哭了一点。", "g: 但后来她说，也许那个你一直在谈论的男人[MC.name]会给你带来一个！", "g: 我想，Arios，也许这可能会发生！我觉得我们已经变得如此亲密，我发现与你交谈如此轻松。", "g: 当然不是为了给你带来任何压力！"], multiple=True)
    add_dialogue("free_girl get_flowers", ("helper"), ["g: 你真是太好了....但是有理由吗？！", "我很好奇你想要什么？"], multiple=True)
    add_dialogue("free_ask_out", ("helper"), ["mc: [girl.name]，我喜欢你。但也许我们可以更接近....你知道，把这提升到一个新的水平吗？", "g: 你想让我...做你的女朋友?", "mc: 没错.", "g: 怎么，你终于问了！当然！我迫不及待地想把这件事告诉我所有的朋友！", "她扑进你的怀抱，给你一个又长又深的吻.", "g: 我会尽一切努力留在你身边并完全属于你。"], multiple=True)

    add_dialogue("free_girlfriend intro", ("helper"), ["g: 哦，[MC.name]！来这里吧，亲爱的...", "mc: 嗨,我的爱人。你今天好吗??", "g: 我很好，亲爱的...你应该跟我一起去，我要给你看一些我想你已经想要了很长时间的东西...", "mc: 这么突然, 当然...", "g: 但首先，为了知道你真的关心我，而不是装模作样，我想问你一个问题。"], multiple=True)
    add_dialogue("free_girlfriend right", ("helper"), ["g: 你说得对，干得好！你显然很关心我，看起来像个坚强的男人，可以照顾我。一个我可以完全奉献自己的人！", "g: 我想永远靠近你。"], multiple=True, love=5)
    add_dialogue("free_girlfriend give_up", ("helper"), ("我猜你并不真正关心我喜欢什么和不喜欢什么...... *皱眉*", "对你来说我只是一个愚蠢的随机女孩。你一开始为什么来找我说话？"), love=-5)
    add_dialogue("free_girlfriend wrong", ("helper"), ["g: 不，这根本不对...我猜你并不真正关心我喜欢什么和不喜欢什么...*皱眉*", "g: 对你来说我只是一个愚蠢的随机女孩。你一开始为什么来找我说话？"], multiple=True, love=-10)
    add_dialogue("free_girlfriend success", ("helper"), ["她把衣服扔在地上，凝视着你的眼睛.", "g: 既然你已经向我展示了你的关注和照顾我的能力....现在是你应该拥有我的时候了。", "g: 你喜欢你现在看到的吗?", "你可以感觉到你的鸡巴每一秒都变得更硬。她似乎注意到了这一点，并对你微笑。", "g: 也许我可以帮你....*脸红并微笑*"], multiple=True)
    add_dialogue("free_girlfriend success naked", ("helper"), ["当她脱下衣服时，你喘息着。", "g: 你不觉得对自己的身体感到舒适是一种美妙的感觉吗?", "g: 当我在家里裸体的时候，我总是觉得很舒服。我希望我能一直裸体!", "g: 但我当然不会光着身子在镇上转悠... *叹气* 我还没疯.", "g: 不过，我很高兴能向你展示真实的自己....你看起来也很开心! *咯咯笑*", "g: 也许我可以帮助你解决下面的问题... *眨眼*"], multiple=True)

    add_dialogue("free_job_request", ("helper"), ["g: 你有...你有和其他女孩约会吗?", "mc: 呃?", "g: 告诉我真相....哦，我知道....我看到你和他们在一起....感觉我的心都要炸了!", "g: 我以为我能接受，但我就是不能！", "mc: 我很抱歉....我...我会解释的...", "g: 没关系。我知道你是谁。你不必爱我，但我爱你。我想永远靠近你。", "g: 我愿意做任何事留在你身边。即使你愿意，我也愿意做你的奴隶.", "g: 你愿意接受我吗？我求你了，请接受我....我是你的!", "mc: 呃... 我....让我想想..."], multiple=True)

    add_dialogue("accept farm", ("helper"), ("我明白了...我一定不知怎么惹你不高兴了...", "哦，农场....如果我必须的话，主人...", "既然你这么说，主人.", "那我就走吧...", "我明白，主人."))
    add_dialogue("gizel take girl to farm", ("helper"), ("快点吧，奴隶。奴才不会自己挤奶。"))
    add_dialogue("slave thanks", ("helper"), ("谢谢。", "谢谢主人。", "谢谢你，[MC.name]主人。", "谢谢主人。", "谢谢主人。我很感激。", "谢谢你，我很感激。"))
    add_dialogue("slave naked request permanent", ("helper"), ("谢谢您，主人....无论如何，衣服在这行工作中都是碍事的....*咯咯笑*"), love=2, fear=-1, sound=s_sigh)
    add_dialogue("slave naked request accept", ("helper", "loyal", "sweet"), ("好吧，主人....我想....那么今天就裸体工作吧....", "好吧好吧....我想今天就全部展示出来吧。", "好吧....如果对生意有帮助的话，我今天就裸体去。", "我....我会让那些男人看到我的....我的整个身体....并玩一点。希望对企业有所帮助。", "*她用力吞咽口水，然后耸耸肩*...我想今天是一个裸体工作日然后...", "好吧，主人....如您所愿....我猜[girl.fullname]今天会裸体为那些男人服务。 *她行屈膝礼*"), love=1, sound=s_ahaa)
    add_dialogue("slave naked request resist", ("helper", "loyal", "sweet"), ("不，我不想这样做！", "不，主人，拜托了！这太不舒服了", "不，主人，求求你....我太害羞了，不敢去....*吞咽*....今天裸体。"), love=-2, fear=-2)
    add_dialogue("slave toggle naked on", ("helper"), ("是的主人。我很高兴展示自己！顾客似乎也很喜欢它！ *微笑*"))
    add_dialogue("slave toggle naked off", ("helper"), ("好的，主人....我会把它们放回去...."))
    add_dialogue("MC praise friend", ("helper"), ("噢，谢谢主人！她会很高兴听到你这么说。 *微笑*"), sound=s_laugh)
    add_dialogue("slave chat tastes likes", ("helper", "sweet", "pet"), ("我们有时会和其他女孩谈论这个。我最喜欢的[thing_cn]是[best]。", "我真的很高兴你想了解你的女奴，主人！简单来说，我认为[best]就是最好的[thing_cn]。", "在这个女孩看来，[best]就是最好的[thing_cn]。谢谢您向我询问，主人。 *微笑*"), unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("helper", "pet", "sweet"), ("我曾经和其他女孩讨论过这个问题，我真正不喜欢的一件事是[worst]。呃！", "我很高兴你对你的奴隶感兴趣，主人。我讨厌的一件事是[worst]。", "我有时会和其他女孩谈论这个问题。有一次他们中的一个人说他们喜欢[worst]。我没有告诉她，但我只是不明白这一点......", "我真的不喜欢[worst]。我认为这是最糟糕的[thing_cn]。不过，如果其中一位顾客喜欢它，我会像一个好女孩那样尽量保留自己的意见。"), unlock="LM")
    add_dialogue("slave chat origins 1", ("helper"), ("我很高兴你对我感兴趣，主人。我来自[girl.origin]。", "谢谢主人的提问。我出生在[girl.origin]。", "我很高兴你对我感兴趣，[MC.name]主人。我的家人来自[girl.origin]。"), unlock="EI")
    add_dialogue("origin Zan", ("helper"), ["g: 我对昙镇的老街了如指掌.... ", "g: 但是如果你不富有的话，玉城可能会是一个艰难的地方。我的[girl.story_guardian]经常感到疲倦且心情不好。", "g: 我是一个非常活跃和健谈的小女孩，但这并没有帮助我。", "g: 我的[girl.story_guardian]过去常常对我发脾气，但我学会了避开。", "g: 有时候我想，是不是有一个脾气这么暴躁的[girl.story_guardian]让我对别人的感受变得如此敏感。", "g: 我的意思是我喜欢帮忙，但有时我会牺牲自己的需要！", "g: 我讨厌打架！我讨厌告诉别人一些他们不想听的事情。你注意到了吗？你懂我的意思吗？", "mc: 我注意到了，[girl.fullname]，但对他人的需求敏感对于性奴隶来说并不是一件坏事。", "mc: 你常常不得不把自己的需求放在一边，只做让客户满意的事情。", "mc: 你是一个非常聪明、富有同情心的女孩。如果你接受自己本来的样子，你就会成为一流的妓女。", "mc: 如果你拥抱自己，你很快就会学会像奴隶一样去取悦鸡巴。", "g: 当然了，主人...."], multiple=True)
    add_dialogue("origin the border with the Holy Lands", ("helper", "pet"), ["g: 圣地是一个充满战争和苦难的地方，只不过是不同信仰的战场。", "g: 小女孩的成长环境很艰苦，我的[girl.story_guardian]经常很累，心情也不好。", "g: 我是一个非常活跃和健谈的孩子，但这并没有帮助我。", "g: 我的[girl.story_guardian]过去常常对我发脾气，但我学会了避开。", "g: 有时候我想，是不是有一个脾气这么暴躁的[girl.story_guardian]让我对别人的感受变得如此敏感。", "g: 我的意思是我喜欢帮忙，但有时我会牺牲自己的需要！", "g: 我讨厌打架！我讨厌告诉别人一些他们不想听的事情。  你注意到了吗？你懂我的意思吗？", "mc: 我注意到了，[girl.fullname]，但对他人的需求敏感对于性奴隶来说并不是一件坏事。", "mc: 你常常不得不把自己的需求放在一边，只做让客户满意的事情。", "mc: 你是一个聪明又富有同情心的女孩。如果你接受自己本来的样子，你就能成为一个真正伟大的妓女。", "mc: 如果你拥抱自己，你很快就会学会像年轻的女奴一样热爱为男人服务。", "g: 当然了，主人...."], multiple=True)
    add_dialogue("origin the Blood Islands", ("helper", "pet"), ["g: 血色群岛是个残酷的地方....我记得和我的[girl.story_guardian]一起去竞技场，看着奴隶被怪物撕成碎片....", "g: 如果你不富有，那生活会很艰难，对于一个小女孩来说，成长的环境也很可怕。我的[girl.story_guardian]经常很累，心情也不好。", "g: 我是一个非常活跃和健谈的孩子，但这并没有帮助我。", "g: 我的[girl.story_guardian]过去常常对我发脾气，但我学会了避开。", "g: 有时候我想，是不是有一个脾气这么暴躁的[girl.story_guardian]让我对别人的感受变得如此敏感。", "g: 我的意思是我喜欢帮忙，但有时我会牺牲自己的需要！", "g: 我讨厌打架！我讨厌告诉别人一些他们不想听的事情。  你注意到了吗？你懂我的意思吗？", "mc: 我注意到了，[girl.fullname]，但对他人的需求敏感对于性奴隶来说并不是一件坏事。", "mc: 你常常不得不把自己的需求放在一边，只做让客户满意的事情。", "mc: 你是一个聪明又富有同情心的女孩。如果你接受自己本来的样子，你就会成为一流的妓女。", "mc: 如果你拥抱自己，你很快就会学会喜欢帮助顾客在你漂亮的小脸上打转，就像你应该像一个好奴隶女孩一样。", "g: 当然了，主人...."], multiple=True)
    add_dialogue("origin Karkyr", ("helper", "pet"), ["g: 卡基尔是一座美妙的、闪闪发光的城市，由大法师议会统治。一切都很神奇，连椅子和桌子都会说话.... ", "g: 但如果你不富有的话，这也可能是一个艰难的地方。我的[girl.story_guardian]经常感到疲倦且心情不好。", "g: 我是一个非常活跃和健谈的小女孩，经常玩食物并给神奇的桌子上舞蹈课，但这并没有帮助！", "g: 我的[girl.story_guardian]过去常常对我发脾气，但我学会了避开。", "g: 有时候我想，是不是有一个脾气这么暴躁的[girl.story_guardian]让我对别人的感受变得如此敏感。", "g: 我的意思是我喜欢帮忙，但有时我会牺牲自己的需要！", "g: 我讨厌打架！我讨厌告诉别人一些他们不想听的事情。你注意到了吗？你懂我的意思吗？", "mc: 我注意到了，[girl.fullname]，但对他人的需求敏感对于性奴隶来说并不是一件坏事。", "mc: 你常常不得不把自己的需求放在一边，只做让客户满意的事情。", "mc: 你是一个聪明又富有同情心的女孩。如果你接受自己本来的样子，你就会成为一个真正优秀的妓女......", "mc: 如果你拥抱自己，你很快就会学会像年轻女奴一样去取悦鸡巴。", "g: 当然了，主人...."], multiple=True)
    add_dialogue("origin Westmarch", ("helper", "pet", "generic"), ["g: 我长大的威斯特玛公国是一个非常难以预测的地方。有一天，一座城市欣欣向荣，第二天，它就陷入纯粹的无政府状态，掠夺者掠夺和掠夺城镇。", "这是一个艰难的成长环境，我的 [girl.story_guardian] 经常感到疲倦且心情不好。", "g: 我是一个非常活跃和健谈的小女孩，但这并没有帮助我。", "g: 我的[girl.story_guardian]过去常常对我发脾气，但我学会了避开。", "g: 有时候我想，是不是有一个脾气这么暴躁的[girl.story_guardian]让我对别人的感受变得如此敏感。", "g: 我的意思是我喜欢帮忙，但有时我会牺牲自己的需要！", "g: 我讨厌打架！我讨厌告诉别人一些他们不想听的事情。你注意到了吗？你懂我的意思吗？", "mc: 我注意到了，[girl.fullname]，但对他人的需求敏感对于性奴隶来说并不是一件坏事。", "mc: 你常常不得不把自己的需求放在一边，只做让客户满意的事情。", "mc: 你是一个聪明又富有同情心的女孩。如果你接受自己本来的样子，你就会成为一名优秀的妓女。", "mc: 如果你拥抱自己，你很快就会学会像一个热心的小女奴那样去取悦鸡巴。", "g: 当然了，主人...."], multiple=True)
    add_dialogue("origin the desert of Hokoma", ("helper", "pet", "very sub"), ["g: 沙漠人是安静而聪明的人....", "g: 哈哈，当然除了我！自从我学会说话以来，我就经常说话！", "我的[girl.story_guardian]曾经说过，我宁愿听沙漠风的呼啸，也不愿听那个女孩的胡言乱语！", "g: 生活环境艰苦。我的[girl.story_guardian]经常感到疲倦且心情不好。", "g: 尽管我是一个非常活跃的孩子，但我尽量不妨碍。", "g: 有时候我想，是不是有一个脾气这么暴躁的[girl.story_guardian]让我对别人的感受变得如此敏感。", "g: 我的意思是我喜欢帮忙，但有时我会牺牲自己的需要！", "g: 我讨厌打架！我讨厌告诉别人一些他们不想听的事情。你注意到了吗？你懂我的意思吗？", "mc: 我注意到了，[girl.fullname]，但对他人的需求敏感对于性奴隶来说并不是一件坏事。", "mc: 你常常不得不把自己的需求放在一边，只做让客户满意的事情。", "mc: 你是一个聪明又富有同情心的女孩。如果你接受自己本来的样子，你就会成为一个真正一流的妓女......",  "mc: 如果你拥抱自己，你很快就会学会像年轻女奴一样去取悦鸡巴。", "g: 当然了，主人...."], multiple=True)
    add_dialogue("origin Borgo, the port city", ("helper", "pet", "very sub"), ["g: 无法形容博尔戈在大多数日子里是多么忙碌和拥挤，来自世界各地的水手出售你能想象到的一切，还有许多难以想象的东西...... ", "g: 但是港口城市并不像泽恩那么繁荣，很多人都生活在贫困之中。那是一个艰难的成长环境，因为我们并不富裕。我的[girl.story_guardian]经常感到疲倦且心情不好。", "g: 我是一个非常活跃和健谈的小女孩，但这并没有帮助我。", "g: 我的[girl.story_guardian]过去常常对我发脾气，但我学会了避开。", "g: 有时候我想，是不是有一个脾气这么暴躁的[girl.story_guardian]让我对别人的感受变得如此敏感。", "g: 我的意思是我喜欢帮忙，但有时我会牺牲自己的需要！", "g: 我讨厌打架！我讨厌告诉别人一些他们不想听的事情。你注意到了吗？你懂我的意思吗？", "mc: 我注意到了，[girl.fullname]，但对他人的需求敏感对于性奴隶来说并不是一件坏事。", "mc: 你常常不得不把自己的需求放在一边，只做让客户满意的事情。", "mc: 你是一个聪明又富有同情心的女孩。如果你接受自己本来的样子，你就会成为一流的妓女。", "mc: 如果你拥抱自己，你很快就会学会像女奴那样去取悦鸡巴。", "g: 当然了，主人...."], multiple=True)
    add_dialogue("origin the Goliath desolations", ("helper", "pet", "very sub"), ["g: 荒凉的地方是一片荒凉、贫瘠的地方。不管你是富有还是贫穷，你都必须每天努力工作，只是为了生存。", "g: 我的[girl.story_guardian]经常很累并且心情不好。", "g: 我是一个非常活跃和健谈的小女孩，但这并没有帮助我。", "g: 我的[girl.story_guardian]过去常常对我发脾气，但我学会了避开。", "g: 有时候我想，是不是有一个脾气这么暴躁的[girl.story_guardian]让我对别人的感受变得如此敏感。", "g: 我的意思是我喜欢帮忙，但有时我会牺牲自己的需要！", "g: 我讨厌打架！我讨厌告诉别人一些他们不想听的事情。你注意到了吗？你懂我的意思吗？", "mc: 我注意到了，[girl.fullname]，但对他人的需求敏感对于性奴隶来说并不是一件坏事。", "mc: 你常常不得不把自己的需求放在一边，只做让客户满意的事情。", "mc: 你是一个聪明又富有同情心的女孩。如果你接受自己本来的样子，你就会成为一流的妓女。", "mc: 如果你拥抱自己，你很快就会学会喜欢像奴隶一样为男人服务。", "g: 当然了，主人...."], multiple=True)
    add_dialogue("origin the Arik mountains", ("helper", "pet", "very sub"), ["g: 他们说阿里克山脉是已知世界中最高的山脉，但那里的生活环境也很艰苦，因为你必须非常努力地工作才能生存。", "g: 我的[girl.story_guardian]经常很累并且心情不好。", "g: 我是一个非常活跃和健谈的小女孩，但这并没有帮助我。", "g: 我的[girl.story_guardian]过去常常对我发脾气，但我学会了避开。", "g: 有时候我想，是不是有一个脾气这么暴躁的[girl.story_guardian]让我对别人的感受变得如此敏感。", "g: 我的意思是我喜欢帮忙，但有时我会牺牲自己的需要！", "g: 我讨厌打架！我讨厌告诉别人一些他们不想听的事情。你注意到了吗？你懂我的意思吗？", "mc: 我注意到了，[girl.fullname]，但对他人的需求敏感对于性奴隶来说并不是一件坏事。", "mc: 你常常不得不把自己的需求放在一边，只做让客户满意的事情。", "mc: 你是一个聪明又富有同情心的女孩。如果你接受自己本来的样子，你就可以发挥作为妓女的潜力。", "mc: 如果你拥抱自己，你很快就会学会像奴隶一样服务鸡巴。", "g: 当然了，主人...."], multiple=True)
    add_dialogue("slave lecture refuses", ("helper", "sweet"), ("呃！请不要谈论这个，主人！我不介意帮助[brothel.name]，但我有我的极限！"))
    add_dialogue("slave train service success", ("helper"), ("你的精液，主人....请用它来沐浴我...."))
    add_dialogue("beach intro", ("very extravert"), ["[girl.fullname]正在海滩上和一群人说说笑笑，其中一些人公开欣赏她健美的身材。"], multiple=True, sound=s_laugh)
    add_dialogue("beach meet MC", ("very sub"), ["g: 师、主人？对不起，我没有偷懒....", "她在你面前畏缩，期待着你的耳朵。", "mc: 别傻了，今天是你的休息日。", "g: 咳咳，是的....谢谢。"], multiple=True)
    add_dialogue("beach refuse oiling", ("very sub"), ["g: 不、不在这里，主人！我受够了....我们停下来吧。"], multiple=True)

    add_dialogue("beach refuse public sex", ("very sub"), ["g: 请原谅，主人，这是不可能的！对不起，对不起！"], multiple=True)

    add_dialogue("beach refuse sex", ("very sub"), ("请主人原谅，这是不可能的！对不起，对不起！"))

## START HOLY DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("holy"), ("向您问好，好先生。请以 Arios 的名义受到我的祝福，[girl.fullname]。"), love=1)
    add_dialogue("free_greetings_casual", ("holy"), ("你好，我是[girl.fullname]。愿太阳神的光芒照耀着你。 *微笑*"), love=2)
    add_dialogue("free_greetings_rude", ("holy"), ("[girl.fullname]。要知道，阿里奥的教义并不认可你的举止！"))

    add_dialogue("free_small_talk", ("holy"), ("这一切在亚里欧斯眼里都是毫无意义的。", "别浪费我宝贵的时间。", "请直接进入您的询问点。", "为什么这会引起我或太阳神教会的关注？"), max_cap=25)
    add_dialogue("free_gossip", ("holy"), ("有时人们会把最疯狂的故事带到太阳神教堂。像这个。", "你是否也想知道太阳神对某些事件有何感想？", "请听我说完。这个谣言实在是太吸引人了！"), love=2, max_cap=25)
    add_dialogue("free_chat_life", ("holy"), ("我很高兴你问了。我觉得太阳神对我们所有人都有一个计划。", "加入我们的 Arios 教堂，我们将回答您所有的问题。 *微笑*。", "哦，终于等到你问我这些问题了！ *微笑*"), love=2, max_cap=25)
    add_dialogue("free_chat_love", ("holy"), ("这一切在亚里欧斯眼里都是毫无意义的。", "别浪费我宝贵的时间。", "我没有时间做这个。显然太阳神是我的爱人。", "为什么这会引起我或太阳神教会的关注？"), max_cap=25)
    add_dialogue("free_chat_origins", ("holy"), ("哦，我出生在[girl.origin]。但我们都来自太阳神。我有告诉过你世界的起源吗？这一切都始于阿里奥第一次......", "阿里奥.我是他创造的，就像你一样。按照他的设计，我是在[girl.origin]中被创造出来的。请让我告诉你更多关于亚里欧斯和这个世界的诞生的事情。"), love=3, max_cap=40, sound=s_laugh)
    add_dialogue("free_chat_hobbies", ("holy"), ("可以说我喜欢[hobby]。但这已经是过去式了。现在太阳神教堂需要我的时间。", "我曾经花时间[hobby]。但如您所知，太阳神对我们所有人都施加了严格的规则。"), max_cap=40)
    add_dialogue("free_chat_likes", ("holy", "loyal", "repressed", "cold"), ("我认为[best]是一件好事。但谈论个人需求是浪费时间。"), max_cap=40)
    add_dialogue("free_chat_dislikes", ("holy", "prude"), ("你能想象人们喜欢[worst]吗？他们赞同这个[thing_cn]，是在取笑阿里奥！哦，很抱歉就这样爆发了。 *眨眼*", "任何认为[worst]是最好的[thing_cn]的人都有一个严重的问题。阿里奥一定会惩罚他们的。 *微笑*谢谢你让我发泄一些蒸汽。我需要那个。"), love=1, max_cap=40)

    add_dialogue("free_joke_harmless", ("holy"), ("说实话，我更想听听莎莉亚的教诲....", "我需要打电话调查才能让你停止说话吗？", "*咕哝*当我最需要他的保护时，Arios在哪里？"), love=-1, max_cap=50, sound=s_sigh)
    add_dialogue("free_joke_adult", ("holy"), ("幸运的是，太阳神听不到所说的一切。但是我可以。请继续。 *眨眼*", "那个很好。现在该我了！", "哈哈，这让我想起我们教会的一个案例。有点悲伤，但仍然很有趣。"), love=1, max_cap=50, sound=s_laugh)
    add_dialogue("free_joke_dark", ("holy"), ("以太阳神的名字来说，这真是太棒了！请再多一点！", "请不要告诉任何人，但比莎莉亚的教义更黑暗的笑话只是我的专长。 *眨眼*", "哈哈哈，太黑了，能把亚里欧斯教堂的光都熄灭了。多一个！"), love=3, max_cap=50, sound=s_laugh)
    add_dialogue("free_joke_mean", ("holy", "repressed"), ("幸运的是，太阳神听不到所说的一切。但是我可以。请继续。 *眨眼*", "那个很好。现在该我了！", "哈哈，好痛啊最好准备好接受一些回报。 *眨眼*"), love=1, max_cap=50, sound=s_laugh)

    add_dialogue("free_touch_hand", ("holy"), ("和你一起走在昙街头的感觉真好。阿里奥祝福我们。", "我们在一起会变得更强大。这就是它本来的样子。", "你最好不要放开我的手，否则我会亲自招来亚里欧斯的愤怒。 *眨眼*"), love=2, max_cap=90)
    add_dialogue("free_touch_kiss", ("holy", "prude", "repressed"), ["她轻轻地吻了你一下，然后轻轻地把你推开。", "g: 我们真的不应该这样做。如果我们被看见怎么办？"], multiple=True, love=1, max_cap=90)
    add_dialogue("free_touch_ass", ("holy"), ("以太阳神之名！是的！", "*低语*如果你再用点力气，我就会爬到你的脚边。 *脸红*我真的这么说了吗？", "哦，这正是阿里奥的教导中所缺少的！ *眨眼*"), love=3, max_cap=90, sound=s_aah)
    add_dialogue("free_touch_breasts", ("holy"), ("以太阳神之名！是的！", "*低语*用力掐他们，我将永远属于你。 *脸红*我真的这么说了吗？", "哦，这可以为太阳神的教义增添新的篇章！ *眨眼*"), love=2, max_cap=90, sound=s_aah)
    add_dialogue("free_touch_pussy", ("holy", "stubborn", "prude", "repressed", "cold"), ("立即移开你的手。", "你要我叫警卫吗？", "停下来。严重地。停下来吧。"), love=1, max_cap=90)

    add_dialogue("free_play refuses", ("holy"), ("你这个异教徒！是什么让你认为我会和你这么做！", "这是不可原谅的。我信了你！", "放开你的手，混蛋！ *耳光*让这成为你的一个教训！"), love=-1, sound=s_punch)
    add_dialogue("free_play very reluctant", ("holy"), ("你知道阿里奥禁止这样做。我们真的不应该。啊啊....", "何必那么执着呢。将这些技能用于 Arios，而不是用来追求我。让我们结束这一切吧...", "我们不能做点不同的事情吗？有Arios批准的东西吗？请...？"), love=1, sound=s_sigh)
    add_dialogue("free_play reluctant", ("holy"), ("你知道阿里奥禁止这样做。但如果和你在一起的话...", "何必那么执着呢。将这些技能用于 Arios，而不是用来追求我。", "我们不能做点不同的事情吗？有Arios批准的东西吗？但好吧，这还不算太糟糕......"), love=2)
    add_dialogue("free_play a little reluctant", ("holy"), ("你知道阿里奥禁止这样做。希望他不会发现。", "何必那么执着呢。让我们算一下吧。", "我们不能做点不同的事情吗？有Arios批准的东西吗？但好吧，有你在，可能没问题。"), love=2)
    add_dialogue("free_play indifferent", ("holy"), ("理论上太阳神禁止这样做。但我没有看到他阻止我们。", "嗯...为什么不呢？让我们算一下吧。", "这或许没有得到亚里欧斯的认可....不过如果是你的话，我也没关系。"), love=3)
    add_dialogue("free_play a little interested", ("holy"), ("理论上太阳神禁止这样做。但我很好奇。所以... *眨眼*", "我可能有兴趣。 *眨眼*所以让我们算数吧。", "你怎么知道我只是想知道那会是什么样的感觉？你受到太阳神的祝福吗？"), love=4)
    add_dialogue("free_play interested", ("holy"), ("我一直想知道那些莎莉亚信徒在谈论什么。我想我快要追上了....*眨眼*", "以太阳神的名义，我对此有很多疑问。请做一个好主人。  *眨眼*", "你怎么知道我需要什么以及何时需要？你受到太阳神的祝福吗？ *眨眼*"), love=4)
    add_dialogue("free_play very interested", ("holy"), ("那些莎莉亚母狗说话总是一副行动最多的样子。我想我快要追上了....*眨眼*", "以太阳神的名义，教我一切知识....哦，光是这个想法就让我湿透了。", "您确切地知道我需要什么、何时需要以及在哪里需要。就这样，此时此地。"), love=5, sound=s_mmh)
    add_dialogue("free_play fascinated", ("holy"), ("那些莎莉亚母狗说话总是一副行动最多的样子。如果他们知道我们要做什么就好了....*aaaah*", "以太阳神的名义，如果我们现在就在他的神庙里就好了....哦，光是这个想法就让我如此湿润。", "您确切地知道我需要什么、何时需要以及在哪里需要。就这样，此时此地。希望太阳神能够关注！"), love=5, sound=s_mmh)
    add_dialogue("MC take virginity", ("holy"), ("我们今天所做的，是在亚里欧斯守护下的神圣誓言。我很高兴第一次和你在一起。"), love=5)
    add_dialogue("free_play interested after", ("holy"), ("阿里奥可能不会同意。但是我愿意。 *吻*", "蛮好玩的。我们什么时候再做一次？", "在太阳神的光芒下，我喜欢它。"))
    add_dialogue("free_play not interested after", ("holy"), ("对不起，但我必须回去履行我的职责。愿太阳神保护你。", "嗯，这确实是一种新的体验。但我明白为什么太阳神不赞成它。"))

    add_dialogue("free_flirt_beauty", ("holy"), ("少说些空话吧。与亚里欧斯的光芒相比，我的美貌显得黯然失色。", "肉体之美并不是人们所追求的。真正的美在于心灵和精神。"), love=-1, max_cap=75, sound=s_sigh)
    add_dialogue("free_flirt_body", ("holy"), ("我不明白我的身体有什么关系吗？但是，是的，我知道。", "由于是亚里欧斯的灼热之光所造成，所以我的身体当然是热的。你想说啥？", "抱歉，我真的不明白你要做什么。"), max_cap=75)
    add_dialogue("free_flirt_mind", ("holy", "prude"), ("哦谢谢。 *脸红*我希望我也知道这些词可以照亮你的一天。", "哦，拜托...你真的这么认为吗？谢谢...*脸红*", "阿里奥，你听到了吗？这是有史以来最好的赞美！"), love=3, max_cap=75, sound=s_laugh)
    add_dialogue("free_flirt_spirit", ("holy"), ("谢谢。我用我的精力来传播 Arios 的信息。", "你真的这样想吗？谢谢。 *微笑*", "阿里奥，你听到了吗？这是一个很好的赞美。 *微笑*"), love=2, max_cap=75, sound=s_laugh)

    add_dialogue("free_flirt_sex_experience very experienced", ("holy"), ("你知道，莎莉亚的女祭司并不是镇上唯一享受乐趣的女孩....*眨眼*", "哦，如果阿里奥知道了，他会亲自鞭打我。 *咯咯*我非常希望这样。 *眨眼*"), love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("holy"), ("可能有一些....也许还有更多。但阿里奥还没有惩罚我。 *眨眼*", "可以说，我把我的一份爱传播到了Zan。如果你明白我的意思。 *眨眼*"), love=2)
    add_dialogue("free_flirt_sex_experience average", ("holy"), ("有一些。虽然还在合理范围之内！", "我的意思是，这是自然的，不是吗？所以，是的，有一些....但只有太阳神留在了我身边。"), love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("holy"), ("我们有必要讨论这个吗？我的过去可能发生过一些事件，但那些早已过去了。那么我们可以谈谈别的事情吗？", "你知道亚里欧斯不喜欢无意义的交往。以前我也有过一些纠结。我们可以谈谈别的事情吗？"))
    add_dialogue("free_flirt_sex_experience very inexperienced", ("holy"), ("这真是让我很不舒服....我的过去也许有过一些小事，但那些都已经过去了。我们换个话题吧！", "你知道亚里欧斯不喜欢无意义的交往。过去的就过去了，不应该再谈了....我们换个话题吧！"), love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("holy"), ("嗯....按照阿里奥的教诲，我还是....纯洁的....我不敢相信我会告诉你这些！ *脸红*"), love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("holy"), ("你遵循阿里奥的教诲！我必须承认，我不这么认为...", "好吧，也许你找到了合适的人。 *眨眼*至少我希望如此。"), love=4)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("holy"), ("你知道，仅仅因为我是太阳神的追随者并不意味着我天真。虽然我很欣赏你的努力。", "真的吗？虽然是遵循亚里欧斯的教诲，但我实在无法相信你。毕竟我们是在泽恩。"), love=-1)

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("holy"), ("你遵循阿里奥的教诲！我必须承认，我不这么认为...", "好吧，也许你很快就会增加你的计数。 *眨眼*至少我希望如此。"), love=2)
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("holy"), ("你知道，仅仅因为我是太阳神的追随者并不意味着我天真。虽然我很欣赏你的努力。", "真的吗？虽然是遵循亚里欧斯的教诲，但我实在无法相信你。毕竟我们是在泽恩。"))
    add_dialogue("free_flirt_sex_experience reply_been_around", ("holy"), ("平衡的生活是如此重要！你应该拥抱自然。 *眨眼*也许我时不时...？ *脸红*", "嗯，这可能有点超出了 Arios 的喜好，但是....也许我可以从你的经验中受益？ *眨眼* ...我刚才说什么？ *脸红*"), love=3)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("holy"), ("我不敢相信你为此感到自豪！这完全违背了太阳神的教诲！", "我不知道，在你宣布之后我也不想知道！"))
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("holy"), ("你是谁，你需要在这件事上撒谎吗？您让我恶心！", "你真可怜....我以为我认识你...."), love=-1)
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("holy"), ("我明白了....至少你在这座城市里传播了一些欢乐。虽然不知道Arios对此有何感想....", "嗯，这是一份工作，泽恩需要它。至少当我们到达时你会知道该怎么走......*脸红*"), love=1)

    add_dialogue("free_flirt_sex_act refuses", ("holy"), ("阿里奥！是什么让你觉得我想和你谈谈这个？", "以太阳神的名义，为什么？这根本不关你的事！", "换个话题，就现在！"))
    add_dialogue("free_flirt_sex_act very reluctant", ("holy"), ("你知道阿里奥禁止这样做。我们真的不应该谈论它。啊啊....", "何必那么执着呢。将这些技能用于 Arios，而不是用来追求我。让我们结束这次谈话...", "我们就不能聊点不一样的吗？有Arios批准的东西吗？请...？"))
    add_dialogue("free_flirt_sex_act reluctant", ("holy"), ("你知道阿里奥禁止这样做。但如果有你在的话我们可以谈谈...", "何必那么执着呢。将这些技能用于 Arios，而不是用来追求我。", "我们就不能聊点不一样的吗？有Arios批准的东西吗？哦，我想这并不是一个太糟糕的话题......"))
    add_dialogue("free_flirt_sex_act a little reluctant", ("holy"), ("你知道阿里奥禁止这样做。希望他不会发现我们正在讨论这个问题。", "何必那么执着呢。让我们让这次谈话变得有价值。", "我们就不能聊点不一样的吗？有Arios批准的东西吗？但好吧，有你在，可能没问题。"))
    add_dialogue("free_flirt_sex_act indifferent", ("holy"), ("阿里奥禁止这样做。但我不认为他阻止我们谈论这件事。 *眨眼*", "嗯...为什么不呢？但作为回报，我会问你一些问题。", "这可能没有得到 Arios 的批准。但如果是你问这个问题，那我也没关系。"), love=1)
    add_dialogue("free_flirt_sex_act a little interested", ("holy"), ("理论上太阳神禁止这样做。但我对这个话题很好奇。所以... *眨眼*", "我可能对这个话题感兴趣。 *眨眼*所以让我们让谈话变得有意义。", "你怎么知道我只是想知道那是怎么回事？你受到太阳神的祝福吗？"), love=2)
    add_dialogue("free_flirt_sex_act interested", ("holy"), ("我一直想知道那些莎莉亚信徒在谈论什么。我想我快要追上了....*眨眼*", "以太阳神的名义，我对此有很多疑问。请做一个好主人。  *眨眼*", "你怎么知道我现在在想什么？你受到太阳神的祝福吗？ *眨眼*"), love=2)
    add_dialogue("free_flirt_sex_act very interested", ("holy"), ("那些莎莉亚母狗说话总是一副行动最多的样子。终于我有一个可以公开交谈的人了....*眨眼*", "以太阳神的名义，让我找出所有需要知道的事情！", "你清楚地知道我想讨论什么以及何时讨论。就这样，此时此地。"), love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("holy"), ("那些莎莉亚母狗说话总是一副行动最多的样子。如果他们知道我要告诉你什么就好了....*aaaah*", "以太阳神的名义，如果他知道我要告诉你的事情就好了....哦，光是这个想法就让我湿透了。", "你清楚地知道我想讨论什么以及何时讨论。就这样，此时此地。我希望太阳神能够倾听！"), love=3)

    add_dialogue("free_give_gold +++", ("holy", "prude"), ("太感谢了。你是太阳神亲自送来的祝福！", "哦，我非常需要这个！愿太阳神祝福你！"), love=6, max_cap=75)
    add_dialogue("free_give_gold ++", ("holy"), ("非常感谢。阿里奥今天肯定在照顾我。 *眨眼*", "这是对真神之道的慷慨贡献。阿里奥祝福你。"), love=4, max_cap=75)
    add_dialogue("free_give_gold +", ("holy"), ("谢谢。那是没有必要的...但是谢谢你。", "今天太阳神的祝福与你同在。"), love=2, max_cap=75)
    add_dialogue("free_give_gold -", ("holy"), ("您对这一事业的贡献已被记录。祝你有美好的一天。", "好的。但黄金对于光的追随者来说有什么用呢？"), max_cap=75)
    add_dialogue("free_give_gold --", ("holy"), ("阿里奥的爱是买不来的。我的也不能！", "阿里奥的追随者不是妓女。你让我感到恶心！"), love=-1, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("holy"), ["[girl.name] 看着你，眼中充满了深深的悲伤。", "g: 我爱你，但是....我刚刚逃离了我神的假庙里的狂欢。青楼工作真的是我的宿命吗？", "g: 我知道，传播爱是阿里奥的教诲。但我不再知道我应该相信什么。什么是真实的。", "g: Do you... think I could do it?"], multiple=True, love=-1)
    add_dialogue("free_offer_job half_lie", ("holy"), ["[girl.name] 眼中充满震惊地看着你。", "g: 我以为我爱你，但你和那些假神父一样坏！你还瞒着我什么？", "你及时后退，躲开了她的一巴掌，等了一会儿，她的能量再次离开了她。", "mc: 亲爱的，事情没有你想象的那么糟糕。我爱你，这将是我们永远在一起的机会。", "g: 我刚刚逃离了我神的假庙里的狂欢。现在你来了。青楼工作真的是我的宿命吗？", "g: 我知道，传播爱是阿里奥的教诲。但我不再知道我应该相信什么。什么是真实的。", "g: Do you... think I could do it?"], multiple=True, love=-3)
    add_dialogue("free_offer_job lie", ("holy"), ["[girl.name] 眼中充满震惊地看着你。", "g: 我以为我爱你，但你和那些假神父一样坏！你还撒过什么谎？", "你及时后退，躲开了她的一巴掌，等了一会儿，她的能量再次离开了她。", "mc: 亲爱的，我们第一次见面时我只是不想吓跑你。我爱你，这将是我们永远在一起的机会。", "g: 我刚刚逃离了我神的假庙里的狂欢。现在你来了。青楼工作真的是我的宿命吗？", "g: 我知道，传播爱是阿里奥的教诲。但我不再知道我应该相信什么。什么是真实的。", "g: Do you... think I could do it?"], multiple=True, love=-4)
    add_dialogue("free_offer_job success", ("holy"), ["深吸了几次气，又缓缓呼出，她终于给出了答案。", "g: 也许....也许这一切都是Arios设计的一部分。我的意思是，不然我们为什么要在这场危机之前相遇呢？", "g: 所以是的，我会成为你的奴隶。而你将成为我的主人。我确信，太阳神会希望这样。"], multiple=True)
    add_dialogue("free_offer_job thinking", ("holy"), ["g: 谢谢你的邀请....但是...", "g: 我现在还不能接受。我将寻求 Arios 的进一步指导，以扫清我前进的道路。", "她离开时，一边向太阳神低声祈祷，一边走开。"], multiple=True)
    add_dialogue("free_offer_job failure lie", ("holy"), ["g: 你最坏了，先是骗我，现在又这样？！", "g: 我是太阳神的一名自豪的助手。我不是妓女，更不是你的奴隶！", "g: 我确信您也参与了仪式！别管我了，你这个异教徒！", "她离开了，看起来很生气.", "mc: 是的，进展顺利。也许稍后，等她冷静下来？"], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("holy"), ["g: 你是最糟糕的！", "g: 我是太阳神的一名自豪的助手。我不是妓女，更不是你的奴隶！", "g: 我确信您也参与了仪式！别管我了，你这个异教徒！", "她离开了，看起来很生气.", "mc: 是的，进展顺利。也许稍后，等她冷静下来？"], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("holy"), ["g: 是这样吗？阿里奥不太喜欢这个行业，但我猜你有助于传播快乐。以你自己的方式...", "mc: 这当然是一种表达方式。你是做什么的？", "g: 我是太阳神教会一个分支的侍僧。不过最近感觉有些奇怪。但我们现在不谈这个......"], multiple=True, love=1)
    add_dialogue("free_friend half_lie", ("holy"), ["g: 哦，我明白了。这些天周围有很多冒险者。愿太阳神的祝福与你同在。", "mc: 谢谢。你是做什么的？", "g: 我是太阳神教会一个分支的侍僧。不过最近感觉有些奇怪。但我们现在不谈这个......"], multiple=True, love=1)
    add_dialogue("free_friend lie", ("holy"), ["g: 奇怪....你没有表现出我所期望的[lie]的氛围。", "mc: 哈哈,肯定...你呢，你是做什么的?", "g: 我是太阳神教会一个分支的侍僧。不过最近感觉有些奇怪。但我们现在不谈这个......"], multiple=True)

    add_dialogue("free_love_interest", ("holy"), ["mc: 嗨，[girl.name]。你现在不应该去参加仪式吗？", "g: 仪式？哦不....我完全陷入了沉思，完全忘记了时间。", "mc: 是什么让你忘记了仪式？阿里奥教堂不是你的生活吗？", "g: 你知道，有那对情侣手牵着手......", "g: 你知道吗，在太阳神教堂里，鲜花是永恒爱情的象征？如果你给我一些，太阳神一定会同意的....*脸红*", "g: 在阿里奥的光辉下，我必须走了。现在。仪式。是的。忘记它吧，好吗？再见！", "[girl.name]说着，脸色变得猩红，看也不看你一眼就跑开了。", "mc: 等等[girl.name]！教堂在另一个方向！ ... 花，嗯？很高兴知道。"], multiple=True)
    add_dialogue("free_girl get_flowers", ("holy"), ("在亚里欧斯的光芒下，它们很美丽。这意味着什么？"))
    add_dialogue("free_ask_out", ("holy"), ["mc: [girl.name]，我喜欢你。你觉得阿里奥会同意我们在一起吗？", "g: 你前几天听说过？哦不，我该怎么办？", "mc: 嗯，你可以接受这些花。至少如果你也喜欢我的话。", "g: 当然啦。我只是....这对我来说太新鲜了。我绝不会想到...现在怎么办？", "mc: 现在你拿着花，用双臂搂住我的脖子，闭上眼睛。", "[girl.name] 的困惑表情很快变成了明亮的红晕，因为她意识到即将发生什么。尽管如此，她还是照你说的做了，并让你靠过来轻轻地吻她。", "在这个吻中徘徊了一段时间后，她把嘴唇从你身上移开。", "g: 那是....特别的。对不起，但我得尽快走了。还有另一个仪式，他们明确要求我出席。某个特别的事件，但具体内容我不知道....啊，但愿这一刻能够永远持续下去！太阳神，我太高兴了！"], multiple=True)

    add_dialogue("free_girlfriend intro", ("holy"), ["g: 你好[MC.name]，今天是美好的一天，不是吗？", "mc: 确实是这样。尤其是当我可以和你一起度过的时候。", "g: 哦，你真可爱。你的话比阿里奥的教导更能照亮我的心情！尤其是最近....等等，不在这儿，跟我来吧！", "mc: 这么突然, 当然...", "她紧紧握住你的手，把你拉进狭窄的小巷。", "g: 现在应该没人能听到我们的声音了。为了确保确实是您本人，请回答一个问题。"], multiple=True)
    add_dialogue("free_girlfriend right", ("holy"), ["g: Arios，是你。我真是放心了！", "mc: [girl.name]，发生什么事了？为什么要保密？", "g: 教会要我做一件事。他们说大祭司很快就会来拜访我们，并且...所有侍僧都...参加仪式...裸体...*抽泣*", "当她告诉你这些时，她的话语变得越来越难以理解，泪水开始在她的眼中涌出。你只是站在那里，对正在发生的事情感到困惑。抽泣了几声后，[girl.name]再次开始说话。", "g: 所以我想，你应该是第一个见到我的人。因为我爱你..."], multiple=True, love=5)
    add_dialogue("free_girlfriend give_up", ("holy"), ["g: 现在真的不是玩游戏的时候！ *哭泣*", "[girl.name]开始哭泣，冲回大街。", "mc: 嘿，发生什么事了？你想告诉我什么？妈的，她已经走了。疯狂的。"], multiple=True, love=-5)
    add_dialogue("free_girlfriend wrong", ("holy"), ["g: 要么你不是你，要么你就是残忍！在我脆弱的时候利用我！ *打*", "打了你一次后，[girl.name]就冲了出去，回到了大街上。", "mc: 好痛啊！你想告诉我什么？妈的，她已经走了。疯狂的。"], multiple=True, love=-10)
    add_dialogue("free_girlfriend success", ("holy"), ["她把侍僧长袍扔到地上，深深地看着你的眼睛。", "g: 这就是我必须参加仪式的方式。阿里奥创造我的方式...你...你喜欢吗？ *脸红*", "你可以感觉到你的鸡巴每一秒都变硬了。她很美丽，她试图掩盖和展示自己的方式。", "mc: 你很完美。能见到你这样，真是受到了亚里欧斯的祝福。", "g: 谢谢，这对我来说意义重大！", "当[girl.name]赤身裸体地倾身进行一个深沉而热情的吻时，你会忘记周围的一切。她有说一些关于仪式的事情吗？说真的，谁在乎呢？你忘记了这个想法，只专注于这一刻......"], multiple=True)
    add_dialogue("free_girlfriend success naked", ("holy"), ["她把侍僧长袍扔到地上，深深地看着你的眼睛。", "g: 这就是我必须参加仪式的方式。 Arios创造我的方式...当我一个人的时候我经常这样，但在其他人面前却不会...你喜欢吗？ *脸红*", "你可以感觉到你的鸡巴每一秒都变硬了。她很美丽，她试图掩盖和展示自己的方式。", "mc: 你很完美。能见到你这样，真是受到了亚里欧斯的祝福。", "g: 谢谢您，这对我来说意义重大！和你在一起我终于可以做真实的自己了！", "当[girl.name]赤身裸体地倾身进行一个深沉而热情的吻时，你会忘记周围的一切。她有说一些关于仪式的事情吗？说真的，谁在乎呢？你忘记了这个想法，只专注于这一刻......"], multiple=True)

    add_dialogue("free_job_request", ("holy"), ["当 [girl.name] 靠近时，您注意到她穿着与平常不同的侍僧长袍。这些似乎是用更优质的材料制成的，装饰凸显了她的女性曲线。", "但只有当她投入你的怀抱，你能感觉到她半透明的布料下柔软的身体时，你才会想起她的“特殊”仪式。", "g:  *抽泣* 哦，[MC.name]，我太蠢了... *抽泣*", "mc: [girl.name]，发生什么事了？阿里奥教堂发生了什么事情吗？", "你想知道她是否可以哭得更厉害。答案是“是的！”。经过长时间的拥抱和多次哭泣后，她再次开始说话。", "g: 我的教堂....祭司长....太阳神！我正在为一个伪装的莎莉亚邪教工作！这段时间！ *哭泣*", "现在让你无语了。但回想起来，可能有一些迹象。最好什么也不说，只是暂时听着。", "g: 他们狂欢了！我所有的朋友，我的姐妹们....我必须逃跑....", "g: 我现在孤身一人了。我的一生都是建立在为太阳神服务的基础上的......而现在，连主教堂都不会接纳我了。*抽泣*", "她突然哭了起来.", "g: [MC.name]，我能做什么？我应该去哪儿？我什么都没有剩下...*抽泣*", "mc: [girl.name]冷静点，我们一起想办法....", "你当然可以想出解决办法。但你首先得想出好词好句让她融入你的青楼。她肯定会是一个很好的补充。"], multiple=True)
    add_dialogue("gizel take girl to farm", ("holy"), ("哈哈哈，赞一个！为我神圣种马的神圣种子准备的奴隶容器！"))
    add_dialogue("slave chat tastes likes", ("holy", "loyal", "repressed", "cold"), ("我认为[best]是一件好事。但谈论个人需求是浪费时间。"), unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("holy", "prude"), ("你能想象人们喜欢[worst]吗？他们赞同这个[thing_cn]，是在取笑阿里奥！哦，很抱歉就这样爆发了。 *眨眼*", "任何认为[worst]是最好的[thing_cn]的人都有一个严重的问题。阿里奥一定会惩罚他们的。 *微笑*谢谢你让我发泄一些蒸汽。我需要那个。"), unlock="LM")
    add_dialogue("slave chat origins 1", ("holy"), ("哦，我出生在[girl.origin]。但我们都来自太阳神。我有告诉过你世界的起源吗？这一切都始于阿里奥第一次......", "阿里奥.我是他创造的，就像你一样。按照他的设计，我是在[girl.origin]中被创造出来的。请让我告诉你更多关于亚里欧斯和这个世界的诞生的事情。"), unlock="EI")
    add_dialogue("origin the border with the Holy Lands", ("holy"), ["圣地是我们的主阿里奥第一次降临并将他的光明带给我们的地方！然而他们却是各种卑鄙怪物和异教徒的家园，这些都是对他伟大的侮辱....", "我和我的[girl.story_guardian]一起在那里长大。我记得我们曾经如何为前来对抗异教徒的圣堂武士欢呼！"], multiple=True)
    add_dialogue("slave magic naked success", ("holy"), ("...我的身体是一座大教堂...揭开大教堂的面纱..."), sound=s_ahaa)

## START CREEP DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("creep"), ("终于我们可以说话了。我观察你很久了我是[girl.fullname]。","是的，我知道你是谁。我在看着你。总是。这是[girl.fullname]。","我是[girl.fullname]。我很久以前就开始关注你了。","最后你向[girl.fullname]打了招呼，这么多年她一直致力于研究你。", "呵呵。我就知道是你。我认出了你的脚步声。我是[girl.fullname]。"))
    add_dialogue("free_greetings_casual", ("creep"), ("终于我们可以说话了。我观察你很久了我是[girl.fullname]。","是的，我知道你是谁。我在看着你。总是。这是[girl.fullname]。","嗯...我是[girl.fullname]。你介意我们说话时我舔你的手指吗？","我是[girl.fullname]。我很久以前就开始关注你了。","最后你向[girl.fullname]打了招呼，这么多年她一直致力于研究你。", "呵呵。我就知道是你。我认出了你的脚步声。我是[girl.fullname]。"), love=1)
    add_dialogue("free_greetings_rude", ("creep"), ("终于我们可以说话了。我观察你很久了我是[girl.fullname]。","是的，我知道你是谁。我在看着你。总是。这是[girl.fullname]。","嗯...我是[girl.fullname]。你介意我们说话时我舔你的手指吗？","我是[girl.fullname]。我很久以前就开始关注你了。","最后你向[girl.fullname]打了招呼，这么多年她一直致力于研究你。", "呵呵。我就知道是你。我认出了你的脚步声。我是[girl.fullname]。", "当我在灌木丛后面看着你时，我一遍又一遍地低声说“注意我”。成功了。我是[girl.fullname]。"), love=2)

    add_dialogue("free_small_talk", ("creep", "yandere"), ("你介意我把整个谈话写下来吗？","呵呵。你就像他们说的那样。","我喜欢你说的方式。我现在更喜欢你了。还有更多。","我就知道你会这么说。我知道关于你的一切。","你为什么不像我脑子里那样约我出去呢？", "回家后我会把这次相遇的记忆添加到神社里。","如果我跟着你回家，看着你睡觉，你不会介意吧？"), love=2, max_cap=25)
    add_dialogue("free_gossip", ("creep"), ("对不起。我们可以谈点别的吗？这不是我想象的我们的谈话......","你已经对另外六个女孩说过同样的话了。我一直在数着。","我就知道你会这么说。我知道关于你的一切。","回家后我会把这次相遇的记忆添加到神社里。","如果我跟着你回家，看着你睡觉，你不会介意吧？"), max_cap=25)
    add_dialogue("free_chat_life", ("creep"), ("当我也能想到你时，为什么还要费力去想这些事情呢？", "那没关系。我满脑子都是你。我{i}需要{/i}就是你。", "不要管那个。我需要你认真起来并开始和我约会，因为我是非常认真的。"), max_cap=25)
    add_dialogue("free_chat_love", ("creep"), ("这一切都始于你十二岁的时候....从那时起我就一直注视着你。", "只有一个可能的答案。你。", "我一直在想这个问题。我想你和我。一切开始得很慢，然后我们变得更加饥饿，我们的吻变得充满激情，然后....", "你已经知道答案了，不是吗？"), love=2, max_cap=25)
    add_dialogue("free_chat_origins", ("creep"), ("我出生在[girl.origin]。那段日子很艰难，但现在遇见了你，一切都是值得的。", "我来自[girl.origin]。你在那儿的节日期间蹂躏了我，还记得吗？不，等等。那只是一个梦。"), max_cap=40)
    add_dialogue("free_chat_hobbies", ("creep", "yandere"), ("*低语*表现得正常，[girl.name]。他喜欢这样。 *咳咳*我喜欢[hobby]。", "让我们看看...我喜欢玩刀。我喜欢[hobby]。我喜欢跟踪你。嗯，还有什么？", "我就知道你会这么问。我知道我应该回答是[hobby]。我知道关于你的一切。", "我大部分时间都在写关于一个非常英俊的 [MC.playerclass] 的色情故事。除此之外，我还喜欢[hobby]。"), love=2, max_cap=40)
    add_dialogue("free_chat_likes", ("creep"), ("*低语*别吓跑他，[girl.name]。 *咳咳*你不同意[best]是一件美妙的[thing_cn]吗？", "我知道你喜欢[best]。这是一件很棒的事情，不是吗？", "我非常喜欢和你说话。我可以和你谈论任何事情。即使是像[thing_cn][best]这样的小事。"), love=2, max_cap=40)
    add_dialogue("free_chat_dislikes", ("creep"), ("嗯...我讨厌排队等候。我讨厌乞丐。我讨厌[thing_cn][worst]。我讨厌看到你和其他女孩说话。","我无法忍受你必须生活在一个存在[thing_cn][worst]的世界里。我会尽一切努力从你的生活中消除[worst]。"), love=1, max_cap=40)

    add_dialogue("free_joke_harmless", ("creep"), ("我喜欢看你的嘴唇动起来。","我希望我能整天听你的笑话。","我喜欢你的幽默感。我现在更喜欢你了。还有更多。", "你真是太机智了。我一回家就会把这个笑话添加到神社里。", "当你说话时我无法停止注视你的嘴唇。我浑身发抖。"), love=3, max_cap=50)
    add_dialogue("free_joke_adult", ("creep"), ("我喜欢看你的嘴唇动起来。","我希望我能整天听你的笑话。","你真是太机智了。我一回家就会把这个笑话添加到神社里。", "当你说话时我无法停止注视你的嘴唇。"), love=1, max_cap=50)
    add_dialogue("free_joke_dark", ("creep"), ("对不起。我们可以谈点别的吗？你并没有我想象的那么机智...","你已经给另外十四个女孩讲过同样的笑话了。我一直在数着。","等等，这不好笑。你为什么不像我脑子里那样约我出去呢？"), love=-1, max_cap=50)
    add_dialogue("free_joke_mean", ("creep"), ("我希望我能整天听你的笑话。","我喜欢你的幽默感。", "你真是太机智了。我一回家就会把这个笑话添加到神社里。", "当你说话时我无法停止注视你的嘴唇。我浑身发抖。"), love=1, max_cap=50)

    add_dialogue("free_touch_hand", ("creep", "yandere"), ("昨晚你用那只手摸了自己....啊啊！我自慰可以吗？", "我开始非常爱你的手，我可以把它撕下来并永远保留它！", "如果你想让我做某事，就说吧。你的愿望就是我的命令。", "如果你不停下来，我就得把你锁在壁橱里，这样我就可以把你们一个人藏起来。", "啊，[MC.name] 的皮肤太棒了。很快，我将无法阻止自己将你淹没在甲醛中，以永远保持你的完美！","皮肤会再生，对吗？保持不动，我会用这个指甲锉刮掉你的足够多的指甲，制作出你手的精确复制品来玩。", "要是你有第三只手就好了。我可以把它剪掉并为自己保留一切......","我想我只要你的触摸就可以达到高潮。","如果我们牵手，是否意味着我们正在约会？"), love=2, max_cap=90)
    add_dialogue("free_touch_kiss", ("creep", "masochist", "yandere"), ("我很高兴我是你的。我再也不会这么高兴了。","呃。呵呵。呵呵呵呵呵呵！","你注意到我是如何盯着你的嘴唇的吗？好的。", "是的！！这是前戏还是你只是在逗我？", "这里只有你和我，呵呵。"), love=3, max_cap=90)
    add_dialogue("free_touch_ass", ("creep", "masochist", "yandere"), ("如果我保持安静，让你摸我，你会高兴吗？呵呵。","呃。呵呵。呵呵呵呵呵呵！","你今天怎么了？你比平常更有攻击性。", "哦，[MC.name]...如果你继续下去...安！我会失去控制的！","这真的可以吗？我不想用我肮脏肮脏的身体玷污你的纯洁....","如果你想让我做某事，就说吧。你的愿望就是我的命令。", "我想我只要你的触摸就可以达到高潮。"), love=1, max_cap=90)
    add_dialogue("free_touch_breasts", ("creep", "yandere"), ("呵呵。隔着衣服触摸它们就够了，还是....？", "啊....汗....我出汗了....我快融化了....","呃。呵呵。呵呵呵呵呵呵！","这里只有你和我，呵呵。","这真的可以吗？我不想用我肮脏肮脏的身体玷污你的纯洁....","我想我只要你的触摸就可以达到高潮。","是的！快扑到我的胸前吧！他们在等你。"), love=2, max_cap=90)
    add_dialogue("free_touch_pussy", ("creep", "masochist", "yandere"), ("呵呵。隔着衣服触碰就够了，还是....？", "呃。呵呵。呵呵呵呵呵呵！", "如果你想让我做某事，就说吧。你的愿望就是我的命令。", "啊....我浑身湿透了，无法思考了。", "啊啊啊....我已经等不及让你火辣的、抽动的鸡巴一遍又一遍地操我湿漉漉的小穴了！", "啊[MC.name]！你在公共场合触摸我就像梦想成真。", "继续...我只需要几秒钟就可以到达..."), love=3, max_cap=90)

    add_dialogue("free_play refuses", ("creep", "masochist", "yandere"), ("啊啊！一文不值！垃圾！ ... 对不起。我不是生你的气，而是生我自己不够好......"), love=-1)
    add_dialogue("free_play very reluctant", ("creep", "masochist"), ("没关系，你可以折磨我。我要你把我当作性对象！使用和虐待我！"), love=1)
    add_dialogue("free_play reluctant", ("creep", "masochist"), ("我要你把我当奴隶一样对待！一个玩具！一个让您满意的工具！"), love=2)
    add_dialogue("free_play a little reluctant", ("creep", "masochist"), ("如果这是你想要的，我会忍耐。我现在是你的奴隶了，你爱怎么处置我就怎么处置我吧！"), love=2)
    add_dialogue("free_play indifferent", ("creep", "masochist"), ("即使你想伤害我或羞辱我，只要知道你快乐，我就能达到高潮。"), love=3)
    add_dialogue("free_play a little interested", ("creep", "masochist", "yandere"), ("我喜欢。这几天我一直对你着迷。"), love=4)
    add_dialogue("free_play interested", ("creep", "masochist"), ("你想玷污我吗？请这样做！"), love=4)
    add_dialogue("free_play very interested", ("creep", "masochist"), ("来吧，你知道我会同意你提出的任何要求，[MC.name]。"), love=5)
    add_dialogue("free_play fascinated", ("creep", "masochist", "yandere"), ("嘿嘿嘿，真调皮。但我比你更脏，我保证。"), love=5)
    add_dialogue("MC take virginity", ("creep"), ("啊...我们终于在一起了...这个小穴是你的，只有你的。你是我的第一个。"), love=5)
    add_dialogue("free_play interested after", ("creep", "masochist", "yandere"), ("呵呵。你真是个顽皮的孩子。"))
    add_dialogue("free_play not interested after", ("creep", "masochist"), ("满足你的每一个愿望，那就是真爱。我的感受如何并不重要。"))

    add_dialogue("free_flirt_beauty", ("creep"), ("我再也受不了了。我非常爱你，我想我会做一些非常非常糟糕的事情。","我喜欢看你的嘴唇动起来。","我希望我能整天听你说话。","当你说话时我无法停止注视你的嘴唇。我浑身发抖。","谢谢你的夸奖。但要成为你的完美女人，我还有很长的路要走。"), love=3, max_cap=75)
    add_dialogue("free_flirt_body", ("creep"), ("我再也受不了了。我非常爱你，我想我会做一些非常非常糟糕的事情。","我喜欢看你的嘴唇动起来。","我希望我能整天听你说话。","当你说话时我无法停止注视你的嘴唇。我浑身发抖。","谢谢你的夸奖。但要成为你的完美女人，我还有很长的路要走。"), love=2, max_cap=75)
    add_dialogue("free_flirt_mind", ("creep"), ("我正在努力练习，但要成为你的完美女人，我还有很长的路要走。", "其他女孩总是告诉我我吓到了她们。我并不可怕，不是吗？我是吗？", "呵呵，别怕。如果我开始伤害你，那只是因为我太爱你了....", "真实的你和梦中的你现在都混在一起了...."), love=-1, max_cap=75)
    add_dialogue("free_flirt_spirit", ("creep"), ("我正在努力练习，但要成为你的完美女人，我还有很长的路要走。", "啊，流鼻血了！抱歉，我有点太兴奋了。我们可以谈点别的吗？", "其他女孩总是告诉我我吓到了她们。我并不可怕，不是吗？我是吗？", "你愿意接受我原本的样子吗？我很高兴听到这个消息。", "为了你，我会假装聪明、活泼。我愿意为你挡子弹。我会做任何事，只要告诉我你想要什么。", "真实的你和梦中的你现在都混在一起了...."), max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("creep"), ("绝对可以，[MC.name]。我知道你喜欢你的女儿训练有素。当然，在做爱时我总是想着你。"), love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("creep"), ("我已经尽力了。我知道你喜欢有经验的女孩，所以我一直在为你付出努力。"), love=2)
    add_dialogue("free_flirt_sex_experience average", ("creep"), ("啊....我已经尽力满足你的期望，但最终，当没有你的时候，性就没有乐趣了。"), love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("creep"), ("不完全是，我大部分时间都是在想着你的时候自慰。我刚才正在做。瞧瞧，我的手指多漂亮啊？"))
    add_dialogue("free_flirt_sex_experience very inexperienced", ("creep"), ("与你以外的人发生性关系？恶心！我要生病了。"), love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("creep"), ("我一直在等你。为你拯救我自己。"), love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("creep", "yandere"), ("你在等我吗？ *抽泣*哦...抱歉，我不是故意哭的。我就是这么、这么高兴...."))
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("creep"), ("如果您在等我时变得不耐烦，我可以理解。没关系。"), love=1)

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("creep"), ("我知道....我当时就在那里。躲在阴影里。但现在你可以将其他女孩的记忆从你的脑海中清除。我们终于在一起了。"), love=2)
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("creep"), ("我们都知道那不是真的。你以为没有人会看到吗？我一直在看，你知道..."))
    add_dialogue("free_flirt_sex_experience reply_been_around", ("creep", "yandere"), ("*叹气*我知道你有。我太爱你了，我可以杀了你....诶嘿嘿嘿！我可以杀死所有这些女孩....然后我将成为你唯一的一个。"), love=-1)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("creep", "yandere"), ("我知道你是，呵呵。你很完美。我将成为你的完美女人。"), love=4)
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("creep", "yandere"), ("我相信一旦我们开始锻炼身体，你就会的。我们有充足的时间让我们的梦想成为现实。熟能生巧！"), love=1)
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("creep", "yandere"), ("真正的爱情不仅仅是一份工作。我可以给你看。我们之间有着更深层次的联系。我们的身体连接程度会和其他女孩不同，呵呵！"), love=1)

    add_dialogue("free_flirt_sex_act refuses", ("creep", "yandere"), ("对不起，我还不够勇敢。首先让我成为一个更肮脏的女孩。"))
    add_dialogue("free_flirt_sex_act very reluctant", ("creep", "pet"), ("不....但我永远无法拒绝你。让我成为一个肮脏的女孩，亲爱的。"))
    add_dialogue("free_flirt_sex_act reluctant", ("creep"), ("我、我想，但是....我从来没有做过这样的事，所以我想我太害怕了...."))
    add_dialogue("free_flirt_sex_act a little reluctant", ("creep", "yandere"), ("如果你继续这样看着我，我会开始更多的练习。"))
    add_dialogue("free_flirt_sex_act indifferent", ("creep"), ("与你？我喜欢！我会穿一套保证让你疯狂的衣服。"), love=1)
    add_dialogue("free_flirt_sex_act interested", ("creep", "masochist"), ("你想让我在公共场合这样做吗？你的愿望就是我的命令。"), love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("creep", "yandere"), ("是的！你也喜欢它，不是吗？让我们来探索一下我们对彼此的爱有多深吧！"), love=2)
    add_dialogue("free_flirt_sex_act very interested", ("creep", "yandere"), ("是的，我喜欢它。你现在能带我去一个又黑又安静的地方吗？我可以给你看。"), love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("creep", "yandere"), ("天哪，是的。 *呻吟*我....现在非常非常饥渴。"), love=3)

    add_dialogue("free_give_gold +++", ("creep", "yandere", "nerd"), ("谢谢你，[MC.name]。我爱你！哦....以前说起来那么容易，现在却都快尴尬了。"), love=6, max_cap=75)
    add_dialogue("free_give_gold ++", ("creep", "yandere"), ("啊....我真的很高兴。如果你想要什么回报，尽管问。我愿意为你掏出我的心。"), love=4, max_cap=75)
    add_dialogue("free_give_gold +", ("creep", "yandere"), ("我很感激，[MC.name]。我会努力为你表现得更正常一些。"), love=2, max_cap=75)
    add_dialogue("free_give_gold -", ("creep", "yandere"), ("太好了....我正在存钱买把新刀...."), max_cap=75)
    add_dialogue("free_give_gold --", ("creep", "yandere"), ("通常，小气的人会让我恨不得把他们的眼睛挖出来，但你可以自私，随心所欲。"), love=-1, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("creep", "yandere"), ["mc: 是的，你可以和我一起住在青楼。", "她转身背对着你，开始自言自语。", "g: 我和[MC.name]住在同一屋檐下....呵呵呵呵。想想我们将会享受到的所有乐趣。", "g: 但是等等....其他人呢？那些荡妇。我们不能让他们破坏我们的乐趣！", "g: 啊，我有一个主意了....呃呃呃....我要开始制定消灭他们的计划了。是的，这样就可以了..."], multiple=True, love=2)
    add_dialogue("free_offer_job half_lie", ("creep", "yandere"), ["mc: 是的，你可以和我一起住在青楼。", "g: 没有必要再对我保守秘密了，[MC.name]。我知道所有的东西。我一直在看着你。","她转身背对着你，开始自言自语。", "g: 我和[MC.name]住在同一屋檐下....呵呵呵呵。想想我们将会享受到的所有乐趣。", "g: 但是等等....其他人呢？那些荡妇。我们不能让他们破坏我们的乐趣！", "g: 啊，我有一个主意了....呃呃呃....我要开始制定消灭他们的计划了。是的，这样就可以了..."], multiple=True, love=2)
    add_dialogue("free_offer_job lie", ("creep", "yandere"), ["mc: 是的，你可以和我一起住在青楼。", "g: 没有必要再对我保守秘密了，[MC.name]。我知道所有的东西。我一直在看着你。","她转身背对着你，开始自言自语。", "g: 我和[MC.name]住在同一屋檐下....呵呵呵呵。想想我们将会享受到的所有乐趣。", "g: 但是等等....其他人呢？那些荡妇。我们不能让他们破坏我们的乐趣！", "g: 啊，我有一个主意了....呃呃呃....我要开始制定消灭他们的计划了。是的，这样就可以了..."], multiple=True)
    add_dialogue("free_offer_job success", ("creep", "yandere"), ["她转身给你她的答案", "g: 我们开始吧！只要能和你一起度过余生，其他的我都不在乎。"], multiple=True)
    add_dialogue("free_offer_job thinking", ("creep", "yandere"), ["她背对着你，不断地自言自语。","g: 嗯...我可能需要更多的刀，一些绳子，足够的垃圾袋和钢锯来处理这些烂摊子...不...我还没准备好...", "她转过身来给你她的答案。", "g:  对不起，[MC.name]。我需要更多时间准备...这对我们来说是一大步！"], multiple=True)
    add_dialogue("free_offer_job failure lie", ("creep", "yandere"), ["她背对着你，不断地自言自语。","g: 嗯...我可能需要更多的刀，一些绳子，足够的垃圾袋和钢锯来处理这些烂摊子...", "g: 或者也许应该先折磨女孩们。因为他们对我亲爱的所做的一切。我甜蜜、完美的亲爱的，被那些毫无价值的垃圾玷污了....不....我还没准备好....他们会付出代价的....", "她转过身来给你她的答案。", "g:  对不起，[MC.name]。我需要更多时间准备...这对我们来说是一大步！"], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("creep", "yandere"), ["她背对着你，不断地自言自语。","g: 嗯...我可能需要更多的刀，一些绳子，足够的垃圾袋和钢锯来处理这些烂摊子...", "g: 或者也许应该先折磨女孩们。因为他们对我亲爱的所做的一切。我甜蜜、完美的亲爱的，被那些毫无价值的垃圾玷污了....不....我还没准备好....他们会付出代价的....", "她转身给你她的答案", "g:  对不起，[MC.name]。我需要更多时间准备...这对我们来说是一大步！"], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("creep"), ["g: *叹气*是的，我就知道这么多...我只是想听你说。","g: 很快我就会让你明白。有我在你的生活中，你就不需要任何其他女孩了。", "mc: 呃....这是为什么呢？", "g: 诶嘿嘿....很快，亲爱的。很快你就会看到。我们会永远在一起。", "g: 我还需要收集更多信息。我会看着你。看看每个角落后面，也许你会找到我。"], multiple=True, love=-1)
    add_dialogue("free_friend half_lie", ("creep"), ["g: *叹气*我希望你对我诚实......我只是想听你说出来。","g: 很快我就会让你明白。有我在你的生活中，你就不需要任何其他女孩了。", "mc: 呃....这是为什么呢？", "g: 诶嘿嘿....很快，亲爱的。很快你就会看到。我们会永远在一起。", "g: 我还需要收集更多信息。我会看着你。看看每个角落后面，也许你会找到我。"], multiple=True, love=-1)
    add_dialogue("free_friend lie", ("creep"), ["g: *叹气*我希望你对我诚实......我只是想听你说出来。","g: 很快我就会让你明白。有我在你的生活中，你就不需要任何其他女孩了。", "mc: 呃....这是为什么呢？", "g: 诶嘿嘿....很快，亲爱的。很快你就会看到。我们会永远在一起。", "g: 我还需要收集更多信息。我会看着你。看看每个角落后面，也许你会找到我。"], multiple=True)

    add_dialogue("free_love_interest", ("creep", "yandere"), ["mc: 嗨，[girl.name]。你好吗？你看起来比平常更累。", "g: [MC.name]...你是对的。我昨晚一夜没合眼。或者前一天晚上。", "mc: 哦？怎么了？","g: 我无法停止想你。我醒着的每一秒我都无法停止想你。", "g: ....你和我，永远在一起。  永远！！呃呃呃。", "mc: 嗯...."], multiple=True)
    add_dialogue("free_girl get_flowers", ("creep", "yandere"), ("*喘息*这意味着我认为的意思吗？"))
    add_dialogue("free_ask_out", ("creep", "yandere"), ["mc: [girl.name]，你的热情是不可抗拒的。让我们永远在一起吧。", "g: 诶嘿嘿！掐我。扇我！我一定是在做梦！", "你打了[girl.name]一巴掌。","g: 诶嘿嘿！我简直不敢相信。是的！当然！", "她扑进你的怀抱，给你一个又长又深的吻.", "g: 我非常非常非常爱你。", "g: 永远不要离开我...我非常爱你，我可以杀了你。也许我会杀了我们两个，这样这一刻就可以持续永恒。"], multiple=True)

    add_dialogue("free_girlfriend intro", ("creep", "yandere"), ["g: [MC.name]，过来一下，一会儿没人打扰我们。", "g: 我的身体是你的。我会服从一切命令。", "g: 但首先，我想确保你同意我的口味。毕竟，我必须确保我是适合你的完美女人。"], multiple=True)
    add_dialogue("free_girlfriend right", ("creep", "yandere"), ("呵呵呵呵，是啊！我将成为你完美的妻子。我们可以一起变得完美。"), love=5)
    add_dialogue("free_girlfriend give_up", ("creep", "yandere"), ["g: 原来如此....我对你的印象似乎有点不对劲。","g: *叹气*我就是垃圾。我一文不值。把我扔掉然后忘记我。"], multiple=True, love=-5)
    add_dialogue("free_girlfriend wrong", ("creep", "yandere"), ["g: 原来如此....我对你的印象似乎有点不对劲。","g: *叹气*我就是垃圾。我一文不值。把我扔掉然后忘记我。"], multiple=True, love=-10)
    add_dialogue("free_girlfriend success", ("creep", "yandere"), ["当她把衣服扔到地上时，各种刀具从她的口袋里掉到地板上。", "g: 我的身体就是你的身体，所以我会好好照顾它。", "g: 我的小穴太湿了，我无法再思考了。拜托....我希望你用我的身体来满足你的每一个愿望。"], multiple=True)
    add_dialogue("free_girlfriend success naked", ("creep", "yandere"), ["当她把衣服扔到地上时，各种刀具从她的口袋里掉到地板上。", "g: 我的身体就是你的身体，所以我会好好照顾它。", "g: 我的小穴太湿了，我无法再思考了。拜托....我希望你用我的身体来满足你的每一个愿望。", "g: 一旦我成为你的妻子，我发誓我再也不会穿衣服了。容易接近。"], multiple=True)

    add_dialogue("free_job_request", ("creep"), ["g: 哦，[MC.name]！我-我犯了一个可怕的错误...*抽泣*", "mc: 发生什么事了？告诉我，[女孩的名字]。", "g: 我父亲...他告诉我我们要搬家...*抽泣*然后我...", "g: *抽泣*我只是无法忍受离开你的想法...*抽泣*", "g: 所以我抓起我的刀，然后...*抽泣*然后...", "她突然哭了起来.", "mc: [girl.name]...你做了什么？", "g: 我不能再回家了...*抽泣*我不能...我不能...", "mc: 现在冷静点，[girl.name]。我们将为您找到一个新家。"], multiple=True)
    add_dialogue("gizel take girl to farm", ("creep"), ("*叹气*我已经知道这将是少数。你肯定知道如何挑选它们......"))
    add_dialogue("slave hit", ("creep", "very dom"), ["哎哟!好痛..."])
    add_dialogue("slave chat tastes likes", ("creep"), ("*低语*别吓跑他，[girl.name]。 *咳咳*你不同意[best]是一件美妙的[thing_cn]吗？", "我知道你喜欢[best]。这是一件很棒的事情，不是吗？", "我非常喜欢和你说话。我可以和你谈论任何事情。即使是像[thing_cn][best]这样的小事。"), unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("creep"), ("嗯...我讨厌排队等候。我讨厌乞丐。我讨厌[thing_cn][worst]。我讨厌看到你和其他女孩说话。","我无法忍受你必须生活在一个存在[thing_cn][worst]的世界里。我会尽一切努力从你的生活中消除[worst]。"), unlock="LM")
    add_dialogue("slave chat origins 1", ("creep"), ("我出生在[girl.origin]。那段日子很艰难，但现在遇见了你，一切都是值得的。", "我来自[girl.origin]。你在那儿的节日期间蹂躏了我，还记得吗？不，等等。那只是一个梦。"), unlock="EI")
    add_dialogue("slave chat origins 2", ("very introvert"), ("我曾经和我的 [girl.story_guardian] 一起住在 [girl.origin] 附近的 [a_home]。我不太适合那里....但这就是我所知道的一切。"), unlock="EI")

## START REPRESSED DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("repressed", "nerd", "prude"), ("我的名字是[girl.fullname]。很高兴认识您！"), love=2)
    add_dialogue("free_greetings_casual", ("repressed", "stubborn", "masochist", "meek"), ("我以前没见过你。我的名字是[girl.fullname]。"), love=3)
    add_dialogue("free_greetings_rude", ("repressed", "stubborn"), ("请你举止得体一点好吗？我的名字是[girl.fullname]。"), love=-2)

    add_dialogue("free_small_talk", ("repressed", "generic", "nerd", "masochist", "meek", "loyal"), ("你是对的，[MC.name]..."), love=2, max_cap=25)
    add_dialogue("free_gossip", ("repressed", "stubborn", "masochist", "class president"), ("我不太在意传闻，但你听说过吗？"), max_cap=25)
    add_dialogue("free_chat_life", ("repressed", "generic"), ("这是一个令人着迷的问题！我个人认为..."), love=2, max_cap=25)
    add_dialogue("free_chat_love", ("repressed", "meek", "holy", "prude", "cold"), ("我相信这样的事情是私人的事情。"), max_cap=25)
    add_dialogue("free_chat_origins", ("repressed", "stubborn", "prude"), ("我是在[girl.origin]长大的，不像这个城市污水坑里的大多数女孩。", "我在[girl.origin]出生和长大。", "我的家人在 [girl.origin] 附近过着舒适的生活。"), love=1, max_cap=40)
    add_dialogue("free_chat_hobbies", ("repressed", "princess", "stubborn", "superficial", "prude"), ("我认为[hobby]绝对是很棒的。你不同意吗？", "一生中有很多令人愉快的事情要做，但[hobby]在我心中占据了一个特殊的位置。", "我永远无法获得足够的[hobby]。这是一个多么可爱的打发时间的方式啊！"), love=2, max_cap=40)
    add_dialogue("free_chat_likes", ("repressed", "sweet", "helper", "loyal"), ("每个人都有自己最喜欢的[thing_cn]。对我来说，它必须是[best]。"), max_cap=40)
    add_dialogue("free_chat_dislikes", ("repressed", "stubborn", "princess"), ("当我想到[thing_cn]时，[worst]是最后想到的。总的！", "我知道有些人喜欢[worst]。与此相比，我更喜欢任何其他[thing_cn]。"), love=1, max_cap=40)

    add_dialogue("free_joke_harmless", ("repressed", "creep"), ("*笑*这就是我所说的真正的膝盖拍击者！"), love=3, max_cap=50)
    add_dialogue("free_joke_adult", ("very modest", "nerd", "meek"), ("I don't like it. You're making me uncomfortable."), love=-3, max_cap=50)
    add_dialogue("free_joke_dark", ("repressed", "loyal", "meek"), ["她忍住笑。", "g: 对不起，我真的不应该笑。这是病态的。"], multiple=True, love=3, max_cap=50)
    add_dialogue("free_joke_mean", ("repressed", "helper", "holy"), ("这有点卑鄙，但我会把它视为我们友谊萌芽的标志。"), love=1, max_cap=50)

    add_dialogue("free_touch_hand", ("repressed", "sweet", "helper", "loyal", "stubborn", "pet", "holy"), ("哦，[MC.name]...我很高兴和你在一起。"), love=4, max_cap=90)
    add_dialogue("free_touch_kiss", ("repressed", "sweet", "helper", "loyal", "holy"), ["她脸红了，闭上眼睛，然后吻了你的嘴唇。", "g: 我爱你，[MC.name]...我希望这一刻永远持续下去。"], multiple=True, love=5, max_cap=90)
    add_dialogue("free_touch_ass", ("repressed", "stubborn", "princess", "prude"), ("*打巴掌*别这样！你怎么了？"), love=-1, max_cap=90)
    add_dialogue("free_touch_breasts", ("repressed", "meek", "loyal"), ("*脸红*不-不...我们不应该..."), max_cap=90)
    add_dialogue("free_touch_pussy", ("repressed", "stubborn", "holy"), ["她打了你一巴掌，然后离开你。", "g: 放手，变态！控制住自己！"], multiple=True, love=-1, max_cap=90)

    add_dialogue("free_play refuses", ("repressed", "stubborn"), ("停下来，[MC.name]！那是猥亵的。"), love=-1)
    add_dialogue("free_play very reluctant", ("repressed"), ("不，这是大错特错了！请不要让我这样做..."), love=1)
    add_dialogue("free_play reluctant", ("repressed", "meek"), ("这、这不对....我们不应该这样做...."), love=2)
    add_dialogue("free_play a little reluctant", ("repressed"), ("我不敢相信我要这么做....这太不雅了！"), love=2)
    add_dialogue("free_play indifferent", ("repressed"), ("*脸红* A-你确定吗？真是太脏了..."), love=3)
    add_dialogue("free_play a little interested", ("repressed", "meek"), ("*脸红*如果有人看到我们怎么办..."), love=4)
    add_dialogue("free_play interested", ("repressed", "helper", "loyal", "meek"), ("*脸红*哦-好吧...我相信你，[MC.name]。"), love=4)
    add_dialogue("free_play very interested", ("repressed"), ("嗯....我知道这是错的，但我无法抗拒。"), love=5)
    add_dialogue("free_play fascinated", ("repressed", "meek"), ("嗯...我爱你，亲爱的...请温柔一点..."), love=5)
    add_dialogue("MC take virginity", ("repressed"), ("我、我的少女时代被夺走了....我想我们应该结婚。"), love=5)
    add_dialogue("free_play interested after", ("repressed"), ("*脸红*我爱你，[MC.name]。"))
    add_dialogue("free_play not interested after", ("repressed"), ("我很羞愧....这是答错了！让我们永远不再谈论它。"))

    add_dialogue("free_flirt_beauty", ("repressed"), ("祝福你，[MC.name]。这是多么美妙的事情啊。"), love=3, max_cap=75)
    add_dialogue("free_flirt_body", ("repressed", "nerd", "meek"), ("别这么粗鲁，你自己都丢脸了。"), max_cap=75)
    add_dialogue("free_flirt_mind", ("repressed", "pet", "meek"), ("你知道该说什么才能让一位女士感到特别，[MC.name]。谢谢。"), love=3, max_cap=75)
    add_dialogue("free_flirt_spirit", ("repressed", "meek"), ("你....你在取笑我。你太卑鄙了...*哭*"), max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("repressed"), ["她的脸颊变得鲜红。", "g: 你、你听到了什么？那是私人的。这不关你的事！", "她似乎在隐瞒什么...."], multiple=True, love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("repressed"), ["她的脸颊变得鲜红。", "g: 谁、谁告诉你这件事的？我们可以谈点别的吗？", "她似乎在隐瞒什么...."], multiple=True, love=2)
    add_dialogue("free_flirt_sex_experience average", ("repressed"), ("*脸红*那是个人问题...我宁愿讨论其他事情。"), love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("repressed"), ("*脸红*这真的不关你的事。让我们换个话题。"))
    add_dialogue("free_flirt_sex_experience very inexperienced", ("repressed"), ("这是多么粗鲁的问题啊....我拒绝用答案来尊严地回答这个问题！"), love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("repressed", "princess"), ("我为自己的纯洁感到自豪。我的荣誉就靠它了！"), love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("repressed", "holy"), ("我很为你感到骄傲！抵制诱惑。节制是一种美德！"), love=4)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("very modest"), ("你以为我会相信吗?你一定觉得我很笨..."), love=-1)

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("very modest", "very idealist", "loyal"), ("啊...我想成为你唯一的女孩....但我会让你开心的!"), love=6)
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("very modest"), ("你以为我会相信吗?你一定觉得我很笨..."), love=2)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("very modest"), ("嗯,没有。其实我不知道."), love=-1)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("very modest"), ("噁,你真恶心!"))
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("very modest"), ["g: 哈哈。你....你在开玩笑，对吧?", "mc: 呃... 当然!"], multiple=True, love=-1)
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("very modest", "very idealist"), ("我知道...我想这是意料之中的... *叹气*"), love=1)

    add_dialogue("free_flirt_sex_act refuses", ("repressed", "stubborn"), ("*巴掌*你怎么敢！"))
    add_dialogue("free_flirt_sex_act very reluctant", ("repressed", "stubborn"), ("我不会用答案来荣耀这个！"))
    add_dialogue("free_flirt_sex_act reluctant", ("repressed", "stubborn"), ("那不关你的事！"))
    add_dialogue("free_flirt_sex_act a little reluctant", ("repressed"), ("那是个人问题！"))
    add_dialogue("free_flirt_sex_act indifferent", ("repressed"), ("我们真的不应该如此公开地谈论这个。这是不对的。"), love=1)
    add_dialogue("free_flirt_sex_act interested", ("repressed"), ("*脸红*我们-我们可以讨论点别的吗？那是私人问题。"), love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("repressed"), ("*脸红* 嗯...不-不，当然不是。人们会怎么想！"), love=2)
    add_dialogue("free_flirt_sex_act very interested", ("repressed"), ("*脸红* 嗯...不-不，当然不是！一点也不！"), love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("repressed", "nerd"), ["当她靠近你时，她的脸颊变得鲜红。", "g: *低语* {i}你能....保守秘密吗？{/i}", "mc: 呃... 当然!", "g: *低语* {i}我呃...我确实想了很多...{/i}"], multiple=True, love=3)

    add_dialogue("free_give_gold +++", ("repressed", "class president"), ("你真慷慨！谢谢你，[MC.name]。我一定会先付款。"), love=6, max_cap=75)
    add_dialogue("free_give_gold ++", ("repressed", "very modest"), ("谢谢你，[MC.name]。你确实不必这样做。"), love=4, max_cap=75)
    add_dialogue("free_give_gold +", ("repressed", "very modest", "loyal", "stubborn"), ("你真是太好了，[MC.name]。"), love=2, max_cap=75)
    add_dialogue("free_give_gold -", ("repressed", "helper", "meek", "masochist"), ("你为什么给我这个？"), max_cap=75)
    add_dialogue("free_give_gold --", ("repressed", "princess"), ("在你眼里我像个乞丐吗？"), love=-1, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("repressed"), ["她看起来受到了侮辱。", "g: 你就是这么想我的吗？一块让人目瞪口呆的肉？", "g: 我...我不敢相信我什至正在考虑...我发生了什么事？！", "她羞愧地低下了头，开始哭泣", "g: *呜咽*我真的已经堕落到这个地步了吗？"], multiple=True, love=-1)
    add_dialogue("free_offer_job half_lie", ("repressed"), ["她看起来受到了侮辱。", "g: 这太荒谬了！我是一块值得被人盯着的肉吗？", "g: 我...我不敢相信我竟然在认真考虑它...我怎么了？！", "她羞愧地低下了头，开始哭泣", "g: *呜咽*我真的已经堕落到这个地步了吗？"], multiple=True, love=-3)
    add_dialogue("free_offer_job lie", ("repressed"), ["g: 你....什么？一个小人物？我的男朋友是皮条客？！", "她看起来非常愤怒。", "g: 我....简直不敢相信！你这是什么蛇啊！！", "g: 我们一起做的所有事情....一直以来，你都在经营一家青楼？！", "她开始无法控制地哭泣。你试图安慰她，但她却伤心不已。", "g: *抽泣*我...我不敢相信*抽泣*我什至*抽泣*考虑到它...", "g: *呜咽*我怎么了？ *抽泣*我真的*抽泣*这么低落吗？"], multiple=True, love=-4)
    add_dialogue("free_offer_job success", ("repressed"), ["泪水不断地从她的脸上滚落。痛苦的哭声使她无法与你说话。", "g:  *呜咽* 哇啊啊！！ *哭泣*", "mc: 来吧，[girl.name]。你知道我会好好照顾你的。我保证！", "她继续无法控制地大哭。", "mc: 只要在虚线上签下合约，你很快就会重新站起来。", "g: *呜咽*哇啊！ *呜咽*哇啊啊啊啊！！ *哭泣*", "mc: 那里，那里....就在这里签名吧....", "你握住她的手，轻轻地引导她在奴隶合约上签名。"], multiple=True)
    add_dialogue("free_offer_job thinking", ("repressed"), ["泪水不断地从她的脸上滚落。痛苦的哭声使她无法与你说话。", "g:  *呜咽* 哇啊啊！！ *哭泣*", "mc: 来吧，[girl.name]。你知道我会好好照顾你的。我保证！", "g:  *呜咽* 恩恩... *呜咽* 不！！离我远点！", "mc: 请....冷静下来想一想，[girl.name]....", "g: *抽泣*离我远点...*抽泣*...你这个恶魔！", "她开始猛烈攻击你。你决定暂时离开她。"], multiple=True)
    add_dialogue("free_offer_job failure lie", ("repressed"), ["泪水不断地从她的脸上滚落。她痛苦地哭泣。", "g:  *呜咽* 哇啊啊！！ *哭泣*", "mc: [girl.name]...我保证，事情并不像看起来那么糟糕！", "g:  *呜咽* 恩恩... *呜咽* 不！！离我远点，你这个骗子！", "mc: 请...想想这个，[girl.name]...", "g: *抽泣*不！！请别打扰我！ *哭泣*", "她开始猛烈攻击你。你决定暂时离开她。"], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("repressed"), ["泪水不断地从她的脸上滚落。她痛苦地哭泣。", "g:  *呜咽* 哇啊啊！！ *哭泣*", "mc: [girl.name]...我保证，事情并不像看起来那么糟糕！", "g:  *呜咽* 恩恩... *呜咽* 不！！离我远点！", "mc: 请...想想这个，[girl.name]...", "g: *抽泣*不！！请别打扰我！ *哭泣*", "她开始猛烈攻击你。你决定暂时离开她。"], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("very modest"), ["g: 这个...这是一种可怕的生活方式!这是不对的!", "mc: 嗯，它能付账单...你是做什么的?", "g: Err, 呃..."], multiple=True, love=-5)
    add_dialogue("free_friend half_lie", ("repressed"), ["g: 哦，一个旅行者！我希望有一天我能看到这个世界。","mc: 你有什么事情吗？","g: 遗憾的是，没有...."], multiple=True, love=5)
    add_dialogue("free_friend lie", ("repressed"), ["g: 哦，[lie]！重要的事情！","mc: 你的职业是什么？","g: *微笑*嗯，我现在主要从事慈善工作...仍在寻找支付账单的方法..."], multiple=True)

    add_dialogue("free_love_interest", ("repressed"), ["mc:  怎么样，[girl.name]？你看起来有点难过...", "g: 哦，你好[MC.name]！我很想念你...", "g: 我只是看着路过的情侣。这让我感到孤独....我很高兴你现在和我在一起。", "g: 你知道，我很想花更多时间和你在一起。我想更好地了解你。", "mc: 哦，当然....如果你愿意的话，我们可以一起出去玩。我随时为您服务！", "g: 谢谢[MC.name]...但我想我正在寻找一种不同类型的关系...", "g: 我想知道....如果你想让我们在一起....你应该更认真地对待这类事情。", "mc: 哦，好吧....我会考虑一下的。"], multiple=True)
    add_dialogue("free_girl get_flowers", ("repressed"), ("它们看起来很漂亮....我做了什么值得这样？"))
    add_dialogue("free_ask_out", ("repressed"), ["mc: [girl.name]，我想我们都已经准备好下一步了。你能做我女朋友吗？", "g: *脸红*哦，[MC.name]！是的！！一千次是的！", "她扑进你的怀里，紧张地吻着你的嘴唇。", "g: 这真的让我的一天变得愉快！我会想念你！！再见。"], multiple=True)

    add_dialogue("free_girlfriend intro", ("repressed"), ["mc: 嗨 [girl.name]...你能跟着我一下吗？", "g: 嗨，亲爱的。我非常想念你...你好吗？", "mc: 我很好，亲爱的....过来一下。我想和你玩一个小游戏。这就是所谓的真心话大冒险。", "g: 好的...听起来很有趣！它是如何工作的？", "mc: 你可以问我任何你想问的问题....我要么如实回答，要么听从你的命令。", "g: 嗯....好吧？我想我有点明白了...这个问题怎么样..."], multiple=True)
    add_dialogue("free_girlfriend right", ("repressed"), ["mc: 对于这个游戏来说，这是一个有点奇怪的问题......我不确定你是否完全理解了这个概念......", "g: *咯咯*不过回答正确！这个游戏很有趣。轮到我了！！", "mc: 好的。让我们看看...我该问什么...", "mc: 啊，这是一个很好的。你多久自慰一次？", "g: *脸红*[MC.name]！你到底是怎么了！我不回答这个问题....所以现在你可以给我下命令了，对吧？", "mc: 没错！我命令你....裸体！", "g: *脸红*什-什么？我不能那样做！！", "mc: 好吧，那么回答问题吧。这就是游戏的运作方式。", "g: 哇哦....好吧！我会听从你的命令。"], multiple=True, love=5)
    add_dialogue("free_girlfriend give_up", ("repressed"), ["mc: 对于这个游戏来说，这是一个有点奇怪的问题......我不确定你是否完全理解了这个概念......", "g: *咯咯笑*你只是一个痛苦的失败者。更好地了解我！也许我们什么时候可以再玩一次。"], multiple=True, love=-5)
    add_dialogue("free_girlfriend wrong", ("repressed"), ["mc: 对于这个游戏来说，这是一个有点奇怪的问题......我不确定你是否完全理解了这个概念......", "g: 没关系，你为什么不选正确的答案呢？ *疯狂的*"], multiple=True, love=-10)
    add_dialogue("free_girlfriend success", ("repressed"), ["她紧张地把衣服一件一件地脱掉。", "g: 好了，我做到了！", "当你盯着她的时候，你能感觉到血液涌入你的阴茎。当她注意到这一点时，她吃了一惊。", "g: 不....我不喜欢你这样....我们别再玩这个游戏了。"], multiple=True)
    add_dialogue("free_girlfriend success naked", ("repressed"), ["她紧张地把衣服一件一件地脱掉。", "g: 好了，我做到了！没问题！你实际上会感到惊讶......当我在家时，我花了很多时间裸体。 *眨眼*", "当你盯着她的时候，你能感觉到血液涌入你的阴茎。当她注意到这一点时，她吃了一惊。", "g: 不....我不喜欢你这样....我们别再玩这个游戏了。"], multiple=True)

    add_dialogue("free_job_request", ("repressed"), ["g: 哦，[MC.name]，可怕的消息...... *抽泣*", "mc: 哦不....怎么了，[girl.name]？", "g: 我们的房子...它被烧毁了...而父亲...他在试图扑灭火焰时倒下了...而母亲...她失踪了！", "g: 我现在孤身一人了。没有床可以睡，没有家可以回....", "g: 我不能生活在阴沟里！我该怎么办？！", "她突然哭了起来.", "mc: 可怜的[girl.name]...别担心，我们会想办法的..."], multiple=True)
    add_dialogue("gizel take girl to farm", ("repressed"), ("啊哈哈哈！是时候去冒险了，愚蠢的母狗。"))
    add_dialogue("slave positive reaction", ("generic"), ["哇！这个是来做什么的？", "真的吗，主人？ W-为什么？", "噢，主人....你为什么要对我好？", "等等，那是做什么用的？", "主人....为什么？"])
    add_dialogue("slave bullied", ("repressed","very sub"), ["不好了..."])
    add_dialogue("slave negative fixation accept", ("generic"), ["但是主人，这太恶心了....", "我-我对此不太确定...", "C-我们不能做点别的吗？", "我不喜欢，但是....温柔一点，好吗？"])
    add_dialogue("MC fight intro", ("repressed", "very sub"), ["g: 你不能！不是这个...不，拜托！", "她看起来很惊恐，因愤怒而浑身发抖。没想到，她却反抗你，并试图把你推开。"], multiple=True, sound=s_scream_loud)
    add_dialogue("slave chat slave_life -2", ("repressed"), ["当她看着你时，脸上满是泪水。", "g: *呜咽*", "mc: 来吧，[girl.name]。事情不可能那么糟糕！", "g: *抽泣*是的，它可以而且确实如此。", "像我这样的女孩——青楼的奴隶？！这一切就像一场非常可怕的噩梦......", "g: 但我好像没有醒来...."], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life -1", ("repressed"), ["g: 她眼神茫然，好像她的心思在别处。你试图安慰她，但收效甚微。", "g: 我...我不敢相信...我的生活已经变成这样了...", "g: 我不想成为奴隶....在肮脏下流的房子里....", "g: 我的[girl.story_guardian]会怎么想？"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0", ("repressed", "loyal"), ["她给你一个悲伤的表情。", "g: 我不喜欢这样，但这是我的责任。", "g: 生活中有些事情我们只能接受。", "g: 我会尽力而为。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0.5", ("repressed"), ["她鞠躬。", "g: 作为您的奴隶，生活并不坏，主人。", "g: 还有更糟糕的事情可能发生在我身上。", "我只是希望它不是在青楼里。我的 [girl.story_guardian] 总是警告我那些......"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 1", ("repressed"), ["她笑了。", "g: 我喜欢当奴隶，主人。", "g: 我喜欢这样，当我没有自己决定事情的时候..", "g: 它帮助我控制危险的冲动。", "g: 这样我就有安全感了。谢谢主人。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 2", ("repressed"), ["她倒在你脚边。", "g: 主人，我喜欢做你的奴隶！", "g: 成为你的奴隶是我经历过的最好的事情....", "g: 希望您对我的服务感到满意？"], multiple=True, unlock="DS")
    add_dialogue("slave chat brothel -2", ("repressed", "very modest"), ["你注意到她在哭。她低下头，避开你的目光。", "g:  *呜咽* *嗤之以鼻* *呜咽*", "mc: 别哭，[girl.name]。到最后都会好起来的！如果还不好，那就还没有结束。", "她抬头看着你。", "g: 不，这{b}是{/b}结束了！这是我最可怕的噩梦...", "g: 我的[girl.story_guardian]把我养育成一个好女孩，但现在我却在一个肮脏的罪恶之家，女人被买来是为了....呜咽....难以形容的事情....", "她又开始哭泣。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel -1", ("repressed", "very modest"), ["你发现她凝视着远方。当她看着你的时候，眼里几乎没有掩饰愤怒。", "g: 我....简直不敢相信！我不敢相信我已经堕落到这样的地步了。", "我不敢相信我必须在这样一个肮脏、卑鄙的地方工作！"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0", ("repressed", "very modest"), ["她沉默了一会儿。", "g: 这个地方并不像我想象的青楼那么糟糕。我的 [girl.story_guardian] 总是警告我关于欲望之屋以及堕落女性会发生什么......", "g: 但是当我了解了她们之后，我发现无论是女孩还是顾客都是普通人。", "g: 生活还要继续，我会挺过去的...."], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0.5", ("repressed"), ["她的唇边带着淡淡的微笑。", "g: 这根本不像我想象中的青楼。", "g: 生活很艰难，但我....*吞咽*....发现了....关于我自己的新事物。", "g: 我在青楼工作，感觉....就像工作一样....还不错。"], multiple=True, unlock="LM")

    add_dialogue("slave chat brothel 1", ("repressed", "very modest"), ["她的脸颊微微泛红。", "g: 我的[girl.story_guardian]总是警告我坏女孩和堕落女人会发生什么......", "g: 现在....我想....我是其中之一....", "她停了下来，压低声音，低声说道。", "g: 我....*吞咽*....意识到....我喜欢和所有这些男人一起做....{i}it{/i}。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 2", ("repressed"), ["她看着你微笑。从她的眼神就可以看出她很兴奋。", "g: 我从来没想过我可以....*吞咽*....成为一个{i}那种{/i}类型的女孩。", "g: 不是我....不是我的成长经历....不是[girl.fullname]，她总是牢记自己的纯洁和荣誉。 ", "g: 但是这个地方让我非常关心我自己。", "g: 我一直都是那样的女孩。", "我需要鸡巴....很多鸡鸡。 *傻笑*", "g: 在这里我可以拥有我能处理的所有鸡巴！我喜欢这个地方，主人！", "g: 谢谢你帮助我接触到自己....真正的我。"], multiple=True, unlock="LM")
    add_dialogue("slave chat tastes likes", ("repressed", "sweet", "helper", "loyal"), ("每个人都有自己最喜欢的[thing_cn]。对我来说，它必须是[best]。"), unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("repressed", "stubborn", "princess"), ("当我想到[thing_cn]时，[worst]是最后想到的。总的！", "我知道有些人喜欢[worst]。与此相比，我更喜欢任何其他[thing_cn]。"), unlock="LM")
    add_dialogue("slave chat origins 1", ("repressed", "stubborn", "prude"), ("我是在[girl.origin]长大的，不像这个城市污水坑里的大多数女孩。", "我在[girl.origin]出生和长大。", "我的家人在 [girl.origin] 附近过着舒适的生活。"), unlock="EI")
    add_dialogue("slave lecture fear", ("very modest"), ("她害怕你。"))
    add_dialogue("slave train obedience", ("repressed", "very sub"), ("当然，主人。我会立即着手处理。"))
    add_dialogue("slave train constitution", ("repressed", "very extravert"), ("是的先生！锻炼对于健康的身体和精神很重要。"))
    add_dialogue("slave magic sensitivity success", ("generic"), ("嗯....我是取悦诸神的容器...."), sound=s_mmh)
    add_dialogue("slave magic failure", ("repressed", "very dom"), ("什...你到底在做什么？嘿，你在对我尝试一些肮脏的魔法！哎呀！走开！！！"), sound=s_scream, unlock="DS")

    add_dialogue("slave reward sex accepted", ("very modest"), ("当然，主人。请...温柔点...*微笑*"), love=-1, sound=s_ahaa, unlock="LM")

    add_dialogue("slave reward sex refused", ("repressed", "very dom"), ("什么？！？决不！！！离我远点！！！"), sound=s_scream)
    add_dialogue("slave reward praise", ("repressed", "very idealist"), ("谢谢主人。我很高兴听到这个消息。"), love=1, unlock="MI")
    add_dialogue("slave reward gold", ("repressed", "very idealist"), ("好，谢谢。"), unlock="MI")
    add_dialogue("slave reward pet", ("repressed", "very sub"), ["你给了她一个拥抱，她靠在你的肩上，把头靠在你的肩上。", "g: 谢谢主人。感觉不错..."], multiple=True, love=1, unlock="DS")
    add_dialogue("slave reward day off", ("repressed","very extravert"), ("真的吗？谢谢主人，真是一​​个惊喜...."), love=1, unlock="DS")
    add_dialogue("slave reward day off KO", ("generic"), ["g: 但是主人，今天已经是我休息的日子了....", "mc: 啊，对了。我已经忘记了。"], multiple=True)
    add_dialogue("slave punish scold deserved", ("repressed", "very idealist"), ["她看起来很受伤。", "g: 很抱歉我总是没有让您满意。"], multiple=True, fear=1, unlock="MI")
    add_dialogue("slave punish scold undeserved", ("repressed", "very idealist"), ["她看起来很受伤。", "g: 这不是真的！我不值得受到这样的虐待！"], multiple=True, love=-1, unlock="MI")
    add_dialogue("slave punish upkeep", ("very modest"), ("噢..."), unlock="MI")
    add_dialogue("slave punish upkeep KO", ("generic"), ["g: 但、但是....你已经剥夺了我的零用钱....", "mc: 哦，对了，哈哈....我只是在测试你。"], multiple=True)
    add_dialogue("slave punish beat", ("generic"), ["当你让她尝尝你的管教时，她会随着每一次打击而哭泣和尖叫。", "g: 啊！啊啊哈！！！主人....拜托....啊啊！"], multiple=True, sound=s_screams, unlock="DS")
    add_dialogue("slave punish farm", ("generic"), ("农场？你在想什么？！？"), unlock="DS")
    add_dialogue("slave punish naked", ("very modest"), ("哎呀！！！别碰我！！！不！！！"), fear=3, unlock="LM")

    add_dialogue("slave punish rape", ("very modest"), ("哎呀！！！别碰我！！！不！！！"), fear=2, unlock="LM")
    add_dialogue("slave raped", ("generic"), ["不....啊啊啊！", "啊啊！！！啊！！！"], sound=s_screams)
    add_dialogue("slave rape positive fixation", ("generic"), ("啊，这太脏了....嗯...."), love=1, sound=s_aah)

## START SCHEMER DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("schemer", "princess", "pet"), ("我们有什么在这里？我是[girl.fullname]。我喜欢你的穿着方式！"), love=1)
    add_dialogue("free_greetings_casual", ("schemer", "pet"), ("你好呀。我是[girl.fullname]。好看的衣服！你看起来很有钱。 *傻笑*"), love=2)
    add_dialogue("free_greetings_rude", ("schemer", "stubborn"), ("你他妈刚刚说什么？我是[girl.fullname]，我发誓如果你再不尊重我，我就把你的老二扭断。"))

    add_dialogue("free_small_talk", ("schemer", "rebel"), ("我真的不在乎。"), love=1, max_cap=25)
    add_dialogue("free_gossip", ("schemer"), ("通常我会向您收取此类信息的费用。你听说过这个吗？"), max_cap=25)
    add_dialogue("free_chat_life", ("schemer", "stubborn"), ("我想了很多....我确实有我的理论，但你不会理解。这是很复杂的事情。"), love=1, max_cap=25)
    add_dialogue("free_chat_love", ("schemer"), ["她向你面前的地上吐口水。", "g: ....我不相信爱情。", "mc: 你的意思是，除非你能利用它？","g: 嘿，说得好。"], multiple=True, love=2, max_cap=25)
    add_dialogue("free_chat_origins", ("schemer"), ("我从底层开始，在 [girl.origin]。我现在就在这。", "我的旅程始于[girl.origin] - 并将以沐浴在敌人的鲜血中结束！", "这并不重要...很快[girl.origin]就会被烧毁。"), max_cap=40)
    add_dialogue("free_chat_hobbies", ("schemer"), ("我已向市议会提交了一份提案，要求驱逐任何不喜欢[hobby]的人。", "如果你不能欣赏[hobby]，那么我就无法欣赏你对呼吸的渴望。", "任何不喜欢[hobby]的人都应该被围捕并投入劳教所。"), love=2, max_cap=40)
    add_dialogue("free_chat_likes", ("schemer", "rebel"), ("除了[best]之外，我才不在乎任何[thing_cn]。", "所有其他[thing_cn]都应该跪下并崇拜[best]。"), love=2, max_cap=40)
    add_dialogue("free_chat_dislikes", ("schemer"), ("如果没有[worst]作为[thing_cn]，世界将会变得更加美好。", "我已经制定了一个计划来消除世界上的[worst]。", "如果我有办法的话，[worst]将不再是[thing_cn]。我将确保它成为过去时代的珍品，只能在博物馆中找到。"), max_cap=40)

    add_dialogue("free_joke_harmless", ("schemer", "stubborn", "princess"), ("*叹气*你真的认为这很有趣吗？得到帮助。"), love=2, max_cap=50)
    add_dialogue("free_joke_adult", ("schemer", "stubborn", "princess", "cold"), ("哦，我明白了。 {i}你{/i}就是个笑话。"), love=-1, max_cap=50)
    add_dialogue("free_joke_dark", ("schemer", "rebel"), ("好吧，那很好。"), love=3, max_cap=50)
    add_dialogue("free_joke_mean", ("schemer"), ("好吧，轮到我了！你父母是表兄弟吗？是你逃离了他们，还是他们逃离了你？", "好的！这个怎么样：你看起来并不像个十足的白痴。有些零件明显缺失！", "好的。你听过这个吗？当你的上帝把牙齿放进你嘴里时，他毁了一个完美的混蛋！", "轮到我了！我想从你的角度看问题，但我不能把我的头放在我的屁股上！", "呵呵。你能去找你老公吗，我不喜欢和丑女人打架！", "不错....公主和感冒的野鸭有什么区别？一个人是个病态的鸭子，我忘记了笑点，但你妈妈是个妓女！"), love=-1, max_cap=50)

    add_dialogue("free_touch_hand", ("schemer"), ("嗯，[MC.name]...你在做什么？"), love=3, max_cap=90)
    add_dialogue("free_touch_kiss", ("schemer"), ["g: [MC.name]...", "g: *低语* {i}...你愿意为我杀人吗？{/i}"], multiple=True, love=5, max_cap=90)
    add_dialogue("free_touch_ass", ("schemer", "nerd"), ("你认为你在做什么？"), love=-1, max_cap=90)
    add_dialogue("free_touch_breasts", ("schemer", "rebel"), ("*咯咯笑*也许我应该给你看一下，但要付点钱。"), love=2, max_cap=90)
    add_dialogue("free_touch_pussy", ("schemer"), ["她的反应是抓住你的蛋蛋。", "当她挤压你的袋子时，她给你一个顽皮的笑容。", "g: 我{}完全{/i}知道你想从我这里得到什么，[MC.name]。", "g: 我会确保你明白。只要{i}I{/i}得到{i}I{/i}想要的东西。"], multiple=True, max_cap=90)

    add_dialogue("free_play refuses", ("schemer", "rebel"), ("他妈的不！"), love=-1)
    add_dialogue("free_play very reluctant", ("schemer"), ("呃！你就是个有病的混蛋。为此你欠我的。"), love=1)
    add_dialogue("free_play reluctant", ("schemer", "bimbo", "cold"), ("呃，{i}真的{/i}？你喜欢这样的事情吗？"), love=2)
    add_dialogue("free_play a little reluctant", ("schemer", "bimbo"), ("*叹气*好吧...只要答应我你会为我做一些事情作为回报。"), love=2, sound=s_sigh)
    add_dialogue("free_play indifferent", ("schemer", "bimbo"), ("*叹气*让我们结束这一切......"), love=3, sound=s_sigh)
    add_dialogue("free_play a little interested", ("schemer", "bimbo", "cold"), ("这对我行得通。"), love=4)
    add_dialogue("free_play interested", ("schemer"), ("*咯咯*我希望你会问这个。"), love=4, sound=s_mmh)
    add_dialogue("free_play very interested", ("schemer"), ("这将是我的荣幸！"), love=5, sound=s_mmh)
    add_dialogue("free_play fascinated", ("schemer", "rebel"), ("是的！我他妈的喜欢它！"), love=5, sound=s_mmh)
    add_dialogue("MC take virginity", ("schemer"), ("啊哈哈哈，我终于做到了！谢谢你，[MC.name]。你是我的第一个。"), love=5)
    add_dialogue("free_play interested after", ("schemer"), ("我们应该更频繁地这样做。"))
    add_dialogue("free_play not interested after", ("schemer"), ("呃，那真是太恶心了。"))

    add_dialogue("free_flirt_beauty", ("schemer", "pet", "generic", "bimbo"), ("AWW谢谢！"), love=3, max_cap=75)
    add_dialogue("free_flirt_body", ("schemer"), ("我知道如何使用它。 *眨眼*"), love=3, max_cap=75)
    add_dialogue("free_flirt_mind", ("schemer"), ("你知道的！"), love=1, max_cap=75)
    add_dialogue("free_flirt_spirit", ("schemer", "stubborn", "bimbo", "class president"), ("哦，是吗？"), love=1, max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("schemer"), ["她咧嘴一笑，舔了舔嘴唇。", "g: 当然，我已经吃够了。最终他们总是跪下，乞求更多。"], multiple=True, love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("schemer"), ["她微笑着点点头。", "g: 足以停止计数。男人就是这么容易被操纵...."], multiple=True, love=2)
    add_dialogue("free_flirt_sex_experience average", ("schemer"), ["她在回答之前思考了一会儿。", "g: 我想我对男人有点挑剔。这需要相互交流，你知道吗？"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("schemer"), ["g: 她叹了口气。", "g: 我有标准。你需要证明你的价值才能进入我的裤子。"], multiple=True)
    add_dialogue("free_flirt_sex_experience very inexperienced", ("schemer"), ["她看起来很生气。", "g: 不，还没有。", "g: 我现在基本上把这张王牌藏在了袖子里。"], multiple=True, love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("schemer"), ("我现在会珍惜我的少女时代......我会让男人们为之奋斗。"), love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("schemer"), ("听起来确实很傻。尤其是对于一个男人来说。你怎么了？"), love=4)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("schemer"), ("来吧...我们在他妈的泽恩，已知世界的性之都。你为什么要对这样的事情撒谎？"), love=1)

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("schemer"), ("哦？这让我想知道为什么。我以为你比这更有趣。"), love=4)
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("schemer"), ("我猜你至少有几十个。泽恩的女孩子就是这么简单。"), love=1)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("schemer"), ("是的，很公平。"), love=-3)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("schemer"), ("嗯，您可能{i}认为{/i}是，但这并不能成为事实。"), love=2)
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("schemer"), ["她翻白眼。", "g: 是的，对。", "g: 我怀疑，即使你的能力是你实际水平的两倍，你仍然只有你想象的一半。"], multiple=True)
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("schemer"), ["她点点头。", "g: 店主必须知道他卖的是什么。"], multiple=True, love=1)

    add_dialogue("free_flirt_sex_act refuses", ("schemer"), ["她看起来很不安。","g: 这确实不关你的事。你是在为政府工作，研究折磨我的方法吗？他们永远不会活捉我！", "你怀疑她讨厌这个话题。"], multiple=True)
    add_dialogue("free_flirt_sex_act very reluctant", ("schemer"), ["她的脸色变得苍白。", "g: 我拒绝回答这个问题。你是想揭穿我的弱点吗？","你怀疑她讨厌这个话题。"], multiple=True)
    add_dialogue("free_flirt_sex_act reluctant", ("schemer"), ["g: 我为什么要告诉你这个？我不会泄露我的秘密。", "g: 无论你想对我施加什么样的折磨，你都不会击垮我。绝不！", "你怀疑她不喜欢这种行为。"], multiple=True)
    add_dialogue("free_flirt_sex_act a little reluctant", ("schemer"), ["g: 我为什么要和你分享这个？您正在与{i}他们{/i}合作，不是吗？", "g: 收集信息，是吗？好吧，你从我这里什么也得不到。我还是闭嘴吧", "你怀疑她有点不喜欢这个行为。"], multiple=True)
    add_dialogue("free_flirt_sex_act indifferent", ("schemer"), ["g: 我不是妓女。你为什么想知道这些事情？这是工作面试吗？", "你怀疑她对这种性行为没有保留。"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_act interested", ("schemer"), ["她脸红.", "g: 你为什么想知道？你是那些试图引诱我的特工之一吗？我不会被转身。", "尽管她试图隐瞒，但你怀疑她对这个话题感兴趣。"], multiple=True, love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("schemer"), ["她脸红.", "g: 谁想知道？难道是光明会想引诱我落入陷阱？你永远抓不到我。", "尽管她试图隐瞒，但你怀疑她对这个话题感兴趣。"], multiple=True, love=2)
    add_dialogue("free_flirt_sex_act very interested", ("schemer"), ["她的脸变成鲜红的。", "g: 谁告诉你的！你听到的一切都是谎言。我不会被诱惑的！你不会打扰我的计划。", "她似乎特别喜欢这种性行为。"], multiple=True, love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("schemer"), ["她的脸变成鲜红的。", "g: 啊，原来你发现了我的秘密啊。但如何呢？我会在睡梦中说话吗？该死的....如果我能不再每晚都做这样的梦就好了！", "她似乎对这个话题非常着迷。"], multiple=True, love=3)

    add_dialogue("free_give_gold +++", ("schemer"), ("*亲吻*将为您建造一座雕像！万岁[MC.name]！！"), love=6, max_cap=75)
    add_dialogue("free_give_gold ++", ("schemer", "rebel"), ("*咧嘴一笑*您对这一事业的捐赠将不会被忘记。"), love=4, max_cap=75)
    add_dialogue("free_give_gold +", ("schemer", "rebel"), ("这就是全部吗？我需要更多的资金来资助叛乱。"), love=2, max_cap=75)
    add_dialogue("free_give_gold -", ("schemer", "rebel", "princess"), ("....是这样吗？再努力一点好吗？"), max_cap=75)
    add_dialogue("free_give_gold --", ("schemer", "rebel"), ("你在开玩笑吗？滚蛋吧。"), love=-1, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("schemer"), ["她的眼睛亮了起来。", "g: 你认为我在那里能赚很多钱吗，[MC.name]？", "g: 听起来确实是一场轻松的演出...."], multiple=True, love=2)
    add_dialogue("free_offer_job half_lie", ("schemer"), ["g: 什-什么？你为什么不告诉我！", "mc: 嗯，当时看起来并不相关......", "g: 你他妈的应该早点告诉我，混蛋！我....让我想想...."], multiple=True)
    add_dialogue("free_offer_job lie", ("schemer"), ["她突然大笑起来。","g: 我只是跟你开玩笑，我已经这么想了。", "g: 我的意思是，来吧....一个[girl.MC_lied]？真的吗？", "mc: 呵呵，看来你已经看透我了....", "g: 所以你认为我可以在青楼工作，是吗？"], multiple=True, love=-5)
    add_dialogue("free_offer_job success", ("schemer"), ["g: *叹气*是啊是啊，我们可以跳过那些无聊的事情吗？", "g: 这听起来轻而易举。我会直接进入国王堡垒。"], multiple=True)
    add_dialogue("free_offer_job thinking", ("schemer"), ["g: 呃，这根本不符合我的计划！", "g: 我必须回到绘图板。", "她离开了，看上去很沮丧。"], multiple=True)
    add_dialogue("free_offer_job failure lie", ("schemer"), ["g: 谢谢你的邀请，但这不适合我。", "g: 你太不靠谱了。我不会和你做生意。", "g: 不知道你还向我隐瞒了什么。", "她离开并开始与一家竞争对手青楼的老板聊天。", "mc: 哦，好吧，她接受这个世界充满了说谎的渣男只是时间问题。"], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("schemer"), ["g:  不，我不喜欢这些术语。", "g: 我要求适当的工资。如果必须的话，请不要将其记录在案。", "mc: 那不会发生。奴隶就是奴隶。", "她离开了，看上去很失望。"], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("schemer"), ["g:  太好了！我一直希望能遇到像你这样的人！", "mc: 哦？这是为什么？", "g: 我需要有人带我去王堡。", "mc: 我确信你可以在没有我帮助的情况下潜入那里......", "g: 我追求的不是一日游，你这个傻瓜！我要像贵族一样生活。", "mc: 是这样吗？你是做什么的？", "g: 我？呃....我是某个公会的....学徒？啊，是的，在木匠行会！"], multiple=True, love=-3)
    add_dialogue("free_friend half_lie", ("schemer"), ["她茫然地看着你。", "mc: 是的。我只是一个普通的[MC.playerclass]。这就是我。你呢？", "g: 我？哦，我是木匠行会的学徒。不过我也在考虑转行..."], multiple=True)
    add_dialogue("free_friend lie", ("schemer"), ["g: 啊，当然，我应该认为你是[lie]。你拥有适合它的完美体质。", "mc: 是的，就是我！你呢？", "g: 这并不像[lie]那么酷。我是木匠行会的专家桌子专家。", "mc: 哦？告诉我更多..."], multiple=True, love=3)

    add_dialogue("free_love_interest", ("schemer"), ["mc: 你好，[girl.name]。一切都好吗？", "g: 嗨[MC.name]。不是真的...我只是在想，已经是[season]了...", "g: 我感觉我的生活毫无进展....我失业了....", "mc: 噢不！你在木匠行会工作，对吗？", "g: 木匠行会？哦，是的...我确实告诉过你了。 *笑*", "g: 我想我只是需要一些东西让我高兴起来。一些鲜花可以照亮我的一天，你知道吗？"], multiple=True)
    add_dialogue("free_girl get_flowers", ("schemer"), ["g: 他们很可爱！太感谢了。", "g: ....你有什么想说的吗？"], multiple=True)
    add_dialogue("free_ask_out", ("schemer"), ["mc: [girl.name]，你愿意做我的女朋友吗？", "她咧嘴一笑，搓着手。", "g: 我很乐意，[MC.name]。这让我很高兴！", "她拍拍你的头，亲吻你的嘴唇。然后她开始在你耳边低语。", "g: {i}齐心协力，我们势不可挡。泽恩所有的人都会跪在我们面前。{/i}"], multiple=True)

    add_dialogue("free_girlfriend intro", ("schemer"), ["g: [MC.name]！我想告诉你一件事。", "mc: 嗨宝贝，这是什么？", "g: 我一直在做一个非常特别的项目。你必须保证保守秘密，好吗？", "mc: 好的，我保证。", "g: 但首先，我们需要为这个项目指定一个代号。嗯....怎么样...."], multiple=True)
    add_dialogue("free_girlfriend right", ("schemer"), ["g:  太棒了！你准备好了吗？", "她靠近你，在你耳边低语。", "g: {i}我在大教堂里安放了一枚炸弹。{/i}", "mc: 你做了什么？！", "g: 哦，不、没关系....也许我不应该告诉你....", "g: 我们换个话题吧！"], multiple=True, love=5)
    add_dialogue("free_girlfriend give_up", ("schemer"), ("美好的！反正我也不需要你！"), love=-5)
    add_dialogue("free_girlfriend wrong", ("schemer"), ("他妈的不！这是答错了！"), love=-10)
    add_dialogue("free_girlfriend success", ("schemer"), ["她脱掉衣服，粘在你身上。", "g: 很高兴和你在一起...", "mc: 等、等一下，你刚才说大教堂的事是什么？", "g: 噢，别想了....享受我们在一起的这一刻吧....", "g: 想象一下你和我，在一片火焰中....", "mc: 火焰？", "g: 我有说火焰吗？我指的是鲜花。你和我在花海里....不是很好吗？"], multiple=True)
    add_dialogue("free_girlfriend success naked", ("schemer"), ["她粘着你。", "g: 我很高兴和你在一起......当我在你身边时我想一直裸体。", "mc: 等、等一下，你刚才说大教堂的事是什么？", "g: 噢，别想了....享受我们在一起的这一刻吧....", "g: 想象一下你和我，在一片火焰中....", "mc: 火焰？", "g: 我有说火焰吗？我指的是鲜花。你和我在花海里....不是很好吗？"], multiple=True)

    add_dialogue("free_job_request", ("schemer"), ("我需要一份工作，[MC.name]。有成长机会的东西。你能关注一下我吗？"))
    add_dialogue("refuse farm", ("very dom"), ["农场吗?不! !你不能强迫我!", "我不去农场，就这么定了!绝不!!!", "啊！不，不去农场，你在开玩笑吗?!?"])
    add_dialogue("gizel take girl to farm", ("schemer"), ("哈哈！终于有一个新的奴隶少女被鞭打屈服了。"))
    add_dialogue("MC fair promise", ("schemer", "very lewd"), ["她给你一个怀疑的眼神。", "g: 谢谢，我想。"], multiple=True, fear=-1)

    add_dialogue("MC harsh promise", ("very dom"), ("她咬紧牙关，露出挑衅的表情，但什么也没说。"), love=-3, fear=2)
    add_dialogue("slave naked request resist", ("generic"), ("这太恶心了....不...."), love=-1, fear=-2)
    add_dialogue("slave chat feelings very disobedient", ("very dom"), ("但我不承认你是‘Master’之类的！"), unlock="DS")
    add_dialogue("slave chat feelings disobedient", ("very dom"), ("不是要戳破你的幻想，但我也不会向你低头。我希望你能正确对待我。"), unlock="DS")
    add_dialogue("slave chat feelings a little obedient", ("very dom"), ("我想我是个奴隶，所以我必须听从你的命令。不过，别逼我太紧。"), unlock="DS")
    add_dialogue("slave chat feelings obedient", ("very dom"), ("我是来尊重你的。作为我的....主人，我想。 *吞*"), unlock="DS")
    add_dialogue("slave chat feelings very obedient", ("very dom"), ("为您服务是我的荣幸，主人。有什么事就问我吧。"), unlock="DS")
    add_dialogue("slave chat tastes likes", ("schemer", "rebel"), ("除了[best]之外，我才不在乎任何[thing_cn]。", "所有其他[thing_cn]都应该跪下并崇拜[best]。"), unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("schemer"), ("如果没有[worst]作为[thing_cn]，世界将会变得更加美好。", "我已经制定了一个计划来消除世界上的[worst]。", "如果我有办法的话，[worst]将不再是[thing_cn]。我将确保它成为过去时代的珍品，只能在博物馆中找到。"), unlock="LM")
    add_dialogue("slave chat origins 1", ("schemer"), ("我从底层开始，在 [girl.origin]。我现在就在这。", "我的旅程始于[girl.origin] - 并将以沐浴在敌人的鲜血中结束！", "这并不重要...很快[girl.origin]就会被烧毁。"), unlock="EI")
    add_dialogue("slave train naked failure", ("very dom"), ("不！别看我！"), sound=s_surprise)
    add_dialogue("slave punish scold deserved", ("schemer", "very materialist"), ["她看起来很生气。", "g: 哼...."], multiple=True, unlock="MI")
    add_dialogue("slave punish scold undeserved", ("schemer", "very materialist"), ["她看起来很生气。", "g: 哼...."], multiple=True, love=-1, unlock="MI")

## START PRUDE DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("prude", "very modest", "repressed"), ("名字是[girl.fullname]。很高兴认识你，[MC.name]。"), love=3)
    add_dialogue("free_greetings_casual", ("prude", "very modest"), ("[MC.name]？我的名字是[girl.fullname]。我很乐意聊天。"), love=1)
    add_dialogue("free_greetings_rude", ("prude", "stubborn", "very modest"), ("我看起来像是想要你的陪伴吗？哼。我叫[girl.fullname]，去追别的女孩吧！"), love=-1)

    add_dialogue("free_small_talk", ("prude", "class president"), ("哦，我只是在想同样的事情！", "琐事确实能为生活增添色彩，你不同意吗？", "你说得很对，[MC.name]。"), love=1, max_cap=25)
    add_dialogue("free_gossip", ("prude", "holy", "princess"), ("*喘息*你听到国王要塞的最新低语了吗？你永远猜不到公主穿的是什么......", "*喘息*我听说图书馆已添加了色情收藏。可耻，你不同意吗？", "哦，有很多话要说！我们从哪里开始..."), love=2, max_cap=25)
    add_dialogue("free_chat_life", ("prude", "holy"), ("一个有趣的问题！愿太阳神引导我们找到我们如此迫切寻求的答案。"), love=1, max_cap=25)
    add_dialogue("free_chat_love", ("prude", "holy", "repressed", "pet", "loyal"), ("哼....生活不像童话！稳定的婚姻需要的是一个尽职的妻子和阿里奥的祝福，仅此而已。"), max_cap=25)
    add_dialogue("free_chat_origins", ("prude", "class president", "holy", "princess"), ("我的婴儿床位于 [girl.origin] 的一个古色古香的小角落。"), love=2, max_cap=40)
    add_dialogue("free_chat_hobbies", ("prude", "repressed", "very modest", "sweet"), ("啊，我很高兴你问了！我喜欢练习[hobby]。真是令人心旷神怡。"), love=2, max_cap=40)
    add_dialogue("free_chat_likes", ("prude", "repressed", "holy", "loyal", "pet"), "我最喜欢的[thing_cn]？我承认我确实时不时地享受[best]。", max_cap=40)
    add_dialogue("free_chat_dislikes", ("prude", "holy", "very modest"), ("嗯....我很抱歉，但是....我不能说我曾经认真考虑过这件事。我想[worst]并不是我最喜欢的[thing_cn]。", "我的朋友们在谈论[thing_cn]时变得非常兴奋。他们说[worst]是Arios的祝福，但我完全不同意！"), max_cap=40)

    add_dialogue("free_joke_harmless", ("prude", "class president", "easy", "meek", "masochist", "cold"), ("*笑*没有喜剧的生活几乎算不上什么生活！"), love=1, max_cap=50)
    add_dialogue("free_joke_adult", ("prude", "schemer", "class president"), ("一句无味的话。如果你没有什么更好的话要对我说，我就跟你告别了。"), love=-1, max_cap=50)
    add_dialogue("free_joke_dark", ("prude", "princess", "yandere", "holy"), ("呵呵....虽然很粗俗，但是这个笑话有一定的魅力。"), love=1, max_cap=50)
    add_dialogue("free_joke_mean", ("prude"), ("*笑*没有喜剧的生活几乎算不上什么生活！"), love=3, max_cap=50)

    add_dialogue("free_touch_hand", ("prude", "holy", "sweet", "tsundere"), ("*脸红* [MC.name]...如果有人看到我们怎么办？"), love=2, max_cap=90)
    add_dialogue("free_touch_kiss", ("prude", "princess", "creep"), ("嗯....这一刻我一直在做白日梦。"), love=4, max_cap=90)
    add_dialogue("free_touch_ass", ("prude", "creep", "princess", "class president", "tsundere"), ("*喘气*表现得好！"), love=1, max_cap=90)
    add_dialogue("free_touch_breasts", ("prude", "holy", "helper", "pet"), ("*脸红*小心一点，[MC.name]。那些很敏感。"), love=3, max_cap=90)
    add_dialogue("free_touch_pussy", ("prude", "holy", "stubborn"), ("*巴掌*你怎么敢！猪！"), love=-1, max_cap=90)

    add_dialogue("free_play refuses", ("prude", "repressed", "princess", "holy", "very modest"), ("打扰一下？！这可不是开玩笑的事。", "太恶心了。让你的思想走出阴沟！"), love=-1)
    add_dialogue("free_play very reluctant", ("prude", "very modest"), ("*抽泣*我为什么要这样做？原谅我，父亲。"), love=1)
    add_dialogue("free_play reluctant", ("prude", "very modest"), ("*喘气*那是大错特错了！我不敢相信你让我这么做。"), love=2)
    add_dialogue("free_play a little reluctant", ("prude", "very modest"), ("*叹气*我真的不应该，但我知道你有多执着。"), love=2)
    add_dialogue("free_play indifferent", ("prude", "very modest"), ["g: *喘息*你怎么敢，恶棍！","g: *低语*不要在公共场合脱口而出！我们去那边那个僻静的地方吧。"], multiple=True, love=3)
    add_dialogue("free_play a little interested", ("prude", "very modest"), ("你是一个大胆的人。你不觉得我们应该先结婚吗？", "[MC.name]！你又喝酒了吗？我不敢相信你让我这么做。"), love=4)
    add_dialogue("free_play interested", ("prude", "very modest"), ("*喘息*你对我的影响太糟糕了。我不敢相信我真的同意了。", "你就没有羞耻心吗？你不能突然问我这个问题....如果我为你做这件事，你会表现得好吗？"), love=4)
    add_dialogue("free_play very interested", ("prude", "very modest"), ("*脸红*你已经无可救药了。我们去那里做吧，没人会注意到我们的地方。"), love=5)
    add_dialogue("free_play fascinated", ("prude", "very modest"), ("*脸红*我羞于承认这一点，但我无法抗拒诱惑。", "我知道这是答错了，但你就是无法抗拒。"), love=5)
    add_dialogue("MC take virginity", ("prude", "very modest"), ["她看起来心烦意乱。", "g: *抽泣*哦，Arios请原谅我...你夺走了我的清白！", "g: 我感觉不舒服。我做了什么？！"], multiple=True, love=5)
    add_dialogue("free_play interested after", ("prude", "very modest"), ("我明白为什么有些人会沉迷于这种肮脏的行为。"))
    add_dialogue("free_play not interested after", ("prude", "very modest"), ("那真是太恶心了。你应该感到羞耻，逼我这样贬低自己。"))

    add_dialogue("free_flirt_beauty", ("prude", "princess", "repressed"), ("谢谢你的客气话，[MC.name]。我总是尽力让自己看起来漂亮。","谢谢你，[MC.name]。你自己看起来也很衣冠楚楚啊！"), love=2, max_cap=75)
    add_dialogue("free_flirt_body", ("prude", "princess", "repressed", "holy"), ("我可以想出一个更雄辩的方式来表达它，但仍然感谢你的赞美。","谢谢你！维持这个数字需要努力。但请记住，凝视是不礼貌的。"), love=1, max_cap=75)
    add_dialogue("free_flirt_mind", ("prude", "helper", "schemer"), ("我确实喜欢讨论严肃的话题。这没有什么问题，不是吗？","哦？我没想到会得到你的称赞，但还是谢谢你。"), love=1, max_cap=75)
    add_dialogue("free_flirt_spirit", ("prude", "masochist", "schemer", "class president", "nerd"), ("*咯咯*我不能完全相信这一点。和你说话让我的一天充满阳光。","我确实很欣赏这一点。不知何故，当你在身边时，我的心情不可避免地会好起来。"), love=1, max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("prude", "very modest"), ("你这个流氓！你不应该向一位女士询问此类话题。有些事还是不说比较好。 *眨眼*"), love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("prude", "very modest"), ("*叹气*我确定您想知道，但您真的不应该向女士询问此类事情。这是不礼貌的。"), love=2)
    add_dialogue("free_flirt_sex_experience average", ("prude", "very modest"), ("[MC.name]，乖！我不想用答案来荣耀这个问题。"), love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("prude", "very modest"), ("管住你的嘴，[MC.name]！提出这样的问题是一件可耻的事情。你父母会怎么想？"))
    add_dialogue("free_flirt_sex_experience very inexperienced", ("prude", "very modest"), ("多么粗俗啊！对不起，我不想再和你在一起了。"), love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("prude", "very modest"), ("太粗鲁了！不言而喻，我是在为婚姻而保存自己，就像所有女孩都应该做的那样。"), love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("prude", "very modest"), ("这一点也不傻，[MC.name]。其实我觉得这是一件非常值得敬佩的事情！"), love=3)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("prude", "very materialist", "very modest"), ("*叹气* [MC.name]，你应该对我诚实。即使你过去犯过一些可怕的错误。我值得知道。"), love=-3)

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("prude", "very modest", "very materialist"), ("哦。我想这很正常，毕竟你是个男人..."), love=4)
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("prude", "very modest"), ("*叹气*这不是我所希望的答案。我们都会犯错。诚实为宽恕铺平道路。"), love=1)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("prude", "class president"), ("Oh..."), love=1)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("prude", "very modest", "very materialist"), ("我希望你没有提到这一点...但是一个正派的男人很难找到，所以我想这是可以预料的。"), love=1)
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("prude", "very modest"), ("我无法理解你为什么要吹嘘自己道德如此松散。"), love=-1)
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("prude", "very modest", "very materialist"), ("别在我脸上做文章!我男朋友是个皮条客已经够糟糕的了，我不需要提醒."), love=3)

    add_dialogue("free_flirt_sex_act refuses", ("prude", "very modest"), ("当然不是！你当我是什么？","你怎么敢！我绝不会做这样的事。"))
    add_dialogue("free_flirt_sex_act very reluctant", ("prude", "very modest"), ("这太庸俗了！让你的思想走出阴沟！","你的心怎么会充满这样的污秽呢？生活中除了这些你似乎痴迷的性话题之外还有更多的事情。"))
    add_dialogue("free_flirt_sex_act reluctant", ("prude", "very modest"), ("为什么每次和你的谈话都要聊到这样的话题？","我不明白为什么你会认为这是一个合适的话题。"))
    add_dialogue("free_flirt_sex_act a little reluctant", ("prude", "very modest"), ("这实在是太离谱了。我怀疑教会会批准这种享乐主义。","我无法让自己享受这种放荡的行为。"))
    add_dialogue("free_flirt_sex_act indifferent", ("prude", "very modest"), ("我对此事的看法无关紧要。这是一个不恰当的话题。"), love=1)
    add_dialogue("free_flirt_sex_act interested", ("prude", "very modest"), ("就算我说了，这个时候讨论这种事也不合适。"), love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("prude", "very modest"), ("有趣的是你提出来了。您知道图书馆中有专门讨论该主题的部分吗？这、这只是我听到的谣言。"), love=2)
    add_dialogue("free_flirt_sex_act very interested", ("prude", "very modest"), ("*喘气*谁告诉你的？看在上帝的份上，我们来谈谈别的事情吧。"), love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("prude", "very modest"), ("*喘气*谁告诉你的？看在上帝的份上，我们来谈谈别的事情吧。"), love=3)

    add_dialogue("free_give_gold +++", ("prude", "holy", "very materialist"), ("祝福你，[MC.name]！我将确保将其用于公益事业。"), love=8, max_cap=75)
    add_dialogue("free_give_gold ++", ("prude", "very materialist", "masochist"), ("你确定吗？你真是太好了，[MC.name]。"), love=5, max_cap=75)
    add_dialogue("free_give_gold +", ("prude", "very materialist"), ("谢谢你，[MC.name]。"), love=3, max_cap=75)
    add_dialogue("free_give_gold -", ("prude", "holy", "very materialist"), ("我不太明白你为什么这么做，但我不会拒绝。"), love=1, max_cap=75)
    add_dialogue("free_give_gold --", ("prude", "holy"), ("你以为我会被这种空洞的举动迷住吗？"), love=-2, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("prude", "very modest"), ["她看起来很震惊。","g: 这、这太荒谬了！你把我当成什么浪荡子了！","mc: 青楼有很多就业机会。我们有警卫、女佣、厨房工作人员，应有尽有。", "g: 对——对，当然！我很抱歉仓促下结论。"], multiple=True)
    add_dialogue("free_offer_job half_lie", ("prude", "very modest"), ["她看上去既震惊又震惊。","g: 呃！我要生病了！", "g: 所以、所以你一直向我隐瞒你这种放荡的生活方式....而现在你却希望我简单地接受这一点并开始为了金钱而自我贬低？", "g: 这、这太荒谬了！你把我当成什么浪荡子了？！","mc: 青楼有很多就业机会。我们有警卫、女佣、厨房工作人员，应有尽有。", "g: 哦，对....我想是这样....很抱歉仓促下结论。"], multiple=True)
    add_dialogue("free_offer_job lie", ("prude", "very modest"), ["她看上去既震惊又震惊。","g: 呃！我要生病了！", "g: 所以、所以你一直向我隐瞒你这种放荡的生活方式....而现在你却希望我简单地接受这一点并开始为了金钱而自我贬低？", "g: 这、这太荒谬了！你把我当成什么浪荡子了？！","mc: 青楼有很多就业机会。我们有警卫、女佣、厨房工作人员，应有尽有。", "g: 哦，对....我想是这样....很抱歉仓促下结论。"], multiple=True)
    add_dialogue("free_offer_job success", ("prude", "very modest"), ["g: 这只是一种形式，对吧？", "[girl.name] 仔细考虑你的提议，看上去很沉思。", "g: 我相信你，[MC.name]。我必须不断提醒自己，这只是暂时的困难，需要克服。", "g: 我有点不喜欢这个，但我看不到任何其他的前进方向。"], multiple=True)
    add_dialogue("free_offer_job thinking", ("prude", "very modest"), ["g: 这只是一种形式，对吧？", "[girl.name] 仔细考虑你的提议，看上去很沉思。", "g: 我需要更多时间来考虑这个问题。", "g: 我实在无法想象自己在青楼工作。一定还有别的办法。"], multiple=True)
    add_dialogue("free_offer_job failure lie", ("prude", "very modest"), ["她变得愤怒并打你的脸。", "g: 我绝对不会纵容你这种不道德的行为，更不会参与其中！", "她怒气冲冲地走了。", "mc: 嗯，一切都符合预期。让我们给她一些时间来炖吧。"], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("prude", "very modest"), ["g: [MC.name]！注意你的言行！这可不是开玩笑的事。", "g: 我绝不会纵容你的不道德行为，更不会参与其中。", "当她紧握双手时，她的手臂在颤抖。她的眼里涌出泪水。", "g: 我不敢相信你刚刚建议...我快要发脾气了。我们稍后再讨论这个问题。", "mc: 好的，女朋友。我只是想帮忙。"], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("prude", "very modest"), ["g: 什、什么？！这太可怕了！听到这个消息我很遗憾。", "g: 我们生活在一个多么残酷的世界，你看起来是一个多么正派和有能力的人。你怎么会陷入如此可怕的境地？", "mc: 你可能不喜欢听，但我为自己所做的事感到自豪。事情确实没有你想象的那么糟糕。", "g: 哦，可怜的灵魂。你已经习惯了生活在罪中。我会为你祈祷。", "mc: 我真的认为没有必要。那你是做什么的？", "g: 哦，不多....但我很乐意贡献自己的时间来帮助那些被引入歧途的人。", "g: 我一定会经常为你祈祷！保持坚强，[MC.name]。阿里奥将引导你走向光明。"], multiple=True, love=1)
    add_dialogue("free_friend half_lie", ("prude", "very modest"), ["g: 谢天谢地，你终于找到了一份受人尊敬的职业的工作。", "g: 你看上去是一个正派、有能力的人。我确信无论您致力于哪个职业，您都会取得成功。", "mc: 谢谢你的客气话。那你是做什么的？", "g: 哦，不多....但我很乐意贡献自己的时间来帮助那些被引入歧途的人。", "g: 我相信你会同意，现在泽恩恩存在着令人担忧的不道德和无法无天的现象。", "mc: 哦，有吗？我没注意到。"], multiple=True, love=3)
    add_dialogue("free_friend lie", ("prude", "very modest"), ["g: 谢天谢地，你终于找到了一份受人尊敬的职业的工作。", "mc: 谢谢你的客气话。那你是做什么的？", "g: 哦，不多....但我很乐意贡献自己的时间来帮助那些被引入歧途的人。", "g: 我相信你会同意，现在泽恩恩存在着令人担忧的不道德和无法无天的现象。", "mc: 哦，有吗？我没注意到。"], multiple=True, love=-2)

    add_dialogue("free_love_interest", ("prude"), ["g: 我很期待再次见到你的脸。最近怎么样？", "mc: 我做得很好！刚刚追上我最喜欢的女孩，[girl.name]。", "g: *脸红*你-你最喜欢的女孩？别这样拿我们的关系开玩笑。", "mc: 我不是在开玩笑！你真的是我的最爱。", "g: 别说了！我们都知道，如果你真的认真对待这件事，你就会带着鲜花来。"], multiple=True)
    add_dialogue("free_girl get_flowers", ("prude"), ("哦，它们看起来很可爱！什么情况？"))
    add_dialogue("free_ask_out", ("prude"), ["mc: [girl.name]，当我在你面前时，我的世界就会亮起来。你能做我女朋友吗？", "g: *脸红*你-你女朋友？这是多么大的一步啊！我不知道该说什么。", "mc: 就说是吧。让我们互相承诺。", "g: 是的，是的，我非常想要。抱歉，这一切让我感觉有点不知所措。", "mc: 没关系，[girl.name]。让我们一起手牵手第一次散步吧？"], multiple=True)

    add_dialogue("free_girlfriend intro", ("prude"), ["g: 哦，很高兴见到你[MC.name]。我们可以一起度过一段时间吗？", "mc: 当然可以！想要玩个小游戏吗，[girl.name]？", "g: 呃，游戏？我发现大多数游戏都非常无聊。你有什么想法？", "mc: 这个在威斯特玛的贵族中非常流行。他们称之为{i}诚实和勇气{/i}。", "g: *喘息*这个名字确实反映了一些令人钦佩的品质。它是如何工作的？", "mc: 这是一款旨在向年轻贵族传授这些美德重要性的游戏。", "mc: 我们每个人轮流。你可以问我任何问题，我必须诚实回答，或者你可以向我提出任何挑战，考验我的勇气和决心。", "g: 多么迷人啊！很好....我问你一个问题！"], multiple=True)
    add_dialogue("free_girlfriend right", ("prude"), ["g: 诚实回答！游戏就是这样玩的吗？", "mc: 完全正确。我们每个人都来来回回，谁不能表现出{i}诚实和勇气{/i}，谁就会被宣布为不光彩的失败者。轮到我了！", "g: *咯咯笑*那就继续吧。", "mc: 我会挑战你....赤手空拳地面对我。", "g: *翻白眼*你想让我脱衣服，是吗？控制。我不会因为某些游戏而贬低自己。", "mc: 你没有勇气吗？！", "g: 这和勇气无关。也许一旦我们订婚了，这种不雅行为就很少被允许了。", "mc: 啊哈！这是一个{i}反击挑战{/i}吗？我接受并在此发誓嫁给你！", "g: 你不应该拿这种事开玩笑。我是认真的。", "mc: 我也是！你还缺乏{i}勇气{/i}吗？！让你和你的家蒙羞！", "g: 不、不，这与我的勇气无关。你居然敢质疑我的荣誉！", "mc: 要么证明你的勇气，要么接受你的耻辱！", "g: *抱怨*好吧！我会向你展示我的勇气。我会让你信守嫁给我的誓言。"], multiple=True, love=5)
    add_dialogue("free_girlfriend give_up", ("prude"), ["g: 呃，我以为这很简单！我简直不敢相信这一点。" , "她深深地叹了口气。", "g: 别介意你的这个游戏。我不想再玩了。"], multiple=True, love=-5)
    add_dialogue("free_girlfriend wrong", ("prude"), ["g: 呃，我以为这很简单！我简直不敢相信这一点。" , "她深深地叹了口气。", "g: 别介意你的这个游戏。我不想再玩了。"], multiple=True, love=-10)
    add_dialogue("free_girlfriend success", ("prude"), ["她笨手笨脚地把衣服一层一层地脱掉。", "g: 很享受这个表演，是吗？变态！", "[girl.name] 显然非常不舒服并且没有表现出太多的自信。", "mc: 你应该感到自豪，[girl.name]。你所做的事情是一种荣幸。", "她看起来很困惑。", "g: 我、我真的不明白。我现在要穿上衣服了。"], multiple=True)
    add_dialogue("free_girlfriend success naked", ("prude"), ["她笨手笨脚地把衣服一层一层地脱掉。", "g: 很享受这个表演，是吗？变态！", "[girl.name] 实际上看起来很舒服。她看起来一点也不紧张。", "mc: 你应该感到自豪，[girl.name]。你所做的事情是一种荣幸。", "她看起来很困惑。", "g: 我、我真的不明白。我现在要穿上衣服了。"], multiple=True)

    add_dialogue("free_job_request", ("prude"), ["g: [MC.name]，我们可以谈谈吗？有一点问题。", "mc: 这是什么，[girl.name]？", "她脸红得很厉害。", "g: 是关于我的房东的....他今天早上被捕了。他们说他试图与牧师的妻子私奔！", "g: 噢，我该怎么办！", "mc: 这不像你，[girl.name]。你肯定不会因为一些流言蜚语而如此激动吧？", "g: 不、不，不仅如此。他的所有财产都被没收，包括我的房子。他们把我踢到街上了！", "mc: 哦，原来如此。别担心，[girl.name]。我确信我们会找到解决问题的方法。"], multiple=True)

    add_dialogue("accept farm", ("prude", "very modest"), ("我可以利用一些时间休息。远离这一切污秽....", "我当然不会错过我们的客户。", "哦，我会喜欢的。终于呼吸到新鲜空气了！", "谢谢主人。我期待着离开青楼一段时间。"))
    add_dialogue("accept farm fear", ("prude", "very modest"), ["她看起来心烦意乱。她的眼里涌出泪水。", "g:  农场？这不可能发生...", "g: 这只是一个噩梦，不是吗？只是个梦。", "她的脸上浮现出一丝苦笑。她已经完全崩溃了，没有任何反抗。"], multiple=True)
    add_dialogue("refuse farm", ("prude", "very modest"), ("别荒唐了！这可不是开玩笑的事！", "你很清楚我不属于猪圈。你为什么不自己去那里呢！"))
    add_dialogue("gizel take girl to farm", ("prude", "very modest", "very materialist"), ("快点。是时候放个小假了，你这个可怜的奴隶荡妇。"))

    add_dialogue("girl introduction", ("prude", "very modest"), ("名字是[girl.fullname]。很高兴认识您。"))
    add_dialogue("slave thanks", ("prude", "very modest"), ("你有我的感激之情。", "我欠你的情。", "祝福你！", "我对此非常感激。", "我真的很感激。"))
    add_dialogue("slave effusive thanks", ("prude", "very modest"), ("我的天啊！言语无法形容这让我多么高兴。", "太阳神值得称赞！我不值得这样的善意。", "祝福你！我爱你无以言表！", "哦，哇！我对此非常感激！", "祝福你！我真的很感激！"))
    add_dialogue("slave positive reaction", ("prude", "very modest"), ("一份奖励？什么情况？", "噢，真是一个惊喜！我凭什么得到这份快乐？", "我做了什么才能得到这样的善意？", "天啊！这有什么特别的原因吗？"))
    add_dialogue("slave negative reaction", ("prude", "very modest"), ("我在某些方面让你失望了吗？", "有什么特别的原因让你对我如此不愉快吗？", "您只是心情不好还是需要吸取教训？", "至少可以告诉我是什么让你生气吗？"))
    add_dialogue("slave whining", ("prude"), ("这是闻所未闻的！", "我想和希露通话。", "这是不可接受的！我想提出正式投诉。", "这太荒谬了！", "你这个无赖！", "你怎么敢！"))
    add_dialogue("slave strongly refuse", ("prude", "very modest"), ("不！我不同意！", "把你肮脏的爪子从我身上拿开！", "别这样了，你这头猪！", "不就是不！退后！"), sound=s_screams)
    add_dialogue("slave bullied", ("prude", "very modest"), ("你真是太刻薄了。", "我不喜欢被这样对待！", "你怎么敢！", "呸！你这头猪..."))
    add_dialogue("slave apology", ("prude", "very modest"), ("抱歉，主人。", "这样的事不会再发生了，主人。", "我已经尽力了，Master。", "*呜咽*我不习惯这个，主人。"))
    add_dialogue("slave hit", ("prude", "very modest"), ("啊啊！那真的很痛！", "*喘气*你怎么敢！", "哇！没必要这么暴力！"))
    add_dialogue("slave positive fixation accept", ("prude", "very modest"), ("*脸红*你太脏了。", "*脸红*我不能否认这是一个令人兴奋的提议。", "*脸红*我知道这是错的，但我无法抗拒。", "*脸红*我不敢相信你把我变成了一个{i}变态{/i}。"))
    add_dialogue("slave negative fixation accept", ("prude", "very modest"), ("*喘气*这是答错了！", "呃！这绝对是令人反感的！", "*抽泣*我不敢相信你让我这么做。", "呃！！我想我要生病了！"))
    add_dialogue("slave negative fixation refuse", ("prude", "very modest"), ("不，绝对不！这就是我划清界限的地方。", "这是不道德的！我拒绝！", "这绝对是令人反感的。我永不！"))

    add_dialogue("slave first visit", ("prude", "very extravert"), ("你！你要对我做什么？"))
    add_dialogue("MC kind promise", ("prude", "very modest"), ["她给你一个淡淡的微笑。", "g: 谢谢。"], multiple=True, love=3, fear=-3)
    add_dialogue("MC fair promise", ("prude", "very modest"), ["她看上去很不自在。", "g: 哦不....这、这是青楼，不是吗？", "mc: 确实是这样。欢迎来到[brothel.name]。", "当你分享一些[brothel.name]的历史时，她的脸色变得苍白。"], multiple=True, fear=-1)
    add_dialogue("MC no promise", ("prude", "very modest"), ["她看起来病了。", "g: 不不不....这、这不可能发生。", "在没有任何警告的情况下，她吐到了卧室的地板上。", "mc: *叹气*在我回来之前把它清理干净。"], multiple=True, fear=1)
    add_dialogue("MC harsh promise", ("prude", "very modest"), ["她看起来非常害怕。", "当她盘起双腿蹲下时，她的眼里涌出泪水。看来这个女孩已经生自己的气了。", "mc: *叹气*把自己清理干净，你这个肮脏的荡妇。"], multiple=True, love=-4, fear=3)
    add_dialogue("MC break promise", ("prude", "very modest"), ("我就知道！你这个骗子！你没有尊严吗？"), love=-7, fear=1)
    add_dialogue("MC fight intro", ("prude", "very materialist"), ["g: 从来没有！我宁愿死！", "她拼命想与你抗争，但她绝对不是你的对手。"], multiple=True, sound=s_scream_loud)
    add_dialogue("slave fear intro", ("prude", "very modest"), ["她看上去很害怕，双手抱住头。", "g: 太阳神是世界之光。凡跟从他的人，就不在黑暗里行走。让我们抛弃黑暗的行为，穿上光明的军装。阿门。", "她似乎处于某种惊慌的恍惚状态，背诵着宗教经文。她没有能力回答你的问题。"], multiple=True)
    add_dialogue("slave fear reassure success", ("prude", "very modest"), ["她突然进行眼神交流。", "g: 哦，对不起....我心情不好。"], multiple=True, fear=-2)
    add_dialogue("slave fear reassure failure", ("prude", "very modest", "very materialist"), ["她捂住耳朵，仍然没有反应。", "你决定暂时让她一个人呆着。"], multiple=True, fear=-1)
    add_dialogue("slave fear discipline", ("prude", "very modest"), ["她大声叫喊，蜷缩到角落里。", "她看上去完全惊恐万状，根本无法说话。"], multiple=True, fear=1)

    add_dialogue("slave naked request permanent", ("prude", "very modest"), ["mc: 而且，这不就是Arios最终对你的期望吗？", "g: 你、你什么意思？！当然不是。真是丢人啊！", "mc: 你自称走在光明中，却执意要将自己的身体笼罩在黑暗之中？ {i}这{/i}是可耻的。", "mc: 为真实的自己感到自豪。只有罪人才会有隐藏羞耻的冲动。", "g: 哇哦....如果这就是亚里欧斯想要的。"], multiple=True, love=-1, fear=2, sound=s_sigh)
    add_dialogue("slave naked request accept", ("prude", "very modest"), ["g: 不！我不能同意这一点。真是逆天啊！", "mc: 废话！乖僻是一种精神状态，而不是身体状态。", "mc: 你为什么反对裸体？是不是你心里暗藏着罪恶的思想呢？", "g: 当然不是！我从来没有！", "mc: 那么你的心应该没有烦恼。你完全没有理由感到羞耻。这只是你被带到这个世界的方式，仅此而已。", "g: 噢....你说的确实有道理。"], multiple=True, sound=s_ahaa)
    add_dialogue("slave naked request resist", ("prude", "very modest"), ("绝对不！别开玩笑了！"), love=-2, fear=-3)
    add_dialogue("slave toggle naked on", ("prude", "very modest"), ["mc: 当然，只要你不感到有罪和羞耻。", "g: 嗯...我不觉得羞耻。我为什么要？我的心是纯洁的！"], multiple=True, love=-1)
    add_dialogue("slave toggle naked off", ("prude", "very modest"), ("谢天谢地。我一直受到各种肮脏的目光。"), love=1)
    add_dialogue("slave train beg", ("prude", "very modest"), ["[girl.name]挺直背部并表明立场。", "g: 你、你怎么敢提出这么卑鄙的事！这当然不是我应该参与的事情。", "g: 你没看出这是答错了吗？"], multiple=True)
    add_dialogue("slave discipline beg", ("prude", "very modest", "very materialist"), ["[girl.name]看起来很挑衅。", "g: 什、什么？！别胡说八道了。我承认我可能犯了错误，但这种惩罚与罪名不符。"], multiple=True)
    add_dialogue("slave beg proceed", ("prude", "very modest"), ("不！主人，这不对啊！"), love=-1, fear=1)
    add_dialogue("slave beg warning", ("prude", "very modest"), ("我很高兴我们能像文明人一样用语言解决这个问题。"), fear=1, sound=s_sigh)
    add_dialogue("slave beg give up", ("prude", "very modest"), ("感谢诸天。我很高兴你醒悟过来了。"), love=1, fear=-2, sound=s_surprise)
    add_dialogue("slave send to master bedroom love +", ("prude", "very modest"), ["[girl.name]脸红了。", "g: 哦，我们要睡一张床吗？现在不要有任何肮脏的想法，[MC.name]。 *傻笑*"], multiple=True)
    add_dialogue("slave send to master bedroom love", ("prude", "very modest"), ["[girl.name]看起来松了口气。", "g: 我认为那是最好的。", "g: 有时你很难控制自己的原始冲动。我希望我能对你产生良好的影响。"], multiple=True)
    add_dialogue("slave send to master bedroom love -", ("prude", "very modest"), ["[girl.name] 看起来对这个想法很反感。", "g: 我有点不喜欢这个主意。如果我戴贞操带你会反对吗？"], multiple=True)
    add_dialogue("slave send to master bedroom fear +", ("prude", "very modest"), ["[girl.name]看起来非常震惊。她低声念叨着简短的祈祷。", "g: （太阳神，请保护我的灵魂免受黑暗的腐蚀。愿你的敌人连同他们的家园和壁炉一起燃烧。）"], multiple=True)
    add_dialogue("slave send to master bedroom fear", ("prude", "very modest"), ["[girl.name] 似乎有点困惑。", "g: 我不介意占用你的房间，但是那你把头放在哪里呢？也许在我以前的卧室里？"], multiple=True)
    add_dialogue("slave send to master bedroom fear -", ("prude", "very modest"), ["[girl.name]看起来非常震惊。她低声念叨着简短的祈祷。", "g: （太阳神，请保护我的灵魂免受黑暗的腐蚀。愿你的敌人连同他们的家园和壁炉一起燃烧。）"], multiple=True)
    add_dialogue("slave leave master bedroom love +", ("prude", "very modest"), ["g: 我很高兴你终于明白了我一直想告诉你的事情。", "g: 我们应该先安排我们的婚姻。一切都结束后，共享一间卧室就变得合适了。"], multiple=True)
    add_dialogue("slave leave master bedroom love", ("prude", "very modest"), ("那最好了。这确实在婚姻之外没有立足之地。"))
    add_dialogue("slave leave master bedroom love -", ("prude", "very modest"), ("终于得救了！我已经经受了彻底的考验，但诱惑对我毫无吸引力。"))
    add_dialogue("slave leave master bedroom fear +", ("prude", "very modest"), ("终于得救了！我已经经受了彻底的考验，但诱惑对我毫无吸引力。"), multiple=True)
    add_dialogue("slave leave master bedroom fear", ("prude", "very modest"), ("阿里奥受到赞扬...我只是想让你知道我正在为你祈祷。"))
    add_dialogue("slave leave master bedroom fear -", ("prude", "very modest"), ("谢天谢地。这确实在婚姻之外没有立足之地。"))

    add_dialogue("slave chat slave_life -2", ("prude", "very modest"), ["她看起来很生气。","g: 我要求你立即解除我这份敲诈勒索的合约！我不属于这里。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life -1", ("prude", "very modest"), ["她看起来很愤怒。","g: 这是什么问题？正如你可以想象的那样，这并不完全是一个童话故事。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0", ("prude", "very modest"), ("我的想法重要吗？这是我必须接受的事实。"), unlock="DS")
    add_dialogue("slave chat slave_life 0.5", ("prude", "very modest"), ["她耸耸肩。","g: 如果这是亚里欧斯为我选择的道路，那么我就必须接受它。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 1", ("prude", "very modest"), ["她虚弱地笑了笑。","g: 正如经文所说：{i}让所有奴隶都尊重他们的主人，以免阿里乌斯的名字受到辱骂{/i}。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 2", ("prude", "very modest"), ["她傲慢地笑。","g: 我不是奴隶。真正的奴隶是那些无法控制自己卑鄙性欲的动物。"], multiple=True, unlock="DS")
    add_dialogue("slave chat brothel -2", ("prude", "very modest"), ["她给你一个轻蔑的眼神。","g: 这个地方就像一座专门供奉不道德行为的寺庙。言语无法描述我的厌恶之深。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel -1", ("prude", "very modest"), ["她给你一个轻蔑的眼神。","g: 这里到底怎么可能有人安宁呢？这个地方就像一座专门供奉不道德行为的令人反感的寺庙。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0", ("prude", "very modest"), ["她看起来焦躁不安。","g: 有时候我觉得我可以习惯这里的生活。那些时刻让我充满羞愧和悔恨。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0.5", ("prude", "very modest"), ["她看起来很担心。","g: 我必须悔改。我感到非常羞愧，竟然把这样一个可耻的地方称为我的家。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel virgin", ("prude", "very modest"), ["她给你一个轻蔑的眼神。","g: 这里到底怎么可能有人安宁呢？这个地方就像一座专门供奉不道德行为的令人反感的寺庙。", "g: 这让我担心最坏的情况。我的尊严会在这种地方被剥夺吗？"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 1", ("prude", "very modest"), ["她看起来很担心。","g: 我对此感到非常内疚，但我已经习惯了生活在这个罪恶之家。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 2", ("prude", "very modest"), ["g: 我不想考虑太多。这让我头晕。", "g: 这是我的家。这才是最重要的。"], multiple=True, unlock="LM")
    add_dialogue("slave chat customers -2", ("prude", "very modest"), ["她似乎对这个想法感到生气。", "g: 你疯了吗？！我无法忍受靠近那些堕落的小家伙！"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers -1", ("prude", "very modest"), ("那永远不会发生！让那些堕落者远离我。"), unlock="MI")
    add_dialogue("slave chat customers 0", ("prude", "very modest"), ("绝对不！我彻夜难眠，担心如果我让这些不道德的野蛮人进入我的内心，我会发生什么。"), unlock="MI")
    add_dialogue("slave chat customers 0.5", ("prude", "very modest"), ("他们、他们是一群变态。我不能让自己被他们这样的人迷住！"), unlock="MI")
    add_dialogue("slave chat customers 1", ("prude", "very modest"), ["g: 我不赞成他们的行为，但我必须承认他们中的大多数人只是被误解了。", "g: 我希望我能以某种方式为他们的康复做出贡献。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 2", ("prude", "very modest"), ["g: 虽然他们的行为应该受到谴责，但我相信我可以对他们产生良好的影响。", "g: 我希望我能激励他们改善生活。"], multiple=True, unlock="MI")
    add_dialogue("slave chat other_girls -2", ("prude", "very modest"), ("很抱歉让你失望了，但我对和这些荡妇交好没兴趣。"), unlock="EI")
    add_dialogue("slave chat other_girls -1", ("prude", "very modest"), ("我尽量忽略它们。我自己的问题已经够多了。"), unlock="EI")
    add_dialogue("slave chat other_girls 0", ("prude", "very modest"), ("我尽量忽略它们。我自己的问题已经够多了。"), unlock="EI")
    add_dialogue("slave chat other_girls 0.5", ("prude", "very modest"), ["g: 哼！他们肯定在你的变态方面受过良好的训练。", "g: 嘿，把你脸上的坏笑擦掉吧！这并不是一种恭维！"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 1", ("prude", "very modest"), ("我想很高兴知道我并不孤单。每当我觉得有点难以承受时，我都可以和他们交谈。"), unlock="EI")
    add_dialogue("slave chat other_girls 2", ("prude", "very modest"), ("每当他们如此随意地提出禁忌话题时，我确实感到困扰，但我已经有点喜欢他们了。"), unlock="EI")
    add_dialogue("MC praise friend", ("prude", "very modest"), ("她的本意是好的。我已经为她祈祷有一段时间了。"), sound=s_laugh)
    add_dialogue("MC demean rival", ("prude", "very modest"), ("我不会使用这些确切的词，但我同意这种观点。"), sound=s_evil_laugh)
    add_dialogue("slave chat well_being -3", ("prude", "very modest"), ("别迟钝了！我祈祷太阳神能够迅速将我从这里所遭受的恐惧中释放出来。"), multiple=True, unlock="MI")
    add_dialogue("slave chat well_being -2", ("prude", "very modest"), ["g: 一点也不！！我日日夜夜都感到恶心。", "g: 我担心我永远无法从脑海中抹去我在这里看到的恐怖。"], unlock="MI")
    add_dialogue("slave chat well_being -1", ("prude", "very modest"), ("别迟钝了！我祈祷太阳神能够迅速将我从这里所遭受的恐惧中释放出来。"), multiple=True, unlock="MI")
    add_dialogue("slave chat well_being 0", ("prude", "very modest"), ("住在青楼怎么能安心呢？我不明白这怎么可能。"), unlock="MI")
    add_dialogue("slave chat well_being 1", ("prude", "very modest"), ["g: 工作时间这里发生的事情真的让我很烦恼。", "g: 我想我永远不会习惯这一点。"], multiple=True, unlock="MI")
    add_dialogue("slave chat well_being 2", ("prude", "very modest"), ("工作时间这里发生的事情仍然困扰着我，但我很高兴能在你身边。"), unlock="MI")
    add_dialogue("slave chat well_being 3", ("prude", "very modest"), ["g: 并不是说我接受这里发生的事情，但我确实理解为什么Arios引导我来到这里。", "g: 我衷心希望我能够对参观这个机构的被误导的灵魂产生良好的影响。"], multiple=True, unlock="MI")
    add_dialogue("slave chat well_being attacked", ("prude", "very modest"), ["g: 我已经受够了这些渣男想要攻击我了。", "g: 看在太阳神的份上，请给我一把好武器，这样我就可以结束他们的痛苦。"], multiple=True)
    add_dialogue("slave chat well_being sick", ("prude", "very modest"), ["g: 我感到虚弱和不适。", "g: 我一直在想，这是否是因为我所遭受的污垢、食物或不道德的污水坑。", "g: 我想说这可能是所有这些因素的结合。"], multiple=True)
    add_dialogue("slave chat well_being exhausted", ("prude", "very modest"), ("我感觉我随时都会倒下。你让我远远超出了我的身体和灵魂所能承受的范围。"))
    add_dialogue("slave chat well_being MC apology", ("prude", "very materialist"), ("我不需要借口！我想要更好的条件....唉...."))
    add_dialogue("slave chat feelings love -1", ("prude", "very modest"), ("你生活在罪中。我可怜你。"), unlock="DS")
    add_dialogue("slave chat feelings love 0", ("prude", "very modest"), ("我不喜欢你对无聊的追求如此痴迷。"), unlock="DS")
    add_dialogue("slave chat feelings love 1", ("prude", "very modest"), ("我真的很关心你、担心你。这就是为什么我每晚都为你祈祷。"), unlock="DS")
    add_dialogue("slave chat feelings love 2", ("prude", "very modest"), ("你有根本性的缺陷，但仍有时间悔改并改善自己。"), unlock="DS")
    add_dialogue("slave chat feelings fear -1", ("prude", "very modest"), ("你有根本性的缺陷，但仍有时间悔改并改善自己。"), unlock="DS")
    add_dialogue("slave chat feelings fear 0", ("prude", "very modest"), ("你可以很不讲道理。你常常要求我做我不赞成的事情。"), unlock="DS")
    add_dialogue("slave chat feelings fear 1", ("prude", "very modest"), ("我害怕你接下来会让我遭受什么恐怖。"), unlock="DS")
    add_dialogue("slave chat feelings fear 2", ("prude", "very modest"), ("我只侍奉一位明师。阿里奥是他的名字。"), unlock="DS")
    add_dialogue("slave chat feelings very disobedient", ("prude", "very modest"), ("我只侍奉一位明师。阿里奥是他的名字。"), unlock="DS")
    add_dialogue("slave chat feelings disobedient", ("prude", "very modest"), ("我拒绝接受像你这样堕落的人的命令。"), unlock="DS")
    add_dialogue("slave chat feelings a little obedient", ("prude", "very modest", "very materialist"), ("你没有做任何事来赢得我的尊重。"), unlock="DS")
    add_dialogue("slave chat feelings obedient", ("prude", "very modest"), ("虽然我很关心你，但我想明确表示，我不赞成你这种变态的生活方式。"), unlock="DS")
    add_dialogue("slave chat feelings very obedient", ("prude", "very modest"), ["g: 我担心如果没有我在你身边，你会偏离道路多远。", "g: 这就是为什么我尽管心存疑虑，还是倾向于听从你的命令。"], multiple=True, unlock="DS")
    add_dialogue("slave chat tastes likes", ("prude", "repressed", "holy", "loyal", "pet"), "我最喜欢的[thing_cn]？我承认我确实时不时地享受[best]。", unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("prude", "holy", "very modest"), ("嗯....我很抱歉，但是....我不能说我曾经认真考虑过这件事。我想[worst]并不是我最喜欢的[thing_cn]。", "我的朋友们在谈论[thing_cn]时变得非常兴奋。他们说[worst]是Arios的祝福，但我完全不同意！"), unlock="LM")
    add_dialogue("slave chat tastes loves +", ("prude", "very modest"), ("还有什么比与亲人分享[thing_cn]更有益健康的事情吗？"), unlock="LM")
    add_dialogue("slave chat tastes loves -", ("prude", "very modest", "very materialist"), ("你喜欢[thing_cn]吗？它总是让我振作起来。"), unlock="LM")
    add_dialogue("slave chat tastes no loves", ("prude", "very modest"), ("我不喜欢人们沉迷于物质。重要的是你内心的想法。"), unlock="LM")
    add_dialogue("slave chat tastes hates", ("prude", "very modest", "very materialist"), ("我不知道那是什么，但我无法忍受[thing_cn]。"), unlock="LM")
    add_dialogue("slave chat tastes no hates", ("prude", "very modest"), ("当人们无法欣赏一份真心的礼物时，你不讨厌吗？"), unlock="LM")
    add_dialogue("slave chat tastes positive act", ("prude", "very modest"), ("我注意到我对 [act_desc] 感兴趣...你认为这是答错了吗？"), unlock="LM")
    add_dialogue("slave chat tastes negative act", ("prude", "very modest"), ("你知道，[act_desc] 让我非常不舒服......我认为它很脏。"), unlock="LM")
    add_dialogue("slave chat tastes no negative act", ("prude", "very modest"), ("不言而喻，性轻浮是一种可耻的追求，但我不认为任何一种性行为比其他性行为更糟糕......"), unlock="LM")

    add_dialogue("slave chat origins 1", ("prude", "class president", "holy", "princess"), ("我的婴儿床位于 [girl.origin] 的一个古色古香的小角落。"), unlock="EI")
    add_dialogue("slave chat origins 2", ("prude", "very modest"), ("我是由我的[girl.story_guardian]抚养长大的。我们在[girl.origin]有一个可爱的[a_home]。"), unlock="EI")
    add_dialogue("slave chat origins 3", ("prude", "very modest"), ("啊，我很向往在我们的[girl.story_home]里和我的[girl.story_guardian]一起度过的平静日子。"), unlock="EI")
    add_dialogue("slave train accepted", ("prude", "very modest"), ("我不同意这种做法，但我会遵守规定。", "我不敢相信你让我这么做。", "哦不...这是非常答错了，但我会按照你的要求去做。", "这绝对是可悲的，但我会忍受它。"))
    add_dialogue("slave train resisted", ("prude", "very modest"), ("你不能让我这么做。这是不对的！", "不，请不要让我这么做。那太丢人了！", "这太令人反感了！你怎么能问我这个？", "我恳求您重新考虑一下，主人。我不同意这一点。"))
    add_dialogue("slave train refused", ("prude", "very modest"), ("绝对不！这太令人反感了！", "你怎么敢！我永远不会做那样的事情。", "别荒唐了。让你的思想走出阴沟！", "不！！我绝对不会把自己降得那么低！"))
    add_dialogue("slave lecture love", ("prude", "very modest"), ("我确实很喜欢和你在一起，但我们必须总是谈论这些不正当的话题吗？"))
    add_dialogue("slave lecture neutral", ("prude", "very modest"), ("*叹气*我们不能谈谈别的事情吗？你让我不舒服。"))
    add_dialogue("slave lecture fear", ("prude", "very modest"), ("*叹气*继续吧，主人。"))
    add_dialogue("slave lecture refuses", ("prude", "very modest"), ("啊，不，不可能！！！这只是针对变态和病人的！"))
    add_dialogue("slave lecture very reluctant", ("prude", "very modest"), ("拜托，光是听到这件事就让我感到不舒服...."))
    add_dialogue("slave lecture reluctant", ("prude", "very modest"), ("我-它...这不适合像我这样的女孩！我对此不感兴趣！ *脸红*"))
    add_dialogue("slave lecture a little reluctant", ("prude", "very modest"), ("我宁愿不这样做....这有点顽皮...."), sound=s_sigh)
    add_dialogue("slave lecture indifferent", ("prude", "very modest"), ("嗯...我想这是我工作的一部分..."))
    add_dialogue("slave lecture a little interested", ("prude", "very modest"), ("哦这个？嗯...没那么糟糕...我的意思是，它很脏，但是...噢...*脸红*"), sound=s_surprise)
    add_dialogue("slave lecture interested", ("prude", "very modest"), ("我从没想过我会这么说，但 [act_desc] 实际上...有趣？"), sound=s_mmh)
    add_dialogue("slave lecture very interested", ("prude", "very modest"), ("当想到 [act_desc] 时，这让我感觉很奇怪....我感到温暖，而且....嗯...."), sound=s_mmh)
    add_dialogue("slave lecture fascinated", ("prude", "very modest"), ("哦，[act_desc] 感觉真好...你一定认为我是个荡妇但是...我...我想要它..."), sound=s_aah)
    add_dialogue("slave train obedience", ("prude", "very sub"), ("是的主人。"))
    add_dialogue("slave train constitution", ("prude", "very introvert"), ("既然你这么说，主人."))
    add_dialogue("slave train refuses", ("prude", "very modest"), ("她似乎对 [act_desc] 的想法感到厌恶。她给你一个害怕的表情。"), sound=s_screams)
    add_dialogue("slave train very reluctant", ("prude", "very modest"), ("这是可耻的、不道德的。你为什么要让我这样做...", "哦不...这很恶心，很脏...拜托，我们不要..."), sound=s_scream)
    add_dialogue("slave train reluctant", ("prude", "very modest"), ("不，别看我....我感到很羞耻...."), sound=s_scream)
    add_dialogue("slave train a little reluctant", ("prude", "very modest"), ("我真的不想这样做....这是答错了....啊啊！"), sound=s_surprise)
    add_dialogue("slave train indifferent", ("prude", "very modest"), ("哦，[MC.name]主人...你真是个变态...*脸红*"), sound=s_ahaa)
    add_dialogue("slave train a little interested", ("prude", "very modest"), ("嗯嗯，好像已经习惯了....等等，我不是这个意思！ *恐慌*"), sound=s_ahaa)
    add_dialogue("slave train interested", ("prude", "very modest"), ("嗯，[act_desc]...还不错...嗯..."), sound=s_mmh)
    add_dialogue("slave train very interested", ("prude", "very modest"), ("哦，我喜欢这个...我感觉自己像个荡妇...*脸红*"), sound=s_aah)
    add_dialogue("slave train fascinated", ("prude", "very modest"), ("哦主人，[act_desc]感觉真好....我想我已经变成了一个肮脏、肮脏的母狗...."), sound=s_orgasm_fast)
    add_dialogue("slave train naked failure", ("prude", "very modest"), ("拜、拜托别那样盯着看。你让我很紧张。"), sound=s_surprise)
    add_dialogue("slave train naked success", ("prude", "very modest"), ("我从没想过我会这么说，但也许我应该更频繁地裸体....如果你高兴的话。"), sound=s_aah)
    add_dialogue("slave train service failure", ("prude", "very modest"), ("*抽泣*不！这是不道德的。我做不到！"))
    add_dialogue("slave train service success", ("prude", "very modest"), ("主人，你太脏了。我马上用我的嘴把你清理干净。"))
    add_dialogue("slave train sex failure", ("prude", "very modest"), ("*抽泣*请把它拿出来。我根本不应该同意这一点。"))
    add_dialogue("slave train sex success", ("prude", "very modest"), ("嗯....Master真是个变态啊。我敢打赌，如果我允许的话，你可以整天整夜地继续下去。"))
    add_dialogue("slave train anal failure", ("prude", "very modest"), ("啊啊，好痛啊！请住手！"))
    add_dialogue("slave train anal success", ("prude", "very modest"), ("哇，你太脏了[MC.name]。你享受这个吗？"))
    add_dialogue("slave train fetish failure", ("prude", "very modest"), ("不！！帮助！我不同意！"))
    add_dialogue("slave train fetish success", ("prude", "very modest"), ("你真的很喜欢这个，不是吗？肮脏的，肮脏的男孩。"))
    add_dialogue("slave train bisexual failure", ("prude", "very modest"), ("这是不道德的....爱情应该由男人和女人共同分享。"))
    add_dialogue("slave train bisexual success", ("prude", "very modest"), ("希露真是个荡妇....是个肮脏的小贱人，不是主人吗？"), sound=s_mmh)
    add_dialogue("slave train group failure", ("prude", "very modest"), ("这太恶心了！请别打扰我！"))
    add_dialogue("slave train group success", ("prude", "very modest"), ("你们两个真是变态啊。谢天谢地，我来这里是为了满足你的渴望。"))
    add_dialogue("slave magic obedience success", ("prude", "very modest"), ("让罪恶的汁液流出....将它们从我纯洁的灵魂中驱逐出去...."), sound=s_ahaa)
    add_dialogue("slave magic libido success", ("prude", "very modest"), ("让罪恶的汁液流出....将它们从我纯洁的灵魂中驱逐出去...."), sound=s_mmh)
    add_dialogue("slave magic sensitivity success", ("prude", "very modest"), ("我必须传播快乐...传播这个词..."), sound=s_mmh)
    add_dialogue("slave magic naked success", ("prude", "very modest"), ("我没有什么可隐瞒的...没有什么可羞耻的..."), sound=s_ahaa)
    add_dialogue("slave magic service success", ("prude", "very modest"), ("让罪人到我这里来....我会减轻他们的负担...."), sound=s_mmh)
    add_dialogue("slave magic sex success", ("prude", "very modest"), ("让我背起你的十字架...我会为你受苦..."), sound=s_aah)
    add_dialogue("slave magic anal success", ("prude", "very modest"), ("最脏的洞...太阳神不介意..."), sound=s_ahaa)
    add_dialogue("slave magic fetish success", ("prude", "very modest"), ("请继续..."), sound=s_aah)
    add_dialogue("slave magic bisexual success", ("prude", "very modest"), ("我必须与她合而为一...来纠正她..."), sound=s_mmh)
    add_dialogue("slave magic group success", ("prude", "very modest"), ("我会接受所有罪人...我必须帮助他们所有人..."), sound=s_ahaa)
    add_dialogue("slave magic failure", ("prude", "very modest"), ["g: *喘息*你想催眠我，不是吗？我的朋友警告我这可能会发生！", "g: 救命！！离我远点，你这个恶魔！", "她惊慌失措并尽快逃跑。"], multiple=True, sound=s_scream, unlock="DS")

    add_dialogue("slave reward sex accepted", ("very modest"), ("噢，主人。我们就像恋人......噢......*脸红*"), love=-1, sound=s_ahaa, unlock="LM")
    add_dialogue("slave reward sex resisted", ("prude", "very dom"), ("什么？不！！！这是什么奖励啊！！！"), love=-1, sound=s_surprise, unlock="LM")
    add_dialogue("slave reward sex refused", ("prude", "very sub"), ("等等，不！！！我不想..."), sound=s_scream)
    add_dialogue("slave reward praise", ("prude", "very materialist"), ("谢谢，我想...这是否意味着我会得到奖励？"), love=-1, unlock="MI")
    add_dialogue("slave reward gold", ("prude", "very modest"), ("我很感激，主人。我为此付出了努力。"), love=2, unlock="MI")
    add_dialogue("slave reward pet", ("prude", "very modest"), ["你让她在你的腿上坐了一会儿，抚摸她的头发，亲吻她的额头。", "g: 这很好....我们应该经常这样做。"], multiple=True, love=1, unlock="DS")
    add_dialogue("slave reward day off", ("prude", "very modest"), ["g: 我明白了。谢谢你，我想....但说实话，我确实喜欢让自己忙碌起来。当我无事可做时，我往往会感到沮丧。", "g: 你知道，我只是开始思考我的问题和情况......然后我开始感觉越来越糟。"], multiple=True, unlock="DS")
    add_dialogue("slave reward day off KO", ("prude", "very modest"), ("你已经告诉过我了，傻瓜。"))
    add_dialogue("slave punish scold deserved", ("prude", "very modest"), ["她似乎在忏悔和反抗之间矛盾。", "g: 听着....我知道我违背了你的命令。我真的很后悔。", "g: 但是有时候你对我的要求也很无理！"], multiple=True, fear=-1, unlock="MI")
    add_dialogue("slave punish scold undeserved", ("prude", "very modest"), ["她非常挑衅。", "g: 这显然是答错了！你的判断是基于谎言，我不接受！"], multiple=True, love=-1, fear=-1, unlock="MI")
    add_dialogue("slave punish upkeep", ("prude", "very modest"), ("不，这不公平！你不能这么做，对吗？"), fear=1, unlock="MI")
    add_dialogue("slave punish upkeep KO", ("prude", "very modest"), ("你已经告诉过我了，傻瓜。"))
    add_dialogue("slave punish beat", ("prude", "very modest"), ["当你殴打她时，她会低声对自己唱一首宗教赞美诗。", "g: 不要害怕那些...啊！那些残废身体的人。他们可能...啊啊！！他们永远不会削弱灵魂。"], multiple=True, sound=s_screams, unlock="DS")
    add_dialogue("slave punish farm", ("prude", "very modest"), ("多么迷人的提议啊！肯定不会比这个猪圈更糟糕吧？"), unlock="DS")
    add_dialogue("slave punish naked", ("prude", "very modest"), ("不，不是那样。除了那个之外什么都可以！这是不道德的！！ *哭泣*"), fear=2, unlock="LM")
    add_dialogue("slave punish naked KO", ("prude", "very modest"), ("我们已经经历过这一切。你以为今天随意裸体是我自己决定的吗？"))
    add_dialogue("slave punish rape", ("prude", "very modest"), ["她的脸色变得苍白。", "g: 不！你不敢！"], multiple=True, fear=3, unlock="LM")
    add_dialogue("slave raped", ("prude", "very modest"), ["当你随心所欲地对待她时，她会无法控制地尖叫。","g: 啊啊....不！我不同意！","她撕心裂肺的哭声在[brothel.name]的走廊里回响。"], multiple=True, sound=s_screams)
    add_dialogue("slave rape positive fixation", ("prude", "very modest"), ["g: *抽泣*我不敢相信你，[MC.name]...", "g: 这太令人厌恶了。啊啊！！这是不对的！"], multiple=True, love=1, sound=s_aah)
    add_dialogue("slave rape negative fixation", ("prude", "very modest"), ["g: *呜咽*你做了什么，[MC.name]...", "她看起来非常害怕并恳求你怜悯。", "g: 这不可能发生...请停止它，[MC.name]！"], multiple=True, love=-3, fear=5, sound=s_scream_loud)

    add_dialogue("rest", ("prude", "very modest", "very materialist"), ("那个我能接受。如果您改变主意，您知道在哪里可以找到我。{w=1.0}{nw}"))
    add_dialogue("accept job", ("prude", "very modest", "very materialist"), ("我明白了，[MC.name]。我会以{b}[girl.job_cn]{/b}的身份帮助青楼。{w=1.0}{nw}"))
    add_dialogue("work_whore", ("prude", "very modest"), ["g: 哦[MC.name]，多么不正当的要求啊！很好，我会这么做的。{w=1.5}{nw}", "g: 我会一边做{b}[girl.job_cn]{/b}一边通奸。{w=1.5}{nw}"], multiple=True)
    add_dialogue("exhausted", ("prude", "very modest", "very materialist"), ("对不起，[MC.name]。我绝对被击败了。我会尽快恢复作为{b}[girl.job_cn]{/b}的职责。"))
    add_dialogue("rank up", ("prude", "very modest", "very materialist"), ("万岁！香槟在哪里？我现在正式成为一名[newrank]奴隶。"))
    add_dialogue("refuse whoring", ("prude"), ("绝对不！你怎么敢提出这样的建议！"))
    add_dialogue("refuse sex act", ("prude", "very modest"), ("绝对不！这太令人反感了！", "你怎么敢！我永远不会做那样的事情。", "别荒唐了。让你的思想走出阴沟！", "不！！我绝对不会把自己降得那么低！"))

    add_dialogue("bought", ("prude", "very modest"), ["g: 名字是[girl.fullname]。很高兴认识您，先生。", "她向你深深鞠了一躬。从她的举止来看，她可能曾担任过贵族的女仆。"], multiple=True)
    add_dialogue("freed", ("prude", "very modest"), ("这是为了最好的。我一直很难接受住在青楼的生活。告别！"))
    add_dialogue("sold", ("prude", "very modest"), ["g: 这是最好的。我一直很难接受住在青楼的生活。", "g: 我希望我的下一个工作地点有一个更高尚的目标。告别！"], multiple=True)
    add_dialogue("sold love", ("prude", "very modest"), ["g: *嗅一嗅*我真的会想念你，主人....但也许这是最好的。", "g: 我一直很难接受住在青楼的生活。", "g: 我希望我的下一个工作地点有一个更高尚的目标。你将永远在我心中占有特殊的位置！"], multiple=True, sound=s_surprise)
    add_dialogue("leave for quest", ("prude", "very modest"), ("我会看看我能做什么，主人。答应我在我不在的时候要好好表现！"))
    add_dialogue("leave for class", ("prude", "very modest"), ("如果这是你的愿望，我会尽力的。我不在的时候请尽量表现得规矩点。"))
    add_dialogue("advertise", ("prude", "repressed", "holy"), ("请记住，通奸是一种罪过！欲了解更多信息，请访问 [brothel.name]！", "警告你的丈夫注意[brothel.name]，这是一座邪恶的不道德寺庙！", "快来亲自看看，[brothel.name] 是泽恩猖獗的性轻浮的完美例子。", "泽恩的家庭主妇们，警告你们的丈夫注意那个名为[brothel.name]的罪恶宫殿！"))

    add_dialogue("beach intro", ("prude", "very modest"), ["你很惊讶地看到一张熟悉的面孔。 [girl.fullname] 躲在临时挡风板后面，正在沐浴阳光。"], multiple=True)
    add_dialogue("beach meet MC", ("prude", "very modest"), ["g: *脸红*主人！我没想到会在这里见到你。", "她尴尬地试图用毛巾盖住自己。", "g: 我希望我知道你正计划沿着海滩漫步。我会穿得朴素一点。"], multiple=True)
    add_dialogue("beach oiling", ("prude", "very modest"), ("我很感谢主人的帮助。这是非常放松的。"), sound=s_ahaa)
    add_dialogue("beach accept oiling", ("prude", "very modest"), ["g: 我不敢相信你会这么做！你真是个变态。", "g: 好吧，那就继续吧！我知道你无法控制那些卑鄙的冲动，所以让我们结束这一切吧。"], multiple=True)
    add_dialogue("beach refuse oiling", ("prude", "very modest"), ("嘿！这是不可接受的！你怎么敢！"))
    add_dialogue("beach accept public sex", ("prude", "very modest"), ("*叹气*你真是一个无可救药的堕落者。快点吧，好吗？"), multiple=True)
    add_dialogue("beach refuse public sex", ("prude", "very modest"), ["g: 这绝对应该受到谴责！别开玩笑了！", "她用即兴的祈祷来反驳你的建议。", "g: 亲爱的Arios，请原谅[MC.name]并治愈他扭曲的心灵。阿门。"], multiple=True)
    add_dialogue("beach accept sex", ("prude", "very modest"), ("*叹气*你真是一个无可救药的堕落者。快点吧，好吗？"))
    add_dialogue("beach refuse sex", ("prude", "very modest"), ("绝对不！离我远点，你这个变态！"))
    add_dialogue("beach whoring request", ("prude", "very modest"), ["她厌恶地看着你。", "g: *叹息*你的不道德行为是无止境的，[MC.name]。"], multiple=True)
    add_dialogue("beach whoring accept", ("prude", "very modest"), ["她深深地叹了口气" ,"g: 经文说奴隶必须服务和服从....但你应该知道我不赞成这样做。"], multiple=True)
    add_dialogue("beach whoring refuse", ("prude", "very modest"), ("你怎么敢提出这样的建议！滚出我的视线！"))

## START PRINCESS DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("princess", "schemer"), ("至少有一个男人懂得如何对待女人！我的名字是 [girl.fullname]，目前我不需要任何东西。"), love=2)
    add_dialogue("free_greetings_casual", ("princess"), ("你真是太普通了。我是[girl.fullname]。我为什么要授予你与我交谈的特权？", "多么粗俗啊。你是在谷仓长大的吗？我是[girl.fullname]。", "你真是太普通了。你可能是被养猪人养大的——作为猪中的一员吗？我的名字是[girl.fullname]。" ))
    add_dialogue("free_greetings_rude", ("princess"), ("你们就是这样跟女士打招呼的吗？不过你很有趣。人们通常不会这样对我说话！我是[girl.fullname]。", "你虽然不是很文雅，但我却觉得你很有趣。我的名字是[girl.fullname]。", "你知道你在和谁说话吗？如果你这样做了，你就不会那么粗鲁了。不过，我还是觉得你很有趣。我是[girl.fullname]。"), love=1)

    add_dialogue("free_small_talk", ("princess"), ("这听起来像是普通的 [MC.playerclass] 会做出的那种平淡的观察。我很期待像你这样的乌合之众会这么做。", "多么无聊和粗俗。我们为什么不谈论一些有趣的事情，比如如果您被邀请去法庭，您会穿什么！"), max_cap=25)
    add_dialogue("free_gossip", ("princess", "superficial"), ("在世界上最大、最繁荣的城市里，总有一些事情发生。", "玉城里有上流社会，也有下流社会....流言蜚语也不少。", "这是一个繁华的大都市，有许多令人兴奋的事情正在发生。"), love=2, max_cap=25)
    add_dialogue("free_chat_life", ("princess"), ("这些都是大事。我不太关心他们。", "宇宙？你是说我们生活的世界吗？它很大，充满了许多可爱和令人愉快的东西，比如花朵和松鼠....还有鸟类和蜜蜂。但也有乞丐、农民等令人沮丧的丑陋事物。我希望我不必每天见到他们。", "这些都是一些大问题。我没有那么多生活经验。只有我在与我的[girl.story_guardian]一起长大时学到的东西，他给了我良好的教养。"), max_cap=25)
    add_dialogue("free_chat_love", ("princess"), ["g: 当然，我正在等待我的穿着闪亮盔甲的骑士....从我还是个小女孩的时候起，我就一直在想象我想要的他是什么样子。", "g: 他一定很高，像你一样，但是更高....比其他男人高出一个头和肩膀。", "g: 他必须有很好的幽默感，但不能白笑。", "g: 他的笑话一定要有趣，不能是无聊和无害的，因为我不喜欢那些。", "g: 他应该像牛一样强壮，但不能为了生活而工作，因为工作是为粗鲁的农民和仆人服务的。", "g: 他一定很帅，很有魅力，可以迷倒任何女孩。", "g: 但完全献身于我，他的爱人。", "g: 他一定出身名门，有关系。自信，但不自满，勇敢，勇敢，侠义，善良，儒雅，潇洒，雄心勃勃，感性，多才多艺，超越年龄的智慧，忠诚....", "g: 这些只是我希望我的闪亮盔甲骑士能够成为的一部分。你认为对于一个女孩来说这个要求太过分了吗？", "mc: ....呃....这是一个很长的清单。我怀疑所有Xeros中是否有一个人能够满足所有这些要求！", "g: *她看起来很生气* 嗯嗯....也许你是对的。也许感性并不是那么重要。我可以把那个排除在外。"], multiple=True, love=2, max_cap=25)
    add_dialogue("free_chat_origins", ("princess"), ("我来自[girl.origin]。我将凭借与生俱来的高贵和良好的品格，在这个繁华的大都市里跻身社会的前列！", "我出生在[girl.origin]，我就在这里。我相信玉城将为我带来美好的事物！", "我的家人来自[girl.origin]。我有良好的教养，一定能在玉城找到好运气！"), love=1, max_cap=40)
    add_dialogue("free_chat_hobbies", ("princess", "sweet"), ("哦，我喜欢从事许多令人愉快的消遣活动！例如，我真的很喜欢[hobby]！", "我喜欢在[hobby]这样美好的爱好中打发时间。"), love=2, max_cap=40)
    add_dialogue("free_chat_likes", ("princess"), ("我对很多事情感到高兴。例如，我最喜欢的[thing_cn]是[best]。", "当你爱上我并开始给我买我喜欢的东西时，你应该知道我最喜欢的[thing_cn]是[best]。", "我现在不需要你提供任何东西，但如果时机成熟，你最好记住我最喜欢的[thing_cn]是[best]。"), love=2, max_cap=40)
    add_dialogue("free_chat_dislikes", ("princess"), ("这个世界上有很多无意义的事情。例如，我最不喜欢的[thing_cn]是[worst]。", "好问题。我一直以为[worst]是平民的[thing_cn]，缺乏文雅和品位！", "在我看来，[worst]是一件愚蠢的[thing_cn]。如今，在较好的豪宅中很少见到这种情况。", "任何对什么是优雅有所了解的人都认为[worst]是一种粗俗[thing_cn]。"), max_cap=40)

    add_dialogue("free_joke_harmless", ("princess"), ("平淡又无聊。我不喜欢这类笑话。", "我和马有过更有趣的对话。", "我不是已经告诉过你我不喜欢无聊无害的笑话吗？"), max_cap=50)
    add_dialogue("free_joke_adult", ("princess"), ("开个玩笑就可以了。", "有点好笑。", "温和有趣。", "好吧好吧，还不错....", "粗俗，但足够有趣。"), love=1, max_cap=50)
    add_dialogue("free_joke_dark", ("princess"), ("开个玩笑就可以了。", "有点好笑。", "温和有趣。", "好吧好吧，还不错....", "粗俗，但足够有趣。"), love=1, max_cap=50)
    add_dialogue("free_joke_mean", ("princess", "repressed"), ("有趣，但我听说过更有趣的。", "充其量是轻度娱乐。", "你的言论很粗鲁，但也很有趣。"), love=1, max_cap=50)

    add_dialogue("free_touch_hand", ("princess", "stubborn"), ("感觉真好！你也可以亲吻我的手。"), love=1, max_cap=90)
    add_dialogue("free_touch_kiss", ("princess", "holy"), ("你这真是太大胆了，不过我喜欢！"), love=4, max_cap=90)
    add_dialogue("free_touch_ass", ("princess"), ("你刚才做了什么？ *冰冷地盯着你*", "放手！！关于如何对待像我这样有教养的女孩，你还有很多东西需要学习。", "停下来！多么无礼啊。"), love=1, max_cap=90)
    add_dialogue("free_touch_breasts", ("princess", "holy"), ("你这胆子更大啊！但感觉真好啊！ *微笑*"), love=5, max_cap=90)
    add_dialogue("free_touch_pussy", ("princess"), ("你刚才做了什么？ *冰冷地盯着你*", "放手！！你显然不知道如何对待一位女士。", "停下来！多么无礼啊。", "放手！！你为什么要和我这样一个有教养的女孩一起尝试呢？"), max_cap=90)

    add_dialogue("free_play refuses", ("princess", "prude", "repressed"), ("决不。这是非常不愉快的。如果你认为像我这样长大的女孩会在肮脏的街角做这种事，那你就是在自欺欺人。"), love=-1)
    add_dialogue("free_play very reluctant", ("princess"), ("你提出的要求不太像淑女，但如果你有礼貌地提出要求，我会为你做的。"), love=1)
    add_dialogue("free_play reluctant", ("princess"), ("你的要求不太淑女，但我会为你做的。"), love=2)
    add_dialogue("free_play a little reluctant", ("princess"), ("不太淑女！ *咯咯笑*但我会这么做，亲爱的。"), love=2)
    add_dialogue("free_play indifferent", ("princess"), ("嗯....我不太喜欢这种行为，但我们就这么做吧。我要看看你在卧室里是否擅长！"), love=3)
    add_dialogue("free_play a little interested", ("princess"), ("好吧，我发现你的坚持很迷人。男人对我通常不会那么直白！"), love=4)
    add_dialogue("free_play interested", ("princess"), ("我们开始做吧。请给我带来快乐并欣赏我的身体，[MC.name]。"), love=4)
    add_dialogue("free_play very interested", ("princess"), ("哦，是的....蹂躏我，我的骑士！想想我的内衣已经湿透了...."), love=5)
    add_dialogue("free_play fascinated", ("princess"), ("哦，是的....蹂躏我，我的骑士！想想我的内衣已经完全湿透了......"), love=5)
    add_dialogue("MC take virginity", ("princess"), ["g: 你有幸成为我的第一个，并且毁了我。我不再是少女了。", "g: 既然我已经失去了童贞，那我们就快点再做一次吧！"], multiple=True, love=5)
    add_dialogue("free_play interested after", ("princess"), ("哦，原来你知道如何满足我！这是我在一位能赢得我心的绅士身上寻找的品质之一。"))
    add_dialogue("free_play not interested after", ("princess"), ("你玩得很开心，但如果你想满足像我这样精致的女士，你必须更加努力。"))

    add_dialogue("free_flirt_beauty", ("princess"), ("谢谢。我很高兴你注意到了！", "谢谢你发现我很漂亮。我认为我的漂亮外表加上我良好的性格和教养有一天会让我走得更远。"), love=2, max_cap=75)
    add_dialogue("free_flirt_body", ("princess"), ("谢谢。一个女人应该有一个好身材。神奇的内衣是一个很好的方式来强调它，让正确的东西脱颖而出....给你一点提示，告诉你该买什么。", "你说得有点粗俗，但是保持好身材对于一个女人来说是必不可少的。", "我知道我的身体适合像我这样的女士。如果你真的喜欢它，你应该给我买一些漂亮的衣服，因为不幸的是我现在买不起真正漂亮的衣服。"), love=4, max_cap=75)
    add_dialogue("free_flirt_mind", ("princess"), ("你想侮辱我吗？女人光鲜亮丽是不合适的！", "你还叫我聪明啊！下一步是什么？告诉我我应该穿裤子去工作谋生！？", "看在太阳神的份上，我不聪明！那不优雅。这对于一个女孩来说是不可取的。"), love=-1, max_cap=75)
    add_dialogue("free_flirt_spirit", ("princess"), ("当然！", "我很高兴您注意到我的良好品格。你真是太有礼貌了。", "你指的一定是我与生俱来的优雅。我和我的[girl.story_guardian]有良好的成长经历。", "啊，你可能是说我与生俱来的高贵品格。", "谢谢。虽然我只是一个女孩，但我知道我很活泼，很优雅。这是我良好教养的结果。"), love=2, max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("princess"), ["g: 我喜欢在卧室内外受到绅士的关注......", "g: ....我[i]得到了[/i]他们的很多关注....", "她笑着说."], multiple=True, love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("princess"), ("很多男人都很佩服我。我让他们中的一些人非常钦佩我。 *咯咯笑*"), love=2)
    add_dialogue("free_flirt_sex_experience average", ("princess"), ["她脸红.", "g: 这有点个人化....但是如果我们不尝试一下，我怎么知道我的仰慕者能在卧室里满足我呢？"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("princess"), ["她脸通红.", "g: 我也接到过绅士的来电，我也尝试过，但是像个普通的妓女一样到处乱睡可不是什么淑女风范。"], multiple=True)
    add_dialogue("free_flirt_sex_experience very inexperienced", ("princess"), ["她给了你一个天真的眼神.", "g: 不要向女士问这个问题....", "她皱眉."], multiple=True, love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("princess", "repressed"), ("童贞是女孩最宝贵的财产。如果我的身穿闪亮盔甲的骑士值得的话，我会把它交给他。"), love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("princess"), ("哦真的吗？我很欣赏你的贞洁，但你也应该学会满足我。事实上，我应该尽快让你知道我在卧室里对你有什么要求。"), love=3)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("princess"), ["g: 你的意思是你找不到人？我希望我的骑士能够在任何女孩完全献身于我之前让她们神魂颠倒。", "g: 如果你没有经验，怎么能让我满意呢？"], multiple=True, love=-1)

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("princess"), ("在我的梦里，你对我完全忠诚，你的唯一！但我很高兴你没有和太多的小女孩鬼混。"), love=2)
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("princess"), ["g: 你的意思是你找不到女孩？我希望我的骑士能够在任何女孩完全爱上我之前让她们神魂颠倒。", "g: 如果你连那些愚蠢的普通女孩都勾引不了，你又怎么能够满足我呢？"], multiple=True)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("princess"), ("我明白了....毫无疑问是在操弄愚蠢的农家女孩。别提醒我你有多不优雅。"), love=-1)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("princess"), ["g: 哦，我印象深刻！ *舔她的嘴唇*我希望我的穿着闪亮盔甲的骑士床上功夫很好，能够随时勾引任何女孩。", "g: 当我成为你们唯一的一个时，那些娘们一定会嫉妒极了！"], multiple=True, love=3)

    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("princess"), ["g: 哦，是的....你在看管其中一栋挂着红灯笼的房子，不是吗？", "g: 你一定很懂得如何与女孩打交道，如果你手下有这么多女孩的话....一想到我的内衣就有点湿了。", "g: 我很高兴你和这么多堕落的女人一起练习....", "g: 当然，你最终会爱上我，成为你的唯一！"], multiple=True, love=3)

    add_dialogue("free_flirt_sex_act refuses", ("princess"), ("回答这样的问题很不淑女。"))
    add_dialogue("free_flirt_sex_act very reluctant", ("princess"), ("向一位女士提出这样的要求，实在是太不礼貌了。我们为什么不谈谈别的事情呢？"))
    add_dialogue("free_flirt_sex_act reluctant", ("princess"), ("向女士提出这样的要求实在是不礼貌。我们为什么不谈谈别的事情呢？"))
    add_dialogue("free_flirt_sex_act a little reluctant", ("princess"), ("向女士提出这样的要求是不礼貌的。至少在我们认识之前....更好。"))
    add_dialogue("free_flirt_sex_act indifferent", ("princess"), ["她想了一会儿.", "g: 哦，好吧...这是人们在卧室里做的事情之一，我想...我不介意你有时这样做。"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_act interested", ("princess"), ("哦，我很喜欢这样！它会带来如此令人愉快的高潮。 *脸红*"), love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("princess"), ("哦，那真是太美妙了！它会带来如此令人愉快的高潮。 *脸红*"), love=2)
    add_dialogue("free_flirt_sex_act very interested", ("princess"), ("哦天哪....光是想想我的内衣就有点湿了。"), love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("princess"), ("哦天啊....光是想想我的内衣就湿透了。"), love=3)

    add_dialogue("free_give_gold +++", ("princess", "bimbo"), ("我万分感谢！ *微笑*正是女孩需要买一些生活中的好东西！"), love=8, max_cap=75)
    add_dialogue("free_give_gold ++", ("princess"), ("我非常感激。是时候给自己买一些新珠宝了！"), love=5, max_cap=75)
    add_dialogue("free_give_gold +", ("princess", "bimbo", "superficial"), ("谢谢。这是一个不错的数额。我也许可以用它买一些漂亮的内衣。"), love=3, max_cap=75)
    add_dialogue("free_give_gold -", ("princess", "superficial", "bimbo", "schemer"), ("这应该足够了吗？你知道真正漂亮的衣服要多少钱吗？"), love=1, max_cap=75)
    add_dialogue("free_give_gold --", ("princess", "schemer"), ("你侮辱了我！"), love=-2, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("princess"), ["她用新发现的决心看着你.", "g: 我？妓女？难道就没有别的办法了吗...", "g: 我并不反对性本身，但我反对真正的女士必须工作的想法。你确定你不只是想支持我这样可爱的女孩吗？", "g: 另外，一个像我一样成长和血统的女孩成为奴隶的想法简直是荒谬的。", "mc: 恐怕你已经欠了很多债了，[girl.fullname]。签署临时奴隶合约会让你摆脱困境。"], multiple=True, love=3)
    add_dialogue("free_offer_job half_lie", ("princess"), ["g: 你从没告诉过我!", "mc: 我当时认为这并不重要...", "g: 我并不反对性，但我反对女性必须工作的想法。你确定你不只是想支持我这样可爱的女孩吗？", "g: 另外，一个与我有血统和成长经历的女孩成为奴隶的想法真是荒谬。", "mc: 你已经欠了很多债，[girl.fullname]。签署临时奴隶合约会让你摆脱困境。"], multiple=True, love=3)
    add_dialogue("free_offer_job lie", ("princess"), ["g: 噢，所以你骗了我！我以为你从事的是令人印象深刻且浪漫的职业，但事实证明你是虚假且自负的！", "g: 这不是我梦想的那样....我，一个妓女？", "mc: 有些女孩更喜欢“陪护”这个词...", "g: 护送？困扰我的不是性别，而是你真的希望像我这样长大的优雅女士像平民一样工作吗？"], multiple=True, love=-1)
    add_dialogue("free_offer_job success", ("princess"), ["g: 我已经决定了。我会做。我享受性爱。我喜欢受到男人的关注...", "g: 但是，我必须承认，最让我着迷的是身处那些红灯塔之一的想法。像我这样甜美脱俗的女孩，一定会成为闻名世界的名妓！", "g:  女士工作不适合，但如果我仰着工作的话，肯定不算数。"], multiple=True)
    add_dialogue("free_offer_job thinking", ("princess"), ["g: 嗯....当妓女并不淑女。任何类型的工作都不适合希望进入美好社会的人....但我确实喜欢接受男人的关注和礼物。", "g: 也许我可以监督其他女孩？他们对我来说就像仆人一样。他们会看到我的需求得到满足。我会坚定但公平地对待他们。", "mc: 不，我不需要女士。我已经有了希露，他负责处理这件事和许多其他事情。你可以成为一名女按摩师、一名艺伎或一名女服务员，如果你所说的妓女太过分了。", "g: 这听起来太像实际工作了。虽然艺伎也许不会太糟糕。", "g: 我需要考虑一下...如果我想再次购买新的手袋和神奇的内衣，我确实需要钱。 ", "她离开时看上去若有所思。"], multiple=True)
    add_dialogue("free_offer_job failure lie", ("princess"), ["g: 去你的吧，我就是这么想的！以太阳神的名义，你以为我是谁！", "g: 你对我撒了谎，现在你却想让我像一个普通的妓女一样在你那可怕的青楼里工作！我一生中没有一天工作过。那是不会发生的！", "g: 滚出我的视线！", "她离开了，看起来很生气.", "mc: 进展顺利。等她冷静下来再说吧?"], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("princess"), ["g: 去你的吧，我就是这么想的！你以为我是亚里欧斯的谁啊！", "g: 你认为我会因为对你的工作感兴趣而像一个普通的妓女一样工作吗？", "g: 滚出我的视线！", "她离开了，看起来很生气.", "mc: 进展顺利。等她冷静下来再说吧?"], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("princess"), ["她突然变得像个小女孩一样头晕、兴奋。", "g: 真的吗？！这真是太令人兴奋了！和很多乖乖女一样，我总是暗自对那些挂着红灯笼的房子里发生的事情有些着迷....我有时可以过来看看吗？我可以吗？能？！", "g: 我很想看看那些夜里的女士们是怎样做的。我很好奇发生了什么！"], multiple=True, love=3)
    add_dialogue("free_friend half_lie", ("princess"), ("只是一个[MC.playerclass]...多么不精致。我想了一会儿，你可能值得我关注。"), love=-2)
    add_dialogue("free_friend lie", ("princess"), ("这真是令人兴奋，甚至浪漫！你还蛮有趣的。"), love=1)

    add_dialogue("free_love_interest", ("princess"), ["mc: Hi, [girl.name]. 出什么事了吗?", "g: 呃，我？不....我只是在想。当我还是个小女孩的时候，我喜欢读浪漫的老式书籍。", "g: 在那些书中，主人公总是给他们的爱人带来一朵美丽的花，以表达他对她的奉献。", "g: 真是侠义又浪漫啊！", "g: 既然我们已经如此亲密，如果您是一位英勇的绅士并给我带来一个，我将非常感激。"], multiple=True)
    add_dialogue("free_girl get_flowers", ("princess"), ("哦，一朵美丽的花送给你的女士。这真是太浪漫了....你有什么想要从我这里得到的吗？"))
    add_dialogue("free_ask_out", ("princess"), ["mc: [girl.name], 我喜欢你。让我们在一起.", "g: 你想让我....成为你的情人吗？", "mc: 没错.", "g: Why, finally you ask! Of course!", "她向你伸出手，期待你亲吻它。", "g: 既然你对我忠诚了，你就可以满足我的愿望，给我买礼物....", "g: ....也许我会给你一些好东西作为回报。 *眨眼*"], multiple=True)

    add_dialogue("free_girlfriend intro", ("princess"), ["g: 哦，[MC.name]！过来吧，我的骑士....", "mc: 嗨,我的爱人。你今天好吗??", "g: 我很好，亲爱的...跟我来，我想给你看一些东西...", "mc: 这么突然, 当然...", "g: 但首先，我要问你一个问题。"], multiple=True)
    add_dialogue("free_girlfriend right", ("princess"), ("你是对的，当然！在我心里，我一直知道你不会让我失望的！"), love=5)
    add_dialogue("free_girlfriend give_up", ("princess"), ("哦真的吗？你愿意放弃{b}我{/b}吗？！ ....而且很可能会去找一些毫无价值、不优雅的妓女！ *皱眉*"), love=-5)
    add_dialogue("free_girlfriend wrong", ("princess"), ["g: 你太糟糕了！！！根本不是那么回事！！！你配不上我这样的少女....*疯狂*", "mc: 啊, 呃, 抱歉..."], multiple=True, love=-10)
    add_dialogue("free_girlfriend success", ("princess"), ["她把衣服扔在地上，凝视着你的眼睛.", "g: 你觉得我丰满的优美身材怎么样？", "你可以感觉到你的鸡巴在第二秒变得更硬。她似乎注意到了，并对你报以微笑.", "g: Hmmm..."], multiple=True)
    add_dialogue("free_girlfriend success naked", ("princess"), ["当她脱下衣服，双手捧起胸部，轻轻地抚摸着她的乳头时，你倒吸了一口气.", "g: 我一直以为像我这样高贵的身体，赤身裸体才是最优雅的", "g: 当我在家里裸体的时候，我总是觉得很舒服。我希望我能一直裸体!", "g: 但不幸的是，出于道德和习俗的考虑，我当然不会光着身子在城里走来走去....*叹气*我没有疯。", "g: 不过，我很高兴能向你展示真实的自己....你看起来也很开心! *咯咯笑*"], multiple=True)

    add_dialogue("free_job_request", ("princess"), ["g: 哦，[MC.name]！为什么每个人都试图让我的生活变得如此糟糕！", "mc: 拜托，亲爱的，那不是真的...发生了什么事?", "g: 是我叔叔！他的遗产....自从他去世后....我只用了一些开支，几个手提包，六件衣服，神奇的内衣....", "g: 但是那个愚蠢的店员说钱没了！全没了！现在我借了一些小钱的贪婪的高利贷者想要回来。 *哭*", "她泪眼婆娑地看着你.", "g: 我负债累累!我该怎么办... *啜泣*", "mc: Mmmh...好吧，也许有一种方法...奴隶不能负债，你知道吗?", "g: 呃？你有什么建议？！"], multiple=True)
    add_dialogue("gizel take girl to farm", ("princess"), ("哈！欢迎来到我的领域，你这个愚蠢的女人。我会把你鞭打成形状。"))

    add_dialogue("girl introduction", ("princess"), ["你好。我是[girl.fullname]。我希望你能善待我。", "嗨，我是[girl.fullname]。我希望在这个地方能得到很好的待遇..."])
    add_dialogue("slave thanks", ("princess"), ("谢谢。", "非常感谢你。", "谢谢。你很自然地欣赏我的努力。"))
    add_dialogue("slave negative fixation refuse", ("princess"), ("不，拜托，不是那个！这不适合我这样优雅的女孩。"))

    add_dialogue("slave first visit", ("princess"), ["g: 你是来跟我说话的。为什么？", "g: 你知道这对我来说是多么羞辱吗？"], multiple=True)
    add_dialogue("MC kind promise", ("princess"), ("谢谢。我很高兴你明白你需要善待像我这样的女孩。"), love=2, fear=-3)
    add_dialogue("MC fair promise", ("princess"), ["她看上去警惕心少了一些。", "g: 我明白了。我很高兴你明白你需要善待像我这样的女孩。"], multiple=True, fear=-1)
    add_dialogue("MC no promise", ("princess"), ("你说什么？！你知道我是谁吗？"), love=-1, fear=1)
    add_dialogue("MC fight intro", ("princess"), ("你认为你到底在做什么？"), sound=s_scream_loud)
    add_dialogue("slave naked request resist", ("princess"), ("哈哈。决不。我的身体对于来到这里的乌合之众来说太好了。"), love=-1, fear=-2)
    add_dialogue("slave chat brothel -2", ("princess","very modest"), ["她的眼睛燃烧着，声音因正义的愤怒而颤抖。", "g: 你他妈在开玩笑吗？这是罪恶和堕落的巢穴！让我离开这里，现在！！！"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel -1", ("princess","very modest"), ["她看起来很生气。", "g: 这个地方是肮脏的青楼！我不是那种女孩...我在这里做什么...*抽泣*"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0", ("princess","very modest"), ["她低下头。", "g: 我还是不敢相信我在这种地方工作....主人，我真的必须这么做吗？"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0.5", ("princess","very modest"), ["她耸耸肩。", "g: 我最不想在青楼工作....但现在我还好。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel virgin", ("princess","very modest"), ["她耸耸肩。", "g: 听着，你知道我没有和其他女孩一样的经历，这并不是我梦想的生活。但我挺过去了。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 1", ("princess","very modest"), ["她脸红.", "g: 我一直认为青楼是最糟糕的。但现在我在这里工作了，我想其实还不错。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 2", ("princess","very modest"), ["她脸红了，咬着嘴唇。", "g: 说起来很羞耻，但我喜欢这里...我从来没有想过我会成为这样的女孩，但是... *脸红*"], multiple=True, unlock="LM")
    add_dialogue("slave chat customers -2", ("very materialist"), ["她勃然大怒。", "g: 我讨厌那些畜生！！！为什么我要侍奉这些恶心的猪？"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers -1", ("very materialist"), ["她的声音因愤怒而颤抖。", "g: 一群好色的混蛋，就是这样！他们为什么不打扰其他女孩？"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 0", ("very materialist"), ["她看起来很沮丧。", "g: 顾客，他们真是粗鲁....我希望没有他们我们也能继续营业，但这不是一个选择。 *叹*"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 0.5", ("very materialist"), ["她耸耸肩。", "g: 他们中的一些人可能很粗鲁和吝啬，但我想我已经学会了如何应对他们。"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 1", ("very materialist"), ["她嗤之以鼻。", "g: 他们一直命令我做这做那....但我只要给他们正确的表情，他们就成了我的宠物！ *眨眼*"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 2", ("very materialist"), ["她笑得很善意。", "g: 哦，我爱顾客！他们总是给我带来礼物并称赞我。这并不痛，你知道吗？"], multiple=True, unlock="MI")
    add_dialogue("slave chat other_girls -2", ("princess"), ("我最讨厌那些粗鲁的农家母狗了！我从心底里恨他们！这个地方最糟糕的事情就是不得不和那些流浪汉住在一起......"), unlock="EI")
    add_dialogue("slave chat tastes likes", ("princess"), ("我对很多事情感到高兴。例如，我最喜欢的[thing_cn]是[best]。", "当你爱上我并开始给我买我喜欢的东西时，你应该知道我最喜欢的[thing_cn]是[best]。", "我现在不需要你提供任何东西，但如果时机成熟，你最好记住我最喜欢的[thing_cn]是[best]。"), unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("princess"), ("这个世界上有很多无意义的事情。例如，我最不喜欢的[thing_cn]是[worst]。", "好问题。我一直以为[worst]是平民的[thing_cn]，缺乏文雅和品位！", "在我看来，[worst]是一件愚蠢的[thing_cn]。如今，在较好的豪宅中很少见到这种情况。", "任何对什么是优雅有所了解的人都认为[worst]是一种粗俗[thing_cn]。"), unlock="LM")
    add_dialogue("slave chat origins 1", ("princess"), ("我来自[girl.origin]。我将凭借与生俱来的高贵和良好的品格，在这个繁华的大都市里跻身社会的前列！", "我出生在[girl.origin]，我就在这里。我相信玉城将为我带来美好的事物！", "我的家人来自[girl.origin]。我有良好的教养，一定能在玉城找到好运气！"), unlock="EI")
    add_dialogue("slave chat origins 2", ("princess"), ("我曾经和我的 [girl.story_guardian] 一起住在 [girl.origin] 附近的 [a_home]。 "), unlock="EI")
    add_dialogue("slave chat origins 3", ("princess"), ("我记得我和我的[girl.story_guardian]住的[girl.story_home]..."), unlock="EI")
    add_dialogue("origin Zan", ("princess"), ["g: 我和我的[girl.story_guardian]一起长大。我们并不富有，但我的[girl.story_guardian]总是告诉我，我来自一个有着悠久血统的好家庭，比这里的大多数乌合之众要好得多。", "g: 我们还有像我叔叔这样的有钱亲戚，他最近去世了。我从小就认为自己很特别，并且欣赏生活中美好的事物。我一直以为我注定会进入上流社会。", "g: 最近，我听到一些让我烦恼的事情。一个女孩子骂我是个被宠坏的小妖精！", "g: 我不是风骚的！我绝对没有被宠坏。主人，你觉得我被宠坏了吗？", "她看起来很悲伤。"], multiple=True)
    add_dialogue("origin the border with the Holy Lands", ("princess"), ["g: 圣地一直是一个充满战争和苦难的地方。我来自那里的一个古老家庭，他们在战争中失去了一切。", "g: 我和我的[girl.story_guardian]一起长大，他教会了我优良的血统和血管里流淌的高贵血统，以及我应该如何做相应的行为", "g: 我的[girl.story_guardian]曾经说过，像我这样从这片战火蹂躏的土地上发芽的玫瑰，抵得上一百个农民或城市里的平民，我比他们任何一个都优秀。这就是我从小到大所相信的。", "g: 最近，我听到一些让我烦恼的事情。一个女孩子骂我是个被宠坏的小妖精！", "g: 我不是风骚的！我绝对没有被宠坏。我不想被宠坏！主人，你觉得我被宠坏了吗？", "她看起来很悲伤。"], multiple=True)
    add_dialogue("origin the Blood Islands", ("princess"), ["g: 血腥群岛是一个严酷的地方。我非常习惯奴隶制并看到奴隶以最残酷的方式受到惩罚。", "g 我和我的[girl.story_guardian]一起长大，她总是提醒我，尽管我们很穷，但我们与那里的贵族统治家族之一有联系，必须表现得相应。", "g: 我的[girl.story_guardian]曾经说过，像你这样美丽的血玫瑰，胜过一百个农民或一万个奴隶。", "g: 当我搬到泽恩时，我总是试图记住我的高贵血统，以及我的[girl.story_guardian]所说的话。", "g: 最近，我听到一些让我烦恼的事情。一个女孩子骂我是个被宠坏的小妖精！", "g: 我不是风骚的！我绝对没有被宠坏。我不想被宠坏！主人，你觉得我被宠坏了吗？", "她看起来很悲伤。"] , multiple=True)
    add_dialogue("origin Karkyr", ("princess"), ["卡基尔是一座美丽而迷人的城市，由大法师议会统治。我和我的[girl.story_guardian]一起长大，他告诉我，我来自一个非常古老而高贵的血统，即使我们不像我最近去世的泽恩叔叔那样富有。", "g: 我的[girl.story_guardian]告诉我，一朵像我这样的神奇玫瑰，比一百个农民或城市里的平民还要值钱。", "g: 最近，我听到一些让我烦恼的事情。一个女孩子骂我是个被宠坏的小妖精！", "g: 我不是风骚的！我绝对没有被宠坏。我不想被宠坏！主人，你觉得我被宠坏了吗？", "她看起来很悲伤。"], multiple=True)
    add_dialogue("origin Westmarch", ("princess"), ["g: 我长大的威斯特玛公国是一个非常难以预测的地方。有一天，一座城市欣欣向荣，第二天，它就陷入无政府状态，掠夺者掠夺和掠夺城镇。我来自那里的一个古老家庭，他们在战争中失去了一切。", "g: 我和我的[girl.story_guardian]一起长大，他教会了我优良的血统和血管里流淌的高贵血统，以及我应该如何做相应的行为", "g: 我的[girl.story_guardian]曾经说过，像我这样为我们暂时陷入困境的家庭发芽的一朵玫瑰花，抵得上一百个农民或城市里的平民。这就是我从小到大所相信的。", "g: 最近，我听到一些让我烦恼的事情。一个女孩子骂我是个被宠坏的小妖精！", "g: 我不是风骚的！我绝对没有被宠坏。我不想被宠坏！主人，你觉得我被宠坏了吗？", "她看起来很悲伤。"], multiple=True)
    add_dialogue("origin the desert of Hokoma", ("princess"), ["g: 我们沙漠人有自己的风俗习惯，有自己古老的家族。我的[girl.story_guardian]曾经告诉我，我是如何从如此古老而高贵的血统中继承下来的。", "g: 我从小就认为自己很特别，注定会成就伟大的事情。我的[girl.story_guardian]告诉我，像我这样的一朵沙漠玫瑰，胜过一百个城市里的平民。", "g: 最近，我听到一些让我烦恼的事情。一个女孩子骂我是个被宠坏的小妖精！", "g: 我不是风骚的！我绝对没有被宠坏。我不想被宠坏！主人，你觉得我被宠坏了吗？", "她看起来很悲伤。"], multiple=True)
    add_dialogue("origin Borgo, the port city", ("princess"), ["g: 无法描述博尔戈在大多数日子里是多么忙碌和拥挤，来自世界各地的水手出售你能想象到的所有东西，还有许多其他东西。", "g: 也比Zan粗。我的[girl.story_guardian]并没有忽视这个事实，她曾经告诉我，我出身高贵，比博尔戈的乌合之众要好得多。", "g: 我的[girl.story_guardian]曾经说过，像你这样的玫瑰在这些不成熟的猪群中消失了。你应该搬到泽恩，在那里他们会欣赏你真正高贵的品格。", "g: 最近，我听到一些让我烦恼的事情。一个女孩子骂我是个被宠坏的小妖精！", "g: 我不是风骚的！我绝对没有被宠坏。我不想被宠坏！主人，你觉得我被宠坏了吗？", "她看起来很悲伤。"], multiple=True)
    add_dialogue("origin the Goliath desolations", ("princess"), ["g: 荒凉的地方是一个寒冷、可怕的地方。无论贫穷还是富有，每天都必须努力工作，才能勉强生存。", "g: 不过，就像我的 [girl.story_guardian] 曾经提醒我的那样，我实际上出身高贵，值得过更轻松的生活。", "我的[girl.story_guardian]也曾经告诉我，像我这样在歌利亚荒凉中长大的女孩胜过一百个在其他地方长大的女孩，应该像最出身的贵族或公主一样对待。", "g: 最近，我听到一些让我烦恼的事情。一个女孩子骂我是个被宠坏的小妖精！", "g: 我不是风骚的！我绝对没有被宠坏。为了阿里奥，我在歌利亚的荒凉中长大！主人，你觉得我被宠坏了吗？", "她看起来很悲伤。"], multiple=True)
    add_dialogue("origin the Arik mountains", ("princess"), ["g: 他们说阿里克山是世界上最高的山。那里的空气很纯净，不像这里那样充满泥土和邪恶魔法的臭味。我的[girl.story_guardian]曾经告诉我，我们阿里克的人民比生活在下面城市的乌合之众更加纯洁。", "g: 我是阿里克山脉一个古老而高贵的血统的后裔。我从小就认为自己很特别，注定会成就伟大的事情。我的 [girl.story_guardian] 告诉我，一朵阿里克山玫瑰的价值超过一百朵低地玫瑰。", "g: 最近，我听到一些让我烦恼的事情。一个女孩子骂我是个被宠坏的小妖精！", "g: 我不是风骚的！我绝对没有被宠坏。我不想被宠坏！主人，你觉得我被宠坏了吗？", "她看起来很悲伤。"], multiple=True)
    add_dialogue("slave train resisted", ("very dom"), ["主人请！别....别逼我这么做....", "不，等等....我不想！", "但、但是....我不喜欢这样！"])
    add_dialogue("slave train refused", ("very dom"), ["决不！！！我不是荡妇！", "我不会这么做！我不会。这是最终的。", "把你的脏爪子从我身上拿开！！！", "什么？不！！！滚蛋！"])

    add_dialogue("slave lecture neutral", ("princess"), ("您是来参加您的一场讲座吗...？", "是的，我知道性让世界运转......我应该尝试更多新事物......现在这是我的工作......等等等等。", "又到上课时间了？"))
    add_dialogue("slave train obedience", ("very dom"), ("呃....像个愚蠢的仆人一样被命令...."))
    add_dialogue("slave train naked failure", ("very modest"), ("太可耻了....你没有礼貌...."), sound=s_surprise)
    add_dialogue("slave train naked success", ("very modest"), ("主人....我喜欢你看着我...."), sound=s_aah)

    add_dialogue("slave train service success", ("very dom"), ("主人，我想要你的精液...请不要让我乞求..."))
    add_dialogue("slave train sex failure", ("very modest"), ("真是羞耻啊....*呜呜*"))
    add_dialogue("slave train sex success", ("very modest"), ("主人，我高潮了....啊啊啊！做个坏女孩真好...."))

    add_dialogue("slave train anal success", ("very modest"), ("啊啊啊！！！我爱死了！啊哈！！！我就是这样一个妓女..."))
    add_dialogue("slave train fetish failure", ("very modest"), ("你在干什么！！！停下来！！！"))
    add_dialogue("slave train fetish success", ("very modest"), ("主人....请伤害我吧....我是个顽皮、顽皮的荡妇...."))
    add_dialogue("slave train bisexual failure", ("very modest"), ("不....女孩子都是肮脏的...."))
    add_dialogue("slave train bisexual success", ("very modest"), ("嗯....我不敢相信我现在是个女同性恋了...."), sound=s_mmh)
    add_dialogue("slave train group failure", ("very modest"), ("三人行....真是....太堕落了！！！"))
    add_dialogue("slave train group success", ("very modest"), ("我现在是一个彻头彻尾的狂欢荡妇...如果我的 [girl.story_guardian] 能看到我...*脸红*"))
    add_dialogue("refuse sex act", ("very dom"), ["决不！！！我不是荡妇！", "我不会这么做！我不会。这是最终的。", "把你的脏爪子从我身上拿开！！！", "什么？不！！！滚蛋！"])

## START EASY DIALOGUE 03.February.2022

    add_dialogue("free_greetings_rude", ("easy", "pet"), ("出色地！我的名字是[girl.fullname]。你总是那么随性吗？"), love=1)
    add_dialogue("free_chat_life", ("easy"), ("我只是希望每个人都幸福。"), love=1, max_cap=25)
    add_dialogue("free_chat_love", ("easy"), ("我当然有过很多爱。这不是我的错！伙计们似乎只是喜欢我。"), love=2, max_cap=25)
    add_dialogue("free_chat_origins", ("easy", "very introvert"), ("我来自[girl.origin]。我想这是一个和其他地方一样的地方。我没见过太多的世界。"), max_cap=40)
    add_dialogue("free_flirt_beauty", ("easy"), ("我真的有那么特别吗？"), max_cap=75)
    add_dialogue("free_flirt_body", ("easy"), ("男生经常这么对我说！我不想让他们失望*微笑*"), love=1, max_cap=75)
    add_dialogue("free_flirt_mind", ("easy", "helper"), ("我只是一个很普通的女孩。我尽我所能，让别人幸福！"), love=1, max_cap=75)
    add_dialogue("free_flirt_spirit", ("easy", "princess"), ("谢谢你这么说。"), love=1, max_cap=75)
    add_dialogue("gizel take girl to farm", ("easy"), ("好吧，我会让她成为一个像样的奴隶。听我的命令吧，你这个愚蠢的荡妇。"))

    add_dialogue("girl introduction", ("very extravert"), ["啊，你好！我是[girl.name]。很高兴认识你。", "很高兴见到你。我是[girl.name]。"])
    add_dialogue("slave whining", ("generic"), ["噢...", "但...", "但、但是....", "呃？等待...", "哦..."])
    add_dialogue("slave negative fixation refuse", ("generic"), ["不，不是这个！我不喜欢它！"])
    add_dialogue("slave naked request accept", ("generic"), ("我....我要让大家看看我丢人的身体，然后....*脸红*"), love=2, sound=s_ahaa)

    add_dialogue("slave toggle naked on", ("very lewd"), ("哦，很高兴！ *微笑*"), love=1)
    add_dialogue("slave toggle naked off", ("very lewd"), ("嗯...当然...给我一两分钟..."), love=-1)
    add_dialogue("slave send to master bedroom love", ("generic"), ["她看着你，眼里闪烁着光芒。", "g:  去你的房间吗？这是不是意味着....我们会整晚都在一起？嗯..."], multiple=True)
    add_dialogue("slave send to master bedroom love -", ("generic"), ["她耸耸肩。", "g: 如果你这么说的话...."], multiple=True)
    add_dialogue("slave send to master bedroom fear -", ("generic"), ["她耸耸肩。", "g: 如果我必须...."], multiple=True)

    add_dialogue("slave leave master bedroom love", ("generic"), ["她叹了口气。", "g: 主人，您要解雇我吗？噢..."], multiple=True)
    add_dialogue("slave leave master bedroom love -", ("generic"), ["她耸耸肩。", "g: 当然。反正我已经无聊了..."], multiple=True)

    add_dialogue("slave leave master bedroom fear", ("generic"), ["她似乎松了口气。", "g: 当然，我会..."], multiple=True)
    add_dialogue("slave leave master bedroom fear -", ("generic"), ["她耸耸肩。", "g: 好吧！一刻也不早。"], multiple=True)
    add_dialogue("slave chat brothel -2", ("very lewd"), ["她看起来很沮丧。", "g: 这个地方又可怕又肮脏！这里的条件....太糟糕了！"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel -1", ("very lewd"), ["她看起来很生气。", "g: 我不在乎这是青楼还是宫殿....但是这个地方就是垃圾场！"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0", ("very lewd"), ["她沉默了一会儿。", "g: 这不是我想象中的青楼，你知道....哪里来的奢华和魅力？但我挺过去了..."], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0.5", ("very lewd"), ["她给你一个虚弱的微笑。", "g: 虽然很难，但我想在这样的地方工作也很有趣。我学到了一些东西。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel virgin", ("very lewd"), ["她脸通红.", "g: 这里太疯狂了，这让我很好奇...尽管我从来没有...嗯..."], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 1", ("very lewd"), ["她舔了舔嘴唇.", "g: 这里发生了很多事情，我永远不会感到无聊......而且我偶尔可以享受一次美好的性爱！ *脸红*"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 2", ("very lewd"), ["她给你一个狂热的表情。你可以看到她直立的乳头从她的奴隶裙下脱颖而出。", "g: 这个地方就像天堂一样....我喜欢和男人一起享受乐趣，在这里我可以获得我想要的所有性爱。多么美妙的经历啊！"], multiple=True, unlock="LM")
    add_dialogue("slave chat customers 2", ("easy"), ["她开始跳舞和唱歌。", "g: {i}大家相处得很融洽！带或不带安全套！{/i}", "这首歌似乎是现场即兴创作的。", "g: {i}是啊是啊，空气中弥漫着爱的气息！到处都是湿漉漉的屁股！{/i}", "她以屈膝礼结束了她的例行公事。", "mc: 那好吧。下次简单地说“是”就可以了。"], multiple=True, unlock="MI")
    add_dialogue("slave chat tastes loves +", ("generic"), ("你知道什么会让我如此高兴吗？我喜欢[thing_cn]...我希望我有一些。"), unlock="LM")
    add_dialogue("slave chat tastes loves -", ("generic"), ("我喜欢[thing_cn]。他们很好。"), unlock="LM")
    add_dialogue("slave chat tastes no loves", ("generic"), ("礼物对我来说没有什么好处。这不关我的事。"), unlock="LM")
    add_dialogue("slave chat tastes hates", ("generic"), ("我真的很讨厌[thing_cn]。请不要给我那样的东西。"), unlock="LM")
    add_dialogue("slave chat tastes no hates", ("generic"), ("我喜欢礼物，无论它是什么。"), unlock="LM")
    add_dialogue("slave chat tastes positive act", ("very lewd"), ("最近，我更喜欢[act_desc]...我想我喜欢尝试新事物。"), unlock="LM")
    add_dialogue("slave chat tastes negative act", ("very lewd"), ("不知何故，[act_desc] 让我感到不舒服....有一些事情让我烦恼。"), unlock="LM")
    add_dialogue("slave chat tastes no negative act", ("very lewd"), ("我认为那里有各种各样的性幻想......我真的不介意任何事情。生命短暂！"), unlock="LM")

    add_dialogue("slave chat origins 1", ("easy", "very introvert"), ("我来自[girl.origin]。我想这是一个和其他地方一样的地方。我没见过太多的世界。"), unlock="EI")
    add_dialogue("freed", ("generic"), ("好吧，那就再见了...."))

## START PET DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("pet", "loyal", "schemer", "easy"), ("为什么要谢谢你呢，好先生。 [girl.fullname]，竭诚为您服务！ *傻笑*"), love=2)
    add_dialogue("free_greetings_casual", ("pet", "sweet", "helper", "superficial", "schemer", "easy"), ("你好帅哥，我是[girl.fullname]。很高兴见到你！"))
    add_dialogue("free_greetings_rude", ("pet", "sweet", "helper", "easy"), ("*咯咯笑*你很有趣！我是[girl.fullname]。"), love=1)

    add_dialogue("free_small_talk", ("pet", "helper", "creep"), ("我很高兴你这么说，[MC.name]。我在想同样的事。"), love=2, max_cap=25)
    add_dialogue("free_gossip", ("pet", "helper", "loyal"), ("哦，我很乐意为像你这样的好人透露秘密......"), love=2, max_cap=25)
    add_dialogue("free_chat_life", ("pet"), ("我-我不太确定该怎么想...你的意见是什么，[MC.name]？"), max_cap=25)
    add_dialogue("free_chat_love", ("pet", "loyal"), ["她的眼睛似乎看着很远的地方。", "g: 我想和我尊敬的人一起度过一生。"], multiple=True, max_cap=25)
    add_dialogue("free_chat_origins", ("pet", "helper", "meek"), ("呃，我的故事没那么有趣....我来自[girl.origin]。", "我只是一个来自[girl.origin]的普通女孩....那么你呢？", "我来自[girl.origin]。关于我的事情已经说完了，让我们来谈谈你吧！"), love=1, max_cap=40)
    add_dialogue("free_chat_hobbies", ("pet", "helper", "creep", "meek"), ("M-我？我不太确定...你对[hobby]有什么看法？", "哦，那[hobby]呢？你喜欢它？", "嗯....我妈妈一直很喜欢[hobby]。你？"), love=2, max_cap=40)
    add_dialogue("free_chat_likes", ("pet", "helper", "loyal"), "嗯，我最近做了一个梦，世界上唯一的[thing_cn]是[best]。你喜欢[best]吗？", max_cap=40)
    add_dialogue("free_chat_dislikes", ("pet", "helper", "masochist"), ("嗯，我不喜欢的一件事是[worst]。但——但也许我只是需要热身一下。你觉得[worst]怎么样？", "嗯....说到[thing_cn]，你觉得[worst]的是什么？", "[MC.name]，你对作为[thing_cn]的[worst]有何看法？"), love=1, max_cap=40)

    add_dialogue("free_joke_harmless", ("pet", "nerd"), ("嘿哟哟！啊哈哈哈哈哈哈！你的笑话是最好的！"), max_cap=50)
    add_dialogue("free_joke_adult", ("pet", "helper", "creep"), ("哇哈哈！那。是。搞笑。", "嘿哟哟！啊哈哈哈哈哈哈！你的笑话是最好的！"), love=1, max_cap=50)
    add_dialogue("free_joke_dark", ("pet", "masochist"), ("如果不是那么真实那就太有趣了..."), love=-1, max_cap=50)
    add_dialogue("free_joke_mean", ("pet", "masochist"), ("*脸红*谢谢-谢谢，我想...我正在尽力！所以你说你有一个笑话？"), love=5, max_cap=50)

    add_dialogue("free_touch_hand", ("pet", "generic", "creep", "holy"), ("请永远不要放手，[MC.name]..."), love=1, max_cap=90)
    add_dialogue("free_touch_kiss", ("pet", "meek", "repressed"), ["她脸红了，闭上了眼睛。", "g: 哦，[MC.name]...我爱你！"], multiple=True, love=2, max_cap=90)
    add_dialogue("free_touch_ass", ("pet", "helper", "sweet", "loyal"), ("哦...*咯咯*你想打我屁股吗？"), love=3, max_cap=90)
    add_dialogue("free_touch_breasts", ("pet", "sweet"), ("C、我也可以碰你吗？"), love=3, max_cap=90)
    add_dialogue("free_touch_pussy", ("pet", "helper", "sweet", "loyal"), ("嗯...你想要我，不是吗..."), love=2, max_cap=90)

    add_dialogue("free_play refuses", ("pet", "creep", "masochist"), ("我-我很抱歉[MC.name]，我不能...请再给我一些时间。"), love=-1)
    add_dialogue("free_play very reluctant", ("pet", "loyal", "helper"), ("我-如果那是你真正想要的..."), love=1, sound=s_sigh)
    add_dialogue("free_play reluctant", ("pet", "loyal", "helper"), ("哦-好吧[MC.name]，我会做任何你要求的事情......"), love=2, sound=s_sigh)
    add_dialogue("free_play a little reluctant", ("pet", "loyal", "helper"), ("我会为你做的，[MC.name]..."), love=2, sound=s_sigh)
    add_dialogue("free_play indifferent", ("pet", "loyal", "helper"), ("当然，为什么不呢。"), love=3)
    add_dialogue("free_play a little interested", ("pet", "loyal", "helper", "yandere"), ("我会为你做任何事，[MC.name]。"), love=4, sound=s_mmh)
    add_dialogue("free_play interested", ("pet", "helper", "yandere"), ("我很乐意...特别是因为是你，[MC.name]。"), love=4, sound=s_mmh)
    add_dialogue("free_play very interested", ("pet", "helper"), ("哦，是的...我一直梦想着这一刻。"), love=5, sound=s_mmh)
    add_dialogue("free_play fascinated", ("pet", "yandere", "creep"), ("你不知道我在幻想这个的同时手淫了多少次......"), love=5, sound=s_mmh)
    add_dialogue("MC take virginity", ("pet"), ("谢谢你...我很高兴你是我的第一个..."), love=5)
    add_dialogue("free_play interested after", ("pet", "helper"), ("你太擅长这些了....*脸红*"))
    add_dialogue("free_play not interested after", ("pet", "loyal"), ("哈、我做得怎么样？和我在一起你高兴吗？"))

    add_dialogue("free_flirt_beauty", ("pet", "creep"), ("什、什么？我的美貌还没有你一半..."), love=2, max_cap=75)
    add_dialogue("free_flirt_body", ("pet", "sweet", "princess"), ("*咯咯笑*谢谢你，[MC.name]。"), max_cap=75)
    add_dialogue("free_flirt_mind", ("pet"), ("哦，真的，[MC.name]。我还有很多东西要向你学习...", "但是[MC.name]。与你相比，我不聪明！", "但您更聪明，先生！"), love=-1, max_cap=75)
    add_dialogue("free_flirt_spirit", ("pet", "sweet", "pervert"), ("光是在你身边就让我感觉充满了能量！"), love=2, max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("pet"), ["她笑着对你眨眼。", "g: 我受过最好的训练，却被其他人操过。所以请随意告诉我你的怪癖是什么，我知道如何取悦你。"], multiple=True, love=3, sound=s_laugh)
    add_dialogue("free_flirt_sex_experience experienced", ("pet"), ["她伸出舌头.", "g: 嗯，我接受过一些广泛的培训....每个女人都应该学习如何取悦男人。 *眨眼*"], multiple=True, love=2)
    add_dialogue("free_flirt_sex_experience average", ("pet"), ["她笑了。", "g: 嗯...我渴望了解更多，如果这就是你所问的..."], multiple=True, love=1, sound=s_sigh)
    add_dialogue("free_flirt_sex_experience inexperienced", ("pet"), ["她紧张地捂住乳房。", "g: 我很想了解更多....也许，如果可以和你在一起的话...."], multiple=True, sound=s_surprise)
    add_dialogue("free_flirt_sex_experience very inexperienced", ("pet"), ["她看起来很困惑。", "g: 那、那是什么？", "g: 对不起...我不知道你在说什么..."], multiple=True, love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("pet"), ("我真的希望我的第一次是特别的......"), love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("pet"), ("真的吗？我印象深刻！你充满了惊喜，不是吗？ *傻笑*"), love=-1)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("pet"), ("我、如果你这么说的话...."), love=-3)

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("pet"), ("这很好，我想..."), love=2)
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("pet"), ["她看起来很悲伤。", "g: 噢...我明白了..."], multiple=True)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("pet"), ("感人的！我可以从你身上学到很多东西。"), love=3)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("pet"), ("哦，我可以想象！"), love=3)
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("pet"), ("是这样吗？"))
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("pet"), ("那么你的女儿们就会按照你的命令去做吗？嗯，有趣！"), love=3)

    add_dialogue("free_flirt_sex_act refuses", ("pet", "helper"), ["她给了你一个天真的眼神.", "g: 你-你能解释一下吗？我不明白你在问什么..."], multiple=True, sound=s_surprise)
    add_dialogue("free_flirt_sex_act very reluctant", ("pet", "helper"), ["她的眼里涌出泪水。", "g: 我-我不知道该说什么...我需要你的帮助，[MC.name]。"], multiple=True)
    add_dialogue("free_flirt_sex_act reluctant", ("pet", "loyal"), ["她沉思了一会儿。", "g: 你真的很喜欢那种东西，是吗？我必须了解更多相关信息。"], multiple=True)
    add_dialogue("free_flirt_sex_act a little reluctant", ("pet", "helper"), ["她停顿了一下。", "g: 嗯，我从来没有真正考虑过这个问题......直到现在，就是这样。"], multiple=True)
    add_dialogue("free_flirt_sex_act indifferent", ("pet", "helper"), ["她想了一会儿.", "g: 只要能让你开心的事，我就喜欢！"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_act interested", ("pet", "bimbo"), ["她笑得合不拢嘴。", "g: 哦，是的，绝对！你想让我详细说一下吗？"], multiple=True, love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("pet", "bimbo"), ["她笑了。", "g: 天啊，是的....我要给你现场演示吗？"], multiple=True, love=2)
    add_dialogue("free_flirt_sex_act very interested", ("pet", "bimbo"), ["她开始流口水。", "g: 天啊，我太喜欢这个了...."], multiple=True, love=3, sound=s_mmh)
    add_dialogue("free_flirt_sex_act fascinated", ("pet", "pervert"), ["她突然将一只手伸进大腿之间，开始抚摸自己。", "g: 天哪，[MC.name]。光是想想就让我湿透了...."], multiple=True, love=3, sound=s_mmh)

    add_dialogue("free_give_gold +++", ("pet", "meek"), ("太谢谢你了，你也太好了！我不值得这一切。"), love=8, max_cap=75)
    add_dialogue("free_give_gold ++", ("pet", "meek", "creep"), ("非常感谢你，[MC.name]。"), love=5, max_cap=75)
    add_dialogue("free_give_gold +", ("pet", "loyal", "masochist"), ("谢谢...您想要什么回报吗？"), love=3, max_cap=75)
    add_dialogue("free_give_gold -", ("pet", "meek", "masochist"), ("我真的不需要这个..."), love=1, max_cap=75)
    add_dialogue("free_give_gold --", ("pet", "meek", "masochist"), ("我很困惑...你凭什么认为我想要你的第纳尔？"), love=-2, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("pet"), ["她紧紧地握住你的手。", "g: 谢谢你，[MC.name]。你真的看到了我的潜力，不是吗？", "g: 在这座危险的城市里，危险潜伏在每个角落。我晚上彻夜难眠，害怕会发生什么。", "g: 想到永远在你身边，在你怀里安全....这确实是一个诱人的提议。"], multiple=True, love=2)
    add_dialogue("free_offer_job half_lie", ("pet"), ["g: 你总是让人惊叹，[MC.name]！", "mc: 嗯，这确实没什么大不了的......", "g: 你应该早点告诉我。我有很多问题！"], multiple=True, love=4)
    add_dialogue("free_offer_job lie", ("pet"), ["g: 什-什么？", "g: 你怎么能骗我....我信任你！", "mc: 对不起，[girl.name]。我应该早点告诉你的。", "g: 噢，我不能生你的气....", "g: 说实话，成为你的财产的想法在某种程度上让我兴奋......"], multiple=True, love=5)
    add_dialogue("free_offer_job success", ("pet"), ["g: 无论你去哪里，我都会跟着。", "g: 无论需要什么，我都会陪在你身边。"], multiple=True)
    add_dialogue("free_offer_job thinking", ("pet"), ["g: 啊啊....这让我头疼....", "g: 我做不到！肯定还有别的办法....", "她开始哭泣。"], multiple=True)
    add_dialogue("free_offer_job failure lie", ("pet"), ["g: 你就是个变态的王八蛋，你知道吗？", "g: 我很佩服你。如果你问的话，我会帮你舔地板。现在...", "g: 你是说你已经拥有一群听从你命令的女孩了？我以为我对你来说很特别！", "她怒气冲冲地走了。", "mc: 她会过来的...."], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("pet"), ["g: 你到底把我当什么？", "g: 仅仅因为我钦佩你，并不能使我成为你的出租小混蛋之一！", "g: ....操！", "她强忍着泪水走开。", "mc: Rentable Cumbuckets 听起来不错....我必须记住这个名字，以防我厌倦了[brothel.name]。"], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("pet"), ["g: 太棒了....原来女孩们都是你的财产，她们必须听从你的一切命令....", "mc: 嗯，是的，就是这个想法。", "g:  令人着迷！"], multiple=True, love=3)
    add_dialogue("free_friend half_lie", ("pet"), ["g: 啊，一个[MC.playerclass]！告诉我更多！", "mc: 我真的不想让你厌倦这些细节......你自己呢？", "g: 呃，没人关心我....不过，你不会每天都看到[MC.playerclass]。"], multiple=True, love=2)
    add_dialogue("free_friend lie", ("pet"), ["g: [lie]？我有很多问题。", "mc: 啊，关于我的事就够了。你做什么工作？", "g: 我想你可以说我仍在寻找目标...."], multiple=True, love=-5)

    add_dialogue("free_love_interest", ("pet"), ["mc: 嗨，[girl.name]。一切都好吗？", "g: [MC.name]！我真的很想念你...", "g: 我们应该出去玩。有什么我可以为您做的吗？", "g: 我可以给你喝一杯......或者我可以给你按摩......任何你喜欢的！", "g: 每当你离开的时候我真的很想念你...但幸好现在你又来了，我的生活就像春天来了一样！", "mc: 嘘，[girl.name]。你有点太强势了。从现在起你为什么不让我来领导呢？"], multiple=True)
    add_dialogue("free_girl get_flowers", ("pet"), ("你是最棒的，[MC.name]！我爱他们！"))
    add_dialogue("free_ask_out", ("pet"), ["mc: [girl.name]，你对我很重要。我想你成为我生活的一部分。", "g: 你想让我...做你的女朋友?", "mc: 没错.", "g: 我非常爱你！", "她扑进你的怀抱，给你一个又长又深的吻.", "g: 我得走了。我需要与大家分享这个好消息！"], multiple=True)

    add_dialogue("free_girlfriend intro", ("pet"), ["g: [MC.name]！过来这里...", "mc: [girl.name]？怎么了？", "g: 嗯，我一直在想....你想让我给你脱衣服吗？", "mc: 当然，为什么不呢！", "g: *咯咯* 那么是时候进行小测验了。您必须首先回答以下出奇简单的问题！ *傻笑*"], multiple=True)
    add_dialogue("free_girlfriend right", ("pet"), ("出色的！现在，为了你的精美奖品....我！"), love=5)
    add_dialogue("free_girlfriend give_up", ("pet"), ("什、什么意思....别再这样取笑我了！"), love=-5)
    add_dialogue("free_girlfriend wrong", ("pet"), ["g: 非常有趣[MC.name]...*疯狂*", "g: 我猜你只是对这个奖品不感兴趣？"], multiple=True, love=-10)
    add_dialogue("free_girlfriend success", ("pet"), ["她笑了，开始脱衣服。", "g: 你觉得你的奖品怎么样？", "她用手指抚摸着自己的身体，然后四肢着地，在你面前爬来爬去。", "g: 那你觉得怎么样？主人，我是个好女孩吗？ *傻笑*"], multiple=True, sound=s_dress)
    add_dialogue("free_girlfriend success naked", ("pet"), ["她松了口气，迅速脱掉衣服。", "g: 我应该早点做这件事。得到你的全神贯注让我很高兴。", "g: 说实话，我希望我能一直裸体！", "g: 但是然后每个人都会盯着我看并打扰我......你是我唯一想要的。", "g: 我的这个身体....是你的了，随意处置！ *傻笑*"], multiple=True, sound=s_sigh)

    add_dialogue("free_job_request", ("pet"), ["g: 哦，[MC.name]。我陷入困境...请听我说完，你总是知道该怎么做。", "mc: 这是什么，[girl.name]？你知道你可以随时跟我说话。", "g: 我、我破产了....而我的房东，他把我赶了出去....", "g: 我真的需要一个地方住下，或者一份好工作让我重新站起来......", "她看起来很绝望。", "mc: 别担心，[girl.name]。我确信我们可以一起想出一些办法。我会帮你的。", "g: 非常感谢您，我知道我可以依靠您的帮助。你是最棒的，[MC.name]！"], multiple=True)
    add_dialogue("refuse farm", ("very sub"), ["主人，求你了，别把我丢给那个神经病女精灵...", "但-但-但是...我不想去农场....那是个可怕的地方...", "哦，主人，我做了什么让你不高兴的事?"])
    add_dialogue("gizel take girl to farm", ("pet"), ("哎呀....我想我会永远把它和其他小黄人一起关在围栏里。"))
    add_dialogue("slave negative reaction", ("generic"), ["嘿！这个是来做什么的！", "不，主人！为什么？？？", "等等，那是干什么的？！？", "但是，主人....为什么？？？"])
    add_dialogue("slave bullied", ("very materialist"), ["...", "好吧，我明白..."])
    add_dialogue("slave fear intro", ("generic"), ("当你靠近时，她因恐惧而畏缩，她的眼睛因惊慌而困惑。她没有能力回答你的问题。"))
    add_dialogue("slave fear reassure success", ("generic"), ("她稍微放松了一些，似乎终于明白了你话里的意思。"), love=1, fear=-2)
    add_dialogue("slave fear reassure failure", ("generic"), ("她颤抖着摇着头，看上去太害怕了，无法回答你。最终，你放弃了。"), fear=-1)
    add_dialogue("slave fear discipline", ("generic"), ("你一巴掌打在她脸上。泪水从她的脸上流下来，她现在因恐惧而颤抖。尝试与她交谈是没有用的。"), fear=1)
    add_dialogue("slave chat well_being -3", ("generic"), ("我感觉很糟糕。我想离开这里。求求你了，主人，不要就这样离开我....*呜咽*"), unlock="MI")
    add_dialogue("slave chat well_being -2", ("generic"), ("我感觉不太舒服。这个地方实在是太拖累我了...."), unlock="MI")
    add_dialogue("slave chat well_being -1", ("generic"), ("哼，我不能说我在这里感觉很好。这不是一种舒适的生活。"), unlock="MI")
    add_dialogue("slave chat well_being 0", ("generic"), ("我想，我还好。"), unlock="MI")
    add_dialogue("slave chat well_being 1", ("generic"), ("我在这里很开心。请继续好好照顾我，主人."), unlock="MI")
    add_dialogue("slave chat well_being 2", ("generic"), ("我在这里很开心，主人。我想要改变的事情很少。"), unlock="MI")
    add_dialogue("slave chat well_being 3", ("generic"), ("我喜欢在这里工作，主人。我尽可能地感到舒适和快乐！"), unlock="MI")
    add_dialogue("slave chat well_being attacked", ("generic"), ("在过去的一个月里，我遭到攻击和伤害 [nb_times] 次。那太糟糕了。请保护我们吧，主人！"))
    add_dialogue("slave chat well_being sick", ("generic"), ("过去一个月我生病了 [nb_times] 次。这并不令人愉快。 [MC.name] 主人，请确保这个地方始终干净。"))
    add_dialogue("slave chat well_being exhausted", ("generic"), ("过去一个月，我因过度劳累而感到疲惫不堪[nb_times]。我太累了...请确保我的日程安排合理，[MC.name]主人..."))
    add_dialogue("slave chat well_being MC apology", ("pet","very idealist"), ("我明白。我会尝试忍受它。"))
    add_dialogue("slave chat feelings very disobedient", ("very sub"), ("虽然我是奴隶，但我不准备接受你的命令。"), unlock="DS")
    add_dialogue("slave chat feelings disobedient", ("very sub"), ("不过，我是奴隶，所以我会听从你的指示，只要它们是合理的。"), unlock="DS")
    add_dialogue("slave chat feelings a little obedient", ("very sub"), ("无论如何，我还是你的奴隶。请照顾我。"), unlock="DS")
    add_dialogue("slave chat feelings obedient", ("very sub"), ("我尊敬您作为我的主和主人。"), unlock="DS")
    add_dialogue("slave chat feelings very obedient", ("very sub"), ("我喜欢为您服务，主人。我是你忠实的仆人。"), unlock="DS")
    add_dialogue("slave chat tastes likes", ("pet", "helper", "loyal"), "嗯，我最近做了一个梦，世界上唯一的[thing_cn]是[best]。你喜欢[best]吗？", unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("pet", "helper", "masochist"), ("嗯，我不喜欢的一件事是[worst]。但——但也许我只是需要热身一下。你觉得[worst]怎么样？", "嗯....说到[thing_cn]，你觉得[worst]的是什么？", "[MC.name]，你对作为[thing_cn]的[worst]有何看法？"), unlock="LM")
    add_dialogue("slave chat origins 1", ("pet", "helper", "meek"), ("呃，我的故事没那么有趣....我来自[girl.origin]。", "我只是一个来自[girl.origin]的普通女孩....那么你呢？", "我来自[girl.origin]。关于我的事情已经说完了，让我们来谈谈你吧！"), unlock="EI")
    add_dialogue("slave lecture love", ("pet", "very introvert"), ("噢，主人....*脸红*"))
    add_dialogue("slave lecture neutral", ("very sub"), ("我在听，主人。"))
    add_dialogue("bought", ("generic"), ("请善待我，主人。"))
    add_dialogue("freed", ("masochist", "pet"), ("不！别让我走...我需要一个主人..."))
    add_dialogue("sold", ("generic"), ["...", "这次就再见了，那么....", "主人，我这就去...."])
    add_dialogue("sold love", ("generic"), ["但、但是，主人！我...我爱你...*抽泣*", "不，主人！我想和你在一起... *抽泣*"], sound=s_surprise)
    add_dialogue("leave for quest", ("generic"), ("主人，我走了。很快再见。"))
    add_dialogue("leave for class", ("generic"), ("主人，我走了。很快再见。"))

## START CLASS PRESIDENT DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("class president"), ("向您问好，[MC.name] 先生。我是[girl.fullname]。事实上，有件事....你介意参加一场关于生命意义的哲学讨论吗？ *微笑*", "哦，终于是一个有礼貌的人了；我没想到赞里还有你这种人。哦，但是我的在哪里！我是[girl.fullname]。很高兴见到你。 *微笑*", "你真是个绅士。 [girl.fullname]，随时为您服务。 *微笑*"), love=3)
    add_dialogue("free_greetings_casual", ("class president"), ("你好，[MC.name] 先生。我是[girl.fullname]。您介意参加一项关于 昙山 生活质量的调查吗？ *微笑*", "哦，终于是一个不粗鲁的人了；我没想到泽恩里还有你这种人。哦，可是我的礼貌呢！我是[girl.fullname]。很高兴见到你。 *微笑*", "你还算顺利。 [girl.fullname]，随时为您服务。"), love=3)
    add_dialogue("free_greetings_rude", ("class president"), ("我的名字是[girl.fullname]。它是什么？时间有限，如果您能尽快完成，我将不胜感激。", "让我们看看今天下午我安排了什么...嗯？我是[girl.fullname]。你需要我做点什么吗？快一点。", "我的名字是[girl.fullname]，但我认为与你互动没有任何价值。再见。", "我是[girl.fullname]。你让我很恼火。再见。", "我的名字是[girl.fullname]。如果你不浪费我的时间，我会更喜欢它。"), love=-3)

    add_dialogue("free_small_talk", ("class president", "loyal"), ("我也是这么想的", "这只是常识。", "当然，你是对的。"), love=1, max_cap=25)
    add_dialogue("free_gossip", ("class president", "stubborn", "repressed"), ("我不是一个喜欢八卦的人，但我听到了一些很奇怪的事情......", "我不想把时间浪费在这些胡言乱语上，所以我会简短地说......"), max_cap=25)
    add_dialogue("free_chat_life", ("class president"), ("一个有趣的询问。你想要我的意见吗？具体是在哪一方面呢？", "我常常想，身体是否是人类有一天会抛弃的肉监狱，你不这么认为吗？", "我也有兴趣听听你的想法。让我们来一场哲学辩论吧。"), love=3, max_cap=25)
    add_dialogue("free_chat_love", ("class president", "nerd"), ("说实话，我想我从来没有恋爱过。这让我得出结论：它很可能不存在。", "我也有兴趣听听你的想法。但到目前为止，我的生活并没有让我感到鼓舞。", "我仍然觉得整个概念有很多难以理解的地方。"), max_cap=25)
    add_dialogue("free_chat_origins", ("class president"), ("我很高兴你问了。我会让你知道我的家人在 [girl.origin] 受到高度尊重。", "我的婴儿床位于 [girl.origin]。但像这样的大城市提供的机会是无与伦比的。", "我在 [girl.origin] 度过了愉快的时光。但可惜的是，像我这样有才华的女孩应该去最好的学校，这样的学校只有在像这样的大城市才能找到。"), love=2, max_cap=40)
    add_dialogue("free_chat_hobbies", ("class president", "loyal", "holy"), ("虽然我不喜欢把时间浪费在这些追求上，但我必须承认[hobby]是相当放松的。"), max_cap=40)
    add_dialogue("free_chat_likes", ("class president", "nerd"), ("口味无法解释，但我最喜欢的[thing_cn]是[best]。", "我最近读了一篇关于[thing_cn]理论的研究，证实[best]就是最好的[thing_cn]。"), max_cap=40)
    add_dialogue("free_chat_dislikes", ("class president", "nerd"), ("我不太能解释为什么，但我厌恶[thing_cn][worst]。", "我最近听了一场关于[thing_cn]理论的讲座，该理论推测[worst]是一种劣等[thing_cn]。"), love=2, max_cap=40)

    add_dialogue("free_joke_harmless", ("class president", "prude"), ("一句幽默的话，虽然我确实觉得它有点衍生。"), love=1, max_cap=50)
    add_dialogue("free_joke_adult", ("class president"), ("接下来是什么，小幽默？", "我猜你是那些认为自己放屁很幽默的人之一？"), love=-1, max_cap=50)
    add_dialogue("free_joke_dark", ("class president", "nerd"), ("*笑*我喜欢诸如此类的尖锐观察。", "啊哈哈哈！！非凡的。", "啊哈哈！非常有创意。"), love=5, max_cap=50)
    add_dialogue("free_joke_mean", ("class president"), ("我看不到有趣的一面。", "你想侮辱我吗？", "我不确定我应该笑还是哭。"), love=-1, max_cap=50)

    add_dialogue("free_touch_hand", ("class president", "nerd"), ("*脸红*啊，牵着手。我....一直想做这个。", "*脸红*我认为我们是一对很好的情侣，不是吗？"), love=4, max_cap=90)
    add_dialogue("free_touch_kiss", ("class president", "sweet"), ("*脸红* 嗯嗯...", "嗯嗯....啊...."), love=4, max_cap=90)
    add_dialogue("free_touch_ass", ("class president", "prude"), ("*喘气*这真的让我跳了起来。", "*喘气*哦，乖一点！"), love=1, max_cap=90)
    add_dialogue("free_touch_breasts", ("class president", "prude"), ("我很想知道为什么你对我的胸部表现出如此大的兴趣。请赐教。", "确切地告诉我你对我的乳房有什么如此着迷的地方。我不明白。"), love=-1, max_cap=90)
    add_dialogue("free_touch_pussy", ("class president"), ("*凝视*我现在就停下来，除非你想让我尖叫求救。", "少即是多。请思考一下这个成语。行动前请三思。"), love=-1, max_cap=90)

    add_dialogue("free_play refuses", ("class president", "nerd"), ("啊!我向你们明确表示，我绝对不会做这种卑鄙的事！"), love=-1)
    add_dialogue("free_play very reluctant", ("class president", "nerd", "bimbo"), ("*悲伤*D-我们必须这样做吗？嗯....至少我们中的一个人会感觉很棒。"), love=1)
    add_dialogue("free_play reluctant", ("class president", "nerd", "stubborn"), ("*叹气*从你脸上好色的表情来看，我不可能说服你不要这么做。"), love=2)
    add_dialogue("free_play a little reluctant", ("class president", "nerd", "meek"), ("什么？好、好吧，我们来实验一下。"), love=2)
    add_dialogue("free_play indifferent", ("class president", "nerd", "meek"), ("B、温柔点...."), love=3)
    add_dialogue("free_play a little interested", ("class president"), ("什么？！你确实是个变态。话又说回来，我不能否认我很感兴趣。"), love=4)
    add_dialogue("free_play interested", ("class president", "nerd"), ("嗯....只要你温柔....就会让我感受到被爱。"), love=4)
    add_dialogue("free_play very interested", ("class president", "nerd"), ("是的！我为此学到了一项新技术。 *脸红*想尝试一下吗？"), love=5)
    add_dialogue("free_play fascinated", ("class president", "nerd"), ("*呻吟* Y-是的。我光是想想就被欲望所征服，这很奇怪吗？不....这很正常。完全正常。"), love=5)
    add_dialogue("MC take virginity", ("class president"), ["g: 这、这就是成为一个人的意义....", "g: 我相信大多数人都不会忘记他们的第一次。所以...你将永远在我心中占有特殊的位置。"], multiple=True, love=5)
    add_dialogue("free_play interested after", ("class president"), ("那就特别有趣了！让我们更频繁地尝试一下。"))
    add_dialogue("free_play not interested after", ("class president"), ("*叹气*你让我失望了。"))

    add_dialogue("free_flirt_beauty", ("class president", "sweet"), ("什-什么？别盯着我看。太丢脸了。"), max_cap=75)
    add_dialogue("free_flirt_body", ("class president", "nerd"), ("如果我们能用一个简单的眼神就能读懂彼此的想法，我会很高兴。想要破坏我的想法吗？你打扰我了。", "*叹气*...现在，你的脸和裤子上的凸起都不应该在公共场合出现。控制住自己，不然我会生气的。"), love=-1, max_cap=75)
    add_dialogue("free_flirt_mind", ("class president", "schemer"), ("*微笑*我很高兴得到这样的赞美。", "我并不特别，我只是觉得你有点慢。 *笑*但是还是谢谢你。"), love=5, max_cap=75)
    add_dialogue("free_flirt_spirit", ("class president"), ("呵呵。我做了什么事情才赢得这个赞扬吗？"), love=1, max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("class president"), ["g: 是的，我认为自己是该领域的专家。", "g: 你想看一下我的笔记吗？我仔细记录了我的所有发现。"], multiple=True, love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("class president"), ("是的，我相信我在这方面研究得比较透彻。什-什么？这是生活中至关重要的一部分，不是吗？"), love=2)
    add_dialogue("free_flirt_sex_experience average", ("class president"), ("我认为我的性生活相对普通，与其他女孩相比。"), love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("class president"), ("我、我有过一个伴侣，但是....事情进展得不太顺利。"))
    add_dialogue("free_flirt_sex_experience very inexperienced", ("class president"), ("呃....我、我有过一个伙伴，但是....他似乎对这种事情不太感兴趣。"), love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("class president"), ("我在这些事情上一直无法获得任何经验。要是有人陪我练习就好了...."), love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("class president"), ("这是可以理解的。生活中还有其他方面比这些琐事更重要。"), love=5)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("class president"), ("这是一个明显的谎言，但可以被原谅。在与异性打交道时，人类倾向于让自己的本能和性欲战胜自己。"), love=1)

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("class president"), ("实践对于所有事情都很重要。从这个意义上来说，胡闹并没有什么可耻的。这样的培训非常有益。"), love=4)
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("class president"), ("这是一个明显的谎言，但可以被原谅。在与异性打交道时，人类倾向于让自己的本能和性欲战胜自己。"), love=1)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("class president"), ("请记住，它不应该成为您的主要动机。其他更重要的事情优先。"), love=1)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("class president"), ("那是可恶的！它永远不应该成为你的主要动机。其他更重要的事情优先。"), love=-1)
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("class president"), ("*叹气*明显的谎言。在与异性打交道时，人类倾向于让自己的本能和性欲战胜自己。你应该做得更好。"), love=-1)
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("class president"), ("哇，我想从这个意义上来说你是个异类。从消极的角度来说，就是这样。"), love=-1)

    add_dialogue("free_flirt_sex_act refuses", ("class president", "stubborn", "nerd"), ("嘎！什、为什么你会....我不必回答这个问题！"))
    add_dialogue("free_flirt_sex_act very reluctant", ("class president", "nerd"), ("我对此没有兴趣。", "花时间做这样的事情不会带来任何有用的东西。"))
    add_dialogue("free_flirt_sex_act reluctant", ("class president", "nerd"), ("我-我是人类，就像其他人一样。别、别对我傻笑了，你这个混蛋！"))
    add_dialogue("free_flirt_sex_act a little reluctant", ("class president"), ("我-我不是说不，但你确实需要学习如何实现这些目标。从我的角度考虑一下。"))
    add_dialogue("free_flirt_sex_act indifferent", ("class president", "nerd"), ("我、我是笼统地说，明白吗？是的，是的，我相信大多数（如果不是全部）女孩都会这样做。"), love=1)
    add_dialogue("free_flirt_sex_act interested", ("class president"), ("O-One 在寻求知识时无法挑选。性只是必须探索的知识的一个分支。"), love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("class president"), ("我-我愿意。如果我没有探索任何知识分支，包括性感，我会感到羞愧。"), love=2)
    add_dialogue("free_flirt_sex_act very interested", ("class president"), ("是-是的。这是我最敏感的行为之一......"), love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("class president"), ["g: *呻吟*达到高潮对我来说是最佳选择......", "g: *脸红* N-自然地，我已经考虑了我可以使用的所有工具来弄清楚如何才能最好地感到高兴。"], multiple=True, love=3)

    add_dialogue("free_give_gold +++", ("class president", "repressed"), ("非常感谢。我一定会慷慨地奖励你的这种行为。"), love=4, max_cap=75)
    add_dialogue("free_give_gold ++", ("class president", "schemer"), ("谢谢。我得考虑如何奖励你的这种行为。"), love=3, max_cap=75)
    add_dialogue("free_give_gold +", ("class president", "loyal", "generic"), ("谢谢。我会好好利用它的。"), love=1, max_cap=75)
    add_dialogue("free_give_gold -", ("class president", "stubborn", "sweet"), ("如果你不介意的话，我宁愿用自己的两只脚站立。"), love=-1, max_cap=75)
    add_dialogue("free_give_gold --", ("class president", "helper", "prude"), ("你想在这里发出什么信号？我要求一个解释。"), love=-1, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("class president"), ["她看起来很困惑。", "g: 我对你有什么用？这样的工作对我的技能没有丝毫好处。", "mc: 你会感到惊讶的。这项工作需要大量的专业精神和情商。凭借你的分析头脑，你很快就能成为明星。", "mc: 最重要的是，你也不是一个坏人！不要低估自己。"], multiple=True, love=1)
    add_dialogue("free_offer_job half_lie", ("class president"), ["她看起来很生气。", "g: 我不是妓女，[MC.name]！我不知道你怎么看我，但那不是我！", "mc: 我知道你可能不符合这种刻板印象，但谁符合呢？您将可以自由地以自己的方式发光发热。","g: 哼....我对你有什么用？这样的工作对我的技能没有丝毫好处。", "mc: 你会感到惊讶的。这项工作需要大量的专业精神和情商。凭借你的分析头脑，你很快就能成为明星。", "mc: 最重要的是，你也不是一个坏人！不要低估自己。"], multiple=True, love=-3)
    add_dialogue("free_offer_job lie", ("class president"), ["她看起来很生气。", "g: 我不是妓女，[MC.name]！我不知道你怎么看我，但那不是我！", "mc: 我知道你可能不符合这种刻板印象，但谁符合呢？您将可以自由地以自己的方式发光发热。","g: 哼....我对你有什么用？你只是想要无意识的奴隶。这样的工作对我的技能没有丝毫好处。", "mc: 你会感到惊讶的。这项工作需要大量的专业精神和情商。凭借你的分析头脑，你很快就能成为明星。", "mc: 最重要的是，你也不是一个坏人！不要低估自己。"], multiple=True, love=-4)
    add_dialogue("free_offer_job success", ("class president"), ["g: 也许你是对的。只要有足够的奉献精神，我就能掌握它并擅长它。", "mc: 这就是精神！让我向您介绍我的助理希露，她会确保您能够顺利开展工作。"], multiple=True)
    add_dialogue("free_offer_job thinking", ("class president"), ["g: 也许你是对的。只要有足够的奉献精神，我就能掌握它并擅长它。", "g: 但我还没准备好扣动扳机....我需要仔细考虑一下。"], multiple=True)
    add_dialogue("free_offer_job failure lie", ("class president"), ["她看起来仍然很愤怒。", "g: 抛开你对我撒谎的事实....仅仅因为你的大脑在你的裤子里并不意味着我的大脑也应该在你的裤子里。", "g: 我可以列出很多我可以下定决心做的其他事情。你的建议绝对是我放在该清单上的最后一件事。","让我们在事情进一步升级之前结束这次谈话吧。"], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("class president"), ["她看起来仍然很愤怒。", "g: 仅仅因为“你的”大脑在你的裤子里，并不意味着我的大脑也应该在裤子里。", "g: 我可以列出很多我可以下定决心做的其他事情。你的建议绝对是我放在该清单上的最后一件事。", "让我们在事情进一步升级之前结束这次谈话吧。"], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("class president"), ["g: *叹气*你兜售这样的变态难道不感到羞耻吗？", "mc: 不能说我是。你做什么工作？", "g: 噢，我还没有参加工作...."], multiple=True, love=-5)
    add_dialogue("free_friend half_lie", ("class president"), ["g: 我明白了。致力于更大更好的事情？", "mc: 希望如此。你做什么工作？", "g: 噢，我还没有参加工作...."], multiple=True, love=3)
    add_dialogue("free_friend lie", ("class president"), ["g: 这有点令人失望....给我一些野心吧！", "mc: 那你做什么？", "g: 噢，我还没有参加工作...."], multiple=True, love=2)

    add_dialogue("free_love_interest", ("class president"), ["mc: 嗨，[girl.name]。你要做什么？", "g: 啊，好吧....我的爱好之一是观察人们。我对一些不稳定的人类行为特别感兴趣。", "g: 举个例子，我只是看着情侣接吻、牵手。直到最近，这些手势总是让我感到困惑。", "mc: 你说直到最近？","g: 嗯....嗯，是的....以前我一直不明白，但最近我认识了一个让我以不同的方式看待世界的人。 *脸红*", "mc: 我明白了。有趣的！", "g: 是的，是的，确实如此。突然间有这么多新的途径需要考虑...*低语*L型鲜花、拥抱、礼物、亲密、异地婚姻...", "mc: 抱歉，我听不到你的声音。你能再说一遍吗？", "g: 哦，不、不，没什么！ *脸红*"], multiple=True)
    add_dialogue("free_girl get_flowers", ("class president"), ("啊，多么可爱的安排啊！我凭什么得到这份快乐？"))
    add_dialogue("free_ask_out", ("class president"), ["mc: [girl.name], 我喜欢你。让我们在一起.", "g: 你想让我...成为你的搭档吗？", "mc: 没错.", "g:  哎呀，我会很高兴的！是的！", "她扑进你的怀抱，给你一个又长又深的吻.", "g: 我现在得走了....但很快就会见到你，[MC.name]！ *眨眼*"], multiple=True)

    add_dialogue("free_girlfriend intro", ("class president"), ["g: 很高兴见到你，[MC.name]。我正准备为即将到来的考试做准备。我觉得你是一个理想的学习伙伴。", "mc: 嗨，亲爱的。主题是什么？", "g: *咯咯*这是解剖学。但在我们开始之前，让我先测试一下您对不同主题的了解。", "mc: 好的，带上吧。"], multiple=True)
    add_dialogue("free_girlfriend right", ("class president"), ("你是对的。跟我来。我们找个安静的地方学习吧。"), love=5)
    add_dialogue("free_girlfriend give_up", ("class president"), ("*皱眉*零分。你失败了。"), love=-5)
    add_dialogue("free_girlfriend wrong", ("class president"), ("*皱眉*零分。你失败了。我没想到会如此失望。"), love=-10)
    add_dialogue("free_girlfriend success", ("class president"), ["一旦你们两个找到一个僻静的地方，[girl.name]就开始脱衣服。她一边这样做，一边整齐地叠好衣服。", "g: *叹气*从你脸上好色的表情来看，你在想不正当的想法。正确的？", "mc: 在这种情况下。这是很自然的。只要看看你，你就很美！", "g: *脸红*谢谢....现在，如果您能好心的话，请脱掉衣服。", "你连忙答应。她好奇地看着你半充血的鸡巴。", "g: 我发现它还没有完全直立。那么，我们是不是应该从研究女性解剖学开始呢？", "她在桌子上站起来，将她的小穴摊开在你面前。", "g: 如你所见，这里是大阴唇和小阴唇，这里是阴蒂....啊！我看到男性对象已经准备好接受检查了....", "她停下手头的事情，急切地开始检查你勃起的阴茎。", "g: 抱歉，几个月来我一直在彻底研究我自己的小穴。这个器官更有趣。", "g: 啊，有一条系带连接着龟头，很有趣！让我们看看它对刺激有何反应，好吗？", "你花了一点时间和[girl.name]一起学习。"], multiple=True)
    add_dialogue("free_girlfriend success naked", ("class president"), ["一旦你们两个找到一个僻静的地方，[girl.name]就开始脱衣服。她一边这样做，一边整齐地叠好衣服。", "g: *叹气*从你脸上好色的表情来看，你在想不正当的想法。正确的？", "mc: 在这种情况下。这是很自然的。只要看看你，你就很美！", "g: *脸红*谢谢....现在，如果您能好心的话，请脱掉衣服。", "你连忙答应。她好奇地看着你半饱的鸡巴。", "g: 我发现它还没有完全直立。那么，我们是不是应该从研究女性解剖学开始呢？", "她在桌子上站起来，将她的小穴摊开在你面前。", "g: 如你所见，这里是大阴唇和小阴唇，这里是阴蒂....啊！我看到男性对象已经准备好接受检查了....", "她停下手头的事情，急切地开始检查你勃起的阴茎。", "g: 对不起，我一生都在彻底研究我自己的小穴。你的器官更有趣。", "g: 我和我的母亲在家里总是赤身裸体，但我的父亲通常穿着衣服，所以我对男性解剖学的大部分了解纯粹是理论性的。", "g: 啊，有一条系带连接着龟头，很有趣！让我们看看它对刺激有何反应，好吗？", "你花了一点时间和[girl.name]一起学习。"], multiple=True)

    add_dialogue("free_job_request", ("class president"), ["g: 噢，[MC.name]，可怕的消息....*抽泣*", "mc: [girl.name]，发生什么事了？", "g: 这是我的学校....警卫突击搜查了这个地方，发现我们的炼金术课程是泽恩的大部分非法毒品交易的罪魁祸首。", "g: 现在他们已经关闭了{i}整个{/i}学校，包括所有其他课程。这太糟糕了！", "g: 我和那些炼金术课程没有任何关系，但我的学术生涯却受到玷污和诽谤。这不公平！！", "她突然哭了起来.", "g: 哦，我该怎么办！ *呜咽*没有其他学校会录取我！我得找份工作了...", "mc: [girl.name] 冷静点，我们会找到解决办法的..."], multiple=True)
    add_dialogue("gizel take girl to farm", ("class president"), ("现在就走吧，愚蠢的母狗。没有人关心你的痛苦。"))
    add_dialogue("MC fair promise", ("generic"), ["她看上去警惕心少了一些。", "g: 我明白了。"], multiple=True, love=2, fear=-1)
    add_dialogue("slave chat tastes likes", ("class president", "nerd"), ("口味无法解释，但我最喜欢的[thing_cn]是[best]。", "我最近读了一篇关于[thing_cn]理论的研究，证实[best]就是最好的[thing_cn]。"), unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("class president", "nerd"), ("我不太能解释为什么，但我厌恶[thing_cn][worst]。", "我最近听了一场关于[thing_cn]理论的讲座，该理论推测[worst]是一种劣等[thing_cn]。"), unlock="LM")
    add_dialogue("slave chat origins 1", ("class president"), ("我很高兴你问了。我会让你知道我的家人在 [girl.origin] 受到高度尊重。", "我的婴儿床位于 [girl.origin]。但像这样的大城市提供的机会是无与伦比的。", "我在 [girl.origin] 度过了愉快的时光。但可惜的是，像我这样有才华的女孩应该去最好的学校，这样的学校只有在像这样的大城市才能找到。"), unlock="EI")
    add_dialogue("slave reward sex accepted", ("very modest"), ("噢，主人。我们就像恋人......噢......*脸红*"), love=-1, sound=s_ahaa, unlock="LM")
    add_dialogue("slave reward praise", ("very idealist"), ("谢谢主人。我会让你感到骄傲。"), love=2, unlock="MI")
    add_dialogue("slave punish upkeep", ("class president", "very materialist"), ("工作没钱？噢，拜托！"), fear=-1, unlock="MI")
    add_dialogue("slave punish rape", ("very modest"), ("不！！！你以为你在做什么！！！"), fear=1, unlock="LM")
    add_dialogue("rest", ("generic"), ("我现在要休息了。{w=1.0}{nw}"))
    add_dialogue("accept job", ("generic"), ("我现在将担任{b}[girl.job_cn]{/b}，以满足客户的需求。{w=1.0}{nw}"))
    add_dialogue("work_whore", ("generic"), ("我现在将担任{b}[girl.job_cn]{/b}和妓女，以满足客户的需求。{w=1.0}{nw}"))
    add_dialogue("exhausted", ("generic"), ("对不起主人，我还是很累，需要多休息。  康复后，我将回去担任 {b}[girl.job_cn]{/b} 的工作。"))
    add_dialogue("rank up", ("generic"), ("谢谢主人。我现在是一名[newrank]奴隶。"))
    add_dialogue("refuse whoring", ("generic"), ("哇哦，没办法！！！我不是荡妇！"))
    add_dialogue("refuse sex act", ("generic"), ["我不会那样做！", "不行....不行！！！", "我....还没准备好。"])
    add_dialogue("beach accept sex", ("very modest"), ["g: 哦，主人！人们正在看着我们，但是...我的身体感觉很热...做你想做的...", "当你抓住她的臀部并将她靠近时，她喘息着。"])

    add_dialogue("beach whoring request", ("very idealist"), ["但你却给了我休息日！你不能就这样食言...."])
    add_dialogue("beach whoring accept", ("very modest"), ["噢，主人，您让我做的事情....好吧。"])
    add_dialogue("beach whoring refuse", ("very idealist"), ["不，这不是一个公平的交易。我需要休息。没有机会！"])

## START TSUNDERE DIALOGUE 03.February.2022

    add_dialogue("free_greetings_rude", ("tsundere", "stubborn"), ("我是[girl.fullname]。现在离开吧，免得我伤害你。"), love=-1)
    add_dialogue("gizel take girl to farm", ("tsundere"), ("好吧，奴隶荡妇，继续前进。我们去农场。"))
    add_dialogue("slave bullied", ("very dom"), ["什么？？？决不..."])

## START LOYAL DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("loyal", "sweet", "helper", "pet"), ("嗨，我是[girl.fullname]。不需要跟我这么正式！", "嗨，我是[girl.fullname]。我只是一个普通的女孩。不需要对我这么正式！ *咯咯笑*"), love=2)
    add_dialogue("free_greetings_casual", ("loyal", "sweet", "helper"), ("嗨，我是[girl.fullname]。你看起来不错！", "你好，我的名字是 [girl.fullname]。想说话吗？"), love=2)
    add_dialogue("free_greetings_rude", ("loyal", "repressed", "tsundere", "very modest"), ("好吧，如果不关你的事，我是 [girl.fullname]。我为什么要和你说话？", "这太粗鲁了！我是[girl.fullname]，我喜欢有礼貌的男人。", "太粗鲁了！我是[girl.fullname]。你想要什么？"), love=-1)

    add_dialogue("free_small_talk", ("loyal", "generic", "very idealist", "prude"), ("你可以再说一遍！", "既然你提到了，我想你也可以这么说！", "嗯，是的，我想可能是这样。"), love=2, max_cap=25)
    add_dialogue("free_gossip", ("loyal", "sweet", "pervert", "very idealist", "class president"), ("昙镇总是有很多流言蜚语。街上流传着这样一句话：", "八卦吧？有很多八卦。你听说过吗？"), max_cap=25)
    add_dialogue("free_chat_life", ("loyal"), ["g: 有一首来自博尔戈的流行歌手的歌曲，它总结了我对生活的感受。你听说过吗？事情是这样的......*开始唱歌*", "g: {i}你可能来自Hokoma，或者来自Karkyyyr的法师，你可能是一个奴隶，或者一个迷失而孤独的女孩。{/i}", "g: {i}您可能是一名在愤怒中战斗的斗士，您可能拥有可以指挥的咒语，或者是战车中的怪物......{/i}", "g: {i}但你必须服务某人，哦，是的，你必须服务某人！{/i}", "g: 我认为这听起来是真的。我的意思是我们在这个世界上都有自己的位置。尽我们最大的能力尽自己的一份力量是我们的责任....而且总有人在我们之上....", "g: ....无论怎样，我们都必须为某人服务！", "mc: 这非常深，[girl.fullname]！", "mc: 如果你正在服役，我可能有一些想法......"], multiple=True, love=2, max_cap=25)
    add_dialogue("free_chat_love", ("loyal", "very idealist"), ("好问题。我认为恋人之间是有义务的...", "我正在寻找合适的人。当我找到他时，我的工作就是让他开心。让我快乐是他的工作。", "我相信我们在这个世界上都有自己的位置，我们必须尽力而为。如果我很幸运找到真爱，我的责任就是对他。"), max_cap=25)
    add_dialogue("free_chat_origins", ("loyal", "generic", "very idealist"), ("我来自[girl.origin]。", "我来自[girl.origin]。试图在泽恩取得成功。", "我来自[girl.origin]...而我现在就在这里。"), love=1, max_cap=40)
    add_dialogue("free_chat_hobbies", ("loyal", "class president"), ("我喜欢[hobby]，这很有趣。当我有时间的时候，当然...", "我认为工作比爱好更重要，但我喜欢[hobby]。", "我通常不会让空闲时间干扰我的职责，但当我有时间时我会享受[hobby]。", "我的[girl.story_guardian]总是说：先工作，然后玩耍。但一到玩的时候，我就喜欢[hobby]。"), max_cap=40)
    add_dialogue("free_chat_likes", ("loyal", "helper", "holy", "very idealist"), ("我最喜欢的[thing_cn]是[best]。", "让我想想...我可能没有充分考虑我真正喜欢什么，但是，既然你问了，我想我最喜欢的[thing_cn]是[best]。", "我最喜欢的东西？我倾向于把自己放在最后，但如果你真的想知道，我应该告诉你。我最喜欢的[thing_cn]是[best]。"), max_cap=40)
    add_dialogue("free_chat_dislikes", ("loyal", "helper", "meek", "very idealist"), ("是的，有些事情我不喜欢。例如，我真的不喜欢的一件[thing_cn]是[worst]！", "感谢您的询问，[MC.name]！很多人对我喜欢和不喜欢的东西不感兴趣。但你做了！我最不喜欢的[thing_cn]可能是[worst]。"), love=3, max_cap=40)

    add_dialogue("free_joke_harmless", ("loyal", "helper"), ("这....这真是太蹩脚了。", "这应该很有趣吗？", "可能还有比这更糟糕的笑话，但不多......", "我可能听过更糟糕的笑话，但现在想不出来......", "我通常会努力成为一个好的倾听者。我认为每个人都值得被倾听。但如果你的笑话没有进步，我可能就得走开了！"), max_cap=50)
    add_dialogue("free_joke_adult", ("loyal", "sweet"), ("哈哈，有趣....你的思想很肮脏。", "哈哈...天哪，这真是一个肮脏的笑话！"), love=1, max_cap=50)
    add_dialogue("free_joke_dark", ("loyal", "repressed", "class president", "sweet"), ("哈哈，太搞笑了！", "搞笑！我喜欢那些能看到一切事物阴暗面并嘲笑它的人！", "这是一个残酷的世界，但你却让我发笑这世界是多么的可笑！"), love=3, max_cap=50)
    add_dialogue("free_joke_mean", ("loyal", "sweet", "bimbo"), ("哦...严厉，但有趣！", "这很刻薄，但同时也很有趣！", "这确实很恶心，但我不介意..."), love=1, max_cap=50)

    add_dialogue("free_touch_hand", ("loyal", "sweet", "repressed", "helper", "generic"), ("太浪漫了！", "你的手感觉温暖....嗯。", "我很高兴你想握住我的手，[MC.name]。"), love=3, max_cap=90)
    add_dialogue("free_touch_kiss", ("loyal", "very sub", "masochist"), ("她会对你的吻做出回应。", "..嗯...", "她凝视着你的眼睛并回吻你。", "她回吻你并问：“这是你想要的吗？”"), love=2, max_cap=90)
    add_dialogue("free_touch_ass", ("loyal", "pet"), ("你喜欢我的屁股！", "哦，这就是你想要的！拍我屁股会让你开心吗？ *脸红*", "如果你喜欢打我，我的屁股很乐意履行职责......*咯咯地笑和扭动*", "哎呀....你打我屁股了！顽皮...*咯咯笑*"), love=3, max_cap=90)
    add_dialogue("free_touch_breasts", ("loyal", "nerd"), ("请不要碰我的胸部，你太过分了！", "请不要，我对那里很敏感......", "请不要碰我那里，[MC.name]。"), love=-1, max_cap=90)
    add_dialogue("free_touch_pussy", ("loyal", "sweet", "pet"), ("哦...你已经走得很远了，但我不介意！ *脸红*", "触摸我的小穴！我开始有心情了....", "我的小猫，随时为您服务。 *咯咯笑*", "触摸我，[MC.name]，我已经开始准备好了！"), love=2, max_cap=90)

    add_dialogue("free_play refuses", ("loyal", "sweet", "helper"), ("也许我应该这样做，但这确实感觉太不对劲了。", "我绝对不会这么做！"), love=-1)
    add_dialogue("free_play very reluctant", ("loyal", "very idealist"), ("所以，即使我没有心情，我也必须为你做这件事。"), love=1)
    add_dialogue("free_play reluctant", ("loyal", "meek"), ("我不太热衷，但如果你喜欢的话，阻止你是不公平的......"), love=2)
    add_dialogue("free_play a little reluctant", ("loyal", "meek"), ("好吧，如果你这么想要的话，我们可以试试。你一直对我很好。"), love=2)
    add_dialogue("free_play indifferent", ("loyal", "very idealist"), ("为什么不？ ... 这是你应得的。你想要怎样？"), love=3)
    add_dialogue("free_play a little interested", ("loyal", "pet"), ("如果你想要我的身体....我有什么资格拒绝呢？告诉我你有多喜欢它！ *微笑*"), love=4)
    add_dialogue("free_play interested", ("loyal", "very idealist"), ("你应得的，我的责任就是把我的身体给你......*眨眼*"), love=4)
    add_dialogue("free_play very interested", ("loyal", "helper"), ("哦，是的，我很乐意效劳。 *微笑*现在就带我去吧！"), love=5)
    add_dialogue("free_play fascinated", ("loyal", "helper"), ("哦，是的，我已经湿透了，很乐意效劳！ *微笑*"), love=5)
    add_dialogue("MC take virginity", ("loyal"), ("我 - 我 - 我....以前从来没有和任何人做过这样的事....", "你毁了我的贞操！现在我属于你了...", "从现在开始，我的职责就是和你一起做更多次。 *微笑*"), love=5)
    add_dialogue("free_play interested after", ("loyal", "sweet", "helper"), ("我真的很喜欢那个....太好了！ *脸红*"))
    add_dialogue("free_play not interested after", ("loyal", "sweet"), ("我做了我觉得我必须做的事....尽管我并不真正喜欢它。我希望你至少幸福。"))

    add_dialogue("free_flirt_beauty", ("loyal", "helper"), ("谢谢你，但我不相信我有你说的那么漂亮。", "我，美丽....不，我只是一个普通的女孩。", "谢谢，但我不确定你是否是真心的。", "我不认为你真的是这个意思。"), max_cap=75)
    add_dialogue("free_flirt_body", ("loyal", "helper"), ("这就是你所想的一切吗？我不仅仅是一块肉！", "你关心的只是我的身体。我早该知道...*悲伤*", "你一直在说我的好话，但现在看来你只想要我的身体。 *伤心*" ), love=-2, max_cap=75)
    add_dialogue("free_flirt_mind", ("loyal", "very idealist", "repressed", "sweet"), ("噢，{b}谢谢！{/b}这让我的一天充满了阳光！", "没有多少人对我说过这么好听的话！确实非常感谢你，[MC.name]！", "谢谢你，我很高兴你认为我很聪明！"), love=3, max_cap=75)
    add_dialogue("free_flirt_spirit", ("loyal", "very idealist"), ("哦谢谢！世界可能会让你沮丧，但我觉得女孩需要保持精神振奋！", "谢谢你！很高兴你注意到了！我正在努力让自己打起精神。我觉得这是我欠自己的。", "泽恩的街道可能是一个艰难的地方。我觉得保持精神振奋是我的责任！"), love=2, max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("loyal"), ("实话告诉你。是的，我和很多很多男人睡过！如果他们觉得我有吸引力，我觉得我应该答应....而且我也喜欢！ "), love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("loyal"), ("在你之前我已经睡过好几个男人了。如果一个男人真的想要它并且发现我很有吸引力，那么这感觉就像是正确的事情。就像你现在做的那样..."), love=2)
    add_dialogue("free_flirt_sex_experience average", ("loyal"), ("这有点个人化，但是是的，我以前和一些男人在一起过....如果一个男人真的想要它并且觉得我有吸引力，那么感觉这是正确的事情。就像你现在做的那样..."), love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("loyal"), ["她脸通红.", "g: 我试过了...我有过几个男朋友，但都没有达到我所希望的...", "g: ....你看，当我找到合适的男人时，我的责任就是对他负责，同时也是床上完美的女人....", "g: ....但到目前为止我还没有找到他！"], multiple=True)
    add_dialogue("free_flirt_sex_experience very inexperienced", ("loyal"), ["她的脸色变得苍白。", "g: 我不知道你在说什么！爱情和性对我来说都是严肃的事情......", "g: ....如果我找到了合适的人，我就有责任把我的一切都给他....", "g: ...但我并没有和任何人一起睡觉，你知道！"], multiple=True, love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("loyal"), ["g: 不！ *震惊*我还没有和任何人睡过。", "g: 当我找到合适的男人时，我的责任就是做一个好女人！我会为他保全我的童贞！"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("loyal"), ("听起来不错....我也在等合适的人！"), love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("loyal"), ("我不相信你，但也许我应该相信。"), love=1)

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("loyal"), ("啊....我本想成为你唯一的....但我会做任何让你开心的事！"), love=2)
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("loyal"), ("我不相信你。"))
    add_dialogue("free_flirt_sex_experience reply_been_around", ("loyal"), ("我认为这对男人来说是健康的！你的职责就是练习，这样你才能满足合适的女人。"), love=3)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("loyal"), ("那是....很多伙伴...."), love=1)
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("loyal"), ("你充满了热气... "))
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("loyal"), ("当然，你是青楼老板。别让我想起你有多恶心....*闷闷不乐*"), love=-1)

    add_dialogue("free_flirt_sex_act refuses", ("loyal", "meek"), ["她一脸不可置信地看着你....", "g: 细节太多了。我不想谈这个！"], multiple=True)
    add_dialogue("free_flirt_sex_act very reluctant", ("loyal", "helper", "meek"), ("太多细节了....为什么我们不谈谈别的事情呢？"))
    add_dialogue("free_flirt_sex_act reluctant", ("loyal", "meek"), ("我可以这样做，如果我真的觉得我必须这样做的话....但我不认为我会喜欢它...."))
    add_dialogue("free_flirt_sex_act a little reluctant", ("loyal", "meek"), ["*皱眉*", "g: ....如果我觉得有必要的话，我可能会尝试一下。", "g: 但这离我想做的还很远。"], multiple=True)
    add_dialogue("free_flirt_sex_act indifferent", ("loyal"), ("我不介意。如果我喜欢这个人并且他愿意的话，我会这么做。"), love=1)
    add_dialogue("free_flirt_sex_act interested", ("loyal", "generic"), ("我能做到这一点。这听起来不错！"), love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("loyal", "generic"), ("哦....听起来不错！"), love=2)
    add_dialogue("free_flirt_sex_act very interested", ("loyal", "generic"), ("你把我弄湿了！"), love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("loyal", "generic"), ("你把我弄湿了！我的小穴告诉我是的..."), love=3)

    add_dialogue("free_give_gold +++", ("loyal", "stubborn", "class president", "repressed"), ("这{b}真的{/b}太多了！我非常感激！"), love=4, max_cap=75)
    add_dialogue("free_give_gold ++", ("loyal", "generic", "stubborn", "nerd", "meek"), ("这真的是很多啊！"), love=3, max_cap=75)
    add_dialogue("free_give_gold +", ("loyal", "class president", "pet", "sweet"), ("谢谢，这有帮助！"), love=1, max_cap=75)
    add_dialogue("free_give_gold -", ("loyal", "pet", "sweet", "yandere"), ("你给我钱，但为什么？你买不到我的忠诚。"), love=-1, max_cap=75)
    add_dialogue("free_give_gold --", ("loyal", "generic", "very idealist"), ("我不是一个妓女......*悲伤*"), love=-1, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("loyal"), ["她用新发现的决心看着你.", "g: 我？妓女？我觉得生活交给我的任何责任我都应该尽力而为，但我没想到会用我的身体为无数的男人服务......", "g: 但我很高兴你告诉了我有关你工作的真相。这给了我时间去思考。", "g: 如果这就是我一生的命运，那么我就应该拥抱它并尽力而为....", "g: 你认为我能做到吗...？"], multiple=True, love=3)
    add_dialogue("free_offer_job half_lie", ("loyal"), ["g: 你从没告诉过我!", "mc: 我当时认为这并不重要...", "g: 那里的女孩们....她们的职责就是和任何付钱的人做爱，对吗？"], multiple=True, love=1)
    add_dialogue("free_offer_job lie", ("loyal"), ["g: Oh, so you lied...", "g: 这不是我梦想的那样....我，一个妓女？", "mc: 有些女孩更喜欢“陪护”这个词...", "g: 护送？嗯，它确实有一种更令人愉快的感觉。那些陪护女孩的职责就是和任何付钱的人做爱，对吗？"], multiple=True, love=1)
    add_dialogue("free_offer_job success", ("loyal"), ["g: 好的，我会按照你的要求做。如果做妓女是我的职责，那么我会尽我最大的努力去履行这个职责....", "g: 我是你的。我已准备好为您和顾客服务，主人。"], multiple=True)
    add_dialogue("free_offer_job thinking", ("loyal", "generic"), ["g: 谢谢你的邀请....但是...", "g: 我还没准备好接受这一点。一定还有其他工作....还有一些我没有考虑过的选择....", "她离开了，看上去若有所思."], multiple=True)
    add_dialogue("free_offer_job failure lie", ("loyal"), ["g: 操你妈的，我就是这么想的！你以为我是什么鬼啊！", "g: 你骗了我，现在又要我在你恶心的青楼里工作！那不会发生！", "g: 我可能有很强的责任感，像你这样的人渣会想方设法利用，但我确实有一些自尊心。滚蛋！", "她离开了，看起来很生气.", "mc: 进展顺利。等她冷静下来再说吧?"], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("loyal"), ["g: 操你妈的，我就是这么想的！你以为我是什么鬼啊！", "g: 你认为因为我有强烈的责任感，我就会成为一个漂亮的小妓女，愿意把自己的身体卖给谁出钱吗？", "g: 滚蛋!", "她离开了，看起来很生气.", "mc: 进展顺利。等她冷静下来再说吧?"], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("loyal"), ["g:  青楼？皮条客？！！我们都需要以某种方式谋生，但我认为你的方式很恶心！你让那些女孩出卖自己并虐待她们的身体......*悲伤*", "mc: 这对你来说可能听起来很恶心，但我提供了一项重要的服务，让世界变得更安全、更美好。", "mc: 这对女孩来说更安全，她们不需要在街上工作，而且可以免受触手怪物和疯狂乞丐的侵害。", "mc: 妓女需要房子，国家需要青楼。", "mc: 太阳神的牧师曾经试图取缔青楼，但这导致强奸和谋杀事件大幅增加。", "mc: 我的青楼女孩为好斗的男人提供了一种积极的方式来释放他们被压抑的能量。可以说这是女孩子的义务。", "g: 我从来没有这样想过。也许那些女孩确实对泽恩社区负有责任。", "g: 不过，我还是感觉不太对劲....", "她看起来很深思熟虑，但似乎并不完全相信你的论点。"], multiple=True, love=-3)
    add_dialogue("free_friend half_lie", ("loyal"), ["g: 哦，这几天我看到了很多冒险者。似乎每隔一天就会有一些充满希望的[MC.playerclass]出现！", "mc: 那你是做什么的？", "g: 我的职责！ ...", "g: ....如果我真的有一份就好了....因为我有点没有工作....*她看起来很不好意思*"], multiple=True, love=2)
    add_dialogue("free_friend lie", ("loyal"), ["g: 一个....[lie]？而我其实就是乔装打扮的黑姬公主本人！", "我很难相信你是一个[lie]。你看起来只是另一个充满希望的[MC.playerclass]，试图在泽恩取得成功。", "mc: 那你是做什么的？", "g: 我的职责！ ...", "g: ....如果我真的有一份就好了....因为我有点没有工作....*她看起来很不好意思*"], multiple=True, love=-1)

    add_dialogue("free_love_interest", ("loyal"), ["mc: Hi, [girl.name]. 出什么事了吗?", "g: 呃，我？不....不，我只是想我们已经变得非常亲密了。你对我来说意义重大，我希望你也是如此。", "g: 我只是看着情侣们在这个轻松愉快的[season]日子里手牵着手......", "g: 啊啊，我现在感觉自己就像一个迷失和孤独的女孩......", "g: 你知道吗...男孩给女孩送花是为了告诉她们喜欢她们。这是一个很好的举动，可以表明你对我的忠诚......", "mc: Is that so?"], multiple=True)
    add_dialogue("free_girl get_flowers", ("loyal"), ("花朵！真是一个令人愉快的惊喜！但为什么？"))
    add_dialogue("free_ask_out", ("loyal"), ("是的，当然，亲爱的....我的职责就是你！ *吻*"))

    add_dialogue("free_girlfriend intro", ("loyal"), ["g: 哦，[MC.name]！来这里吧，亲爱的...", "mc: 嗨,我的爱人。你今天好吗??", "g: 我很好，亲爱的...跟我来，我想你应该得到一点东西...", "mc: 这么突然, 当然...", "g: 但是，为了测试你的忠诚度，我会问你一个问题。"], multiple=True)
    add_dialogue("free_girlfriend right", ("loyal"), ("你说得对，我爱你！跟我来吧，亲爱的..."), love=5)
    add_dialogue("free_girlfriend give_up", ("loyal"), ("哦真的吗？看来我们还是不太了解，毕竟....*悲伤*"), love=-5)
    add_dialogue("free_girlfriend wrong", ("loyal"), ["g: 你太可怕了！！！你完全忘记了！！！你真是个可怕的男朋友....*生气*", "mc: 啊, 呃, 抱歉..."], multiple=True, love=-10)
    add_dialogue("free_girlfriend success", ("loyal"), ["她把衣服扔在地上，凝视着你的眼睛.", "g: 亲爱的，你喜欢你所看到的吗？", "你可以感觉到你的鸡巴变得越来越硬。她似乎注意到了这一点，并对你微笑。", "g: 我是不是对你做了那种事....我想，女孩子的身体就是为了让男孩子变硬吧！"], multiple=True)
    add_dialogue("free_girlfriend success naked", ("loyal"), ["当她脱下衣服时，你喘息着。", "g: 你不觉得对自己的身体感到舒适是一种美妙的感觉吗?", "g: 我认为我们对自己的身体有责任，尽可能让它们自由....我希望我能一直赤身裸体！", "g: 但我当然不会光着身子在镇上转悠... *叹气* 我还没疯.", "g: 不过，我还是很高兴能向你展示真实的自己....看你裤子上的那个凸起，看来我的身体也尽到了它的职责了！ *傻笑*"], multiple=True)

    add_dialogue("free_job_request", ("loyal"), ["g: Oh, [MC.name], 这太可怕了... *啜泣*", "mc: 宝贝，发生什么事了？", "g: 我希望能在Zan开始新的生活", "看守们....他们把我从我住的地方赶了出来....我没有可以一起住的朋友....", "g: 我现在孤身一人了。我是一个好工人，无论做什么工作都尽职尽责，但没有人愿意给我证明自己的机会！", "g: 请帮忙，[MC.name]！你是唯一一个对我好的人！", "她突然哭了起来.", "mc: [girl.name]，冷静点，我们会找到解决办法的...."], multiple=True)

    add_dialogue("accept farm", ("loyal", "very idealist", "very sub"), ("农场？既然你这么说，我就有义务服从...."))
    add_dialogue("accept farm fear", ("loyal", "very idealist"), ("当吉泽尔来找她时，她吓得浑身发抖，但还是温顺地接受了她的职责。", "她用眼睛恳求不要走，但最终还是屈服了。", "她太害怕了，无法抗拒你的命令，所以温顺地接受了。"))
    add_dialogue("refuse farm", ("loyal", "very idealist"), ("我不想去农场！请主人不要！我会以其他方式为您服务！", "不！不是农场！拜托...我会做任何事！请？！", "求求你了，主人....不....请放过我....除了那样我会做任何事！"))
    add_dialogue("gizel take girl to farm", ("loyal", "very idealist"), ("有趣....这确实适合训练。好发现！"))

    add_dialogue("girl introduction", ("loyal", "very idealist"), ("好的，我[girl.name] 准备好开始了。你想要我做什么？", "在这里，我就像我所承诺的那样。你希望我做什么工作？"))
    add_dialogue("slave thanks", ("loyal", "very sub"), ("谢谢。", "谢谢主人！你欣赏我的努力让我很高兴。", "谢谢你，[MC.name]主人。我只乐意尽我的职责。", "谢谢主人。", "谢谢主人。我很感激。", "谢谢您，我很高兴您发现我的工作符合 [brothel.name] 的标准。", "谢谢你，先生！我真的很感谢您给我这个机会！"))
    add_dialogue("slave effusive thanks", ("loyal", "very sub"), ("噢，谢谢主人！太感谢了！", "噢，我真是太感谢主人了！谢谢你！", "主人，我很高兴您为我提供了工作，并且似乎对我的贡献感到满意！"))
    add_dialogue("slave positive reaction", ("loyal", "generic", "very idealist"), ("这让我很高兴！", "哇，主人！", "这真是一个大惊喜！", "我很高兴您对我的服务感到满意！", "很高兴尽我的一份力量，先生！"))
    add_dialogue("slave negative reaction", ("loyal", "very idealist"), ("嘿！这个是来做什么的！我试图取悦你！", "请主人！难道我没有尽到自己的义务吗！", "请问善良的主人，这是做​​什么用的？"))
    add_dialogue("slave whining", ("loyal", "very idealist", "very sub"), ("噢...", "但...", "但、但是....",  "哦...", "哇...请不要！"))
    add_dialogue("slave strongly refuse", ("generic", "very sub", "loyal"), ("不，主人，不！！！ *哭泣*", "拜、拜、请不要这样对我，主人！"), sound=s_screams)
    add_dialogue("slave bullied", ("loyal", "very idealist", "very sub"), ("不好了...", "嘿，等等....我不想让你不高兴！", "请停止这样吧，主人！"))
    add_dialogue("slave apology", ("loyal", "very idealist"), ("对不起，主人，让您失望了....", "对不起，我下次会努力的....", "对不起，主人。不会再有这样的事了....以后我要做一个好女孩....", "我不是故意的....对不起。这样的事不会再发生了。"))
    add_dialogue("slave hit", ("loyal", "very idealist", "generic"), ("哎哟!真的很痛啊！", "呜呜呜....痛痛！！！"))
    add_dialogue("slave positive fixation accept", ("loyal", "very idealist"), ("哦，主人，这是我最喜欢的...", "是的，这太好了...很高兴为您服务！", "哦主人，我作为你的性奴隶的责任从未感觉如此美好！", "哦，这感觉真好....我的职责从来没有这么好过！ ", "*舔她的嘴唇*我很高兴这样做！{/i}"))
    add_dialogue("slave negative fixation accept", ("loyal", "very idealist"), ("我真的很想做点别的事情，但因为我相信为[brothel.name]尽自己的一份力量，所以我会这么做。", "好吧，我会做的，因为这是工作的一部分，但这不是我特别喜欢的部分。", "先生，请。我真的很想以其他方式为您服务。", "我想成为一个好妓女，为这个地方尽我的一份力量，但这是一个非常不愉快的要求......"))
    add_dialogue("slave negative fixation refuse", ("loyal", "very idealist"), ("不，不是这个....我愿意做你要求的任何其他事情。请问主人？", "不！我很抱歉，但我就是做不到......我不明白任何女孩怎么可能喜欢这样！"))

    add_dialogue("slave first visit", ("loyal", "very idealist"), ["g: 主人....我在这里....", "g: 我知道现在为您服务是我的职责....", "g: ....但请给予合理的回报。"], multiple=True)
    add_dialogue("MC kind promise", ("loyal", "very sub"), ["她微微一笑。", "g: 谢谢。我保证我不会让你失望的。"], multiple=True, love=1, fear=-3)
    add_dialogue("MC fair promise", ("loyal", "very idealist"), ["她看上去警惕心少了一些。", "g: 我想这很公平。"], multiple=True, love=2, fear=-1)
    add_dialogue("MC no promise", ("loyal", "generic", "very idealist"), ["她盯着地面。", "g: 是的，主人。我了解我的处境。"], multiple=True, love=1, fear=1)
    add_dialogue("MC harsh promise", ("loyal", "very idealist"), ("她给了你一个挑衅的眼神，然后叹了口气，低下了头，什么也没说。"), love=-3, fear=4)
    add_dialogue("MC break promise", ("loyal", "very idealist"), ["g: 但是你、你、你答应过你会公平的！" , "g: 这不对！", "她看起来既震惊又泄气，就像有什么东西刚刚在她体内破裂一样。"], multiple=True, love=-8, fear=3)
    add_dialogue("MC fight intro", ("loyal", "very idealist"), ["g: 不....就是没门！！！这个不对！这不应该是这样的！", "你向她走近，但她真的很生气并试图反击。"], multiple=True, sound=s_scream_loud)
    add_dialogue("slave fear intro", ("loyal", "very idealist"), ["当你靠近时，她的肩膀下沉。你可以看到她眼中惊恐的鹿的表情。", "那女孩太害怕了，不敢回答你的问题。"], multiple=True)
    add_dialogue("slave fear reassure success", ("loyal", "very idealist"), ("你可以看出她看起来不那么害怕你了。你的话似乎又让她明白了。"), love=1, fear=-2)
    add_dialogue("slave fear reassure failure", ("loyal", "very idealist"), ["她只是摇摇头，对自己嘀咕一些（{i}不公平{/i}...）的事情。", "看起来她太害怕而不敢和你说话。最后，你只能放弃。"], multiple=True, fear=-1)
    add_dialogue("slave fear discipline", ("loyal", "very idealist"), ["你一巴掌打在她脸上。", "她像一只受惊的小狗一样呜咽着，不明白主人为什么要这样惩罚她。", "现在想跟她说话是没有用的。"], multiple=True, love=-1, fear=1)

    add_dialogue("slave naked request permanent", ("loyal", "very idealist"), ("我很乐意服从，主人！我知道这是这个妓女工作的重要组成部分....而且，说实话，我真的学会了享受它...."), love=1, sound=s_sigh)
    add_dialogue("slave naked request accept", ("loyal"), ["她看着你就像一只受惊的小狗。", "g: ....请吧，主人。这也太不舒服了吧！", "g: 我{i}真的{/i}不想！我觉得太害羞了。当我工作时，我不想让顾客过多地看到我。", "mc: 你是我的奴隶，[girl.fullname]。我有一份合约，上面是这么说的。", "mc: 当你是奴隶时，很多人会看到你裸体....甚至看到你公开做爱。这是您的职责，也是您工作的一部分——一个{i}重要{/i}的部分。", "g: 我明白了。我想做好我的工作，所以我会好好做这件事...希望顾客会喜欢我的身体...", "mc: 他们会喜欢的，女孩。现在，你去上班吧。", "你轻轻捏捏她的乳头。"], multiple=True, love=1, sound=s_ahaa)
    add_dialogue("slave naked request resist", ("loyal", "very idealist"), ["她看着你就像一只受惊的小狗。", "g: ....请吧，主人。这也太不舒服了吧！", "g: 我{i}真的{/i}不想！我觉得太害羞了。当我工作时，我不想让顾客过多地看到我。", "她拒绝裸体。"], multiple=True, love=-2, fear=-2)
    add_dialogue("slave toggle naked on", ("loyal", "very idealist"), ["g: 遵命，主人。今后我将赤身裸体为顾客服务....", "她试图表现得专业而超然，但你可以看出她对你的命令感到兴奋。"], multiple=True)
    add_dialogue("slave toggle naked off", ("loyal", "sweet", "very idealist"), ("如您所愿，主人....现在....我的衣服又落在哪里了...."))
    add_dialogue("slave train beg", ("loyal", "very idealist", "very sub"), ["[girl.name]跪倒在地。你可以看到她眼里的泪水。", "g: 主人，求你了，我可以做任何事，但不能这样！我求求你，不要让我这么做！"], multiple=True)
    add_dialogue("slave discipline beg", ("loyal", "very idealist", "very sub"), ["[girl.name]开始求你。", "g: 主人，非常抱歉！我不会再这样做了！请不！"], multiple=True)
    add_dialogue("slave beg proceed", ("loyal", "very idealist", "very sub"), ("哦，不！", "*她只是震惊地看着你*", "*抽泣*她开始哭泣。"), love=-1)
    add_dialogue("slave beg warning", ("loyal", "very idealist", "very sub"), ("我-我-我明白了....我不会让你失望的，Master"), fear=1, sound=s_sigh)
    add_dialogue("slave beg give up", ("loyal", "very idealist"), ["g: 对——真的吗？", "mc: 当然。你现在可以走了，不用担心。", "g: T、T、谢谢您，主人....我确信我能及时赶到，但还不到...."], multiple=True, love=2, fear=-1, sound=s_surprise)
    add_dialogue("slave send to master bedroom love +", ("loyal", "very idealist", "very sub"), ["你可以看到她听到你的话高兴得几乎发出咕噜声。", "g: 哦，主人，我很高兴....你似乎对我最近在青楼的工作很满意！ *脸红*"], multiple=True)
    add_dialogue("slave send to master bedroom love", ("loyal", "very idealist", "very sub"), ("谢谢主人！看来你对我最近在你青楼的工作很满意！ *微笑*"))
    add_dialogue("slave send to master bedroom love -", ("loyal", "very idealist", "very sub"), ["她耸耸肩。", "g: 好的，主人。我知道服从是我的义务...", "g: （....但这并不意味着我必须喜欢它....）"], multiple=True)
    add_dialogue("slave send to master bedroom fear +", ("loyal", "very idealist"), ["当她明白你话里的意思时，她害怕得发抖。", "g: 当然，主人....我不想让你不高兴....*吞咽*"], multiple=True)
    add_dialogue("slave send to master bedroom fear", ("loyal", "very idealist", "very sub"), ["她太害怕你而不敢不服从。", "g: 当然....主人....随你便吧....请不要伤害我...."], multiple=True)
    add_dialogue("slave send to master bedroom fear -", ("loyal", "very idealist", "very sub"), ["她耸耸肩。", "g:  好的，先生。如果你这么说....我想我在哪里过夜并不重要。"], multiple=True)
    add_dialogue("slave leave master bedroom love +", ("loyal", "very idealist", "very sub"), ["你注意到她在哭。", "g: 请，主人。请不要送我走....我知道按照你说的去做是我的责任，但我很喜欢睡在你旁边！"], multiple=True)
    add_dialogue("slave leave master bedroom love", ("loyal", "very idealist"), ["她叹了口气。", "g: 主人，你要送我走吗？", "g: 我知道按照你说的去做是我的责任，但我不介意在你身边多睡一晚！"], multiple=True)
    add_dialogue("slave leave master bedroom love -", ("loyal", "very idealist"), ["她耸耸肩。", "g: 你的愿望就是我的命令。", "g: （很高兴我不用再睡在那里了。）"], multiple=True)
    add_dialogue("slave leave master bedroom fear +", ("loyal", "very idealist"), ["她如释重负地浑身发抖。", "g: 你的愿望就是我的命令。", "g: （很高兴能离开那里......）"], multiple=True)
    add_dialogue("slave leave master bedroom fear", ("loyal", "very idealist"), ["你认为她看上去松了口气。", "g:  先生，随你怎么说。", "g: （很高兴我不用再睡在那里了。）"], multiple=True)
    add_dialogue("slave leave master bedroom fear -", ("loyal", "very idealist"), ["她明显松了口气。", "g: 你的愿望就是我的命令。", "g: （所以，很高兴噩梦终于结束了！）"], multiple=True)

    add_dialogue("slave chat slave_life -2", ("loyal", "very idealist"), ["她的眼睛里充满了泪水，看上去很绝望。", "g: 我...我不知道我在这里做什么...", "g: ....这违背了我所信仰的一切。*呜咽*"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life -1", ("loyal", "very idealist"), ["她看起来悲伤而失败。", "g: 我知道现在就是我的生活，但我真的不想成为奴隶。", "g: 我习惯做事是因为我相信某事，而不是因为我必须做。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0", ("loyal", "very idealist"), ["她给你一个悲伤的表情。", "g: 这是我的职责。", "g: 我必须这么做。", "g: 我喜不喜欢并不重要。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0.5", ("loyal", "very idealist", "very sub"), ["她鞠躬。", "g: 我想这就是我现在的生活。也不是那么坏。", "g: 我不介意做您的仆人，先生。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 1", ("loyal", "very idealist", "very sub"), ["她笑了。", "g: 我喜欢这里，主人。我感到....安全。我不知道如果我有空我会做什么...", "g: 我的职责是为您服务，我热爱我的职责！"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 2", ("loyal", "very idealist", "very sub"), ["她跪下并深深鞠了一躬。", "g: 主人，我喜欢做你的奴隶！", "g: 先生，我已经找到了自己的人生定位。"], multiple=True, unlock="DS")
    add_dialogue("slave chat brothel -2", ("loyal", "very idealist"), ["她看上去既悲伤又愤怒。", "g: 这个地方太可怕了，你还强迫这里的女孩子做一些肮脏的事情！", "g: 你怎么可以这样对我们！"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel -1", ("loyal", "very idealist"), ["她看起来很生气。", "g: 这不是我想象的生活！", "g: 我觉得我不适合做这种工作！", "g: 那些顾客可能想从我这样的女孩那里得到什么？"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0", ("loyal", "very idealist"), ["她沉默了一会儿。", "g: 这不是我想象中的青楼....不过没关系。", "g: 为所有这些客户提供服务已经成为一种日常工作......", "g: 不过我还过得去....我已经习惯了。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0.5", ("loyal", "very idealist"), ["她给你一个虚弱的微笑。", "g: 工作量很大，但在这样的地方工作也很有意义....", "g: ....就职责而言，这并不是一件令人不愉快的事情！"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel virgin", ("loyal", "very idealist"), ["她脸通红.", "g: 这里发生的一切都很疯狂，这让我很好奇......有一天我很想自己尝试更多......嗯......"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 1", ("loyal", "very idealist"), ["g:  太忙了！我不知道是谁说的...", "g: ....女人的工作永远做不完....",  "g: ....但他们显然是对的。总会有新顾客需要小穴或其他东西！"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 2", ("loyal", "very idealist"), ["她给你一个狂热的表情。", "g: 我喜欢它...我会做妓女的工作，因为这是我的职责...", "g: ...但是哦，这是多么大的责任啊... *舔她的嘴唇*", "g: 我喜欢被操，放弃所有抵抗，让我的高潮来临！"], multiple=True, unlock="LM")
    add_dialogue("slave chat customers -2", ("loyal", "very idealist"), ["她看上去悲伤又沮丧。", "g: 我觉得我不适合这个行业！我尽我最大的努力去服务，但他们却不断地侮辱和谩骂我...... ", "g: 我觉得他们不喜欢我这样的女孩...."], multiple=True, unlock="MI")
    add_dialogue("slave chat customers -1", ("loyal", "very idealist"), ["她看起来很沮丧。", "g: 他们对待我就像对待泥土一样。我明白，满足他们的幻想是我的工作，无论多么肮脏。", "g: 但我想我做不到。", "g: 内心深处我只是一个普通的女孩，而不是一个供所有人使用的荡妇。 *伤心*"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 0", ("loyal", "very idealist"), ["她叹了口气。", "g:  没关系。", "g: 如果和像我这样的普通女孩一起过夜可以帮助她们忘记她们的问题，我有什么资格拒绝呢！"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 0.5", ("loyal", "very idealist"), ["她微微一笑。", "g: 我想我正在做出改变，先生！", "g: 顾客总是向我倾诉他们与妻子、工作或与孩子不亲近的问题....", "g: 帮助他们暂时忘记这一切感觉很好......做我做的事情......*脸红*"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 1", ("loyal", "very idealist"), ["她心情轻松起来。", "g: 哦，顾客，他们简直是最棒的！现在，许多常客都感觉自己是真正的朋友......", "g: 我知道很多人来这里是为了做一些他们不能和妻子一起做的事情，但也有真正的联系。", "g: 这份工作让我学到了很多关于如何成为一名女性的知识！"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 2", ("loyal", "very idealist"), ["她脸上洋溢着自豪的笑容。", "g: 帮助顾客让我很高兴。我找到了人生真正的使命。", "g: 我会尽我所能帮助他们忘记与妻子或工作有关的问题。", "g: 不管他们想把我当公主、女朋友还是妓女，我很乐意满足他们的幻想！"], multiple=True, unlock="MI")
    add_dialogue("slave chat other_girls -2", ("loyal", "very idealist"), ["g: 其他女孩看起来都是经验丰富的妓女，但以太阳神的名义，像我这样的女孩在这里做什么！", "g: 我觉得我不适合这个行业！"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls -1", ("loyal", "very idealist"), ["她看起来很沮丧。", "g: 我太专注于工作和生存，以至于没有时间和其他女孩交谈。", "g: 无论如何，我觉得我们没有太多共同点。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 0", ("loyal", "very idealist"), ["她皱眉.", "g: 我不知道。我将尽我所能地完成这项新工作....就像我应该做的那样....", "g: ....但他们似乎花在闲聊上的时间和工作的时间一样多。", "g: ....我有这种感觉，有人在背后议论我。 *伤心*"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 0.5", ("loyal", "very idealist"), ["她想了一会儿.", "g: 他们中的很多人都非常好。无论如何，我有时间与之交谈的人。", "g: 有一点支持网络感觉很好，即使我仍然觉得我和他们中的很多人没有那么多共同点。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 1", ("loyal", "very idealist"), ["她笑了。", "g: 我发现我有一些非常好的同事。有陪伴真是太有动力了！"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 2", ("loyal", "very idealist"), ["她给你一个温暖而幸福的微笑。", "g: 其他女孩都很棒！能够与他们交换小费真是太有用了！", "g: 我们谈论一切，从如何取悦特定顾客到如何在性姿势中给予和获得最大的快乐！"], multiple=True, unlock="EI")
    add_dialogue("MC praise friend", ("loyal", "very idealist"), ("哇...我很高兴你也喜欢 [inter.other_girl.name]！她很酷，是个好朋友....*微笑*"), sound=s_laugh)
    add_dialogue("MC demean rival", ("loyal", "very idealist"), ("所以，你已经注意到了！我和她实在合不来....我也不知道为什么！在某种程度上，我很高兴你也对她有问题......"), sound=s_evil_laugh)
    add_dialogue("slave chat well_being -3", ("loyal", "very idealist"), ("我感觉很糟糕。我认为我不适合从事这种工作。对不起，主人....*抽泣*"), unlock="MI")
    add_dialogue("slave chat well_being -2", ("loyal", "very idealist"), ("我感觉不太舒服。这确实是一项艰苦的工作...我认为我不适合做这个。"), unlock="MI")
    add_dialogue("slave chat well_being -1", ("loyal", "very idealist", "very sub", "generic"), ("这是艰难的工作，也是艰难的生活。 *伤心*"), unlock="MI")
    add_dialogue("slave chat well_being 0", ("loyal", "very idealist", "very sub", "generic"), ("我很好。我的情况更糟。"), unlock="MI")
    add_dialogue("slave chat well_being 1", ("loyal", "very idealist"), ("我很高兴在这里工作。请主人继续照顾我。"), unlock="MI")
    add_dialogue("slave chat well_being 2", ("loyal", "very idealist"), ("我在这里很开心，主人！我真的很喜欢我的工作。"), unlock="MI")
    add_dialogue("slave chat well_being 3", ("loyal", "very idealist"), ("我喜欢在这里工作，主人。实在是让我很充实、很幸福！"), unlock="MI")
    add_dialogue("slave chat well_being attacked", ("loyal", "very idealist"), ["g: 过去一个月我受到攻击和伤害 [nb_times] 次。", "g: 我正在努力做好我的工作，但我觉得在这里工作不安全。请保护我们吧，主人！"], multiple=True)
    add_dialogue("slave chat well_being sick", ("loyal", "very idealist"), ["g: 过去一个月我生病了 [nb_times] 次。", "g: 我正在努力做好我的工作，但这不是一个健康的工作场所。如果能干净一点就更好了。"], multiple=True)
    add_dialogue("slave chat well_being exhausted", ("loyal", "very idealist"), ("过去一个月，我因过度劳累而感到疲惫不堪[nb_times]。我太累了....对不起，主人....但是如果我太酸了，我就无法工作。"))
    add_dialogue("slave chat well_being MC apology", ("loyal", "very idealist"), ["她给你一个虚弱的微笑。", "g: 我明白了，先生。我会尝试忍受它。", "g: ....毕竟，这是我的工作。"], multiple=True)
    add_dialogue("slave chat feelings love -1", ("loyal", "generic", "very idealist"), ("这很难说。我觉得我并不真正了解你。"), unlock="DS")
    add_dialogue("slave chat feelings love 0", ("loyal", "generic", "very idealist"), ["g: 你没事吧。我认为您大多数时候都是一位善良的Master。", "g: 我很高兴为您工作....大部分时间。"], multiple=True, unlock="DS")
    add_dialogue("slave chat feelings love 1", ("loyal", "generic", "very idealist"), ("我喜欢你！很荣幸为您服务，先生。"), unlock="DS")
    add_dialogue("slave chat feelings love 2", ("loyal", "generic", "very idealist"), ("我爱你，主人。我想和你在一起，任何时候！"), unlock="DS")
    add_dialogue("slave chat feelings fear -1", ("loyal", "generic", "very idealist"), ("有时候你可能会....有点刻薄。"), unlock="DS")
    add_dialogue("slave chat feelings fear 0", ("loyal", "generic", "very idealist"), ("你....你有时让我担心。我害怕让你不高兴。"), unlock="DS")
    add_dialogue("slave chat feelings fear 1", ("loyal", "generic", "very idealist"), ("我不想让您失望，主人！你生气的时候很可怕..."), unlock="DS")
    add_dialogue("slave chat feelings fear 2", ("loyal", "generic", "very idealist"), ("我....我会做任何你想做的事，主人。 P-请不要再伤害我了..."), unlock="DS")
    add_dialogue("slave chat feelings very disobedient", ("loyal", "very idealist", "very sub"), ("这是荒唐的！我做事是因为我相信它们......而且我是我自己的主人！"), unlock="DS")
    add_dialogue("slave chat feelings disobedient", ("loyal", "very idealist", "very sub"), ["g: 你是我的主人。我会对你尽我的职责...", "你可以听到她嘟囔着什么....", "g: （....但这并不意味着我必须喜欢它。）"] , multiple=True, unlock="DS")
    add_dialogue("slave chat feelings a little obedient", ("loyal", "very idealist", "very sub"), ("我想我现在是你的奴隶了，所以我有责任按照你的吩咐去做。但请不要逼我太紧..."), unlock="DS")
    add_dialogue("slave chat feelings obedient", ("loyal", "very idealist", "very sub"), ("我是来尊重你的。给您做女仆感觉很自然....主人。"), unlock="DS")
    add_dialogue("slave chat feelings very obedient", ("loyal", "very idealist", "very sub"), ("很荣幸为您服务，主人。"), unlock="DS")
    add_dialogue("slave chat tastes likes", ("loyal", "helper", "holy", "very idealist"), ("我最喜欢的[thing_cn]是[best]。", "让我想想...我可能没有充分考虑我真正喜欢什么，但是，既然你问了，我想我最喜欢的[thing_cn]是[best]。", "我最喜欢的东西？我倾向于把自己放在最后，但如果你真的想知道，我应该告诉你。我最喜欢的[thing_cn]是[best]。"), unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("loyal", "helper", "meek", "very idealist"), ("是的，有些事情我不喜欢。例如，我真的不喜欢的一件[thing_cn]是[worst]！", "感谢您的询问，[MC.name]！很多人对我喜欢和不喜欢的东西不感兴趣。但你做了！我最不喜欢的[thing_cn]可能是[worst]。"), unlock="LM")
    add_dialogue("slave chat tastes loves +", ("loyal", "very idealist"), ["g: 我不太在意礼物。", "g: 先生，请不要特意去拿东西....", "g: ....但我想我不会介意，如果我有一些[thing_cn]...."] , multiple=True, unlock="LM")
    add_dialogue("slave chat tastes loves -", ("loyal", "very idealist"), ("不需要给我任何东西，先生。虽然我想我不会介意[thing_cn]。他们很好。"), unlock="LM")
    add_dialogue("slave chat tastes no loves", ("loyal", "very idealist"), ("呵呵，我真的不需要什么，先生！我想我是一个容易被取悦的女孩..."), unlock="LM")
    add_dialogue("slave chat tastes hates", ("loyal", "very idealist"), ["g: 嗯，无论如何你也买不到我的感情。", "g: 但是如果你确实给我买了一些东西，请不要做[thing_cn]。", "g: 我没有看到上诉..."], multiple=True, unlock="LM")
    add_dialogue("slave chat tastes no hates", ("loyal", "very idealist"), ["g:  先生，我什么都可以！", "g: 重要的是想法！"], multiple=True, unlock="LM")
    add_dialogue("slave chat tastes positive act", ("loyal", "very idealist", "very sub"), ["g: 虽然我通常会尝试对顾客想要的任何东西持开放态度......就像一个真正的妓女应该......", "g: 我注意到我特别喜欢[act_desc]。不知怎的，感觉真的很对！"], multiple=True, unlock="LM")
    add_dialogue("slave chat tastes negative act", ("loyal", "very idealist"), ("我知道我现在在青楼工作，我的身体被用来以各种方式获得快乐，但我根本不明白 [act_desc] 的吸引力......", "光是想到 [act_desc] 就感觉很可怕。我什至不知道为什么。", "我正在尽最大努力让 [act_desc] 变得专业，但不知怎的，它只是让我感到毛骨悚然！"), unlock="LM")
    add_dialogue("slave chat tastes no negative act", ("loyal", "very idealist"), ("我的工作就是满足性幻想。我对他们中的任何一个都很好！ *她看起来很自豪*"), unlock="LM")

    add_dialogue("slave chat origins 1", ("loyal", "very idealist"), ("我来自[girl.origin]。", "我来自[girl.origin]。试图在泽恩取得成功。", "我来自[girl.origin]...而我现在就在这里。"), unlock="EI")
    add_dialogue("slave chat origins 2", ("loyal", "very idealist"), ("我曾经和我的 [girl.story_guardian] 一起住在 [girl.origin] 附近的 [a_home]。我想我在那段日子里学到了很多东西...."), unlock="EI")
    add_dialogue("slave chat origins 3", ("loyal", "very idealist"), ("我记得我和我的[girl.story_guardian]住的[girl.story_home]...那是一个有趣的地方，教会了我很多东西！"), unlock="EI")
    add_dialogue("origin Zan", ("loyal", "very idealist"), ["g: 我来自泽恩，现在我仍然在这里，只是年纪大了一点，希望能更聪明一点。我和我的[girl.story_guardian]一起长大。", "g: 这不是一个糟糕的城市，尽管我在这里的生活并不轻松。", "g: 我越来越喜欢它，并努力忠于自己...."], multiple=True)
    add_dialogue("origin the border with the Holy Lands", ("loyal", "very idealist"), ["g: 圣地是一片有着深绿色森林、雪白山顶和一望无际的荒野的地方。它们是各种怪物、半怪物和亚人的家园。", "g: 我和我的[girl.story_guardian]一起在那里长大。那里很美丽....如果那些怪物没有那么努力地想要杀死我们的话，那可能会是一个非常令人兴奋的地方....", "g: ....并不是说来到那里的太阳神和其他人的圣堂武士总是好得多！", "g: 尽管如此，那是我的家，无论我走到哪里，我心里都有一片圣地！", "g: Zan比较平和，有很多机会，但有时我还是觉得自己像个童年的流放者。"], multiple=True)
    add_dialogue("origin the Blood Islands", ("loyal", "very sub"), ["g: 血群岛是一个崎岖但美丽的地方。我记得小时候相信大海的自然颜色是深红色，因为这就是我和我的[girl.story_guardian]一起长大的地方！", "g: 我记得在竞技场上看到奴隶以最可怕的方式受到惩罚....有时他们被折磨，有时被剥光衣服....被羞辱....", "g: ....这很可怕，但同时又有点令人着迷。", "g: 我想那些女孩应该知道自己的位置，否则就不会发生这样的事情！", "g: 有时我偷偷想象自己处于他们的位置......*脸红*",  "g: 我从来没有告诉过我的[girl.story_guardian]。"], multiple=True)
    add_dialogue("origin Karkyr", ("loyal", "very idealist"), ["g: 卡克尔是一个适合小女孩成长的有趣城市！一切都很神奇，天空充满了火花，发生了很多事情！", "g: 我曾经尝试偷偷溜出去观看法师施展法术，而我的[girl.story_guardian]常常责骂我。", "g: 我是一个多么不守规矩的孩子，直到有一天我吸取了教训。", "g: 涉及到一位大法师、我和一些普通的家养猫狗，有触手....*脸红*", "g: 这教会了我不要多管闲事！我答应过我会按照别人告诉我的去做....希望有一天生活会回报我。"], multiple=True)
    add_dialogue("origin Westmarch", ("loyal", "very sub"), ["g: 我在威斯特玛公国度过了一段美好的童年。当地的王子心胸宽广，心地善良。", "g: 他为穷人组织食物。他支持艺术、科学以及施法。", "g: 每年都会有一个盛大的节日，有音乐和舞蹈，直到太阳升起。", "g: 我的[girl.story_guardian]曾经说过：我们很幸运有这样的王子。", "g: 当然，这种情况并没有持续多久。与邻国公国之间长期存在不和。甚至没有人记得，这一切是从哪里开始的....", "g: 一天晚上，他们发动了一次突然袭击。大多数妇女都被强奸了。有些人被卖为奴隶。", "g: 我和我的[girl.story_guardian]侥幸逃脱。", "g: 我以前觉得成为奴隶并臣服于主人一定是一件很兴奋的事情。", "g: 我的[girl.story_guardian]有点不喜欢它并责备了我！", "g: 嗯，我现在在这里...."] , multiple=True)
    add_dialogue("origin the desert of Hokoma", ("loyal", "very idealist"), ["g: 我和我的[girl.story_guardian]一起在霍科马广阔的沙漠中长大。", "g: 我了解了我人民的秘密。我们代代相传的古老故事......", "g: 当寒冷的沙漠夜幕降临时，我们为让整个部落保持温暖所做的事情......", "g: ....以及当女孩或男孩成年时的秘密庆祝活动....", "g: 我答应我的[girl.story_guardian]不会向城里人透露我们的生活方式。", "g: 我一言以蔽之。", "g: 这对你来说意味着没有秘密，即使你是我的Master。", "g: 沙漠中发生的事情就留在沙漠里。"], multiple=True)
    add_dialogue("origin Borgo, the port city", ("loyal", "very idealist"), ["g:  令人难以置信的是，博尔戈在大多数日子里是多么忙碌和拥挤。港口如此巨大，吸引着来自Xeros各个角落的各类人群。", "g: 看起来就像一群蜜蜂或蚂蚁！", "g: 我喜欢和我的 [girl.story_guardian] 一起猜测每个人都来自哪里......", "g: 我曾经以为，在繁忙的港口里，每个人都有自己的职责和目的....", "g: ....从码头管理员到水手再到奴隶....", "g: 我想这些天我也会添加港口妓女......*脸红*"], multiple=True)
    add_dialogue("origin the Goliath desolations", ("loyal", "very idealist"), ["g: 他们说歌利亚荒原曾经是一个郁郁葱葱的绿色天堂，但我告诉你，它现在什么也没有留下了！", "g: 荒凉贫瘠，生活艰难。", "g: 我和我的[girl.story_guardian]在一座曾经伟大城市的废墟中长大。", "g: 看得出来规模很大，但我们只剩下不到两百人了....", "g: 为了生存而奋斗。我们必须团结在一起。", "g: 我了解到履行职责和遵守诺言的价值。"], multiple=True)
    add_dialogue("origin the Arik mountains", ("loyal", "very idealist"), ["g: 我在阿里克山区长大。它们位于卡克尔和圣地之间。", "g: 我和我的[girl.story_guardian]一起长大的地方远离任何贸易路线，而且我们没有太多旅行者......", "g: 但是有一次，当我还小的时候，我看到一支军队行进到圣地作战。", "g: 他们在那里太小了....看起来像蚂蚁....但制服真的很鲜艳。", "g: 他们让我很好奇！我想象那些小士兵在军队中都有自己的目标，也有对指挥官的职责！", "g: 我还决定，等我长大了，我要去看看，那里的生活是什么样的....", "g: 我就在这里。"], multiple=True)

    add_dialogue("slave train accepted", ("generic", "loyal", "very idealist"), ("是的主人。", "如您所愿，主人。", "你的愿望就是我的命令，主人。", "哦，[MC.name]主人...*脸红*", "当然，主人。", "我很乐意效劳，主人。", "是啊是啊，[MC.name]主人！"))
    add_dialogue("slave train resisted", ("loyal", "very sub", "very idealist"), ("主人，求你了....不....", "主人，我求求你，我不想这样....", "C-不能...我们不能做点别的吗？", "我、我必须吗，真的吗？我不能..."))
    add_dialogue("slave train refused", ("loyal", "very sub", "very idealist"), ("主人，这....不可能！不！", "主人，对不起，我....我做不到！", "不、不，不是这个....这是....它很脏！", "我不是那种女孩，主人...."))
    add_dialogue("slave lecture love", ("loyal", "very idealist"), ("噢，主人，我们今天要聊什么呢？ *脸红*", "这可能听起来很奇怪，[MC.name]主人。但我喜欢听你谈论几乎任何事情！", "有这样一位学识渊博的主人真是太好了！", "哦哦，今天你想教训我什么淘气的事？ *咯咯笑*"))
    add_dialogue("slave lecture neutral", ("loyal", "very idealist"), ("好的，主人。今天你想讨论什么？", "你想交流？我很高兴学习新事物，但我也相信设定限制很重要。", "一场演讲？我很高兴学习新东西...只要它不是完全变态。"))
    add_dialogue("slave lecture fear", ("loyal", "very idealist"), ("她看起来很害怕，但正在专心听着，生怕惹恼你。"))
    add_dialogue("slave lecture refuses", ("loyal", "very idealist"), ("呃！请不要这样，主人！", "这也太变态了吧！", "这听起来不像是一个好女孩该做的事。"))
    add_dialogue("slave lecture very reluctant", ("loyal", "very idealist"), ("什么？！请不要谈论这个！我不明白女孩子怎么能做出这样的事！", "哦不，这太过分了！我不确定我是否能够做到。", "呃！请不要这样，主人！我知道从事我工作的女孩应该对性持开放态度，但我有我的限制！"))
    add_dialogue("slave lecture reluctant", ("loyal", "very idealist"), ("主人，请不要这样！我可能是个妓女，但我就是看不到[act_desc]的吸引力！", "我根本不明白 [act_desc]...的吸引力。重点是什么？为什么人们喜欢它？", "我想满足客户的幻想，但他们为什么会喜欢这样的东西？！", "人们想对女孩做这件事吗？！我简直不敢相信..."))
    add_dialogue("slave lecture a little reluctant", ("loyal", "very idealist"), ("这不是我最喜欢的...但我想在我的工作中我应该乐于尝试新事物...", "哦，[act_desc]。我不太喜欢这样，但我想有时候一个女孩就必须做她该做的事......"), sound=s_sigh)
    add_dialogue("slave lecture indifferent", ("loyal", "very idealist"), ("哦，那个....我不介意。这就像任何事情一样。", "没关系。我不在乎这样或那样。", "没关系。我是个妓女。不管我是否喜欢每一个行为，都没关系。"))
    add_dialogue("slave lecture a little interested", ("loyal", "very idealist"), ("这是一个有趣的话题，[MC.name]主人。我想知道，您是否有任何关于如何做得更好的建议？", "我明白我的身体是用来享乐的。请给我解释一下，如何充分利用它？", "我想像我这样的性工作者是在用我们的身体工作。如果您能帮助我更好地使用 [act_desc]，那就太好了。"), sound=s_surprise)
    add_dialogue("slave lecture interested", ("loyal", "very idealist"), ("这是一个非常有趣的行为！但为什么我们只谈论它呢？ *眨眼*", "我是一个幸运的女孩，能靠做这样的事情来谋生....*眨眼*"), sound=s_mmh)
    add_dialogue("slave lecture very interested", ("loyal", "very idealist"), ("哦，我喜欢[act_desc]！这是快乐和工作相遇的地方。 *眨眼*"), sound=s_mmh)
    add_dialogue("slave lecture fascinated", ("loyal", "very idealist"), ("这是一个非常有趣的行为！但为什么我们只谈论它呢？ *眨眼*", "我是一个幸运的女孩，能靠做这样的事情来谋生....*眨眼*"), sound=s_aah)
    add_dialogue("slave train obedience", ("loyal", "very sub", "very idealist"), ("琐碎的家务活吧？我想对于一个奴隶来说，这样的事情是应该发生的....", "我想这就是我现在的工作....我最好继续做下去。", "好吧，我想成为你的仆人，所以为什么不......", "我答应做你的婢女，为什么不呢？"))
    add_dialogue("slave train constitution", ("loyal", "very idealist"), ("锻炼？我想我需要保持身材...", "锻炼？我觉得稍微运动一下应该不会有什么坏处...", "当然可以，为什么不呢？我可以做一些运动。", "我想我们女孩都是要锻炼身体的，所以我应该保持身材......", "说得通。我是一名性工作者，所以我应该照顾好自己的身体。"))
    add_dialogue("slave train refuses", ("loyal", "very idealist"), ["她对 [act_desc] 的想法感到非常羞愧，以至于有一段时间无法说话。", "她的脸变成鲜红色。", "g: 对不起，主人....我....我....就是不能。这太过分了..."], multiple=True, sound=s_screams)
    add_dialogue("slave train very reluctant", ("loyal", "very idealist"), ("这就是感觉不对....为什么，主人，为什么？！为什么我必须继续这样做？", "呃，[act_desc]？这件事太超出我的界限了...." , "哇....不是这个....", "呃...[act_desc]...这是人们对女孩的期望吗？他们怎么了？！"), sound=s_scream)
    add_dialogue("slave train reluctant", ("loyal", "very idealist"), ("好的，如果主人觉得有必要的话，我会做的。但我其实不太喜欢...", "请不要用这样的眼神看着我，主人！你知道我不喜欢它...", "我会这么做，因为这是我在这里职责的一部分，但我真的没有从中得到任何东西......"), sound=s_scream)
    add_dialogue("slave train a little reluctant", ("loyal", "very idealist"), ("今天的肮脏训练....感觉很奇怪....", "我知道像我这样的性工作者与我们的身体打交道，我想在这方面做得更好，但这在某种程度上感觉很奇怪。"), sound=s_surprise)
    add_dialogue("slave train indifferent", ("loyal", "very idealist"), ("嗯...啊哈...我不介意做更多的 [act_desc]..."), sound=s_ahaa)
    add_dialogue("slave train a little interested", ("loyal", "very idealist"), ("哦，听起来很有趣！我很想尝试并在这方面做得更好！"), sound=s_ahaa)
    add_dialogue("slave train interested", ("loyal", "very idealist"), ("嗯，[act_desc]...我已经湿透了...工作从来没有这么好过！"), sound=s_mmh)
    add_dialogue("slave train very interested", ("loyal", "very idealist"), ("天哪....我感觉两腿之间好热！"), sound=s_aah)
    add_dialogue("slave train fascinated", ("loyal", "very idealist"), ("哦... [act_desc] 是我的最爱。让我们继续！", "先生，湿透了！ *兴奋的*", "光是提到这件事就让我双腿之间湿润了，先生！", "我的小穴已经准备好工作了，先生！光是提到就让我湿透了！"), sound=s_orgasm_fast)
    add_dialogue("slave train naked failure", ("loyal", "very idealist"), ("不、不、不....对不起，主人。我就是做不到！", "不！这让我太不舒服了。"), sound=s_surprise)
    add_dialogue("slave train naked success", ("loyal", "very idealist"), ("主人，我很高兴我的身体让您满意！"), sound=s_aah)
    add_dialogue("slave train service failure", ("loyal", "very idealist"), ("我愿意侍奉主人，但不是这样的！", "*叹气，低头，沮丧*我该怎么处理它？我不明白...", "主人，我该怎么办？这感觉实在是太奇怪了...."))
    add_dialogue("slave train service success", ("loyal", "very idealist"), ("主人，奖励我...我想要你的精液...太糟糕了。", "主人，你的精液！你的奴隶需要奖励她出色的工作！", "工作完成了，就这样吧！请来找我吧，先生！"))
    add_dialogue("slave train sex failure", ("loyal", "very idealist"), ("感觉不太好....你快结束了吗？", "只是感觉很奇怪，先生....很快就会结束吗？"))
    add_dialogue("slave train sex success", ("loyal", "very idealist"), ("噢...aaahh...我感觉到高潮即将到来...AAAAAH！", "噢，天哪，太阳神！这真是恰到好处！"))
    add_dialogue("slave train anal failure", ("loyal", "very idealist"), ("哦不....它根本不适合放在那里。为什么不使用正确的地方呢？", "不行，太紧了！它不会适合！", "不....为什么不把它放在正确的地方呢！"))
    add_dialogue("slave train anal success", ("loyal", "very idealist"), ("噢噢！！！那个洞真好...", "我很喜欢我的屁股，主人！", "我已经学会了从后门去爱它，主人！ *眨眼*"))
    add_dialogue("slave train fetish failure", ("loyal", "very idealist"), ("你在干什么！由太阳神！不！！！"))
    add_dialogue("slave train fetish success", ("loyal", "very sub", "very idealist"), ("请主人！伤害我！你真的把这个奴隶放在了她的位置上。 *眨眼*", "如果你喜欢惩罚我，我很乐意履行我的职责......*咯咯笑和扭动*", "哎哟...顽皮...*咯咯笑*"))
    add_dialogue("slave train bisexual failure", ("loyal", "very idealist"), ("这感觉太奇怪了....跟别的女孩子在一起根本就没道理啊！", "这不是希露的错，但对于一个女孩来说这感觉不太对劲。对不起，主人。"))
    add_dialogue("slave train bisexual success", ("loyal", "very idealist"), ("先生！我喜欢和另一个女孩在一起！ （....尤其是希露。）", "先生，女孩子是最棒的！", "与女孩发生性关系是如此美好的事情......*微笑*"), sound=s_mmh)
    add_dialogue("slave train group failure", ("loyal", "very idealist"), ("这实在是太不舒服了！我可以对付一个人，但对付不了几个人。 *皱眉*", "我可以和一个男孩一起做，而不是几个！ *受惊*"))
    add_dialogue("slave train group success", ("loyal", "very idealist"), ("呵呵...我可以多带...两个还不够！", "来吧！如果我们有很多顾客，我现在可以一次拿走很多！ *微笑*", "给我带来更多的男孩！我可以把他们全部带走！", "我是专业人士。我能承受的还不止这些！"))
    add_dialogue("slave magic obedience success", ("loyal", "very idealist"), ("你是主人。我服从主人。"), sound=s_ahaa)
    add_dialogue("slave magic libido success", ("loyal", "very idealist"), ("我感到如此温暖...必须跟随我的直觉...去犯罪...并且好好犯罪..."), sound=s_mmh)
    add_dialogue("slave magic sensitivity success", ("loyal", "very idealist"), ("嗯...天使般的高潮..."), sound=s_mmh)
    add_dialogue("slave magic naked success", ("loyal", "very idealist"), ("我的真实本性...是揭露...越来越多"), sound=s_ahaa)
    add_dialogue("slave magic service success", ("loyal", "very idealist"), ("你是我的主和主人...使用我...为了快乐...为了快乐"), sound=s_mmh)
    add_dialogue("slave magic sex success", ("loyal", "very idealist"), ("你是我的主和主人...使用我的子宫...为了快乐... "), sound=s_aah)
    add_dialogue("slave magic anal success", ("loyal", "very idealist"), ("你是我的主和主人......使用我的屁股......为了快乐......"), sound=s_ahaa)
    add_dialogue("slave magic fetish success", ("loyal", "very idealist"), ("你是我的主和主人...使用我的乳头...作为惩罚..."), sound=s_aah)
    add_dialogue("slave magic bisexual success", ("loyal", "very idealist"), ("我是女神的器皿和工具....请带上你卑微的仆人...."), sound=s_mmh)
    add_dialogue("slave magic group success", ("loyal", "very idealist"), ["g: 请带上我吧，欲望之灵....", "g: ....一切为一....一为一切....", "g: ....还有所有这些给我的鸡巴...."], multiple=True, sound=s_ahaa)
    add_dialogue("slave magic failure", ("loyal", "very idealist"), ("这是什么？你到底在做什么？！这实在是太奇怪了。为什么，主人？为什么？！", "刚刚发生了什么？你是想对我使用某种魔法吗？你知道你不必..."), sound=s_scream, unlock="DS")

    add_dialogue("slave reward sex accepted", ("loyal", "very lewd", "very idealist"), ("当然，主人。就在我感到饥渴的时候....*微笑*", "我感觉好热啊！现在就请带我走吧，主人！ *咧嘴笑*"), love=2, sound=s_ahaa, unlock="LM")
    add_dialogue("slave reward sex resisted", ("loyal", "very idealist"), ("几乎没有奖励...只是更多的工作..."), sound=s_surprise, unlock="LM")
    add_dialogue("slave reward sex refused", ("loyal", "very idealist"), ("决不！请别打扰我！", "嘿嘿，这可不专业啊！我现在是个妓女，所以你必须付出代价！", "决不！性行为严格来说只是为了工作。"), sound=s_scream)
    add_dialogue("slave reward praise", ("loyal", "very idealist"), ("谢谢主人！我只是在做我的工作。", "我很高兴您对我的工作感到满意，主人！"), love=2, unlock="MI")
    add_dialogue("slave reward gold", ("loyal", "very idealist"), ("这让我感觉很廉价...", "我不是为了钱才干这行的", "谢谢，但我不太在乎物质的东西", "你以为你可以买所有东西吗？", "你买不到我的尊重和爱。"), love=-1, unlock="MI")
    add_dialogue("slave reward pet", ("loyal", "very sub", "very idealist"), ["你把她抱在膝盖上，拍拍她的头一分钟。你几乎可以听到她的呼噜声。", "g: 噢，主人....在你怀里的感觉真好....", "g: 我内心很高兴你对你女儿在这里的工作感到满意。我已经很努力了。"], multiple=True, love=2, unlock="DS")
    add_dialogue("slave reward day off", ("loyal", "very sub", "very idealist"), ("呃，什么？但、但是....我应该去哪里？？？", "好吧，但我只是喜欢在这里并在这里工作......", "我想休息一下是件好事....但我真的不知道该做什么？！", "但为什么我不能轮班工作呢？", "我认为工作比休息更重要。其实我也不知道该怎么办！", "这很好，但我认为工作比休息更重要。"), love=-2, unlock="DS")
    add_dialogue("slave reward day off KO", ("loyal", "very idealist"), ["g: 如果可以的话我会的，但是今天已经是我的休息日了，主人....", "mc: 啊，当然。我不记得了..."], multiple=True)
    add_dialogue("slave punish scold deserved", ("loyal", "very idealist"), ["她脸红了。", "g: 非常抱歉，主人。我应该更好地履行我的职责..."], multiple=True, fear=1, unlock="MI")
    add_dialogue("slave punish scold undeserved", ("loyal", "very idealist"), ["她看起来很受伤。", "g: 但这既不真实也不公平！我不值得这样！"], multiple=True, love=-2, fear=1, unlock="MI")
    add_dialogue("slave punish upkeep", ("loyal", "very idealist"), ("啊....真可惜，但我能活下来。", "我并不太在乎钱，你知道吗？", "只要我头顶上有食物和屋顶，我就没事....", "好吧....不管怎样，我不是为了物质奖励。"), fear=-1, unlock="MI")
    add_dialogue("slave punish upkeep KO", ("loyal", "very idealist", "generic"), ["g: 但、但是....你已经把它删除了....", "mc: 啊，当然....我忘了。"], multiple=True)
    add_dialogue("slave punish beat", ("loyal", "very sub"), ["当你打她时，她会抽泣，直到她的屁股完全变红。", "g: 哦....对不起，主人....*呜咽*", "g: 对不起，我让你失望了！ *嗅闻*"], multiple=True, fear=1, sound=s_screams, unlock="DS")
    add_dialogue("slave punish farm", ("loyal", "very sub"), ("好吧，我想我得去吉泽尔了....*咕噜*", "拜托，不是农场....*咕噜*"), fear=-1, unlock="DS")
    add_dialogue("slave punish naked", ("loyal", "very lewd"), ["g: 但是请主人...每个人都会看到我...*抽泣*", "mc: 这就是重点。"], multiple=True, unlock="LM")
    add_dialogue("slave punish naked KO", ("loyal", "very idealist"), ["g: 呃？但是主人....你没看到吗，我已经赤身裸体了！我真的那么难发现吗？", "mc: 哈哈....当然。只是在开玩笑！"], multiple=True)
    add_dialogue("slave punish rape", ("loyal", "very idealist"), ("不，主人....请不要这样对待我！ *哭泣*", "现在不行，主人！不是这样的！请！！！ *哭泣*", "你太难为我了，主人！好痛！ *哭泣*"), fear=-1, unlock="LM")
    add_dialogue("slave raped", ("loyal", "very idealist"), ["啊啊啊....不....啊啊啊！", "不哦！！！哦！！！啊啊！！！"], sound=s_screams)
    add_dialogue("slave rape positive fixation", ("loyal", "very idealist"), ("呵呵...其实我很喜欢被这样对待！", "很脏但是很好！", "呵呵，你发现了我的怪癖....*气喘吁吁*。", "哇哦....感觉出奇的好。我想我就是喜欢 [act_desc]！"), love=2, fear=-1, sound=s_aah)
    add_dialogue("slave rape negative fixation", ("loyal", "very idealist"), ("不，不是这个！！！除了这个还有什么！！！不不不！！！", "这太可怕了！在所有可能的事情中，你强迫我这样做[act_desc]。"), love=-2, fear=3, sound=s_scream_loud)

    add_dialogue("rest", ("loyal", "very idealist"), ("我现在要休息一下，以便以后可以更好地工作。 {w=1.0}{nw}"))
    add_dialogue("accept job", ("loyal", "very idealist"), ("如您所愿，我现在将担任{b}[girl.job_cn]{/b}，并尽全力满足客户的需求。{w=1.0}{nw}"))
    add_dialogue("work_whore", ("loyal", "very idealist"), ("我现在将担任{b}[girl.job_cn]{/b}和妓女，以满足客户的需求。{w=1.0}{nw}"))
    add_dialogue("exhausted", ("loyal", "very idealist"), ("对不起主人，我还是很累。我需要多休息。", "康复后，我将回去担任 {b}[girl.job_cn]{/b} 的工作。我需要保持良好的状态才能正确地完成这件事。"))
    add_dialogue("rank up", ("loyal", "very idealist"), ("谢谢主人。我现在是一名[newrank]奴隶。准备好把工作做得更好！"))
    add_dialogue("refuse whoring", ("loyal", "very idealist"), ("哇哦，没办法！！！我不是那种女孩！你觉得我怎么样？ *哭泣*"))
    add_dialogue("refuse sex act", ("loyal", "very sub", "very idealist"), ("主人，这....不可能！不！", "主人，对不起，我....我做不到！", "不、不，不是这个....这是....它很脏！", "我不是那种女孩，主人...."))

    add_dialogue("bought", ("loyal", "very idealist"), ["g: 主人您好。我来这里是为了成为你忠实的仆人......", "g: ...但是请友善一点，不要问我不可能的事。"], multiple=True)
    add_dialogue("freed", ("loyal", "very idealist"), ("我想这就是再见了，那么....我希望我能找到其他人，他们会感激我的服务...."))
    add_dialogue("sold", ("loyal", "very idealist"), ("我想这就是再见了，那么....希望我的新主人能够感谢我的服务...."))
    add_dialogue("sold love", ("loyal", "very idealist"), ["g: 请不要出卖我，主人！ *哭泣*。我不是你最忠实的仆人吗？", "g: 我已经尽力在这家青楼工作中取得成功，因为我爱你...... *哭泣*"], multiple=True, sound=s_surprise)
    add_dialogue("leave for quest", ("loyal", "very idealist"), ("主人，我要去....我会让您骄傲！", "主人，我要去....我会让[brothel.name]自豪！"))
    add_dialogue("leave for class", ("loyal", "very idealist"), ("主人，我走了。我希望他们能教我在工作中做得更好！", "好的，我这就去，主人！我希望他们能提供一些关于如何更好地取悦男人的好建议！ *眨眼*", "我这就去，主人。我希望他们能帮助我在这方面做得更好！", "听起来这堂课很有趣，先生！让我们看看我能学到什么！", "我要去。希望我能成为众多顾客的梦中情人！"))
    add_dialogue("advertise", ("loyal", "very idealist"), ("来看看[brothel.name]里的辣妹....她们都非常擅长她们所做的事情！", "快来看看我们可爱的女孩们吧！", "快来看看我们可爱的女孩们吧！那就来吧我们可爱的女孩们！" , "先生，我们都是爱情艺术的专业人士！快来[brothel.name]见我们吧！ *眨眼*", "这就是我们[brothel.name]女孩的样子！来看看你能和我们一起做什么... *眨眼*"))

    add_dialogue("beach intro", ("loyal", "very idealist"), ["[girl.fullname] 正在帮助一个小男孩建造一座沙堡。路人拍着屁股问，多少钱？", "她礼貌地微笑着，但拒绝说今天是她的休息日。"], multiple=True, sound=s_laugh)
    add_dialogue("beach meet MC", ("loyal", "very idealist"), ["g: 您好，[MC.name]主人！很高兴在这里见到你！正如你所看到的，我很享受我的休息时间，所以当我回到工作岗位时我感到精神焕发和放松。", "她低着头，似乎因为没有工作而感到有点内疚，尽管这不是她的轮班。", "她的身材穿着紧身泳衣看起来很漂亮，这给了你一个想法......"], multiple=True)
    add_dialogue("beach oiling", ("loyal", "very idealist"), ["g: 谢谢主人！那种感觉真好....", "g: 请把那些东西擦在我身上......"], multiple=True, sound=s_ahaa)
    add_dialogue("beach accept oiling", ("loyal", "very idealist", "very sub"), ["g: 哦，主人今天心情不好啊！", "g: 那太好了....*呻吟*"], multiple=True)
    add_dialogue("beach refuse oiling", ("loyal", "very idealist"), ["g: 但是，主人，请不要碰我那里！", "g: 轮班后我仍然感到酸痛......"], multiple=True)
    add_dialogue("beach accept public sex", ("loyal", "very idealist"), ["g: Master，你想当着这么多人的面这么做吗？！", "mc: 没错，女孩。我会傻傻地操你，他们会看着的。这对青楼来说是很好的宣传。", "g: 很公平，先生...我想我是作为[brothel.name]的雇员来到这里...即使今天是我的休息日...", "g: 先生，让我们给他们表演一场让我们的机构感到自豪的表演吧！"], multiple=True)
    add_dialogue("beach refuse public sex", ("loyal", "very idealist"), ["g: 什么？！？不，我不能，主人！不是当着这么多人的面...", "g: ....对不起，我真的需要休息！上周让我感觉全身酸痛......"], multiple=True)
    add_dialogue("beach accept sex", ("loyal", "very idealist"), ["g:  先生，您想现在就做吗？", "mc: 没错，女孩。", "g: 当然，主人。如果你需要一个好的他妈的...", "g: 我想我们女孩的工作就是帮助你获释....", "g: ....任何时间、任何地点。 *微笑*"], multiple=True)
    add_dialogue("beach refuse sex", ("loyal", "very idealist"), ["g: 真的很抱歉主人，但我现在做不到。", "g: 工作让我的腰部酸痛得几乎无法行走！"], multiple=True)
    add_dialogue("beach whoring request", ("loyal", "very idealist"), ["g: 但是，主人，今天是我的休息日！", "g: 剩下的我真的可以用，这样我以后就能更热情地为顾客服务...."], multiple=True)
    add_dialogue("beach whoring accept", ("loyal", "very idealist"), ["g: 如果这是您的愿望，主人，我的职责就是服从。", "g: 毕竟....", "g: 即使今天是休息日，我也是[brothel.name]的员工。", "g: 你想让我带顾客去哪里？"], multiple=True)
    add_dialogue("beach whoring refuse", ("loyal", "very idealist"), ["g: 实在抱歉主人，但我必须恭敬谢绝。", "g: 我确实需要一些时间来恢复。最后一班让我酸痛得几乎无法走路！"], multiple=True)

## START YANDERE DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("yandere", "creep"), ("哦你好。我的名字是[girl.fullname]。我感觉我想更多地了解你。多很多。", "好吧，看看我们这里有谁....很高兴见到你，先生。我是[girl.fullname]。", "*咯咯笑*你好。我想我们会相处得很好。我是[girl.fullname]。", "你好吗，[MC.name]。我的名字是[girl.fullname]。", "你很可爱！我的名字是[girl.fullname]。我们应该多见面。"))
    add_dialogue("free_greetings_casual", ("yandere"), ("好吧，看看我们这里有谁...很高兴见到你。我是[girl.fullname]。", "你好吗，[MC.name]。我的名字是[girl.fullname]。", "*咯咯笑*你很可爱！我的名字是[girl.fullname]。我们应该多见面。"))
    add_dialogue("free_greetings_rude", ("yandere"), ("哦你好。我的名字是[girl.fullname]。我感觉我想更多地了解你。多很多。", "*咯咯笑*你好。我想我们会相处得很好。我是[girl.fullname]。", "*咯咯笑*你很可爱！我的名字是[girl.fullname]。我们应该多见面。", "*咯咯笑*我{i}喜欢{/i}你！我的名字是[girl.fullname]。别当陌生人！"), love=3)

    add_dialogue("free_small_talk", ("yandere", "stubborn"), ("嗯....也许下次我们可以谈谈别的事情？", "我们为什么不谈谈别的事情呢？", "哦真的吗？", "我知道，对吧？"), max_cap=25)
    add_dialogue("free_gossip", ("yandere", "helper"), ("我听到了一些有趣的事情...", "一个朋友的朋友告诉我这件事...", "你永远不会相信...", "听听这个...", "你听说（这件新闻）了吗？"), love=1, max_cap=25)
    add_dialogue("free_chat_life", ("yandere"), ("我以前除了家人之外没有和任何人住过，所以我没见过太多的世界。", "我希望我能成为一名冒险家。探索未知的土地对我来说听起来很令人兴奋。", "我想知道从云层之上凝视这个世界会是什么样的感觉。","抱歉，我们可以谈谈别的事情吗？", "嗯...对不起。也许下次我们可以谈谈别的事情？", "我们为什么不谈谈别的事情呢？"), max_cap=25)
    add_dialogue("free_chat_love", ("yandere", "creep"), ("坠入爱河是很自然的事，不是吗？我想我现在可能爱上某人了！ *眨眼*", "有人说我对爱情有点执着....这不是很好吗？", "爱情可以如此令人兴奋。我有时会有点嫉妒。 *傻笑*", "嗯...爱不仅仅是一个词。你在心里感受到它，并在你的行动中表现出来。", "哦，这个世界上没有比这更好的事情了。我往往会变得非常热情。 *傻笑*"), love=3, max_cap=25)
    add_dialogue("free_chat_origins", ("yandere"), ("哦，你知道...我去过这里、那里、到处。 [girl.origin] 是我首先想到的地方。", "我在[girl.origin]长大。不幸的是，某些情况迫使我把这种生活抛在脑后。", "不幸的是我不得不放弃我在[girl.origin]的旧生活。"), max_cap=40)
    add_dialogue("free_chat_hobbies", ("yandere", "stubborn", "schemer"), ("我沉迷于[hobby]。当我看到别人做错事时，我会非常{i}愤怒{/i}。 *傻笑*", "当谈到[hobby]时，我变得{i}非常{/i}充满热情。", "我真的很喜欢[hobby]。你不敢对此说任何负面的话。"), love=1, max_cap=40)
    add_dialogue("free_chat_likes", ("yandere", "schemer"), ("听着，[best]是一件很棒的[thing_cn]。这没有争议。", "我讨厌有人不喜欢[best]作为[thing_cn]。我的意思是....什么？这是最好的[thing_cn]！这是事实！", "每当有人没有给予[thing_cn][best]应有的尊重时，我就会非常生气。"), love=3, max_cap=40)
    add_dialogue("free_chat_dislikes", ("yandere"), ("嗯...我想是[thing_cn][worst]？说实话，我真的不在乎。","在我看来，[thing_cn][worst]并不是那么特别。但谁关心这些东西....我们能谈谈别的吗？"), max_cap=40)

    add_dialogue("free_joke_harmless", ("yandere", "princess"), ("*叹气*你让我厌烦了。","当你开始说这种胡言乱语时，我的大脑很受伤。","让我们假装那件事没有发生...我以为你比这更有趣。", "*打哈欠*请不要让我感到无聊。", "*叹气*你在用这种废话浪费我们的时间。"), max_cap=50)
    add_dialogue("free_joke_adult", ("yandere"), ("*笑*轮到我了！关闭的青楼上的牌子上写着什么？打败它。我们关门了。", "*咯咯*好吧，这个怎么样....你的妻子和你的工作有什么区别？五年后，你的工作仍然很糟糕。", "*笑*这个怎么样....香蕉对振动器说了什么？为什么{i}你{/i}发抖？她会{i}吃掉{/i}我！", "*咯咯笑*轮到我了！阴道还有什么名字？装着阴茎的盒子。", "*笑*哦，我知道一个！怎样才能让女朋友在做爱时尖叫呢？取下堵嘴。", "*笑*下一个是我！生命如何像阴茎？你的女朋友让你很难受。", "*笑*好吧，怎么样....为什么女人会有高潮？确实，这只是另一个抱怨的理由。", "啊哈哈哈....轮到我了！什么又长又硬，有两个拇指宽，让女孩们想操你？一把匕首。"), love=3, max_cap=50)
    add_dialogue("free_joke_dark", ("yandere", "helper"), ("*咯咯笑*可能更糟。", "*咯咯笑*很公平。", "*咯咯笑*还不错。"), love=1, max_cap=50)
    add_dialogue("free_joke_mean", ("yandere", "class president"), ("*叹气*你听起来很可怜​​。","当你开始说这种胡言乱语时，我的大脑很受伤。","让我们假装那件事没有发生...我以为你比这更有趣。", "... 打扰一下？请不要再这样激怒我了。", "*叹气*你在用这种废话浪费我们的时间。", "*生气*你想激怒我吗？"), love=-1, max_cap=50)

    add_dialogue("free_touch_hand", ("yandere", "stubborn"), ("当我们手牵着手时，我感到很幸福。", "*咯咯*你现在不能逃离我了。", "现在你都是我的了。", "好孩子....靠近我。", "*咯咯*我永远不会放手。"), love=1, max_cap=90)
    add_dialogue("free_touch_kiss", ("yandere"), ("*咧嘴一笑*就这样，协议完成了。","嘿，听着....如果我曾经虐待过你，请知道我有时就是这样表达我的爱的。","*咯咯笑*现在把你的牙齿打进去真是太有趣了。只是在开玩笑！ *吻*", "你已经放松了警惕....我现在就可以轻易扭断你的脖子。别担心，我绝不会做那样的事。我爱你。 *吻*"), love=2, max_cap=90)
    add_dialogue("free_touch_ass", ("yandere", "creep"), ("你今天没有勾搭其他女孩吧？只有我？只有我，对吧？！","呃呃呃....你现在就想玷污我吗？","呵呵....你想在黑暗安静的地方继续吗？", "呵呵。你对自己的愿望如此诚实。","嗯....你可以随意摸索我——而且只能摸索我——随你便。"), love=2, max_cap=90)
    add_dialogue("free_touch_breasts", ("yandere", "creep"), ("*呻吟*我...现在非常非常饥渴。", "*呻吟*我很高兴我是你的。我再也不会这么高兴了。","啊....我很抱歉成为一个如此肮脏的女孩....你太性感了，我无法抗拒。", "呵呵。它们是专为您而设计的。"), love=4, max_cap=90)
    add_dialogue("free_touch_pussy", ("yandere", "creep"), ("啊... *呻吟*如果你继续下去，我对你的爱将会爆发为暴力。", "啊....我无法停止思考我想强迫你做的所有肮脏的事情....", "啊....这种快乐真是太神圣了。这让我想要伤害别人。", "*呻吟*我非常爱你，我想我可能不得不把你关起来。", "*喘气*开门见山确实是最好的方法。 B、温柔点...."), love=3, max_cap=90)

    add_dialogue("free_play refuses", ("yandere"), ("*叹气*我们先别去那里。我害怕在激情的时刻我会伤害你脆弱的小脖子。"), love=-1)
    add_dialogue("free_play very reluctant", ("yandere", "creep", "very lewd"), ("我讨厌这样....但如果它让你兴奋，我会为你牺牲自己。"), love=1)
    add_dialogue("free_play reluctant", ("yandere", "very lewd", "creep"), ("呵呵。你的眼神里充满了{i}我要取笑她{/i}的表情。我可以像读一本打开的书一样读懂你。所以永远、永远不要对我撒谎。"), love=2)
    add_dialogue("free_play a little reluctant", ("yandere", "stubborn"), ("答应我，除了我，你不会想到任何女孩。除了你我谁也不想。只有你。"), love=2)
    add_dialogue("free_play indifferent", ("yandere", "very lewd", "creep"), ("呵呵....我实在无法忍受你再看我了。停止寻找，开始触摸！"), love=3)
    add_dialogue("free_play a little interested", ("yandere", "creep"), ("呵呵，我的每一寸都是你的，从发尾到脚趾尖。"), love=4)
    add_dialogue("free_play interested", ("yandere", "pet"), ("如果我们能一起度过永恒就好了...."), love=4)
    add_dialogue("free_play very interested", ("yandere", "creep"), ("呃呃呃...你永远摆脱不了我，[MC.name]。"), love=5)
    add_dialogue("free_play fascinated", ("yandere"), ("呵呵，你的建议真是周到啊。现在我不需要用刀强迫你了。"), love=5)
    add_dialogue("MC take virginity", ("yandere"), ("嗯...我们是天生一对。你是我的第一个....鲜血让一切变得更加令人兴奋！"), love=5)
    add_dialogue("free_play interested after", ("yandere"), ("诶嘿嘿嘿....以后一起玩得更开心吧。"))
    add_dialogue("free_play not interested after", ("yandere"), ("你已经无可救药了。认真想想你刚刚做了什么，好吗？"))

    add_dialogue("free_flirt_beauty", ("yandere"), ("小心你对我说的话，记住莎莉亚正在监视你的一举一动。","不像你那可悲的自己....啊！抱歉，我刚才是大声说出来了吗？ T、这就是我有时表达我的爱的方式。","你不介意我时不时有点精神错乱吧？", "*叹气*看来你还是有一些缺陷....只要有足够的力量，我相信我能让你变得更好。"), love=1, max_cap=75)
    add_dialogue("free_flirt_body", ("yandere"), ("*咧嘴笑*哇，谢谢！现在任何介入你我之间的人都可以{i}死{/i}。", "*咧嘴笑*谢谢！我必须警告你，我是一个嫉妒的女孩。我希望你属于我，但我不会善意地对待别人碰我的东西。", "*笑*哇...愿莎莉亚祝福你和你的家人！", "*咯咯笑*不像你。我们属于一体，你和我。", "啊哈哈....你总是知道该说什么！我开始为你着迷。"), love=4, max_cap=75)
    add_dialogue("free_flirt_mind", ("yandere"), ("小心你对我说的话，记住莎莉亚正在监视你的一举一动。","不像你那可悲的自己....啊！抱歉，我刚才是大声说出来了吗？ T、这就是我有时表达我的爱的方式。","嘘....不说话了。只是听。因为你是我的朋友，所以我会给你{i}一次[/i]警告。别再用这种废话来烦我了。", "*叹气*看来你还是有一些缺陷....只要有足够的力量，我相信我能让你变得更好。", "算了吧。 {i}我{/i}应该是戏弄{i}你{/i}的人，而不是相反。"), love=-1, max_cap=75)
    add_dialogue("free_flirt_spirit", ("yandere"), ("*咧嘴笑*哇，谢谢！现在任何介入你我之间的人都可以{i}死{/i}。", "*咧嘴笑*谢谢！我必须警告你，我是一个嫉妒的女孩。我希望你属于我，但我不会善意地对待别人碰我的东西。", "你不介意我时不时有点精神错乱吧？","*笑*哇...愿莎莉亚祝福你和你的家人！", "*咯咯笑*不像你。我们属于一体，你和我。", "啊哈哈....你总是知道该说什么！我开始为你着迷。"), love=2, max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("yandere"), ["她疯狂地笑。", "g: 我不会告诉你所有残酷的细节，但是是的。", "g: 你现在需要知道的是，这一切都不重要。从现在开始，就只有你和我了。 *眨眼*"], multiple=True, love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("yandere"), ["g: 诶嘿嘿....是的，可以这么说。", "g: 但为了你，我会尽力控制自己的冲动并表现得更好。 *咧嘴笑*"], multiple=True, love=2)
    add_dialogue("free_flirt_sex_experience average", ("yandere"), ["她微笑着对你眨眼。", "g: 哦，我只是一个普通的女孩。我保证！"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("yandere"), ["她咯咯笑，脸红了。", "g: 哇哦，这不是你应该问女士的问题！", "g: 这么说吧....我尝试过几次，但我以前的男朋友都没有达到我的期望。"], multiple=True)
    add_dialogue("free_flirt_sex_experience very inexperienced", ("yandere"), ["她咯咯笑，脸红了。", "g: 哇哦，这不是你应该问女士的问题！", "g: 让我这样说吧....我对迄今为止我所拥有的每一段感情都深感遗憾。"], multiple=True, love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("yandere"), ["她咯咯笑，脸红了。", "g: 哇哦，这不是你应该问女士的问题！", "g: 这么说吧....我还没有遇到值得我奉献的人。"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("yandere"), ["她敬畏地抬头看着你。", "g: 我很高兴听到这个消息！爱情是值得珍惜的东西。", "g: 如果你只是把爱送给每个人，那它还有什么好处呢？大多数时候，讨厌别人会更好。这会让您找到爱人的时光变得更加甜蜜。"], multiple=True, love=2)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("yandere"), ["她向你投来好奇的目光。", "g: 我不相信你，但至少你的心是对的。爱情是值得珍惜的东西。", "g: 如果你只是把爱送给每个人，那它还有什么好处呢？大多数时候，讨厌别人会更好。这会让您找到爱人的时光变得更加甜蜜。"], multiple=True, love=2)

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("yandere"), ["g: *叹气*所以你的意思是你和其他人一样。", "g: 我对你很失望，[MC.name]。非常失望。"], multiple=True)
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("yandere"), ["g: *叹气*你和我都知道你对我不诚实。", "g: 我对你很失望，[MC.name]。非常失望。"], multiple=True, love=-1)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("yandere"), ["g: *叹气*这很不幸。", "g:  你认为你能给我提供一份清单吗？ *低语*消除他们所有人将是一件苦差事......"], multiple=True, love=-1)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("yandere"), ("这正是我为你建造一座神社的原因。"), love=4)
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("yandere"), ["g: 你是一个梦想家，我喜欢你这一点......", "g: 你可能还不是城里最好的歌手，但我想你很快就能达到这些高度。", "g: 让我们想想....我需要一根鞭子和一些铁链作为开始。也许我可以给你连接一台机器？"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("yandere"), ["g: 啊，你的才华都浪费在那些麻木不仁的女孩身上了。", "g: 我敢打赌你根本不知道什么是真爱。", "g: 我可以告诉你，燃烧的激情之火可以变得多么灼热....呃呃呃...."], multiple=True, love=1)

    add_dialogue("free_flirt_sex_act refuses", ("yandere"), ["她皱起眉头，挥舞着一把刀。","g: 让我用另一个问题来反驳你的问题。如果我把你的老二割掉你会喜欢吗？"], multiple=True)
    add_dialogue("free_flirt_sex_act very reluctant", ("yandere"), ("呃....我并不是不肯做这样的事，但确实会让我产生杀气。"))
    add_dialogue("free_flirt_sex_act reluctant", ("yandere"), ["g: 你是一个精神错乱的人......", "g: 话又说回来，我们不都是这样吗？ *眨眼*"], multiple=True)
    add_dialogue("free_flirt_sex_act a little reluctant", ("yandere"), ["她耸耸肩，翻白眼。", "g: 为什么我感觉你问这个问题的时候是在用眼神脱我的衣服？", "g: 我应该省点你的脑力，就在此时此地脱掉我的衣服吗？你可以随时询问。"], multiple=True)
    add_dialogue("free_flirt_sex_act indifferent", ("yandere"), ["她耸耸肩，微笑着。", "g: 你正在想象我现在的处境，不是吗？", "g: 没关系。我确信，与我对你的幻想相比，你的不安幻想显得苍白无力。 *傻笑*"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_act interested", ("yandere"), ["她笑得很诡异。","g: 呃呃呃....我很好奇想尝试一下。", "g: 我想知道我可以添加什么样的曲折来让一个男人尖叫。"], multiple=True, love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("yandere"), ["她点点头，笑了。", "g:  这很正常，不是吗？事实上，我敢说任何不喜欢这样的人都是精神病患者。"], multiple=True, love=2)
    add_dialogue("free_flirt_sex_act very interested", ("yandere"), ["她笑得很诡异。","g: 呃呃呃....啊，这让我回想起了。当我们年轻的时候，我常常强迫我的姐妹们做出这样的事情。"], multiple=True, love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("yandere"), ("*呻吟*你知道如何按下我的按钮...想跟着我进入黑暗的小巷吗？"), love=3)

    add_dialogue("free_give_gold +++", ("yandere", "nerd"), ("哇哦，谢谢你[MC.name]。我想我快要疯了，我是如此爱你！"), love=6, max_cap=75)
    add_dialogue("free_give_gold ++", ("yandere"), ("哦，我知道该怎么做。别担心，这不是一把刀或类似的奇怪东西。"), love=4, max_cap=75)
    add_dialogue("free_give_gold +", ("yandere"), ["g: 谢谢你，[MC.name]。在这个悲惨的日子里，这正是我所需要的。", "g: 我正处于失去它的边缘，但你成功地缓和了我的情绪。"], multiple=True, love=2, max_cap=75)
    add_dialogue("free_give_gold -", ("yandere"), ("我警告你，不要试图对我们这里拥有的东西进行估价。我们俩的结局都不会好。"), max_cap=75)
    add_dialogue("free_give_gold --", ("yandere"), ["她后退了几步，用力将钱袋扔向了一个恰好走过的孩子。", "当硬币击中孩子的后脑勺时，你听到一声巨响。", "g: 啊哈哈哈！你看到了吗？你看，这么多血！！这太棒了。谢谢[MC.name]。"], multiple=True, love=-1, max_cap=75)
    add_dialogue("free_friend no_lie", ("yandere"), ["g: *咯咯*所以你以鞭打女孩为生？令人着迷的东西...", "mc: 是的，当然。那么你呢？", "g: 啊，我过得去...."], multiple=True, love=2)
    add_dialogue("free_friend half_lie", ("yandere"), ["g: 呃....这听起来非常无聊。如果您有上吊的冲动，请告诉我，我很乐意提供帮助。", "mc: 不用了，谢谢。那么我假设我的工作与你的相比相形见绌，是吗？", "g: 啊，我其实没有工作...."], multiple=True, love=-5)
    add_dialogue("free_friend lie", ("yandere"), ["g:  嗯，你不常听到这个。很有意思...", "mc: 那你呢？", "g: 嗯，我还在市场上...."], multiple=True, love=3)
    add_dialogue("gizel take girl to farm", ("yandere"), ("好吧，你这个神经病的婊子，现在就来吧。让我们看看当你在每个洞都被蹂躏时，你是否还能保持这种斗志。"))
    add_dialogue("slave chat tastes likes", ("yandere", "schemer"), ("听着，[best]是一件很棒的[thing_cn]。这是不容置疑的。", "我讨厌有人不喜欢[best]作为[thing_cn]。我的意思是....什么？这是最好的[thing_cn]！这是事实！", "每当有人没有给予[best]作为[thing_cn]时应有的尊重，我就会非常生气。"), unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("yandere"), ("嗯...我想是[thing_cn][worst]？说实话，我真的不在乎。","在我看来，[thing_cn][worst]并不是那么特别。但谁关心这些东西....我们能谈谈别的吗？"), unlock="LM")
    add_dialogue("slave chat origins 1", ("yandere"), ("哦，你知道...我去过这里、那里、到处。 [girl.origin] 是我首先想到的地方。", "我在[girl.origin]长大。不幸的是，某些情况迫使我把这种生活抛在脑后。", "不幸的是我不得不放弃我在[girl.origin]的旧生活。"), unlock="EI")

## START STUBBORN DIALOGUE 03.February.2022

    add_dialogue("free_greetings_polite", ("stubborn", "class president", "very modest", "very dom"), ("至少你有礼貌，即使他们非常过分。我是[girl.fullname]。 *微笑*"), love=2)
    add_dialogue("free_greetings_casual", ("stubborn", "helper", "nerd", "very dom"), ("你好。我是[girl.fullname]。很高兴见到你。我想知道，你在追求什么？", "你好。我是[girl.fullname]。很高兴见到你。我希望我们能有一些共同点。"), love=2)
    add_dialogue("free_greetings_rude", ("stubborn", "repressed", "prude", "very modest", "schemer"), ("你说话就像个真正的流浪汉。我是[girl.fullname]，我认为我们没有任何共同点！", "我是[girl.fullname]。我看起来像那种喜欢听到陌生人这样评论的女孩吗？", "我的名字是[girl.fullname]。听起来你像是在找人打你的脸，[MC.name] 先生。"), love=-1)

    add_dialogue("free_small_talk", ("stubborn", "rebel"), ("我觉得闲聊有点不真诚。", "我不是一个喜欢闲聊的人。", "我们来谈谈更重要的事情吧。"), max_cap=25)
    add_dialogue("free_gossip", ("stubborn", "holy"), ("八卦？在这座道德败坏的城市里，不乏这样的人。不过它可能非常多汁......", "我不是一个喜欢八卦的人，但是你听说过吗....？",  "这里的每个人都很有判断力。只要看一眼就很容易辨别！他们说..."), love=1, max_cap=25)
    add_dialogue("free_chat_life", ("stubborn", "schemer"), ("只要生命、宇宙和一切不妨碍我，我都不介意。","嗯，宇宙和一切都在外面，但生命却在这里。为什么不集中精力呢？","生命、宇宙和一切？我倾向于对他们有自己的看法，而且我总是对的！"), love=2, max_cap=25)
    add_dialogue("free_chat_love", ("stubborn", "very dom", "rebel"), ("我正在寻找一个能够尊重我的男人。并且完全按照我说的去做。 *眨眼*"), love=1, max_cap=25)
    add_dialogue("free_chat_origins", ("stubborn", "very extravert", "prude", "sweet"), ("我来自[girl.origin]。没有一个地方像家一样，不是吗？那里有我太多的回忆..."), love=2, max_cap=40)
    add_dialogue("free_chat_hobbies", ("stubborn"), ("我知道我喜欢什么并且我喜欢[hobby]。", "天哪，很高兴你问！我真的可以花几个小时[hobby]！"), love=1, max_cap=40)
    add_dialogue("free_chat_likes", ("stubborn"), ("我是一个与自己的情感相协调的女人，我就是爱[best]！", "我知道我喜欢什么并且我最喜欢[best]！", "我通常对我喜欢的事情充满热情。例如，我最喜欢的[thing_cn]是[best]。我就喜欢！"), love=1, max_cap=40)
    add_dialogue("free_chat_dislikes", ("stubborn"), ("我为自己非常了解自己而感到自豪。这也意味着我知道自己不喜欢什么。例如，我最不喜欢的[thing_cn]是[worst]。布莱...", "呃....我真的很讨厌[worst]。", "有些东西我真的不喜欢，比如[worst]。", "我无意评判，但我很难理解那些喜欢[worst]的人。", "我不想评判，但我怎么能不评判那些最喜欢的[thing_cn]却是[worst]人呢？我只是觉得我们没有任何共同点！"), max_cap=40)

    add_dialogue("free_joke_harmless", ("stubborn", "schemer"), ("那太愚蠢了。", "你真够无聊的。", "到底怎么回事，[MC.name]？这应该是个笑话吗？"), max_cap=50)
    add_dialogue("free_joke_adult", ("stubborn", "repressed"), ("这应该很有趣吗？", "这是非常色情和粗俗的，我不喜欢它。"), love=-1, max_cap=50)
    add_dialogue("free_joke_dark", ("stubborn", "loyal"), ("那真好笑！", "哈哈，你真有趣！", "啊哈哈，真有趣，先生！"), love=5, max_cap=50)
    add_dialogue("free_joke_mean", ("stubborn", "rebel"), ("你怎么敢对我说这种话，先生！ *发烟*", "滚出我的视线，如果那是你的搞笑点的话！", "我看起来像那种喜欢评论的女孩吗？你是想找人打你的脸吗？"), love=-1, max_cap=50)

    add_dialogue("free_touch_hand", ("stubborn", "very dom"), ("嘿，是你吗，[MC.name]？ *微笑*握住我的手，男孩！","哇....我​​们手牵着手吧。", "我们可以牵手。别害羞，[MC.name]！"), love=3, max_cap=90)
    add_dialogue("free_touch_kiss", ("stubborn", "princess"), ("这是出乎意料的，[MC.name]！我并不完全反对像这样的浪漫表演...过来吻我，[MC.name]！", "吻我吧，[MC.name]！", "来吧，吻我，男孩！"), love=4, max_cap=90)
    add_dialogue("free_touch_ass", ("stubborn", "repressed", "princess"), ("表现自己。", "把手放在自己身上。", "谁允许你这么做的？！"), max_cap=90)
    add_dialogue("free_touch_breasts", ("stubborn", "helper"), ("哈哈，我昨晚做了一个梦，梦见你告诉我我的胸部很棒！我醒来时脸上带着微笑...你可以触摸它们，[MC.name]...", "来吧，触摸我的胸部，[MC.name]！我想感受你的按摩。 *眨眼*", "我注意到你喜欢我的胸部。 *微笑*"), love=2, max_cap=90)
    add_dialogue("free_touch_pussy", ("stubborn", "repressed"), ("我允许你碰我那里了吗，先生？", "我勒个去！先生，请把手放在自己身上！ *尖叫声*"), love=-1, max_cap=90)

    add_dialogue("free_play refuses", ("stubborn", "princess"), ("不，因为我不想！！！", "我没心情，[MC.name]。", "我没心情，[MC.name]。你会学会尊重这一点！") , love=-1)
    add_dialogue("free_play very reluctant", ("stubborn", "schemer"), ("我相信我们的关系，这就是为什么我会为你做这件事。你最好给我一些好东西作为回报。"), love=1)
    add_dialogue("free_play reluctant", ("stubborn", "generic"), ("好吧，我就让你随心所欲吧。到这里来，[MC.name]。"), love=2)
    add_dialogue("free_play a little reluctant", ("stubborn", "loyal", "pet", "yandere"), ("我很在乎你，所以我愿意这么做。"), love=2)
    add_dialogue("free_play indifferent", ("stubborn", "yandere"), ("我会这样做，因为我爱你。"), love=3)
    add_dialogue("free_play a little interested", ("stubborn", "bimbo"), ("来这里，[MC.name]！我有好东西给你！"), love=4)
    add_dialogue("free_play interested", ("stubborn", "bimbo"), ("带我走，[MC.name]！我已经准备好迎接美好时光了！"), love=4)
    add_dialogue("free_play very interested", ("stubborn", "bimbo", "superficial"), ("现在就来找我吧，[MC.name]！我真的很需要它！"), love=5)
    add_dialogue("free_play fascinated", ("stubborn", "bimbo", "superficial"), ("现在就来干我吧，[MC.name]！一想到这件事我就浑身湿透了！ *点在她的两腿之间*"), love=5)
    add_dialogue("MC take virginity", ("stubborn"), ("你是我的第一个！我不会对任何人这样做，你知道吗？"), love=5)
    add_dialogue("free_play interested after", ("stubborn"), ("哦，那很好。我们必须再次这样做，[MC.name]！"))
    add_dialogue("free_play not interested after", ("stubborn"), ("我希望你满意，因为我绝对不满意！"))

    add_dialogue("free_flirt_beauty", ("stubborn", "pervert"), ("我不太喜欢甜言蜜语，不过谢谢。"), love=1, max_cap=75)
    add_dialogue("free_flirt_body", ("stubborn"), ("谢谢！当我照镜子时，我确实认为我的身体部位是成比例的。", "这只是另一具尸体，我认为还不错，但是谢谢！"), love=2, max_cap=75)
    add_dialogue("free_flirt_mind", ("stubborn"), ("谢谢！你很幸运能遇到一个像[girl.fullname]这样有骨气的女孩，你知道吗？"), love=3, max_cap=75)
    add_dialogue("free_flirt_spirit", ("stubborn", "schemer"), ["谢谢[MC.name]，但不要太过于胡说八道。", "哈哈，是的，我很有活力......这是一个很好的表达方式！不是所有男人都能对付我，但让我们来了解一下你。 *眨眼*"], love=2, max_cap=75)

    add_dialogue("free_flirt_sex_experience very experienced", ("stubborn"), ("哈哈，你们男人都一样。我{i}应该{/i}知道。我和你们很多人在一起过。 *眨眼*"), love=3)
    add_dialogue("free_flirt_sex_experience experienced", ("stubborn"), ("坦白说，亲爱的，我不是昨天才出生的。在你之前我已经有过男朋友了。事实上有不少。 *眨眼*"), love=2)
    add_dialogue("free_flirt_sex_experience average", ("stubborn"), ("我允许你问这么私人的事情了吗？但我一直在身边。我这辈子不只是在等待，你知道吗？"), love=1)
    add_dialogue("free_flirt_sex_experience inexperienced", ("stubborn"), ("*脸红*我试过了，但没什么严重的。我在等对的人当我找到他时，我会非常认真地对待这段关系。"))
    add_dialogue("free_flirt_sex_experience very inexperienced", ("stubborn"), ("你是什​​么意思？我不是荡妇，如果你是这个意思的话。"), love=-1)
    add_dialogue("free_flirt_sex_experience virgin", ("stubborn"), ("*脸红*不，我没有和任何人在一起。我正在等待一个合适的人，他会尊重我本来的样子。你是对的人吗？"), love=1)
    add_dialogue("free_flirt_sex_experience reply_waiting success", ("stubborn"), ("哇....你是处女吗？这太可爱了，而且即将改变。 *眨眼*"), love=6)
    add_dialogue("free_flirt_sex_experience reply_waiting failure", ("stubborn"), ("别再说谎了，先生。"))

    add_dialogue("free_flirt_sex_experience reply_not_many success", ("stubborn"), ("很高兴你没有去过太多地方。现在，你发现自己是一个意志坚强的女孩！我会让你快乐，让我们的关系继续下去。 *她微笑着握着你的手*"), love=4)
    add_dialogue("free_flirt_sex_experience reply_not_many failure", ("stubborn"), ("哈哈....你以为我是昨天出生的吗？我可以看出你拥有的女孩数量已经超出了你应得的数量。 *眨眼*"), love=1)
    add_dialogue("free_flirt_sex_experience reply_been_around", ("stubborn"), ("什么鬼啊混蛋？！你配不上像我这样有原则的女孩。 *生气和受伤*"), love=-1)
    add_dialogue("free_flirt_sex_experience reply_sex_god success", ("stubborn"), ("你是说你是城里最大的吹牛者？"))
    add_dialogue("free_flirt_sex_experience reply_sex_god failure", ("stubborn"), ("你知道你听起来有多自以为是吗？！"), love=-1)
    add_dialogue("free_flirt_sex_experience reply_brothel_owner", ("stubborn"), ("好吧，我不是你们的荡妇之一，所以最好努力满足我......"), love=1)

    add_dialogue("free_flirt_sex_act refuses", ("stubborn"), ("不，我不想。"))
    add_dialogue("free_flirt_sex_act very reluctant", ("stubborn", "prude", "rebel"), ["她皱眉.", "g: 你真的很以性为中心。给我一朵花并不意味着你可以问任何私人问题。我决定什么时候你可以问这样的问题。"], multiple=True)
    add_dialogue("free_flirt_sex_act reluctant", ("stubborn", "repressed"), ["她厌恶地看了你一眼.", "g: 我不是那种女孩，先生。我们来讨论别的事情吧。"], multiple=True)
    add_dialogue("free_flirt_sex_act a little reluctant", ("stubborn", "repressed", "rebel"), ["她皱眉.", "g: 不是我的事。我是否以某种方式让你觉得可以直接问这样的问题......？"], multiple=True)
    add_dialogue("free_flirt_sex_act indifferent", ("stubborn", "rebel"), ["她想了一会儿.", "g: 没关系....我没有什么反对的。"], multiple=True, love=1)
    add_dialogue("free_flirt_sex_act interested", ("stubborn", "loyal"), ["她想了一会儿.", "g: 没关系...如果我喜欢这个家伙，我不介意这样做。"], multiple=True, love=2)
    add_dialogue("free_flirt_sex_act a little interested", ("stubborn"), ["她越来越兴奋了。", "g: 我{i}确实{/i}喜欢这样！嗯...."], multiple=True, love=2)
    add_dialogue("free_flirt_sex_act very interested", ("stubborn"), ["她越来越兴奋了。", "g: 先生，你让我心情愉快。 *眨眼*。"], multiple=True, love=3)
    add_dialogue("free_flirt_sex_act fascinated", ("stubborn"), ["她舔了舔嘴唇.", "g: 天哪，我喜欢它....你现在让我感觉双腿之间湿润了！ *脸红*我希望你能解决这个问题。 *眨眼*"], multiple=True, love=3)

    add_dialogue("free_give_gold +++", ("stubborn", "loyal", "repressed"), ("天哪，[MC.name]！你真是太好了！ "), love=6, max_cap=75)
    add_dialogue("free_give_gold ++", ("stubborn", "nerd"), ("那是很多钱。你很善良！说实话，我有很多经济上的担忧，你知道的...."), love=4, max_cap=75)
    add_dialogue("free_give_gold +", ("stubborn", "generic", "loyal", "class president", "creep"), ("谢谢你，[MC.name]。"), love=2, max_cap=75)
    add_dialogue("free_give_gold -", ("stubborn", "nerd"), ("你为什么要给我钱？我正在寻找一个能够尊重我的人，而不是一个认为可以收买我的人。"), max_cap=75)
    add_dialogue("free_give_gold --", ("stubborn", "bimbo"), ("我不是什么廉价的妓女！滚出我的视线，你这个混蛋！！"), love=-1, max_cap=75)

    add_dialogue("free_offer_job no_lie", ("stubborn"), ["她带着认真考虑的表情看着你。", "g: 我？妓女？这似乎是一个奇怪的想法......我不是一个荡妇！", "g: 但我不想因为那个自以为是的出身高贵的贱人而进监狱。我很高兴你告诉了我有关你工作的真相。这给了我时间去思考。", "g: 也许我能做到。但你知道我的脾气，不是吗？我可能最终会让一些顾客眼花缭乱....", "g: 你{i}真的{/i}认为我能做到吗？"], multiple=True, love=1)
    add_dialogue("free_offer_job half_lie", ("stubborn"), ["g: 你个渣男。你从来没有告诉过我。我更喜欢诚实！", "mc: 我当时认为这并不重要...", "g: 那里的女孩...她们...只是和付钱的人睡觉，对吗？"], multiple=True, love=-1)
    add_dialogue("free_offer_job lie", ("stubborn"), ["g: Oh, so you lied...", "g: 我已经准备好为这段关系付出这么多了....这就是你眼中的我吗，一个妓女？", "mc: 有些女孩更喜欢“陪护”这个词...", "g: 护送？哦，拜托，别废话了。当我看到黑桃时，我称它为黑桃；当我看到妓女时，我称她为妓女。但我从没想过我最终会成为其中之一！我的 [girl.story_guardian] 会怎么想？", "g: 所以你毕竟不是[girl.MC_lied]。这是一个地狱般的选择：青楼还是监狱......"], multiple=True, love=-5)
    add_dialogue("free_offer_job success", ("stubborn"), ["g: 好的，我会做的。但请注意，像我这样脾气的女孩对被命令的反应不太好......", "g: 不过，我想他们只是男人。", "g: 我什么时候开始？"], multiple=True)
    add_dialogue("free_offer_job thinking", ("stubborn"), ["g: 那肯定能让我摆脱麻烦....但是....", "g: 当我说我宁愿在青楼工作时，我实际上并不是这个意思。一定还有其他选择...", "她离开了，看上去既愤怒又绝望。"], multiple=True)
    add_dialogue("free_offer_job failure lie", ("stubborn"), ["g: 去你妈的，你这个爱操纵别人的混蛋。那就是我所想的！你以为我是个什么样的廉价荡妇啊！？", "g: 你先骗我，然后又想让我去你那破烂的青楼干活！是什么让你的自以为是的头脑里产生了如此愚蠢的想法！", "g: 滚出我的视线，[MC.name]，否则我会踢你的屁股！", "她离开了，看起来真的很生气。", "mc: 进展顺利。等她冷静下来再说吧?"], multiple=True, love=-15)
    add_dialogue("free_offer_job failure no_lie", ("stubborn"), ["g: 操你妈的，混蛋，我就是这么想的！你以为我是谁啊！", "g: 你认为，因为我曾经说过，我宁愿在青楼工作，也不愿向那个出身名门的贱人低头，我就会成为一个听话的小妓女，乐意张开双腿，听从你的指挥？", "g: 滚蛋!", "她离开了，看起来很生气.", "mc: 进展顺利。等她冷静下来再说吧?"], multiple=True, love=-15)

    add_dialogue("free_friend no_lie", ("stubborn"), ["g: 青楼老板？这太恶心了....我不喜欢从事肉体贸易的人。我对你印象很好。也许我错了？ ....我已经习惯了自己是对的。", "mc: 你是做什么的?", "g: ..."], multiple=True, love=-2)
    add_dialogue("free_friend half_lie", ("stubborn"), ["g: 冒险家，太酷了！我是一个很脚踏实地的女孩，但我不介意一点兴奋。 *眨眼*", "mc: 你是做什么的?", "g: Me? Oh, ahem..."], multiple=True, love=1)
    add_dialogue("free_friend lie", ("stubborn"), ["g: A...[lie]？那太令人兴奋了！我只是一个普通的脚踏实地的女孩，尽我最大的努力在Zan取得成功。我从没想过我会遇到[lie]。哇！", "mc: 哈哈,肯定...你呢，你是做什么的?", "g: 哦，你知道的，这个那个..."], multiple=True, love=3)

    add_dialogue("free_love_interest", ("stubborn"), ["mc: Hi, [girl.name]. 出什么事了吗?", "g: 你知道吗...男孩给女孩送花是为了告诉她们喜欢她们。这是昙县的习俗。", "g: 我一直在想....是时候让我们的关系更上一层楼了。如果你能给我带来一朵花，我将非常感激，[MC.name]。", "g: 我通常不是一个愚蠢浪漫的女孩，但这是一个传统，我真的很喜欢！", "mc: Is that so?"], multiple=True)
    add_dialogue("free_girl get_flowers", ("stubborn"), ("哦，一朵花。正如我所要求的！现在，约我出去吧，[MC.name]！ *微笑*"))
    add_dialogue("free_ask_out", ("stubborn"), ["mc: 我喜欢你，[girl.name]。我们在一起吧。", "g: 你终于要我做你女朋友了吗？", "mc: 没错.", "g:  是的，当然！", "她扑进你的怀抱，给你一个又长又深的吻.", "g: 我认真对待人际关系！我希望你也这样做..."], multiple=True)

    add_dialogue("free_girlfriend intro", ("stubborn"), ["g: 哦，[MC.name]！来这里吧，亲爱的...", "mc: 嗨,我的爱人。你今天好吗??", "g: 我很好，亲爱的...跟我来，我想向你展示...我的全部。 *微笑*", "mc: 这么突然, 当然...", "g: 但首先，要知道你不仅仅是想利用像我这样天真的、有原则的女孩，我要问你一个问题。"], multiple=True)
    add_dialogue("free_girlfriend right", ("stubborn"), ("你已经注意了！也许你是男朋友的料....跟我来吧，亲爱的！ *眨眼*"), love=5)
    add_dialogue("free_girlfriend give_up", ("stubborn"), ("真的吗？我以为我们有什么东西，但我猜你害怕遇到一个女强人....走开，滚出我的视线，你这个胆小鬼！"), love=-5)
    add_dialogue("free_girlfriend wrong", ("stubborn"), ["g: 你太可怕了！！！当我告诉你我自己的时候，我以为你在听！我关心这些事情，它们对我来说非常重要。滚出我的视线！你是个糟糕的男朋友....这是行不通的。", "mc: I'm sorry..."], multiple=True, love=-10)
    add_dialogue("free_girlfriend success", ("stubborn"), ["她把衣服扔在地上，凝视着你的眼睛.", "g: 所以，这是我的身体。你喜欢你看到的吗？", "你可以感觉到你的鸡巴在第二秒变得更硬。她似乎注意到了，并对你报以微笑.", "g: 看来你那里有点问题.... "], multiple=True)
    add_dialogue("free_girlfriend success naked", ("stubborn"), ["当她脱下衣服时，你喘息着。", "g: 当我完全赤身裸体时，我总是感觉最舒服。", "g: 我更喜欢直接做我想做的事，无论是说出我的意思还是做我自己。我希望我能一直赤身裸体！", "g: 但是我当然不会光着身子在城里走来走去！", "g: 不过，我很高兴能向你展示真实的自己....你看起来也很开心! *咯咯笑*"], multiple=True)

    add_dialogue("free_job_request", ("stubborn"), ["g: 我必须和你谈谈，[MC.name]。早些时候我遇到了一些麻烦，当时我被错误地指控偷了这个出身高贵的母狗的....呃....女士的钱包。","g: 这一切都是误会....","g: 守卫抓住了真正的小偷，但我可能已经把那头高贵的母牛称为一些最好不说的事情，现在她要求道歉，否则他们会因为诽谤而把我关进监狱！","g: 我永远不会道歉。不是我的错！","g: 我不喜欢道歉，即使我做错了事......", "g: 这次我没有做错什么！","g: 我宁愿砍掉我的手臂，也不愿让那头蠢牛看到我卑躬屈膝的满足！ *冒烟*", "g: 天啊....我宁愿在阿里奥该死的青楼里工作！"], multiple=True)

    add_dialogue("accept farm", ("stubborn", "very dom"), ("哦，农场？我明白了...您想培训我，让我的工作做得更好。我会为你做这件事。", "....如果必须的话，我会去。", "我明白，主人."))
    add_dialogue("accept farm fear", ("stubborn", "very dom"), ["当吉泽尔向她走来时，她因恐惧和愤怒而浑身颤抖，她退缩了，但她不敢反抗。", "她看上去像是在忍气吞声，但却低着头，不敢违抗你的命令。"])
    add_dialogue("refuse farm", ("stubborn", "very dom"), ("不！不要农场！我清楚那里发生了什么事情....我拒绝去!", "我不想去农场！我也许愿意当妓女，但我有我的极限！", "不！不是农场！我不同意...", "我不能走，主人....我知道那里发生了什么....我不能....而且你不能逼迫我！ *尖叫声*"))
    add_dialogue("gizel take girl to farm", ("stubborn"), ("到吉泽尔妈妈那里来吧，你这个蠢女人。劈斩。", "到吉泽尔妈妈那里来吧，你这个蠢丫头！看来闯入这个会很有趣......") )

    add_dialogue("girl introduction", ("stubborn", "very dom"), ("我是[girl.fullname]。", "我是[girl.fullname]。我不是最顺从的人，但我们会看看事情会如何发展......"))
    add_dialogue("slave thanks", ("stubborn", "very dom"), ("谢谢。", "谢谢主人。", "谢谢你，[MC.name]。", "谢谢主人。我很感激！", "谢谢你，我很感激！"))
    add_dialogue("slave effusive thanks", ("stubborn", "very dom"), ("哦谢谢！太感谢了！", "哦，你真是太好了！谢谢你，[MC.name]！"))
    add_dialogue("slave positive reaction", ("stubborn", "very dom"), ("哇！你真是太好了！", " 主人，我很高兴您认可我的努力。", "噢，主人....这真是出乎意料。", "谢谢你，主人。这是一个很好的惊喜！"))
    add_dialogue("slave negative reaction", ("stubborn", "very dom"), ("嘿！我做了什么值得这样？这不公平！", "不，主人！我不想！", "等等，你为什么要这样做？我只想知道为什么？！？", "但是，[MC.name]主人...我很沮丧！我想知道你为什么不开心？为什么？！", "但是，主人，我以为事情进展顺利。为什么？！"))
    add_dialogue("slave whining", ("stubborn", "very dom"), ("不...", "决不...", "但、但是，到底是什么....", "呃？到底为什么...", "呃，不....", "呃...哦"))
    add_dialogue("slave strongly refuse", ("stubborn", "very dom"), ("不，主人，我不想这样做。 *她停下来尖叫*我是认真的！", "我不想！"), sound=s_screams)
    add_dialogue("slave bullied", ("stubborn", "very dom"), ("但、但是....什么？！", "什么...不！", "什么....你为什么这么卑鄙？"))
    add_dialogue("slave apology", ("stubborn"), ("我不常道歉，但对不起，主人....", "不，我或许愿意承认....或许我不应该....Master", "哦，我想...我...我...好吧，我会这么说...抱歉", "对不起，主人....我可能很固执，但我对发生的事情感到抱歉....", "我不是故意的....我不知道为什么会发生这种事....我....很抱歉....有点。", "对不起，主人，您无法对付我....", "对不起，主人，你不够男人，无法对付我这样一个活泼的女孩...."))
    add_dialogue("slave hit", ("stubborn", "very dom"), ("他妈的！那个痛...", "好痛....*她愤怒地瞪着你*"))
    add_dialogue("slave positive fixation accept", ("stubborn", "very dom"), ("*舔她的嘴唇*是的，对我这样做，主人！", "把它给我，[MC.name]。 *微笑*", "我需要它。请现在就做我吧，主人....", "这让我兴奋....请满足我的需求，[MC.name]。", "是的！现在就做我吧！现在;立刻;马上！"))
    add_dialogue("slave negative fixation accept", ("stubborn", "very dom"), ("这很恶心，但我会为你做的。", "我对此不太确定，但为了你我会这么做。", "我不喜欢这样，但是....温柔一点，[MC.name]。"))
    add_dialogue("slave negative fixation refuse", ("stubborn", "very dom"), ("太恶心了....我不想。我是认真的！", "我对此不确定....我对这一切都不确定。我们不要这样做。", "我们就不能做点别的吗？我已经准备好为你做很多事了，你知道吗？但不是这个....", "我不喜欢这样，所以...我们不要这样做，好吗？", "不，不是这个！我不喜欢它！", "地狱里没有机会！", "太恶心了，我真的不想！", "我拒绝！", "我不想，因为我不想。", "我可能是一个奴隶，但有些事情我不会做。"))

    add_dialogue("slave first visit", ("stubborn", "very dom"), ("我在这里。你的新财产....你将拥有我的身体。但我决定里面的东西会发生什么。"))
    add_dialogue("MC kind promise", ("stubborn", "very dom"), "我希望如此...我希望你能信守诺言。", love=4, fear=-3)
    add_dialogue("MC fair promise", ("stubborn", "very dom"), ("感谢你们承诺的公平待遇，但是什么是公平呢？你自由了。我是一个奴隶。你拥有一家青楼。而我是个妓女。"), fear=-1)
    add_dialogue("MC no promise", ("stubborn", "very dom"), ("我很高兴至少你对此是诚实的。您希望从新获得的财产中受益。但我想你会发现我并不轻易屈服...."), love=-1, fear=1)
    add_dialogue("MC harsh promise", ("stubborn", "very dom"), ("是的主人。这是可以理解的....*她自言自语*....去他妈的吧...."), love=-3, fear=2)
    add_dialogue("MC break promise", ("stubborn", "very dom"), ("嘿，这不公平！你可不是答应过要这样对待我的，你这个混蛋！"), love=-7, fear=1)
    add_dialogue("MC fight intro", ("very dom"), ["g: 不....不可能！！！请别打扰我！我不会让你的！", "你向她走近，但她试图击退你。"], multiple=True, sound=s_scream_loud)
    add_dialogue("slave fear intro", ("stubborn", "very dom"), ("当你走近时，她看起来很愤怒，也很受伤，避开了你的目光。她没有能力回答你的问题。", "她自言自语了些什么，并避开了你的目光，看起来深受创伤。她没有能力回答你的问题。", "当你走近时，她看起来很受伤。她没有能力回答您的问题，她宁愿一个人呆着。"))
    add_dialogue("slave fear reassure success", ("stubborn", "very dom"), ("她放松了一些，看起来没有那么受伤。她很怀疑，但愿意听你的。"), fear=-2)
    add_dialogue("slave fear reassure failure", ("stubborn", "very dom"), ("她看起来很受伤，静静地摇了摇头。她挑衅地拒绝与你的目光对视。最终，你放弃了。"), love=-1, fear=-1)
    add_dialogue("slave fear discipline", ("stubborn", "very dom"), ("你一巴掌打在她脸上。她咬着嘴唇。她现在因恐惧而颤抖，并压抑着愤怒。尝试与她交谈是没有用的。"), love=-2, fear=1)

    add_dialogue("slave naked request permanent", ("stubborn", "very dom"), ("我明白了....好吧，我会做的。裸体的感觉真好。我并不羞于分享我的观点，那么我为什么要羞于分享我的身体呢？", "好吧，我来做这个。我已经开始喜欢裸体了。让他们看看我的身体！", "好吧，为什么不呢？我享受我的身体。让昙的其他人也能享受到吧！"), fear=2, sound=s_sigh)
    add_dialogue("slave naked request accept", ("stubborn", "very dom"), ("好吧，我就让大家看看我的身体。", "如果这是你的命令，我就会这么做。 *她嘀咕* ... 这次。", "我会为你做这件事，[MC.name]。", "我并不羞于表达自己的观点。我为什么要对自己的身体感到害羞？", "好吧，主人，我会让那些顾客看到我的身体，但如果他们想碰，我就踢他们的屁股！", "我对此不太满意，但这到底是什么？当我照镜子时，我确实觉得我的身材很好。今天就让大家看看..."), sound=s_ahaa)
    add_dialogue("slave train beg", ("stubborn", "very dom"), ("没办法，简直没办法！", "没办法，他妈的没办法！", "我愿意为你做很多事，但不是这样！", "我是一个与自己的情感相协调的女人，我对此感到不舒服！", "我不会这么做。别试图强迫我。", "不。", "今天你想让大家看到我的身体吗？也许还可以触摸它？！不要吧？！！", "没办法，我不想让全世界都看到我的身体。", "我宁愿不这样做。"), love=-2, fear=-3)
    add_dialogue("slave toggle naked on", ("very modest"), ("是的主人。如果我必须...", "我会让泽恩所有的人看到我的身体。"), love=-1)
    add_dialogue("slave toggle naked off", ("very modest"), ("谢谢主人。这太可耻了，我能感觉到每个人都在看着我....我不喜欢这样。", "很高兴衣服拿回来了..."), love=1)
    add_dialogue("slave train beg", ("stubborn", "very dom"), ["[girl.name]跪下并开始乞求你。", "g: 主人，这不公平，我不想！！！不是那个....只是那个....我求你了....求求你了。"], multiple=True)
    add_dialogue("slave discipline beg", ("stubborn", "very dom"), ["[girl.name] 因恐惧而退缩，并开始双手合十乞求你的怜悯。", "g: 主人，求你了，不要！！！请不要让我这样做！"], multiple=True)
    add_dialogue("slave beg proceed", ("stubborn", "very dom"), ("我不想！你就这么无视我的意志吗！！不哦！！！"), love=-3, fear=2)
    add_dialogue("slave beg warning", ("stubborn", "very dom"), ("我明白。我不能那么固执，因为我是你的奴隶。", "我——我明白了。这对我来说并不自然......", "我——我明白了。只是....我有我的极限。" ), fear=-1, sound=s_sigh)
    add_dialogue("slave beg give up", ("stubborn", "very dom"), ["g: 对——真的吗？你不打算逼我吗？", "mc: 当然。你现在可以走了，不用担心。",  "g: 谢谢你让我得到我想要的。"], multiple=True, love=2, fear=-2, sound=s_surprise)
    add_dialogue("slave send to master bedroom love +", ("stubborn", "very dom"), ["当她听到你的话时，她高兴得浑身发抖。", "g: 哦，[MC.name]，有机会单独拥有你一段时间。 *微笑*"], multiple=True)
    add_dialogue("slave send to master bedroom love", ("stubborn", "very dom"), ["她看着你，眼里闪烁着光芒。", "g:  去你的私人卧室？这是不是意味着....你会让我度过一整夜的美好时光？嗯..."], multiple=True)
    add_dialogue("slave send to master bedroom love -", ("stubborn", "very dom"), ["她耸耸肩。", "g: 我不想这样做，但如果我必须这样做...."], multiple=True)
    add_dialogue("slave send to master bedroom fear +", ("stubborn", "very dom"), ["当她听到你的声音时，她会害怕得发抖。", "g: 我....我....我会服从....主人。请不要伤害我。"], multiple=True)
    add_dialogue("slave send to master bedroom fear", ("stubborn", "very dom"), ["她太害怕你而不敢不服从。", "g: 不，但是....我....我不想....我*她的声音破碎*....我会服从。"], multiple=True)
    add_dialogue("slave send to master bedroom fear -", ("stubborn", "very dom"), ["她耸耸肩。", "g: 你想让我在那里指挥我吗？我是你的奴隶，如果必须的话，我会这么做...."], multiple=True)
    add_dialogue("slave leave master bedroom love +", ("stubborn", "very dom"), ["她的眼睛里充满了泪水。", "g: 主人，您要我离开....但为什么呢？我爱你，想一直和你在一起！"], multiple=True)
    add_dialogue("slave leave master bedroom love", ("stubborn", "very dom"), ["她叹了口气。", "g: [MC.name]，你要解雇我吗？我真的不想。我非常喜欢这里..."], multiple=True)
    add_dialogue("slave leave master bedroom love -", ("stubborn", "very dom"), ["她耸耸肩。", "g: 见鬼，反正也没那么好...."], multiple=True)
    add_dialogue("slave leave master bedroom fear +", ("stubborn", "very dom"), ["她如释重负地浑身发抖。", "g: 是....你要让我走吗？谢谢您，先生....您真是太好了。"], multiple=True)
    add_dialogue("slave leave master bedroom fear", ("stubborn", "very dom"), ["她似乎松了口气。", "g: 哦，太好了，你别管我了。 "], multiple=True)
    add_dialogue("slave leave master bedroom fear -", ("stubborn", "very dom"), ["g: 哈哈...我看你要放我走了。让我屈服于你的意志并不那么容易。"], multiple=True)

    add_dialogue("slave chat slave_life -2", ("stubborn", "very dom"), ["她握紧拳头，一脸绝望。", "g: 我...我不知道我在这里做什么...这一定是一个可怕的错误...", "g: [girl.fullname]，被贴上奴隶的标签？谁认为这是个好主意？", "这就像某种恶心的笑话....*抽泣*"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life -1", ("stubborn", "very dom"), ["她看起来悲伤而失败。", "g: 我不想成为奴隶....我不想服从。我不喜欢被人指使！", "g: 我是说，到底是什么？！你是自由的，为什么我不自由？"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0", ("stubborn", "very dom"), ["她给你一个悲伤的表情。", "g: 我是你的奴隶。我是你的财产。不管我喜不喜欢，都没关系。", "g: 但你永远不会摧毁我的精神。", "g: 我不是一个可以被闯入的女孩。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 0.5", ("stubborn", "very dom"), ["她鞠躬。", "g: 我不喜欢接受订单，但也没有我想象的那么糟糕....", "g: 也许我可以学会忍受它，但我仍然更喜欢随心所欲。", "g: 我现在应该称呼你为主人了，对吗？"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 1", ("stubborn", "very dom"), ["她笑了。", "g: 我想我也许能明白做奴隶的意义了。不必自己做决定会有一种安全感。", "g: 我从来没想过我能变成这样", "g: 我以前总是那么任性。", "g: 谢谢你....向我展示了一种不同的方式。", "g: ....主人。"], multiple=True, unlock="DS")
    add_dialogue("slave chat slave_life 2", ("stubborn"), ["她跪下并深深鞠了一躬。", "g: 主人，我喜欢做你的奴隶！", "g: 我以前很固执，但女孩子就不行啊！"], multiple=True, unlock="DS")
    add_dialogue("slave chat brothel -2", ("stubborn"), ["她看起来很沮丧。", "g: 我不喜欢青楼。", "g: 我不喜欢接受命令。", "g: 我鄙视那些把辛苦赚来的第纳尔花在妓女身上的男人。", "g: 你希望我回答什么？", "g: 我他妈的讨厌这里！这就是我喜欢你青楼的生活！"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel -1", ("stubborn"), ["她看上去又生气又心烦意乱。", "g: 这个地方太恶心了！我不赞成青楼和女人为了几第纳尔出卖自己！", "g: 我怎么会到这里来？为什么我必须在这里？"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0", ("stubborn"), ["她沉默了一会儿。", "g: 这不是我想象中的青楼，但说实话我并没有抱太大的期望....", "g: 我已经学会了接受这里的现实，但我不是那种喜欢嫖娼的女人。这是答错了。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 0.5", ("stubborn", "repressed", "very dom"), ["她给你一个虚弱的微笑。", "g: 这很难，也不适合我，但我并不特别讨厌你们的机构。就青楼而言，我想情况可能会更糟。"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel virgin", ("stubborn"), ["她脸通红.", "g: 这里太疯狂了....到处都是性爱！", "g: 我一直以为我会把我的童贞给合适的男人，他会听我的并且尊重我的真实身份......", "g: 但是这里的女孩总是和任何人做这种事！我不得不承认，这让我有点好奇...."], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 1", ("stubborn"), ["她微笑着，用舌尖触碰上唇。", "g: 我没想到我会成为那种为了钱出卖自己还以此为乐的放荡女人....", "g: 但是这里确实非常令人兴奋！这是绝对不会无聊的！"], multiple=True, unlock="LM")
    add_dialogue("slave chat brothel 2", ("stubborn", "repressed"), ["她给你一个狂热的表情，并舔着嘴唇。你可以看到她的乳头很硬。", "g: 我不认为我是那种放荡的女人，但我大错特错了！", "g: 这个地方令人难以置信......我喜欢和所有这些顾客一起玩得开心！", "g: 我现在的看法是：我有一个坚实的年轻身体，所以为什么不将它用于它的用途......"], multiple=True, unlock="LM")
    add_dialogue("slave chat customers -2", ("stubborn", "very dom"), ["她看起来很生气。", "g: 我讨厌那些混蛋！我尽我最大的努力来发球等等，但他们一直让我心烦意乱....我发誓有一天我会踢掉某人的牙齿......"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers -1", ("stubborn", "very dom"), ["她看起来很沮丧。", "g: 他们对我来说就像牛一样。这就像一个又一个地挤奶，我应该表现得像一个好侍女什么的。", "g: 我知道每个人都有自己的问题，但为什么他们的问题就是我的问题呢？"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 0", ("stubborn", "very dom"), ["她叹了口气。", "g: 我想有些还不错....", "g: 我不赞成任何人来到这样的场所......", "g: 但我只想勒死他们中的{i}一些{/i}！"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 0.5", ("stubborn", "very dom"), ["她微微一笑。", "g: 他们总是向我吐露心声，谈论他们的家庭、他们的艰辛、他们破碎的心....没关系。", "g: 这是一种真正的联系，而且是有益的！"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 1", ("stubborn", "very dom"), ["她心情轻松起来。", "g: 哦，顾客很有趣！我们越亲密，我就越了解他们，也越了解我自己。即使没有性，这也令人惊讶地有趣！"], multiple=True, unlock="MI")
    add_dialogue("slave chat customers 2", ("stubborn", "very dom"), ["她脸上洋溢着自豪的笑容。", "g: 我很高兴能够帮助顾客忘记他们的痛苦和烦恼！我真的很喜欢为他们服务....我会尽一切努力让他们开心。", "g: ...我所说的任何事情都是我来这里之前无法想象的。 *眨眼*。"], multiple=True, unlock="MI")
    add_dialogue("slave chat other_girls -2", ("stubborn", "very dom"), ["她看上去既生气又不高兴。", "g: 和他们相处得怎么样？我不想做出评判，但我认为他们是愚蠢的牛。", "g: ....还有愚蠢的荡妇。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls -1", ("stubborn", "very dom"), ["她看起来脾气暴躁。", "g: 说实话，我和他们交往不多。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 0", ("stubborn", "very dom"), ["她皱眉.", "g: 有些还不错。其他人可能会抱怨我的对抗态度或同样荒谬的事情......", "g: ....但我会把它们放在原来的位置！"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 0.5", ("stubborn", "very dom"), ["她笑了。", "g: 很高兴有人陪伴。其他大多数女孩都还好，真的。只要他们不以不好的方式惹恼我。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 1", ("stubborn", "very dom"), ["她想了一会儿.", "g: 我有时间去见其他女孩并和她们聊天。我已经告诉他们我对泽恩和这个地方以及作为一个妓女的看法。", "g: 他们似乎对我的观点很满意。我觉得他们其实还好。"], multiple=True, unlock="EI")
    add_dialogue("slave chat other_girls 2", ("stubborn", "very dom"), ["她给你一个温暖而幸福的微笑。", "g: 和其他女孩在一起真是太好了！他们总是让人开怀大笑。", "g: 如果有人在城里对他们说脏话，我会为他们挺身而出！"], multiple=True, unlock="EI")
    add_dialogue("MC praise friend", ("stubborn"), ("哦，谢谢你，[MC.name]！她是一个好朋友，她听我的话并且完全按照我说的去做。 *微笑*"), sound=s_laugh)
    add_dialogue("MC demean rival", ("stubborn", "very dom"), ("哈哈，是啊，真是牛啊！我经常这样告诉她。 *笑*"), sound=s_evil_laugh)
    add_dialogue("slave chat well_being -3", ("stubborn", "very dom"), ("我他妈的讨厌这里！没有什么是好的。"), unlock="MI")
    add_dialogue("slave chat well_being -2", ("stubborn", "very dom"), ("我感觉不太舒服。我不喜欢接受命令。你为什么不让我走？"), unlock="MI")
    add_dialogue("slave chat well_being -1", ("stubborn"), ("我不能说我在这里感觉很好。我不喜欢接受命令。我不喜欢把第纳尔花在妓女身上的男人。"), unlock="MI")
    add_dialogue("slave chat well_being 0", ("stubborn", "very dom"), ("可能更糟。这样的生活并不舒服，但我已经习惯了。我只是偶尔想狠狠地打击一些顾客...."), unlock="MI")
    add_dialogue("slave chat well_being 1", ("stubborn", "very dom"), ("我可以。不高兴，但也没有拆墙。"), unlock="MI")
    add_dialogue("slave chat well_being 2", ("stubborn", "very dom"), ("我在这里很开心，主人。我已经习惯了这个地方并享受我的生活。"), unlock="MI")
    add_dialogue("slave chat well_being 3", ("stubborn", "very dom"), ("我喜欢在这里工作，主人！这很令人惊讶，但我一生中从未感到如此快乐和安全。"), unlock="MI")
    add_dialogue("slave chat well_being attacked", ("stubborn", "very dom"), ("在过去的一个月里，我遭到攻击和伤害 [nb_times] 次。那太他妈可怕了。为什么不加强安全措施？！"))
    add_dialogue("slave chat well_being sick", ("stubborn", "very dom"), ("过去一个月我生病了 [nb_times] 次。那是非常不愉快的。这肮脏的青楼让我感到恶心！"))
    add_dialogue("slave chat well_being exhausted", ("stubborn", "very dom"), ("过去一个月，我因过度劳累而感到疲惫不堪[nb_times]。我太累了...我愿意投入工作，[MC.name]，但我有我的极限..."))
    add_dialogue("slave chat well_being MC apology", ("stubborn", "very dom"), ["g: 我明白。就是这样。", "g: 我只是不喜欢它。"], multiple=True)
    add_dialogue("slave chat feelings love -1", ("stubborn", "very dom"), ("我们并不是很亲近。你期待听到什么？你以为我会亲吻你的脚并歌颂你吗？"), unlock="DS")
    add_dialogue("slave chat feelings love 0", ("stubborn", "very dom"), ("你没事吧。不要让这个占据你的头脑。"), unlock="DS")
    add_dialogue("slave chat feelings love 1", ("stubborn", "very dom"), ("我喜欢你。我确信外面还有更糟糕的妓女主。"), unlock="DS")
    add_dialogue("slave chat feelings love 2", ("stubborn"), ["我爱你，主人。我想一直靠近你。", "我知道我对自己关心的事情可能非常固执，我决心帮助您使这家酒店成为泽恩最好的酒店！"], multiple=True, unlock="DS")
    add_dialogue("slave chat feelings fear -1", ("stubborn", "very dom"), ("你可以对我们女孩有点严厉。这对我不起作用。"), unlock="DS")
    add_dialogue("slave chat feelings fear 0", ("stubborn", "very dom"), ("你....你有时让我担心。我知道我很直言不讳，意志坚强，但现在我其实很害怕让你不高兴....这并不容易发生...."), unlock="DS")
    add_dialogue("slave chat feelings fear 1", ("stubborn"), ("我知道我可能很难相处，但我会尽力把对你的影响降到最低，主人。你生气的时候真可怕！"), unlock="DS")
    add_dialogue("slave chat feelings fear 2", ("stubborn", "very dom"), ("别、别....别伤害我....主人。我会成为一个好奴隶。我保证。"), unlock="DS")
    add_dialogue("slave chat feelings very disobedient", ("stubborn", "very dom"), ("你他妈的不是我的主人！我不是任何人的财产！"), unlock="DS")
    add_dialogue("slave chat feelings disobedient", ("stubborn", "very dom"), ("如果你以为我会向你鞠躬，那你就太高调了！"), unlock="DS")
    add_dialogue("slave chat feelings a little obedient", ("stubborn", "very dom"), ("我是你的奴隶。我按照别人告诉我的去做。我就明白这么多了。这并不意味着我必须喜欢它。"), unlock="DS")
    add_dialogue("slave chat feelings obedient", ("stubborn", "very dom"), ["g: 你没事吧。我是来尊重你的。你可能希望我现在使用一个 m 词......", "g: 也许，我会....", "g: ....主人。"], multiple=True, unlock="DS")
    add_dialogue("slave chat feelings very obedient", ("stubborn", "very dom"), ("你是我的主人。我尊敬你，我已经学会按照你说的去做。", "我是你的奴隶。我已经平静下来并找到了其中的意义。您是我唯一愿意臣服的人，主人。"), unlock="DS")
    add_dialogue("slave chat tastes likes", ("stubborn"), ("我们通常会与我的感受保持一致。我真正喜欢的事情之一就是[best]！", "我知道我喜欢什么并且我最喜欢[best]！"), unlock="LM")
    add_dialogue("slave chat tastes dislikes", ("stubborn"), ("虽然我是奴隶，但我很了解自己。这也意味着我知道自己不喜欢什么。其中一件事情就是[worst]。", "有些东西我真的不喜欢，比如[worst]。", "我无意评判，但我很难理解那些喜欢[worst]的人。"), unlock="LM")
    add_dialogue("slave chat tastes loves +", ("stubborn"), ("你还记得我说过，我很了解自己喜欢什么和不喜欢什么吗？你知道什么会让我如此高兴吗？是[thing_cn]！"), unlock="LM")
    add_dialogue("slave chat tastes loves -", ("stubborn"), ("我怀疑你是否很关心对我来说重要的事情，但我喜欢[thing_cn]。"), unlock="LM")
    add_dialogue("slave chat tastes no loves", ("stubborn"), ("不，我真的不需要任何东西......我是一个非常脚踏实地的女孩。"), unlock="LM")
    add_dialogue("slave chat tastes hates", ("stubborn"), ("我是一个很了解她的情绪和厌恶的人。我真正不喜欢的是[thing_cn]。"), unlock="LM")
    add_dialogue("slave chat tastes no hates", ("stubborn"), ("当然，我会很喜欢一份礼物。没有什么花哨。我是一个很脚踏实地的女孩。"), unlock="LM")
    add_dialogue("slave chat tastes positive act", ("stubborn"), ("我曾经非常谦虚，对所有这些性实验不感兴趣，但我发现我真的很喜欢[act_desc]。不知何故感觉如此正确和良好！"), unlock="LM")
    add_dialogue("slave chat tastes negative act", ("stubborn"), ["g: 我知道我现在在青楼工作，但我根本不明白[act_desc]的吸引力......", "g:  感觉非常糟糕且错误！我不想做出评判，但为什么会有女孩这么做呢？！"], multiple=True, unlock="LM")
    add_dialogue("slave chat tastes no negative act", ("stubborn", "very dom"), ("有各种各样的乐趣....而我对其中的大多数都感到满意！ *微笑一点*"), unlock="LM")

    add_dialogue("slave chat origins 1", ("stubborn", "very extravert", "prude", "sweet"), ("我来自[girl.origin]。没有一个地方像家一样，不是吗？那里有我太多的回忆..."), unlock="EI")
    add_dialogue("slave chat origins 2", ("stubborn", "very extravert"), ("我曾经和我的 [girl.story_guardian] 一起住在 [girl.origin] 附近的 [a_home]。那些日子..."), unlock="EI")
    add_dialogue("slave chat origins 3", ("generic"), ("我记得我和我的[girl.story_guardian]住的[girl.story_home]..."), unlock="EI")
    add_dialogue("origin Zan", ("stubborn", "very dom", "rebel"), ("我很喜欢这个地方，尽管它道德败坏....我的[girl.story_guardian]教会我要坚强和独立，才能在泽恩的街道上生存。我学会了在这里取得成功的技巧，最重要的是，我学会了为自己挺身而出。"))
    add_dialogue("origin the border with the Holy Lands", ("stubborn", "very dom"), ["g: 圣地是一个充满战争和苦难的地方，对于一个小女孩来说也是一个可怕的成长之地。 ", "g: 以太阳神的名义发动战争的有权势的人不会想到这一点 - 但我们是生活在其中的真实人民，希望过上正常的生活。我在泽恩这里更安全，这说明了很多！", "g: 尽管如此，那是我的家，我想念它！我和我的 [girl.story_guardian] 一起长大，他教会我要坚强，在这样的世界里为自己挺身而出。"], multiple=True)
    add_dialogue("origin the Blood Islands", ("stubborn", "very dom"), ["g: 对于一个小女孩来说，血色群岛是一个残酷的成长之地....我记得我坐在码头上看着奴隶船来来往往，和我的[girl.story_guardian]一起....", "g: 看着所有这些奴隶，我知道我必须坚强并为自己挺身而出，才能在这样的世界中取得成功", "g: 哦，讽刺的是，最终成为了那些奴隶中的一员。尽管如此，当我需要的时候，我不会停止为自己挺身而出！"], multiple=True)
    add_dialogue("origin Karkyr", ("stubborn", "very dom"), ["g: 卡克尔对于小孩子来说是一个很棒的成长之地。我和我的[girl.story_guardian]住在一起，她经常带我去看法师。当他们施展咒语并梦见遥远的地方时，我常常目瞪口呆。", "g: 如果我早知道它们不那么神奇就好了....哦，好吧，在这样的世界里，女孩需要为自己挺身而出！"], multiple=True)
    add_dialogue("origin Westmarch", ("stubborn", "very dom"), ["g: 威斯特玛公国很美丽，我的家也很珍贵。这是一个非常难以预测的地方，我们这些小人物往往会陷入城堡里王子们的一时兴起而互相发动战争的困境。", "g: 我的[girl.story_guardian]试图保护我，但生活很艰难。我知道我必须坚强并为自己挺身而出才能在这样的世界中生存。"], multiple=True)
    add_dialogue("origin the desert of Hokoma", ("stubborn", "very dom", "rebel"), ["g: 沙漠人更喜欢独来独往。我们有我们自己的方式。我的[girl.story_guardian]知道很多秘密，并把其中一些传给了我。", "g: 也许是因为我是在泽恩这样的地方长大的，所以我不喜欢那些自以为是的贵族和他们虚伪的等级制度。", "g: 我想念沙漠。没有一个地方像家一样，不是吗？"], multiple=True)
    add_dialogue("origin Borgo, the port city", ("stubborn", "very dom"), ["g: 博尔戈比泽恩活泼得多，这说明了很多问题。这个地方有傲慢的贵族和不成文的社会规则，对我来说从来没有感觉到真实。", "g: 我受到我的[girl.story_guardian]的照顾。我长大了，变得坚强、独立。我学会了为自己挺身而出。"], multiple=True)
    add_dialogue("origin the Goliath desolations", ("stubborn", "very dom"), ["g: 我的家乡很艰苦。对于小女孩来说，歌利亚荒原是一个无情的成长环境。因为荒原很艰苦，我的[girl.story_guardian]教会我要坚强。", "g: 不过我确实很怀念荒凉之地。它们是我的家，可以如此美丽，当夕阳将贫瘠的荒地染成紫色和金色时。"], multiple=True)
    add_dialogue("origin the Arik mountains", ("stubborn", "very dom"), ["g: 我是山里的姑娘。阿里克山脉高于这片大陆上的一切，而我们登山者则与其他人不同。这是一种艰苦的生活，但比在泽恩的腐败之中要简单。", "g: 我的[girl.story_guardian]教会我如何像山一样坚强和独立。"], multiple=True)

    add_dialogue("slave train accepted", ("stubborn", "very dom"), ("如果这就是你想要的，那么我们就这么做吧....", "正如你的命令。", "哦，[MC.name]...让我们现在就开始吧！", "我会做到的，主人。"))
    add_dialogue("slave train resisted", ("stubborn", "very dom"), ("不，我不想！别....让我这么做....", "不，等等...我对此不满意！", "嘿....我不喜欢这样！", "我宁愿不这样做。"))
    add_dialogue("slave train refused", ("stubborn", "very dom"), ("决不！！！想都别想！", "我不会这么做的！我不会。真他妈没有办法啊！", "把你的脏爪子从我身上拿开！！！", "什么？不！！！为了他妈的缘故！", "滚蛋！", "我不想！"))
    add_dialogue("slave lecture love", ("stubborn", "very dom"), ("很高兴见到你，[MC.name]！今天的主题是什么？..."))
    add_dialogue("slave lecture neutral", ("stubborn", "very dom"), ("又来给我讲一堂课吗？是的，我知道这是青楼。性是我们所有人的食物....我应该更加开放....废话连篇中.....。"))
    add_dialogue("slave lecture fear", ("stubborn", "very dom"), ("她非常警惕，把目光移开。她看上去不太适合听你讲话。"))
    add_dialogue("slave lecture refuses", ("stubborn", "very dom"), ("啊!我不想做出评判，但这听起来太可怕了。", "拜托，不要再提这件事了！"))
    add_dialogue("slave lecture very reluctant", ("stubborn"), ("啊，不是这个！ [act_desc] 是糟糕且答错了。我不是那种女孩！"))
    add_dialogue("slave lecture reluctant", ("stubborn", "very dom"), ("我有我的极限，你知道......这绝对是太过分了......"))
    add_dialogue("slave lecture a little reluctant", ("stubborn", "very dom"), ("这不是我最喜欢的......但我并不完全反对尝试......也许吧。"), sound=s_sigh)
    add_dialogue("slave lecture indifferent", ("stubborn", "very dom"), ("嗯....这只是青楼里发生的事情之一。这只是许多其他行为中的一种性行为......"))
    add_dialogue("slave lecture a little interested", ("stubborn", "very dom"), ("哦[MC.name]，关于那个...我想知道..."), sound=s_surprise)
    add_dialogue("slave lecture interested", ("stubborn", "very dom"), ("听起来很过瘾！ *眨眼*我想了解更多..."), sound=s_mmh)
    add_dialogue("slave lecture very interested", ("stubborn"), ("我总体上与自己相处得很好。令我惊讶的是，我发现我是一个热爱 [act_desc] 的女人...这让我感觉很好...嗯。"), sound=s_mmh)
    add_dialogue("slave lecture fascinated", ("stubborn", "very dom"), ("太棒了，因为，[act_desc] 简直是最好的！！！我可以整晚和每天都做！我们还在等什么？！ *眨眼*"), sound=s_aah)
    add_dialogue("slave train obedience", ("stubborn", "very dom"), ("所以，你只是想让我在这里对我发号施令并处理类似的家务？... *她嘟囔*...看在他妈的份上..."))
    add_dialogue("slave train constitution", ("stubborn", "very dom"), ("好吧，我想稍微运动一下会更好。"))
    add_dialogue("slave train refuses", ("stubborn", "very dom"), ["她非常强烈地反对 [act_desc] 的想法，以至于她只是盯着你，眼睛瞪着，脸红了。", "g: 不可能，[MC.name]，不可能......"], multiple=True, sound=s_screams)
    add_dialogue("slave train very reluctant", ("stubborn", "very dom"), ("我不喜欢这个....天啊！为什么我必须继续这样做？啊！！！", "呃，[act_desc]？你为什么要让我这么做，变态...."), sound=s_scream)
    add_dialogue("slave train reluctant", ("stubborn", "very dom"), ("你知道我不喜欢这个....事实上，我他妈的讨厌它！嘎啊！"), sound=s_scream)
    add_dialogue("slave train a little reluctant", ("stubborn", "very dom"), ["g: 你又对我做变态的事了....这让我感觉很奇怪....", "g: ....但还不错...."], multiple=True, sound=s_surprise)
    add_dialogue("slave train indifferent", ("stubborn", "very dom"), ("啊啊.... "), sound=s_ahaa)
    add_dialogue("slave train a little interested", ("stubborn", "very dom"), ("哦，所以这就是我们要做的？听起来不错！"), sound=s_ahaa)
    add_dialogue("slave train interested", ("stubborn", "very dom"), ("噢....我的腿间变得湿润了...."), sound=s_mmh)
    add_dialogue("slave train very interested", ("stubborn", "very dom"), ("哦天哪...我都湿透了...现在就带我吧，[MC.name]！"), sound=s_aah)
    add_dialogue("slave train fascinated", ("stubborn", "very dom"), ("我真是个荡妇....整天都在想着[act_desc]。现在就做我吧！"), sound=s_orgasm_fast)
    add_dialogue("slave train naked failure", ("stubborn", "very dom"), ("没门....只是....没门！", "我宁愿不这样做。"), sound=s_surprise)
    add_dialogue("slave train naked success", ("stubborn", "very dom"), ("我的身体？....就在这里。 *眨眼* "), sound=s_aah)
    add_dialogue("slave train service failure", ("stubborn", "very dom"), ("她沮丧又羞愧地瞪着你：这他妈的毫无意义！"))
    add_dialogue("slave train service success", ("stubborn", "very dom"), ("我想要你的精液，[MC.name]！现在就来找我吧！"))
    add_dialogue("slave train sex failure", ("stubborn", "very dom"), ("这....感觉不太对劲....你说完了吗？！"))
    add_dialogue("slave train sex success", ("stubborn", "very dom"), ("哦...感觉就像魔法在我的血管里流淌。啊啊啊....我高潮了！！！"))
    add_dialogue("slave train anal failure", ("stubborn", "very dom"), ("不....不可能....不会走后门的...."))
    add_dialogue("slave train anal success", ("stubborn", "very dom"), ("啊啊...这太棒了，[MC.name]...我的屁股需要更多！"))
    add_dialogue("slave train fetish failure", ("stubborn", "very dom"), ("哇啊....不，这真是病态啊，你这个变态！"))
    add_dialogue("slave train fetish success", ("stubborn", "very dom"), ("请主人带上吧！ [girl.fullname] 是你的了！ *眨眼*"))
    add_dialogue("slave train bisexual failure", ("stubborn", "very dom"), ("不....不和另一个女人在一起。只是感觉不太对劲！"))
    add_dialogue("slave train bisexual success", ("stubborn", "very dom"), ("我喜欢和另一个女人在一起。那太好了！ *眨眼*"), sound=s_mmh)
    add_dialogue("slave train group failure", ("stubborn", "very dom"), ("我勒个去？！决不！！ ....一次一个，不是他妈的泽恩的全部！"))
    add_dialogue("slave train group success", ("stubborn", "very dom"), ("哦....那太好了！我还可以做更多，想看看吗？ （她看上去很疲惫，但意志坚定。）"))
    add_dialogue("slave magic obedience success", ("stubborn", "very dom"), ("你是我的主人。我灵魂的钥匙就是你的....我必须服从。"), sound=s_ahaa)
    add_dialogue("slave magic libido success", ("stubborn", "very dom"), ("哦...啊啊...罪恶和放荡。"), sound=s_mmh)
    add_dialogue("slave magic sensitivity success", ("stubborn", "very dom"), ("嗯....上帝的命令。我的身体是取悦男人的器皿...."), sound=s_mmh)
    add_dialogue("slave magic naked success", ("stubborn", "very dom"), ("我的身体是一件艺术品....我会把它展示出来...."), sound=s_ahaa)
    add_dialogue("slave magic service success", ("stubborn", "very dom"), ("我的身体....旨在给您带来快乐...."), sound=s_mmh)
    add_dialogue("slave magic sex success", ("stubborn", "very dom"), ("我的身体是一座神殿....它的内部圣所....已经准备好接受礼物了...."), sound=s_aah)
    add_dialogue("slave magic anal success", ("stubborn", "very dom"), ("我的身体是一座寺庙....它的后门....将会收到一份礼物...."), sound=s_ahaa)
    add_dialogue("slave magic fetish success", ("stubborn", "very dom"), ("啊啊！你正在咬我的两个苹果....你觉得它们好吃吗？ ...捏我的苹果..."), sound=s_aah)
    add_dialogue("slave magic bisexual success", ("stubborn", "very dom"), ("恶魔在召唤....女神在召唤....我必须侍奉。"), sound=s_mmh)
    add_dialogue("slave magic group success", ("stubborn", "very dom"), ("我活着就是为了服务....带着我所有的漏洞...."), sound=s_ahaa)
    add_dialogue("slave magic failure", ("stubborn", "very dom"), ["g: 什...你他妈到底在做什么？嘿，你在对我尝试一些肮脏的魔法！离开！！！", "她开始尖叫并对你辱骂。当你离开时，她关上了你身后的门。"], multiple=True, sound=s_scream, unlock="DS")

    add_dialogue("slave reward sex accepted", ("stubborn", "very dom"), ("好吧，那我们就开始吧....不过我现在没心情。"), love=-2, sound=s_ahaa, unlock="LM")
    add_dialogue("slave reward sex resisted", ("stubborn", "very dom"), ("这应该算是奖励吧？"), love=-3, sound=s_surprise, unlock="LM")
    add_dialogue("slave reward sex refused", ("stubborn", "very dom"), ("不....他妈的没办法。离我远点，混蛋！"), sound=s_scream)
    add_dialogue("slave reward praise", ("stubborn", "very dom"), ("谢谢你...我很高兴你欣赏我！"), love=1, unlock="MI")
    add_dialogue("slave reward gold", ("stubborn", "very dom"), ("谢谢。 "), love=1, unlock="MI")
    add_dialogue("slave reward pet", ("very dom"), ["你试图拥抱她，但她很紧张并且回避。", "g: 拥抱，认真的吗？快点..."], multiple=True, love=-1, unlock="DS")
    add_dialogue("slave reward day off", ("stubborn", "very dom"), ("嘿，这是一个惊喜，谢谢！"), love=1, unlock="DS")
    add_dialogue("slave reward day off KO", ("stubborn", "very dom"), ["g: 嘿，今天已经是我休息日了！", "mc: 啊，对了。我已经忘记了。"], multiple=True)
    add_dialogue("slave punish scold deserved", ("stubborn", "very dom"), ("公平地说，我想这是我应得的。我最近本可以表现得更好..."), fear=1, unlock="MI")
    add_dialogue("slave punish scold undeserved", ("stubborn", "very dom"), ("嘿，到底是什么？我不值得这样的虐待！"), love=-2, unlock="MI")
    add_dialogue("slave punish upkeep", ("stubborn", "very dom"), ("... 不好了..."), fear=1, unlock="MI")
    add_dialogue("slave punish upkeep KO", ("stubborn", "very dom"), ["g: 到底是什么？！你已经剥夺了我的津贴...你不能剥夺第二次", "mc: 哦，对了，哈哈....我只是在测试你。"], multiple=True)
    add_dialogue("slave punish beat", ("very dom"), ["当你恶毒地打她时，她会大喊大叫，无休止地辱骂她。", "g: 这是你能做的最好的事情了吗？啊啊！！！你这个混蛋....啊啊！"], multiple=True, fear=-1, sound=s_screams, unlock="DS")
    add_dialogue("slave punish farm", ("very dom"), ("你不能这样对我！不！！！ *害怕的*"), fear=1, unlock="DS")
    add_dialogue("slave punish naked", ("stubborn", "very dom"), ("你又要脱我衣服？！我早该知道..."), fear=2, unlock="LM")
    add_dialogue("slave punish naked KO", ("stubborn", "very dom"), ["g: 呃？当我已经赤身裸体的时候，我很难赤身裸体......", "mc: 呃....当然。我知道。那是个笑话。啊哈哈哈..."], multiple=True)
    add_dialogue("slave punish rape", ("stubborn", "very dom"), ("啊啊啊....不....不是那样的，你这个变态混蛋！！！ *哭泣*"), fear=3, unlock="LM")
    add_dialogue("slave raped", ("stubborn", "very dom"), ("不....我同意了吗？！啊啊！"), sound=s_screams)
    add_dialogue("slave rape positive fixation", ("stubborn", "very dom"), ("如此肮脏和错误，但又如此美好和正确！啊啊啊！"), love=1, sound=s_aah)
    add_dialogue("slave rape negative fixation", ("stubborn", "very dom"), ("不，不是这个....除了这个什么都不是。不哦！"), love=-4, fear=5, sound=s_scream_loud)

    add_dialogue("rest", ("stubborn", "very dom"), ("我需要休息一下。{w=1.0}{nw}"))
    add_dialogue("accept job", ("stubborn", "very dom"), ("我现在将担任{b}[girl.job_cn]{/b}，以满足客户的需求。{w=1.0}{nw}"))
    add_dialogue("work_whore", ("stubborn", "very dom"), ("我现在将担任一名{b}[girl.job_cn]{/b}，并卖掉自己半天的时间，以满足客户的需求。{w=1.0}{nw}"))
    add_dialogue("exhausted", ("stubborn", "very dom"), ("没办法....我还是很累，需要多休息。  我会以{b}[girl.job_cn]{/b}的身份回去工作，但之前必须先躺下。"))
    add_dialogue("rank up", ("stubborn", "very dom"), ("我现在是一名[newrank]奴隶。"))
    add_dialogue("refuse whoring", ("stubborn", "very dom"), ("哈哈....没办法！ [girl.fullname]有原则，不会嫖娼！", "什么？！不要吧！其他的工作我可以做，但我不会像个肮脏的荡妇一样出卖自己！", "没有。我有原则。我不是妓女！"))
    add_dialogue("refuse sex act", ("stubborn", "very dom"), ("决不！！！想都别想！", "我不会这么做的！我不会。真他妈没有办法啊！", "把你的脏爪子从我身上拿开！！！", "什么？不！！！为了他妈的缘故！", "滚蛋！", "我不想！"))

    add_dialogue("bought", ("stubborn", "very dom"), ("我想你会发现我不是奴隶！我不会让人对我发号施令！"))
    add_dialogue("freed", ("stubborn", "very dom"), ("这么久以来，[MC.name]...[girl.fullname] 从来就不是奴隶..."))
    add_dialogue("sold", ("stubborn", "very dom"), ("...", "这次就再见了，那么....", "我要去..."))
    add_dialogue("sold love", ("stubborn"), ["但、但是，为什么？！我...我爱你...*抽泣*", "我可能很难相处，但我相信你和你的青楼！ *哭泣*"], multiple=True, sound=s_surprise)
    add_dialogue("leave for quest", ("stubborn", "very dom"), ("我要去执行任务。很快再见。"))
    add_dialogue("leave for class", ("stubborn", "very dom"), ("我要去参加那堂课了。很快再见。"))
    add_dialogue("advertise", ("stubborn", "very dom"), ["先生！您愿意来看看我们的商品吗？ *眨眼*", "我很孤独，先生....你能进来陪我吗？", "我好饥渴....我爱你很久了....", "先生，您喜欢您所看到的吗？ *眨眼*", "进来吧，先生！你知道你想。", "法律规定不能碰，但我想我看到这里有很多违法者....", "如果你想要我的身体并且你认为我很性感，来吧亲爱的，告诉我吧！ *眨眼*", "来参加聚会吗，先生？ *傻笑*", "看过我的节目吗？不，没有乒乓球，但它很好，相信我！", "进来吧，糖！我会给你一些特别的东西..."])

    add_dialogue("beach intro", ("stubborn", "very dom"), ["[girl.fullname] 正在海滩上与一群人热烈交谈，其中一些人公开欣赏她健美的身材。"], sound=s_laugh)
    add_dialogue("beach meet MC", ("very dom"), ["g: 什么？女孩就不能安安静静地享受假期吗？", "当你靠近时，她会全力防御。", "mc: 哇，注意你的语气，女孩。我平平安安地来。", "g: 哼。好吧，我想我可以在完美的早晨休息一下来和你谈谈......"], multiple=True)
    add_dialogue("beach oiling", ("stubborn", "very dom"), ["这太棒了，你能做得更多吗... *眨眼* 嗯，是的，就像这样。我的胸部也需要一点，拜托..."], sound=s_ahaa)
    add_dialogue("beach accept oiling", ("stubborn", "very dom"), ["哦，谁是个调皮的男孩....？嗯...给我擦点油，[MC.name]！"])
    add_dialogue("beach refuse oiling", ("very dom"), ["嘿！我确信那里不会被晒伤，非常感谢！放手。"])
    add_dialogue("beach accept public sex", ("stubborn", "very dom"), ["g: 我看你下面需要一些注意！ *眨眼*！", "她开始吮吸你的鸡巴，让整个海滩都看到，并用双手脱下你的裤子。"], multiple=True)
    add_dialogue("beach refuse public sex", ("very dom"), ["当着别人面做这事？你要疯了吗？！？"])
    add_dialogue("beach accept sex", ("stubborn", "very dom"), ["呵呵...为什么不呢？当我们在这里的时候，让我们享受一些美好的时光吧...."])
    add_dialogue("beach refuse sex", ("very dom"), ["真不敢相信！这太过分了！今天应该是我的休息日，该死！"])
    add_dialogue("beach whoring request", ("stubborn", "very dom"), ["但你答应过我让我休息！你不能就这样食言...."])
    add_dialogue("beach whoring accept", ("stubborn", "very dom"), ["好吧，反正我也没有很多其他事情要做....我是个妓女....我还能做什么...."])
    add_dialogue("beach whoring refuse", ("stubborn", "very dom"), ["不！今天是我的休息日，我需要休息！"])


label test_dialogue():

    python:
        girl = MC.girls[0]
        add_dialogue("test dialg", "generic", "你好，你想要什么？")
        add_dialogue("test dialm", "generic", ["Multiple dialogue starts", "g: 那是什么？", "mc: 我们正在进行多次对话。", "g: 哦。我懂了。", "多重对话结束"], True)
        add_dialogue("test dialp", girl.personality.name, "这是我的个性对话。")
        add_dialogue("test diala", rand_choice(girl.attributes), "这是我的属性对话。")

    $ girl.say("test dialg")
    $ girl.say("test dialm")
    $ girl.say("test dialp")
    $ girl.say("test diala")

    return


## END DIALOGUE ##
