# Weapon Damage 

This table contains every single ranged weapon in the mod and is to be used for balancing weapons, armor and monster armor and hp.  

|Name                           |Archetype  |Type               |Ammo        |Ballistic | Laser |Plasma|Electric|Pure|AP  |BURST|NOTES                                     |
|-------------------------------|-----------|-------------------|------------|----------|-------|------|--------|----|----|-----|------------------------------------------|
|10mm Pistol                    |BALLISTIC  |Pistol             |10mm        |26        |       |      |        |    |0   |1    |                                          |
|MarSec. 4                      |BALLISTIC  |Pistol             |10mm        |35        |       |      |        |    |0   |2    |                                          |
|W1011 Silvergram               |BALLISTIC  |Smartgun           |10mm SMART  |20        |       |      |        |    |10  |2    |                                          |
|Gibson S86                     |BALLISTIC  |AR/Grenade Launcher|25mm        |80        |       |      |        |    |30  |4    |                                          |
|1025 Goa                       |BALLISTIC  |AT  Sniper         |25mm        |80        |       |      |        |    |30  |1    |Single shot                               |
|Wraitheon Armory 2519          |BALLISTIC  |Smart Sniper       |25mm SMART  |40        |       |      |        |    |30  |1    |Single shot                               |
|eidolon derringer              |Obsolete   |                   |            |          |       |      |        |    |    |1    |                                          |
|RM216 SPIW                     |Obsolete   |                   |            |          |       |      |        |    |    |     |                                          |
|RM232 IDW                      |Obsolete   |                   |            |          |       |      |        |    |    |     |                                          |
|MarSec. T72                    |BALLISTIC  |Handcannon         |7.5mm       |41        |       |      |        |    |15  |1    |                                          |
|landfall survival gun          |BALLISTIC  |Hunting Rifle      |7.5mm       |45        |       |      |        |    |15  |1    |                                          |
|Accipiter Hawk-00              |BALLISTIC  |LMG                |7.5mm       |45        |       |      |        |    |15  |4    |                                          |
|G&W SR-P9                      |BALLISTIC  |AR                 |7.5mm       |40        |       |      |        |    |15  |2    |                                          |
|G&W SR-P77                     |BALLISTIC  |AR                 |7.5mm       |35        |       |      |        |    |15  |15   |                                          |
|Vahagn 10XR                    |BALLISTIC  |Smart LMG          |7.5mm SMART |35        |       |      |        |    |15  |4    |                                          |
|RM99 revolver                  |Obsolete   |                   |            |          |       |      |        |    |    |     |                                          |
|wrist-stunner                  |Obsolete   |                   |UPS         |          |       |      |        |    |    |     |                                          |
|wrist-trilaser                 |Obsolete   |                   |UPS         |          |       |      |        |    |    |     |                                          |
|handheld x-ray cannon          |Obsolete   |                   |            |          |       |      |        |    |    |     |                                          |
|shoddy laser rifle             |Obsolete   |                   |LASER CELL  |          |       |      |        |    |    |     |                                          |
|av-22                          |LASER      |Pistol             |LASER CELL  |          |5      |      |        |    |    |3    |                                          |
|Graf 335L                      |LASER      |Handcannon         |LASER CELL  |          |50     |      |        |    |    |1    |Very frequent overheats                   |
|E-150b                         |LASER      |Pistol             |LASER CELL  |          |20     |      |        |20  |    |2    |                                          |
|Izhevsk PLC-75                 |LASER      |Recoiless Rifle    |LASER CELL  |          |300    |      |        |50  |    |1    |Single shot                               |
|Shikishma A-82 tactical laser  |LASER      |AT  Sniper         |LASER CELL  |          |45     |      |        |50  |    |3    |                                          |
|V14 laser pistol               |LASER      |Pistol             |LASER CELL  |          |10     |      |        |    |    |1    |                                          |
|A7 laser rifle                 |Obsolete   |AR                 |LASER CELL  |          |       |      |        |    |4   |2    |                                          |
|Makeshift Scrambler Rifle      |LASER      |Anti Drone         |LASER CELL  |          |       |      |        |    |1   |1    |                                          |
|xm34 EMP projector             |Obsolete   |                   |LASER CELL  |          |       |      |        |    |    |1    |                                          |
|makeshift rail rifle           |SOV-RAILGUN|Sniper             |ROD         |65, 80    |       |      |        |    |40  |1    |Single shot                               |
|mining rod launcher            |SOV-RAILGUN|Sniper             |ROD         |90        |       |      |        |    |40  |1    |Single shot                               |
|GG-860 Wasp Rifle              |RAILGUN    |AR                 |3X35        |14        |       |      |        |    |30  |8    |                                          |
|3x35mm automatic Coilpistol    |RAILGUN    |Pistol             |3X35        |10        |       |      |        |    |30  |5    |                                          |
|Magnadrive 230K                |PLASMA     |AT rifle           |MIL PLASMA  |          |       |120   |        |    |20  |1    |                                          |
|PAM-41 2g                      |PLASMA     |Handcannon         |MIL PLASMA  |          |       |70    |        |    |    |1    |                                          |
|direct fusion gun              |PLASMA     |Flamethrower       |CIV PLASMA  |          |       |45    |        |    |    |5    |                                          |
|377-UASTA                      |PLASMA     |Handcannon         |CIV PLASMA  |          |       |45    |        |    |    |1    |                                          |
|bionic skullgun                |BALLISTIC  |Meme               |7.5mm       |34        |       |      |        |    |    |1    |                                          |
|Benelli 315                    |SHOT       |Shotgun            |0           |15*9      |       |      |        |    |    |1    |                                          |
|Accipiter Magnastorm-12        |SHOT       |AP Shotgun         |0           |15*9      |       |      |        |    |3*9 |1    |                                          |
|Raketa                         |SHOT       |Assault Shotgun    |0           |15*9      |       |      |        |    |    |2    |                                          |
|Drotik Shotpistol              |SHOT       |Pistol             |0           |15*9      |       |      |        |    |    |1    |                                          |
|R-PROTON ENR                   |VOLTAIC    |Anti Drone Rifle   |VOLTAIC CELL|          |       |      |10      |25  |    |1    |Not Smart                                 |
|W3310 Archangel ENR            |VOLTAIC    |Anti Drone Rifle   |VOLTAIC CELL|          |       |      |30      |    |    |1    |Chains 3 times for 15 electric damage each|
|W3100 Volt                     |VOLTAIC    |Anti Drone Pistol  |VOLTAIC CELL|          |       |      |10      |    |    |1    |                                          |
|Alien lune                     |EXPLOSIVE  |Launcher           |ALIEN CELL  |          |50     |      |        |    |50  |1    |Explosion: 2500dmg                        |
|vatforged grenade launcher     |EXPLOSIVE  |Launcher           |Grenades    |          |       |      |        |    |    |1    |                                          |
|Aztlani bow                    |BOW        |Bow                |ARROW       |64        |       |      |        |    |    |1    |                                          |
|salvage bow                    |BOW        |Bow                |ARROW       |45        |       |      |        |    |    |1    |                                          |
|salvage crossbow               |BOW        |Bow                |ARROW       |60        |       |      |        |    |    |1    |                                          |

## Armor damage and HP breakpoints 

Monster and player armor should be understood to exist in the following categories: unarmored, Light Armor, Medium, Heavy, and Vehicle/Structure. Armor definitions should have the following defensive ratings:

| Armor   | Cut | Bash | Ballistic | Laser | Plasma | Electric |
|---------|-----|------|-----------|-------|--------|----------|
| Light   | 10  | 7.5  | 15        |  0    |  0     |     0    |
| Medium  | 20  | 15   | 30        | 10    |  0     |     0    |
| Heavy   | 50  | 30   | 60        | 30    | 20     |    10    |
| Vehicle | 70  | 50   | 90        | 70    | 50     |    25    |

Monsters and wearable armor pieces should belong to a single armor category (no mix matching E.X. Light melee armor combined with heavy ballistic armor ), if you desire monsters to be weaker against certain attack types, you should use weakpoint sets to achieve this. Armor pieces for players and NPCs should generally be ablative, either using the energy shield functionality or by having the `FRAGILE` flag.

Damage for monsters should be balanced around the armor breakpoints of the table above. A monster capable of deafeating "X" armor should be capable of dealing between 4-10 units of damage in 60% of its attacks attacks against a foe equiped with that type of armor. melee die capable of dealing more than 30 damage in a single turn shouldn't exist.

Good base die you can use for bash damage are:

| Armor     | Bash damage die  |
|-----------|------------------|
| Unarmored | 2d3+ (2 Optional)|
| Light     | 4d3              |
| Medium    | 4d5 +(4 AP)      |
| Heavy     | 16d2 +(6 AP)     |


The following should apply based on the monster type:

| Monster Archetype         | Example   | Estimate HP | Armor                    | Melee Damage Die | Speed | Notes                              |
|---------------------------|-----------|-------------|--------------------------|------------------|-------|------------------------------------|
| Small Alien Fauna         | Hevel     | <30         | unarmored                | unarmored        |       |                                    |
| Alien Herbivore           | Venandi   | 100         | unarmored                | unarmored        |       |                                    |
| Alien Predator            | Boatman   | 300         | light armor              | light or medium  |       |                                    |
| Alien Fauna Bossfight     | none yet  | 700+        | heavy armor              | heavy            |       |                                    |
| Moxphore Grunt            | Scavenger | 80          | unarmored                | unarmored        |       | Regens ~10hp                       |
| Moxphore Specialized      | Elder     | 140         | light armor or medium    | light or medium  |       | Regens ~15hp                       |
| Moxphore Armored          | Spartan   | 200         | medium armor             | medium           |       | Regens ~15hp                       |
| Moxphore Bossfight        | none yet  | 1500+       | heavy armor              | heavy            |       | Regens ~30hp                       |
| Small Utility Drone       | Eyebot    | 30          | unarmored                | unarmored        |       |                                    |
| Flying Utility Drone      | eyebot    | 30          | unarmored                | unarmored        |       |                                    |
| Human/Medium Utility Robot| seneschal | 150         | medium armor             | medium           |       |                                    |
| Large Utility Robot       | Udarnik   | 600         | medium armor             | medium or heavy  |       |                                    |
| Small Combat Drone        | none yet  | 80          | light armor              | medium           |       | Armor is up to X3 the base rating  |
| Human/Medium Combat Drone | Isohypsa  | 600         | heavy armor              | medium or heavy  |       | Armor is up to X3 the base rating  |
| Large Combat Drone        | Zenit     | 1500        | vehicle                  | heavy            |       | Armor is up to X3 the base rating  |
| Robot Bossfight           | none yet  | 4500+       | vehicle + omnishield     | heavy            |       | Armor is up to X3 the base rating  |
| Salvor                    | SALVOR NPC| 80          | light armor              | light            |       |                                    |
| UICA/Mercenary Grunt      | UICA NPC  | 80          | heavy armor              | light or medium  |       | Armor is blative and wont last     |
| UICA specops/Solos        | SOLO NPC  | 120+shield  | heavy armor + omnishield | medium           |       | Armor is blative and wont last     |

# Weapon Categorization

For ease of balancing, all aftershock weapons are separated into three abstract and gamified categories: light weapons, medium weapons and heavy weapons. Where a weapon belongs among these three categories depends on its damage output and AP rating as defined on the weapon/ammo json definitions.

Ideally the mod shouldn't have weapons that exist merely as stat block variations of each other, if you have a weapon idea and you can't get it to play differently from others, its better if you convert it into a variant and spawn it with some integrated gun mods.

##  Weapon types

### Ballistic/Railguns
Ballistic weapons are the most common. They offer the highest maximum range of all weapons, above average damage per projectile and are also the lightest. Compared to energy weapons they are more straightforward to use, with no marked weaknesses or strengths that should be worked around.
 
The current ballistic ammo calibres currently exist in the mod:

|Type        | Default ammo   | Damage of default | AP of default | Design intent                                                                                                             |
|------------|----------------|-------------------|---------------|---------------------------------------------------------------------------------------------------------------------------|
| 00 shot    | 12 g buckshot  |            9x15   |             0 | Deals with lightly armored foes at a disadvantage and deals little to no damage to medium armor. Many specialty variants. |
| 10mm       | 10mm JHP       |              31   |             0 | Deals with lightly armored foes at a disadvantage and deals little to no damage to medium armor.                          |
| 7.5mm      | 7.5mm caseless |              40   |            15 | Cleanly defeats light armor, deals with medium armor at a disadvantage and deals little to no heavy to medium armor.      |
| 25mm       | 25mm ball      |              80   |            30 | Cleanly defeats medium armor, deals with heavy armor at a strong disadvantage.                                            |
| 3x35mm     | GG Stinger     |               8   |            30 | Cleanly defeats medium armor, deals very low damage. Default ammo is considered the AP variant.                           |
| Rail Rod   | Steel rail     |              90   |            40 | Cleanly defeats heavy armor, deals with vehicle armor at a  disadvantage.                                                 |

To balance specialty rounds use the following rule:
- AP ammo recieves +15 ballistic armor piercing at the cost of -10 damage.
- Specialty ammo has the damage of AP ammo and the armor piercing capability of the default round + whatever special effect is granted. If the specialty effect is a strong AOE AP might be reduced further.

### Lasers
Lasers are accurate mid-range weapons whose reduced projectile damage is compensated by their fast fire rates, lack of recoil and the ability to set foes on fire. Lasers are the most common type of energy weapon and also the most versatile. Their magazines are heavier than their ballistic equivalents, but are fully interchangeable between weapons. They excel at dispatching isolated foes, which they can do in the most resource efficient ways.

Another important factor to consider is that lasers are the principal 'renewable' weapon type, they require only energy to be fired and their power cells might be recharged using vehicles or by visiting active settlements. 

#### Expected laser weapon stats
For light medium and heavy categories

* Max damage per turn: `20 / 50 / 120` 
* Max ammo efficiency per unit of damage `2kj / 1.5kj / 1kj`.
* Maximum range `15 / 40 / 60`.
* Average volume `1.5l / 5l / 15l`.
* Average Weight `2kg / 4kg / 12kg`. 
* Minimum reload time 200/200/400 moves.

### Plasma 
Plasma weapons are short range and high damage, and might additionally produce low range explosions or fireballs. Plasma weapons should be bulkier and heavier compared to other weapon types and have relatively shallow magazines with slow reload times, and thus require well planed reloading . The high AOE damage should make them dangerous to use during close combat.

They excel at efficiently dispatching powerful or massed foes.

#### Expected plasma weapon stats
For light medium and heavy categories

* Max damage per turn: `20 / 50 / 120` 
* Max shots per magazine `4 / 8 / 12`.
* Maximum range `8 / 12 / 20`.
* Average volume `2.5l / 7.5l / 30l`.
* Average Weight `2kg / 4kg / 12kg`. 
* Minimum reload time `600 / 1200 / 1800` moves.
 

### Voltaic-Electroshock
Voltaic weapons are all self-targeting, and their projectiles might arc between close targets and produce clouds of electric fields. The electric fields generated by voltaics offer high utility AOE effects: they slow and stun targets that pass through them while also inflicting low amounts of damage, all without risking the item or terrain destruction of traditional explosives or plasma weapons. This utility comes at the cost, compared to other damage types, they have the lowest damage per projectile and the rarest ammunition.

They excel at dispatching groups of weak foes, robots or at slowing foes to create better escape/combat opportunities.

#### Expected voltaic weapon stats
For light medium and heavy categories

* Max damage per turn: `15 / 30 / 60` 
* Max ammo efficiency per unit of damage `2kj / 1.5kj / 1kj`.
* Maximum range `15 / 30 / 60`.
* Average volume `1.5l / 5l / 15l`.
* Average Weight `2kg / 4kg / 12kg`. 
* Minimum reload time `600 / 1200 / 1800` moves.

### Explosive Projectiles
Rockets, grenades, smart bombs and all sort of things that are launched and explode. They offer the highest damage per projectile and deadly AOE damage, at the cost of heavy and expensive ammunition that is generally difficult to carry in good numbers, making them too specialized for general use. After voltaics, these are the second hardest weapon types to acquire. 
