# Power Descriptions
Note that every power, unless otherwise specified, is affected by Intelligence scaling and Nether Attunement scaling. Intelligence scaling is normalized at 10 with +/- 5% per point in either direction—-Intelligence 9 makes powers 95% as effective, Intelligence 12 makes powers 110% as effective, and so on. 

A (C) after a power name indicates that it can be maintained by concentration.

All powers have a kCal cost equal to (Difficulty of power * 5) times a randomized factor from 0.3 to 1.7. This applies when the power is first used and when the power is maintained (if a concentration power).

<details>
<summary><h1>Biokinesis</h1></summary>

**Note**: No biokinetic powers have a target listed because they only affect the psion. 

**Passive Power: Efficient System**: Reduces hunger, thirst, and metabolic burn rate by 3% plus 0.075% times the sum total levels of the psion's biokinetic powers, and increases the number of vitamins absorbed from food by a similar amount.
<details>
<summary><h3>Overcome Pain (C)</h3></summary>

*Difficulty*: 1<br />
*Duration*: 5 minutes to 21 minutes 40 seconds, plus 20 to 75 seconds per level<br />
*Stamina Cost*: 1750, minus 75 per level to a minimum of 800<br />
*Channeling Time*: 125 moves, minus 7 moves per level to a minimum of 50<br />
*Effects*: Adds pkill to the psion, scaling every 4 levels.<br /> 
| Level | Pkill Min | Pkill Tick | Pkill Max |
| --- | --- | --- | --- |
| 0 | 1 | 12 | 15 |
| 4 | 2 | 10 | 30 |
| 8 | 3 | 10 | 50 |
| 12| 4 | 8 | 75 |
| 16| 5 | 8 | 100 |
| 20| 6 | 6 | 130 |

This is natural painkiller and so has natural effects (reduces speed slightly)<br />
*Prerequisites*: Starting power.
</details>
<details>
<summary><h3>Physical Enhancement (C)</h3></summary>

*Difficulty*: 2<br />
*Duration*: 90 seconds to 7 minutes 30 seconds, plus 15 to 90 seconds per level<br />
*Stamina Cost*: 3500, minus 175 per level to a minimum of 1250<br />
*Channeling Time*: 120 moves, minus 5.5 moves per level to a minimum of 75<br />
*Effects*: Adds +1 Strength and +1 Dexterity, with an additional point of each every 5 power levels.  It also makes the psion immune to Weakening Poison.<br />
*Prerequisites*: Starting power.<br />
</details>
<details>
<summary><h3>Oxygen Absorption</h3></summary>

*Difficulty*: 2<br />
*Duration*: 3 minutes to 9 minutes, plus 36 to 72 seconds per level<br />
*Stamina Cost*: 2500, minus 85 per level to a minimum of 1200<br />
*Channeling Time*: 70 moves, minus 6 moves per level to a minimum of 25<br />
*Effects*: Allows the psion to breathe underwater.  This is the same as a rebreather, so it reduces the hidden oxygen stat by a significant amount, making Stamina recovery harder.<br />
*Prerequisites*: Physical Enhancement 4, Overcome Pain 3.<br />
</details>
<details>
<summary><h3>Burst of Speed</h3></summary>

*Difficulty*: 3<br />
*Duration*: Instant<br />
*Stamina Cost*: 3000, minus 190 per level to a minimum of 1500<br />
*Channeling Time*: 75 moves, minus 4.5 moves per level to a minimum of 15<br />
*Effects*: Dash up to 1 square plus 1 square per two levels, to a maximum of 12 squares.  This is normal movement and will subject you to tile hazards.<br />
*Prerequisites*: Physical Enhancement 9 *or* Enhance Mobility 5.<br />
</details>
<details>
<summary><h3>Flexibility</h3></summary>

*Difficulty*: 3<br />
*Duration*: 2 to 5 seconds<br />
*Stamina Cost*: 2500, minus 175 per level to a minimum of 1250<br />
*Channeling Time*: 50 moves, minus 2.5 moves per level to a minimum of 15<br />
*Effects*: Greatly increases the psion’s reaction (2x), block (1.2x) and crawl (1.5) limb scores, as well as rendering them immune to being grabbed and making it easier to recover from being downed.  It reduces fall damage by 20% plus 2% per level.<br />
*Prerequisites*: Physical Enhancement 6<br />
</details>
<details>
<summary><h3>Hardened Skin (C)</h3></summary>

*Difficulty*: 4
*Duration*: 5 minutes and 56 seconds to 11 minutes and 33 seconds, plus 1 minute 26 seconds to to 4 minutes and 4 seconds per level.<br />
*Stamina Cost*: 2500, minus 125 per level to a minimum of 750<br />
*Channeling Time*: 150 moves, minus 8.5 moves per level to a minimum of 50.<br />
*Effects*: Increases piercing armor by 3, bashing armor by 6, and cutting armor by 4.  Also makes the psion immune to bleeding from wounds received during its duration (previous bleeding is unaffected) and reduces incoming pain by 2% per level.<br />
*Prerequisites*: Overcome Pain 6 *or* Physical Enhancement 8, Flexibility 7 *or* Temperature Adaptability 6.<br />
</details>
<details>
<summary><h3>Adrenaline Trigger</h3></summary>

*Difficulty*: 4<br />
*Duration*: 15 minutes<br />
*Stamina Cost*: 3500, minus 165 per level to a minimum of 1800<br />
*Channeling Time*: 100 moves, minus 5.5 moves per level to a minimum of 35<br />
*Effects*: Cause an adrenaline surge. This provides a burst of speed and strength and high tolerance for pain for the duration but the psion will crash when the surge ends.<br />
*Prerequisites*: Overcome Pain 7, Burst of Speed 8 *or* Enhance Mobility 6. 
</details>
<details>
<summary><h3>Temperature Adaptability (C)</h3></summary>

*Difficulty*: 4<br />
*Duration*: 5 minutes to 10 minutes, plus 3 minutes to 6 minutes per level<br />
*Stamina Cost*: 3500, minus 175 per level to a minimum of 1250<br />
*Channeling Time*: 250 moves, minus 8.5 moves per level to a minimum of 150<br />
*Effects*: Increases temperature tolerance in both directions by 15 degrees plus 7.5 degrees per level.<br />
*Prerequisites*: Oxygen Absorption 5, Physical Enhancement 9 *or* Metabolic Hyperefficiency 6<br />
</details>
<details>
<summary><h3>Enhance Mobility (C)</h3></summary>

*Difficulty*: 5<br />
*Duration*: 5 minutes to 15 minutes, plus 45 seconds to 120 seconds per level<br />
*Stamina Cost*: 4500, minus 150 per level to a minimum of 2500<br />
*Channeling Time*: 275 moves, minus 15 moves per level to a minimum of 50.<br />
*Effects*: Reduces encumbrance on every body part, starting at -2 and improving by -2 every 2 levels, to a maximum of -32 at level 30.<br />
*Prerequisites*: Overcome Pain 4,  Heightened Reflexes 6 *or* Flexibility 9, Burst of Speed 10 *or* Combat Dance 4 *or* Physical Enhancement 10.<br />
</details>
<details>
<summary><h3>Hammerhand (C) </h3></summary>

*Difficulty*: 5<br />
*Duration*: 30 minutes to 90 minutes, plus 7 minutes 30 seconds to 12 minutes 30 seconds per level.<br />
*Stamina Cost*: 4500, minus 225 per level to a minimum of 2250<br />
*Channeling Time*: 350 moves, minus 12.5 moves per level to a minimum of 150<br />
*Effects*: Allows the psion to replicate a number of common tools with their own body: it provides the Bolt Turning 1, Screw Driving 1, Hammering 3, Fine Hammering 1, Soft Hammering 1, Wood Chiseling 1, Prying 2, and Nail Prying 1 qualities.<br />
*Prerequisites*: Physical Enhancement 6, Hardened Skin 6<br />
</details>
<details>
<summary><h3>Heightened Reflexes (C)</h3></summary>

*Difficulty*: 6<br />
*Duration*: 90 seconds to 7 minutes 30 seconds, plus 15 to 90 seconds per level<br />
*Stamina Cost*: 5500, minus 205 per level to a minimum of 2250<br />
*Channeling Time*: 175 moves, minus 5.5 moves per level to a minimum of 100<br />
*Effects*: Adds +1 Perception and +5 Speed, plus 1 Perception per 5 levels and plus 1 Speed per level (to a maximum bonus of +30 speed).<br />
*Prerequisites*: Flexibility 8 *or* Burst of Speed 8, Physical Enhancement 6, Adrenaline Trigger 8<br />
</details>
<details>
<summary><h3>Sealed System</h3></summary>

*Difficulty*: 7<br />
*Duration*: 60 seconds to 5 minutes, plus 8 to 25 seconds per level<br />
*Stamina Cost*: 5500, minus 175 per level to a minimum of 2750<br />
*Channeling Time*: 200 moves, minus 7.5 moves per level to a minimum of 100<br />
*Effects*: Prevents the psion from having to breathe and seals off their body against outside danger.  They become immune to the Smoke, Teargas, Boomer Bile, Mi-go Atmosphere, Fetid Goop, Relaxation Gas, Triffid Pollen, Fungal Spores, Dermatik parasitization, Poison, and Bad Poison effects, as well as electrical damage.  They have no scent and receive 75% less radiation. Finally, their wounds stop bleeding and wounds received while the power is in effect will not bleed.<br />
*Prerequisites*: Hardened Skin 9 *or* Oxygen Absorption 9, Temperature Adaptability 10 *or* Hammerhand 7<br />
</details>
<details>
<summary><h3>Metabolic Hyperefficiency (C)</h3></summary>

*Difficulty*: 7<br />
*Duration*: 45 minutes to 112 minutes and 30 seconds, plus 4 minutes 10 seconds to 8 minutes 20 seconds per level<br />
*Stamina Cost*: 8000, minus 250 per level to a minimum of 4000<br />
*Channeling Time*: 250 moves, minus 13 moves per level to a minimum of 50<br />
*Effects*: Greatly increases the psion’s metabolic efficiency.  fatigue grows 25% more slowly and the basal metabolic rate is reduced by 10%.  The fatigue reduction increase by 2% per level to a maximum of 70% increase, and the reduction to metabolic rate increases by 1% per level to a maximum of 40%.  In the addition, the psion can extract more calories and vitmins from food, gain 33% more of each plus 7% per power level, to a maximum of 4x the base caloric and vitamin content.  This applies to all vitamins, including harmful ones.<br />
*Prerequisites*: Temperature Adaptability 8, Adrenaline Trigger 6 *or* Physical Enhancement 12<br />
</details>
<details>
<summary><h3>Combat Dance</h3></summary>

*Difficulty*: 8<br />
*Duration*: 40 seconds to 3 minutes and 20 seconds, plus 12 seconds to 59 seconds per level<br />
*Stamina Cost*: 5500, minus 125 per level to a minimum of 2250<br />
*Channeling Time*: 100 moves, minus 4 moves per level to a minimum of 40<br />
*Effects*: Provides a myriad of combat bonuses depending on what other biokinetic powers the psion has active. 
- With Overcome Pain: Incoming pain is reduced by 15% plus 3% per power level
- With Physical Enhancement: Melee damage is increased by 15% + 3.5% per power level and the stamina consumption of melee attacks is reduced by 5% plus 1.5% per power level to a maximum of 70% reduction.
- With Burst of Speed: Move 25% further plus 3% per power level.
- With Flexibility: Dodge skill is increased by 4, plus 1 per power level.
- With Adrenaline Trigger: Cardio multiplier increases by 15% + 1.5% per power level.
- With Hardened Skin: The bonues from hardened skin are increased by 50% plus 4% per power level, to a maximum of double the base bonus. Also, the psion is immune to being dazed or stunned. 
- With Hammerhand: The psion does 25% additional bash damage with unarmed attacks, plus 3% per power level, as well as an increased chance to directly pulp the corpse of your target.
- With Enhance Mobility: The psion gains Uncanny Dodge.
- With Heightened Reflexes: Move cost is reduced by 10% plus 2% per power level, to a maximum of 50%, and recoil reduced by 30. In addition, the psions gains 1 bonus dodge, plus 1 per 8 power levels.

<br />
*Prerequisites*: Heightened Reflexes 10, Physical Enhancement 10, Adrenaline Trigger 9 *or* Burst of Speed 6<br />
</details>
<details>
<summary><h3>Guided Evolution (C)</h3></summary>

*Difficulty*: 8<br />
*Duration*: 45 minutes to 112 minutes and 30 seconds, plus 4 minutes 10 seconds to 8 minutes 20 seconds per level<br />
*Stamina Cost*: 8000, minus 250 per level to a minimum of 4000<br />
*Channeling Time*: 250 moves, minus 13 moves per level to a minimum of 50<br />
*Effects*: Whenever the psion mutates, they may choose from 1 + 0.25 extra mutations per level for which trait they want to mutate.  This power does not in of itself mutate the psion, and at high nether attunement may result in extra random mutations.<br />
*Prerequisites*: Special (must be studied from notes)<br />
</details>
<details>
<summary><h3>Vitaminosis</h3></summary>

*Difficulty*: 8<br />
*Target*: Self<br />
*Duration*: Instant<br />
*Stamina Cost*: 8000<br />
*Channeling Time*: 5 seconds<br />
*Effects*: Enter a trance where the psion converts calories into either iron, vitamin C, and calcium at a rate of 200 calories per 100 vitamins.  The psion will automatically stop meditating when all three vitamins are full.<br />
*Prerequisites*: Metabolic Hyperefficiency 8, Adrenaline Trigger 6<br />
</details>
<details>
<summary><h3>Perfected Motion (C)</h3></summary>

*Difficulty*: 9<br />
*Duration*: 5 seconds to 30 seconds, plus 0.5 to 1.1 seconds per level<br />
*Stamina Cost*: 8000, minus 175 per level to a minimum of 3500<br />
*Channeling Time*: 75 moves, minus 4 moves per level to a minimum of 15<br />
*Effects*: Increases the psion’s movement rate to an inhuman degree.  Move cost is reduced by 50% plus 1.5% per level, to a maximum of 96% reduced move cost. The psion is also immune to slippery terrain.<br />
*Prerequisites*: Combat Dance 6, Burst of Speed 12<br />  
*Note*: Perfected Motion is incompatible with Hurricane Blows
</details>
<details>
<summary><h3>Hurricane Blow</h3></summary>

*Difficulty*: 10<br />
*Duration*: 1 second<br />
*Stamina Cost*: 4500, minus 75 per level to a minimum of 2500<br />
*Channeling Time*: 65 moves, minus 3 moves per level to a minimum of 15<br />
*Effects*: Allows the psion to strike multiple times in less than a second.  Speed is increased by 400 plus 75 per power level and the psion attacks 25% faster and does 10% more melee damage plus 1.5% per power level, but cannot use ranged attacks or other psionic powers, and the power ends immediately if the psion moves.<br />
*Prerequisites*: Combat Dance 10, Reflex Enhance 14 *or* Adrenaline Trigger 12<br />
*Note*:  Hurricane Blows is incompatible with Perfected Motion
</details>
</details>
<details>
<summary><h1>Clairsentience</h1></summary>

**Passive Power: Psionic Senses**: Protects the psion's senses from minor sensory damage, such as loud noises or the glare of sunlight.  The psion can also sense Nether creatures within a radius of 2 squares plus 0.075 squares times the sum total of the levels of the psion's clairsentience powers.
<details>
<summary><h3>Heightened Senses (C)</h3></summary>

*Difficulty*: 1<br />
*Target*: Self<br />
*Duration*: 9 minutes 55 seconds to 21 minutes 4 seconds, plus 3 minutes 35 seconds to 8 minutes 2 seconds minutes per level<br />
*Stamina Cost*: 2000, minus 85 per level to a minimum of 750<br />
*Channeling Time*: 50 moves, minus 2 moves per level to a minimum of 20<br />
*Effects*: Increases the psion's mundane senses, adding 1 Perception plus 1 per 3 power levels, 1 extra range of overmap sight plus 1 per 5 power levels, and increasing the sensitivity of the psion's hearing by 25% per power level. Extra powers are gained at specific breakpoints: at an effective level of 6, the psion can see underwater; at an effective level of 10, the psion can crack safes without needing a stethoscope, and at an effective level of 15, or at any time in smoke or while blind, the psion is aware of all movement in a small radius around them.<br />
*Prerequisites*: Starting power<br />
</details>
<details>
<summary><h3>Speed Reader (C)</h3></summary>

*Difficulty*: 2<br />
*Target*: Self<br />
*Duration*: 4 minutes 50 seconds to 16 minutes 20 seconds, plus 2 minutes 30 seconds to 4 minutes 30 seconds minutes per level<br />
*Stamina Cost*: 2500, minus 125 per level to a minimum of 1000<br />
*Channeling Time*: 500 moves, minus 12 moves per level to a minimum of 250<br />
*Effects*: Increases the psion's ability to read and retain information. The psion reads 20% faster, plus 2% per power level to a maximum of 60% faster, and gains 0.15% additional XP per reading increment per power level.<br />
*Prerequisites*: Starting power<br />
</details>
<details>
<summary><h3>Premonition (C)</h3></summary>

*Difficulty*: 2<br />
*Target*: Self<br />
*Duration*: 19 minutes and 34 seconds to 37 minutes and 12 seconds, plus 5 minutes and 3 seconds seconds to 16 minutes and 42 seconds per level<br />
*Stamina Cost*: 2250, minus 85 per level to a minimum of 850<br />
*Channeling Time*: 85 moves, minus 7 moves per level to a minimum of 25<br />
*Effects*: Open the psion's senses up to nearby dangers or other disturbances, allowing them to sense nearby motion as well as other more esoteric sources of danger (such as receiving an advance warning before a portal storm).  The psion cannot tell the exact location of the danger, only that it's nearby.<br />
*Prerequisites*: Heightened Senses 6<br />
</details>
<details>
<summary><h3>Night Eyes (C)</h3></summary>

*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: 12 minutes to 23 minutes 20 seconds, plus 6 minutes 12 seconds to 13 minutes 30 seconds minutes per level<br />
*Stamina Cost*: 3500, minus 75 per level to a minimum of 2000<br />
*Channeling Time*: 50 moves, minus 2 moves per level to a minimum of 20<br />
*Effects*: Allows the psion to "see" in the dark--this is technically not sight but functions that way for game purposes.  This increases the psion's night vision by 2 squares plus 1.5 squares per power level.  If the psions also has Heightened Senses level 8 or higher (counting Intelligence and Nether Attunement scaling) active, they can craft in darkness as well.<br />
*Prerequisites*: Heightened Senses 8<br />
</details>
<details>
<summary><h3>Discern Weakness</h3></summary>

*Difficulty*: 3<br />
*Target*: One enemy within 1 square plus 1.2 squares per power level<br />
*Duration*: 13 to 30 seconds, plus 1.5 to 2.5 seconds per level<br />
*Stamina Cost*: 3000, minus 125 per level to a minimum of 1250<br />
*Channeling Time*: 150 moves, minus 5.5 moves per level to a minimum of 75<br />
*Effects*: Reduce the armor values of the target, causing them to take +4 additional damage, +1 per power level, on any hit.<br />
*Prerequisites*: Night Eyes 4, Premonition 4<br />
</details>
<details>
<summary><h3>Aura Sight (C)</h3></summary>

*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: 10 minutes and 50 seconds to 18 minutes and 50 seconds, plus 1 minute 30 seconds to 3 minutes 10 seconds per level<br />
*Stamina Cost*: 4000, minus 115 per level to a minimum of 1750<br />
*Channeling Time*: 300 moves, minus 8.5 moves per level to a minimum of 100<br />
*Effects*: Reveal others' emotions, increasing the psion's chance to persuade them or lie to them by 1% per power level, to a maximum of 20%.<br />
*Prerequisites*: Heightened Senses 5, Discern Weakness 5<br />
</details>
<details>
<summary><h3>Radiation Sense</h3></summary>

*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: Instant or 30 minutes to 1 hour 15 minutes<br />
*Stamina Cost*: 4500, minus 125 per level to a minimum of 2000<br />
*Channeling Time*: 250 moves, minus 4.5 moves per level to a minimum of 100<br />
*Effects*: Sense nearby radiation, either on the psion themselves (instant duration) or in their surrounding environment.  Radiation sense on the psion provides an idea of how much radiation they are suffering from; radiation sense on the environment reveals only its presence or absense.<br />
*Prerequisites*: Special (must be studied from notes)<br />
</details>
<details>
<summary><h3>Marksman's Eye (C)</h3></summary>

*Difficulty*: 4<br />
*Target*: Self<br />
*Duration*: 3 minutes and 30 seconds to 10 minutes and 40 seconds, plus 8 seconds to 25 seconds per level<br />
*Stamina Cost*: 4500, minus 135 per level to a minimum of 2250<br />
*Channeling Time*: 200 moves, minus 6 moves per level to a minimum of 125<br />
*Effects*: Increase the psion's range with ranged weapons by 1 square per 4 power levels, reduces weapon dispersion by 2.5% per power level to a maximum of 60%, and increases your chance to hit weakpoints with ranged weapons by 10% plus 8% per power level.<br />
*Prerequisites*: Discern Weakness 7<br />
</details>
<details>
<summary><h3>Psychometry</h3></summary>

*Difficulty*: 4<br />
*Target*: One item<br />
*Duration*: Instant<br />
*Stamina Cost*: 5000<br />
*Channeling Time*: 5 minutes<br />
*Effects*: Examine a single object, determining hidden information about it. Current supports determining: artifact resonance.<br />
*Prerequisites*: Aura Sight 6, Speed Reading 8 *or* Premonition 8<br />
</details>
<details>
<summary><h3>Sense Hostility (C)</h3></summary>

*Difficulty*: 5<br />
*Target*: All hostile creatures within 2 squares per power level<br />
*Duration*: 2 minutes to 8 minutes 10 seconds, plus 45 seconds to 1 minutes 15 seconds minutes per level<br />
*Stamina Cost*: 6500, minus 120 per level to a minimum of 3150<br />
*Channeling Time*: 85 moves, minus 7 moves per level to a minimum of 25<br />
*Effects*: Reveal the location of all hostile enemies (NPCs who are currently hostile and creatures with aggression 10 or greater) within the power's range. Sense Danger does not reveal exactly what sort of enemy is out there, only that something is.<br />
*Prerequisites*: Heightened Senses 8, Premonition 6, Aura Sight 5<br />
</details>
<details>
<summary><h3>Clairyovance</h3></summary>

*Difficulty*: 5<br />
*Target*: 2 squares plus 1.2 squares per power level to a maximum of 80 squares, with an area of effect of 1.5 squares plus 1.2 squares per power level to a maximum of 50 squares<br />
*Duration*: 2.5 to 15 seconds, plus 0.5 seconds to 1.1 seconds per power level<br />
*Stamina Cost*: 6000, minus 195 per level to a minimum of 3500<br />
*Channeling Time*: 1000 moves, minus 25 moves per level to a minimum of 500<br />
*Effects*: Reveal the entire area of effect as though the psion were standing and able to see all of it at once. When the power duration expires, the effect will gradually fade over the next few seconds.<br />
*Prerequisites*: Premonition 6, Aura Sight 6 *or* Night Eyes 10<br />
</details>
<details>
<summary><h3>Combat Sense (C)</h3></summary>

*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: 2 minutes to 7 minutes and 30 seconds, plus 9 seconds to 17 seconds per level<br />
*Stamina Cost*: 5500, minus 145 per level to a minimum of 2750<br />
*Channeling Time*: 150 moves, minus 9 moves per level to a minimum of 70<br />
*Effects*: Gaze a short time into the future to predict enemy movements.  Grants a 25% chance to avoid any damage from an attack plus 1.5% per power level to a maximum of a 70% chance, prevents the psion from being grabbed, and applies the HARDTOHIT flag.  It also increases your effective dodge skill by 1 per 2 power levels.<br />
*Prerequisites*: Premonition 10 *or* Sense Hostility 5, Speed Reader 10 *or* Discern Weakness 6, Clairyovance 6<br />
</details>
<details>
<summary><h3>Intuitive Artisan (C)</h3></summary>

*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: 20 minutes and 15 seconds to 45 minutes, plus 4 minutes and 10 seconds to 10 minutes per level<br />
*Stamina Cost*: 6500, minus 145 per level to a minimum of 3250<br />
*Channeling Time*: 500 moves, minus 3 moves per level to a minimum of 300<br />
*Effects*: Enter a trance and improve the psion's ability to craft, increasing crafting speed by 4% and skill level by 0.25 per 4 power levels and allowing them to craft regardless of light levels. However, the psion's vision will be limited and their movement speed will be slowed while in the trance, and they will be blind while actually crafting anything.<br />
*Prerequisites*: Speed Reader 8, Discern Weakness 4, Premonition 6<br />
</details>
<details>
<summary><h3>One Perfect Shot</h3></summary>

*Difficulty*: 7<br />
*Target*: Self<br />
*Duration*: 10 seconds or until a shot is fired<br />
*Stamina Cost*: 7500, minus 160 per level to a minimum of 5000<br />
*Channeling Time*: 100 moves, minus 4.5 moves per level to a minimum of 35<br />
*Effects*: Reduce weapon dispersion to 0 and increase ranged damage by 150% for a single attack.<br />
*Prerequisites*: Marksman's Eye 9<br />
</details>
<details>
<summary><h3>Satellite View</h3></summary>

*Difficulty*: 7<br />
*Target*: Overmap between 4 and 11 squares plus 0.5 to 1 per power level <br />
*Duration*: Instant<br />
*Stamina Cost*: 9000<br />
*Channeling Time*: 60 seconds<br />
*Effects*: The psion gains a bird's eye (or mole's eye) view of surrouding terrain, revealing all locations within the power's radius.<br />
*Prerequisites*: Clairvoyance 8, Premonition 6 *or* Aura Sight 6<br />
</details>
<details>
<summary><h3>Clarity (C)</h3></summary>

*Difficulty*: 8<br />
*Target*: Self<br />
*Duration*: 2 minutes and 30 seconds to 7 minutes and 30 seconds, plus 12 seconds to 25 seconds per level<br />
*Stamina Cost*: 8000, minus 150 per level to a minimum of 4500<br />
*Channeling Time*: 75 moves, minus 3.5 moves per level to a minimum of 25<br />
*Effects*: The psion prevents anything from interfering with their senses, becoming immune to being Dazed, Stunned (either physically or psionically), blinded, made to hallucinate, deafened, Blinding Venom, and also cannot get high or drunk.  In addition, the psion can see creatures that are supernaturally hard to perceive.  This does not stop enemy telepaths from hiding their presence.<br />
*Prerequisites*: Night Eyes 10, Speed Reader 8 *or* Aura Sight 8 *or* Combat Sense 5<br />
</details>
<details>
<summary><h3>Astral Projection</h3></summary>

*Difficulty*: 8<br />
*Target*: Self<br />
*Duration*: Indefinite<br />
*Stamina Cost*: 5000, minus 125 per level to a minimum of 2000<br />
*Channeling Time*: 60 seconds<br />
*Effects*: The psion casts their spirit forth, wandering disembodied. While in spirit form they are invisible and intangible, move extremely quickly, and can pass through walls. However, they do not regenerate stamina and every step costs 75 stamina (minus 3 times the power level, to a minimum of 25). When stamina reaches 0, or at any time by using the appropriate power, the psion may return to their body.<br />
*Prerequisites*: Clarity 6 and Clairvoyance 9 *or* Satellite View 8 and Clairvoyance 9<br />
</details>
<details>
<summary><h3>Prescient Tactician (C)</h3></summary>

*Difficulty*: 9<br />
*Target*: All allies within 20 squares<br />
*Duration*: 1 to 3 minutes, plus 9 seconds to 23 seconds per level<br />
*Stamina Cost*: 7500, minus 125 per level to a minimum of 4000<br />
*Channeling Time*: 200 moves, minus 7.5 moves per level to a minimum of 60<br />
*Effects*: The psion enters a trance and predicts the flow of an entire group of combatants. While this inhibits their own combat ability, causing a -6 dodge and -5 hit penalty, the prescient orders they call out add a +4 dodge bonus and +1 block and dodge, +1 extra block and dodge to 8 power levels, to all allies who are close enough to hear the orders.<br />
*Prerequisites*: Combat Sense 8, Marksman's Eye 7, Clarity 5<br />
</details>
<details>
<summary><h3>Omniscience</h3></summary>

*Difficulty*: 10<br />
*Target*: A radius of 40 squares around the psion<br />
*Duration*: 2 to 10 seconds, plus 0.75 to 1.5 seconds per power level<br />
*Stamina Cost*: 10000, minus 115 per level to a minimum of 7500<br />
*Channeling Time*: 75 moves, minus 3.5 moves per level to a minimum of 25<br />
*Effects*: The psion expands their senses to encompass the entire area around them, seeing everything within 40 squares and from Z level 10 to Z level -10 all simultaneously. Their powers allow them to process all the information simultaneously and not suffer any consequences from doing so.<br />
*Prerequisites*: Clairvoyance 14 *or* Satellite View 8, Clarity 9<br />
</details>
</details>
<details>
<summary><h1>Electrokinesis</h1></summary>

**Passive Power: Galvanic Armor**: Reduces incoming electrical damage by 0.2 per level of the psion's electrokinetic powers and reduces incoming pain by 0.035% times the sum total of the psion's levels in electrokinetic powers.
<details>
<summary><h3>Spark Sight (C)</h3></summary>

*Difficulty*: 1<br />
*Target*: Self<br />
*Duration*: 15 minutes to 30 minutes, plus 2 minutes 30 seconds to 5 minutes per level<br />
*Stamina Cost*: 2000, minus 75 per level to a minimum of 750<br />
*Channeling Time*: 150 moves, minus 6 moves per level to a minimum of 80<br />
*Effects*: Allows the psion to see electrical creatures (electrical zombies, robots, and cyborgs) from further away, up to 6 squares + 1.5 squares per power level.<br />
*Prerequisites*: Starting power<br />
</details>
<details>
<summary><h3>Static Touch</h3></summary>

*Difficulty*: 1<br />
*Target*: One target within Range 1<br />
*Duration*: 1 to 3 seconds<br />
*Stamina Cost*: 1500, minus 65 per level to a minimum of 450<br />
*Channeling Time*: 100 moves, minus 4 moves per level to a minimum of 35<br />
*Effects*: Zap a single target with a jolt of electricity, doing 2 to 7 plus 1 to 1.5 per power level electrical damage, as well as dazing them for the power's duration.<br />
*Prerequisites*: Starting power<br />
</details>
<details>
<summary><h3>Electrical Discharge (C)</h3></summary>

*Difficulty*: 2<br />
*Target*: Self<br />
*Duration*: 5 minutes to 13 minutes and 20 seconds, plus 1 minute and 20 seconds to 3 minutes and 45 seconds per power level<br />
*Stamina Cost*: 3500, minus 120 per level to a minimum of 1100<br />
*Channeling Time*: 125 moves, minus 5 moves per level to a minimum of 45<br />
*Effects*: Build up a charge in the psion's body, zapping anyone who attacks them 50% of the time for 1 to 5 damage, plus 1/4 (i.e., one point per four levels) to 1/2 damage per power level.  The power also renders the psion's gear and bionic power immune to EMP attacks.<br />
*Prerequisites*: Static Touch 4<br />
</details>
<details>
<summary><h3>Voltaic Strikes (C)</h3></summary>

*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: 4 minutes to 10 minutes, plus 55 seconds to 1 minute 30 seconds per power level.<br />
*Stamina Cost*: 3750, minus 115 per level to a minimum of 1450<br />
*Channeling Time*: 85 moves, minus 6 moves per level to a minimum of 35<br />
*Effects*: Build up a charge in the psion's body, zapping their targets 50% of the time for 3 to 10 damage, plus 1/3 (i.e., one point per three levels) to 1/1.5 damage per power level, and leaves a lightning field of intensity 1 to 4 at the enemy's location 50% of the time.  The power also provides electrical armor equal to the power level.<br />
*Prerequisites*: Static Touch 5, Electrical Discharge 5<br />
</details>
<details>
<summary><h3>Electron Overflow (C)</h3></summary>

*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: 10 minutes to 30 minutes, plus 45 seconds to 90 seconds per power level<br />
*Stamina Cost*: 6500, minus 150 per level to a minimum of 3500<br />
*Channeling Time*: 350 moves, minus 9 moves per level to a minimum of 150<br />
*Effects*: Passively recharge any batteries and electrical devices on the psion's person.<br /> 
*Prerequisites*: Spark Sight 5, Electrical Discharge 8<br />
</details>
<details>
<summary><h3>Neural Spasms</h3></summary>

*Difficulty*: 4<br />
*Target*: One target within 1 square plus 0.6 squares per power level<br />
*Duration*: From 1 to 3 seconds, plus 0.2 to 0.35 seconds per power level, to a maximum of 5 to 10 seconds<br />

*Stamina Cost*: 5500, minus 150 per level to a minimum of 2500<br />
*Channeling Time*: 150 moves, minus 5 moves per level to a minimum of 75<br />
*Effects*: Dazes and downs the target by overloading their nervous system.  Within the power duration, the target do nothing but twitch futilely. It cannot affect targets without a biological nervous system--plants, robots, Nether creatures, fungus, etc.<br />
*Prerequisites*: Spark Sight 6, Voltaic Strikes 5 *or* Static Touch 8<br />
</details>
<details>
<summary><h3>Pain Suppression (C)</h3></summary>

*Difficulty*: 4<br />
*Target*: Self<br />
*Duration*: 10 minutes to 25 minutes, plus 2 minutes to 4 minutes and 40 seconds per power level.<br />
*Stamina Cost*: 4000, minus 105 per level to a minimum of 1250<br />
*Channeling Time*: 125 moves, minus 4 moves per level to a minimum of 75<br />
*Effects*: Reduces incoming pain by 15% plus 2% per power level, to a maximum of 50% reduction, and increases the chance to remove pain during pain reduction checks by 10% plus 2% per power level to a maximum of 50% increased chance.<br />
*Prerequisites*: Neural Spasms 4 *or* (Spark Sight 8 AND Electrical Discharge 8)<br />
</details>
<details>
<summary><h3>Hacking Interface (C)</h3></summary>

*Difficulty*: 4<br />
*Target*: Self<br />
*Duration*: 10 minutes and to 30 minutes, plus 45 seconds to 1 minute and 30 seconds per power level.<br />
*Stamina Cost*: 6500, minus 150 per level to a minimum of 3500<br />
*Channeling Time*: 350 moves, minus 9 moves per level to a minimum of 150<br />
*Effects*: Create a connection between the psion's brain and any computers nearby, allowing them to hack the computer with their mind.  They still must interact with the computer to hack it.  Increasing level decreases the time the hack will take and increases the odds the hack will be successful.<br />
*Prerequisites*: Spark Sight 4, Static Touch 4, and Electron Overflow 4<br />
</details>
<details>
<summary><h3>Electrocutioner</h3></summary>

*Difficulty*: 5<br />
*Target*: Line stretching 3 squares plus 0.7 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 3500, minus 150 per level to a minimum of 1200<br />
*Channeling Time*: 100 moves, minus 6 moves per level to a minimum of 35<br />
*Effects*: Hurls a lightning bolt at a target within range, doing 20 to 45 electrical damage plus 2 to 4 per power level and leaving intensity 1 to 2 lightning fields in its wake.  This power causes additional sound at the target location.<br />
*Prerequisites*: Voltaic Strikes 8 *or* Static Touch 12, Electrical Discharge 8<br />
</details>
<details>
<summary><h3>Re-energize</h3></summary>

*Difficulty*: 6<br />
*Target*: Adjacent vehicle or appliance<br />
*Duration*: Instant<br />
*Stamina Cost*: 7500, minus 150 per level to a minimum of 4500<br />
*Channeling Time*: 15 seconds<br />
*Effects*: Recharges the batteries of a vehicle or an electrical grid, restoring 250 to 500 power plus 125 to 250 per power level.<br />
*Prerequisites*: Electron Overflow 10, Electrical Discharge 9 *or* Neural Spasms 7<br />
</details>
<details>
<summary><h3>Analgesic Block</h3></summary>

*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: 60 seconds to 2 minutes 30 seconds, plus 8 seconds to 13 seconds per power level<br />
*Stamina Cost*: 4500, minus 125 per level to a minimum of 1750<br />
*Channeling Time*: 75 moves, minus 4.5 moves per level to a minimum of 25<br />
*Effects*: Removes all pain and makes the psion immune to pain for the power's duration. When the duration ends, the psion receives all the pain they put off, plus an additional 10%, back all at once.<br />
*Prerequisites*: Pain Suppression 9<br />
</details>
<details>
<summary><h3>Neuro-acceleration (C)</h3></summary>

*Difficulty*: 6<br />
*Target*: Self or ally within 1 square<br />
*Duration*: 1 minute 21 seconds to 4 minutes 46 seconds, plus 18 to 57 seconds per level if used on self, or <br />
*Stamina Cost*: 6000, minus 135 per level to a minimum of 2750<br />
*Channeling Time*: 165 moves, minus 5.5 moves per level to a minimum of 75<br />
*Effects*: Increases the target's reflexes and response time, adding 5 learning focus plus 1 per power level to a maximum of 35 learning focus, as well as 10 speed plus 1.5 per power level to a maximum of 60 speed.<br />
*Prerequisites*: Electron Overflow 11 *or* Neural Spasms 6, Electrical Discharge 8 *or* Spark Sight 5<br />
</details>
<details>
<summary><h3>Short Circuit</h3></summary>

*Difficulty*: 7<br />
*Target*: One robot or cyborg within 1 square plus 0.7 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 7500, minus 125 per level to a minimum of 4500<br />
*Channeling Time*: 75 moves, minus 2.5 moves per level to a minimum of 30<br />
*Effects*: Overloads a robot or cyborg, completely short-circuiting it and destroying it, and releasing a cloud of sparks within 1 square of the target plus 0.4 squares per power level.  Yrax constructs do not function based on electricity and are immune to this power.<br />
*Prerequisites*: Re-energize 8 *or* Electrocutioner 8 *or* Voltaic Strikes 13, Spark Sight 8<br />
</details>
<details>
<summary><h3>Robotic Interface</h3></summary>

*Difficulty*: 8<br />
*Target*: One nearby robot or cyborg within 10 squares<br />
*Duration*: Indefinite<br />
*Stamina Cost*: 8000, minus 125 per level to a minimum of 5000<br />
*Channeling Time*: 75 moves, minus 2.5 moves per level to a minimum of 30<br />
*Effects*: Attempt to take control of a robot within range, reprogramming it to serve as an ally. The psion may also channel this power to command the robots under their control. Success is dependent on Computer skill.<br />
*Prerequisites*: Spark Sight 12, Hacking Interface 8, Short Circuit 8<br />
</details>
<details>
<summary><h3>Galvanic Aura (C)</h3></summary>

*Difficulty*: 8<br />
*Target*: Self<br />
*Duration*: 60 seconds to 4 minutes 10 seconds, plus 15 seconds to 25 seconds per power level<br />
*Stamina Cost*: 9000, minus 200 per level to a minimum of 4500<br />
*Channeling Time*: 150 moves, minus 8.5 moves per level to a minimum of 55<br />
*Effects*: Supercharges the air around the psion, releasing blasts of 12 fields of intensity 10 lightning every few seconds, as well as blasting a nearby non-NPC target repeatedly with lightning. It makes the psion immune to electrical damage and makes them and their gear immune to EMP blasts.<br />
*Prerequisites*: Electrical Discharge 12, Electron Overflow 15 *or* Re-energize 6<br />
</details>
<details>
<summary><h3>Ion Blast</h3></summary>

*Difficulty*: 9<br />
*Target*: Line stretching 2 squares plus 0.7 squares per power level, causing an explosion with an AoE of 1 plus 1 per 4 power levels<br />
*Duration*: Instant<br />
*Stamina Cost*: 8500, minus 100 per level to a minimum of 4000<br />
*Channeling Time*: 150 moves, minus 6 moves per level to a minimum of 65<br />
*Effects*: Unleashes a lightning bolt that explodes at the target point. The explosion does 25 to 90 electrical damage plus 2 to 4.5 per power level. The bolt does 5 to 25 plus 0.5 to 2.5 per power level. Both the bolt and the explosion release lightning fields of intensity 3 to 7.<br />
*Prerequisites*: Electrocutioner 10 *or* Short Circuit 6, Voltaic Strikes 8 *or* Static Touch 12<br />
</details>
<details>
<summary><h3>Revivification</h3></summary>

*Difficulty*: 10<br />
*Target*: One corpse within 2 squares plus 1 square per 4 power levels<br />
*Duration*: Random but no longer than 12 minutes. The target has an escalating chance to collapse every turn of the effect, beginning at 0.0005% per second in the first minute, climbing to 0.01% per second at minute 4, 1% per second at minute 8, and reaching certainty at minute 12<br />
*Stamina Cost*: 10000, minus 150 per level to a minimum of 6000<br />
*Channeling Time*: 250 moves, minus 6 moves per level to a minimum of 125<br />
*Effects*: Revives a single target with the REVIVES flag, charms it, and heals it for 50% to 80% of its hit points. The revived monster will be allied to you for the power's duration. You may repeatedly use Revivification on the same target as long as it's not pulped.<br />
*Prerequisites*: Neuro-acceleration 8, Analgesic Block 6 *or* Pain Suppression 13<br />
</details>
</details>
<details>
<summary><h1>Photokinesis</h1></summary>

**Passive Power: Photon Regulation**: The photokinetic regulates the amount of light their eyes receive. They can sleep in any light level, are immune to flashbangs, and are not impacted by sun glare.

Powers causing photokinetic damage have a 40% chance to blind the target for 3 seconds and a 5% chance to blind the target for 10 seconds. Each of these is checked independently.
<details>
<summary><h3>Candle's Glow (C)</h3></summary>

*Difficulty*: 1<br />
*Target*: Self<br />
*Duration*: 26 minutes to 57 minutes, plus 4 minutes and 20 seconds to 14 minutes and 30 seconds per power level<br />
*Stamina Cost*: 1500, minus 80 per level to a minimum of 450<br />
*Channeling Time*: 125 moves, minus 7.5 moves per level to a minimum of 50<br />
*Effects*: Generate a small amount of photons near the psion, producing just enough light to read or work by. The light requires more intense concentration and cannot be sustained in combat.<br />
*Prerequisites*: Starting power<br />
</details>
<details>
<summary><h3>Field of Light</h3></summary>

*Difficulty*: 2<br />
*Target*: An area of 1 square plus 0.8 squares per power level to a maximum of 50 squares, out to a distance of 5 squares plus 1.2 squares per power level to a maximum of 80 squares<br />
*Duration*: Halflife of 5 minutes at levels 0-7, 15 minutes at levels 8-15, and 30 minutes at level 16+<br />
*Stamina Cost*: 2500, minus 115 per level to a minimum of 1000<br />
*Channeling Time*: 150 moves, minus 6.5 moves per level to a minimum of 75<br />
*Effects*: Creates a large glow over an area, filling the entire area with light.<br />
*Prerequisites*: Starting power<br />
</details>
<details>
<summary><h3>Illuminate</h3></summary>

*Difficulty*: 2<br />
*Target*: A single target within 3 squares plus 1.1 squares per power level<br />
*Duration*: 1 minute and 6 seconds to 3 minutes and 4 seconds, plus 18 seconds to 1 minute and 11 seconds per power level<br />
*Stamina Cost*: 2750, minus 95 per level to a minimum of 750<br />
*Channeling Time*: 100 moves, minus 5 moves per level to a minimum of 35<br />
*Effects*: Excite the air around a single target, causing them to be surrounded by a glow.  This illumintews the area around them and reduces their chance to dodge slightly.<br />
*Prerequisites*: None<br />
</details>
<details>
<summary><h3>Blackout</h3></summary>

*Difficulty*: 2<br />
*Target*: An area of 1 square plus 0.8 squares per power level to a maximum of 50 squares, out to a distance of 5 squares plus 1.2 squares per power level to a maximum of 80 squares<br />
*Duration*: Halflife of 5 minutes<br />
*Stamina Cost*: 2500, minus 95 per level to a minimum of 750<br />
*Channeling Time*: 150 moves, minus 6.5 moves per level to a minimum of 75<br />
*Effects*: Snuffs out all light in the targeted area. Visibility is reduced to zero.<br />
*Prerequisites*: Candle's Glow 5 *or* Field of Light 4<br />
</details>
<details>
<summary><h3>Trick of the Light (C)</h3></summary>

*Difficulty*: 2<br />
*Target*: Self<br />
*Duration*: 28 seconds to 2 minutes and 5 seconds, plus 13 to 27 seconds per power level, or until hit in combat<br />
*Stamina Cost*: 2250, minus 135 per level to a minimum of 500<br />
*Channeling Time*: 200 moves, minus 9.5 moves per level to a minimum of 65<br />
*Effects*: Wreathe the psion on blurred illusions, confusing their form and making it unclear where exactly they are standing. Adds +6 to dodge, applies the UNCANNY_DODGE and HARDTOHIT flags, and provides a flat 15% + 2% per power level chance to evade the attack on top of normal dodge chance, to a maximum of 85% chance to evade. However, the power instantly ends if the psion is hit.<br />
*Prerequisites*: Field of Light 5, Blackout 5<br />
</details>
<details>
<summary><h3>Photon Beam</h3></summary>

*Difficulty*: 3<br />
*Target*: A line up to 2 squares long plus 0.6 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 2750, minus 125 per level to a minimum of 800<br />
*Channeling Time*: 110 moves, minus 6 moves per level to a minimum of 35<br />
*Effects*: Concentrate light into a searing beam, doing 3 to 15 damage plus 1.5 to 3.5 photokinetic damage to all enemies in the line of the power.<br />
*Prerequisites*: Candle's Glow 8 *or* Field of Light 6<br />
</details>
<details>
<summary><h3>Chameleoflage (C)</h3></summary>

*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: 11 minutes and 30 seconds to 23 minutes and 50 seconds, plus 48 seconds to 1 minute and 53 seconds per power level<br />
*Stamina Cost*: 3500, minus 75 per level to a minimum of 1500<br />
*Channeling Time*: 150 moves, minus 8 moves per level to a minimum of 75<br />
*Effects*: Warp light around the psion, making them blend into the nearby background.  This reduces the range at which monsters or hostile NPCs can see them by 10% plus 3% per power level to a maximum of 60%.<br />
*Prerequisites*: Trick of the Light 6<br />
</details>
<details>
<summary><h3>Lucent Barrier (C)</h3></summary>

*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: 6 minutes and 10 seconds to 13 minutes and 30 seconds, plus 18 seconds to 2 minutes and 22 seconds per power level<br />
*Stamina Cost*: 3000, minus 125 per level to a minimum of 800<br />
*Channeling Time*: 250 moves, minus 4.5 moves per level to a minimum of 100<br />
*Effects*: Control the light and electromagnetic radiation near the psion, effectively forming a shield. This renders the psion immune to photokinetic attack as well as laser weapons and radiation. The barrier glows softly when in effect.<br />
*Prerequisites*: Trick of the Light 9 *or* Blackout 6 *and* Chameleoflage 5<br />
</details>
<details>
<summary><h3>Refracted Arms</h3></summary>

*Difficulty*: 4<br />
*Target*: Self<br />
*Duration*: 26 seconds to 1 minutea nd 11 seconds, plus 8 seconds to 41 seconds per power level<br />
*Stamina Cost*: 4000, minus 125 per level to a minimum of 1500<br />
*Channeling Time*: 125 moves, minus 7 moves per level to a minimum of 25<br />
*Effects*: Create the illusion of multiple other arms, following and preceding the psion's movements, making it very difficult to determine where they will strike. Adds a +4 bonus to hit in melee combat.<br />
*Prerequisites*: Trick of the Light 8, Chameleoflage 6, Candle's Glow 6<br />
</details>
<details>
<summary><h3>Mirror-Mask (C)</h3></summary>

*Difficulty*: 4<br />
*Target*: Self<br />
*Duration*: 7 minutes and 30 seconds to 14 minutes and 50 seconds, plus 22.5 seconds to 55 seconds per power level<br />
*Stamina Cost*: 6500, minus 150 per level to a minimum of 2000<br />
*Channeling Time*: 1500 moves, minus 75 moves per level to a minimum of 150<br />
*Effects*: Wrap the psion in illusions, concealing any mutations or visible bionics they may have. NPCs will react to them better, and certain people who might refuse to talk to a mutant will be happy to talk to them.  Their total Ugliness is reduced by 60% plus 1.5% per level, to a maximum of 100% Ugliness reduction.<br />
*Prerequisites*: Chameleoflage 8, Lucent Barrier 5<br />
</details>
<details>
<summary><h3>Flashbang</h3></summary>

*Difficulty*: 4<br />
*Target*: An area of effect with radius 2 squares, plus 1 square per 2 power levels to a maximum of 30 squares, at a range of 3 squares plus 0.7 squares per power level to a maximum of 50 squares<br />
*Duration*: Instant<br />
*Stamina Cost*: 4500, minus 120 per level to a minimum of 1750<br />
*Channeling Time*: 135 moves, minus 5.5 moves per level to a minimum of 50<br />
*Effects*: Wrap the psion in illusions, concealing any mutations or visible bionics they may have. NPCs will react to them better, and certain people who might refuse to talk to a mutant will be happy to talk to them.  Their total Ugliness is reduced by 60% plus 1.5% per level, to a maximum of 100% Ugliness reduction.<br />
*Prerequisites*: Field of Light 9 *or* Photon Beam 5, Illuminate 6<br />
</details>
<details>
<summary><h3>Lucid Shadows</h3></summary>

*Difficulty*: 5<br />
*Target*: A square up to squares aware plus 0.8 squares per power level to a maximum of 40 squares<br />
*Duration*: 48 seconds to 2 minutes and 16.5 seconds, plus 5.5 to 13.5 seconds per power level<br />
*Stamina Cost*: 4000, minus 145 per level to a minimum of 1750<br />
*Channeling Time*: 150 moves, minus 4 moves per level to a minimum of 90<br />
*Effects*: Create identical copies of the psion, anywhere from 1 to one-third of the power level copies. The copies will run around and confuse the psion's enemies while the power lasts.<br />
*Prerequisites*: Refracted Arms 6 *or* Chameleoflage 6, Photon Beam 6<br />
</details>
<details>
<summary><h3>Radio Transception (C)</h3></summary>

*Difficulty*: 5<br />
*Target*: Self<br />
*Duration*: 24 minutes and 12 seconds to 1 hour and 27 minutes, plus 2 minutes and 6 seconds to 12 minutes and 50 seconds per power level<br />
*Stamina Cost*: 5000, minus 100 per level to a minimum of 2250<br />
*Channeling Time*: 250 moves, minus 10 moves per level to a minimum of 75<br />
*Effects*: Open the psion up to radio waves, allowing them to scan any remaining radio broadcasts or broadcast to anyone with a functional radio.<br />
*Prerequisites*: Field of Light 8 *or* Photon Beam 7, Lucent Barrier 6<br />
</details>
<details>
<summary><h3>Sensor Interference</h3></summary>

*Difficulty*: 5<br />
*Target*: An area of effect with radius 1 square, plus 1 square per 4 power levels to a maximum of 20 squares, at a range of 3 squares plus 0.8 squares per power level to a maximum of 50 squares<br />
*Duration*: 2 to 3 seconds plus three-quarters of a second to a second and a half per power level.<br />
*Stamina Cost*: 6000, minus 150 per level to a minimum of 2200<br />
*Channeling Time*: 200 moves, minus 9.5 moves per level to a minimum of 80<br />
*Effects*: Unleash a burst of electromagnetic waves, overloading any electronic sensors within the target area.  Any robots caught in the blast will be unable to perceive their environment for the power's duration.<br />
*Prerequisites*: Star Flash 5 *or* Photon Beam 4, Radio Transception 6<br />
</details>
<details>
<summary><h3>Gamma Sterilization (C)</h3></summary>

*Difficulty*: 5<br />
*Target*: Self<br />
*Duration*: 10 seconds per item of food sterilized<br />
*Stamina Cost*: 7500, minus 200 per level to a minimum of 4000<br />
*Channeling Time*: 15 seconds<br />
*Effects*: Irradiate food, killing bacteria and helping to preserve it for far longer. The psion may irradiate as much food as they can carry, but it takes longer the greater amount of food they wish to irradiate (40g per second time). Every 10 to 15 seconds spent irradiating costs the psion 1 to 3 calories.<br />
*Prerequisites*: Lucent Barrier 7, Chameleoflage 4, Illuminate 9 *or* Photon Beam 5 *or* Star Flash 3<br />
</details>
<details>
<summary><h3>Veil of Light (C)</h3></summary>

*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: 16 seconds to 42 seconds, plus 6 seconds to 23 seconds per power level<br />
*Stamina Cost*: 3500, minus 125 per level to a minimum of 1200<br />
*Channeling Time*: 150 moves, minus 6.5 moves per level to a minimum of 35<br />
*Effects*: Warp light around the psion, making them completely invisible while still allowing them to perceive their surroundings. There is a chance when moving that the effect will break: 2% minus 0.1% per power level to a minmum of 0.4% per square when crawling or walking, and 8% minus 0.3% per power level to a minimum of 3% per square when running.  It will always break when engaging in melee combat.<br />
*Prerequisites*: Lucent Barrier 6 *or* Lucid Shadows 6, Mirror-Mask 6 *or* Chameleoflage 10<br />
</details>
<details>
<summary><h3>Star Flash</h3></summary>

*Difficulty*: 6<br />
*Target*: A line up to 2 squares long plus 0.6 squares per power level, and 1 additional square in breadth plus 0.3 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 5500, minus 125 per level to a minimum of 2750<br />
*Channeling Time*: 135 moves, minus 8.5 moves per level to a minimum of 40<br />
*Effects*: Unleash a high-powered laser blast, doing 20 to 54 photokinetic damage plus 2.5 to 6 photokinetic damage per level to everything within the targeted line.<br />
*Prerequisites*: Photon Beam 8, Lucent Barrier 6 *or* Refracted Arms 6<br />
</details>
<details>
<summary><h3>Blinding Radiance (C)</h3></summary>

*Difficulty*: 7<br />
*Target*: Self<br />
*Duration*: 59 seconds to 2 minutes and 58 seconds, plus 11 seconds to 47 seconds per power level<br />
*Stamina Cost*: 6500, minus 95 per level to a minimum of 3250<br />
*Channeling Time*: 125 moves, minus 7.5 moves per level to a minimum of 25<br />
*Effects*: Begin glowing brighter than a floodlight, illuminating the ground out to XXXX squares and gaining a +4 dodge bonus as enemies have a hard time targeting the psion.  When hit or when attacking enemies, there is a 33% chance the psion will unleash an even brighter flash that blinds everyone within 5 squares plus 1.2 squares per power level for between 5 and 20 seconds.<br />
*Prerequisites*: Field of Light 12 *or* Flashbang 7, Star Flash 6 *or* Lucent Barrier 10<br />
</details>
<details>
<summary><h3>Luminous Disintegration</h3></summary>

*Difficulty*: 8<br />
*Target*: One target within 2 squares long plus 0.8 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 8000, minus 150 per level to a minimum of 4000<br />
*Channeling Time*: 200 moves, minus 10 moves per level to a minimum of 50<br />
*Effects*: Focus electromagnetic radiation onto a single point, doing immense damage to the target there.  This power does 45 to 135 photokinetic damage plus 5.5 to 17 photokinetic damage per power level<br />
*Prerequisites*: Star Flash 8 *or* Photon Beam 14, Blinding Radiance 5<br />
</details>
<details>
<summary><h3>Phantom Legion (C)</h3></summary>

*Difficulty*: 9<br />
*Target*: Self<br />
*Duration*: 37 seconds to and 1 minute and 37 seconds, plus 5 seconds to 11 seconds per power level<br />
*Stamina Cost*: 10000, minus 255 per level to a minimum of 5500<br />
*Channeling Time*: 150 moves, minus 4 moves per level to a minimum of 90<br />
*Effects*: Summon a myriad of holographic clones: 2 to 5 plus 0.75 to 1.5 per power level within 8 squares of the psion, 66% of this amount again from 8 squares away to 25 squares away, and 50% of this amount again from 25 squares to 40 squares away.  The copies will run around and confuse the psion's enemies while the power lasts.  If damaged, they explode into a burst of light, blinding anyone with 5 squares of the clone.  When the power is ended or the psion loses concentration, all duplicates fade without exploding.<br />
*Prerequisites*: Lucid Shadows 10, Field of Light 14 *or* Refraction of Arms 10 *or* Blinding Radiance 6<br />
</details>
</details>
<details>
<summary><h1>Pyrokinesis</h1></summary>

**Passive Power: Internal Fire**: The pyrokinetic slightly heats the air around themselves, gaining a small amount of warmth at all times (and more in colder temperatures) and increasing their temperature when sleeping by 0.05 times the total levels in the psion's pyrokinetic powers, as well as ignoring the first 10 points of wetness on any part of their body.
<details>
<summary><h3>Brilliant Flash</h3></summary>

*Difficulty*: 1<br />
*Target*: An area of effect with radius 1 square, plus 1 square per 4 power levels to a maximum of 8 squares, at a range of 3 squares plus 1.2 squares per power level to a maximum of 50 squares<br />
*Duration*: 1 to 8 seconds, plus 0.5 to 1 seconds per power level<br />
*Stamina Cost*: 1750, minus 80 per level to a minimum of 550<br />
*Channeling Time*: 150 moves, minus 8 moves per level to a minimum of 50<br />
*Effects*: Excite air molecules and unleash a flash of light, blinding nearby targets for the power's duration.<br />
*Prerequisites*: Starting power<br />
</details>
<details>
<summary><h3>Fountain of Flames</h3></summary>

*Difficulty*: 2<br />
*Target*: One target within 1 square plus 1 square per 10 power levels, to a maximum of 5 squares<br />
*Duration*: Instant<br />
*Stamina Cost*: 1950, minus 75 per level to a minimum of 700<br />
*Channeling Time*: 100 moves, minus 4 moves per level to a minimum of 35<br />
*Effects*: The pyrokinetic unleashes a blast of flame at a close-range target, doing 6 to 26 heat damage plus 1.5 to 3 heat damage per power level. This power also has a 50% chance of leaving a fire field of intensity 1 to 2 in the target square.<br />
*Prerequisites*: Starting power<br />
</details>
<details>
<summary><h3>Cauterize</h3></summary>

*Difficulty*: 2<br />
*Target*: Self<br />
*Duration*: Instant<br />
*Stamina Cost*: 2200, minus 95 per level to a minimum of 750<br />
*Channeling Time*: 600 moves<br />
*Effects*: The psion attempts to seal one of their bleeding wounds shut.This automatically succeeds if the psion is a physician or has the Burn Care proficiency, otherwise it is a check of the Health Care skill + 1d10 vs 7. If the check is failed, the psion suffers 3 damage to the target location and 1-3 pain and the bleeding continues. If the check succeeds, the psion suffers 1 daamge to the target location and 1-2 pain, but the bleeding stops. Bleeding of Intensity 30 or more cannot be stopped through Cauterize. There is also a 6.67% chance, independently checked per attempt, for the wound to become infected within 24 hours.<br />
*Prerequisites*: Fountain of Flames 6 AND Quell Fire 6 *or* Incandescent Lance 5 <br />
</details>
<details>
<summary><h3>Banked Flames (C)</h3></summary>

*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: 8 minutes and 30 seconds to 30 minutes, plus 50 seconds to 20 minutes and 40 seconds per level<br />
*Stamina Cost*: 2500, minus 150 per level to a minimum of 800<br />
*Channeling Time*: 250 moves, minus 10 moves per level to a minimum of 75 moves<br />
*Effects*: Summon a controlled fire in the palm of the psion's hand. The fire sheds a small amount of light and can be used for anything fire can normally be used for; heating food, cooking, lightning other fires, and so on. The banked flame requires more intense concentration and cannot be sustained in combat.  In addition, it encumbers one of your hands and prevents you from using any weapon requiring two hands.<br />
*Prerequisites*: Fountain of Flames 4<br />
</details>
<details>
<summary><h3>Quell Fire</h3></summary>

*Difficulty*: 3<br />
*Target*: An area of effect with a radius of 1 square plus 1 square per 2 power levels to a maximum of 50 squares, at a range of 3 squares plus 0.8 squares per power level to a maximum of 70 squares<br />
*Duration*: Instant<br />
*Stamina Cost*: 3500, minus 120 per level to a minimum of 1000<br />
*Channeling Time*: 125 moves, minus 7.5 moves per level to a minimum of 50 moves<br />
*Effects*: As the psion can control fire, they can also extinguish it. Harmlessly disperses all flamees within the area of effect. The aftereffects of the fire (burned locations or people) are not reversed.<br />
*Prerequisites*: Banked Flames 5<br />
</details>
<details>
<summary><h3>Cloak of Warmth (C)</h3></summary>

*Difficulty*: 4<br />
*Target*: Self<br />
*Duration*: 3 minutes to 24 minutes, plus 29 seconds to 3 minutes and 12 seconds seconds per power level<br />
*Stamina Cost*: 4500, minus 160 per level to a minimum of 2000<br />
*Channeling Time*: 250 moves, minus 11 moves per level to a minimum of 75 moves<br />
*Effects*: Heat the air around the psion to a more comfortable temperature, providing 1 point of armor against heat and 3 points of armor against heat per power level, as well as heating the air 10 degrees toward comfortable per power level (or cooling it 3 degrees per power level, if necessary). The cloak also heats the air around the psion by 26 degrees.<br />
*Prerequisites*: Banked Flames 6 *or* Fountain of Flames 6<br />
</details>
<details>
<summary><h3>Flamethrower</h3></summary>

*Difficulty*: 5<br />
*Target*: A cone out to 3 squares plus 0.3 squares per power level to a maximum of 20 squares, with an arc length of 27 degrees plus 3 degrees per power level, to a maximum of 120 degrees<br />
*Duration*: Instant<br />
*Stamina Cost*: 4500, minus 150 per level to a minimum of 1600<br />
*Channeling Time*: 100 moves, minus 6 moves per level to a minimum of 35 moves<br />
*Effects*: Unleash a blast of flame, burning the psion's enemies for 15 to 40 heat damage, plus 1.5 to 2.5 damage per power level. There is a 20% chance that an affected square will be set on fire with a fire field of intensity 1 to 2.<br />
*Prerequisites*: Fountain of Flames 7, Brilliant Flash 5<br />
</details>
<details>
<summary><h3>Incandescent Lance (C)</h3></summary>

*Difficulty*: 5<br />
*Target*: Self<br />
*Duration*: 3 minutes 25 seconds to 41 minutes, plus 1 minute and 54 seconds to 8 minutes and 12 seconds per power level<br />
*Stamina Cost*: 5000, minus 125 per level to a minimum of 2000<br />
*Channeling Time*: 650 moves, minus 12 moves per level to a minimum of 320 moves<br />
*Effects*: Create a thin line of extremely hot fire, useful for welding or breaching metal doors. The lance requires more intense concentration and cannot be sustained in combat.<br />
*Prerequisites*: Banked Flames 6 *or* Fountain of Flames 9 AND Quell Fire 6<br />
</details>
<details>
<summary><h3>Thermogenesis</h3></summary>

*Difficulty*: 5<br />
*Target*: A space within 3 squares<br />
*Duration*: 1 to 2 hours, plus 2 minutes 30 seconds to 5 minutes per level<br />
*Stamina Cost*: 8000, minus 200 per level to a minimum of 4000<br />
*Channeling Time*: 1500 moves, minus 10 moves per level to a minimum of 1200 moves<br />
*Effects*: Heat nearby air to produce warmth. The spot chosen will shed heat for the duration of the power. Four different intensities are selectable: 6 degrees, 16 degrees, 40 degrees, and 75 degrees.<br />
*Prerequisites*: Banked Flames 10 *or* Cloak of Warmth 6, Brilliant Flash 7<br />
</details>
<details>
<summary><h3>Blazing Aura (C)</h3></summary>

*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: 45 seconds to 3 minutes, plus 7 to 19 seconds per power level<br />
*Stamina Cost*: 6500, minus 175 per level to a minimum of 3500<br />
*Channeling Time*: 125 moves, minus 6.5 moves per level to a minimum of 50 moves<br />
*Effects*: Kindle the air around the psion, doing 5 to 20 heat damage to anyone attacking them in melee and causing 5 to 15 heat damage to anyone the psion attacks. The cloak also sheds light and heats the nearby air by 45 degrees.<br />
*Prerequisites*: Cloak of Warmth 8, Thermogenesis 5 *or* Flamethrower 6, Fountain of Flames 7<br />
</details>
<details>
<summary><h3>Flameshield (C)</h3></summary>

*Difficulty*: 7<br />
*Target*: Self<br />
*Duration*: 90 seconds to 9 minutes and 30 seconds, plus 11 to 47 seconds per power level<br />
*Stamina Cost*: 7750, minus 165 per level to a minimum of 4000<br />
*Channeling Time*: 150 moves, minus 6.5 moves per level to a minimum of 75 moves<br />
*Effects*: The psion becomes totally immune to heat and flame for the power's duration.  They could walk through a burning house or into a blast furnace without injury.<br />
*Prerequisites*: Cloak of Warmth 10 *or* Blazing Aura 6, Quell Fire 9, <br />
</details>
<details>
<summary><h3>Conflagration</h3></summary>

*Difficulty*: 7<br />
*Target*: A radius of 2 squares plus 0.4 squares per power level to a maximum of 25 squares, to a range of 4 squares plus 0.9 squares per power level to a maximum range of 70 squares<br />
*Duration*: Instant<br />
*Stamina Cost*: 7500, minus 125 per level to a minimum of 3500<br />
*Channeling Time*: 150 moves, minus 7 moves per level to a minimum of 35 moves<br />
*Effects*: The psion unleashes an explosion of flames in the target area, doing 37 to 115 heat damage to all targets in the power's area of effect, plus 2.5 to 5 heat damage per power level, with a 25% chance to set each affected square on fire with a fire field of intensity 1 to 2.<br />
*Prerequisites*: Flamethrower 8 *or* Fountain of Flames 13, Thermogenesis 6 *or* Blazing Aura 6<br />
</details>
<details>
<summary><h3>Hellfire</h3></summary>

*Difficulty*: 9<br />
*Target*: A radius of 4 squares plus 0.9 squares per power level around the psion to a maximum of 35 squares<br />
*Duration*: Instant<br />
*Stamina Cost*: 9000, minus 220 per level to a minimum of 6000<br />
*Channeling Time*: 175 moves, minus 8 moves per level to a minimum of 55 moves<br />
*Effects*: Flames roar outward from the psion's position, engulfing the entire nearby area in flames. Does 65 to 169 heat damage to all targets in the power's area of effect, plus 5 to 8 heat damage per power level, with a 50% chance to set each affected square on fire with a fire field of intensity 1 to 3.<br />
*Prerequisites*: Flamethrower 12 *or* Conflagration 6, Thermogenesis 10 *or* Flameshield 6<br />
</details>
<details>
<summary><h3>Crucible</h3></summary>

*Difficulty*: 10<br />
*Target*: One target within 2 squares plus 1 square per 2 power levels, to a maximum of 20 squares<br />
*Duration*: Instant<br />
*Stamina Cost*: 12000, minus 150 per level to a minimum of 8000<br />
*Channeling Time*: 200 moves, minus 4 moves per level to a minimum of 75<br />
*Effects*: The pyrokinetic concentrates all of their power onto a single point, heating it white-hot and incinerating whatever they are focusing on. Does 150 to 400 heat damage plus 10 to 25 heat damage per power level and has a 100% chance to leave a fire field of intensity 3 at the target location.<br />
*Prerequisites*: Conflagration 10, Hellfire 6, Flamethrower 10 *or* Fountain of Flames 14<br />
</details>
</details>
<details>
<summary><h1>Telekinesis</h1></summary>

**Passive Power: Grasping Hand**: The telekinetic may bring items quickly to hand, reducing the time necessary to pull items from pockets or containers by 10%, plus 0.075% times the telekinetic's total levels in telekinesis powers.

Powers causing telekinetic damage have a 40% chance to stagger the target for 2 seconds and a 20% chance to down the target. Each of these is checked independently.
<details>
<summary><h3>Far Hand</h3></summary>

*Difficulty*: 1<br />
*Target*: The items in a space up to 3 squares away plus 0.9 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 1250, minus 80 per level to a minimum of 500<br />
*Channeling Time*: 50 moves, minus 4 moves per level to a minimum of 10<br />
*Effects*: The psion reaches out and pulls a set of items toward or away from them, moving it 1 to 4 squares plus 0.4 to 0.9 squares per power level.<br />
*Prerequisites*: Starting power<br />
</details>
<details>
<summary><h3>Force Shove</h3></summary>

*Difficulty*: 1<br />
*Target*: One enemy, ally, or the items in a space up to 2 squares away plus 0.9 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 1750, minus 80 per level to a minimum of 750<br />
*Channeling Time*: 50 moves, minus 4 moves per level to a minimum of 10<br />
*Effects*: The psion attempts to shove a single target either to them or in a chosen direction. The distance is based on the ratio of the target's weight to the psion's power level (modified by Intelligence and Nether Attunement as usual).  By default, the formula is (power level * 25 kg) * Intelligence modifier * Nether Attunement modifier, divided by the target's weight in kg. If this is 1 or higher, the target is hurled 1 square for every 0.5 above 1 the ratio is. If it is below one, there is still a chance to knock the target over (chance is weight ratio * 100 in percentage; a weight ratio of 0.678 has a 67.8% chance of causing knockdown).<br />
*Prerequisites*: Starting power<br />
</details>
<details>
<summary><h3>Noisemaker</h3></summary>

*Difficulty*: 2<br />
*Target*: One target within to 2 squares away plus 0.9 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 1750, minus 85 per level to a minimum of 450<br />
*Channeling Time*: 64 moves, minus 4 moves per level to a minimum of 15<br />
*Effects*: Thump the ground with telekinetic force, causing 3 to 8 noise plus 0.5 to 1.5 noise per power level.<br />
*Prerequisites*: None<br />
</details>
<details>
<summary><h3>Knockdown</h3></summary>

*Difficulty*: 2<br />
*Target*: One target within to 2 squares away plus 0.5 squares per power level<br />
*Duration*: From 100 to 400 moves, plus 25 to 95 moves per power level<br />
*Stamina Cost*: 3000, minus 80 per level to a minimum of 1250<br />
*Channeling Time*: 75 moves, minus 4 moves per level to a minimum of 30<br />
*Effects*: Slam a single target to the ground, doing 5 to 15 telekinetic damage plus 0.5 plus 1.2 damage per power level, and downing the target for the power's duration.<br />
*Prerequisites*: Force Shove 4<br />
</details>
<details>
<summary><h3>Momentum Alteration (C)</h3></summary>

*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: Instant<br />
*Stamina Cost*: 3500, minus 125 per level to a minimum of 1750<br />
*Channeling Time*: 300 moves, minus 7.5 moves per level to a minimum of 125<br />
*Effects*: Manipulate local momentum to the psion's advantage, speeding their own movements and slowing incoming dangerous objects. Reduces move cost by 0.5% per power level to a maximum of 15%, increases attack speed by 1% per power level, reduces incoming cutting and piercing damage by 0.5% per power level, reduces incoming bashing damage by 1% per power level, and reduces incoming ballistic damage by 2% per power level.<br />
*Prerequisites*: Far Hand 5, Force Shove 5<br />
</details>
<details>
<summary><h3>Slowfall</h3></summary>

*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: From 3 to 15 seconds, plus 1 to 4 seconds per power level<br />
*Stamina Cost*: 2250, minus 85 per level to a minimum of 650<br />
*Channeling Time*: 85 moves, minus 4.5 moves per level to a minimum of 25<br />
*Effects*: Reduce the psion's falling speed, taking 50% less falling damage, plus 4% per level to a maximum of 95% lower falling damage.  Also makes swimming 3 times easier due to increased buoyancy.<br />
*Prerequisites*: Momentum Alteration 6<br />
</details>
<details>
<summary><h3>Wave of Force</h3></summary>

*Difficulty*: 4<br />
*Target*: All targets within range 1<br />
*Duration*: Instant<br />
*Stamina Cost*: 4500, minus 125 per level to a minimum of 2250<br />
*Channeling Time*: 50 moves, minus 4 moves per level to a minimum of 20<br />
*Effects*: Unleash an indiscriminate wave of force, knocking back everything nearby. Like Force Shove, the distance is based on the weight ratio: (power level * 55 kg) * Intelligence modifier * Nether Attunement modifier, divided by the target's weight in kg.  This power affects allies as well as enemies.<br />
*Prerequisites*: Force Shove 7, Knockdown 4 <br />
</details>
<details>
<summary><h3>Water Walking (C)</h3></summary>

*Difficulty*: 4<br />
*Target*: Self<br />
*Duration*: Instant<br />
*Stamina Cost*: 5000, minus 100 per level to a minimum of 2000<br />
*Channeling Time*: 150 moves, minus 6.5 moves per level to a minimum of 50<br />
*Effects*: Lift yourself up just enough to allow surface tension to support your weight, allowing you to walk on water.  You can also walk across sludge without being slowed by it.<br />
*Prerequisites*: Slowfall 6, Momentum Alteration 6<br />
</details>
<details>
<summary><h3>Lifting Field (C)</h3></summary>

*Difficulty*: 4<br />
*Target*: Self<br />
*Duration*: From 8 minutes and 14 seconds to 27 minutes and 54 seconds, plus 1 minute and 33 seconds to 4 minutes and 19 seconds per power level<br />
*Stamina Cost*: 4500, minus 100 per level to a minimum of 2000<br />
*Channeling Time*: 200 moves, minus 6.5 moves per level to a minimum of 55<br />
*Effects*: Create a field to float a single object next to the psion, keeping it close at hand and preventing its weight or encumbrance from affecting them. The weight limit increases at each level of the power; there is no volume or length limit.<br />
*Prerequisites*: Lift Vehicle 3 *or* Far Hand 7 AND Momentum Alteration 5<br />
</details>
<details>
<summary><h3>Enhance Strength (C)</h3></summary>

*Difficulty*: 5<br />
*Target*: Self<br />
*Duration*: From 30 seconds to 2 minutes, plus 15 to 30 seconds per power level<br />
*Stamina Cost*: 5000, minus 150 per level to a minimum of 2000<br />
*Channeling Time*: 300 moves<br />
*Effects*: Use telekinesis to enhance the psion's strength by 15 plus 3 per power level. This enhanced strength requires more intense concentration and cannot be sustained in combat.<br />
*Prerequisites*: Force Shove 6 *or* Far Hand 6, Momentum Alteration 5<br />
</details>
<details>
<summary><h3>Mindhammer</h3></summary>

*Difficulty*: 5<br />
*Target*: One target within 3 squares plus 0.9 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 3750, minus 135 per level to a minimum of 1750<br />
*Channeling Time*: 50 moves, minus 2.5 moves per level to a minimum of 25<br />
*Effects*: Smashes a single target with a fist of telekinetic force, doing 18 to 55 telekinetic damage plus 1.25 to 3.5 damage per power level. Also smashes the terrain at the target tile for 25 to 55 bash damage plus 1.5 to 3 damage per power level.<br />
*Prerequisites*: Knockdown 6, Wave of Force 4 *or* Force Shove 8<br />
</details>
<details>
<summary><h3>Lift Vehicle (C)</h3></summary>

*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: From 10 minutes to 25 minutes, plus 3 minutes and 10 seconds to 7 minutes per power level<br />
*Stamina Cost*: 6500, minus 200 per level to a minimum of 3250<br />
*Channeling Time*: 250 moves, minus 8 moves per level to a minimum of 125<br />
*Effects*: Create a field to lift up a vehicle just enough to work on the wheels or undercarriage. This field requires more intense concentration and cannot be sustained in combat.<br />
*Prerequisites*: Enhance Strength 10 *or* Far Hand 8 AND Slowfall 8 *or* Lifting Field 12<br />
</details>
<details>
<summary><h3>Inertial Barrier (C)</h3></summary>

*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: From 4 minutes and 40 seconds to 12 minutes, plus 14 to 37 seconds per power level<br />
*Stamina Cost*: 8000, minus 185 per level to a minimum of 3250<br />
*Channeling Time*: 250 moves, minus 8 moves per level to a minimum of 65<br />
*Effects*: Summon a telekinetic barrier around the psion, blunting incoming damage. Reduces bashing damage by 2 plus 0.5 per power level, cutting damage by 3 plus 1 per power level, piercing damage by 5 plus 1.5 per power level, and ballistic damage by 12 plus 2.5 per power level.<br />
*Prerequisites*: Wave of Force 8, Momentum Alteration 10<br />
</details>
<details>
<summary><h3>Wrecking Ball</h3></summary>

*Difficulty*: 7<br />
*Target*: An area of effect of 2 squares plus 0.3 squares per power level, to a maximum AoE of 30, within 4 squares plus 0.9 squares per power level, to a maximum range of 60<br />
*Duration*: Instant<br />
*Stamina Cost*: 8500, minus 200 per level to a minimum of 4500<br />
*Channeling Time*: 200 moves, minus 7.5 moves per level to a minimum of 75<br />
*Effects*: Thrashes an area with an explosion of telekinetic force, doing 22 to 99 telekinetic damage plus 3 to 7.5 to everything within the power's area of effect. It also smashes terrain for the same amount of damage.<br />
*Prerequisites*: Knockdown 12 *or* Mindhammer 7, Force Shove 10 *or* Far Hand 10<br />
</details>
<details>
<summary><h3>Levitation (C)</h3></summary>

*Difficulty*: 7<br />
*Target*: Self<br />
*Duration*: 1 to 5 seconds, plus 0.75 to 2 seconds per power level<br />
*Stamina Cost*: 7500, minus 165 per level to a minimum of 3500<br />
*Channeling Time*: 75 moves, minus 5.5 moves per level to a minimum of 15<br />
*Effects*: The psion can lift themselves with telekinesis and fly, traveling in the air in any direction they wish. This power requires more intense concentration and cannot be sustained in combat.<br />
*Prerequisites*: Slowfall 9, Force Shove 12 *or* Water Walking 8<br />
</details>
<details>
<summary><h3>Megakinesis</h3></summary>

*Difficulty*: 8<br />
*Target*: One target in a space up to 2 squares away plus 0.9 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 9500, minus 175 per level to a minimum of 5000<br />
*Channeling Time*: 80 moves, minus 5 moves per level to a minimum of 25<br />/>
*Effects*: Like Force Shove, but on a much greater scale, the psion hurls a single target either to them or in a chosen direction. The distance is based on the ratio of the target's weight to the psion's power level (modified by Intelligence and Nether Attunement as usual).  By default, the formula is (power level * 150 kg) * Intelligence modifier * Nether Attunement modifier, plus 100 kg, divided by the target's weight in kg. If this is 1 or higher, the target is hurled 1 square for every 0.5 above 1 the ratio is. If it is below one, there is still a chance to knock the target over (chance is weight ratio * 1000 in percentage; a weight ratio of 0.952 has a 95.2% chance of causing knockdown).<br />
*Prerequisites*: Force Shove 15 *or* Far Hand 15, Momentum Alteration 10, Lift Vehicle 6<br />
</details>
<details>
<summary><h3>Aegis</h3></summary>

*Difficulty*: 9<br />
*Target*: Self<br />
*Duration*: 1 second to 2 seconds, plus 1 second maximum possible duration per 5 power levels (minimum does not change)<br />
*Stamina Cost*: 9500, minus 225 per level to a minimum of 5500<br />
*Channeling Time*: 125 moves, minus 5 moves per level to a minimum of 55<br />
*Effects*: Put up a nearly-impenetrable barrier of telekinetic force capable of withstanding the blast wave of a nuclear detonation (though not the heat or the radiation). Reduces all bashing, cutting, piercing, and ballistic damage by 100,000. The psion is unable to move while Aegis is in effect.<br />
*Prerequisites*: Inertial Barrier 7, Wave of Force 8 *or* Slowfall 9, Momentum Alteration 12 *or* Enhance Strength 8<br />
</details>
<details>
<summary><h3>Earthshaker</h3></summary>

*Difficulty*: 10<br />
*Target*: A radius around the psion of 5 squares plus 0.8 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 11500, minus 200 per level to a minimum of 7000<br />
*Channeling Time*: 150 moves, minus 6 moves per level to a minimum of 45<br />
*Effects*: Grab the ground and *wrench* it with telekinesis, knocking everyone nearby off their feet and doing 30 to 80 plus 2.5 to 7 bash damage to the entirety of the terrain in the area of effect. Terrain in the area also has a 10% chance of cracking, becoming rubble or a pit.<br />
*Prerequisites*: Wrecking Ball 8 *or* Wave of Force 13, Mindhammer 10 *or* Megakinesis 5 <br />
</details>
</details>
<details>
<summary><h1>Telepathy</h1></summary>

**Passive Power: Telepathic Suggestion**: Influence the attitude of those the psion is speaking to, increasing Persuade, Lie, and Intimidate chances by 5% plus 0.075% times the psion's total levels in telepathic powers.

Powers causing telepathic damage have a 5% chance to down the target, a 33% chance to stun the target for 1 second, and a 66% chance to daze the target for 1 second. Each of these is checked independently.
<details>
<summary><h3>Concentration Trance (C)</h3></summary>

*Difficulty*: 1<br />
*Target*: Self<br />
*Duration*: 9 minutes and 20 seconds to 17 minutes and 13 seconds, plus 2 minutes and 12 seconds to 10 minutes and 5 seconds per power level<br />
*Stamina Cost*: 4000, minus 175 per level to a minimum of 1500<br />
*Channeling Time*: 300 moves, minus 12 moves per level to a minimum of 150<br />
*Effects*: The psion enters a trance that facilitates learning, adding learning focus equal to 2.5 * the power level. The trance takes up most of the psion's concentration, however, increasing movement cost by 3x and reducing vision range the same as the nearsighted trait. The trance requires more intense concentration and cannot be sustained in combat.<br />
*Prerequisites*: Starting power<br />
</details>
<details>
<summary><h3>Sense Minds (C)</h3></summary>

*Difficulty*: 2<br />
*Target*: Self<br />
*Duration*: 1 minute 30 seconds to 10 minutes, plus 26 seconds to 2 minutes and 11 seconds per power level<br />
*Stamina Cost*: 3500, minus 115 per level to a minimum of 1500<br />
*Channeling Time*: 500 moves<br />
*Effects*: Sense all sapient living beings within 2 squares per power level around the psion.  This includes all humans, sapient aliens such as mi-go or triffids (but not the triffids' vegetal defense biotechnology), most mutants who are not too far gone, Nether beings, and cyborgs, and excludes animals and robots.<br />
*Prerequisites*: Starting power<br />
</details>
<details>
<summary><h3>Telepathic Shield (C)</h3></summary>

*Difficulty*: 2<br />
*Target*: Self<br />
*Duration*: 3 minutes to 12 minutes, plus 15 to 36 seconds per power level<br />
*Stamina Cost*: 2500, minus 125 per level to a minimum of 500<br />
*Channeling Time*: 100 moves, minus 6.5 moves per level to a minimum of 10<br />
*Effects*: Place a shield over the psion's mind, preventing telepathic assault and also rendering the psion immune to the attacks of flaming eyes and the personal effects of portal storms. The psion is immune to telepathic damage and most telepathy-related effects while this power is active.<br />
*Prerequisites*: Concentration Trance 5<br />
</details>
<details>
<summary><h3>Mesmerize (C)</h3></summary>

*Difficulty*: 3<br />
*Target*: One target within 3 squares plus 1.1 squares per power level<br />
*Duration*: 8 minutes to 20 seconds, plus 2 to 5 seconds per power level<br />
*Stamina Cost*: 3500, minus 75 per level to a minimum of 750<br />
*Channeling Time*: 100 moves, minus 5 moves per level to a minimum of 35<br />
*Effects*: Send your target into a trance, making them stand in place or wander aimlessly for the power's duration. The chance to be mesmerized depends on the target: animals and similar beings are always mesmerized, against feral humans there is a 90% chance of success, against sapient humans the chance depends on their intelligence and perception, and against alien beings there is a 50% chance of success. If the target takes any damage, it will snap them out of the mesmerize effect.<br />
*Prerequisites*: Sense Minds 6<br />
</details>
<details>
<summary><h3>Mood Stabilization (C)</h3></summary>

*Difficulty*: 3<br />
*Target*: Self or one within 3 squares plus 1.1 squares per power level<br />
*Duration*: 16 minutes and 21 seconds to 42 minutes, plus 6 minutes and 21 seconds to 14 minutes and 59 seconds per power level when used on self, indefinite when used on others<br />
*Stamina Cost*: 5000, minus 125 per level to a minimum of 2000<br />
*Channeling Time*: 300 moves, minus 9.5 moves per level to a minimum of 150<br />
*Effects*: When used on oneself, edit the psion's mind, removing negative thoughts and improving mood. Adds a morale bonus of +10 (building up to a maximum of 25). When used on others, increases a target NPC's trust by 0.25 per power level and reduces both fear and anger by 0.5 per power level (usable a maximum of once per 12 hours) or reduces a target monster's aggression by power level times 5 (usable once per 5 minutes). It may also be used in dialogue to calm down angry NPCs.<br />
*Prerequisites*: Concentration Trance 6, Sense Minds 5<br />
</details>
<details>
<summary><h3>Synaptic Blast</h3></summary>

*Difficulty*: 4<br />
*Target*: One target within 3 squares plus 1.1 square per power level. Does not affect creatures without a living mind (no robots, no portal storm entities, etc.)<br />
*Duration*: Instant<br />
*Stamina Cost*: 3500, minus 125 per level to a minimum of 900<br />
*Channeling Time*: 75 moves, minus 2.5 moves per level to a minimum of 25<br />
*Effects*: Assault the target's mind, causing damage equal to a percentage of their current health, beginning at 5% and adding 1.5% to 3% per power level.  As such, Synaptic Blast is almost never capable of killing the target.<br />
*Prerequisites*: Sense Minds 7, Mood Stabilization 4<br />
</details>
<details>
<summary><h3>Beastmaster</h3></summary>

*Difficulty*: 4<br />
*Target*: One mammal, bird, reptile, amphibian, or fish within target within 3 squares plus 1 square per power level<br />
*Duration*: 3 minutes to 7 minutes and 50 seconds, plus 11.25 seconds to 28 seconds per power level<br />
*Stamina Cost*: 4500, minus 155 per level to a minimum of 2000<br />
*Channeling Time*: 120 moves, minus 3.5 moves per level to a minimum of 75<br />
*Effects*: Take over the mind of an animal, making it friendly to you.  While still an animal and subject to its instincts, it will not be hostile to you or run while the power is active, and may fight to defend you, again subject to its instincts (a wolf is a much better battle companion than a lemming).<br />
*Prerequisites*: Mood Stabilization 8<br />
</details>
<details>
<summary><h3>Sensory Deprivation</h3></summary>

*Difficulty*: 5<br />
*Target*: One target within 3 squares plus 1.1 square per power level. Does not affect creatures without a living mind (no robots, no portal storm entities, etc.)<br />
*Duration*: 2 to 8 seconds, plus 0.5 to 1.5 seconds per power level<br />
*Stamina Cost*: 3750, minus 150 per level to a minimum of 1500<br />
*Channeling Time*: 75 moves, minus 2.5 moves per level to a minimum of 25<br />
*Effects*: Assault the target's mind, disconnecting their senses. Blinds and stuns the target for the duration.<br />
*Prerequisites*: Synaptic Blast 6 *or* Mood Stabilization 6, Telepathic Shield 5<br />
</details>
<details>
<summary><h3>Primal Terror</h3></summary>

*Difficulty*: 5<br />
*Target*: One target within 3 squares plus 1.1 square per power level. Does not affect creatures without a living mind (no robots, no portal storm entities, etc.)<br />
*Duration*: Aftereffects last from 2 to 5 seconds, plus 0.75 to 1.75 seconds per power level<br />
*Stamina Cost*: 6000, minus 100 per level to a minimum of 3500<br />
*Channeling Time*: 125 moves, minus 5 moves per level to a minimum of 50<br />
*Effects*: Assault the target's mind, unleashing their most elemental fears. Freezes the target in place for a number of seconds depending on power level--the formula is from ((Power level / 4) * 6) / ((Power level / 4) + 3) to ((Power level / 4) * 10) / ((Power level / 4) + 3).  In addition, the target will suffer a lingering teror--for the aftereffect duration, the target suffers a -30 penalty to speed, a -2 penalty to dodge, a -2 penalty to hit, and a -8 penalty to bash damage. If an NPC, the target has their fear of the avatar increased by one-half the power level, and if a monster, the target has their morale reduced by 5 times the power level.<br />
*Prerequisites*: Synaptic Blast 8, Mood Stabilization 8<br />
</details>
<details>
<summary><h3>Obscurity</h3></summary>

*Difficulty*: 6<br />
*Target*: One target within 3 squares plus 1.1 square per power level. Does not affect creatures without a living mind (no robots, no portal storm entities, etc.)<br />
*Duration*: 2 minutes and 7 seconds to 8 minutes and 43 seconds, plus 13 to 52 seconds per power level<br />
*Stamina Cost*: 4500, minus 115 per level to a minimum of 2250<br />
*Channeling Time*: 100 moves, minus 6.5 moves per level to a minimum of 25<br />
*Effects*: The psion erases their presence from the target's mind. For the power's duration, the target will not be able to see the psion at all; they will react to any companions or allies the psion has as normal. Attacking the target will immediately cancel the power.<br />
*Prerequisites*: Sensory Deprivation 8, Mood Stabilization 6 *or* Synaptic Blast 11 *or* Telepathic Shield 8<br />
</details>
<details>
<summary><h3>Psychic Scream</h3></summary>

*Difficulty*: 7<br />
*Target*: Everything within a radius of 2 squares plus 1.1 squares per power level. Does not affect creatures without a living mind (no robots, no portal storm entities, etc.)<br />
*Duration*: Instant<br />
*Stamina Cost*: 7000, minus 275 per level to a minimum of 3250<br />
*Channeling Time*: 75 moves, minus 6.5 moves per level to a minimum of 30<br />
*Effects*: Unleash an undirected telepathic shriek, doing 3% of maximum health as damage plus 1% to 2% per power level, +1 flat damage. This second flat damage counts as an additional attack for the purposes of the side effects of telepathic damage.<br />
*Prerequisites*: Synaptic Blast 11 *or* Primal Fear 7, Telepathic Shield 5<br />
</details>
<details>
<summary><h3>Beast Tamer</h3></summary>

*Difficulty*: 7<br />
*Target*: One friendly mammal, bird, reptile, amphibian, or fish within target within 3 squares plus 1 square per power level<br />
*Duration*: 28 days to 56 days, plus 1 day to 3 days per power level<br />
*Stamina Cost*: 8000, minus 185 per level to a minimum of 5500<br />
*Channeling Time*: 2 minutes<br />
*Effects*: Deepen the psion's influence over a friendly animal, making it well-disposed toward the them. The animal counts as tamed and may be tied up, played with, ridden, and all other functions available to tame animals.<br />
*Prerequisites*: Beastmaster 10<br />
</details>
<details>
<summary><h3>Mind Control</h3></summary>

*Difficulty*: 8<br />
*Target*: One target within 3 squares plus 1 square per power level. Does not affect creatures without a living mind (no robots, no portal storm entities, etc.)<br /><br />
*Duration*: 6 to 52 seconds, plus 1.5 to 6.5 seconds per power level<br />
*Stamina Cost*: 7500, minus 165 per level to a minimum of 3500<br />
*Channeling Time*: 120 moves, minus 3.5 moves per level to a minimum of 65<br />
*Effects*: Take over the mind of your target.  The target will not be hostile to you or run while the power is active, and may fight to defend you, subject to its normal behaviors; mind controlling a salmon is unlikely to provide a significant edge in battle.  Due to engine limitations, does not currently work on NPCs.<br />
*Prerequisites*: Mood Stabilization 12 *or* Obscurity 6, Primal Terror 5 *or* Beastmaster 8 *or* Sensory Deprivation 7<br />
</details>
<details>
<summary><h3>Network Effect</h3></summary>

*Difficulty*: 9<br />
*Target*: All nearby NPC allies<br /><br />
*Duration*: 1 minute and 40 seconds to 5 minutes, plus 7 to 34 seconds per power level<br />
*Stamina Cost*: 6500, minus 135 per level to a minimum of 3750<br />
*Channeling Time*: 500 moves, minus 9 moves per level to a minimum of 250<br />
*Effects*: Forge a telepathic connection between nearby allies, allowing immediate reaction to threats and better coordination against danger. This provides a large array of bonuses: +1 dodge and block and another +1 per 12 power levels, +1 Perception and another +1 per 5 power levels, +3 ranged weapon range and another +1 per 4 power levels, a 5% chance to evade incoming attacks and another +1% per 2 power levels, 5% increased damage and another +1% per 2 power levels, increased combat skill gain, and the UNCANNY DODGE flag. It applies to all targets, but may only be used when at least 1 NPC ally is nearby.<br />
*Prerequisites*: Mind Sense 10, Telepathic Concentration 10 *or* Mood Stabilization 8, Psychic Scream 6<br />
</details>
</details>
<details>
<summary><h1>Teleportation</h1></summary>

**Passive Power: Spacial Recalibration**: Immunity to teleglow and a small chance to avoid incoming damage: a 1% chance per attack plus 0.025% times the psion's total levels in teleportation powers.
<details>
<summary><h3>Blink</h3></summary>

*Difficulty*: 1<br />
*Target*: Between 5 and 15 squares away, with a variance of 1 to 5 squares from the initial point<br />
*Duration*: Instant<br />
*Stamina Cost*: 900, minus 55 per level to a minimum of 350<br />
*Channeling Time*: 50 moves, minus 3.5 moves per level to a minimum of 5<br />
*Effects*: The psion vanishes and reappears nearby. They cannot control exactly where they end up. While there is no danger of teleporting into a wall or solid rock, if above ground level it is possible to teleport into open air, after which the psion will fall normally.  The psion may always teleport themselves, and can carry 5L of gear, plus 3.5L per power level.<br />
*Prerequisites*: Starting power<br />
</details>
<details>
<summary><h3>Stutterstep</h3></summary>

*Difficulty*: 2<br />
*Target*: One target within 3 squares plus 1.2 squares per power level, with an AoE increasing by 1 per 5 power levels<br />
*Duration*: 1.25 seconds to 15 seconds, plus 0.75 to 2 seconds per power level<br />
*Stamina Cost*: 2000, minus 75 per level to a minimum of 750<br />
*Channeling Time*: 80 moves, minus 4.5 moves per level to a minimum of 35<br />
*Effects*: Warp space around the target, increasing relative distances and reducing their speed by 40.<br />
*Prerequisites*: Starting power<br />
</details>
<details>
<summary><h3>Phase</h3></summary>

*Difficulty*: 2<br />
*Target*: 2 squares plus 1 square per 10 power levels to a maximum of 4 squares<br />
*Duration*: Instant<br />
*Stamina Cost*: 2500, minus 65 per level to a minimum of 1250<br />
*Channeling Time*: 65 moves, minus 3 moves per level to a minimum of 15<br />
*Effects*: Travel a short distance through the Nether and re-emerge nearby, allowing the psion to bypass a door or travel from the ground floor to the second floor.  The psion may always teleport themselves, and can carry 10L of gear, plus 5L per power level.<br />
*Prerequisites*: Blink 6<br />
</details>
<details>
<summary><h3>Extended Stride (C)</h3></summary>

*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: 30 seconds to 5 minutes, plus 11 to 37 seconds per power level<br />
*Stamina Cost*: 3500, minus 95 per level to a minimum of 1750<br />
*Channeling Time*: 85 moves, minus 7 moves per level to a minimum of 25<br />
*Effects*: Shorten relative distances nearby, allowing the psions to travel faster than their stride would indicate. Reduces move cost by 5% plus 2% per power level to a maximum of 60% reduced move cost.<br />
*Prerequisites*: Phase 4, Stutterstep 6<br />
</details>
<details>
<summary><h3>Apportation</h3></summary>

*Difficulty*: 3<br />
*Target*: One held item of 2L or less volume, plus 2.5L per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 2500, minus 65 per level to a minimum of 1250<br />
*Channeling Time*: 150 moves, minus 7.5 moves per level to a minimum of 75<br />
*Effects*: Transport an item in your hands to a nearby location, up to 2 squares plus 1.25 square per power level away.  The item cannot be teleported into a solid object.<br />
*Prerequisites*: Blink 4, Stutterstep 4<br />
</details>
<details>
<summary><h3>Transposition</h3></summary>

*Difficulty*: 4<br />
*Target*: One target within 1 square plus 1.5 squares per power levels<br />
*Duration*: Instant<br />
*Stamina Cost*: 2750, minus 85 per level to a minimum of 1500<br />
*Channeling Time*: 75 moves, minus 2.5 moves per level to a minimum of 30<br />
*Effects*: Extangle the psion's position with the target's and then swap places, exchanging positions.<br />
*Prerequisites*: Displacement 5, Extended Stride 5<br />
</details>
<details>
<summary><h3>Displacement</h3></summary>

*Difficulty*: 4<br />
*Target*: One target within range 1<br />
*Duration*: Instant<br />
*Stamina Cost*: 4000, minus 65 per level to a minimum of 1750<br />
*Channeling Time*: 95 moves, minus 4 moves per level to a minimum of 25<br />
*Effects*: Touch a single target and teleport them through the Nether, sending them anywhere within 5 to 15 squares with a variance of 1 to 5 squares from that point (the same as Blink). The target must be no larger than 25L in volume plus 12.5L per power level.<br />
*Prerequisites*: Stutterstep 10, Apportation 5 <br />
</details>
<details>
<summary><h3>Reactive Displacement (C)</h3></summary>

*Difficulty*: 5<br />
*Target*: Self<br />
*Duration*: 20 seconds to 3 minutes and 20 seconds plus 10 to 40 seconds per power level<br />
*Stamina Cost*: 3500, minus 100 per level to a minimum of 1500<br />
*Channeling Time*: 100 moves, minus 5 moves per level to a minimum of 25<br />
*Effects*: The psion maintains a reactive shield, forcefully teleporting any entity that hits them through the nether. This effect does not prevent the damage from getting hit. The entity is sent anywhere within 5 to 15 squares with a variance of 1 to 5 squares from that point (the same as Displacement).  The target must be no larger than 25L in volume plus 12.5L per Displacement power level (not Reactive Displacement).<br />
*Prerequisites*: Displacement 5 <br />
</details>
<details>
<summary><h3>Spacial Vortex</h3></summary>

*Difficulty*: 5<br />
*Target*: An area of 3 squares plus 1 square per 4 power levels, with a range of 5 squares plus 1.2 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 5500, minus 75 per level to a minimum of 3000<br />
*Channeling Time*: 80 moves, minus 2 moves per level to a minimum of 45<br />
*Effects*: Warp space and draw everyone within toward the central point. All targets within the AoE are pulled toward the center by 1 square per 4 power levels, to a maximum of 8 squares toward the center.<br />
*Prerequisites*: Stutterstep 10 *or* Transposition 6, Extended Stride 4<br />
</details>
<details>
<summary><h3>Relocation</h3></summary>

*Difficulty*: 5<br />
*Target*: One attuned location<br />
*Duration*: Instant<br />
*Stamina Cost*: 6000, minus 100 per level to a minimum of 3500<br />
*Channeling Time*: 200 moves, minus 5.5 moves per level to a minimum of 75.<br />
*Effects*: Transport all wielded items through the Nether to an attuned location. This power works at any distance. This uses locations attuned to via Gateway. Allowed volume of wielded item is 10L plus 10L per power level.<br />
*Prerequisites*: Gateway 8, Apportation 6<br />
</details>
<details>
<summary><h3>Farstep</h3></summary>

*Difficulty*: 6<br />
*Target*: Anywhere within 1 square plus 2 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 6500, minus 105 per level to a minimum of 2750<br />
*Channeling Time*: 75 moves, minus 3 moves per level to a minimum of 30<br />
*Effects*: Step into the Nether and re-emerge at a location nearby.  Farstep works through walls and across Z levels. The psion may always teleport themselves, and can carry 8L of gear, plus 5L per power level.<br />
*Prerequisites*: Phase 10, Extended Stride 8 *or* Spacial Vortex 6 <br />
</details>
<details>
<summary><h3>Warped Strikes (C)</h3></summary>

*Difficulty*: 5<br />
*Target*: Self<br />
*Duration*: 30 seconds to 3 minutes, plus 10 to 30 seconds per power level<br />
*Stamina Cost*: 4000, minus 100 per level to a minimum of 2000<br />
*Channeling Time*: 80 moves, minus 3 moves per level to a minimum of 20<br />
*Effects*: Allows psion to melee attack extra distance, at 1 + 0.2 tiles per level.<br />
*Prerequisites*: Apportation 6, Extended Stride 10<br />
</details>
<details>
<summary><h3>Ephemeral Walk (C)</h3></summary>

*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: 30 seconds to 5 minutes, plus 10 to 30 seconds per power level<br />
*Stamina Cost*: 6500, minus 200 per level to a minimum of 2000<br />
*Channeling Time*: 85 moves, minus 7 moves per level to a minimum of 25<br />
*Effects*: Allows psion to walk through walls by directly moving into them. Starts out at one "wall" and grows at 0.1 distance per level.<br />
*Prerequisites*: Phase 10, Extended Stride 5<br />
</details>
<details>
<summary><h3>Loci Establishment (C)</h3></summary>

*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: 2 minutes and 5 seconds to 4 minutes and 10 seconds, plus 25 to 50 seconds per power level<br />
*Stamina Cost*: 3000, minus 100 per level to a minimum of 1000<br />
*Channeling Time*: 100 moves, minus 5 moves per level to a minimum of 25<br />
*Effects*: While concentrating, the psion maintains a locus to teleport back to with Loci Technique. Loci Technique and Loci Establishment are learned from contemplating Loci Establishment but have separate practice meditations.<br />
*Prerequisites*: Extended Stride 6, Farstep 6<br />
</details>
<details>
<summary><h3>Loci Technique</h3></summary>

*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: Instant<br />
*Stamina Cost*: 6000, minus 200 per level to a minimum of 3000<br />
*Channeling Time*: 200 moves, minus 5.5 moves per level to a minimum of 75<br />
*Effects*: Allows the psion to teleport to a locus that they are maintaining with Loci Establishment, does nothing if not maintaining a locus. Loci Technique and Loci Establishment are learned from contemplating Loci Establishment but have separate practice meditations.<br />
*Prerequisites*: Extended Stride 6, Farstep 6 (Learned with Loci Establishment)<br />
</details>
<details>
<summary><h3>Oubliette</h3></summary>

*Difficulty*: 7<br />
*Target*: A single target within 2 squares plus 1.5 squares per power level<br />
*Duration*: Instant<br />
*Stamina Cost*: 7500, minus 170 per level to a minimum of 4600<br />
*Channeling Time*: 150 moves, minus 5.5 moves per level to a minimum of 75<br />
*Effects*: Teleports a single target somewhere *else*, removing them and anything they might drop. The target must have HP lower than 15 to 350, plus 15 to 35 per power level, randomly determined when the power is used.  For this purpose, NPC health is calculated as the sum total of their limb health, divided by 3.<br />
*Prerequisites*: Displacement 10, Farstep 6 *or* Transposition 8 *or* Spacial Vortex 8<br />
</details>
<details>
<summary><h3>Gateway</h3></summary>

*Difficulty*: 8<br />
*Target*: One attuned location<br />
*Duration*: Instant<br />
*Stamina Cost*: 10000, minus 200 per level to a minimum of 6000<br />
*Channeling Time*: 200 moves, minus 5.5 moves per level to a minimum of 75. Attunement takes 8 hours, minus 20 minutes per power level of Gateway to a minimum of 30 minutes<br />
*Effects*: Transport the psion through the Nether to an attuned location. This power works at any distance.  The psion may have a number of destinations simultaneously equal to 1 + 1 per 3 levels of Gateway (2.5 levels with the Good Memory trait, 4 levels with the Forgetful trait).  The psion may always teleport themselves, and can carry 10L of gear, plus 7.5L per power level.<br />
*Prerequisites*: Farstep 10, Loci Establishment 6 <br />
</details>
<details>
<summary><h3>Dilated Gateway</h3></summary>

*Difficulty*: 9<br />
*Target*: One attuned location<br />
*Duration*: Instant<br />
*Stamina Cost*: 12000, minus 200 per level to a minimum of 8000<br />
*Channeling Time*: 200 moves, minus 5.5 moves per level to a minimum of 75.<br />
*Effects*: Transport the psion and every adjacent creature through the Nether to an attuned location. This power works at any distance. This uses locations attuned to via Gateway.<br />
*Prerequisites*: Gateway 8, Oubliette 2 <br />
</details>
<details>
<summary><h3>Flickerflash Stance</h3></summary>

*Difficulty*: 9<br />
*Target*: Self<br />
*Duration*: 23 seconds to or 1 minute 37 seconds, plus 3.5 to 14 seconds per power level<br />
*Stamina Cost*: 7500, minus 225 per level to a minimum of 4500<br />
*Channeling Time*: 75 moves, minus 4 moves per level to a minimum of 25<br />
*Effects*: Begin constantly warping space and teleporting small distances to increase the psion's combat prowess. This provides the UNCANNY_DODGE flag, adds 1 to hit per 5 power levels, adds 5% melee damage + 3% per power level, adds 1 bonus dodge plus 1 per 4 power levels, adds a flat 15% chance to dodge any attack, adds an additional 10% plus 2.5% per power level chance to dodge ranged attacks, and a -4 penalty to perception.  In addition, there is a 33% chance when attacking or being attacked that the psion will blink to a nearby square.<br />
*Prerequisites*: Special (must be studied from notes)<br />
</details>
<details>
<summary><h3>Breach</h3></summary>

*Difficulty*: 9<br />
*Target*: A single target within 2 squares plus 1.3 squares per power level<br />
*Duration*: Indefinite<br />
*Stamina Cost*: 9000, minus 250 per level to a minimum of 4500<br />
*Channeling Time*: 250 moves, minus 6.5 moves per level to a minimum of 125<br />
*Effects*: Opens a portal to the Nether and allows something to come through: from 1 to 3 monsters from the GROUP_NETHER_BREACH monster group. The psion has no control over what exactly comes through and no control over what they do when they arrive.<br />
*Prerequisites*: Displacement 12 *or* Oubliette 7, Gateway 6<br />
</details>
<details>
<summary><h3>Reality Tear</h3></summary>

*Difficulty*: 10<br />
*Target*: A single target within 1 square<br />
*Duration*: Indefinite<br />
*Stamina Cost*: 10000, minus 250 per level to a minimum of 5000<br />
*Channeling Time*: 250 moves, minus 10 moves per level to a minimum of 100<br />
*Effects*: Rip open the fabric of reality, creating an opening to the Nether.  This is generally temporary, though there is a chance equal to your Nether Attunement vitamin / 25 as a percentage (+5% if in near a Nether-related location, +10% if in a Nether related location, +20% if in a portal storm) that the rift is permanent. Several denizens of the Nether will also come through the opening; like Breach, the psion has no control over them when they arrive.<br />
*Prerequisites*: Gateway 10, Breach 10<br />
</details>
</details>
<details>
<summary><h1>Vitakinesis</h1></summary>

**Passive Power: Bloom of Vitality**: Increased max HP equal to 5% plus 0.05% times the psion's total levels in vitakinetic powers, faster healing equal to 10% plus 0.05% times the psion's total levels in vitakinetic powers, the ability to heal broken limbs without a splint, and 5x faster processing of mutant toxins.
<details>
<summary><h3>Healthy Glow (C)</h3></summary>

*Difficulty*: 1<br />
*Target*: Self<br />
*Duration*: 5 minutes and 54 seconds to 25 minutes and 50 seconds, plus 21 seconds to 4 minutes and 58 seconds per power level<br />
*Stamina Cost*: 2500, minus 75 per level to a minimum of 1000<br />
*Channeling Time*: 100 moves, minus 7.5 moves per level to a minimum of 25<br />
*Effects*: The psion improves their health. They are immune to the deleterious effects of vitamin deficiency and toxin buildup, heal twice as fast, and cannot suffer from an asthma attack while the power is in effect. In addition, their Health has a 7% chance of going up by 1 every 10 minutes.  Healthy Glow is incompatible with Leucocyte Accumulation.<br />
*Prerequisites*: Starting power<br />
</details>
<details>
<summary><h3>Coagulation (C)</h3></summary>

*Difficulty*: 1<br />
*Target*: Self<br />
*Duration*: 4 minutes and 50 seconds to 19 minutes and 34 seconds, plus 18 seconds to 2 minutes and 43 seconds per power level<br />
*Stamina Cost*: 2500, minus 95 per level to a minimum of 1250<br />
*Channeling Time*: 200 moves, minus 6.5 moves per level to a minimum of 50<br />
*Effects*: Increases the coagulation rate of blood, slowing bleeding.  From level 1 through 7, bleeding is slowed by a third. From level 8 through 15, bleeding is slowed by two thirds. At level 16 or above, bleeding is slowed by two thirds, or prevented entirely if inflicted when the power is active. In addition, all power levels increase the effectiveness of any attempt to stop bleeding by 15%, plus 5% per power level.<br />
*Prerequisites*: Starting power<br />
</details>
<details>
<summary><h3>Leucocyte Accumulation</h3></summary>

*Difficulty*: 2<br />
*Target*: Self<br />
*Duration*: 5 minutes and 54 seconds to 25 minutes and 50 seconds, plus 21 seconds to 4 minutes and 58 seconds per power level.<br />
*Stamina Cost*: 3500, minus 80 per level to a minimum of 1350<br />
*Channeling Time*: 250 moves, minus 9.5 moves per level to a minimum of 35<br />
*Effects*: Focus the psion's healing on a single body part, increasing its healing rate by 20x + 6x per power level, but reducing the healing rate of every other body part by 99%. Leucocyte Accumulation is incompatible with Healthy Glow.<br />
*Prerequisites*: Healthy Glow 5<br />
</details>
<details>
<summary><h3>Staunch Wound</h3></summary>

*Difficulty*: 2<br />
*Target*: Self<br />
*Duration*: Instant<br />
*Stamina Cost*: 3000, minus 125 per level to a minimum of 750<br />
*Channeling Time*: 50 moves, minus 3 moves per level to a minimum of 20<br />
*Effects*: With an act of will, the psion closes their wounds. From level 1 to 5, the power has "bandages_power": 1 and "bleed": 7. From level 6 to 11, the power has "bandages_power": 2 and "bleed": 14. At level 12 or above, the power has "bandages_power": 3 and "bleed": 20.<br />
*Prerequisites*: Coagulation 5<br />
</details>
<details>
<summary><h3>Medicinal Touch</h3></summary>

*Difficulty*: 3<br />
*Target*: One ally within range 1<br />
*Duration*: 5 minutes and 54 seconds to 25 minutes and 50 seconds, plus 21 seconds to 4 minutes and 58 seconds per power level<br />
*Stamina Cost*: 4000, minus 75 per level to a minimum of 2000<br />
*Channeling Time*: 100 moves, minus 7.5 moves per level to a minimum of 25<br />
*Effects*: Apply the effects of Healthy Glow to a friend or ally. The target gains all the benefits of Healthy Glow for as long as the power lasts.<br />
*Prerequisites*: Healthy Glow 6<br />
</details>
<details>
<summary><h3>Enervating Touch</h3></summary>

*Difficulty*: 3<br />
*Target*: One enemy within range 1<br />
*Duration*: 18 seconds to 1 minute and 1 second, plus 29 seconds to 1 minute and 18 seconds per power level<br />
*Stamina Cost*: 2000, minus 65 per level to a minimum of 950<br />
*Channeling Time*: 85 moves, minus 3 moves per level to a minimum of 55<br />
*Effects*: Cause decay in the target's tissues, reducing speed by 5%, slightly reducing their chance to hit, and having a 3% chance per second to cause 1 biological damage, +0.2% chance per power level to a maximum of a 10% chance.  As well, while the power is in effect, any creature with regeneration has their rate of regeneration cut in half.<br />
*Prerequisites*: Medicinal Touch 5, Coagulation 5<br />
</details>
<details>
<summary><h3>Detoxification</h3></summary>

*Difficulty*: 3<br />
*Target*: Self<br />
*Duration*: 2 minutes and 36 seconds to 6 minutes and 58 seconds, plus 4 seconds to 32 seconds per power level<br />
*Stamina Cost*: 3500, minus 115 per level to a minimum of 1750<br />
*Channeling Time*: 75 moves, minus 5 moves per level to a minimum of 25<br />
*Effects*: Cures any poison by sweating it out. A short time afer using the power, between 15 seconds (minute 1 second per power level to a minimum of 1) to 2 minutes (minus 2 seconds per power level to a minimum of 1), the psion will begin sweating and the poison will be removed. The psion gains the benefits of the Toxic Flesh trait for the power's duration.<br />
*Prerequisites*: Healthy Glow 8, Staunch Wound 3 *or* Coagulation 7<br />
</details>
<details>
<summary><h3>Immunostimulus (C)</h3></summary>

*Difficulty*: 4<br />
*Target*: Self<br />
*Duration*: 19 minutes and 8 seconds to 47 minutes and 14 seconds, plus 48 seconds to 5 minutes and 11 seconds per power level<br />
*Stamina Cost*: 5500, minus 125 per level to a minimum of 2500<br />
*Channeling Time*: 500 moves, minus 18 moves per level to a minimum of 50<br />
*Effects*: Kick the psion's immune system into overdrive, helping overcome any diseases they are suffering from. Every 10 minutes (minus 5 seconds per power level) to 60 minutes (minus 30 seconds per power level) while the power is active, the psion has a chance equal to 10% plus the power level to cure one disease they're suffering from. It may take some time before the psion's immune system manages to overcome the disease. In addition, if the psion is suffering from hay fever, the power will make it much worse.<br />
*Prerequisites*: Detoxification 5<br />
</details>
<details>
<summary><h3>Wakeful Rest</h3></summary>

*Difficulty*: 4<br />
*Target*: Self<br />
*Duration*: Indefinite<br />
*Stamina Cost*: 1000<br />
*Channeling Time*: Indefinite<br />
*Effects*: Meditate in lieu of sleep. Using the power will begin the meditating, slowly lowering the psion's fatigue and sleep deprivation ratings. The rate of reduction increases per power level and with the psion's metaphysics skill, with the formula: 1 in (55 - ( Wakeful Rest power level * 2) - Metaphysics skill) ), 15 ) chance per second for fatigue, and 1 per second for sleep deprivation.  When fatigue hits zero, a prompt to cancel the meditation pops up.<br />
*Prerequisites*: Healthy Glow 8, Immunostimulus 4<br />
</details>
<details>
<summary><h3>Allay Infection</h3></summary>

*Difficulty*: 5<br />
*Target*: Self<br />
*Duration*: Instant<br />
*Stamina Cost*: 5000, minus 145 per level to a minimum of 2250<br />
*Channeling Time*: 350 moves, minus 14 moves per level to a minimum of 125<br />
*Effects*: The psion encourages their immune system to focus entirely on their wounds for a brief period. From level 1 to 5, the power has "bite": 0.5, "disinfectant_power": 1, "infect": 0.4. From level 6 to 11, the power has "bite": 0.7, "disinfectant_power": 2, "infect": 0.6. At level 12 or above, the power has "bite": 0.9, "disinfectant_power": 3, "infect": 0.8.<br />
*Prerequisites*: Immunostimulus 7<br />
</details>
<details>
<summary><h3>Revitalizing Meditation</h3></summary>

*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: Instant<br />
*Stamina Cost*: 8000<br />
*Channeling Time*: 5 seconds<br />
*Effects*: Sink deep into meditation and greatly increase healing speed. While meditating, the psion heals 4 times faster, plus 0.75 times per power level. In addition, broken limbs heal 2 times faster, plus 0.25 times per power level.<br />
*Prerequisites*: Leukocyte Accumulation 6, Allay Infection 5<br />
</details>
<details>
<summary><h3>Lacerating Touch</h3></summary>

*Difficulty*: 6<br />
*Target*: One enemy within range 1<br />
*Duration*: Instant<br />
*Stamina Cost*: 6000, minus 115 per level to a minimum of 2350<br />
*Channeling Time*: 85 moves, minus 3 moves per level to a minimum of 55<br />
*Effects*: Directly cause cellular breakdown in the target, doing 12 to 35 biological damage plus 2 to 4 biological damage per power level, and causing 1 biological damage per second for 4 to 8 seconds plus 0.5 to 1.5 seconds per power level afterwards.<br />
*Prerequisites*: Enervating Touch 8<br />
</details>
<details>
<summary><h3>Radiation Decontamination</h3></summary>

*Difficulty*: 6<br />
*Target*: Self<br />
*Duration*: Indefinite<br />
*Stamina Cost*: 7000, minus 135 per level to a minimum of 4500<br />
*Channeling Time*: 1 minute<br />
*Effects*: Purge irradiated tissue. The duration depends on the exact amount of mSv the psion is suffering from. 500 or more means the power takes 4 hours and 10 minutes, between 499 and 250 takes 2 hours and 5 minutes, bewteen 249 to 125 takes 1 hour and 5 minutes, between 124 and 60 takes 30 minutes, between 59 and 30 takes 15 minutes, and 29 or less takes 7 minutes. During that time, the psion loses 1 mSv of radiation per minute. The psion also suffers increasingly serious side effects for the power duration, including -1 Srength and Dexterity and -0.7 Perception per tier above 29 mSv and incresing chances to vomit, suffer pain, or take Health score penalties.<br />
*Prerequisites*: Special<br />
</details>
<details>
<summary><h3>Blood Purge</h3></summary>

*Difficulty*: 7<br />
*Target*: Self<br />
*Duration*: Instant<br />
*Stamina Cost*: 8500, minus 145 per level to a minimum of 4500<br />
*Channeling Time*: 250 moves, minus 8 moves per level to a minimum of 100<br />
*Effects*: Clean the psion's blood of all foreign substances or chemicals. Applies the cureall effect, the same as from Panacea, and also remove all mutagen as well.<br />
*Prerequisites*: Revitalizing Meditation 6, Allay Infection 8 *or* Detoxification 8<br />
</details>
<details>
<summary><h3>Banish Illness</h3></summary>

*Difficulty*: 8<br />
*Target*: Self<br />
*Duration*: Instant<br />
*Stamina Cost*: 10000<br />
*Channeling Time*: 5 seconds<br />
*Effects*: Purge mundane illnesses with 100% success rate or have a chance to cure long-term or chronic conditions. The power allows the psion to attempt to cure asthma, chemical imbalance, kalupetic psychosis, jittery, mood swings, weakening, narcolepsy, seasonal allergies, or seasonable affective disorder. The chance depends on the particular condition and increases with power level.<br />
*Prerequisites*: Allay Infection 12, Leukocyte Accumulation 8 *or* Immunostimulus 12<br />
</details>
<details>
<summary><h3>Anabolic Rejuvenation (C)</h3></summary>

*Difficulty*: 9<br />
*Target*: Self<br />
*Duration*: 2 minutes and 26 seconds to 6 minutes and 12 seconds, plus 29 seconds to 1 minute and 50 seconds per power level<br />
*Stamina Cost*: 10000, minus 150 per level to a minimum of 6500<br />
*Channeling Time*: 10 seconds<br />
*Effects*: Use up the psion's bodily reserves to speed healing to a preternatural rate. Every 20 to 35 seconds, minus 0.5 seconds per power level to a minimum of 3 to 7 seconds, the psion heals one hit point to every body part, but whenever a healing tick occurs, the psion loses between 50 and 250 kCal, 50 to 200 units of iron, 100 to 200 units of calcium, 20 to 60 units of vitamin C, and gains 2 to 10 points of fatigue.<br />
*Prerequisites*: Healthy Glow 14 *or* Revitalizing Meditation 9, Leukocyte Accumulation 10 *or* Detoxification 7 *or* Blood Purge 5<br />
</details>
<details>
<summary><h3>Degenerating Touch</h3></summary>

*Difficulty*: 9<br />
*Target*: One enemy within range 1<br />
*Duration*: 30 seconds minus 1 seccond per power level to 75 seconds minus two seconds per power level to a minimum of 15 seconds<br />
*Stamina Cost*: 8500, minus 250 per level to a minimum of 4500<br />
*Channeling Time*: 85 moves, minus 3 moves per level to a minimum of 55<br />
*Effects*: Invert the target's healing processes, causing massive cellular breakdown and necrosis, doing 25 to 55 biological damage plus 17 to 32 biological damage per power level. This damage is evenly divided over the power's duration. In addition, the target has any regeneration or healing reduced to 0 and suffers a 33% speed penalty for the power's duration.<br />
*Prerequisites*: Enervating Touch 16 *or* Lacerating Touch 8, Banish Illness 6, Anabolic Rejuvenation 5 *or* Immunostimulus 15<br />
</details>
<details>
<summary><h3>Accelerated Resuscitation (C)</h3></summary>

*Difficulty*: 10<br />
*Target*: Self<br />
*Duration*: 1 hour 6 minutes and 2 minutes and 18 seconds to 3 hours and 26 minutes, plus 16 minutes and 2 seconds to 46 minutes and 59 seconds per power level<br />
*Stamina Cost*: 9000, minus 125 per level to a minimum of 6000<br />
*Channeling Time*: 30 seconds<br />
*Effects*: Prepare the psion's body for a potentially fatal shock. If the psion takes fatal damage while this power is maintained, any body part below 15 hit points will be healed to 15 hit points, their attributes and speed will have no penalties based on pain (penalties increase by 10% every 30 seconds until they reach the normal level) and a much faster Anabolic Rejuvenation is placed on them, ticking once every 1 to 3 seconds for 20 seconds. However, the psion's total stored kCal is reduced by 20% to fuel the resuscitation, and each Anabolic Rejuvenation costs 3x the kCal, iron, etc that it would if the psion had used Anabolic Rejuvenation.<br />
*Prerequisites*: Anabolic Rejuvenation 6 *or* Banish Illness 8 *and* Revitalizing Meditation 6<br />
</details>
</details>
