# Scrap Crafting System

## Overview

As one of its main  goals, Aftershock allows the crafting of miscellaneous, highly technological devices that have no actual basis in reality.  To make the crafting of these devices more balanced an intuitive, and to make adding more recipes and items easier, aftershock utilizes a crafting a system in which abstracted pieces of increasingly rare scrap are used to craft increasingly useful tools.


### Current Scrap Categories

The following table lists the currently planned/implemented scrap categories and their tiers.

|     Category      |     Tier 1           |    Tier 2                |     Tier 3                 |     Tier 4                |     Tier 5                           |
| ----------------- | -------------------- | ------------------------ | -------------------------- | ------------------------- | ------------------------------------ |
| `Circuitry`       | scrap photonics      | photonic circuitry       | photonic computation core  | hypergeometric photonics  | acausal logic permutator             |
| `Energy Storage`  | Nanowire battery     | ultracapacitor           | Ultracapacitor array       | Superconductive Coil      | zero-point energy extractor          |
| `Material`        | Composite Superalloy | vacuum cast Carbide      | Nanoprinted Alloys         | crystal forged neutrite   | phase-uneven matter                  |
| `Cloth`           | E-textile            | monofilament silk        | graphene weave             | woven metamaterial        |                                      |
| `Magnet`          | Emag                 | cryo electromagnet       | super conductive emag      | ferrofluid dynamo         |                                      |
| `Optics  `        |                      |                          | Laser Optics               | Metamaterial lens         |                                      |
| `Neural I/O`      | peripheral electrode | neural electrode         | Brain implant prod         | Synthetic Neural Tissue   | neurosynaptic interface matrix       |
| `Biomaterial`     | monomeric slurry     | micellular growth medium | artificial muscle fibers   | self healing polymers     | autologous totipotent tissue culture |
| `Heat Transfer`   | conductive thermoplastic | supercritical coolant | carbon-lattice heatsink   | fermionic nanoribbon   | maxwellian entropic chirality generator |

Note that more categories can be added, and that it inst necessary for a category to encompass the five tiers, although its better if they do.

## Scrap Tiers Briefly Explained

### Tier 1

Tier 1 scrap is plentiful, and can be easily found even when you aren't specifically looking for it.  It might be dropped by defeating common enemies, or by disassembling common household objects.  Ideally Tier 1 scrap is mostly used as a filler component in more advanced recipes. Things that might be crafted using only this tier of scrap must be single-use and not very effective, and should  see little use outside of the early game.For example

- Makeshift ammunition of all kinds, that might risk damaging your gun.
- Weak grenades with very limited range.

### Tier 2

Tier 2 scrap remains common, but requires some measure of effort to acquire. Perhaps it spawns only in certain locations or requires specialized tools and skills to extract.  This scrap might be used to craft disposable tools and weapons or to make decent quality ammunition and explosives. For example:

- Bulky, makeshift version of an UPS with very limited charge capacity.
- A rail gun/laser that works only for a limited number of shots before melting.
- A grenade that emits a low range electric field.

### Tier 3

Much like tier 2 above, this type of scrap is common, but is only meant to spawn in locations that might prove dangerous to a mid-game characters.  Additionally, it should always need tools and skills to extract.  Tier 3 scrap might be used to craft  basic rechargeable tools, mid-quality weapons and exotic ammunition and grenades.  For example:

- UPS
- Non relaodable charge packs for Laser Weapons
- Shoddy laser Rifle

### Tier 4

This tier of scrap is properly uncommon, it spawns should be limited to the 'boss rooms' of mid-game and to end-game dungeons, and should prove challenging to acquire.  It might be used to craft tools that provide great convenience in the non combat aspects of the game, single use items that grant very powerful abilities and good quality weapons. For Example

- Most utility bionics.
- Laser Weapons.
- Atomic tools.
- Single use invisibility cloak.

### Tier 5

Very rare loot occasionally dropped by endgame threats and dungeons, extracting it requires very high skills and specialized tools. Thematically linked to the dimensional technology that caused the Discontinuity. Might be used to craft items that severely and permanently alter the combat aspects of gameplay. For example:

- Hologram Cloak Mk. II
- Rechargeable Spell Casters
- CBMs that interact with space-time
- Most combat bionics.
