# Sky Islands
A raid-based gameplay overhaul mod for CDDA, inspired by games like Escape from Tarkov and Dark & Darker.
### Warning:
- You MUST make a custom character for this.  "Play Now!" will not work.
- The game uses code to search large areas of the map.  That means you may run into load times of up to a couple minutes at times.  You will generally be warned of these in-game, so please be patient.
- Save often because there WILL be bugs and even occasionally crashes at this stage.
- There is yet no way to clear the map.  This means despite a large search radius you will sometimes teleport near areas you've been before, and your save file will get very large very fast.  Unfortunately these are known issues and cannot be solved by mod-accessible code at this time.

Changelog has been moved to the bottom!  Scroll down!

# Overview
This mod attempts to completely change how you play CDDA.

You start off high in the sky on a floating island, and using a warp statue located there, will be teleported to a random location on the earth below to commence an "expedition".  There, you are on a limited timer of only 2 hours and must fight, loot, and journey your way to the nearby exit portal.  Use it, and you will bring all the items you were carrying back to the safety of your floating sanctuary, but you will not be able to return to the place you left behind.
The better equipped you are, the more likely you will survive, but remember that bringing out too much gear will make it hard to carry much new loot home -- and dying with all that high quality gear means it's gone forever.  Balancing what gear you are willing to risk on any expedition is an important consideration.

### You Can't Go Back
Once you warp home, there will be no way to warp back to the area on the ground you just left.  Every trip to the surface is fleeting.  As a result you will have no way to keep most vehicles, no need to thoroughly clear most areas, and no reason to preserve anything.  This will drastically change how most players approach normally routine scenarios.  Remember that only carried items can be brought home -- if something cannot be taken with you or used during the expedition, it's junk!
### Death is not the end.
Should you die, your character's story is not over!  You will simply return to the island at low health, but everything you had on you will be lost.  Recover your strength, gear up from your stash, and head back out.
## Warpcloak
For the first 60 seconds of every expedition, you will be under the effect of "warpcloak".  This leaves you invisible and immune to fall damage, which should give you just enough time to run for cover in case you were dropped into extreme danger.  Don't waste it - act fast!
### Warp Sickness
Difficulty is selected in-game when a new game starts and affects _ONLY_ how long you can stay out on each expedition.  Every setting has a soft limit and a hard limit.  When you hit the soft limit, you suffer Warp Sickness: your stats begin to slowly drain until you leave.  When you hit the hard limit, you contract Warp Disintegration: you begin rapidly taking damage until you leave or die!

## The Island
The eponymous sky island is your sanctuary and home base.  You're given a large, magically isolated area you can customize however you want.  Stash your items, grow crops, set up production, build a base.  Anything you like.  While here no threats should be able to reach you.
As it is exposed to the sky, solar power works here.  As it is very high up, expect cold, windy days.

## The "Expeditions"
When you're ready to set out, gear up and examine the warp statue.  This will send you to a random unexplored area of the map.  Nearby, at random, you will also find a location marked in your mission journal: a return portal, your only exit.  You must fight your way to the return portal before warp sickness overtakes you, and examine the statue in the mysterious Red Room you find marked on your map (it always spawns in a field).  Do this and you complete that excursion -- you will be returned home safely with everything you were carrying.  Take this time to organize, rest, and recover, before planning your next mission.

### Missions
You will be given four marked missions in your log every time you begin an expedition.  One will guide you to the exit portal.  One will require you to kill a certain total amount of enemies before returning home.  And finally you will get two randomly generated missions to visit a location, usually to clear a specific threat.  Rewards, in the form of **warp shards**, are issued on completion of these missions.  Harder missions yield more warp shards.

### Warp Shards and Warped Items
These special resources can only be acquired by completing missions.  Bring them safely home where they can be crafted into special items.  These items provide unique powers and opportunities.
Warp shards can't buy you weapons, armor, food, or most useful supplies.

To find these recipes just look under the "Warp" tab in your crafting menu.

# Tips
- Never forget your time limit!  A watch or clock can save your life, but if you have nothing else, keep an eye on your warp pulses!
- Remember that anything carried or worn is brought home.  Since you can wield very bulky items, it might be worth grabbing the biggest thing you can find before coming home.  A corpse to butcher, a heavy piece of furniture to build with, an entire engine block.  You may not be able to stand up, but if you can hold it, it's coming with you!
- You're expected to die.  More than usual.  Each expedition will see you dropped into potential danger, racing the clock to push through hostile and unfamiliar terrain, cut off from home base, impeded by unseen obstacles, and with only the gear on your back.  Many factors combine to make this experience harder than normal CDDA, so you will probably die more often.  Don't feel bad, just pick yourself up and try again!
- Stockpile multiples!  Many things you only needed one of before will need to be replaced if an expedition is lost.  Stash extra guns, backpacks, shoes, clothes, watches, pocket knives, lighters, and anything else you may risk losing!  Many tools and utensils can be kept safely at home, but for everything else, be mindful!
- You can spend as long as you want in the safety of your home.  Sooner or later you'll need to restock on *something*, but if you need to take a few days off, no one will bother you.
- The Heart of the Island can heal you to full for free, but will only until you have completed 10 successful expeditions.  After that, it costs warp shards to use.  Use this grace period to get a decent stockpile of basic supplies going.  Once you must way, heal yourself from small injuries while recuperating at base, and save the full heals for when you're really injured!
- Life insurance!  For a very high price, you can craft a Homeward Mote.  Bring this on an expedition and if you die, you will instead be healed to full and warped home *with all your items*.  However, this mote is only good for a single expedition.  Even if you survive and extract successfully, the mote will be gone.  It'll be used up either way, so there's no reason not to press your luck!
- Leave in a hurry!  Even if a horde is bearing down on you, or you're literally being eaten alive by dogs, touching the return portal will *instantly* bring you home.  No need to make a last stand, sometimes even with hell on your heels it's best to just run for the exit!
- Have fun!  Please report any bugs or leave suggestions for balance changes.


A mod I wanted to play so bad I just made it myself
-TGWeaver

# Changelog
**v0.3.0** MILESTONE 1 UPDATE!
Almost too many changes to count.  Massive overhaul to progression and balance.  Tested on CDDA Experimental 60499ad .
- Rebalanced expeditions!  This is a huge one.  Raids are now 3x shorter, so a normal raid has warp pulses every 15 minutes and a time limit of only 2 hours before warpsickness sets in.  The upside is that exits and missions now spawn much, much closer to the start.  This means it's now feasible to make quick, simple raids where you simply pop down, grab a few things, and pop back out.  Surviving raids is much easier as a result, so the player should hopefully no longer feel pressured to cram every single pocket full to overflowing (though you're still welcome to do that!) lest they feel the expedition was a waste.  Very reasonable now to have a successive series of short raids for specific goals, to pick missions based on difficulty rather than proximity, and most importantly, to spend most of your time fighting, looting, and exploring, NOT just traveling for miles!
- Longer raids can be unlocked, however, up to and including the old version's normal raid length.  So if you preferred those, they'll still be available too!
- Secure Container Alpha!  Unlock this and craft it and it will forever be a part of you.  It's very small, but anything inside will not be left behind when you die!  More containers are in the game but there are intentionally no recipes for it yet, pending broader testing and balancing.
- Added Heart of the Island (HoI).  Find this statue on your island and examine it for all kinds of new features, including:
- Upgrades!  The HoI can give you missions to retrieve various mundane items.  Complete these and you can unlock all kinds of permanent upgrades for yourself and for the island.  More missions and exits per expedition!  A larger map reveal radius!  Permanently increase the amount of warp pulses you can withstand!  Unlock new places to begin your expedition!  And more!  Currently there are 34 different upgrades you can buy!  Golly!
- Upgrade balance: Please note this is the part of the mod that, by its nature, needs the most testing.  Some upgrades will be way too expensive, others will be too cheap.  Some very early upgrades (Landing 1, Scouting 1, Unlock Expedition Missions, Construct Bunker Entrance, to name a few) are supposede to be achievable within the first 1-3 raids.  Others will take much longer, acting as long-term goals.
- Constructions!  Completing some of the HoI's missions will now instantly build on the island.  These take the form of an underground bunker, which means the player is still free to build and decorate and farm the surface however they wish.  Right now only the entrance and one room (in 4 successive sizes) are available to build.
- Material tokens!  A new currency, these are awarded every time you survive an expedition, even if you did no missions.  Longer expeditions yield more tokens.  They're spent on...
- Infinity sources!  This new system will let you get tons of raw resources right at home -- the same resources you previously had to use warp bags for.  Simply craft the Infinity Tree, Infinity Stone, or Infinity Ore, deploy it, and you will be able to spend your material tokens here for resources!  A much more direct and less tedious way of getting all the planks and nails you'll need to build a house, for instance.  And because they use a new currency they don't compete with warp shards which you'll need to spend in many other places.
- Most warp bags have been removed as a result of the balance change above.
- The hauler's harness still exists, but its weight reduction is no longer 100%.  Still great for bringing huge items with you through the portal, but no longer able to work as a fridge mega-backpack you carry for the entire raid.
- Menu-driven options!  Many neat features previously available through scattered items (salve of forgiveness, stat stone, portal warding stone, etc) are now integrated into the HoI's dialog menus.  You can also use these to change your difficulty settings at any time.
- Healing rebalance!  You can now instantly heal at the HoI for free until you have survived 10 expeditions.  After this, it will heal you to full for a price in warp shards.  Also, surviving an expedition now heals you as much as dying would have (broken limbs are mended, for example) so you will never again wind up in a scenario where it's better to die to increase your health.
- Expeditions are now targeted.  By default you always start in a field, but you can unlock basements, rooftops, and even science labs.
- Backwards compatibility!  Saves made with version 0.2.2 SHOULD work, but this has not been extensively tested.  Your save should automatically initialize the new values, and the map should even generate the newly required terrain.
- A bunch more stuff I probably forgot!

**v0.2.2** This version may not be compatible with old saves!  But old saves don't work on the new versions anyway, so use your own judgement.
- Updated mod to be compatible with newer CDDA versions (as of 2023-06-01-1256).
- Missions to kill groups of enemies now require you to actually kill ALL the enemies.  Previously they would complete after killing ANY of the enemies.
- Random Artifacts are now crafted directly, instead of crafting an "artifact box" and then unpacking it.
- You should now properly lose your radiation sickness when dying or using the Salve of Forgiveness.
- Infinitrees are now considered furniture, not terrain, and can be dragged around your island.

**v0.2.1** This version should be compatible with old saves.
- Being hit by a warp pulse now tells you exactly how many more pulses you have left until negative effects begin.
- Two extracts spawn per mission instead of one.
- Added Portal Storm Warding Stone that will dispel portal storms, but only when used on your island.
- In-game difficulty selection now offers Normal as first option.  Saying no to every option loops the menu over again; you have to say yes to something to proceed.
  - Two extracts spawn per mission instead of one.
  - Normal difficulty is now 6 hours soft cap, 9 hours hard cap.
  - Added new hard difficulty with 4 hour soft cap, 6 hour hard cap (same as old Normal).
- Stat Stone now tells you your difficulty settings.
- Rewrote a lot of in-game text to be more consistent and less wordy.
- Fixed warp disintegration hitting one pulse too early.
- Fixed missions not cleaning up properly.


**v0.2** This version should be compatible with old saves, but may require you to update C:DDA.
- Added multiple difficulties, changed default timer from 24 hours to 4 hours.
- Extracts can now spawn much further away.
- Added many more mission types, monstergroups to fill them with, and more.
- You now receive multiple missions per expedition.
- Added warp shards as mission rewards, and items to craft them into
  - Added warped bags to bring bulk materials home.
  - Added warped carrier to bring animals home.
  - Added warped hauler to strap a single item into for bonus hauling.
  - Added "Infinitree" to harvest logs and sticks at home.
  - Made Quickheal pills craftable.
  - Added Homeward Mote for "life insurance" on specific expeditions.
  - Added Earthbound pill to extend your current raid's timer.
  - Added a way to get an Autodoc on your island.
  - Added a way to cash in warp shards in exchange for random artifacts.
- Replaced starting Quickheal stockpile with Salve of Forgiveness, which heals you for free until you win 5 expeditions.
- Added unlockable progress.  Initially, only some mission types are available, and you will only deploy to fields.  After 5 wins, more mission types will unlock, and you may start deploying to forests.  After 10 wins, all mission types are unlocked and you may start deploying to houses.
- Added a Stat Stone that can tell you how many expeditions you've gone on, as well as total wins and losses.
- Cleaned up your island!  All the misc.  trash will now spawn pre-gathered on a single tile so you don't have to go sweeping every time you start a new game.
- Warp disintegration is more lethal.
- Many text prompts are more clear.
- Added a way to regrow grass at your home island, just for looks.
- Numerous bug and balance fixes.