/*
 * Firebird Open Source JDBC Driver
 *
 * Distributable under LGPL license.
 * You may obtain a copy of the License at http://www.gnu.org/copyleft/lgpl.html
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * LGPL License for more details.
 *
 * This file was created by members of the firebird development team.
 * All individual contributions remain the Copyright (C) of those
 * individuals.  Contributors to this file are either listed here or
 * can be obtained from a source control history command.
 *
 * All rights reserved.
 */
package org.firebirdsql.jna.fbclient;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.ShortByReference;

/**
 * JNA wrapper for XSQLVAR.
 * <p>
 * This file was initially autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>, a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.
 * </p>
 * <p>
 * This file was modified manually, <strong>do not automatically regenerate!</strong>
 * </p>
 * @since 3.0
 */
@Structure.FieldOrder({ "sqltype", "sqlscale", "sqlsubtype", "sqllen", "sqldata", "sqlind", "sqlname_length", "sqlname",
		"relname_length", "relname", "ownname_length", "ownname", "aliasname_length", "aliasname" })
@SuppressWarnings({ "unused", "java:S116", "java:S1104", "java:S2160" })
public class XSQLVAR extends Structure {

    public static final short SQLIND_NULL = -1;
    public static final short SQLIND_NOT_NULL = 0;

	/// C type : ISC_SHORT
	public short sqltype;
	/// C type : ISC_SHORT
	public short sqlscale;
	/// C type : ISC_SHORT
	public short sqlsubtype;
	/// C type : ISC_SHORT
	public short sqllen;
	/// C type : ISC_SCHAR*
	public Pointer sqldata;
	/// C type : ISC_SHORT*
	public ShortByReference sqlind;
	/// C type : ISC_SHORT
	public short sqlname_length;
	/// C type : ISC_SCHAR[32]
	public byte[] sqlname = new byte[32];
	/// C type : ISC_SHORT
	public short relname_length;
	/// C type : ISC_SCHAR[32]
	public byte[] relname = new byte[32];
	/// C type : ISC_SHORT
	public short ownname_length;
	/// C type : ISC_SCHAR[32]
	public byte[] ownname = new byte[32];
	/// C type : ISC_SHORT
	public short aliasname_length;
	/// C type : ISC_SCHAR[32]
	public byte[] aliasname = new byte[32];

	public XSQLVAR() {
		allocateMemory();
	}

    public Memory getSqlData() {
        return (Memory) sqldata;
    }

	public static class ByReference extends XSQLVAR implements Structure.ByReference {
	}

	public static class ByValue extends XSQLVAR implements Structure.ByValue {
	}
}
