/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.chacha64;

import java.security.Provider;
import java.security.Security;
import java.util.Objects;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.firebirdsql.gds.ng.wire.crypt.CryptConnectionInfo;
import org.firebirdsql.gds.ng.wire.crypt.CryptSessionConfig;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionPlugin;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionPluginSpi;
import org.firebirdsql.jaybird.chacha64.ChaCha64EncryptionPlugin;

public final class ChaCha64EncryptionPluginSpi
implements EncryptionPluginSpi {
    static final EncryptionIdentifier CHA_CHA_64_ID = new EncryptionIdentifier("Symmetric", "ChaCha64");
    private final Provider provider = Objects.requireNonNullElseGet(Security.getProvider("BC"), ChaCha64EncryptionPluginSpi::createProvider);

    public EncryptionIdentifier encryptionIdentifier() {
        return CHA_CHA_64_ID;
    }

    public EncryptionPlugin createEncryptionPlugin(CryptSessionConfig cryptSessionConfig) {
        return new ChaCha64EncryptionPlugin(cryptSessionConfig, this.provider);
    }

    public boolean isSupported(CryptConnectionInfo cryptConnectionInfo) {
        return cryptConnectionInfo.protocolVersion() >= 32784;
    }

    private static Provider createProvider() {
        return new BouncyCastleProvider();
    }
}

