/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.chacha64;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.sql.SQLException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.wire.crypt.CryptSessionConfig;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionInitInfo;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionPlugin;
import org.firebirdsql.jaybird.chacha64.ChaCha64EncryptionPluginSpi;

public final class ChaCha64EncryptionPlugin
implements EncryptionPlugin {
    private static final String CHA_CHA_CIPHER_NAME = "ChaCha";
    private final CryptSessionConfig cryptSessionConfig;
    private final Provider provider;

    ChaCha64EncryptionPlugin(CryptSessionConfig cryptSessionConfig, Provider provider) {
        this.cryptSessionConfig = cryptSessionConfig;
        this.provider = provider;
    }

    public EncryptionIdentifier encryptionIdentifier() {
        return ChaCha64EncryptionPluginSpi.CHA_CHA_64_ID;
    }

    public EncryptionInitInfo initializeEncryption() {
        ChaCha64IV iv = new ChaCha64IV();
        try {
            EncryptionInitInfo encryptionInitInfo = EncryptionInitInfo.success((EncryptionIdentifier)this.encryptionIdentifier(), (Cipher)this.createEncryptionCipher(iv), (Cipher)this.createDecryptionCipher(iv));
            iv.close();
            return encryptionInitInfo;
        }
        catch (Throwable throwable) {
            try {
                try {
                    iv.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                return EncryptionInitInfo.failure((EncryptionIdentifier)this.encryptionIdentifier(), (SQLException)e);
            }
        }
    }

    private Cipher createEncryptionCipher(ChaCha64IV iv) throws SQLException {
        return this.createCipher(1, iv, this.toChaChaKey(this.cryptSessionConfig.encryptKey()));
    }

    private Cipher createDecryptionCipher(ChaCha64IV iv) throws SQLException {
        return this.createCipher(2, iv, this.toChaChaKey(this.cryptSessionConfig.decryptKey()));
    }

    private byte[] toChaChaKey(byte[] key) throws SQLException {
        if (key.length < 16) {
            throw FbExceptionBuilder.forNonTransientException((int)337248282).messageParameter((Object)this.encryptionIdentifier(), (Object)"Key too short").toSQLException();
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return md.digest(key);
        }
        catch (NoSuchAlgorithmException e) {
            throw FbExceptionBuilder.forNonTransientException((int)337248281).messageParameter((Object)this.encryptionIdentifier()).cause((Throwable)e).toSQLException();
        }
    }

    private Cipher createCipher(int mode, ChaCha64IV iv, byte[] key) throws SQLException {
        try {
            Cipher chaChaCipher = Cipher.getInstance(CHA_CHA_CIPHER_NAME, this.provider);
            chaChaCipher.init(mode, (Key)new SecretKeySpec(key, CHA_CHA_CIPHER_NAME), iv.toParameterSpec());
            Cipher cipher = chaChaCipher;
            return cipher;
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw FbExceptionBuilder.forNonTransientException((int)337248281).messageParameter((Object)this.encryptionIdentifier()).cause((Throwable)e).toSQLException();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw FbExceptionBuilder.forNonTransientException((int)337248282).messageParameter((Object)this.encryptionIdentifier()).cause((Throwable)e).toSQLException();
        }
        finally {
            Arrays.fill(key, (byte)0);
        }
    }

    private class ChaCha64IV
    implements AutoCloseable {
        private final byte[] nonce;

        ChaCha64IV() throws SQLException {
            byte[] iv = ChaCha64EncryptionPlugin.this.cryptSessionConfig.specificData();
            if (iv == null || iv.length != 8) {
                throw FbExceptionBuilder.forNonTransientException((int)337248282).messageParameter((Object)ChaCha64EncryptionPlugin.this.encryptionIdentifier(), (Object)"Wrong IV length, needs 8 bytes").toSQLException();
            }
            this.nonce = (byte[])iv.clone();
        }

        IvParameterSpec toParameterSpec() {
            return new IvParameterSpec(this.nonce);
        }

        @Override
        public void close() {
            Arrays.fill(this.nonce, (byte)0);
        }
    }
}

