/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.ng.DefaultDatatypeCoder;

public final class LittleEndianDatatypeCoder
extends DefaultDatatypeCoder {
    public static LittleEndianDatatypeCoder forEncodingFactory(IEncodingFactory encodingFactory) {
        return (LittleEndianDatatypeCoder)encodingFactory.getOrCreateDatatypeCoder(LittleEndianDatatypeCoder.class, LittleEndianDatatypeCoder::new);
    }

    public LittleEndianDatatypeCoder(IEncodingFactory encodingFactory) {
        super(encodingFactory);
    }

    public int sizeOfShort() {
        return 2;
    }

    public void encodeShort(int val, byte[] buf, int off) {
        buf[off] = (byte)val;
        buf[off + 1] = (byte)(val >>> 8);
    }

    public short decodeShort(byte[] buf, int off) {
        return (short)((buf[off] & 0xFF) + (buf[off + 1] << 8));
    }

    public void encodeInt(int val, byte[] buf, int off) {
        buf[off] = (byte)val;
        buf[off + 1] = (byte)(val >>> 8);
        buf[off + 2] = (byte)(val >>> 16);
        buf[off + 3] = (byte)(val >>> 24);
    }

    public int decodeInt(byte[] buf, int off) {
        return (buf[off] & 0xFF) + ((buf[off + 1] & 0xFF) << 8) + ((buf[off + 2] & 0xFF) << 16) + (buf[off + 3] << 24);
    }

    public byte[] encodeLong(long val) {
        byte[] buf = new byte[]{(byte)val, (byte)(val >>> 8), (byte)(val >>> 16), (byte)(val >>> 24), (byte)(val >>> 32), (byte)(val >>> 40), (byte)(val >>> 48), (byte)(val >>> 56)};
        return buf;
    }

    public long decodeLong(byte[] buf) {
        if (buf == null) {
            return 0L;
        }
        return ((long)buf[0] & 0xFFL) + (((long)buf[1] & 0xFFL) << 8) + (((long)buf[2] & 0xFFL) << 16) + (((long)buf[3] & 0xFFL) << 24) + (((long)buf[4] & 0xFFL) << 32) + (((long)buf[5] & 0xFFL) << 40) + (((long)buf[6] & 0xFFL) << 48) + ((long)buf[7] << 56);
    }

    protected byte[] networkOrder(byte[] buf) {
        if (buf == null) {
            return null;
        }
        byte[] newArray = new byte[buf.length];
        int maxIndex = newArray.length - 1;
        for (int idx = 0; idx <= maxIndex; ++idx) {
            newArray[idx] = buf[maxIndex - idx];
        }
        return newArray;
    }
}

