/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.ptr.IntByReference;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.AbstractFbTransaction;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.jna.FbClientFeature;
import org.firebirdsql.gds.ng.jna.JnaDatabase;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.jaybird.util.Cleaners;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.jna.fbclient.ISC_STATUS;

public class JnaTransaction
extends AbstractFbTransaction {
    private static final System.Logger log = System.getLogger(JnaTransaction.class.getName());
    private final IntByReference handle;
    private final ISC_STATUS[] statusVector = new ISC_STATUS[20];
    private final FbClientLibrary clientLibrary;
    private final Cleaner.Cleanable cleanable;

    public JnaTransaction(JnaDatabase database, IntByReference transactionHandle, TransactionState initialState) {
        super(initialState, (FbDatabase)database);
        this.handle = transactionHandle;
        this.clientLibrary = database.getClientLibrary();
        this.cleanable = Cleaners.getJbCleaner().register((Object)this, new CleanupAction(transactionHandle, database));
    }

    public JnaDatabase getDatabase() {
        return (JnaDatabase)super.getDatabase();
    }

    public int getHandle() {
        return this.handle.getValue();
    }

    public IntByReference getJnaHandle() {
        return this.handle;
    }

    public void commit() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            JnaDatabase db = this.getDatabase();
            db.checkConnected();
            this.switchState(TransactionState.COMMITTING);
            this.clientLibrary.isc_commit_transaction(this.statusVector, this.handle);
            this.processStatusVector();
            this.switchState(TransactionState.COMMITTED);
            this.cleanable.clean();
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            this.logUnexpectedState(TransactionState.COMMITTED, log);
        }
    }

    public void rollback() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            JnaDatabase db = this.getDatabase();
            db.checkConnected();
            this.switchState(TransactionState.ROLLING_BACK);
            this.clientLibrary.isc_rollback_transaction(this.statusVector, this.handle);
            this.processStatusVector();
            this.switchState(TransactionState.ROLLED_BACK);
            this.cleanable.clean();
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            this.logUnexpectedState(TransactionState.ROLLED_BACK, log);
        }
    }

    public void prepare(byte[] recoveryInformation) throws SQLException {
        boolean noRecoveryInfo = recoveryInformation == null || recoveryInformation.length == 0;
        try (LockCloseable ignored = this.withLock();){
            JnaDatabase db = this.getDatabase();
            db.checkConnected();
            this.switchState(TransactionState.PREPARING);
            if (noRecoveryInfo) {
                this.clientLibrary.isc_prepare_transaction(this.statusVector, this.handle);
            } else {
                this.clientLibrary.isc_prepare_transaction2(this.statusVector, this.handle, (short)recoveryInformation.length, recoveryInformation);
            }
            this.processStatusVector();
            this.switchState(TransactionState.PREPARED);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            this.logUnexpectedState(TransactionState.PREPARED, log);
        }
    }

    public byte[] getTransactionInfo(byte[] requestItems, int maxBufferLength) throws SQLException {
        try {
            ByteBuffer responseBuffer = ByteBuffer.allocateDirect(maxBufferLength);
            try (LockCloseable ignored = this.withLock();){
                JnaDatabase db = this.getDatabase();
                db.checkConnected();
                this.clientLibrary.isc_transaction_info(this.statusVector, this.handle, (short)requestItems.length, requestItems, (short)maxBufferLength, responseBuffer);
                this.processStatusVector();
            }
            byte[] responseArray = new byte[maxBufferLength];
            responseBuffer.get(responseArray);
            return responseArray;
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    private void processStatusVector() throws SQLException {
        this.getDatabase().processStatusVector(this.statusVector, null);
    }

    private static final class CleanupAction
    implements Runnable,
    DatabaseListener {
        private final IntByReference handle;
        private volatile JnaDatabase database;

        private CleanupAction(IntByReference handle, JnaDatabase database) {
            this.handle = handle;
            this.database = database;
            database.addWeakDatabaseListener(this);
        }

        public void detaching(FbDatabase database) {
            this.database = null;
            database.removeDatabaseListener((DatabaseListener)this);
        }

        @Override
        public void run() {
            JnaDatabase database = this.database;
            if (database == null) {
                return;
            }
            this.detaching((FbDatabase)database);
            if (this.handle.getValue() == 0 || !database.hasFeature(FbClientFeature.FB_DISCONNECT_TRANSACTION) || !database.isAttached()) {
                return;
            }
            database.getClientLibrary().fb_disconnect_transaction(new ISC_STATUS[20], this.handle);
        }
    }
}

