/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.Memory;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.ShortByReference;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import org.firebirdsql.gds.ng.AbstractFbStatement;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.FetchDirection;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.OperationCloseHandle;
import org.firebirdsql.gds.ng.StatementState;
import org.firebirdsql.gds.ng.StatementType;
import org.firebirdsql.gds.ng.TransactionHelper;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.jna.FbClientFeature;
import org.firebirdsql.gds.ng.jna.JnaDatabase;
import org.firebirdsql.gds.ng.jna.JnaTransaction;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.jaybird.util.Cleaners;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.jna.fbclient.ISC_STATUS;
import org.firebirdsql.jna.fbclient.XSQLDA;
import org.firebirdsql.jna.fbclient.XSQLVAR;

public class JnaStatement
extends AbstractFbStatement {
    private static final System.Logger log = System.getLogger(JnaStatement.class.getName());
    private final IntByReference handle = new IntByReference(0);
    private final JnaDatabase database;
    private final ISC_STATUS[] statusVector = new ISC_STATUS[20];
    private final FbClientLibrary clientLibrary;
    private XSQLDA inXSqlDa;
    private XSQLDA outXSqlDa;
    private Cleaner.Cleanable cleanable = Cleaners.getNoOp();

    public JnaStatement(JnaDatabase database) {
        this.database = Objects.requireNonNull(database, "database");
        this.clientLibrary = database.getClientLibrary();
    }

    public final LockCloseable withLock() {
        return this.database.withLock();
    }

    protected void setParameterDescriptor(RowDescriptor parameterDescriptor) {
        XSQLDA xsqlda = this.allocateXSqlDa(parameterDescriptor);
        try (LockCloseable ignored = this.withLock();){
            this.inXSqlDa = xsqlda;
            super.setParameterDescriptor(parameterDescriptor);
        }
    }

    protected void setRowDescriptor(RowDescriptor fieldDescriptor) {
        XSQLDA xsqlda = this.allocateXSqlDa(fieldDescriptor);
        try (LockCloseable ignored = this.withLock();){
            this.outXSqlDa = xsqlda;
            super.setRowDescriptor(fieldDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void free(int option) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.clientLibrary.isc_dsql_free_statement(this.statusVector, this.handle, (short)option);
            this.processStatusVector();
            this.reset(option == 2);
        }
        finally {
            if (option == 2) {
                this.handle.setValue(0);
                this.cleanable.clean();
            }
        }
    }

    protected boolean isValidTransactionClass(Class<? extends FbTransaction> transactionClass) {
        return JnaTransaction.class.isAssignableFrom(transactionClass);
    }

    public JnaDatabase getDatabase() {
        return this.database;
    }

    public int getHandle() {
        return this.handle.getValue();
    }

    public JnaTransaction getTransaction() {
        return (JnaTransaction)super.getTransaction();
    }

    public void prepare(String statementText) throws SQLException {
        try {
            boolean useNulTerminated = false;
            byte[] statementArray = this.getDatabase().getEncoding().encodeToCharset(statementText);
            if (statementArray.length > 65536) {
                if (this.database.hasFeature(FbClientFeature.FB_PING)) {
                    statementArray = Arrays.copyOf(statementArray, statementArray.length + 1);
                    useNulTerminated = true;
                } else {
                    throw FbExceptionBuilder.forException((int)337248275).messageParameter(65536, statementArray.length).toSQLException();
                }
            }
            try (LockCloseable ignored = this.withLock();){
                StatementState initialState = this.checkPrepareAllowed();
                this.resetAll();
                JnaDatabase db = this.getDatabase();
                if (initialState == StatementState.NEW) {
                    this.allocateImpl(db);
                } else {
                    this.checkStatementValid();
                }
                this.prepareImpl(useNulTerminated, statementArray, db);
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    private void allocateImpl(JnaDatabase db) throws SQLException {
        try {
            this.clientLibrary.isc_dsql_allocate_statement(this.statusVector, db.getJnaHandle(), this.handle);
            if (this.handle.getValue() != 0) {
                this.cleanable = Cleaners.getJbCleaner().register((Object)this, new CleanupAction(this.handle, this.database));
            }
            this.processStatusVector();
            this.reset();
            this.switchState(StatementState.ALLOCATED);
            this.setType(StatementType.NONE);
        }
        catch (SQLException e) {
            this.forceState(StatementState.NEW);
            throw e;
        }
    }

    private void prepareImpl(boolean useNulTerminated, byte[] statementArray, JnaDatabase db) throws SQLException {
        this.switchState(StatementState.PREPARING);
        try {
            XSQLDA tempXSqlDa = new XSQLDA();
            tempXSqlDa.setAutoRead(false);
            this.clientLibrary.isc_dsql_prepare(this.statusVector, this.getTransaction().getJnaHandle(), this.handle, useNulTerminated ? (short)0 : (short)statementArray.length, statementArray, db.getConnectionDialect(), tempXSqlDa);
            this.processStatusVector();
            byte[] statementInfoRequestItems = this.getStatementInfoRequestItems();
            int responseLength = this.getDefaultSqlInfoSize();
            byte[] statementInfo = this.getSqlInfo(statementInfoRequestItems, responseLength);
            this.parseStatementInfo(statementInfo);
            this.switchState(StatementState.PREPARED);
        }
        catch (SQLException e) {
            this.switchState(StatementState.ALLOCATED);
            throw e;
        }
    }

    public void execute(RowValue parameters) throws SQLException {
        StatementState initialState = this.getState();
        try (LockCloseable ignored = this.withLock();){
            this.checkStatementValid();
            TransactionHelper.checkTransactionActive((FbTransaction)this.getTransaction());
            this.validateParameters(parameters);
            this.reset(false);
            this.switchState(StatementState.EXECUTING);
            this.updateStatementTimeout();
            this.setXSqlDaData(this.inXSqlDa, this.getParameterDescriptor(), parameters);
            StatementType statementType = this.getType();
            boolean hasSingletonResult = this.hasSingletonResult();
            try (OperationCloseHandle operationCloseHandle = this.signalExecute();){
                if (operationCloseHandle.isCancelled()) {
                    throw FbExceptionBuilder.toException((int)335544794);
                }
                if (hasSingletonResult) {
                    this.clientLibrary.isc_dsql_execute2(this.statusVector, this.getTransaction().getJnaHandle(), this.handle, this.inXSqlDa.version, this.inXSqlDa, this.outXSqlDa);
                } else {
                    this.clientLibrary.isc_dsql_execute(this.statusVector, this.getTransaction().getJnaHandle(), this.handle, this.inXSqlDa.version, this.inXSqlDa);
                }
                if (hasSingletonResult) {
                    this.statementListenerDispatcher.statementExecuted((FbStatement)this, false, true);
                    this.processStatusVector();
                    this.queueRowData(this.toRowValue(this.getRowDescriptor(), this.outXSqlDa));
                    this.setAfterLast();
                } else {
                    this.statementListenerDispatcher.statementExecuted((FbStatement)this, this.hasFields(), false);
                    this.processStatusVector();
                }
            }
            if (this.getState() != StatementState.ERROR) {
                this.switchState(statementType.isTypeWithCursor() ? StatementState.CURSOR_OPEN : StatementState.PREPARED);
            }
        }
        catch (SQLException e) {
            if (this.getState() != StatementState.ERROR) {
                this.switchState(initialState);
            }
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    protected void setXSqlDaData(XSQLDA xSqlDa, RowDescriptor rowDescriptor, RowValue parameters) {
        for (int idx = 0; idx < parameters.getCount(); ++idx) {
            XSQLVAR xSqlVar = xSqlDa.sqlvar[idx];
            xSqlVar.getSqlData().clear();
            byte[] fieldData = parameters.getFieldData(idx);
            if (fieldData == null) {
                xSqlVar.sqlind.setValue((short)-1);
                continue;
            }
            xSqlVar.sqlind.setValue((short)0);
            FieldDescriptor fieldDescriptor = rowDescriptor.getFieldDescriptor(idx);
            int bufferOffset = 0;
            if (fieldDescriptor.isVarying()) {
                xSqlVar.sqllen = (short)Math.min(fieldDescriptor.getLength(), fieldData.length);
                xSqlVar.writeField("sqllen");
                xSqlVar.sqldata.setShort(0L, (short)fieldData.length);
                bufferOffset = 2;
            } else if (fieldDescriptor.isFbType(452)) {
                xSqlVar.sqllen = (short)Math.min(fieldDescriptor.getLength(), fieldData.length);
                xSqlVar.writeField("sqllen");
                if (fieldDescriptor.getSubType() != 1) {
                    xSqlVar.sqldata.setMemory(0L, (long)(xSqlVar.sqllen & 0xFFFF), (byte)32);
                }
            }
            xSqlVar.sqldata.write((long)bufferOffset, fieldData, 0, fieldData.length);
        }
    }

    protected XSQLDA allocateXSqlDa(RowDescriptor rowDescriptor) {
        if (rowDescriptor == null || rowDescriptor.getCount() == 0) {
            XSQLDA xSqlDa = new XSQLDA(1);
            xSqlDa.setAutoSynch(false);
            xSqlDa.sqln = 0;
            xSqlDa.sqld = 0;
            xSqlDa.write();
            return xSqlDa;
        }
        XSQLDA xSqlDa = new XSQLDA(rowDescriptor.getCount());
        xSqlDa.setAutoSynch(false);
        for (int idx = 0; idx < rowDescriptor.getCount(); ++idx) {
            FieldDescriptor fieldDescriptor = rowDescriptor.getFieldDescriptor(idx);
            XSQLVAR xSqlVar = xSqlDa.sqlvar[idx];
            this.populateXSqlVar(fieldDescriptor, xSqlVar);
        }
        xSqlDa.write();
        return xSqlDa;
    }

    private void populateXSqlVar(FieldDescriptor fieldDescriptor, XSQLVAR xSqlVar) {
        xSqlVar.setAutoSynch(false);
        xSqlVar.sqltype = (short)(fieldDescriptor.getType() | 1);
        xSqlVar.sqlsubtype = (short)fieldDescriptor.getSubType();
        xSqlVar.sqlscale = (short)fieldDescriptor.getScale();
        xSqlVar.sqllen = (short)fieldDescriptor.getLength();
        xSqlVar.sqlind = new ShortByReference();
        int requiredDataSize = fieldDescriptor.isVarying() ? fieldDescriptor.getLength() + 3 : fieldDescriptor.getLength() + 1;
        xSqlVar.sqldata = new Memory((long)requiredDataSize);
        xSqlVar.write();
    }

    protected RowValue toRowValue(RowDescriptor rowDescriptor, XSQLDA xSqlDa) {
        RowValue row = rowDescriptor.createDefaultFieldValues();
        for (int idx = 0; idx < xSqlDa.sqlvar.length; ++idx) {
            int bufferLength;
            int bufferOffset;
            XSQLVAR xSqlVar = xSqlDa.sqlvar[idx];
            if (xSqlVar.sqlind.getValue() == -1) {
                row.setFieldData(idx, null);
                continue;
            }
            if (rowDescriptor.getFieldDescriptor(idx).isVarying()) {
                bufferOffset = 2;
                bufferLength = xSqlVar.sqldata.getShort(0L) & 0xFFFF;
            } else {
                bufferOffset = 0;
                bufferLength = xSqlVar.sqllen & 0xFFFF;
            }
            byte[] data = new byte[bufferLength];
            xSqlVar.sqldata.read((long)bufferOffset, data, 0, bufferLength);
            row.setFieldData(idx, data);
        }
        return row;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fetchRows(int fetchSize) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkStatementHasOpenCursor();
            this.checkFetchSize(fetchSize);
            if (this.isAfterLast()) {
                return;
            }
            try (OperationCloseHandle operationCloseHandle = this.signalFetch();){
                if (operationCloseHandle.isCancelled()) {
                    throw FbExceptionBuilder.toException((int)335544794);
                }
                ISC_STATUS fetchStatus = this.clientLibrary.isc_dsql_fetch(this.statusVector, this.handle, this.outXSqlDa.version, this.outXSqlDa);
                this.processStatusVector();
                switch (fetchStatus.intValue()) {
                    case 0: {
                        this.queueRowData(this.toRowValue(this.getRowDescriptor(), this.outXSqlDa));
                        this.statementListenerDispatcher.fetchComplete((FbStatement)this, FetchDirection.FORWARD, 1);
                        return;
                    }
                    case 100: {
                        this.statementListenerDispatcher.fetchComplete((FbStatement)this, FetchDirection.FORWARD, 0);
                        this.setAfterLast();
                        return;
                    }
                    default: {
                        String message = "Unexpected fetch status (expected 0 or 100): " + String.valueOf((Object)fetchStatus);
                        log.log(System.Logger.Level.DEBUG, message);
                        throw new SQLException(message, "HY000");
                    }
                }
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    public byte[] getSqlInfo(byte[] requestItems, int bufferLength) throws SQLException {
        try {
            ByteBuffer responseBuffer = ByteBuffer.allocateDirect(bufferLength);
            try (LockCloseable ignored = this.withLock();){
                this.checkStatementValid();
                this.clientLibrary.isc_dsql_sql_info(this.statusVector, this.handle, (short)requestItems.length, requestItems, (short)bufferLength, responseBuffer);
                this.processStatusVector();
            }
            byte[] responseArr = new byte[bufferLength];
            responseBuffer.get(responseArr);
            return responseArr;
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    public int getDefaultSqlInfoSize() {
        return this.getMaxSqlInfoSize();
    }

    public int getMaxSqlInfoSize() {
        return this.getDatabase().getServerVersion().isEqualOrAbove(2, 5) ? 65535 : Short.MAX_VALUE;
    }

    protected void setCursorNameImpl(String cursorName) throws SQLException {
        JnaDatabase db = this.getDatabase();
        this.clientLibrary.isc_dsql_set_cursor_name(this.statusVector, this.handle, db.getEncoding().encodeToCharset(cursorName + "\u0000"), (short)0);
        this.processStatusVector();
    }

    private void updateStatementTimeout() throws SQLException {
        if (!this.database.hasFeature(FbClientFeature.STATEMENT_TIMEOUT)) {
            return;
        }
        int allowedTimeout = (int)this.getAllowedTimeout();
        this.clientLibrary.fb_dsql_set_timeout(this.statusVector, this.handle, allowedTimeout);
        this.processStatusVector();
    }

    public final RowDescriptor emptyRowDescriptor() {
        return this.database.emptyRowDescriptor();
    }

    private void processStatusVector() throws SQLException {
        this.getDatabase().processStatusVector(this.statusVector, this.getStatementWarningCallback());
    }

    private static final class CleanupAction
    implements Runnable,
    DatabaseListener {
        private final IntByReference handle;
        private volatile JnaDatabase database;

        private CleanupAction(IntByReference handle, JnaDatabase database) {
            this.handle = handle;
            this.database = database;
            database.addWeakDatabaseListener(this);
        }

        public void detaching(FbDatabase database) {
            this.database = null;
            database.removeDatabaseListener((DatabaseListener)this);
        }

        @Override
        public void run() {
            JnaDatabase database = this.database;
            if (database == null) {
                return;
            }
            this.detaching((FbDatabase)database);
            if (this.handle.getValue() == 0 || !database.isAttached()) {
                return;
            }
            database.getClientLibrary().isc_dsql_free_statement(new ISC_STATUS[20], this.handle, (short)2);
        }
    }
}

