/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.ptr.IntByReference;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.ServiceParameterBufferImp;
import org.firebirdsql.gds.impl.ServiceRequestBufferImp;
import org.firebirdsql.gds.ng.AbstractConnection;
import org.firebirdsql.gds.ng.AbstractFbService;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.ParameterConverter;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.jna.JnaAttachment;
import org.firebirdsql.gds.ng.jna.JnaParameterConverter;
import org.firebirdsql.gds.ng.jna.JnaServiceConnection;
import org.firebirdsql.jaybird.util.Cleaners;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.jna.fbclient.ISC_STATUS;

public final class JnaService
extends AbstractFbService<JnaServiceConnection>
implements JnaAttachment {
    private static final ParameterConverter<?, JnaServiceConnection> PARAMETER_CONVERTER = new JnaParameterConverter();
    public static final int STATUS_VECTOR_SIZE = 20;
    private final FbClientLibrary clientLibrary;
    private final IntByReference handle = new IntByReference(0);
    private final ISC_STATUS[] statusVector = new ISC_STATUS[20];
    private Cleaner.Cleanable cleanable = Cleaners.getNoOp();

    public JnaService(JnaServiceConnection connection) {
        super((AbstractConnection)connection, connection.createDatatypeCoder());
        this.clientLibrary = connection.getClientLibrary();
    }

    private void setDetachedJna() {
        try {
            this.cleanable.clean();
        }
        finally {
            this.setDetached();
        }
    }

    public ServiceParameterBuffer createServiceParameterBuffer() {
        return new ServiceParameterBufferImp(ServiceParameterBufferImp.SpbMetaData.SPB_VERSION_2, this.getEncoding());
    }

    public ServiceRequestBuffer createServiceRequestBuffer() {
        return new ServiceRequestBufferImp(ServiceRequestBufferImp.SrbMetaData.SRB_VERSION_2, this.getEncoding());
    }

    protected void checkConnected() throws SQLException {
        if (!this.isAttached()) {
            throw FbExceptionBuilder.toException((int)337248274);
        }
    }

    public byte[] getServiceInfo(ServiceParameterBuffer serviceParameterBuffer, ServiceRequestBuffer serviceRequestBuffer, int maxBufferLength) throws SQLException {
        try {
            byte[] serviceParameterBufferBytes = serviceParameterBuffer == null ? null : serviceParameterBuffer.toBytes();
            byte[] serviceRequestBufferBytes = serviceRequestBuffer == null ? null : serviceRequestBuffer.toBytes();
            ByteBuffer responseBuffer = ByteBuffer.allocateDirect(maxBufferLength);
            try (LockCloseable ignored = this.withLock();){
                this.clientLibrary.isc_service_query(this.statusVector, this.handle, new IntByReference(0), (short)(serviceParameterBufferBytes != null ? serviceParameterBufferBytes.length : 0), serviceParameterBufferBytes, (short)(serviceRequestBufferBytes != null ? serviceRequestBufferBytes.length : 0), serviceRequestBufferBytes, (short)maxBufferLength, responseBuffer);
                this.processStatusVector();
            }
            byte[] responseArray = new byte[maxBufferLength];
            responseBuffer.get(responseArray);
            return responseArray;
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    public void startServiceAction(ServiceRequestBuffer serviceRequestBuffer) throws SQLException {
        byte[] serviceRequestBufferBytes = serviceRequestBuffer == null ? null : serviceRequestBuffer.toBytes();
        try (LockCloseable ignored = this.withLock();){
            this.clientLibrary.isc_service_start(this.statusVector, this.handle, new IntByReference(0), (short)(serviceRequestBufferBytes != null ? serviceRequestBufferBytes.length : 0), serviceRequestBufferBytes);
            this.processStatusVector();
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    public void attach() throws SQLException {
        try {
            this.requireNotAttached();
            try (LockCloseable ignored = this.withLock();){
                this.attachImpl();
                this.setAttached();
                this.afterAttachActions();
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    private void attachImpl() throws SQLException {
        try {
            byte[] spbArray = PARAMETER_CONVERTER.toServiceParameterBuffer((AbstractConnection)((JnaServiceConnection)this.connection)).toBytesWithType();
            byte[] serviceName = this.getEncoding().encodeToCharset(((JnaServiceConnection)this.connection).getAttachUrl());
            this.clientLibrary.isc_service_attach(this.statusVector, (short)serviceName.length, serviceName, this.handle, (short)spbArray.length, spbArray);
            if (this.handle.getValue() != 0) {
                this.cleanable = Cleaners.getJbCleaner().register(this, new CleanupAction(this.handle, this.clientLibrary));
            }
            this.processStatusVector();
        }
        catch (SQLException ex) {
            this.safelyDetach();
            throw ex;
        }
        catch (Exception ex) {
            this.safelyDetach();
            throw FbExceptionBuilder.forException((int)335544721).messageParameter((Object)((JnaServiceConnection)this.connection).getAttachUrl()).cause((Throwable)ex).toSQLException();
        }
    }

    private void afterAttachActions() throws SQLException {
        this.getServiceInfo(null, this.getDescribeServiceRequestBuffer(), 1024, this.getServiceInformationProcessor());
    }

    protected void internalDetach() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            try {
                this.clientLibrary.isc_service_detach(this.statusVector, this.handle);
                this.processStatusVector();
            }
            finally {
                this.setDetachedJna();
            }
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw FbExceptionBuilder.forException((int)335544721).messageParameter((Object)((JnaServiceConnection)this.connection).getAttachUrl()).cause((Throwable)ex).toSQLException();
        }
    }

    public int getHandle() {
        return this.handle.getValue();
    }

    public IntByReference getJnaHandle() {
        return this.handle;
    }

    public void setNetworkTimeout(int milliseconds) throws SQLException {
        throw new FBDriverNotCapableException("Setting network timeout not supported in native implementation");
    }

    public int getNetworkTimeout() throws SQLException {
        throw new FBDriverNotCapableException("Getting network timeout not supported in native implementation");
    }

    private void processStatusVector() throws SQLException {
        this.processStatusVector(this.statusVector, this.getServiceWarningCallback());
    }

    public void processStatusVector(ISC_STATUS[] statusVector, WarningMessageCallback warningMessageCallback) throws SQLException {
        if (warningMessageCallback == null) {
            warningMessageCallback = this.getServiceWarningCallback();
        }
        ((JnaServiceConnection)this.connection).processStatusVector(statusVector, warningMessageCallback);
    }

    private record CleanupAction(IntByReference handle, FbClientLibrary library) implements Runnable
    {
        @Override
        public void run() {
            if (this.handle.getValue() == 0) {
                return;
            }
            try {
                this.library.isc_service_detach(new ISC_STATUS[20], this.handle);
            }
            finally {
                this.handle.setValue(0);
            }
        }
    }
}

