/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.firebirdsql.gds.ConnectionParameterBuffer;
import org.firebirdsql.gds.ParameterTagMapping;
import org.firebirdsql.gds.ng.AbstractConnection;
import org.firebirdsql.gds.ng.AbstractParameterConverter;
import org.firebirdsql.gds.ng.IAttachProperties;
import org.firebirdsql.gds.ng.WireCrypt;
import org.firebirdsql.gds.ng.jna.JnaDatabaseConnection;
import org.firebirdsql.gds.ng.jna.JnaServiceConnection;

public class JnaParameterConverter
extends AbstractParameterConverter<JnaDatabaseConnection, JnaServiceConnection> {
    protected void populateAuthenticationProperties(AbstractConnection<?, ?> connection, ConnectionParameterBuffer pb) throws SQLException {
        String authPlugins;
        IAttachProperties props = connection.getAttachProperties();
        ParameterTagMapping tagMapping = pb.getTagMapping();
        if (props.getUser() != null) {
            pb.addArgument(tagMapping.getUserNameTag(), props.getUser());
        }
        if (props.getPassword() != null) {
            pb.addArgument(tagMapping.getPasswordTag(), props.getPassword());
        }
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (props.getWireCryptAsEnum() != WireCrypt.DEFAULT) {
            configMap.put("WireCrypt", props.getWireCrypt());
        }
        if ((authPlugins = props.getAuthPlugins()) != null && !authPlugins.isEmpty()) {
            configMap.put("AuthClient", authPlugins);
        }
        if (!configMap.isEmpty()) {
            String configString = this.buildConfigString(configMap);
            pb.addArgument(tagMapping.getConfigTag(), configString);
        }
    }

    private String buildConfigString(Map<String, String> configMap) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> configEntry : configMap.entrySet()) {
            builder.append(configEntry.getKey()).append('=').append(configEntry.getValue()).append('\n');
        }
        return builder.toString();
    }
}

