/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.Memory;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.EventHandler;
import org.firebirdsql.gds.ng.AbstractEventHandle;
import org.firebirdsql.gds.ng.jna.FbClientDatabaseFactory;
import org.firebirdsql.jaybird.util.Cleaners;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.jna.fbclient.WinFbClientLibrary;

public final class JnaEventHandle
extends AbstractEventHandle {
    private static final System.Logger log = System.getLogger(JnaEventHandle.class.getName());
    private final Memory eventNameMemory;
    private final IntByReference eventId = new IntByReference(0);
    private int size = -1;
    private final PointerByReference eventBuffer = new PointerByReference();
    private final PointerByReference resultBuffer = new PointerByReference();
    private final JnaEventCallback callback = this.createEventCallback();

    JnaEventHandle(String eventName, EventHandler eventHandler, Encoding encoding) {
        super(eventName, eventHandler);
        byte[] eventNameBytes = encoding.encodeToCharset(eventName + "\u0000");
        if (eventNameBytes.length > 256) {
            throw new IllegalArgumentException("Event name as bytes too long");
        }
        this.eventNameMemory = new Memory((long)eventNameBytes.length);
        this.eventNameMemory.write(0L, eventNameBytes, 0, eventNameBytes.length);
        Cleaners.getJbCleaner().register((Object)this, new CleanupAction(this.eventBuffer, this.resultBuffer));
    }

    protected void setEventCount(int eventCount) {
        super.setEventCount(eventCount);
    }

    public int getEventId() {
        return this.eventId.getValue();
    }

    IntByReference getJnaEventId() {
        return this.eventId;
    }

    Memory getEventNameMemory() {
        return this.eventNameMemory;
    }

    void setSize(int size) {
        this.size = size;
    }

    int getSize() {
        return this.size;
    }

    PointerByReference getEventBuffer() {
        return this.eventBuffer;
    }

    PointerByReference getResultBuffer() {
        return this.resultBuffer;
    }

    FbClientLibrary.IscEventCallback getCallback() {
        return this.callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugMemoryDump() {
        if (!log.isLoggable(System.Logger.Level.DEBUG)) {
            return;
        }
        if (this.size == -1) {
            log.log(System.Logger.Level.DEBUG, "Event handle not allocated");
        }
        Class<JnaEventHandle> clazz = JnaEventHandle.class;
        synchronized (JnaEventHandle.class) {
            log.log(System.Logger.Level.DEBUG, "{0}: Event Buffer: {1}, Result Buffer: {2}", this.getEventName(), this.getEventBuffer().getValue().dump(0L, this.size), this.getResultBuffer().getValue().dump(0L, this.size));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private JnaEventCallback createEventCallback() {
        return Platform.isWindows() ? new WinJnaEventCallback() : new JnaEventCallback();
    }

    public synchronized void releaseMemory(FbClientLibrary clientLibrary) {
        if (this.size == -1) {
            return;
        }
        try {
            new CleanupAction(this.eventBuffer, this.resultBuffer).cleanup(clientLibrary);
        }
        finally {
            this.size = -1;
        }
    }

    public String toString() {
        return "JnaEventHandle:{ name:" + this.getEventName() + ", eventId:" + this.getEventId() + " }";
    }

    private class JnaEventCallback
    implements FbClientLibrary.IscEventCallback {
        private JnaEventCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply(Pointer resultArgument, short eventBufferLength, Pointer eventsList) {
            int length = eventBufferLength & 0xFFFF;
            if (length == 0 || eventsList == null) {
                return;
            }
            JnaEventHandle jnaEventHandle = JnaEventHandle.this;
            synchronized (jnaEventHandle) {
                byte[] tempBuffer = eventsList.getByteArray(0L, length);
                resultArgument.write(0L, tempBuffer, 0, length);
            }
            JnaEventHandle.this.onEventOccurred();
        }
    }

    private record CleanupAction(PointerByReference eventBuffer, PointerByReference resultBuffer) implements Runnable
    {
        @Override
        public void run() {
            this.cleanup(FbClientDatabaseFactory.getInstance().getClientLibrary());
        }

        private void cleanup(FbClientLibrary clientLibrary) {
            if (this.eventBuffer.getValue() != Pointer.NULL) {
                clientLibrary.isc_free(this.eventBuffer.getValue());
                this.eventBuffer.setValue(Pointer.NULL);
            }
            if (this.resultBuffer.getValue() != Pointer.NULL) {
                clientLibrary.isc_free(this.resultBuffer.getValue());
                this.resultBuffer.setValue(Pointer.NULL);
            }
        }
    }

    private class WinJnaEventCallback
    extends JnaEventCallback
    implements WinFbClientLibrary.IscEventStdCallback {
        private WinJnaEventCallback() {
        }
    }
}

