/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import java.sql.SQLException;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.impl.DbAttachInfo;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.jna.JnaConnection;
import org.firebirdsql.gds.ng.jna.JnaDatabase;
import org.firebirdsql.jna.fbclient.FbClientLibrary;

public class JnaDatabaseConnection
extends JnaConnection<IConnectionProperties, JnaDatabase> {
    public JnaDatabaseConnection(FbClientLibrary clientLibrary, IConnectionProperties connectionProperties) throws SQLException {
        this(clientLibrary, connectionProperties, EncodingFactory.getPlatformDefault());
    }

    public JnaDatabaseConnection(FbClientLibrary clientLibrary, IConnectionProperties connectionProperties, IEncodingFactory encodingFactory) throws SQLException {
        super(clientLibrary, connectionProperties, encodingFactory);
    }

    @Override
    protected String createAttachUrl(DbAttachInfo dbAttachInfo, IConnectionProperties connectionProperties) throws SQLException {
        if (!dbAttachInfo.hasAttachObjectName()) {
            throw FbExceptionBuilder.forNonTransientConnectionException((int)337248263).messageParameter((Object)connectionProperties.getAttachObjectName(), (Object)"null or empty database name in connection string").toSQLException();
        }
        return JnaDatabaseConnection.toAttachUrl(dbAttachInfo);
    }

    public JnaDatabase identify() throws SQLException {
        return new JnaDatabase(this);
    }
}

