/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.Pointer;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Objects;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.impl.DbAttachInfo;
import org.firebirdsql.gds.ng.AbstractConnection;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.IAttachProperties;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.jna.BigEndianDatatypeCoder;
import org.firebirdsql.gds.ng.jna.JnaAttachment;
import org.firebirdsql.gds.ng.jna.LittleEndianDatatypeCoder;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.jna.fbclient.ISC_STATUS;

public abstract class JnaConnection<T extends IAttachProperties<T>, C extends JnaAttachment>
extends AbstractConnection<T, C> {
    private static final boolean BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    private final FbClientLibrary clientLibrary;
    private final String attachUrl;

    protected JnaConnection(FbClientLibrary clientLibrary, T attachProperties, IEncodingFactory encodingFactory) throws SQLException {
        super(attachProperties, encodingFactory);
        this.clientLibrary = Objects.requireNonNull(clientLibrary, "parameter clientLibrary cannot be null");
        this.attachUrl = this.createAttachUrl(this.toDbAttachInfo(attachProperties), attachProperties);
    }

    private DbAttachInfo toDbAttachInfo(T attachProperties) throws SQLException {
        DbAttachInfo initialDbAttachInfo = DbAttachInfo.of(attachProperties);
        if (!initialDbAttachInfo.hasServerName() && initialDbAttachInfo.hasAttachObjectName() && initialDbAttachInfo.attachObjectName().startsWith("//")) {
            return DbAttachInfo.parseConnectString((String)initialDbAttachInfo.attachObjectName());
        }
        return initialDbAttachInfo;
    }

    protected abstract String createAttachUrl(DbAttachInfo var1, T var2) throws SQLException;

    public final FbClientLibrary getClientLibrary() {
        return this.clientLibrary;
    }

    protected void processStatusVector(ISC_STATUS[] statusVector, WarningMessageCallback warningMessageCallback) throws SQLException {
        Objects.requireNonNull(warningMessageCallback, "warningMessageCallback");
        FbExceptionBuilder builder = new FbExceptionBuilder();
        this.populateExceptionBuilder(statusVector, builder);
        if (builder.isEmpty()) {
            return;
        }
        SQLException exception = builder.toFlatSQLException();
        if (!(exception instanceof SQLWarning)) {
            throw exception;
        }
        SQLWarning warning = (SQLWarning)exception;
        warningMessageCallback.processWarning(warning);
    }

    private void populateExceptionBuilder(ISC_STATUS[] statusVector, FbExceptionBuilder builder) {
        int vectorIndex = 0;
        block8: while (vectorIndex < statusVector.length) {
            switch (statusVector[vectorIndex++].intValue()) {
                case 1: {
                    int errorCode;
                    if ((errorCode = statusVector[vectorIndex++].intValue()) == 0) continue block8;
                    builder.exception(errorCode);
                    continue block8;
                }
                case 18: {
                    int errorCode;
                    if ((errorCode = statusVector[vectorIndex++].intValue()) == 0) continue block8;
                    builder.warning(errorCode);
                    continue block8;
                }
                case 2: 
                case 5: {
                    String stringValue = this.getString(statusVector[vectorIndex++]);
                    if (stringValue == null) {
                        return;
                    }
                    builder.messageParameter((Object)stringValue);
                    continue block8;
                }
                case 19: {
                    String stringValue = this.getString(statusVector[vectorIndex++]);
                    if (stringValue == null) {
                        return;
                    }
                    builder.sqlState(stringValue);
                    continue block8;
                }
                case 3: {
                    builder.messageParameter((Object)this.getCString(statusVector[vectorIndex++], statusVector[vectorIndex++]));
                    continue block8;
                }
                case 0: {
                    return;
                }
            }
            builder.messageParameter(statusVector[vectorIndex++].intValue());
        }
    }

    private String getCString(ISC_STATUS lengthStatus, ISC_STATUS pointerStatus) {
        Pointer cStringPointer = new Pointer(pointerStatus.longValue());
        byte[] stringData = cStringPointer.getByteArray(0L, lengthStatus.intValue());
        return this.getEncoding().decodeFromCharset(stringData);
    }

    private String getString(ISC_STATUS iscStatus) {
        long stringPointerAddress = iscStatus.longValue();
        if (stringPointerAddress == 0L) {
            System.getLogger(((Object)((Object)this)).getClass().getName()).log(System.Logger.Level.WARNING, "Received NULL pointer address for isc_arg_interpreted, isc_arg_string or isc_arg_sql_state");
            return null;
        }
        Pointer stringPointer = new Pointer(stringPointerAddress);
        return stringPointer.getString(0L, this.getEncodingDefinition().getJavaEncodingName());
    }

    final DatatypeCoder createDatatypeCoder() {
        if (BIG_ENDIAN) {
            return BigEndianDatatypeCoder.forEncodingFactory(this.getEncodingFactory());
        }
        return LittleEndianDatatypeCoder.forEncodingFactory(this.getEncodingFactory());
    }

    public String getAttachUrl() {
        return this.attachUrl;
    }

    protected static String toAttachUrl(DbAttachInfo dbAttachInfo) {
        boolean ipv6;
        if (!dbAttachInfo.hasServerName()) {
            return dbAttachInfo.attachObjectName();
        }
        String serverName = dbAttachInfo.serverName();
        String attachObjectName = dbAttachInfo.attachObjectName();
        StringBuilder sb = new StringBuilder(serverName.length() + attachObjectName.length() + 4);
        boolean bl = ipv6 = serverName.indexOf(58) != -1;
        if (ipv6) {
            sb.append('[').append(serverName).append(']');
        } else {
            sb.append(serverName);
        }
        sb.append('/').append(dbAttachInfo.portNumber()).append(':').append(attachObjectName);
        return sb.toString();
    }
}

