/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.lang.ref.Cleaner;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.firebirdsql.gds.ng.IAttachProperties;
import org.firebirdsql.gds.ng.jna.AbstractNativeDatabaseFactory;
import org.firebirdsql.gds.ng.jna.NativeLibraryLoadException;
import org.firebirdsql.gds.ng.jna.NativeResourceTracker;
import org.firebirdsql.jaybird.util.Cleaners;
import org.firebirdsql.jna.embedded.FirebirdEmbeddedLookup;
import org.firebirdsql.jna.embedded.spi.DisposableFirebirdEmbeddedLibrary;
import org.firebirdsql.jna.embedded.spi.FirebirdEmbeddedLibrary;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.jna.fbclient.WinFbClientLibrary;

public final class FbEmbeddedDatabaseFactory
extends AbstractNativeDatabaseFactory {
    private static final System.Logger log = System.getLogger(FbEmbeddedDatabaseFactory.class.getName());
    private static final List<String> LIBRARIES_TO_TRY = List.of("fbembed", "fbclient");
    private static final FbEmbeddedDatabaseFactory INSTANCE = new FbEmbeddedDatabaseFactory();

    private FbEmbeddedDatabaseFactory() {
    }

    public static FbEmbeddedDatabaseFactory getInstance() {
        return INSTANCE;
    }

    @Override
    protected <T extends IAttachProperties<T>> T filterProperties(T attachProperties) {
        IAttachProperties attachPropertiesCopy = attachProperties.asNewMutable();
        attachPropertiesCopy.setServerName(null);
        return (T)attachPropertiesCopy;
    }

    @Override
    protected Collection<String> defaultLibraryNames() {
        return LIBRARIES_TO_TRY;
    }

    @Override
    protected FbClientLibrary createClientLibrary() {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        List<String> librariesToTry = this.findLibrariesToTry();
        for (String libraryName : librariesToTry) {
            try {
                if (Platform.isWindows()) {
                    return (FbClientLibrary)Native.load((String)libraryName, WinFbClientLibrary.class);
                }
                return (FbClientLibrary)Native.load((String)libraryName, FbClientLibrary.class);
            }
            catch (RuntimeException | UnsatisfiedLinkError e) {
                throwables.add(e);
                log.log(System.Logger.Level.DEBUG, () -> "Attempt to load %s failed".formatted(libraryName), e);
            }
        }
        assert (throwables.size() == librariesToTry.size());
        if (log.isLoggable(System.Logger.Level.ERROR)) {
            log.log(System.Logger.Level.ERROR, "Could not load any of the libraries in {0}:", librariesToTry);
            for (int idx = 0; idx < librariesToTry.size(); ++idx) {
                log.log(System.Logger.Level.ERROR, "Loading %s failed".formatted(librariesToTry.get(idx)), (Throwable)throwables.get(idx));
            }
        }
        throw new NativeLibraryLoadException("Could not load any of " + String.valueOf(librariesToTry) + "; linking first exception", (Throwable)throwables.get(0));
    }

    private List<String> findLibrariesToTry() {
        Optional<FirebirdEmbeddedLibrary> optionalFbEmbeddedInstance = FirebirdEmbeddedLookup.findFirebirdEmbedded();
        if (optionalFbEmbeddedInstance.isPresent()) {
            FirebirdEmbeddedLibrary firebirdEmbeddedLibrary = optionalFbEmbeddedInstance.get();
            log.log(System.Logger.Level.INFO, "Found Firebird Embedded {0} on classpath", firebirdEmbeddedLibrary.getVersion());
            if (firebirdEmbeddedLibrary instanceof DisposableFirebirdEmbeddedLibrary) {
                DisposableFirebirdEmbeddedLibrary disposableLibrary = (DisposableFirebirdEmbeddedLibrary)firebirdEmbeddedLibrary;
                NativeResourceTracker.strongRegisterNativeResource(new FirebirdEmbeddedLibraryNativeResource(disposableLibrary));
            }
            Path entryPointPath = firebirdEmbeddedLibrary.getEntryPointPath().toAbsolutePath();
            ArrayList<String> librariesToTry = new ArrayList<String>(LIBRARIES_TO_TRY.size() + 1);
            librariesToTry.add(entryPointPath.toString());
            librariesToTry.addAll(LIBRARIES_TO_TRY);
            return librariesToTry;
        }
        return LIBRARIES_TO_TRY;
    }

    private static final class FirebirdEmbeddedLibraryNativeResource
    extends NativeResourceTracker.NativeResource {
        private final Cleaner.Cleanable cleanable;

        private FirebirdEmbeddedLibraryNativeResource(DisposableFirebirdEmbeddedLibrary firebirdEmbeddedLibrary) {
            Objects.requireNonNull(firebirdEmbeddedLibrary, "firebirdEmbeddedLibrary");
            this.cleanable = Cleaners.getJbCleaner().register(this, new DisposeAction(firebirdEmbeddedLibrary));
        }

        @Override
        void dispose() {
            this.cleanable.clean();
        }

        private record DisposeAction(DisposableFirebirdEmbeddedLibrary firebirdEmbeddedLibrary) implements Runnable
        {
            @Override
            public void run() {
                this.firebirdEmbeddedLibrary.dispose();
            }
        }
    }
}

