/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.NativeLibrary;
import java.lang.ref.Cleaner;
import java.lang.reflect.Proxy;
import org.firebirdsql.gds.ng.jna.AbstractNativeDatabaseFactory;
import org.firebirdsql.gds.ng.jna.FbClientFeatureAccessHandler;
import org.firebirdsql.gds.ng.jna.NativeResourceTracker;
import org.firebirdsql.jaybird.util.Cleaners;
import org.firebirdsql.jna.fbclient.FbClientLibrary;

final class FbClientResource
extends NativeResourceTracker.NativeResource {
    private volatile FbClientLibrary library;
    private final AbstractNativeDatabaseFactory owner;
    private final Cleaner.Cleanable cleanable;

    FbClientResource(FbClientLibrary library, AbstractNativeDatabaseFactory owner) {
        this.library = library;
        this.owner = owner;
        this.cleanable = NativeResourceTracker.isNativeResourceShutdownDisabled() ? Cleaners.getNoOp() : Cleaners.getJbCleaner().register(this, new DisposeAction(library));
    }

    FbClientLibrary get() {
        FbClientLibrary local = this.library;
        if (local == null) {
            throw new IllegalStateException("Library was already disposed");
        }
        return local;
    }

    @Override
    void dispose() {
        FbClientLibrary local = this.library;
        if (local == null) {
            return;
        }
        try {
            this.disposeImpl();
        }
        catch (Throwable e) {
            System.getLogger(FbClientResource.class.getName()).log(System.Logger.Level.ERROR, "Error disposing of " + String.valueOf(local), e);
        }
    }

    private void disposeImpl() {
        FbClientLibrary local = this.library;
        if (local == null) {
            return;
        }
        try {
            this.owner.disposing(this, () -> {
                this.library = null;
            });
        }
        finally {
            this.cleanable.clean();
        }
    }

    private record DisposeAction(FbClientLibrary library) implements Runnable
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.Logger log = System.getLogger(FbClientResource.class.getName());
            try {
                log.log(System.Logger.Level.TRACE, "Calling fb_shutdown on {0}", this.library);
                this.library.fb_shutdown(0, 1);
            }
            catch (Throwable throwable) {
                FbClientFeatureAccessHandler handler = (FbClientFeatureAccessHandler)Proxy.getInvocationHandler(this.library);
                NativeLibrary nativeLibrary = handler.getNativeLibrary();
                log.log(System.Logger.Level.TRACE, "Disposing JNA native library {0}", nativeLibrary);
                try {
                    nativeLibrary.dispose();
                }
                catch (Throwable e) {
                    log.log(System.Logger.Level.ERROR, "Error disposing of " + String.valueOf(nativeLibrary), e);
                }
                throw throwable;
            }
            FbClientFeatureAccessHandler handler = (FbClientFeatureAccessHandler)Proxy.getInvocationHandler(this.library);
            NativeLibrary nativeLibrary = handler.getNativeLibrary();
            log.log(System.Logger.Level.TRACE, "Disposing JNA native library {0}", nativeLibrary);
            try {
                nativeLibrary.dispose();
            }
            catch (Throwable e) {
                log.log(System.Logger.Level.ERROR, "Error disposing of " + String.valueOf(nativeLibrary), e);
            }
        }
    }
}

