/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.util.Collection;
import java.util.List;
import org.firebirdsql.gds.ng.jna.AbstractNativeDatabaseFactory;
import org.firebirdsql.gds.ng.jna.NativeLibraryLoadException;
import org.firebirdsql.jna.fbclient.FbClientLibrary;
import org.firebirdsql.jna.fbclient.WinFbClientLibrary;

public final class FbClientDatabaseFactory
extends AbstractNativeDatabaseFactory {
    private static final FbClientDatabaseFactory INSTANCE = new FbClientDatabaseFactory();
    static final String LIBRARY_NAME_FBCLIENT = "fbclient";

    private FbClientDatabaseFactory() {
    }

    public static FbClientDatabaseFactory getInstance() {
        return INSTANCE;
    }

    @Override
    protected FbClientLibrary createClientLibrary() {
        try {
            if (Platform.isWindows()) {
                return (FbClientLibrary)Native.load((String)LIBRARY_NAME_FBCLIENT, WinFbClientLibrary.class);
            }
            return (FbClientLibrary)Native.load((String)LIBRARY_NAME_FBCLIENT, FbClientLibrary.class);
        }
        catch (RuntimeException | UnsatisfiedLinkError e) {
            throw new NativeLibraryLoadException("Could not load fbclient", e);
        }
    }

    @Override
    protected Collection<String> defaultLibraryNames() {
        return List.of(LIBRARY_NAME_FBCLIENT);
    }
}

