/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import com.sun.jna.NativeLibrary;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.firebirdsql.gds.ng.FbDatabaseFactory;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.IAttachProperties;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.IServiceProperties;
import org.firebirdsql.gds.ng.jna.FbClientFeatureAccessHandler;
import org.firebirdsql.gds.ng.jna.FbClientResource;
import org.firebirdsql.gds.ng.jna.JnaDatabase;
import org.firebirdsql.gds.ng.jna.JnaDatabaseConnection;
import org.firebirdsql.gds.ng.jna.JnaService;
import org.firebirdsql.gds.ng.jna.JnaServiceConnection;
import org.firebirdsql.gds.ng.jna.NativeLibraryLoadException;
import org.firebirdsql.gds.ng.jna.NativeResourceTracker;
import org.firebirdsql.jna.fbclient.FbClientLibrary;

public abstract class AbstractNativeDatabaseFactory
implements FbDatabaseFactory {
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private FbClientResource resource;

    public JnaDatabase connect(IConnectionProperties connectionProperties) throws SQLException {
        this.configureSearchPath((IAttachProperties<?>)connectionProperties);
        try {
            JnaDatabaseConnection jnaDatabaseConnection = new JnaDatabaseConnection(this.getClientLibrary(), this.filterProperties(connectionProperties));
            return jnaDatabaseConnection.identify();
        }
        catch (NativeLibraryLoadException e) {
            throw FbExceptionBuilder.forNonTransientConnectionException((int)337248294).cause((Throwable)e).toSQLException();
        }
    }

    public JnaService serviceConnect(IServiceProperties serviceProperties) throws SQLException {
        this.configureSearchPath((IAttachProperties<?>)serviceProperties);
        try {
            JnaServiceConnection jnaServiceConnection = new JnaServiceConnection(this.getClientLibrary(), this.filterProperties(serviceProperties));
            return jnaServiceConnection.identify();
        }
        catch (NativeLibraryLoadException e) {
            throw FbExceptionBuilder.forNonTransientConnectionException((int)337248294).cause((Throwable)e).toSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FbClientLibrary getClientLibrary() {
        Lock readLock = this.rwLock.readLock();
        readLock.lock();
        if (this.resource == null) {
            readLock.unlock();
            Lock writeLock = this.rwLock.writeLock();
            writeLock.lock();
            try {
                if (this.resource == null) {
                    FbClientLibrary newLibrary = FbClientFeatureAccessHandler.decorateWithFeatureAccess(this.createClientLibrary());
                    this.resource = NativeResourceTracker.registerNativeResource(new FbClientResource(newLibrary, this));
                }
                readLock.lock();
            }
            finally {
                writeLock.unlock();
            }
        }
        try {
            FbClientLibrary fbClientLibrary = this.resource.get();
            return fbClientLibrary;
        }
        finally {
            readLock.unlock();
        }
    }

    protected abstract FbClientLibrary createClientLibrary();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void disposing(FbClientResource disposedResource, Runnable disposeAction) {
        if (disposedResource == null) {
            throw new IllegalStateException("disposedResource was null");
        }
        Lock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            if (this.resource != disposedResource) {
                throw new IllegalStateException("disposedResource does not match current resource");
            }
        }
        finally {
            readLock.unlock();
        }
        Lock writeLock = this.rwLock.writeLock();
        writeLock.lock();
        try {
            this.resource = null;
            disposeAction.run();
        }
        finally {
            writeLock.unlock();
        }
    }

    protected <T extends IAttachProperties<T>> T filterProperties(T attachProperties) {
        return attachProperties;
    }

    protected abstract Collection<String> defaultLibraryNames();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureSearchPath(IAttachProperties<?> connectionProperties) {
        if (this.resource != null) {
            return;
        }
        String nativeLibraryPath = connectionProperties.getProperty("nativeLibraryPath");
        if (nativeLibraryPath == null || nativeLibraryPath.isBlank()) {
            return;
        }
        String pathForJna = this.resolvePathForJna(nativeLibraryPath);
        if (pathForJna == null) {
            return;
        }
        Lock readLock = this.rwLock.readLock();
        readLock.lock();
        try {
            if (this.resource != null) {
                return;
            }
            for (String library : this.defaultLibraryNames()) {
                NativeLibrary.addSearchPath((String)library, (String)pathForJna);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    private String resolvePathForJna(String nativeLibraryPath) {
        System.Logger log = System.getLogger(this.getClass().getName());
        try {
            Path actualPath = Path.of(nativeLibraryPath, new String[0]).toAbsolutePath();
            if (Files.isRegularFile(actualPath, new LinkOption[0])) {
                actualPath = actualPath.getParent();
                log.log(System.Logger.Level.TRACE, "nativeLibraryPath ''{0}'' was a file, using parent ''{1}''", nativeLibraryPath, actualPath);
            }
            if (!Files.isDirectory(actualPath, new LinkOption[0])) {
                log.log(System.Logger.Level.TRACE, "nativeLibraryPath ''{0}'' does not resolve to an existing directory ({1})", nativeLibraryPath, actualPath);
                return null;
            }
            log.log(System.Logger.Level.TRACE, "resolved nativeLibraryPath ''{0}'' to path ''{1}''", nativeLibraryPath, actualPath);
            return actualPath.toString();
        }
        catch (InvalidPathException e) {
            log.log(System.Logger.Level.TRACE, "nativeLibraryPath ''{0}'' is not a valid path: {1}", nativeLibraryPath, e);
            return null;
        }
    }
}

