/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.jni;

import java.sql.SQLException;
import java.util.List;
import org.firebirdsql.gds.impl.BaseGDSFactoryPlugin;
import org.firebirdsql.gds.ng.jna.FbClientDatabaseFactory;

public final class NativeGDSFactoryPlugin
extends BaseGDSFactoryPlugin {
    public static final String NATIVE_TYPE_NAME = "NATIVE";
    private static final List<String> TYPE_ALIASES = List.of("TYPE2", "LOCAL");
    private static final String DEFAULT_PROTOCOL = "jdbc:firebirdsql:native:";
    private static final List<String> JDBC_PROTOCOLS = List.of("jdbc:firebirdsql:native:", "jdbc:firebird:native:", "jdbc:firebirdsql:local:", "jdbc:firebird:local:");

    public String getPluginName() {
        return "JNA-based GDS implementation";
    }

    public String getTypeName() {
        return NATIVE_TYPE_NAME;
    }

    @Deprecated(since="6", forRemoval=true)
    public String[] getTypeAliases() {
        return TYPE_ALIASES.toArray(new String[0]);
    }

    public List<String> getTypeAliasList() {
        return TYPE_ALIASES;
    }

    @Deprecated(since="6", forRemoval=true)
    public String[] getSupportedProtocols() {
        return JDBC_PROTOCOLS.toArray(new String[0]);
    }

    public List<String> getSupportedProtocolList() {
        return JDBC_PROTOCOLS;
    }

    public String getDefaultProtocol() {
        return DEFAULT_PROTOCOL;
    }

    public String getDatabasePath(String server, Integer port, String path) throws SQLException {
        NativeGDSFactoryPlugin.requirePath((String)path);
        if (server == null) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(server);
        if (port != null) {
            sb.append('/').append(port);
        }
        sb.append(':').append(path);
        return sb.toString();
    }

    public FbClientDatabaseFactory getDatabaseFactory() {
        return FbClientDatabaseFactory.getInstance();
    }
}

