/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.StatementListener;
import org.firebirdsql.jdbc.AbstractFetcher;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FetchConfig;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.JdbcTypeConverter;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class FBCachedFetcher
extends AbstractFetcher
implements FBFetcher {
    private List<RowValue> rows;
    private int rowNum;
    private final Supplier<LockCloseable> lockAction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FBCachedFetcher(GDSHelper gdsHelper, FetchConfig fetchConfig, FbStatement stmtHandle, FBObjectListener.FetcherListener fetcherListener) throws SQLException {
        super(fetchConfig, fetcherListener);
        this.lockAction = stmtHandle::withLock;
        try {
            RowListener rowListener = new RowListener();
            stmtHandle.addStatementListener(rowListener);
            try {
                int actualFetchSize = this.actualFetchSize();
                int maxRows = this.getMaxRows();
                while (!(rowListener.isAllRowsFetched() || maxRows != 0 && rowListener.size() >= maxRows)) {
                    if (maxRows > 0) {
                        actualFetchSize = Math.min(actualFetchSize, maxRows - rowListener.size());
                    }
                    stmtHandle.fetchRows(actualFetchSize);
                }
                this.rows = rowListener.getRows();
            }
            finally {
                stmtHandle.removeStatementListener(rowListener);
            }
            RowDescriptor rowDescriptor = stmtHandle.getRowDescriptor();
            boolean[] isBlob = FBCachedFetcher.determineBlobs(rowDescriptor);
            if (isBlob != null) {
                for (RowValue row : this.rows) {
                    FBCachedFetcher.cacheBlobsInRow(gdsHelper, rowDescriptor, isBlob, row);
                }
            }
        }
        finally {
            stmtHandle.closeCursor();
        }
    }

    FBCachedFetcher(List<RowValue> rows, FetchConfig fetchConfig, FBObjectListener.FetcherListener fetcherListener, RowDescriptor rowDescriptor, @Nullable GDSHelper gdsHelper, boolean retrieveBlobs) throws SQLException {
        super(fetchConfig, fetcherListener);
        boolean[] isBlob;
        assert (!retrieveBlobs || rowDescriptor != null && gdsHelper != null) : "Need non-null rowDescriptor and gdsHelper for retrieving blobs";
        this.rows = new ArrayList<RowValue>(rows);
        if (retrieveBlobs && (isBlob = FBCachedFetcher.determineBlobs(rowDescriptor)) != null) {
            for (RowValue row : rows) {
                FBCachedFetcher.cacheBlobsInRow(gdsHelper, rowDescriptor, isBlob, row);
            }
        }
        this.lockAction = gdsHelper != null ? gdsHelper::withLock : () -> LockCloseable.NO_OP;
    }

    private static boolean @Nullable [] determineBlobs(RowDescriptor rowDescriptor) {
        boolean hasBlobs = false;
        boolean[] isBlob = new boolean[rowDescriptor.getCount()];
        for (int i = 0; i < rowDescriptor.getCount(); ++i) {
            FieldDescriptor field = rowDescriptor.getFieldDescriptor(i);
            boolean bl = isBlob[i] = JdbcTypeConverter.isJdbcType(field, 2004) || JdbcTypeConverter.isJdbcType(field, -4) || JdbcTypeConverter.isJdbcType(field, -1);
            if (!isBlob[i]) continue;
            hasBlobs = true;
        }
        return (boolean[])(hasBlobs ? isBlob : null);
    }

    private static void cacheBlobsInRow(GDSHelper gdsHelper, RowDescriptor rowDescriptor, boolean[] isBlob, RowValue localRow) throws SQLException {
        for (int j = 0; j < localRow.getCount(); ++j) {
            final byte[] tempData = localRow.getFieldData(j);
            if (!isBlob[j] || tempData == null) continue;
            FieldDataProvider dataProvider = new FieldDataProvider(){

                @Override
                public byte[] getFieldData() {
                    return tempData;
                }

                @Override
                public void setFieldData(byte[] data) {
                    throw new UnsupportedOperationException();
                }
            };
            FBFlushableField blob = (FBFlushableField)((Object)FBField.createField(rowDescriptor.getFieldDescriptor(j), dataProvider, gdsHelper, false));
            localRow.setFieldData(j, blob.getCachedData());
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isEmpty()) {
            return false;
        }
        ++this.rowNum;
        if (this.adjustIfPositionAfterLast()) {
            return false;
        }
        this.notifyRowChanged(this.rows.get(this.rowNum - 1));
        return true;
    }

    private boolean adjustIfPositionAfterLast() throws SQLException {
        if (this.isAfterLast()) {
            this.notifyRowChanged(null);
            this.rowNum = this.rows.size() + 1;
            return true;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.isEmpty()) {
            return false;
        }
        --this.rowNum;
        if (this.adjustPositionIfBeforeFirst()) {
            return false;
        }
        this.notifyRowChanged(this.rows.get(this.rowNum - 1));
        return true;
    }

    private boolean adjustPositionIfBeforeFirst() throws SQLException {
        if (this.isBeforeFirst()) {
            this.notifyRowChanged(null);
            this.rowNum = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return this.setRowNum(row);
    }

    private boolean setRowNum(int row) throws SQLException {
        if (this.isEmpty()) {
            return false;
        }
        if (row < 0) {
            row = this.rows.size() + row + 1;
        }
        this.rowNum = row;
        if (this.adjustPositionIfBeforeFirst() || this.adjustIfPositionAfterLast()) {
            return false;
        }
        this.notifyRowChanged(this.rows.get(this.rowNum - 1));
        return true;
    }

    @Override
    public boolean first() throws SQLException {
        return this.setRowNum(1);
    }

    @Override
    public boolean last() throws SQLException {
        return this.setRowNum(-1);
    }

    @Override
    public boolean relative(int row) throws SQLException {
        return this.setRowNum(this.rowNum + row);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.first();
        this.previous();
    }

    @Override
    public void afterLast() throws SQLException {
        this.last();
        this.next();
    }

    @Override
    protected void handleClose(CompletionReason completionReason) {
        this.rows = Collections.emptyList();
    }

    @Override
    public int getRowNum() {
        return this.rowNum;
    }

    @Override
    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    @Override
    public boolean isBeforeFirst() {
        return this.rowNum < 1;
    }

    @Override
    public boolean isFirst() {
        return this.rowNum == 1;
    }

    @Override
    public boolean isLast() {
        return this.rowNum == this.rows.size();
    }

    @Override
    public boolean isAfterLast() {
        return this.rowNum > this.rows.size();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw FBCachedFetcher.calledUndecorated();
    }

    @Override
    public void insertRow(RowValue data) throws SQLException {
        throw FBCachedFetcher.calledUndecorated();
    }

    @Override
    public void updateRow(RowValue data) throws SQLException {
        throw FBCachedFetcher.calledUndecorated();
    }

    private static UnsupportedOperationException calledUndecorated() {
        return new UnsupportedOperationException("Implementation error: FBServerScrollFetcher should be decorated with FBUpdatableFetcher");
    }

    @Override
    public int currentPosition() {
        return this.rowNum;
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    protected LockCloseable withLock() {
        return this.lockAction.get();
    }

    private static final class RowListener
    implements StatementListener {
        private final List<RowValue> rows = new ArrayList<RowValue>();
        private boolean allRowsFetched = false;

        private RowListener() {
        }

        @Override
        public void receivedRow(FbStatement sender, RowValue rowValue) {
            this.rows.add(rowValue);
        }

        @Override
        public void afterLast(FbStatement sender) {
            this.allRowsFetched = true;
        }

        public boolean isAllRowsFetched() {
            return this.allRowsFetched;
        }

        public List<RowValue> getRows() {
            return this.rows;
        }

        public int size() {
            return this.rows.size();
        }
    }
}

