/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.parser;

import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.firebirdsql.jaybird.parser.BooleanLiteralToken;
import org.firebirdsql.jaybird.parser.ColonToken;
import org.firebirdsql.jaybird.parser.CommaToken;
import org.firebirdsql.jaybird.parser.CommentToken;
import org.firebirdsql.jaybird.parser.CurlyBraceClose;
import org.firebirdsql.jaybird.parser.CurlyBraceOpen;
import org.firebirdsql.jaybird.parser.GenericToken;
import org.firebirdsql.jaybird.parser.NullLiteralToken;
import org.firebirdsql.jaybird.parser.NumericLiteralToken;
import org.firebirdsql.jaybird.parser.OperatorToken;
import org.firebirdsql.jaybird.parser.ParenthesisClose;
import org.firebirdsql.jaybird.parser.ParenthesisOpen;
import org.firebirdsql.jaybird.parser.PeriodToken;
import org.firebirdsql.jaybird.parser.PositionalParameterToken;
import org.firebirdsql.jaybird.parser.QuotedIdentifierToken;
import org.firebirdsql.jaybird.parser.ReservedToken;
import org.firebirdsql.jaybird.parser.ReservedWords;
import org.firebirdsql.jaybird.parser.SemicolonToken;
import org.firebirdsql.jaybird.parser.SquareBracketClose;
import org.firebirdsql.jaybird.parser.SquareBracketOpen;
import org.firebirdsql.jaybird.parser.StringLiteralToken;
import org.firebirdsql.jaybird.parser.Token;
import org.firebirdsql.jaybird.parser.UnexpectedEndOfInputException;
import org.firebirdsql.jaybird.parser.WhitespaceToken;

public final class SqlTokenizer
implements Iterator<Token>,
AutoCloseable {
    private static final int EOF = -1;
    private final String src;
    private final ReservedWords reservedWords;
    private int pos = 0;
    private Token next;
    private static final char[][] UNKNOWN_SUFFIX = new char[][]{{'n', 'N'}, {'k', 'K'}, {'n', 'N'}, {'o', 'O'}, {'w', 'W'}, {'n', 'N'}};
    private static final char[][] TRUE_SUFFIX = new char[][]{{'r', 'R'}, {'u', 'U'}, {'e', 'E'}};
    private static final char[][] OR_SUFFIX = new char[][]{{'r', 'R'}};
    private static final char[][] NOT_SUFFIX = new char[][]{{'o', 'O'}, {'t', 'T'}};
    private static final char[][] NULL_SUFFIX = new char[][]{{'u', 'U'}, {'l', 'L'}, {'l', 'L'}};
    private static final char[][] LIKE_SUFFIX = new char[][]{{'i', 'I'}, {'k', 'K'}, {'e', 'E'}};
    private static final char[][] IS_SUFFIX = new char[][]{{'s', 'S'}};
    private static final char[][] FALSE_SUFFIX = new char[][]{{'a', 'A'}, {'l', 'L'}, {'s', 'S'}, {'e', 'E'}};
    private static final char[][] AND_SUFFIX = new char[][]{{'n', 'N'}, {'d', 'D'}};

    private SqlTokenizer(String src, ReservedWords reservedWords) {
        this.src = src;
        this.reservedWords = reservedWords;
    }

    public static Builder withReservedWords(ReservedWords reservedWords) {
        return new Builder(reservedWords);
    }

    @Override
    public boolean hasNext() {
        if (this.isClosed()) {
            return false;
        }
        if (this.next == null) {
            this.next = this.nextToken();
        }
        return this.next != null;
    }

    @Override
    public Token next() {
        Token nextToken = this.next;
        if (nextToken != null) {
            this.next = null;
        } else {
            nextToken = this.nextToken();
        }
        if (nextToken != null) {
            return nextToken;
        }
        throw new NoSuchElementException("No more tokens");
    }

    @Override
    public void close() {
        this.pos = -1;
    }

    private boolean isClosed() {
        return this.pos == -1;
    }

    private int read() {
        int length = this.src.length();
        if (this.pos < length) {
            return this.src.charAt(this.pos++);
        }
        this.pos = length;
        return -1;
    }

    private char requireChar() {
        int c = this.read();
        if (c == -1) {
            int originalPosition = this.pos;
            this.close();
            throw new UnexpectedEndOfInputException(String.format("Reached end of input at position %d while character was read", originalPosition));
        }
        return (char)c;
    }

    private void skip() {
        if (this.pos < this.src.length()) {
            ++this.pos;
        } else {
            throw new UnexpectedEndOfInputException(String.format("Reached end of input at position %d while skipping", this.pos));
        }
    }

    private void skip(int amount) {
        int length = this.src.length();
        if (this.pos + amount <= length) {
            this.pos += amount;
        } else {
            this.pos = length;
            throw new UnexpectedEndOfInputException(String.format("Reached end of input after position %d while skipping", this.pos));
        }
    }

    private void unread(int c) {
        if (c != -1) {
            --this.pos;
        }
    }

    private void unread(int[] chars, int lastIndex) {
        while (lastIndex >= 0) {
            this.unread(chars[lastIndex--]);
        }
    }

    private int peek() {
        return this.pos < this.src.length() ? (int)this.src.charAt(this.pos) : -1;
    }

    private Token nextToken() {
        if (this.isClosed()) {
            return null;
        }
        int start = this.pos;
        int c = this.read();
        return switch (c) {
            case -1 -> {
                this.close();
                yield null;
            }
            case 9, 10, 13, 32 -> this.readWhitespaceToken(start);
            case 40 -> new ParenthesisOpen(start);
            case 41 -> new ParenthesisClose(start);
            case 123 -> new CurlyBraceOpen(start);
            case 125 -> new CurlyBraceClose(start);
            case 91 -> new SquareBracketOpen(start);
            case 93 -> new SquareBracketClose(start);
            case 59 -> new SemicolonToken(start);
            case 44 -> new CommaToken(start);
            case 46 -> {
                if (SqlTokenizer.isDigit(this.peek())) {
                    yield this.readNumericLiteral(start, '.');
                }
                yield new PeriodToken(start);
            }
            case 42, 43, 61 -> new OperatorToken(start, this.src, start, this.pos);
            case 45 -> {
                if (this.peek() == 45) {
                    yield this.readLineComment(start);
                }
                yield new OperatorToken(start, this.src, start, this.pos);
            }
            case 47 -> {
                if (this.peek() == 42) {
                    yield this.readBlockComment(start);
                }
                yield new OperatorToken(start, this.src, start, this.pos);
            }
            case 60 -> {
                int cNext = this.read();
                switch (cNext) {
                    case 61: 
                    case 62: {
                        yield new OperatorToken(start, this.src, start, this.pos);
                    }
                }
                this.unread(cNext);
                yield new OperatorToken(start, this.src, start, this.pos);
            }
            case 62 -> {
                int cNext = this.read();
                if (cNext == 61) {
                    yield new OperatorToken(start, this.src, start, this.pos);
                }
                this.unread(cNext);
                yield new OperatorToken(start, this.src, start, this.pos);
            }
            case 33, 94, 126 -> {
                int cNext = this.read();
                switch (cNext) {
                    case 60: 
                    case 61: 
                    case 62: {
                        yield new OperatorToken(start, this.src, start, this.pos);
                    }
                }
                this.unread(cNext);
                yield new OperatorToken(start, this.src, start, this.pos);
            }
            case 124 -> {
                int cNext = this.read();
                if (cNext == 124) {
                    yield new OperatorToken(start, this.src, start, this.pos);
                }
                this.unread(cNext);
                yield new OperatorToken(start, this.src, start, this.pos);
            }
            case 48, 49, 50, 51, 52, 53, 54, 55, 56, 57 -> this.readNumericLiteral(start, (char)c);
            case 39 -> this.readStringLiteral(start);
            case 65, 97 -> {
                if (this.detectAnd()) {
                    yield this.readTokenByLength(start, 2, OperatorToken::new);
                }
                yield this.readOtherToken(start);
            }
            case 70, 102 -> {
                if (this.detectFalse()) {
                    yield this.readTokenByLength(start, 4, BooleanLiteralToken::falseToken);
                }
                yield this.readOtherToken(start);
            }
            case 73, 105 -> {
                if (this.detectIs()) {
                    yield this.readTokenByLength(start, 1, OperatorToken::new);
                }
                yield this.readOtherToken(start);
            }
            case 76, 108 -> {
                if (this.detectLike()) {
                    yield this.readTokenByLength(start, 3, OperatorToken::new);
                }
                yield this.readOtherToken(start);
            }
            case 78, 110 -> {
                if (this.detectNull()) {
                    yield this.readTokenByLength(start, 3, NullLiteralToken::new);
                }
                if (this.detectNot()) {
                    yield this.readTokenByLength(start, 2, OperatorToken::new);
                }
                yield this.readOtherToken(start);
            }
            case 79, 111 -> {
                if (this.detectOr()) {
                    yield this.readTokenByLength(start, 1, OperatorToken::new);
                }
                yield this.readOtherToken(start);
            }
            case 81, 113 -> {
                if (this.peek() == 39) {
                    yield this.readQStringLiteral(start);
                }
                yield this.readOtherToken(start);
            }
            case 84, 116 -> {
                if (this.detectTrue()) {
                    yield this.readTokenByLength(start, 3, BooleanLiteralToken::trueToken);
                }
                yield this.readOtherToken(start);
            }
            case 85, 117 -> {
                if (this.detectUnknown()) {
                    yield this.readTokenByLength(start, 6, BooleanLiteralToken::unknownToken);
                }
                yield this.readOtherToken(start);
            }
            case 88, 120 -> {
                int cNext = this.read();
                if (cNext == 39) {
                    yield this.readHexStringLiteral(start);
                }
                this.unread(cNext);
                yield this.readOtherToken(start);
            }
            case 63 -> new PositionalParameterToken(start);
            case 58 -> new ColonToken(start);
            case 34 -> this.readQuotedIdentifier(start);
            default -> this.readOtherToken(start);
        };
    }

    private boolean detectUnknown() {
        return this.detectToken(UNKNOWN_SUFFIX);
    }

    private boolean detectTrue() {
        return this.detectToken(TRUE_SUFFIX);
    }

    private boolean detectOr() {
        return this.detectToken(OR_SUFFIX);
    }

    private boolean detectNot() {
        return this.detectToken(NOT_SUFFIX);
    }

    private boolean detectNull() {
        return this.detectToken(NULL_SUFFIX);
    }

    private boolean detectLike() {
        return this.detectToken(LIKE_SUFFIX);
    }

    private boolean detectIs() {
        return this.detectToken(IS_SUFFIX);
    }

    private boolean detectFalse() {
        return this.detectToken(FALSE_SUFFIX);
    }

    private boolean detectAnd() {
        return this.detectToken(AND_SUFFIX);
    }

    private WhitespaceToken readWhitespaceToken(int start) {
        int c;
        while (SqlTokenizer.isWhitespace(c = this.read())) {
        }
        this.unread(c);
        return new WhitespaceToken(start, this.src, start, this.pos);
    }

    private CommentToken readLineComment(int start) {
        int c;
        this.skip();
        while (!SqlTokenizer.isEndOfLine(c = this.read())) {
        }
        this.unread(c);
        return new CommentToken(start, this.src, start, this.pos);
    }

    private CommentToken readBlockComment(int start) {
        this.skip();
        char c = this.requireChar();
        while (true) {
            if (c == '*' && this.peek() == 47) break;
            c = this.requireChar();
        }
        this.skip();
        return new CommentToken(start, this.src, start, this.pos);
    }

    private NumericLiteralToken readNumericLiteral(int start, char firstChar) {
        int c;
        boolean beforeDecimalSeparator;
        if (firstChar == '0' && this.peek() == 120) {
            return this.continueBinaryNumericLiteral(start);
        }
        boolean bl = beforeDecimalSeparator = firstChar != '.';
        while (SqlTokenizer.isDigit(c = this.read()) || c == 46 && beforeDecimalSeparator) {
            if (c != 46) continue;
            beforeDecimalSeparator = false;
        }
        if (c == 101 || c == 69) {
            c = this.read();
            if (c != 43 && c != 45 && !SqlTokenizer.isDigit(c)) {
                this.unread(c);
            }
            while (SqlTokenizer.isDigit(c = this.read())) {
            }
        }
        this.unread(c);
        return new NumericLiteralToken(start, this.src, start, this.pos);
    }

    private NumericLiteralToken continueBinaryNumericLiteral(int start) {
        int c;
        this.skip();
        while (SqlTokenizer.isHexDigit(c = this.read())) {
        }
        this.unread(c);
        return new NumericLiteralToken(start, this.src, start, this.pos);
    }

    private StringLiteralToken readHexStringLiteral(int start) {
        return this.readStringLiteral(start);
    }

    private StringLiteralToken readStringLiteral(int start) {
        char c;
        while ((c = this.requireChar()) != '\'' || this.peek() == 39) {
            if (c != '\'') continue;
            this.skip();
        }
        return new StringLiteralToken(start, this.src, start, this.pos);
    }

    private StringLiteralToken readQStringLiteral(int start) {
        this.skip();
        char startToken = this.requireChar();
        char endToken = this.computeCloseQuote(startToken);
        char c = this.requireChar();
        while (true) {
            if (c == endToken && this.peek() == 39) break;
            c = this.requireChar();
        }
        this.skip();
        return new StringLiteralToken(start, this.src, start, this.pos);
    }

    private char computeCloseQuote(char specialChar) {
        return switch (specialChar) {
            case '[' -> ']';
            case '(' -> ')';
            case '{' -> '}';
            case '<' -> '>';
            default -> specialChar;
        };
    }

    private QuotedIdentifierToken readQuotedIdentifier(int start) {
        char c;
        while ((c = this.requireChar()) != '\"' || this.peek() == 34) {
            if (c != '\"') continue;
            this.skip();
        }
        return new QuotedIdentifierToken(start, this.src, start, this.pos);
    }

    private Token readOtherToken(int start) {
        int c;
        while (!SqlTokenizer.isNormalTokenBoundary(c = this.read())) {
        }
        this.unread(c);
        int end = this.pos;
        CharBuffer tokenText = CharBuffer.wrap(this.src, start, end);
        if (this.reservedWords.isReservedWord(tokenText)) {
            return new ReservedToken(start, tokenText);
        }
        return new GenericToken(start, tokenText);
    }

    private <T extends Token> T readTokenByLength(int start, int remainingChars, TokenConstructor<T> tokenConstructor) {
        this.skip(remainingChars);
        return tokenConstructor.construct(start, this.src, start, this.pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detectToken(char[][] expectedChars) {
        int maxChars = expectedChars.length;
        int[] readChars = new int[maxChars + 1];
        int idx = -1;
        try {
            block4: while (++idx < maxChars) {
                int currentChar = readChars[idx] = this.read();
                for (char expectedChar : expectedChars[idx]) {
                    if (currentChar == expectedChar) continue block4;
                }
                boolean bl = false;
                return bl;
            }
            readChars[idx] = this.read();
            boolean bl = SqlTokenizer.isNormalTokenBoundary(readChars[idx]);
            return bl;
        }
        finally {
            this.unread(readChars, idx);
        }
    }

    private static boolean isNormalTokenBoundary(int c) {
        return switch (c) {
            case -1, 9, 10, 13, 32, 33, 34, 39, 40, 41, 42, 43, 45, 46, 47, 58, 59, 60, 61, 62, 63, 91, 93, 94, 123, 125, 126 -> true;
            default -> false;
        };
    }

    private static boolean isWhitespace(int c) {
        return switch (c) {
            case 9, 10, 13, 32 -> true;
            default -> false;
        };
    }

    private static boolean isEndOfLine(int c) {
        return switch (c) {
            case -1, 10, 13 -> true;
            default -> false;
        };
    }

    private static boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }

    private static boolean isHexDigit(int c) {
        return SqlTokenizer.isDigit(c) || 65 <= c && c <= 70 || 97 <= c && c <= 102;
    }

    public static final class Builder {
        private final ReservedWords reservedWords;

        private Builder(ReservedWords reservedWords) {
            this.reservedWords = reservedWords;
        }

        public SqlTokenizer of(String statementText) {
            return new SqlTokenizer(statementText, this.reservedWords);
        }
    }

    @FunctionalInterface
    private static interface TokenConstructor<T extends Token> {
        public T construct(int var1, CharSequence var2, int var3, int var4);
    }
}

