/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.InfoProcessor;

public final class ExecutionPlanProcessor
implements InfoProcessor<String> {
    private static final byte[] DESCRIBE_PLAN_INFO_ITEMS = new byte[]{22, 1};
    private static final byte[] DESCRIBE_EXPLAINED_PLAN_INFO_ITEMS = new byte[]{26, 1};
    private final FbStatement statement;

    public ExecutionPlanProcessor(FbStatement statement) {
        this.statement = statement;
    }

    @Override
    public String process(byte[] buffer) throws SQLException {
        if (buffer[0] == 1) {
            return "";
        }
        if (buffer[0] == 2 && (buffer = this.statement.getSqlInfo(this.getDescribePlanInfoItems(), this.statement.getMaxSqlInfoSize()))[0] == 2) {
            return null;
        }
        if (buffer[0] != 22 && buffer[0] != 26) {
            throw FbExceptionBuilder.forException(337248306).messageParameter("sql", "isc_info_sql_get_plan or isc_info_sql_explain_plan", "22 or 26", buffer[0]).toSQLException();
        }
        int len = VaxEncoding.iscVaxInteger2(buffer, 1);
        if (len > 1) {
            return this.statement.getDatabase().getEncoding().decodeFromCharset(buffer, 3, len).trim();
        }
        return "";
    }

    public byte[] getDescribePlanInfoItems() {
        return (byte[])DESCRIBE_PLAN_INFO_ITEMS.clone();
    }

    public byte[] getDescribeExplainedPlanInfoItems() {
        return (byte[])DESCRIBE_EXPLAINED_PLAN_INFO_ITEMS.clone();
    }
}

