/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import org.firebirdsql.gds.ConnectionParameterBuffer;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.ParameterBuffer;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.impl.DatabaseParameterBufferImp;
import org.firebirdsql.gds.impl.ServiceParameterBufferImp;
import org.firebirdsql.gds.ng.AbstractConnection;
import org.firebirdsql.gds.ng.IAttachProperties;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.IServiceProperties;
import org.firebirdsql.gds.ng.ParameterConverter;
import org.firebirdsql.jaybird.props.def.ConnectionProperty;
import org.firebirdsql.jaybird.props.def.ConnectionPropertyType;

public abstract class AbstractParameterConverter<D extends AbstractConnection<IConnectionProperties, ?>, S extends AbstractConnection<IServiceProperties, ?>>
implements ParameterConverter<D, S> {
    protected DatabaseParameterBuffer createDatabaseParameterBuffer(D connection) {
        return new DatabaseParameterBufferImp(DatabaseParameterBufferImp.DpbMetaData.DPB_VERSION_1, ((AbstractConnection)connection).getEncoding());
    }

    protected ServiceParameterBuffer createServiceParameterBuffer(S connection) {
        return new ServiceParameterBufferImp(ServiceParameterBufferImp.SpbMetaData.SPB_VERSION_2_ATTACH, ((AbstractConnection)connection).getEncoding());
    }

    @Override
    public final DatabaseParameterBuffer toDatabaseParameterBuffer(D connection) throws SQLException {
        DatabaseParameterBuffer dpb = this.createDatabaseParameterBuffer(connection);
        this.populateDefaultProperties(connection, dpb);
        return dpb;
    }

    protected void populateDefaultProperties(D connection, DatabaseParameterBuffer dpb) throws SQLException {
        dpb.addArgument(48, ((AbstractConnection)connection).getEncodingDefinition().getFirebirdEncodingName());
        IConnectionProperties props = (IConnectionProperties)((AbstractConnection)connection).getAttachProperties();
        this.populateFromProperties(props, dpb, ConnectionProperty::hasDpbItem, ConnectionProperty::dpbItem);
        this.populateAuthenticationProperties((AbstractConnection<?, ?>)connection, dpb);
        String sessionTimeZone = props.getSessionTimeZone();
        if (sessionTimeZone != null && !"server".equalsIgnoreCase(sessionTimeZone)) {
            dpb.addArgument(91, sessionTimeZone);
        }
    }

    protected abstract void populateAuthenticationProperties(AbstractConnection<?, ?> var1, ConnectionParameterBuffer var2) throws SQLException;

    @Override
    public final ServiceParameterBuffer toServiceParameterBuffer(S connection) throws SQLException {
        ServiceParameterBuffer spb = this.createServiceParameterBuffer(connection);
        this.populateDefaultProperties(connection, spb);
        return spb;
    }

    protected void populateDefaultProperties(S connection, ServiceParameterBuffer spb) throws SQLException {
        this.populateAuthenticationProperties((AbstractConnection<?, ?>)connection, spb);
        IServiceProperties props = (IServiceProperties)((AbstractConnection)connection).getAttachProperties();
        this.populateFromProperties(props, spb, ConnectionProperty::hasSpbItem, ConnectionProperty::spbItem);
        if (props.getRoleName() != null) {
            spb.addArgument(60, props.getRoleName());
        }
        if (props.getConnectTimeout() != -1) {
            spb.addArgument(57, props.getConnectTimeout());
        }
    }

    private void populateFromProperties(IAttachProperties<?> props, ParameterBuffer pb, Predicate<ConnectionProperty> hasPbItem, ToIntFunction<ConnectionProperty> getPbItem) {
        Map<ConnectionProperty, Object> connectionProperties = props.connectionPropertyValues();
        for (Map.Entry<ConnectionProperty, Object> entry : connectionProperties.entrySet()) {
            ConnectionProperty property = entry.getKey();
            Object propertyValue = entry.getValue();
            if (propertyValue == null || !hasPbItem.test(property)) continue;
            ConnectionPropertyType propertyType = property.type();
            int pbItem = getPbItem.applyAsInt(property);
            property.pbType().addValue(pb, pbItem, propertyValue, propertyType);
        }
    }
}

