/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.reader;

import java.io.IOException;
import java.io.Reader;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PBSolverHandle;
import org.sat4j.pb.reader.OPBReader2010;
import org.sat4j.pb.tools.LexicoDecoratorPB;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;

public class OPBReader2012
extends OPBReader2010 {
    private LexicoDecoratorPB lexico = null;
    private static final long serialVersionUID = 1L;

    public OPBReader2012(PBSolverHandle solver) {
        super(solver);
    }

    @Override
    protected void readMetaData() throws IOException, ParseFormatException {
        super.readMetaData();
        this.skipSpaces();
        char c = this.get();
        if (c != '*') {
            this.putback(c);
            return;
        }
        this.skipWhiteSpacesButNewline();
        c = this.get();
        if (c == '\n') {
            return;
        }
        this.putback(c);
        String s = this.readWord();
        if ("#aggregation=".equals(s)) {
            s = this.readWord();
            assert ("lexico".equals(s));
            PBSolverHandle handle = (PBSolverHandle)this.solver;
            this.lexico = new LexicoDecoratorPB((IPBSolver)handle.decorated());
            handle.changeDecorated(this.lexico);
        }
        if ("beginMapping".equals(s)) {
            this.startsMapping();
            this.get();
        } else {
            if (this.savedChar != '\n') {
                this.in.readLine();
            }
            this.get();
        }
    }

    private void skipWhiteSpacesButNewline() throws IOException {
        char c;
        while ((c = this.get()) == ' ') {
        }
        this.putback(c);
    }

    @Override
    protected void readObjective() throws IOException, ParseFormatException {
        super.readObjective();
        if (this.lexico != null && !this.lits.isEmpty()) {
            this.lexico.addCriterion(this.lits.clone(), this.coeffs.clone());
            this.lits.clear();
            this.coeffs.clear();
            this.readObjective();
        }
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        if (this.hasObjFunc && this.lexico == null) {
            return new ObjectiveFunction(this.getVars(), this.getCoeffs());
        }
        return null;
    }

    @Override
    public IProblem parseInstance(Reader input) throws ParseFormatException, ContradictionException {
        super.parseInstance(input);
        return ((PBSolverHandle)this.solver).decorated();
    }
}

