/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.IWatchPb;
import org.sat4j.specs.Constr;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.MandatoryLiteralListener;
import org.sat4j.specs.Propagatable;
import org.sat4j.specs.UnitPropagationListener;
import org.sat4j.specs.VarMapper;

public abstract class WatchPbLongCP
implements IWatchPb,
Propagatable,
Undoable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int LIMIT_SELECTION_SORT = 15;
    protected double activity;
    protected BigInteger[] bigCoefs;
    protected BigInteger bigDegree;
    protected long[] coefs;
    protected long sumcoefs;
    protected long degree;
    protected int[] lits;
    protected boolean learnt = false;
    protected ILits voc;

    WatchPbLongCP() {
    }

    WatchPbLongCP(IDataStructurePB mpb) {
        int size = mpb.size();
        this.lits = new int[size];
        this.bigCoefs = new BigInteger[size];
        mpb.buildConstraintFromMapPb(this.lits, this.bigCoefs);
        assert (mpb.isLongSufficient());
        this.coefs = WatchPbLongCP.toLong(this.bigCoefs);
        this.sumcoefs = 0L;
        for (long c : this.coefs) {
            this.sumcoefs += c;
        }
        this.bigDegree = mpb.getDegree();
        this.degree = this.bigDegree.longValue();
        this.learnt = true;
        this.sort();
    }

    WatchPbLongCP(int[] lits, BigInteger[] coefs, BigInteger degree, BigInteger sumCoefs) {
        this.lits = lits;
        this.coefs = WatchPbLongCP.toLong(coefs);
        this.degree = degree.longValue();
        this.bigCoefs = coefs;
        this.bigDegree = degree;
        this.sumcoefs = sumCoefs.longValue();
        this.sort();
    }

    public static long[] toLong(BigInteger[] bigValues) {
        long[] res = new long[bigValues.length];
        for (int i = 0; i < res.length; ++i) {
            assert (bigValues[i].bitLength() < 64);
            res[i] = bigValues[i].longValue();
            assert (res[i] >= 0L);
        }
        return res;
    }

    public boolean isAssertive(int dl) {
        int i;
        long slack = 0L;
        for (i = 0; i < this.lits.length; ++i) {
            if (this.coefs[i] <= 0L || this.voc.isFalsified(this.lits[i]) && this.voc.getLevel(this.lits[i]) < dl) continue;
            slack += this.coefs[i];
        }
        if ((slack -= this.degree) < 0L) {
            return false;
        }
        for (i = 0; i < this.lits.length; ++i) {
            if (this.coefs[i] <= 0L || !this.voc.isUnassigned(this.lits[i]) && this.voc.getLevel(this.lits[i]) < dl || slack >= this.coefs[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void calcReason(int p, IVecInt outReason) {
        long sumfalsified = 0L;
        int[] mlits = this.lits;
        for (int i = 0; i < mlits.length; ++i) {
            int q = mlits[i];
            if (!this.voc.isFalsified(q)) continue;
            outReason.push(q ^ 1);
            if (this.sumcoefs - (sumfalsified += this.coefs[i]) >= this.degree) continue;
            return;
        }
    }

    protected abstract void computeWatches() throws ContradictionException;

    protected abstract void computePropagation(UnitPropagationListener var1) throws ContradictionException;

    @Override
    public int get(int i) {
        return this.lits[i];
    }

    @Override
    public double getActivity() {
        return this.activity;
    }

    @Override
    public void incActivity(double claInc) {
        if (this.learnt) {
            this.activity += claInc;
        }
    }

    @Override
    public void setActivity(double d) {
        if (this.learnt) {
            this.activity = d;
        }
    }

    public long slackConstraint() {
        return this.computeLeftSide() - this.degree;
    }

    public long slackConstraint(long[] theCoefs, long theDegree) {
        return this.computeLeftSide(theCoefs) - theDegree;
    }

    public long computeLeftSide(long[] theCoefs) {
        long poss = 0L;
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            assert (theCoefs[i] >= 0L);
            poss += theCoefs[i];
        }
        return poss;
    }

    public BigInteger computeLeftSide(BigInteger[] theCoefs) {
        BigInteger poss = BigInteger.ZERO;
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            assert (theCoefs[i].signum() >= 0);
            poss = poss.add(theCoefs[i]);
        }
        return poss;
    }

    public long computeLeftSide() {
        return this.computeLeftSide(this.coefs);
    }

    protected boolean isSatisfiable() {
        return this.computeLeftSide() >= this.degree;
    }

    @Override
    public boolean learnt() {
        return this.learnt;
    }

    @Override
    public boolean locked() {
        for (int p : this.lits) {
            if (this.voc.getReason(p) != this) continue;
            return true;
        }
        return false;
    }

    protected static BigInteger ppcm(BigInteger a, BigInteger b) {
        return a.divide(a.gcd(b)).multiply(b);
    }

    @Override
    public void rescaleBy(double d) {
        this.activity *= d;
    }

    void selectionSort(int from, int to) {
        for (int i = from; i < to - 1; ++i) {
            int bestIndex = i;
            for (int j = i + 1; j < to; ++j) {
                if (this.coefs[j] <= this.coefs[bestIndex] && (this.coefs[j] != this.coefs[bestIndex] || this.lits[j] >= this.lits[bestIndex])) continue;
                bestIndex = j;
            }
            long tmp = this.coefs[i];
            this.coefs[i] = this.coefs[bestIndex];
            this.coefs[bestIndex] = tmp;
            BigInteger bigTmp = this.bigCoefs[i];
            this.bigCoefs[i] = this.bigCoefs[bestIndex];
            this.bigCoefs[bestIndex] = bigTmp;
            int tmp2 = this.lits[i];
            this.lits[i] = this.lits[bestIndex];
            this.lits[bestIndex] = tmp2;
            assert (this.coefs[i] >= 0L);
            assert (this.coefs[bestIndex] >= 0L);
        }
    }

    @Override
    public void setLearnt() {
        this.learnt = true;
    }

    @Override
    public boolean simplify() {
        long cumul = 0L;
        for (int i = 0; i < this.lits.length && cumul < this.degree; ++i) {
            if (!this.voc.isSatisfied(this.lits[i])) continue;
            cumul += this.coefs[i];
        }
        return cumul >= this.degree;
    }

    @Override
    public final int size() {
        return this.lits.length;
    }

    protected final void sort() {
        assert (this.lits != null);
        if (this.coefs.length > 0) {
            this.sort(0, this.size());
        }
    }

    protected final void sort(int from, int to) {
        int width = to - from;
        if (width <= 15) {
            this.selectionSort(from, to);
        } else {
            int i;
            block7: {
                assert (this.coefs.length == this.bigCoefs.length);
                int indPivot = width / 2 + from;
                long pivot = this.coefs[indPivot];
                int litPivot = this.lits[indPivot];
                i = from - 1;
                int j = to;
                while (true) {
                    if (this.coefs[++i] > pivot || this.coefs[i] == pivot && this.lits[i] < litPivot) {
                        continue;
                    }
                    while (pivot > this.coefs[--j] || this.coefs[j] == pivot && this.lits[j] > litPivot) {
                    }
                    if (i >= j) break block7;
                    long tmp = this.coefs[i];
                    this.coefs[i] = this.coefs[j];
                    this.coefs[j] = tmp;
                    BigInteger bigTmp = this.bigCoefs[i];
                    this.bigCoefs[i] = this.bigCoefs[j];
                    this.bigCoefs[j] = bigTmp;
                    int tmp2 = this.lits[i];
                    this.lits[i] = this.lits[j];
                    this.lits[j] = tmp2;
                    assert (this.coefs[i] >= 0L);
                    if (!$assertionsDisabled && this.coefs[j] < 0L) break;
                }
                throw new AssertionError();
            }
            this.sort(from, i);
            this.sort(i, to);
        }
    }

    public String toString() {
        StringBuilder stb = new StringBuilder();
        if (this.lits.length > 0) {
            for (int i = 0; i < this.lits.length; ++i) {
                stb.append(" + ");
                stb.append(this.coefs[i]);
                stb.append(".");
                stb.append(Lits.toString(this.lits[i]));
                stb.append("[");
                stb.append(this.voc.valueToString(this.lits[i]));
                stb.append("@");
                stb.append(this.voc.getLevel(this.lits[i]));
                stb.append("]");
                stb.append(" ");
            }
            stb.append(">= ");
            stb.append(this.degree);
        }
        return stb.toString();
    }

    @Override
    public void assertConstraint(UnitPropagationListener s) {
        long tmp = this.slackConstraint();
        for (int i = 0; i < this.lits.length; ++i) {
            if (!this.voc.isUnassigned(this.lits[i]) || tmp >= this.coefs[i]) continue;
            boolean ret = s.enqueue(this.lits[i], this);
            assert (ret);
        }
    }

    @Override
    public void assertConstraintIfNeeded(UnitPropagationListener s) {
        this.assertConstraint(s);
    }

    @Override
    public void register() {
        block3: {
            assert (this.learnt);
            try {
                this.computeWatches();
            }
            catch (ContradictionException e) {
                System.out.println(this);
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    @Override
    public int[] getLits() {
        int[] litsBis = new int[this.lits.length];
        System.arraycopy(this.lits, 0, litsBis, 0, this.lits.length);
        return litsBis;
    }

    @Override
    public ILits getVocabulary() {
        return this.voc;
    }

    @Override
    public IVecInt computeAnImpliedClause() {
        int index = this.coefs.length;
        for (long cptCoefs = 0L; cptCoefs > this.degree && index > 0; cptCoefs += this.coefs[--index]) {
        }
        if (index > 0 && index < this.size() / 2) {
            VecInt literals = new VecInt(index);
            for (int j = 0; j <= index; ++j) {
                literals.push(this.lits[j]);
            }
            return literals;
        }
        return null;
    }

    public boolean coefficientsEqualToOne() {
        return false;
    }

    public boolean equals(Object pb) {
        if (pb == null) {
            return false;
        }
        if (this.getClass() != pb.getClass()) {
            return false;
        }
        try {
            WatchPbLongCP wpb = (WatchPbLongCP)pb;
            if (this.degree != wpb.degree || this.coefs.length != wpb.coefs.length || this.lits.length != wpb.lits.length) {
                return false;
            }
            for (int ilit = 0; ilit < this.coefs.length; ++ilit) {
                int lit = this.lits[ilit];
                boolean ok = false;
                for (int ilit2 = 0; ilit2 < this.coefs.length; ++ilit2) {
                    if (wpb.lits[ilit2] != lit) continue;
                    if (wpb.coefs[ilit2] != this.coefs[ilit]) {
                        return false;
                    }
                    ok = true;
                    break;
                }
                if (ok) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        long sum = 0L;
        for (int p : this.lits) {
            sum += (long)p;
        }
        return (int)sum / this.lits.length;
    }

    @Override
    public void forwardActivity(double claInc) {
        if (!this.learnt) {
            this.activity += claInc;
        }
    }

    public long[] getLongCoefs() {
        long[] coefsBis = new long[this.coefs.length];
        System.arraycopy(this.coefs, 0, coefsBis, 0, this.coefs.length);
        return coefsBis;
    }

    @Override
    public BigInteger slackConstraint(BigInteger[] theCoefs, BigInteger theDegree) {
        return this.computeLeftSide(theCoefs).subtract(theDegree);
    }

    @Override
    public BigInteger getCoef(int i) {
        return this.bigCoefs[i];
    }

    @Override
    public BigInteger[] getCoefs() {
        BigInteger[] coefsBis = new BigInteger[this.coefs.length];
        System.arraycopy(this.bigCoefs, 0, coefsBis, 0, this.coefs.length);
        return coefsBis;
    }

    @Override
    public BigInteger getDegree() {
        return this.bigDegree;
    }

    @Override
    public boolean canBePropagatedMultipleTimes() {
        return true;
    }

    @Override
    public Constr toConstraint() {
        return this;
    }

    @Override
    public void calcReasonOnTheFly(int p, IVecInt trail, IVecInt outReason) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public boolean propagatePI(MandatoryLiteralListener l, int p) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public boolean canBeSatisfiedByCountingLiterals() {
        return false;
    }

    @Override
    public int requiredNumberOfSatisfiedLiterals() {
        throw new UnsupportedOperationException("Not applicable for PB constraints");
    }

    @Override
    public boolean isSatisfied() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public String toString(VarMapper mapper) {
        StringBuilder stb = new StringBuilder();
        if (this.lits.length > 0) {
            for (int i = 0; i < this.lits.length; ++i) {
                stb.append(" + ");
                stb.append(this.coefs[i]);
                stb.append(".");
                stb.append(mapper.map(LiteralsUtils.toDimacs(this.lits[i])));
                stb.append("[");
                stb.append(this.voc.valueToString(this.lits[i]));
                stb.append("@");
                stb.append(this.voc.getLevel(this.lits[i]));
                stb.append("]");
                stb.append(" ");
            }
            stb.append(">= ");
            stb.append(this.degree);
        }
        return stb.toString();
    }

    @Override
    public String dump() {
        StringBuilder stb = new StringBuilder();
        if (this.lits.length > 0) {
            for (int i = 0; i < this.lits.length; ++i) {
                stb.append("+");
                stb.append(this.coefs[i]);
                stb.append(" ");
                stb.append(LiteralsUtils.toOPB(this.lits[i]));
                stb.append(' ');
            }
            stb.append(">= ");
            stb.append(this.degree);
        }
        return stb.toString();
    }

    @Override
    public BigInteger getSumCoefs() {
        return BigInteger.valueOf(this.sumcoefs);
    }
}

