/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import net.xiaoyu233.fml.relaunch.Launch;

public class Utils {
    private static final char[] hexCode = "0123456789ABCDEF".toCharArray();
    private static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String calcMD5(File file) {
        String string;
        block9: {
            InputStream stream = Files.newInputStream(file.toPath(), StandardOpenOption.READ);
            try {
                int len;
                MessageDigest digest = MessageDigest.getInstance("MD5");
                byte[] buf = new byte[8192];
                while ((len = stream.read(buf)) > 0) {
                    digest.update(buf, 0, len);
                }
                string = Utils.toHexString(digest.digest());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NoSuchAlgorithmException var18) {
                    var18.printStackTrace();
                    return "";
                }
            }
            stream.close();
        }
        return string;
    }

    public static void extractFileFromJar(String path, @Nonnull File outFile, boolean override) throws IOException {
        if (outFile.exists() && !override) {
            return;
        }
        InputStream resourceAsStream = Utils.class.getResourceAsStream(path);
        outFile.mkdirs();
        FileOutputStream fos = new FileOutputStream(outFile);
        Utils.copy(resourceAsStream, fos);
        resourceAsStream.close();
        fos.close();
    }

    public static void copy(InputStream source, OutputStream target) throws IOException {
        int n;
        byte[] buf = new byte[8192];
        while ((n = source.read(buf)) > 0) {
            target.write(buf, 0, n);
        }
    }

    public static String getLibFileLocation() {
        return URLDecoder.decode(Launch.class.getProtectionDomain().getCodeSource().getLocation().getFile());
    }

    public static String getLibFileLocationRawURL() {
        return Launch.class.getProtectionDomain().getCodeSource().getLocation().getFile();
    }

    public static Map<String, InputStream> getAllFilesBelow(File dir, String ext) throws FileNotFoundException {
        File[] files1;
        HashMap<String, InputStream> files = new HashMap<String, InputStream>();
        if (dir.isDirectory() && (files1 = dir.listFiles()) != null) {
            for (File listFile : files1) {
                if (listFile.isFile() && listFile.getName().endsWith(ext)) {
                    files.put(listFile.getAbsolutePath().replace(dir.getAbsolutePath(), ""), new FileInputStream(listFile));
                    continue;
                }
                files.putAll(Utils.getAllFilesBelow(listFile, ext));
            }
        }
        return files;
    }

    public static Map<String, InputStream> getInternalClassesFromJar(Predicate<String> nameChecker) throws IOException {
        String libFile = Utils.getLibFileLocation();
        HashMap<String, InputStream> classNames = new HashMap<String, InputStream>();
        if (libFile.endsWith(".jar")) {
            JarFile jarFile = new JarFile(libFile);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!nameChecker.test(name)) continue;
                classNames.put(name, jarFile.getInputStream(entry));
            }
            return classNames;
        }
        return new HashMap<String, InputStream>();
    }

    public static Map<String, InputStream> getInternalClassesFromJar(String packageName) throws IOException {
        String libFile = Utils.getLibFileLocation();
        HashMap<String, InputStream> classNames = new HashMap<String, InputStream>();
        if (libFile.endsWith(".jar")) {
            JarFile jarFile = new JarFile(libFile);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.contains(packageName) || !name.endsWith(".class")) continue;
                classNames.put(name, jarFile.getInputStream(entry));
            }
            return classNames;
        }
        return Utils.getAllFilesBelow(new File(libFile + packageName), ".class");
    }

    public static byte[] readAllBytes(InputStream stream) throws IOException {
        int capacity = 16;
        byte[] buf = new byte[capacity];
        int nread = 0;
        while (true) {
            int n;
            if ((n = stream.read(buf, nread, capacity - nread)) > 0) {
                nread += n;
                continue;
            }
            if (n < 0 || (n = stream.read()) < 0) {
                return capacity == nread ? buf : Arrays.copyOf(buf, nread);
            }
            if (capacity <= 0x7FFFFFF7 - capacity) {
                capacity = Math.max(capacity << 1, 8192);
            } else {
                if (capacity == 0x7FFFFFF7) {
                    throw new OutOfMemoryError("Required array size too large");
                }
                capacity = 0x7FFFFFF7;
            }
            buf = Arrays.copyOf(buf, capacity);
            buf[nread++] = (byte)n;
        }
    }

    public static File createJar(String name) throws IOException {
        File jarFile = new File(new File(Utils.getLibFileLocation()).getParentFile(), name + ".jar");
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        JarOutputStream out = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), manifest);
        out.flush();
        out.close();
        return jarFile;
    }

    public static String toHexString(byte[] data) {
        StringBuilder r = new StringBuilder(data.length * 2);
        for (byte b : data) {
            r.append(hexCode[b >> 4 & 0xF]);
            r.append(hexCode[b & 0xF]);
        }
        return r.toString();
    }

    public static String getInternalNameFromDesc(String desc) {
        int startIndex = 1;
        char c;
        while ((c = desc.charAt(startIndex)) == '[' || c == 'L') {
            ++startIndex;
        }
        return desc.substring(startIndex, desc.length() - 1);
    }

    public static <R> R safeMake(DangerConsumer<R> maker, R defaultResult) {
        try {
            return maker.dangerGet();
        }
        catch (Throwable var3) {
            var3.printStackTrace();
            return defaultResult;
        }
    }

    public static void logInfoConsole(String msg) {
        System.out.println(format.format(new Date()) + " [INFO] " + msg);
    }

    public static boolean isJavaType(String name) {
        return !name.endsWith(";");
    }

    public static interface DangerConsumer<R> {
        public R dangerGet() throws Throwable;
    }
}

