/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.util;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.xiaoyu233.fml.FishModLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class PackageLoader {
    public static List<String> findClassByDirectory(String packageName, String packagePath, ClassLoader classLoader, Class<? extends Annotation> targetAnnotation) {
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return new ArrayList<String>(0);
        }
        File[] dirs = dir.listFiles();
        ArrayList<String> classes = new ArrayList<String>();
        for (File file : dirs) {
            if (file.isDirectory()) {
                classes.addAll(PackageLoader.findClassByDirectory(packageName + "." + file.getName(), file.getAbsolutePath(), classLoader, targetAnnotation));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = file.getName().substring(0, file.getName().length() - 6);
            classes.add(packageName + "." + className);
        }
        return classes;
    }

    public static List<String> findClassInJar(String packageName, URL url, Class<? extends Annotation> targetAnnotation) {
        ArrayList<String> classes = new ArrayList<String>();
        String packageDirName = packageName.replace('.', '/');
        try {
            URLConnection urlConnection = url.openConnection();
            JarFile jar = urlConnection instanceof JarURLConnection ? ((JarURLConnection)urlConnection).getJarFile() : new JarFile(URLDecoder.decode(url.getFile(), "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            block2: while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (!name.startsWith(packageDirName) || !name.endsWith(".class")) continue;
                String className = name.substring(0, name.length() - 6).replace('/', '.');
                if (targetAnnotation == null) continue;
                ClassReader reader = new ClassReader(jar.getInputStream(entry));
                ClassNode classNode = new ClassNode();
                reader.accept(classNode, 0);
                classNode.accept(new ClassVisitor(524288){});
                List<AnnotationNode> visibleAnnotations = classNode.invisibleAnnotations;
                if (visibleAnnotations == null || visibleAnnotations.isEmpty()) continue;
                for (AnnotationNode visibleAnnotation : visibleAnnotations) {
                    if (!visibleAnnotation.desc.equals(Type.getDescriptor(targetAnnotation))) continue;
                    classes.add(className);
                    continue block2;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static List<String> getClasses(String packageName, ClassLoader classLoader, Class<? extends Annotation> targetAnnotation) {
        ArrayList<String> classes = new ArrayList<String>();
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            if (dirs.hasMoreElements()) {
                while (dirs.hasMoreElements()) {
                    URL url = dirs.nextElement();
                    String protocol = url.getProtocol();
                    if ("file".equals(protocol)) {
                        String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                        classes.addAll(PackageLoader.findClassByDirectory(packageName, filePath, classLoader, targetAnnotation));
                        continue;
                    }
                    if (!"jar".equals(protocol)) continue;
                    classes.addAll(PackageLoader.findClassInJar(packageName, url, targetAnnotation));
                }
            } else {
                classes.addAll(PackageLoader.findClassInJar(packageName, FishModLoader.class.getProtectionDomain().getCodeSource().getLocation(), targetAnnotation));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }
}

