/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogProxy
extends PrintStream {
    public static final Logger logger = LogManager.getLogger("STDOUT");
    private final ProxyStyle style;

    public LogProxy(OutputStream out, ProxyStyle style) {
        super(out);
        this.style = style;
    }

    @Override
    public void print(String s) {
        this.style.loggerMsgConsumer.accept(logger, s);
    }

    @Override
    public void println(String x) {
        this.style.loggerMsgConsumer.accept(logger, x);
    }

    @Override
    public void println() {
        this.style.loggerMsgConsumer.accept(logger, "");
    }

    public static void proxySysout() {
        System.setOut(new LogProxy((OutputStream)System.out, ProxyStyle.OUT));
    }

    public static void proxySyserr() {
        System.setErr(new LogProxy((OutputStream)System.err, ProxyStyle.ERR));
    }

    private static enum ProxyStyle {
        OUT(Logger::info),
        ERR(Logger::error);

        private final BiConsumer<Logger, String> loggerMsgConsumer;

        private ProxyStyle(BiConsumer<Logger, String> loggerMsgConsumer) {
            this.loggerMsgConsumer = loggerMsgConsumer;
        }
    }
}

