/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.reload.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;

public class MojangAPI {
    private static final String UUID_URL = "https://api.mojang.com/profiles/minecraft";
    private static final String PROFILE_URL = "https://sessionserver.mojang.com/session/minecraft/profile/";
    private static final HashMap<String, MojangUUID> cacheUUID = new HashMap();
    private static final HashMap<String, MojangProfile> cacheProfile = new HashMap();

    public static String fixImageUrl(String imageUrl) {
        MojangProfile p;
        MojangUUID u;
        String playername;
        String[] coll2;
        String[] coll;
        String ret = imageUrl;
        if (imageUrl.startsWith("http://skins.minecraft.net/MinecraftSkins/")) {
            try {
                coll = imageUrl.split("/");
                coll2 = coll[coll.length - 1].split("\\.");
                playername = coll2[0];
                u = MojangAPI.getPlayerUUID(playername);
                if (u == null) {
                    return ret;
                }
                p = MojangAPI.getProfile(u.id);
                if (p == null) {
                    return ret;
                }
                ret = p.properties[0].valueBase64.textures.SKIN.metadata.model.equals("slim") ? MojangAPI.alexToSteveService(p.properties[0].valueBase64.textures.SKIN.url, playername) : p.properties[0].valueBase64.textures.SKIN.url;
                ret = ret.isEmpty() ? imageUrl : ret;
            }
            catch (Exception var9) {
                var9.printStackTrace();
                ret = imageUrl;
            }
        }
        if (imageUrl.startsWith("http://skins.minecraft.net/MinecraftCloaks/")) {
            try {
                coll = imageUrl.split("/");
                coll2 = coll[coll.length - 1].split("\\.");
                playername = coll2[0];
                u = MojangAPI.getPlayerUUID(playername);
                if (u == null) {
                    return ret;
                }
                p = MojangAPI.getProfile(u.id);
                if (p == null) {
                    return ret;
                }
                ret = p.properties[0].valueBase64.textures.CAPE.url;
                ret = ret.isEmpty() ? imageUrl : ret;
            }
            catch (Exception var8) {
                var8.printStackTrace();
                ret = imageUrl;
            }
        }
        return ret;
    }

    private static String alexToSteveService(String skinurl, String playername) {
        Object ret = skinurl;
        String sUrl = "http://www.lumylabs.com/lumyskinpatch/alextosteve.php?skinurl=" + skinurl + "&playername=" + playername + "&v=1.6.4";
        try {
            URL url = new URL(sUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            connection.connect();
            if (connection.getContentType().equals("image/png")) {
                ret = sUrl;
            }
        }
        catch (Exception var6) {
            var6.printStackTrace();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readUrlGET(String urlString) throws IOException, InterruptedException {
        String ret;
        HttpURLConnection con = null;
        try {
            String inputLine;
            URL url = new URL(urlString);
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.connect();
            if (con.getResponseCode() == 429) {
                Thread.sleep(30000L);
                con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("GET");
                con.connect();
            }
            StringBuilder response = new StringBuilder();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
                response.append('\n');
            }
            ret = response.toString();
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        con.disconnect();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readUrlPOST(String urlParameters) throws IOException {
        String ret;
        HttpURLConnection con = null;
        try {
            String inputLine;
            URL url = new URL(UUID_URL);
            con = (HttpURLConnection)url.openConnection();
            byte[] postData = urlParameters.getBytes(StandardCharsets.UTF_8);
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/json");
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.write(postData);
            StringBuilder response = new StringBuilder();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
                response.append('\n');
            }
            ret = response.toString();
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        con.disconnect();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MojangUUID getPlayerUUID(String playername) {
        if (cacheUUID.containsKey(playername)) {
            return cacheUUID.get(playername);
        }
        try {
            String json = MojangAPI.readUrlPOST("[\"" + playername + "\"]");
            Gson gson = new Gson();
            List res = (List)gson.fromJson(json, new TypeToken<List<MojangUUID>>(){}.getType());
            if (res.size() == 1) {
                cacheUUID.put(playername, (MojangUUID)res.get(0));
                return (MojangUUID)res.get(0);
            }
            cacheUUID.put(playername, null);
            return null;
        }
        catch (Exception var6) {
            var6.printStackTrace();
            HashMap<String, MojangUUID> var2 = cacheUUID;
            HashMap<String, MojangUUID> hashMap = cacheUUID;
            synchronized (hashMap) {
                if (cacheUUID.containsKey(playername)) {
                    return cacheUUID.get(playername);
                }
            }
            cacheUUID.put(playername, null);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MojangProfile getProfile(String uuid) {
        HashMap<String, MojangProfile> var1 = cacheProfile;
        HashMap<String, MojangProfile> hashMap = cacheProfile;
        synchronized (hashMap) {
            if (cacheProfile.containsKey(uuid)) {
                return cacheProfile.get(uuid);
            }
        }
        try {
            String json = MojangAPI.readUrlGET(PROFILE_URL + uuid);
            Gson gson = new Gson();
            MojangProfile res = (MojangProfile)gson.fromJson(json, MojangProfile.class);
            byte[] decoded = Base64.getDecoder().decode(res.properties[0].value);
            String decodedJson = new String(decoded, StandardCharsets.UTF_8);
            res.properties[0].valueBase64 = (PropertiesValueBase64)gson.fromJson(decodedJson, PropertiesValueBase64.class);
            HashMap<String, MojangProfile> hashMap2 = cacheProfile;
            synchronized (hashMap2) {
                cacheProfile.put(uuid, res);
            }
            return res;
        }
        catch (Exception var13) {
            var13.printStackTrace();
            HashMap<String, MojangProfile> var2 = cacheProfile;
            HashMap<String, MojangProfile> hashMap3 = cacheProfile;
            synchronized (hashMap3) {
                if (cacheProfile.containsKey(uuid)) {
                    return cacheProfile.get(uuid);
                }
            }
            var2 = cacheProfile;
            hashMap3 = cacheProfile;
            synchronized (hashMap3) {
                cacheProfile.put(uuid, null);
                return null;
            }
        }
    }

    public static class MojangUUID {
        public String id;
        public String name;
        public boolean legacy;
        public boolean demo;

        MojangUUID() {
        }
    }

    public static class MojangProfile {
        public String id;
        public String name;
        public Properties[] properties;

        MojangProfile() {
        }
    }

    public static class Properties {
        public String name;
        public String value;
        public String signature;
        public PropertiesValueBase64 valueBase64;

        Properties() {
        }
    }

    public static class PropertiesValueBase64 {
        long timestamp;
        String profileId;
        String profileName;
        boolean signatureRequired;
        Textures textures = new Textures();

        PropertiesValueBase64() {
        }
    }

    public static class Textures {
        Skin SKIN = new Skin();
        Cape CAPE = new Cape();
    }

    public static class Skin {
        String url = "";
        Metadata metadata = new Metadata();
    }

    public static class Metadata {
        String model = "";
    }

    public static class Cape {
        String url = "";
    }
}

