/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.reload.transform.registry;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.CraftingManager;
import net.minecraft.IRecipe;
import net.minecraft.ItemStack;
import net.minecraft.RecipesMITE;
import net.minecraft.ShapedRecipes;
import net.minecraft.ShapelessRecipes;
import net.xiaoyu233.fml.api.item.recipe.RecipesArgs;
import net.xiaoyu233.fml.reload.event.AchievementRegistryEvent;
import net.xiaoyu233.fml.reload.event.BlockRegistryEvent;
import net.xiaoyu233.fml.reload.event.ItemRegistryEvent;
import net.xiaoyu233.fml.reload.event.MITEEvents;
import net.xiaoyu233.fml.reload.event.RecipeModifyEvent;
import net.xiaoyu233.fml.reload.event.RecipeRegistryEvent;
import net.xiaoyu233.fml.reload.event.recipe.RecipeModifier;
import net.xiaoyu233.fml.reload.transform.util.CraftingManagerInvoker;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={CraftingManager.class})
public abstract class ItemBlockRecipeRegistryMixin {
    @Shadow
    public abstract ShapelessRecipes addShapelessRecipe(ItemStack var1, boolean var2, Object ... var3);

    @Shadow
    public abstract ShapedRecipes addRecipe(ItemStack var1, boolean var2, Object ... var3);

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/RecipesMITE;addCraftingRecipes(Lnet/minecraft/CraftingManager;)V"))
    private void injectRegisterRecipes(CraftingManager crafters) {
        MITEEvents.MITE_EVENT_BUS.post(new ItemRegistryEvent());
        MITEEvents.MITE_EVENT_BUS.post(new BlockRegistryEvent());
        MITEEvents.MITE_EVENT_BUS.post(new AchievementRegistryEvent());
        RecipeRegistryEvent event = new RecipeRegistryEvent();
        MITEEvents.MITE_EVENT_BUS.post(event);
        RecipesMITE.addCraftingRecipes((CraftingManager)crafters);
        for (RecipesArgs args : event.getShapedRecipes()) {
            ShapedRecipes shapedRecipes = ((CraftingManagerInvoker)crafters).addRecipe(args.result, args.include_in_lowest_crafting_difficulty_determination, args.inputs);
            args.getDifficulty().ifPresent(arg_0 -> ((ShapedRecipes)shapedRecipes).setDifficulty(arg_0));
            if (!args.isExtendsNBT()) continue;
            shapedRecipes.func_92100_c();
        }
        for (RecipesArgs args : event.getShapelessRecipe()) {
            ShapelessRecipes shapelessRecipes = ((CraftingManagerInvoker)crafters).addShapelessRecipe(args.result, args.include_in_lowest_crafting_difficulty_determination, args.inputs);
            args.getDifficulty().ifPresent(arg_0 -> ((ShapelessRecipes)shapelessRecipes).setDifficulty(arg_0));
            if (!args.isExtendsNBT()) continue;
            shapelessRecipes.propagateTagCompound();
        }
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Ljava/util/Collections;sort(Ljava/util/List;Ljava/util/Comparator;)V"))
    private void injectApplyModifier(List<IRecipe> list, Comparator<IRecipe> comparator) {
        RecipeModifyEvent event = new RecipeModifyEvent();
        MITEEvents.MITE_EVENT_BUS.post(event);
        for (IRecipe iRecipe : list) {
            RecipeModifier recipeModifier;
            ItemStack recipeOutput = iRecipe.getRecipeOutput();
            if (recipeOutput == null || (recipeModifier = event.getModifiers().get(new RecipeModifyEvent.ItemInfo(recipeOutput.getItem(), recipeOutput.stackSize, recipeOutput.getItemSubtype()))) == null) continue;
            list.remove(iRecipe);
            switch (recipeModifier.getType()) {
                case SHAPED: {
                    ShapedRecipes shapedRecipes = this.addRecipe(recipeModifier.getOutput(), recipeModifier.isIncludeInLowestCraftingDifficultyDetermination(), recipeModifier.toObjArgs());
                    recipeModifier.getCraftingDifficulty().ifPresent(arg_0 -> ((ShapedRecipes)shapedRecipes).setDifficulty(arg_0));
                    break;
                }
                case SHAPELESS: {
                    ShapelessRecipes shapelessRecipes = this.addShapelessRecipe(recipeModifier.getOutput(), recipeModifier.isIncludeInLowestCraftingDifficultyDetermination(), recipeModifier.toObjArgs());
                    recipeModifier.getCraftingDifficulty().ifPresent(arg_0 -> ((ShapelessRecipes)shapelessRecipes).setDifficulty(arg_0));
                    break;
                }
            }
        }
        Collections.sort(list, comparator);
    }
}

