/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.reload.transform.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.Enchantment;
import net.xiaoyu233.fml.reload.event.EnchantmentRegistryEvent;
import net.xiaoyu233.fml.reload.event.MITEEvents;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Enchantment.class})
public class EnchantmentRegisterMixin {
    @Shadow
    @Final
    @Mutable
    public static Enchantment[] enchantmentsBookList;

    @Inject(method={"<clinit>"}, at={@At(value="RETURN")})
    private static void injectRegister(CallbackInfo callbackInfo) {
        EnchantmentRegistryEvent event = new EnchantmentRegistryEvent();
        MITEEvents.MITE_EVENT_BUS.post(event);
        EnchantmentRegisterMixin.registerDynamicEnchantments(event.getEnchantmentList());
    }

    private static synchronized void registerDynamicEnchantments(List<Enchantment> newEnchantments) {
        if (newEnchantments == null || newEnchantments.isEmpty()) {
            return;
        }
        ArrayList<Enchantment> filtered = new ArrayList<Enchantment>(Enchantment.enchantmentsList.length);
        for (Enchantment enchantment : Enchantment.enchantmentsList) {
            if (enchantment == null) continue;
            filtered.add(enchantment);
        }
        enchantmentsBookList = filtered.toArray(new Enchantment[0]);
    }
}

