/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu233.fml.reload.transform.network;

import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.fabricmc.loader.impl.ModContainerImpl;
import net.fabricmc.loader.impl.metadata.LoaderModMetadata;
import net.minecraft.INetworkManager;
import net.minecraft.NetHandler;
import net.minecraft.NetLoginHandler;
import net.minecraft.Packet2ClientProtocol;
import net.minecraft.server.MinecraftServer;
import net.xiaoyu233.fml.FishModLoader;
import net.xiaoyu233.fml.config.Configs;
import net.xiaoyu233.fml.network.FMLClientProtocol;
import net.xiaoyu233.fml.util.RemoteModInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NetLoginHandler.class})
public abstract class PendingConnectionTransform
extends NetHandler {
    @Shadow
    private String clientUsername;
    @Shadow
    private MinecraftServer mcServer;

    @Shadow
    public abstract void raiseErrorAndDisconnect(String var1);

    @Inject(method={"handleClientProtocol"}, at={@At(value="HEAD")}, cancellable=true)
    public void handleClientProtocol(Packet2ClientProtocol par1Packet2ClientProtocol, CallbackInfo callbackInfo) throws VersionParsingException {
        FMLClientProtocol fmlClientProtocol = (FMLClientProtocol)par1Packet2ClientProtocol;
        List<RemoteModInfo> modInfos = fmlClientProtocol.getModInfos();
        if (modInfos != null && fmlClientProtocol.getSignatures().contains("FishModLoader")) {
            StringBuilder problems = new StringBuilder();
            Map<String, ModContainerImpl> serverMods = FishModLoader.getModsMapForLoginCheck();
            for (RemoteModInfo modInfo : modInfos) {
                String modid = modInfo.getModid();
                boolean clientOnly = !modInfo.canBeUsedAt(EnvType.SERVER);
                Version clientModVer = modInfo.getModVer();
                ModContainerImpl serverMod = serverMods.get(modid);
                if (serverMod != null) {
                    LoaderModMetadata serverModInfo = serverMod.getMetadata();
                    if (serverModInfo.getVersion().compareTo(clientModVer) > 0) {
                        problems.append("\u5ba2\u6237\u7aef\u6a21\u7ec4\u7248\u672c\u8fc7\u4f4e:").append(modid).append(" \u9700\u8981:").append(serverModInfo.getVersion()).append(" ,\u5f53\u524d;").append(clientModVer).append("\n");
                    } else if (serverModInfo.getVersion().compareTo(clientModVer) < 0) {
                        problems.append("\u5ba2\u6237\u7aef\u6a21\u7ec4\u7248\u672c\u8fc7\u9ad8:").append(modid).append(" \u9700\u8981:").append(serverModInfo.getVersion()).append(" ,\u5f53\u524d;").append(clientModVer).append("\n");
                    }
                    serverMods.remove(modid);
                    continue;
                }
                if (clientOnly) {
                    if (Configs.Server.ALLOW_CLIENT_MODS.get().booleanValue()) continue;
                    problems.append("\u670d\u52a1\u7aef\u4e0d\u5141\u8bb8\u6dfb\u52a0\u5ba2\u6237\u7aef\u6a21\u7ec4: ").append(modid).append("\n");
                    continue;
                }
                problems.append("\u5ba2\u6237\u7aef\u6a21\u7ec4\u8fc7\u591a: ").append(modid).append("\n");
            }
            if (!serverMods.isEmpty()) {
                for (ModContainerImpl value : serverMods.values()) {
                    if (value.getMetadata().getEnvironment() == ModEnvironment.CLIENT) continue;
                    LoaderModMetadata modMetadata = value.getMetadata();
                    problems.append("\u5ba2\u6237\u7aef\u7f3a\u5931\u6a21\u7ec4:").append(modMetadata.getId()).append("-").append(modMetadata.getVersion()).append("\n");
                }
            }
            if (!problems.isEmpty()) {
                this.raiseErrorAndDisconnect(problems.toString());
                callbackInfo.cancel();
            }
        }
    }

    @Shadow
    public INetworkManager getNetManager() {
        return null;
    }

    @Shadow
    public boolean isServerHandler() {
        return false;
    }
}

